/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.Application;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import resources.ResourceManager;

public class ToolUtils {
    public static final String TOOL_EXTENSION = ".tool";
    private static final Logger LOGGER = LogManager.getLogger(ToolUtils.class);
    private static final File USER_TOOLS_DIR = new File(ToolUtils.getApplicationToolDirPath());
    private static Set<ToolTemplate> allTools;
    private static Set<ToolTemplate> defaultTools;
    private static Set<ToolTemplate> extraTools;
    private static boolean allowTestTools;

    private ToolUtils() {
    }

    public static File getUserToolsDirectory() {
        return USER_TOOLS_DIR;
    }

    public static synchronized Set<ToolTemplate> getDefaultApplicationTools() {
        if (defaultTools != null) {
            return defaultTools;
        }
        HashSet<ToolTemplate> set = new HashSet<ToolTemplate>();
        Set toolNames = ResourceManager.getResourceNames((String)"defaultTools", (String)TOOL_EXTENSION);
        for (String toolName : toolNames) {
            ToolTemplate tool;
            if (ToolUtils.skipTool(toolName) || (tool = ToolUtils.readToolTemplate(toolName)) == null) continue;
            set.add(tool);
        }
        defaultTools = Collections.unmodifiableSet(set);
        return defaultTools;
    }

    public static synchronized Set<ToolTemplate> getExtraApplicationTools() {
        if (extraTools != null) {
            return extraTools;
        }
        HashSet<ToolTemplate> set = new HashSet<ToolTemplate>();
        Set extraToolsList = ResourceManager.getResourceNames((String)"extraTools", (String)TOOL_EXTENSION);
        for (String toolName : extraToolsList) {
            ToolTemplate tool = ToolUtils.readToolTemplate(toolName);
            if (tool == null) continue;
            set.add(tool);
        }
        extraTools = Collections.unmodifiableSet(set);
        return extraTools;
    }

    public static synchronized Set<ToolTemplate> getAllApplicationTools() {
        if (allTools != null) {
            return allTools;
        }
        HashSet<ToolTemplate> set = new HashSet<ToolTemplate>();
        set.addAll(ToolUtils.getDefaultApplicationTools());
        set.addAll(ToolUtils.getExtraApplicationTools());
        allTools = Collections.unmodifiableSet(set);
        return allTools;
    }

    public static Map<String, ToolTemplate> loadUserTools() {
        FilenameFilter filter = (dir, name) -> name.endsWith(".tcd");
        TreeMap<String, ToolTemplate> map = new TreeMap<String, ToolTemplate>();
        File[] toolFiles = USER_TOOLS_DIR.listFiles(filter);
        if (toolFiles != null) {
            for (File toolFile : toolFiles) {
                ToolTemplate template = ToolUtils.readToolTemplate(toolFile);
                if (template == null) continue;
                map.put(template.getName(), template);
            }
        }
        return map;
    }

    public static void removeInvalidPlugins(ToolTemplate template) {
        Object[] childArray;
        Element xmlRoot = template.saveToXml();
        Element toolElement = xmlRoot.getChild("TOOL");
        List children = toolElement.getChildren("PLUGIN");
        for (Object object : childArray = children.toArray()) {
            Element pluginElement = (Element)object;
            Attribute classAttribute = pluginElement.getAttribute("CLASS");
            String value = classAttribute.getValue();
            try {
                Class.forName(value);
            }
            catch (Throwable t) {
                LOGGER.info("Removing invalid plugin " + pluginElement.getAttributeValue("CLASS") + " from tool: " + template.getName());
                toolElement.removeContent((Content)pluginElement);
            }
        }
        template.restoreFromXml(xmlRoot);
    }

    public static void deleteTool(ToolTemplate template) {
        USER_TOOLS_DIR.mkdirs();
        String name = template.getName();
        File toolFile = ToolUtils.getToolFile(name);
        if (toolFile == null) {
            return;
        }
        toolFile.delete();
    }

    public static void renameToolTemplate(ToolTemplate toolTemplate, String newName) {
        ToolUtils.deleteTool(toolTemplate);
        toolTemplate.setName(newName);
        ToolUtils.writeToolTemplate(toolTemplate);
    }

    public static boolean writeToolTemplate(ToolTemplate template) {
        USER_TOOLS_DIR.mkdirs();
        String toolName = template.getName();
        File toolFile = ToolUtils.getToolFile(toolName);
        boolean status = false;
        try (FileOutputStream os = new FileOutputStream(toolFile);){
            Element element = template.saveToXml();
            Document doc = new Document(element);
            GenericXMLOutputter xmlout = new GenericXMLOutputter();
            xmlout.output(doc, (OutputStream)os);
            ((OutputStream)os).close();
            status = true;
        }
        catch (Exception e) {
            Msg.error((Object)LOGGER, (Object)("Error saving tool: " + toolName), (Throwable)e);
        }
        return status;
    }

    public static ToolTemplate readToolTemplate(File toolFile) {
        LOGGER.trace("Loading tool file {}", (Object)toolFile);
        GhidraToolTemplate toolTemplate = null;
        try (FileInputStream is = new FileInputStream(toolFile);){
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document doc = sax.build((InputStream)is);
            Element root = doc.getRootElement();
            toolTemplate = new GhidraToolTemplate(root, toolFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new AssertException("We should only be passed valid files. Cannot find: " + toolFile.getAbsolutePath());
        }
        catch (JDOMException e) {
            Msg.error((Object)LOGGER, (Object)("Error reading XML for " + String.valueOf(toolFile)), (Throwable)e);
        }
        catch (Exception e) {
            Msg.error((Object)LOGGER, (Object)("Can't read tool template for " + String.valueOf(toolFile)), (Throwable)e);
        }
        ToolUtils.updateFilenameToMatchToolName(toolFile, toolTemplate);
        return toolTemplate;
    }

    private static void updateFilenameToMatchToolName(File toolFile, GhidraToolTemplate toolTemplate) {
        if (toolTemplate == null) {
            return;
        }
        File correctToolFile = ToolUtils.getToolFile(toolTemplate.getName());
        if (correctToolFile.equals(toolFile)) {
            return;
        }
        if (ToolUtils.removeLastExtension(correctToolFile.getName()).equals(NamingUtilities.mangle((String)toolTemplate.getName()))) {
            return;
        }
        if (correctToolFile.getParentFile().equals(toolFile.getParentFile())) {
            toolFile.delete();
        }
        ToolUtils.writeToolTemplate(toolTemplate);
    }

    private static String removeLastExtension(String filename) {
        int period = filename.lastIndexOf(46);
        if (period == -1) {
            return filename;
        }
        return filename.substring(0, period);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ToolTemplate readToolTemplate(String resourceFileName) {
        try (InputStream is = ResourceManager.getResourceAsStream((String)resourceFileName);){
            if (is == null) {
                ToolTemplate toolTemplate = null;
                return toolTemplate;
            }
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document doc = sax.build(is);
            Element root = doc.getRootElement();
            GhidraToolTemplate ghidraToolTemplate = new GhidraToolTemplate(root, resourceFileName);
            return ghidraToolTemplate;
        }
        catch (JDOMException e) {
            Msg.error((Object)LOGGER, (Object)("Error reading XML for resource " + resourceFileName), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            Msg.error((Object)LOGGER, (Object)("Can't read tool template for resource " + resourceFileName), (Throwable)e);
        }
        return null;
    }

    private static boolean skipTool(String toolName) {
        if (allowTestTools) {
            return false;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)toolName, (CharSequence)"test")) {
            LOGGER.trace("Not adding default 'test' tool: " + toolName);
            return true;
        }
        return false;
    }

    public static String getUniqueToolName(ToolTemplate template) {
        Object name = template.getName();
        int n = 1;
        while (ToolUtils.getToolFile((String)name).exists()) {
            name = (String)name + "_" + n++;
        }
        return name;
    }

    private static File getToolFile(File dir, String toolName) {
        return new File(dir, NamingUtilities.mangle((String)toolName) + ".tcd");
    }

    public static File getToolFile(String name) {
        return ToolUtils.getToolFile(USER_TOOLS_DIR, name);
    }

    public static String getApplicationToolDirPath() {
        String userSettingsPath = Application.getUserSettingsDirectory().getAbsolutePath();
        return userSettingsPath + File.separatorChar + "tools";
    }

    static {
        allowTestTools = SystemUtilities.isInTestingMode();
    }
}

