#line 2 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- several percent faster when measuring
 * raw parsing (Flex + Bison).  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "parser/gramparse.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "port/pg_bitutils.h"
#include "mb/pg_wchar.h"

#line 46 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 67
#define YY_END_OF_BUFFER 68
struct yy_trans_info
	{
	flex_int16_t yy_verify;
	flex_int16_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[26094] =
    {
 {   0,   0 }, {   0,25838 }, {   0,   0 }, {   0,25836 }, {   1,6192 },
 {   2,6192 }, {   3,6192 }, {   4,6192 }, {   5,6192 }, {   6,6192 },
 {   7,6192 }, {   8,6192 }, {   9,6194 }, {  10,6199 }, {  11,6192 },
 {  12,6194 }, {  13,6194 }, {  14,6192 }, {  15,6192 }, {  16,6192 },
 {  17,6192 }, {  18,6192 }, {  19,6192 }, {  20,6192 }, {  21,6192 },
 {  22,6192 }, {  23,6192 }, {  24,6192 }, {  25,6192 }, {  26,6192 },
 {  27,6192 }, {  28,6192 }, {  29,6192 }, {  30,6192 }, {  31,6192 },
 {  32,6194 }, {  33,6201 }, {  34,6196 }, {  35,6241 }, {  36,6307 },
 {  37,6564 }, {  38,6241 }, {  39,6214 }, {  40,6216 }, {  41,6216 },
 {  42,6564 }, {  43,6564 }, {  44,6216 }, {  45,6575 }, {  46,6594 },

 {  47,6665 }, {  48,6697 }, {  49,6697 }, {  50,6697 }, {  51,6697 },
 {  52,6697 }, {  53,6697 }, {  54,6697 }, {  55,6697 }, {  56,6697 },
 {  57,6697 }, {  58,6219 }, {  59,6216 }, {  60,6954 }, {  61,6965 },
 {  62,7032 }, {  63,6241 }, {  64,6241 }, {  65,7064 }, {  66,7321 },
 {  67,7064 }, {  68,7064 }, {  69,7578 }, {  70,7064 }, {  71,7064 },
 {  72,7064 }, {  73,7064 }, {  74,7064 }, {  75,7064 }, {  76,7064 },
 {  77,7064 }, {  78,7835 }, {  79,7064 }, {  80,7064 }, {  81,7064 },
 {  82,7064 }, {  83,7064 }, {  84,7064 }, {  85,8092 }, {  86,7064 },
 {  87,7064 }, {  88,8349 }, {  89,7064 }, {  90,7064 }, {  91,6216 },
 {  92,6192 }, {  93,6216 }, {  94,6564 }, {  95,7064 }, {  96,6241 },

 {  97,7064 }, {  98,7321 }, {  99,7064 }, { 100,7064 }, { 101,7578 },
 { 102,7064 }, { 103,7064 }, { 104,7064 }, { 105,7064 }, { 106,7064 },
 { 107,7064 }, { 108,7064 }, { 109,7064 }, { 110,7835 }, { 111,7064 },
 { 112,7064 }, { 113,7064 }, { 114,7064 }, { 115,7064 }, { 116,7064 },
 { 117,8092 }, { 118,7064 }, { 119,7064 }, { 120,8349 }, { 121,7064 },
 { 122,7064 }, { 123,6192 }, { 124,6241 }, { 125,6192 }, { 126,6241 },
 { 127,6192 }, { 128,7064 }, { 129,7064 }, { 130,7064 }, { 131,7064 },
 { 132,7064 }, { 133,7064 }, { 134,7064 }, { 135,7064 }, { 136,7064 },
 { 137,7064 }, { 138,7064 }, { 139,7064 }, { 140,7064 }, { 141,7064 },
 { 142,7064 }, { 143,7064 }, { 144,7064 }, { 145,7064 }, { 146,7064 },

 { 147,7064 }, { 148,7064 }, { 149,7064 }, { 150,7064 }, { 151,7064 },
 { 152,7064 }, { 153,7064 }, { 154,7064 }, { 155,7064 }, { 156,7064 },
 { 157,7064 }, { 158,7064 }, { 159,7064 }, { 160,7064 }, { 161,7064 },
 { 162,7064 }, { 163,7064 }, { 164,7064 }, { 165,7064 }, { 166,7064 },
 { 167,7064 }, { 168,7064 }, { 169,7064 }, { 170,7064 }, { 171,7064 },
 { 172,7064 }, { 173,7064 }, { 174,7064 }, { 175,7064 }, { 176,7064 },
 { 177,7064 }, { 178,7064 }, { 179,7064 }, { 180,7064 }, { 181,7064 },
 { 182,7064 }, { 183,7064 }, { 184,7064 }, { 185,7064 }, { 186,7064 },
 { 187,7064 }, { 188,7064 }, { 189,7064 }, { 190,7064 }, { 191,7064 },
 { 192,7064 }, { 193,7064 }, { 194,7064 }, { 195,7064 }, { 196,7064 },

 { 197,7064 }, { 198,7064 }, { 199,7064 }, { 200,7064 }, { 201,7064 },
 { 202,7064 }, { 203,7064 }, { 204,7064 }, { 205,7064 }, { 206,7064 },
 { 207,7064 }, { 208,7064 }, { 209,7064 }, { 210,7064 }, { 211,7064 },
 { 212,7064 }, { 213,7064 }, { 214,7064 }, { 215,7064 }, { 216,7064 },
 { 217,7064 }, { 218,7064 }, { 219,7064 }, { 220,7064 }, { 221,7064 },
 { 222,7064 }, { 223,7064 }, { 224,7064 }, { 225,7064 }, { 226,7064 },
 { 227,7064 }, { 228,7064 }, { 229,7064 }, { 230,7064 }, { 231,7064 },
 { 232,7064 }, { 233,7064 }, { 234,7064 }, { 235,7064 }, { 236,7064 },
 { 237,7064 }, { 238,7064 }, { 239,7064 }, { 240,7064 }, { 241,7064 },
 { 242,7064 }, { 243,7064 }, { 244,7064 }, { 245,7064 }, { 246,7064 },

 { 247,7064 }, { 248,7064 }, { 249,7064 }, { 250,7064 }, { 251,7064 },
 { 252,7064 }, { 253,7064 }, { 254,7064 }, { 255,7064 }, { 256,6192 },
 {   0,   0 }, {   0,25578 }, {   1,5934 }, {   2,5934 }, {   3,5934 },
 {   4,5934 }, {   5,5934 }, {   6,5934 }, {   7,5934 }, {   8,5934 },
 {   9,5936 }, {  10,5941 }, {  11,5934 }, {  12,5936 }, {  13,5936 },
 {  14,5934 }, {  15,5934 }, {  16,5934 }, {  17,5934 }, {  18,5934 },
 {  19,5934 }, {  20,5934 }, {  21,5934 }, {  22,5934 }, {  23,5934 },
 {  24,5934 }, {  25,5934 }, {  26,5934 }, {  27,5934 }, {  28,5934 },
 {  29,5934 }, {  30,5934 }, {  31,5934 }, {  32,5936 }, {  33,5943 },
 {  34,5938 }, {  35,5983 }, {  36,6049 }, {  37,6306 }, {  38,5983 },

 {  39,5956 }, {  40,5958 }, {  41,5958 }, {  42,6306 }, {  43,6306 },
 {  44,5958 }, {  45,6317 }, {  46,6336 }, {  47,6407 }, {  48,6439 },
 {  49,6439 }, {  50,6439 }, {  51,6439 }, {  52,6439 }, {  53,6439 },
 {  54,6439 }, {  55,6439 }, {  56,6439 }, {  57,6439 }, {  58,5961 },
 {  59,5958 }, {  60,6696 }, {  61,6707 }, {  62,6774 }, {  63,5983 },
 {  64,5983 }, {  65,6806 }, {  66,7063 }, {  67,6806 }, {  68,6806 },
 {  69,7320 }, {  70,6806 }, {  71,6806 }, {  72,6806 }, {  73,6806 },
 {  74,6806 }, {  75,6806 }, {  76,6806 }, {  77,6806 }, {  78,7577 },
 {  79,6806 }, {  80,6806 }, {  81,6806 }, {  82,6806 }, {  83,6806 },
 {  84,6806 }, {  85,7834 }, {  86,6806 }, {  87,6806 }, {  88,8091 },

 {  89,6806 }, {  90,6806 }, {  91,5958 }, {  92,5934 }, {  93,5958 },
 {  94,6306 }, {  95,6806 }, {  96,5983 }, {  97,6806 }, {  98,7063 },
 {  99,6806 }, { 100,6806 }, { 101,7320 }, { 102,6806 }, { 103,6806 },
 { 104,6806 }, { 105,6806 }, { 106,6806 }, { 107,6806 }, { 108,6806 },
 { 109,6806 }, { 110,7577 }, { 111,6806 }, { 112,6806 }, { 113,6806 },
 { 114,6806 }, { 115,6806 }, { 116,6806 }, { 117,7834 }, { 118,6806 },
 { 119,6806 }, { 120,8091 }, { 121,6806 }, { 122,6806 }, { 123,5934 },
 { 124,5983 }, { 125,5934 }, { 126,5983 }, { 127,5934 }, { 128,6806 },
 { 129,6806 }, { 130,6806 }, { 131,6806 }, { 132,6806 }, { 133,6806 },
 { 134,6806 }, { 135,6806 }, { 136,6806 }, { 137,6806 }, { 138,6806 },

 { 139,6806 }, { 140,6806 }, { 141,6806 }, { 142,6806 }, { 143,6806 },
 { 144,6806 }, { 145,6806 }, { 146,6806 }, { 147,6806 }, { 148,6806 },
 { 149,6806 }, { 150,6806 }, { 151,6806 }, { 152,6806 }, { 153,6806 },
 { 154,6806 }, { 155,6806 }, { 156,6806 }, { 157,6806 }, { 158,6806 },
 { 159,6806 }, { 160,6806 }, { 161,6806 }, { 162,6806 }, { 163,6806 },
 { 164,6806 }, { 165,6806 }, { 166,6806 }, { 167,6806 }, { 168,6806 },
 { 169,6806 }, { 170,6806 }, { 171,6806 }, { 172,6806 }, { 173,6806 },
 { 174,6806 }, { 175,6806 }, { 176,6806 }, { 177,6806 }, { 178,6806 },
 { 179,6806 }, { 180,6806 }, { 181,6806 }, { 182,6806 }, { 183,6806 },
 { 184,6806 }, { 185,6806 }, { 186,6806 }, { 187,6806 }, { 188,6806 },

 { 189,6806 }, { 190,6806 }, { 191,6806 }, { 192,6806 }, { 193,6806 },
 { 194,6806 }, { 195,6806 }, { 196,6806 }, { 197,6806 }, { 198,6806 },
 { 199,6806 }, { 200,6806 }, { 201,6806 }, { 202,6806 }, { 203,6806 },
 { 204,6806 }, { 205,6806 }, { 206,6806 }, { 207,6806 }, { 208,6806 },
 { 209,6806 }, { 210,6806 }, { 211,6806 }, { 212,6806 }, { 213,6806 },
 { 214,6806 }, { 215,6806 }, { 216,6806 }, { 217,6806 }, { 218,6806 },
 { 219,6806 }, { 220,6806 }, { 221,6806 }, { 222,6806 }, { 223,6806 },
 { 224,6806 }, { 225,6806 }, { 226,6806 }, { 227,6806 }, { 228,6806 },
 { 229,6806 }, { 230,6806 }, { 231,6806 }, { 232,6806 }, { 233,6806 },
 { 234,6806 }, { 235,6806 }, { 236,6806 }, { 237,6806 }, { 238,6806 },

 { 239,6806 }, { 240,6806 }, { 241,6806 }, { 242,6806 }, { 243,6806 },
 { 244,6806 }, { 245,6806 }, { 246,6806 }, { 247,6806 }, { 248,6806 },
 { 249,6806 }, { 250,6806 }, { 251,6806 }, { 252,6806 }, { 253,6806 },
 { 254,6806 }, { 255,6806 }, { 256,5934 }, {   0,  10 }, {   0,25320 },
 {   1,8090 }, {   2,8090 }, {   3,8090 }, {   4,8090 }, {   5,8090 },
 {   6,8090 }, {   7,8090 }, {   8,8090 }, {   9,8090 }, {  10,8090 },
 {  11,8090 }, {  12,8090 }, {  13,8090 }, {  14,8090 }, {  15,8090 },
 {  16,8090 }, {  17,8090 }, {  18,8090 }, {  19,8090 }, {  20,8090 },
 {  21,8090 }, {  22,8090 }, {  23,8090 }, {  24,8090 }, {  25,8090 },
 {  26,8090 }, {  27,8090 }, {  28,8090 }, {  29,8090 }, {  30,8090 },

 {  31,8090 }, {  32,8090 }, {  33,8090 }, {  34,8090 }, {  35,8090 },
 {  36,8090 }, {  37,8090 }, {  38,8090 }, {  39,5705 }, {  40,8090 },
 {  41,8090 }, {  42,8090 }, {  43,8090 }, {  44,8090 }, {  45,8090 },
 {  46,8090 }, {  47,8090 }, {  48,8090 }, {  49,8090 }, {  50,8090 },
 {  51,8090 }, {  52,8090 }, {  53,8090 }, {  54,8090 }, {  55,8090 },
 {  56,8090 }, {  57,8090 }, {  58,8090 }, {  59,8090 }, {  60,8090 },
 {  61,8090 }, {  62,8090 }, {  63,8090 }, {  64,8090 }, {  65,8090 },
 {  66,8090 }, {  67,8090 }, {  68,8090 }, {  69,8090 }, {  70,8090 },
 {  71,8090 }, {  72,8090 }, {  73,8090 }, {  74,8090 }, {  75,8090 },
 {  76,8090 }, {  77,8090 }, {  78,8090 }, {  79,8090 }, {  80,8090 },

 {  81,8090 }, {  82,8090 }, {  83,8090 }, {  84,8090 }, {  85,8090 },
 {  86,8090 }, {  87,8090 }, {  88,8090 }, {  89,8090 }, {  90,8090 },
 {  91,8090 }, {  92,8090 }, {  93,8090 }, {  94,8090 }, {  95,8090 },
 {  96,8090 }, {  97,8090 }, {  98,8090 }, {  99,8090 }, { 100,8090 },
 { 101,8090 }, { 102,8090 }, { 103,8090 }, { 104,8090 }, { 105,8090 },
 { 106,8090 }, { 107,8090 }, { 108,8090 }, { 109,8090 }, { 110,8090 },
 { 111,8090 }, { 112,8090 }, { 113,8090 }, { 114,8090 }, { 115,8090 },
 { 116,8090 }, { 117,8090 }, { 118,8090 }, { 119,8090 }, { 120,8090 },
 { 121,8090 }, { 122,8090 }, { 123,8090 }, { 124,8090 }, { 125,8090 },
 { 126,8090 }, { 127,8090 }, { 128,8090 }, { 129,8090 }, { 130,8090 },

 { 131,8090 }, { 132,8090 }, { 133,8090 }, { 134,8090 }, { 135,8090 },
 { 136,8090 }, { 137,8090 }, { 138,8090 }, { 139,8090 }, { 140,8090 },
 { 141,8090 }, { 142,8090 }, { 143,8090 }, { 144,8090 }, { 145,8090 },
 { 146,8090 }, { 147,8090 }, { 148,8090 }, { 149,8090 }, { 150,8090 },
 { 151,8090 }, { 152,8090 }, { 153,8090 }, { 154,8090 }, { 155,8090 },
 { 156,8090 }, { 157,8090 }, { 158,8090 }, { 159,8090 }, { 160,8090 },
 { 161,8090 }, { 162,8090 }, { 163,8090 }, { 164,8090 }, { 165,8090 },
 { 166,8090 }, { 167,8090 }, { 168,8090 }, { 169,8090 }, { 170,8090 },
 { 171,8090 }, { 172,8090 }, { 173,8090 }, { 174,8090 }, { 175,8090 },
 { 176,8090 }, { 177,8090 }, { 178,8090 }, { 179,8090 }, { 180,8090 },

 { 181,8090 }, { 182,8090 }, { 183,8090 }, { 184,8090 }, { 185,8090 },
 { 186,8090 }, { 187,8090 }, { 188,8090 }, { 189,8090 }, { 190,8090 },
 { 191,8090 }, { 192,8090 }, { 193,8090 }, { 194,8090 }, { 195,8090 },
 { 196,8090 }, { 197,8090 }, { 198,8090 }, { 199,8090 }, { 200,8090 },
 { 201,8090 }, { 202,8090 }, { 203,8090 }, { 204,8090 }, { 205,8090 },
 { 206,8090 }, { 207,8090 }, { 208,8090 }, { 209,8090 }, { 210,8090 },
 { 211,8090 }, { 212,8090 }, { 213,8090 }, { 214,8090 }, { 215,8090 },
 { 216,8090 }, { 217,8090 }, { 218,8090 }, { 219,8090 }, { 220,8090 },
 { 221,8090 }, { 222,8090 }, { 223,8090 }, { 224,8090 }, { 225,8090 },
 { 226,8090 }, { 227,8090 }, { 228,8090 }, { 229,8090 }, { 230,8090 },

 { 231,8090 }, { 232,8090 }, { 233,8090 }, { 234,8090 }, { 235,8090 },
 { 236,8090 }, { 237,8090 }, { 238,8090 }, { 239,8090 }, { 240,8090 },
 { 241,8090 }, { 242,8090 }, { 243,8090 }, { 244,8090 }, { 245,8090 },
 { 246,8090 }, { 247,8090 }, { 248,8090 }, { 249,8090 }, { 250,8090 },
 { 251,8090 }, { 252,8090 }, { 253,8090 }, { 254,8090 }, { 255,8090 },
 { 256,8090 }, {   0,  10 }, {   0,25062 }, {   1,7832 }, {   2,7832 },
 {   3,7832 }, {   4,7832 }, {   5,7832 }, {   6,7832 }, {   7,7832 },
 {   8,7832 }, {   9,7832 }, {  10,7832 }, {  11,7832 }, {  12,7832 },
 {  13,7832 }, {  14,7832 }, {  15,7832 }, {  16,7832 }, {  17,7832 },
 {  18,7832 }, {  19,7832 }, {  20,7832 }, {  21,7832 }, {  22,7832 },

 {  23,7832 }, {  24,7832 }, {  25,7832 }, {  26,7832 }, {  27,7832 },
 {  28,7832 }, {  29,7832 }, {  30,7832 }, {  31,7832 }, {  32,7832 },
 {  33,7832 }, {  34,7832 }, {  35,7832 }, {  36,7832 }, {  37,7832 },
 {  38,7832 }, {  39,5447 }, {  40,7832 }, {  41,7832 }, {  42,7832 },
 {  43,7832 }, {  44,7832 }, {  45,7832 }, {  46,7832 }, {  47,7832 },
 {  48,7832 }, {  49,7832 }, {  50,7832 }, {  51,7832 }, {  52,7832 },
 {  53,7832 }, {  54,7832 }, {  55,7832 }, {  56,7832 }, {  57,7832 },
 {  58,7832 }, {  59,7832 }, {  60,7832 }, {  61,7832 }, {  62,7832 },
 {  63,7832 }, {  64,7832 }, {  65,7832 }, {  66,7832 }, {  67,7832 },
 {  68,7832 }, {  69,7832 }, {  70,7832 }, {  71,7832 }, {  72,7832 },

 {  73,7832 }, {  74,7832 }, {  75,7832 }, {  76,7832 }, {  77,7832 },
 {  78,7832 }, {  79,7832 }, {  80,7832 }, {  81,7832 }, {  82,7832 },
 {  83,7832 }, {  84,7832 }, {  85,7832 }, {  86,7832 }, {  87,7832 },
 {  88,7832 }, {  89,7832 }, {  90,7832 }, {  91,7832 }, {  92,7832 },
 {  93,7832 }, {  94,7832 }, {  95,7832 }, {  96,7832 }, {  97,7832 },
 {  98,7832 }, {  99,7832 }, { 100,7832 }, { 101,7832 }, { 102,7832 },
 { 103,7832 }, { 104,7832 }, { 105,7832 }, { 106,7832 }, { 107,7832 },
 { 108,7832 }, { 109,7832 }, { 110,7832 }, { 111,7832 }, { 112,7832 },
 { 113,7832 }, { 114,7832 }, { 115,7832 }, { 116,7832 }, { 117,7832 },
 { 118,7832 }, { 119,7832 }, { 120,7832 }, { 121,7832 }, { 122,7832 },

 { 123,7832 }, { 124,7832 }, { 125,7832 }, { 126,7832 }, { 127,7832 },
 { 128,7832 }, { 129,7832 }, { 130,7832 }, { 131,7832 }, { 132,7832 },
 { 133,7832 }, { 134,7832 }, { 135,7832 }, { 136,7832 }, { 137,7832 },
 { 138,7832 }, { 139,7832 }, { 140,7832 }, { 141,7832 }, { 142,7832 },
 { 143,7832 }, { 144,7832 }, { 145,7832 }, { 146,7832 }, { 147,7832 },
 { 148,7832 }, { 149,7832 }, { 150,7832 }, { 151,7832 }, { 152,7832 },
 { 153,7832 }, { 154,7832 }, { 155,7832 }, { 156,7832 }, { 157,7832 },
 { 158,7832 }, { 159,7832 }, { 160,7832 }, { 161,7832 }, { 162,7832 },
 { 163,7832 }, { 164,7832 }, { 165,7832 }, { 166,7832 }, { 167,7832 },
 { 168,7832 }, { 169,7832 }, { 170,7832 }, { 171,7832 }, { 172,7832 },

 { 173,7832 }, { 174,7832 }, { 175,7832 }, { 176,7832 }, { 177,7832 },
 { 178,7832 }, { 179,7832 }, { 180,7832 }, { 181,7832 }, { 182,7832 },
 { 183,7832 }, { 184,7832 }, { 185,7832 }, { 186,7832 }, { 187,7832 },
 { 188,7832 }, { 189,7832 }, { 190,7832 }, { 191,7832 }, { 192,7832 },
 { 193,7832 }, { 194,7832 }, { 195,7832 }, { 196,7832 }, { 197,7832 },
 { 198,7832 }, { 199,7832 }, { 200,7832 }, { 201,7832 }, { 202,7832 },
 { 203,7832 }, { 204,7832 }, { 205,7832 }, { 206,7832 }, { 207,7832 },
 { 208,7832 }, { 209,7832 }, { 210,7832 }, { 211,7832 }, { 212,7832 },
 { 213,7832 }, { 214,7832 }, { 215,7832 }, { 216,7832 }, { 217,7832 },
 { 218,7832 }, { 219,7832 }, { 220,7832 }, { 221,7832 }, { 222,7832 },

 { 223,7832 }, { 224,7832 }, { 225,7832 }, { 226,7832 }, { 227,7832 },
 { 228,7832 }, { 229,7832 }, { 230,7832 }, { 231,7832 }, { 232,7832 },
 { 233,7832 }, { 234,7832 }, { 235,7832 }, { 236,7832 }, { 237,7832 },
 { 238,7832 }, { 239,7832 }, { 240,7832 }, { 241,7832 }, { 242,7832 },
 { 243,7832 }, { 244,7832 }, { 245,7832 }, { 246,7832 }, { 247,7832 },
 { 248,7832 }, { 249,7832 }, { 250,7832 }, { 251,7832 }, { 252,7832 },
 { 253,7832 }, { 254,7832 }, { 255,7832 }, { 256,7832 }, {   0,   0 },
 {   0,24804 }, {   1,7832 }, {   2,7832 }, {   3,7832 }, {   4,7832 },
 {   5,7832 }, {   6,7832 }, {   7,7832 }, {   8,7832 }, {   9,7832 },
 {  10,7832 }, {  11,7832 }, {  12,7832 }, {  13,7832 }, {  14,7832 },

 {  15,7832 }, {  16,7832 }, {  17,7832 }, {  18,7832 }, {  19,7832 },
 {  20,7832 }, {  21,7832 }, {  22,7832 }, {  23,7832 }, {  24,7832 },
 {  25,7832 }, {  26,7832 }, {  27,7832 }, {  28,7832 }, {  29,7832 },
 {  30,7832 }, {  31,7832 }, {  32,7832 }, {  33,8090 }, {  34,7832 },
 {  35,8090 }, {  36,7832 }, {  37,8090 }, {  38,8090 }, {  39,7832 },
 {  40,7832 }, {  41,7832 }, {  42,5192 }, {  43,8090 }, {  44,7832 },
 {  45,8090 }, {  46,7832 }, {  47,5196 }, {  48,7832 }, {  49,7832 },
 {  50,7832 }, {  51,7832 }, {  52,7832 }, {  53,7832 }, {  54,7832 },
 {  55,7832 }, {  56,7832 }, {  57,7832 }, {  58,7832 }, {  59,7832 },
 {  60,8090 }, {  61,8090 }, {  62,8090 }, {  63,8090 }, {  64,8090 },

 {  65,7832 }, {  66,7832 }, {  67,7832 }, {  68,7832 }, {  69,7832 },
 {  70,7832 }, {  71,7832 }, {  72,7832 }, {  73,7832 }, {  74,7832 },
 {  75,7832 }, {  76,7832 }, {  77,7832 }, {  78,7832 }, {  79,7832 },
 {  80,7832 }, {  81,7832 }, {  82,7832 }, {  83,7832 }, {  84,7832 },
 {  85,7832 }, {  86,7832 }, {  87,7832 }, {  88,7832 }, {  89,7832 },
 {  90,7832 }, {  91,7832 }, {  92,7832 }, {  93,7832 }, {  94,8090 },
 {  95,7832 }, {  96,8090 }, {  97,7832 }, {  98,7832 }, {  99,7832 },
 { 100,7832 }, { 101,7832 }, { 102,7832 }, { 103,7832 }, { 104,7832 },
 { 105,7832 }, { 106,7832 }, { 107,7832 }, { 108,7832 }, { 109,7832 },
 { 110,7832 }, { 111,7832 }, { 112,7832 }, { 113,7832 }, { 114,7832 },

 { 115,7832 }, { 116,7832 }, { 117,7832 }, { 118,7832 }, { 119,7832 },
 { 120,7832 }, { 121,7832 }, { 122,7832 }, { 123,7832 }, { 124,8090 },
 { 125,7832 }, { 126,8090 }, { 127,7832 }, { 128,7832 }, { 129,7832 },
 { 130,7832 }, { 131,7832 }, { 132,7832 }, { 133,7832 }, { 134,7832 },
 { 135,7832 }, { 136,7832 }, { 137,7832 }, { 138,7832 }, { 139,7832 },
 { 140,7832 }, { 141,7832 }, { 142,7832 }, { 143,7832 }, { 144,7832 },
 { 145,7832 }, { 146,7832 }, { 147,7832 }, { 148,7832 }, { 149,7832 },
 { 150,7832 }, { 151,7832 }, { 152,7832 }, { 153,7832 }, { 154,7832 },
 { 155,7832 }, { 156,7832 }, { 157,7832 }, { 158,7832 }, { 159,7832 },
 { 160,7832 }, { 161,7832 }, { 162,7832 }, { 163,7832 }, { 164,7832 },

 { 165,7832 }, { 166,7832 }, { 167,7832 }, { 168,7832 }, { 169,7832 },
 { 170,7832 }, { 171,7832 }, { 172,7832 }, { 173,7832 }, { 174,7832 },
 { 175,7832 }, { 176,7832 }, { 177,7832 }, { 178,7832 }, { 179,7832 },
 { 180,7832 }, { 181,7832 }, { 182,7832 }, { 183,7832 }, { 184,7832 },
 { 185,7832 }, { 186,7832 }, { 187,7832 }, { 188,7832 }, { 189,7832 },
 { 190,7832 }, { 191,7832 }, { 192,7832 }, { 193,7832 }, { 194,7832 },
 { 195,7832 }, { 196,7832 }, { 197,7832 }, { 198,7832 }, { 199,7832 },
 { 200,7832 }, { 201,7832 }, { 202,7832 }, { 203,7832 }, { 204,7832 },
 { 205,7832 }, { 206,7832 }, { 207,7832 }, { 208,7832 }, { 209,7832 },
 { 210,7832 }, { 211,7832 }, { 212,7832 }, { 213,7832 }, { 214,7832 },

 { 215,7832 }, { 216,7832 }, { 217,7832 }, { 218,7832 }, { 219,7832 },
 { 220,7832 }, { 221,7832 }, { 222,7832 }, { 223,7832 }, { 224,7832 },
 { 225,7832 }, { 226,7832 }, { 227,7832 }, { 228,7832 }, { 229,7832 },
 { 230,7832 }, { 231,7832 }, { 232,7832 }, { 233,7832 }, { 234,7832 },
 { 235,7832 }, { 236,7832 }, { 237,7832 }, { 238,7832 }, { 239,7832 },
 { 240,7832 }, { 241,7832 }, { 242,7832 }, { 243,7832 }, { 244,7832 },
 { 245,7832 }, { 246,7832 }, { 247,7832 }, { 248,7832 }, { 249,7832 },
 { 250,7832 }, { 251,7832 }, { 252,7832 }, { 253,7832 }, { 254,7832 },
 { 255,7832 }, { 256,7832 }, {   0,   0 }, {   0,24546 }, {   1,7574 },
 {   2,7574 }, {   3,7574 }, {   4,7574 }, {   5,7574 }, {   6,7574 },

 {   7,7574 }, {   8,7574 }, {   9,7574 }, {  10,7574 }, {  11,7574 },
 {  12,7574 }, {  13,7574 }, {  14,7574 }, {  15,7574 }, {  16,7574 },
 {  17,7574 }, {  18,7574 }, {  19,7574 }, {  20,7574 }, {  21,7574 },
 {  22,7574 }, {  23,7574 }, {  24,7574 }, {  25,7574 }, {  26,7574 },
 {  27,7574 }, {  28,7574 }, {  29,7574 }, {  30,7574 }, {  31,7574 },
 {  32,7574 }, {  33,7832 }, {  34,7574 }, {  35,7832 }, {  36,7574 },
 {  37,7832 }, {  38,7832 }, {  39,7574 }, {  40,7574 }, {  41,7574 },
 {  42,4934 }, {  43,7832 }, {  44,7574 }, {  45,7832 }, {  46,7574 },
 {  47,4938 }, {  48,7574 }, {  49,7574 }, {  50,7574 }, {  51,7574 },
 {  52,7574 }, {  53,7574 }, {  54,7574 }, {  55,7574 }, {  56,7574 },

 {  57,7574 }, {  58,7574 }, {  59,7574 }, {  60,7832 }, {  61,7832 },
 {  62,7832 }, {  63,7832 }, {  64,7832 }, {  65,7574 }, {  66,7574 },
 {  67,7574 }, {  68,7574 }, {  69,7574 }, {  70,7574 }, {  71,7574 },
 {  72,7574 }, {  73,7574 }, {  74,7574 }, {  75,7574 }, {  76,7574 },
 {  77,7574 }, {  78,7574 }, {  79,7574 }, {  80,7574 }, {  81,7574 },
 {  82,7574 }, {  83,7574 }, {  84,7574 }, {  85,7574 }, {  86,7574 },
 {  87,7574 }, {  88,7574 }, {  89,7574 }, {  90,7574 }, {  91,7574 },
 {  92,7574 }, {  93,7574 }, {  94,7832 }, {  95,7574 }, {  96,7832 },
 {  97,7574 }, {  98,7574 }, {  99,7574 }, { 100,7574 }, { 101,7574 },
 { 102,7574 }, { 103,7574 }, { 104,7574 }, { 105,7574 }, { 106,7574 },

 { 107,7574 }, { 108,7574 }, { 109,7574 }, { 110,7574 }, { 111,7574 },
 { 112,7574 }, { 113,7574 }, { 114,7574 }, { 115,7574 }, { 116,7574 },
 { 117,7574 }, { 118,7574 }, { 119,7574 }, { 120,7574 }, { 121,7574 },
 { 122,7574 }, { 123,7574 }, { 124,7832 }, { 125,7574 }, { 126,7832 },
 { 127,7574 }, { 128,7574 }, { 129,7574 }, { 130,7574 }, { 131,7574 },
 { 132,7574 }, { 133,7574 }, { 134,7574 }, { 135,7574 }, { 136,7574 },
 { 137,7574 }, { 138,7574 }, { 139,7574 }, { 140,7574 }, { 141,7574 },
 { 142,7574 }, { 143,7574 }, { 144,7574 }, { 145,7574 }, { 146,7574 },
 { 147,7574 }, { 148,7574 }, { 149,7574 }, { 150,7574 }, { 151,7574 },
 { 152,7574 }, { 153,7574 }, { 154,7574 }, { 155,7574 }, { 156,7574 },

 { 157,7574 }, { 158,7574 }, { 159,7574 }, { 160,7574 }, { 161,7574 },
 { 162,7574 }, { 163,7574 }, { 164,7574 }, { 165,7574 }, { 166,7574 },
 { 167,7574 }, { 168,7574 }, { 169,7574 }, { 170,7574 }, { 171,7574 },
 { 172,7574 }, { 173,7574 }, { 174,7574 }, { 175,7574 }, { 176,7574 },
 { 177,7574 }, { 178,7574 }, { 179,7574 }, { 180,7574 }, { 181,7574 },
 { 182,7574 }, { 183,7574 }, { 184,7574 }, { 185,7574 }, { 186,7574 },
 { 187,7574 }, { 188,7574 }, { 189,7574 }, { 190,7574 }, { 191,7574 },
 { 192,7574 }, { 193,7574 }, { 194,7574 }, { 195,7574 }, { 196,7574 },
 { 197,7574 }, { 198,7574 }, { 199,7574 }, { 200,7574 }, { 201,7574 },
 { 202,7574 }, { 203,7574 }, { 204,7574 }, { 205,7574 }, { 206,7574 },

 { 207,7574 }, { 208,7574 }, { 209,7574 }, { 210,7574 }, { 211,7574 },
 { 212,7574 }, { 213,7574 }, { 214,7574 }, { 215,7574 }, { 216,7574 },
 { 217,7574 }, { 218,7574 }, { 219,7574 }, { 220,7574 }, { 221,7574 },
 { 222,7574 }, { 223,7574 }, { 224,7574 }, { 225,7574 }, { 226,7574 },
 { 227,7574 }, { 228,7574 }, { 229,7574 }, { 230,7574 }, { 231,7574 },
 { 232,7574 }, { 233,7574 }, { 234,7574 }, { 235,7574 }, { 236,7574 },
 { 237,7574 }, { 238,7574 }, { 239,7574 }, { 240,7574 }, { 241,7574 },
 { 242,7574 }, { 243,7574 }, { 244,7574 }, { 245,7574 }, { 246,7574 },
 { 247,7574 }, { 248,7574 }, { 249,7574 }, { 250,7574 }, { 251,7574 },
 { 252,7574 }, { 253,7574 }, { 254,7574 }, { 255,7574 }, { 256,7574 },

 {   0,   0 }, {   0,24288 }, {   1,7832 }, {   2,7832 }, {   3,7832 },
 {   4,7832 }, {   5,7832 }, {   6,7832 }, {   7,7832 }, {   8,7832 },
 {   9,7832 }, {  10,7832 }, {  11,7832 }, {  12,7832 }, {  13,7832 },
 {  14,7832 }, {  15,7832 }, {  16,7832 }, {  17,7832 }, {  18,7832 },
 {  19,7832 }, {  20,7832 }, {  21,7832 }, {  22,7832 }, {  23,7832 },
 {  24,7832 }, {  25,7832 }, {  26,7832 }, {  27,7832 }, {  28,7832 },
 {  29,7832 }, {  30,7832 }, {  31,7832 }, {  32,7832 }, {  33,7832 },
 {  34,4685 }, {  35,7832 }, {  36,7832 }, {  37,7832 }, {  38,7832 },
 {  39,7832 }, {  40,7832 }, {  41,7832 }, {  42,7832 }, {  43,7832 },
 {  44,7832 }, {  45,7832 }, {  46,7832 }, {  47,7832 }, {  48,7832 },

 {  49,7832 }, {  50,7832 }, {  51,7832 }, {  52,7832 }, {  53,7832 },
 {  54,7832 }, {  55,7832 }, {  56,7832 }, {  57,7832 }, {  58,7832 },
 {  59,7832 }, {  60,7832 }, {  61,7832 }, {  62,7832 }, {  63,7832 },
 {  64,7832 }, {  65,7832 }, {  66,7832 }, {  67,7832 }, {  68,7832 },
 {  69,7832 }, {  70,7832 }, {  71,7832 }, {  72,7832 }, {  73,7832 },
 {  74,7832 }, {  75,7832 }, {  76,7832 }, {  77,7832 }, {  78,7832 },
 {  79,7832 }, {  80,7832 }, {  81,7832 }, {  82,7832 }, {  83,7832 },
 {  84,7832 }, {  85,7832 }, {  86,7832 }, {  87,7832 }, {  88,7832 },
 {  89,7832 }, {  90,7832 }, {  91,7832 }, {  92,7832 }, {  93,7832 },
 {  94,7832 }, {  95,7832 }, {  96,7832 }, {  97,7832 }, {  98,7832 },

 {  99,7832 }, { 100,7832 }, { 101,7832 }, { 102,7832 }, { 103,7832 },
 { 104,7832 }, { 105,7832 }, { 106,7832 }, { 107,7832 }, { 108,7832 },
 { 109,7832 }, { 110,7832 }, { 111,7832 }, { 112,7832 }, { 113,7832 },
 { 114,7832 }, { 115,7832 }, { 116,7832 }, { 117,7832 }, { 118,7832 },
 { 119,7832 }, { 120,7832 }, { 121,7832 }, { 122,7832 }, { 123,7832 },
 { 124,7832 }, { 125,7832 }, { 126,7832 }, { 127,7832 }, { 128,7832 },
 { 129,7832 }, { 130,7832 }, { 131,7832 }, { 132,7832 }, { 133,7832 },
 { 134,7832 }, { 135,7832 }, { 136,7832 }, { 137,7832 }, { 138,7832 },
 { 139,7832 }, { 140,7832 }, { 141,7832 }, { 142,7832 }, { 143,7832 },
 { 144,7832 }, { 145,7832 }, { 146,7832 }, { 147,7832 }, { 148,7832 },

 { 149,7832 }, { 150,7832 }, { 151,7832 }, { 152,7832 }, { 153,7832 },
 { 154,7832 }, { 155,7832 }, { 156,7832 }, { 157,7832 }, { 158,7832 },
 { 159,7832 }, { 160,7832 }, { 161,7832 }, { 162,7832 }, { 163,7832 },
 { 164,7832 }, { 165,7832 }, { 166,7832 }, { 167,7832 }, { 168,7832 },
 { 169,7832 }, { 170,7832 }, { 171,7832 }, { 172,7832 }, { 173,7832 },
 { 174,7832 }, { 175,7832 }, { 176,7832 }, { 177,7832 }, { 178,7832 },
 { 179,7832 }, { 180,7832 }, { 181,7832 }, { 182,7832 }, { 183,7832 },
 { 184,7832 }, { 185,7832 }, { 186,7832 }, { 187,7832 }, { 188,7832 },
 { 189,7832 }, { 190,7832 }, { 191,7832 }, { 192,7832 }, { 193,7832 },
 { 194,7832 }, { 195,7832 }, { 196,7832 }, { 197,7832 }, { 198,7832 },

 { 199,7832 }, { 200,7832 }, { 201,7832 }, { 202,7832 }, { 203,7832 },
 { 204,7832 }, { 205,7832 }, { 206,7832 }, { 207,7832 }, { 208,7832 },
 { 209,7832 }, { 210,7832 }, { 211,7832 }, { 212,7832 }, { 213,7832 },
 { 214,7832 }, { 215,7832 }, { 216,7832 }, { 217,7832 }, { 218,7832 },
 { 219,7832 }, { 220,7832 }, { 221,7832 }, { 222,7832 }, { 223,7832 },
 { 224,7832 }, { 225,7832 }, { 226,7832 }, { 227,7832 }, { 228,7832 },
 { 229,7832 }, { 230,7832 }, { 231,7832 }, { 232,7832 }, { 233,7832 },
 { 234,7832 }, { 235,7832 }, { 236,7832 }, { 237,7832 }, { 238,7832 },
 { 239,7832 }, { 240,7832 }, { 241,7832 }, { 242,7832 }, { 243,7832 },
 { 244,7832 }, { 245,7832 }, { 246,7832 }, { 247,7832 }, { 248,7832 },

 { 249,7832 }, { 250,7832 }, { 251,7832 }, { 252,7832 }, { 253,7832 },
 { 254,7832 }, { 255,7832 }, { 256,7832 }, {   0,   0 }, {   0,24030 },
 {   1,7574 }, {   2,7574 }, {   3,7574 }, {   4,7574 }, {   5,7574 },
 {   6,7574 }, {   7,7574 }, {   8,7574 }, {   9,7574 }, {  10,7574 },
 {  11,7574 }, {  12,7574 }, {  13,7574 }, {  14,7574 }, {  15,7574 },
 {  16,7574 }, {  17,7574 }, {  18,7574 }, {  19,7574 }, {  20,7574 },
 {  21,7574 }, {  22,7574 }, {  23,7574 }, {  24,7574 }, {  25,7574 },
 {  26,7574 }, {  27,7574 }, {  28,7574 }, {  29,7574 }, {  30,7574 },
 {  31,7574 }, {  32,7574 }, {  33,7574 }, {  34,4427 }, {  35,7574 },
 {  36,7574 }, {  37,7574 }, {  38,7574 }, {  39,7574 }, {  40,7574 },

 {  41,7574 }, {  42,7574 }, {  43,7574 }, {  44,7574 }, {  45,7574 },
 {  46,7574 }, {  47,7574 }, {  48,7574 }, {  49,7574 }, {  50,7574 },
 {  51,7574 }, {  52,7574 }, {  53,7574 }, {  54,7574 }, {  55,7574 },
 {  56,7574 }, {  57,7574 }, {  58,7574 }, {  59,7574 }, {  60,7574 },
 {  61,7574 }, {  62,7574 }, {  63,7574 }, {  64,7574 }, {  65,7574 },
 {  66,7574 }, {  67,7574 }, {  68,7574 }, {  69,7574 }, {  70,7574 },
 {  71,7574 }, {  72,7574 }, {  73,7574 }, {  74,7574 }, {  75,7574 },
 {  76,7574 }, {  77,7574 }, {  78,7574 }, {  79,7574 }, {  80,7574 },
 {  81,7574 }, {  82,7574 }, {  83,7574 }, {  84,7574 }, {  85,7574 },
 {  86,7574 }, {  87,7574 }, {  88,7574 }, {  89,7574 }, {  90,7574 },

 {  91,7574 }, {  92,7574 }, {  93,7574 }, {  94,7574 }, {  95,7574 },
 {  96,7574 }, {  97,7574 }, {  98,7574 }, {  99,7574 }, { 100,7574 },
 { 101,7574 }, { 102,7574 }, { 103,7574 }, { 104,7574 }, { 105,7574 },
 { 106,7574 }, { 107,7574 }, { 108,7574 }, { 109,7574 }, { 110,7574 },
 { 111,7574 }, { 112,7574 }, { 113,7574 }, { 114,7574 }, { 115,7574 },
 { 116,7574 }, { 117,7574 }, { 118,7574 }, { 119,7574 }, { 120,7574 },
 { 121,7574 }, { 122,7574 }, { 123,7574 }, { 124,7574 }, { 125,7574 },
 { 126,7574 }, { 127,7574 }, { 128,7574 }, { 129,7574 }, { 130,7574 },
 { 131,7574 }, { 132,7574 }, { 133,7574 }, { 134,7574 }, { 135,7574 },
 { 136,7574 }, { 137,7574 }, { 138,7574 }, { 139,7574 }, { 140,7574 },

 { 141,7574 }, { 142,7574 }, { 143,7574 }, { 144,7574 }, { 145,7574 },
 { 146,7574 }, { 147,7574 }, { 148,7574 }, { 149,7574 }, { 150,7574 },
 { 151,7574 }, { 152,7574 }, { 153,7574 }, { 154,7574 }, { 155,7574 },
 { 156,7574 }, { 157,7574 }, { 158,7574 }, { 159,7574 }, { 160,7574 },
 { 161,7574 }, { 162,7574 }, { 163,7574 }, { 164,7574 }, { 165,7574 },
 { 166,7574 }, { 167,7574 }, { 168,7574 }, { 169,7574 }, { 170,7574 },
 { 171,7574 }, { 172,7574 }, { 173,7574 }, { 174,7574 }, { 175,7574 },
 { 176,7574 }, { 177,7574 }, { 178,7574 }, { 179,7574 }, { 180,7574 },
 { 181,7574 }, { 182,7574 }, { 183,7574 }, { 184,7574 }, { 185,7574 },
 { 186,7574 }, { 187,7574 }, { 188,7574 }, { 189,7574 }, { 190,7574 },

 { 191,7574 }, { 192,7574 }, { 193,7574 }, { 194,7574 }, { 195,7574 },
 { 196,7574 }, { 197,7574 }, { 198,7574 }, { 199,7574 }, { 200,7574 },
 { 201,7574 }, { 202,7574 }, { 203,7574 }, { 204,7574 }, { 205,7574 },
 { 206,7574 }, { 207,7574 }, { 208,7574 }, { 209,7574 }, { 210,7574 },
 { 211,7574 }, { 212,7574 }, { 213,7574 }, { 214,7574 }, { 215,7574 },
 { 216,7574 }, { 217,7574 }, { 218,7574 }, { 219,7574 }, { 220,7574 },
 { 221,7574 }, { 222,7574 }, { 223,7574 }, { 224,7574 }, { 225,7574 },
 { 226,7574 }, { 227,7574 }, { 228,7574 }, { 229,7574 }, { 230,7574 },
 { 231,7574 }, { 232,7574 }, { 233,7574 }, { 234,7574 }, { 235,7574 },
 { 236,7574 }, { 237,7574 }, { 238,7574 }, { 239,7574 }, { 240,7574 },

 { 241,7574 }, { 242,7574 }, { 243,7574 }, { 244,7574 }, { 245,7574 },
 { 246,7574 }, { 247,7574 }, { 248,7574 }, { 249,7574 }, { 250,7574 },
 { 251,7574 }, { 252,7574 }, { 253,7574 }, { 254,7574 }, { 255,7574 },
 { 256,7574 }, {   0,   9 }, {   0,23772 }, {   1,7574 }, {   2,7574 },
 {   3,7574 }, {   4,7574 }, {   5,7574 }, {   6,7574 }, {   7,7574 },
 {   8,7574 }, {   9,7574 }, {  10,7574 }, {  11,7574 }, {  12,7574 },
 {  13,7574 }, {  14,7574 }, {  15,7574 }, {  16,7574 }, {  17,7574 },
 {  18,7574 }, {  19,7574 }, {  20,7574 }, {  21,7574 }, {  22,7574 },
 {  23,7574 }, {  24,7574 }, {  25,7574 }, {  26,7574 }, {  27,7574 },
 {  28,7574 }, {  29,7574 }, {  30,7574 }, {  31,7574 }, {  32,7574 },

 {  33,7574 }, {  34,7574 }, {  35,7574 }, {  36,7574 }, {  37,7574 },
 {  38,7574 }, {  39,4157 }, {  40,7574 }, {  41,7574 }, {  42,7574 },
 {  43,7574 }, {  44,7574 }, {  45,7574 }, {  46,7574 }, {  47,7574 },
 {  48,7574 }, {  49,7574 }, {  50,7574 }, {  51,7574 }, {  52,7574 },
 {  53,7574 }, {  54,7574 }, {  55,7574 }, {  56,7574 }, {  57,7574 },
 {  58,7574 }, {  59,7574 }, {  60,7574 }, {  61,7574 }, {  62,7574 },
 {  63,7574 }, {  64,7574 }, {  65,7574 }, {  66,7574 }, {  67,7574 },
 {  68,7574 }, {  69,7574 }, {  70,7574 }, {  71,7574 }, {  72,7574 },
 {  73,7574 }, {  74,7574 }, {  75,7574 }, {  76,7574 }, {  77,7574 },
 {  78,7574 }, {  79,7574 }, {  80,7574 }, {  81,7574 }, {  82,7574 },

 {  83,7574 }, {  84,7574 }, {  85,7574 }, {  86,7574 }, {  87,7574 },
 {  88,7574 }, {  89,7574 }, {  90,7574 }, {  91,7574 }, {  92,7574 },
 {  93,7574 }, {  94,7574 }, {  95,7574 }, {  96,7574 }, {  97,7574 },
 {  98,7574 }, {  99,7574 }, { 100,7574 }, { 101,7574 }, { 102,7574 },
 { 103,7574 }, { 104,7574 }, { 105,7574 }, { 106,7574 }, { 107,7574 },
 { 108,7574 }, { 109,7574 }, { 110,7574 }, { 111,7574 }, { 112,7574 },
 { 113,7574 }, { 114,7574 }, { 115,7574 }, { 116,7574 }, { 117,7574 },
 { 118,7574 }, { 119,7574 }, { 120,7574 }, { 121,7574 }, { 122,7574 },
 { 123,7574 }, { 124,7574 }, { 125,7574 }, { 126,7574 }, { 127,7574 },
 { 128,7574 }, { 129,7574 }, { 130,7574 }, { 131,7574 }, { 132,7574 },

 { 133,7574 }, { 134,7574 }, { 135,7574 }, { 136,7574 }, { 137,7574 },
 { 138,7574 }, { 139,7574 }, { 140,7574 }, { 141,7574 }, { 142,7574 },
 { 143,7574 }, { 144,7574 }, { 145,7574 }, { 146,7574 }, { 147,7574 },
 { 148,7574 }, { 149,7574 }, { 150,7574 }, { 151,7574 }, { 152,7574 },
 { 153,7574 }, { 154,7574 }, { 155,7574 }, { 156,7574 }, { 157,7574 },
 { 158,7574 }, { 159,7574 }, { 160,7574 }, { 161,7574 }, { 162,7574 },
 { 163,7574 }, { 164,7574 }, { 165,7574 }, { 166,7574 }, { 167,7574 },
 { 168,7574 }, { 169,7574 }, { 170,7574 }, { 171,7574 }, { 172,7574 },
 { 173,7574 }, { 174,7574 }, { 175,7574 }, { 176,7574 }, { 177,7574 },
 { 178,7574 }, { 179,7574 }, { 180,7574 }, { 181,7574 }, { 182,7574 },

 { 183,7574 }, { 184,7574 }, { 185,7574 }, { 186,7574 }, { 187,7574 },
 { 188,7574 }, { 189,7574 }, { 190,7574 }, { 191,7574 }, { 192,7574 },
 { 193,7574 }, { 194,7574 }, { 195,7574 }, { 196,7574 }, { 197,7574 },
 { 198,7574 }, { 199,7574 }, { 200,7574 }, { 201,7574 }, { 202,7574 },
 { 203,7574 }, { 204,7574 }, { 205,7574 }, { 206,7574 }, { 207,7574 },
 { 208,7574 }, { 209,7574 }, { 210,7574 }, { 211,7574 }, { 212,7574 },
 { 213,7574 }, { 214,7574 }, { 215,7574 }, { 216,7574 }, { 217,7574 },
 { 218,7574 }, { 219,7574 }, { 220,7574 }, { 221,7574 }, { 222,7574 },
 { 223,7574 }, { 224,7574 }, { 225,7574 }, { 226,7574 }, { 227,7574 },
 { 228,7574 }, { 229,7574 }, { 230,7574 }, { 231,7574 }, { 232,7574 },

 { 233,7574 }, { 234,7574 }, { 235,7574 }, { 236,7574 }, { 237,7574 },
 { 238,7574 }, { 239,7574 }, { 240,7574 }, { 241,7574 }, { 242,7574 },
 { 243,7574 }, { 244,7574 }, { 245,7574 }, { 246,7574 }, { 247,7574 },
 { 248,7574 }, { 249,7574 }, { 250,7574 }, { 251,7574 }, { 252,7574 },
 { 253,7574 }, { 254,7574 }, { 255,7574 }, { 256,7574 }, {   0,   9 },
 {   0,23514 }, {   1,7316 }, {   2,7316 }, {   3,7316 }, {   4,7316 },
 {   5,7316 }, {   6,7316 }, {   7,7316 }, {   8,7316 }, {   9,7316 },
 {  10,7316 }, {  11,7316 }, {  12,7316 }, {  13,7316 }, {  14,7316 },
 {  15,7316 }, {  16,7316 }, {  17,7316 }, {  18,7316 }, {  19,7316 },
 {  20,7316 }, {  21,7316 }, {  22,7316 }, {  23,7316 }, {  24,7316 },

 {  25,7316 }, {  26,7316 }, {  27,7316 }, {  28,7316 }, {  29,7316 },
 {  30,7316 }, {  31,7316 }, {  32,7316 }, {  33,7316 }, {  34,7316 },
 {  35,7316 }, {  36,7316 }, {  37,7316 }, {  38,7316 }, {  39,3899 },
 {  40,7316 }, {  41,7316 }, {  42,7316 }, {  43,7316 }, {  44,7316 },
 {  45,7316 }, {  46,7316 }, {  47,7316 }, {  48,7316 }, {  49,7316 },
 {  50,7316 }, {  51,7316 }, {  52,7316 }, {  53,7316 }, {  54,7316 },
 {  55,7316 }, {  56,7316 }, {  57,7316 }, {  58,7316 }, {  59,7316 },
 {  60,7316 }, {  61,7316 }, {  62,7316 }, {  63,7316 }, {  64,7316 },
 {  65,7316 }, {  66,7316 }, {  67,7316 }, {  68,7316 }, {  69,7316 },
 {  70,7316 }, {  71,7316 }, {  72,7316 }, {  73,7316 }, {  74,7316 },

 {  75,7316 }, {  76,7316 }, {  77,7316 }, {  78,7316 }, {  79,7316 },
 {  80,7316 }, {  81,7316 }, {  82,7316 }, {  83,7316 }, {  84,7316 },
 {  85,7316 }, {  86,7316 }, {  87,7316 }, {  88,7316 }, {  89,7316 },
 {  90,7316 }, {  91,7316 }, {  92,7316 }, {  93,7316 }, {  94,7316 },
 {  95,7316 }, {  96,7316 }, {  97,7316 }, {  98,7316 }, {  99,7316 },
 { 100,7316 }, { 101,7316 }, { 102,7316 }, { 103,7316 }, { 104,7316 },
 { 105,7316 }, { 106,7316 }, { 107,7316 }, { 108,7316 }, { 109,7316 },
 { 110,7316 }, { 111,7316 }, { 112,7316 }, { 113,7316 }, { 114,7316 },
 { 115,7316 }, { 116,7316 }, { 117,7316 }, { 118,7316 }, { 119,7316 },
 { 120,7316 }, { 121,7316 }, { 122,7316 }, { 123,7316 }, { 124,7316 },

 { 125,7316 }, { 126,7316 }, { 127,7316 }, { 128,7316 }, { 129,7316 },
 { 130,7316 }, { 131,7316 }, { 132,7316 }, { 133,7316 }, { 134,7316 },
 { 135,7316 }, { 136,7316 }, { 137,7316 }, { 138,7316 }, { 139,7316 },
 { 140,7316 }, { 141,7316 }, { 142,7316 }, { 143,7316 }, { 144,7316 },
 { 145,7316 }, { 146,7316 }, { 147,7316 }, { 148,7316 }, { 149,7316 },
 { 150,7316 }, { 151,7316 }, { 152,7316 }, { 153,7316 }, { 154,7316 },
 { 155,7316 }, { 156,7316 }, { 157,7316 }, { 158,7316 }, { 159,7316 },
 { 160,7316 }, { 161,7316 }, { 162,7316 }, { 163,7316 }, { 164,7316 },
 { 165,7316 }, { 166,7316 }, { 167,7316 }, { 168,7316 }, { 169,7316 },
 { 170,7316 }, { 171,7316 }, { 172,7316 }, { 173,7316 }, { 174,7316 },

 { 175,7316 }, { 176,7316 }, { 177,7316 }, { 178,7316 }, { 179,7316 },
 { 180,7316 }, { 181,7316 }, { 182,7316 }, { 183,7316 }, { 184,7316 },
 { 185,7316 }, { 186,7316 }, { 187,7316 }, { 188,7316 }, { 189,7316 },
 { 190,7316 }, { 191,7316 }, { 192,7316 }, { 193,7316 }, { 194,7316 },
 { 195,7316 }, { 196,7316 }, { 197,7316 }, { 198,7316 }, { 199,7316 },
 { 200,7316 }, { 201,7316 }, { 202,7316 }, { 203,7316 }, { 204,7316 },
 { 205,7316 }, { 206,7316 }, { 207,7316 }, { 208,7316 }, { 209,7316 },
 { 210,7316 }, { 211,7316 }, { 212,7316 }, { 213,7316 }, { 214,7316 },
 { 215,7316 }, { 216,7316 }, { 217,7316 }, { 218,7316 }, { 219,7316 },
 { 220,7316 }, { 221,7316 }, { 222,7316 }, { 223,7316 }, { 224,7316 },

 { 225,7316 }, { 226,7316 }, { 227,7316 }, { 228,7316 }, { 229,7316 },
 { 230,7316 }, { 231,7316 }, { 232,7316 }, { 233,7316 }, { 234,7316 },
 { 235,7316 }, { 236,7316 }, { 237,7316 }, { 238,7316 }, { 239,7316 },
 { 240,7316 }, { 241,7316 }, { 242,7316 }, { 243,7316 }, { 244,7316 },
 { 245,7316 }, { 246,7316 }, { 247,7316 }, { 248,7316 }, { 249,7316 },
 { 250,7316 }, { 251,7316 }, { 252,7316 }, { 253,7316 }, { 254,7316 },
 { 255,7316 }, { 256,7316 }, {   0,   0 }, {   0,23256 }, {   1,7316 },
 {   2,7316 }, {   3,7316 }, {   4,7316 }, {   5,7316 }, {   6,7316 },
 {   7,7316 }, {   8,7316 }, {   9,7316 }, {  10,7316 }, {  11,7316 },
 {  12,7316 }, {  13,7316 }, {  14,7316 }, {  15,7316 }, {  16,7316 },

 {  17,7316 }, {  18,7316 }, {  19,7316 }, {  20,7316 }, {  21,7316 },
 {  22,7316 }, {  23,7316 }, {  24,7316 }, {  25,7316 }, {  26,7316 },
 {  27,7316 }, {  28,7316 }, {  29,7316 }, {  30,7316 }, {  31,7316 },
 {  32,7316 }, {  33,7316 }, {  34,7316 }, {  35,7316 }, {  36,7316 },
 {  37,7316 }, {  38,7316 }, {  39,3670 }, {  40,7316 }, {  41,7316 },
 {  42,7316 }, {  43,7316 }, {  44,7316 }, {  45,7316 }, {  46,7316 },
 {  47,7316 }, {  48,7316 }, {  49,7316 }, {  50,7316 }, {  51,7316 },
 {  52,7316 }, {  53,7316 }, {  54,7316 }, {  55,7316 }, {  56,7316 },
 {  57,7316 }, {  58,7316 }, {  59,7316 }, {  60,7316 }, {  61,7316 },
 {  62,7316 }, {  63,7316 }, {  64,7316 }, {  65,7316 }, {  66,7316 },

 {  67,7316 }, {  68,7316 }, {  69,7316 }, {  70,7316 }, {  71,7316 },
 {  72,7316 }, {  73,7316 }, {  74,7316 }, {  75,7316 }, {  76,7316 },
 {  77,7316 }, {  78,7316 }, {  79,7316 }, {  80,7316 }, {  81,7316 },
 {  82,7316 }, {  83,7316 }, {  84,7316 }, {  85,7316 }, {  86,7316 },
 {  87,7316 }, {  88,7316 }, {  89,7316 }, {  90,7316 }, {  91,7316 },
 {  92,7316 }, {  93,7316 }, {  94,7316 }, {  95,7316 }, {  96,7316 },
 {  97,7316 }, {  98,7316 }, {  99,7316 }, { 100,7316 }, { 101,7316 },
 { 102,7316 }, { 103,7316 }, { 104,7316 }, { 105,7316 }, { 106,7316 },
 { 107,7316 }, { 108,7316 }, { 109,7316 }, { 110,7316 }, { 111,7316 },
 { 112,7316 }, { 113,7316 }, { 114,7316 }, { 115,7316 }, { 116,7316 },

 { 117,7316 }, { 118,7316 }, { 119,7316 }, { 120,7316 }, { 121,7316 },
 { 122,7316 }, { 123,7316 }, { 124,7316 }, { 125,7316 }, { 126,7316 },
 { 127,7316 }, { 128,7316 }, { 129,7316 }, { 130,7316 }, { 131,7316 },
 { 132,7316 }, { 133,7316 }, { 134,7316 }, { 135,7316 }, { 136,7316 },
 { 137,7316 }, { 138,7316 }, { 139,7316 }, { 140,7316 }, { 141,7316 },
 { 142,7316 }, { 143,7316 }, { 144,7316 }, { 145,7316 }, { 146,7316 },
 { 147,7316 }, { 148,7316 }, { 149,7316 }, { 150,7316 }, { 151,7316 },
 { 152,7316 }, { 153,7316 }, { 154,7316 }, { 155,7316 }, { 156,7316 },
 { 157,7316 }, { 158,7316 }, { 159,7316 }, { 160,7316 }, { 161,7316 },
 { 162,7316 }, { 163,7316 }, { 164,7316 }, { 165,7316 }, { 166,7316 },

 { 167,7316 }, { 168,7316 }, { 169,7316 }, { 170,7316 }, { 171,7316 },
 { 172,7316 }, { 173,7316 }, { 174,7316 }, { 175,7316 }, { 176,7316 },
 { 177,7316 }, { 178,7316 }, { 179,7316 }, { 180,7316 }, { 181,7316 },
 { 182,7316 }, { 183,7316 }, { 184,7316 }, { 185,7316 }, { 186,7316 },
 { 187,7316 }, { 188,7316 }, { 189,7316 }, { 190,7316 }, { 191,7316 },
 { 192,7316 }, { 193,7316 }, { 194,7316 }, { 195,7316 }, { 196,7316 },
 { 197,7316 }, { 198,7316 }, { 199,7316 }, { 200,7316 }, { 201,7316 },
 { 202,7316 }, { 203,7316 }, { 204,7316 }, { 205,7316 }, { 206,7316 },
 { 207,7316 }, { 208,7316 }, { 209,7316 }, { 210,7316 }, { 211,7316 },
 { 212,7316 }, { 213,7316 }, { 214,7316 }, { 215,7316 }, { 216,7316 },

 { 217,7316 }, { 218,7316 }, { 219,7316 }, { 220,7316 }, { 221,7316 },
 { 222,7316 }, { 223,7316 }, { 224,7316 }, { 225,7316 }, { 226,7316 },
 { 227,7316 }, { 228,7316 }, { 229,7316 }, { 230,7316 }, { 231,7316 },
 { 232,7316 }, { 233,7316 }, { 234,7316 }, { 235,7316 }, { 236,7316 },
 { 237,7316 }, { 238,7316 }, { 239,7316 }, { 240,7316 }, { 241,7316 },
 { 242,7316 }, { 243,7316 }, { 244,7316 }, { 245,7316 }, { 246,7316 },
 { 247,7316 }, { 248,7316 }, { 249,7316 }, { 250,7316 }, { 251,7316 },
 { 252,7316 }, { 253,7316 }, { 254,7316 }, { 255,7316 }, { 256,7316 },
 {   0,   0 }, {   0,22998 }, {   1,7058 }, {   2,7058 }, {   3,7058 },
 {   4,7058 }, {   5,7058 }, {   6,7058 }, {   7,7058 }, {   8,7058 },

 {   9,7058 }, {  10,7058 }, {  11,7058 }, {  12,7058 }, {  13,7058 },
 {  14,7058 }, {  15,7058 }, {  16,7058 }, {  17,7058 }, {  18,7058 },
 {  19,7058 }, {  20,7058 }, {  21,7058 }, {  22,7058 }, {  23,7058 },
 {  24,7058 }, {  25,7058 }, {  26,7058 }, {  27,7058 }, {  28,7058 },
 {  29,7058 }, {  30,7058 }, {  31,7058 }, {  32,7058 }, {  33,7058 },
 {  34,7058 }, {  35,7058 }, {  36,7058 }, {  37,7058 }, {  38,7058 },
 {  39,3412 }, {  40,7058 }, {  41,7058 }, {  42,7058 }, {  43,7058 },
 {  44,7058 }, {  45,7058 }, {  46,7058 }, {  47,7058 }, {  48,7058 },
 {  49,7058 }, {  50,7058 }, {  51,7058 }, {  52,7058 }, {  53,7058 },
 {  54,7058 }, {  55,7058 }, {  56,7058 }, {  57,7058 }, {  58,7058 },

 {  59,7058 }, {  60,7058 }, {  61,7058 }, {  62,7058 }, {  63,7058 },
 {  64,7058 }, {  65,7058 }, {  66,7058 }, {  67,7058 }, {  68,7058 },
 {  69,7058 }, {  70,7058 }, {  71,7058 }, {  72,7058 }, {  73,7058 },
 {  74,7058 }, {  75,7058 }, {  76,7058 }, {  77,7058 }, {  78,7058 },
 {  79,7058 }, {  80,7058 }, {  81,7058 }, {  82,7058 }, {  83,7058 },
 {  84,7058 }, {  85,7058 }, {  86,7058 }, {  87,7058 }, {  88,7058 },
 {  89,7058 }, {  90,7058 }, {  91,7058 }, {  92,7058 }, {  93,7058 },
 {  94,7058 }, {  95,7058 }, {  96,7058 }, {  97,7058 }, {  98,7058 },
 {  99,7058 }, { 100,7058 }, { 101,7058 }, { 102,7058 }, { 103,7058 },
 { 104,7058 }, { 105,7058 }, { 106,7058 }, { 107,7058 }, { 108,7058 },

 { 109,7058 }, { 110,7058 }, { 111,7058 }, { 112,7058 }, { 113,7058 },
 { 114,7058 }, { 115,7058 }, { 116,7058 }, { 117,7058 }, { 118,7058 },
 { 119,7058 }, { 120,7058 }, { 121,7058 }, { 122,7058 }, { 123,7058 },
 { 124,7058 }, { 125,7058 }, { 126,7058 }, { 127,7058 }, { 128,7058 },
 { 129,7058 }, { 130,7058 }, { 131,7058 }, { 132,7058 }, { 133,7058 },
 { 134,7058 }, { 135,7058 }, { 136,7058 }, { 137,7058 }, { 138,7058 },
 { 139,7058 }, { 140,7058 }, { 141,7058 }, { 142,7058 }, { 143,7058 },
 { 144,7058 }, { 145,7058 }, { 146,7058 }, { 147,7058 }, { 148,7058 },
 { 149,7058 }, { 150,7058 }, { 151,7058 }, { 152,7058 }, { 153,7058 },
 { 154,7058 }, { 155,7058 }, { 156,7058 }, { 157,7058 }, { 158,7058 },

 { 159,7058 }, { 160,7058 }, { 161,7058 }, { 162,7058 }, { 163,7058 },
 { 164,7058 }, { 165,7058 }, { 166,7058 }, { 167,7058 }, { 168,7058 },
 { 169,7058 }, { 170,7058 }, { 171,7058 }, { 172,7058 }, { 173,7058 },
 { 174,7058 }, { 175,7058 }, { 176,7058 }, { 177,7058 }, { 178,7058 },
 { 179,7058 }, { 180,7058 }, { 181,7058 }, { 182,7058 }, { 183,7058 },
 { 184,7058 }, { 185,7058 }, { 186,7058 }, { 187,7058 }, { 188,7058 },
 { 189,7058 }, { 190,7058 }, { 191,7058 }, { 192,7058 }, { 193,7058 },
 { 194,7058 }, { 195,7058 }, { 196,7058 }, { 197,7058 }, { 198,7058 },
 { 199,7058 }, { 200,7058 }, { 201,7058 }, { 202,7058 }, { 203,7058 },
 { 204,7058 }, { 205,7058 }, { 206,7058 }, { 207,7058 }, { 208,7058 },

 { 209,7058 }, { 210,7058 }, { 211,7058 }, { 212,7058 }, { 213,7058 },
 { 214,7058 }, { 215,7058 }, { 216,7058 }, { 217,7058 }, { 218,7058 },
 { 219,7058 }, { 220,7058 }, { 221,7058 }, { 222,7058 }, { 223,7058 },
 { 224,7058 }, { 225,7058 }, { 226,7058 }, { 227,7058 }, { 228,7058 },
 { 229,7058 }, { 230,7058 }, { 231,7058 }, { 232,7058 }, { 233,7058 },
 { 234,7058 }, { 235,7058 }, { 236,7058 }, { 237,7058 }, { 238,7058 },
 { 239,7058 }, { 240,7058 }, { 241,7058 }, { 242,7058 }, { 243,7058 },
 { 244,7058 }, { 245,7058 }, { 246,7058 }, { 247,7058 }, { 248,7058 },
 { 249,7058 }, { 250,7058 }, { 251,7058 }, { 252,7058 }, { 253,7058 },
 { 254,7058 }, { 255,7058 }, { 256,7058 }, {   0,  18 }, {   0,22740 },

 {   1,3156 }, {   2,3156 }, {   3,3156 }, {   4,3156 }, {   5,3156 },
 {   6,3156 }, {   7,3156 }, {   8,3156 }, {   9,7058 }, {  10,7063 },
 {  11,3156 }, {  12,7058 }, {  13,7079 }, {  14,3156 }, {  15,3156 },
 {  16,3156 }, {  17,3156 }, {  18,3156 }, {  19,3156 }, {  20,3156 },
 {  21,3156 }, {  22,3156 }, {  23,3156 }, {  24,3156 }, {  25,3156 },
 {  26,3156 }, {  27,3156 }, {  28,3156 }, {  29,3156 }, {  30,3156 },
 {  31,3156 }, {  32,7058 }, {  33,3156 }, {  34,3156 }, {  35,3156 },
 {  36,3156 }, {  37,3156 }, {  38,3156 }, {  39,3156 }, {  40,3156 },
 {  41,3156 }, {  42,3156 }, {  43,3156 }, {  44,3156 }, {  45,3158 },
 {  46,3156 }, {  47,3156 }, {  48,3156 }, {  49,3156 }, {  50,3156 },

 {  51,3156 }, {  52,3156 }, {  53,3156 }, {  54,3156 }, {  55,3156 },
 {  56,3156 }, {  57,3156 }, {  58,3156 }, {  59,3156 }, {  60,3156 },
 {  61,3156 }, {  62,3156 }, {  63,3156 }, {  64,3156 }, {  65,3156 },
 {  66,3156 }, {  67,3156 }, {  68,3156 }, {  69,3156 }, {  70,3156 },
 {  71,3156 }, {  72,3156 }, {  73,3156 }, {  74,3156 }, {  75,3156 },
 {  76,3156 }, {  77,3156 }, {  78,3156 }, {  79,3156 }, {  80,3156 },
 {  81,3156 }, {  82,3156 }, {  83,3156 }, {  84,3156 }, {  85,3156 },
 {  86,3156 }, {  87,3156 }, {  88,3156 }, {  89,3156 }, {  90,3156 },
 {  91,3156 }, {  92,3156 }, {  93,3156 }, {  94,3156 }, {  95,3156 },
 {  96,3156 }, {  97,3156 }, {  98,3156 }, {  99,3156 }, { 100,3156 },

 { 101,3156 }, { 102,3156 }, { 103,3156 }, { 104,3156 }, { 105,3156 },
 { 106,3156 }, { 107,3156 }, { 108,3156 }, { 109,3156 }, { 110,3156 },
 { 111,3156 }, { 112,3156 }, { 113,3156 }, { 114,3156 }, { 115,3156 },
 { 116,3156 }, { 117,3156 }, { 118,3156 }, { 119,3156 }, { 120,3156 },
 { 121,3156 }, { 122,3156 }, { 123,3156 }, { 124,3156 }, { 125,3156 },
 { 126,3156 }, { 127,3156 }, { 128,3156 }, { 129,3156 }, { 130,3156 },
 { 131,3156 }, { 132,3156 }, { 133,3156 }, { 134,3156 }, { 135,3156 },
 { 136,3156 }, { 137,3156 }, { 138,3156 }, { 139,3156 }, { 140,3156 },
 { 141,3156 }, { 142,3156 }, { 143,3156 }, { 144,3156 }, { 145,3156 },
 { 146,3156 }, { 147,3156 }, { 148,3156 }, { 149,3156 }, { 150,3156 },

 { 151,3156 }, { 152,3156 }, { 153,3156 }, { 154,3156 }, { 155,3156 },
 { 156,3156 }, { 157,3156 }, { 158,3156 }, { 159,3156 }, { 160,3156 },
 { 161,3156 }, { 162,3156 }, { 163,3156 }, { 164,3156 }, { 165,3156 },
 { 166,3156 }, { 167,3156 }, { 168,3156 }, { 169,3156 }, { 170,3156 },
 { 171,3156 }, { 172,3156 }, { 173,3156 }, { 174,3156 }, { 175,3156 },
 { 176,3156 }, { 177,3156 }, { 178,3156 }, { 179,3156 }, { 180,3156 },
 { 181,3156 }, { 182,3156 }, { 183,3156 }, { 184,3156 }, { 185,3156 },
 { 186,3156 }, { 187,3156 }, { 188,3156 }, { 189,3156 }, { 190,3156 },
 { 191,3156 }, { 192,3156 }, { 193,3156 }, { 194,3156 }, { 195,3156 },
 { 196,3156 }, { 197,3156 }, { 198,3156 }, { 199,3156 }, { 200,3156 },

 { 201,3156 }, { 202,3156 }, { 203,3156 }, { 204,3156 }, { 205,3156 },
 { 206,3156 }, { 207,3156 }, { 208,3156 }, { 209,3156 }, { 210,3156 },
 { 211,3156 }, { 212,3156 }, { 213,3156 }, { 214,3156 }, { 215,3156 },
 { 216,3156 }, { 217,3156 }, { 218,3156 }, { 219,3156 }, { 220,3156 },
 { 221,3156 }, { 222,3156 }, { 223,3156 }, { 224,3156 }, { 225,3156 },
 { 226,3156 }, { 227,3156 }, { 228,3156 }, { 229,3156 }, { 230,3156 },
 { 231,3156 }, { 232,3156 }, { 233,3156 }, { 234,3156 }, { 235,3156 },
 { 236,3156 }, { 237,3156 }, { 238,3156 }, { 239,3156 }, { 240,3156 },
 { 241,3156 }, { 242,3156 }, { 243,3156 }, { 244,3156 }, { 245,3156 },
 { 246,3156 }, { 247,3156 }, { 248,3156 }, { 249,3156 }, { 250,3156 },

 { 251,3156 }, { 252,3156 }, { 253,3156 }, { 254,3156 }, { 255,3156 },
 { 256,3156 }, {   0,  18 }, {   0,22482 }, {   1,2898 }, {   2,2898 },
 {   3,2898 }, {   4,2898 }, {   5,2898 }, {   6,2898 }, {   7,2898 },
 {   8,2898 }, {   9,6800 }, {  10,6805 }, {  11,2898 }, {  12,6800 },
 {  13,6821 }, {  14,2898 }, {  15,2898 }, {  16,2898 }, {  17,2898 },
 {  18,2898 }, {  19,2898 }, {  20,2898 }, {  21,2898 }, {  22,2898 },
 {  23,2898 }, {  24,2898 }, {  25,2898 }, {  26,2898 }, {  27,2898 },
 {  28,2898 }, {  29,2898 }, {  30,2898 }, {  31,2898 }, {  32,6800 },
 {  33,2898 }, {  34,2898 }, {  35,2898 }, {  36,2898 }, {  37,2898 },
 {  38,2898 }, {  39,2898 }, {  40,2898 }, {  41,2898 }, {  42,2898 },

 {  43,2898 }, {  44,2898 }, {  45,2900 }, {  46,2898 }, {  47,2898 },
 {  48,2898 }, {  49,2898 }, {  50,2898 }, {  51,2898 }, {  52,2898 },
 {  53,2898 }, {  54,2898 }, {  55,2898 }, {  56,2898 }, {  57,2898 },
 {  58,2898 }, {  59,2898 }, {  60,2898 }, {  61,2898 }, {  62,2898 },
 {  63,2898 }, {  64,2898 }, {  65,2898 }, {  66,2898 }, {  67,2898 },
 {  68,2898 }, {  69,2898 }, {  70,2898 }, {  71,2898 }, {  72,2898 },
 {  73,2898 }, {  74,2898 }, {  75,2898 }, {  76,2898 }, {  77,2898 },
 {  78,2898 }, {  79,2898 }, {  80,2898 }, {  81,2898 }, {  82,2898 },
 {  83,2898 }, {  84,2898 }, {  85,2898 }, {  86,2898 }, {  87,2898 },
 {  88,2898 }, {  89,2898 }, {  90,2898 }, {  91,2898 }, {  92,2898 },

 {  93,2898 }, {  94,2898 }, {  95,2898 }, {  96,2898 }, {  97,2898 },
 {  98,2898 }, {  99,2898 }, { 100,2898 }, { 101,2898 }, { 102,2898 },
 { 103,2898 }, { 104,2898 }, { 105,2898 }, { 106,2898 }, { 107,2898 },
 { 108,2898 }, { 109,2898 }, { 110,2898 }, { 111,2898 }, { 112,2898 },
 { 113,2898 }, { 114,2898 }, { 115,2898 }, { 116,2898 }, { 117,2898 },
 { 118,2898 }, { 119,2898 }, { 120,2898 }, { 121,2898 }, { 122,2898 },
 { 123,2898 }, { 124,2898 }, { 125,2898 }, { 126,2898 }, { 127,2898 },
 { 128,2898 }, { 129,2898 }, { 130,2898 }, { 131,2898 }, { 132,2898 },
 { 133,2898 }, { 134,2898 }, { 135,2898 }, { 136,2898 }, { 137,2898 },
 { 138,2898 }, { 139,2898 }, { 140,2898 }, { 141,2898 }, { 142,2898 },

 { 143,2898 }, { 144,2898 }, { 145,2898 }, { 146,2898 }, { 147,2898 },
 { 148,2898 }, { 149,2898 }, { 150,2898 }, { 151,2898 }, { 152,2898 },
 { 153,2898 }, { 154,2898 }, { 155,2898 }, { 156,2898 }, { 157,2898 },
 { 158,2898 }, { 159,2898 }, { 160,2898 }, { 161,2898 }, { 162,2898 },
 { 163,2898 }, { 164,2898 }, { 165,2898 }, { 166,2898 }, { 167,2898 },
 { 168,2898 }, { 169,2898 }, { 170,2898 }, { 171,2898 }, { 172,2898 },
 { 173,2898 }, { 174,2898 }, { 175,2898 }, { 176,2898 }, { 177,2898 },
 { 178,2898 }, { 179,2898 }, { 180,2898 }, { 181,2898 }, { 182,2898 },
 { 183,2898 }, { 184,2898 }, { 185,2898 }, { 186,2898 }, { 187,2898 },
 { 188,2898 }, { 189,2898 }, { 190,2898 }, { 191,2898 }, { 192,2898 },

 { 193,2898 }, { 194,2898 }, { 195,2898 }, { 196,2898 }, { 197,2898 },
 { 198,2898 }, { 199,2898 }, { 200,2898 }, { 201,2898 }, { 202,2898 },
 { 203,2898 }, { 204,2898 }, { 205,2898 }, { 206,2898 }, { 207,2898 },
 { 208,2898 }, { 209,2898 }, { 210,2898 }, { 211,2898 }, { 212,2898 },
 { 213,2898 }, { 214,2898 }, { 215,2898 }, { 216,2898 }, { 217,2898 },
 { 218,2898 }, { 219,2898 }, { 220,2898 }, { 221,2898 }, { 222,2898 },
 { 223,2898 }, { 224,2898 }, { 225,2898 }, { 226,2898 }, { 227,2898 },
 { 228,2898 }, { 229,2898 }, { 230,2898 }, { 231,2898 }, { 232,2898 },
 { 233,2898 }, { 234,2898 }, { 235,2898 }, { 236,2898 }, { 237,2898 },
 { 238,2898 }, { 239,2898 }, { 240,2898 }, { 241,2898 }, { 242,2898 },

 { 243,2898 }, { 244,2898 }, { 245,2898 }, { 246,2898 }, { 247,2898 },
 { 248,2898 }, { 249,2898 }, { 250,2898 }, { 251,2898 }, { 252,2898 },
 { 253,2898 }, { 254,2898 }, { 255,2898 }, { 256,2898 }, {   0,   0 },
 {   0,22224 }, {   1,6610 }, {   2,6610 }, {   3,6610 }, {   4,6610 },
 {   5,6610 }, {   6,6610 }, {   7,6610 }, {   8,6610 }, {   9,6610 },
 {  10,6868 }, {  11,6610 }, {  12,6610 }, {  13,6610 }, {  14,6610 },
 {  15,6610 }, {  16,6610 }, {  17,6610 }, {  18,6610 }, {  19,6610 },
 {  20,6610 }, {  21,6610 }, {  22,6610 }, {  23,6610 }, {  24,6610 },
 {  25,6610 }, {  26,6610 }, {  27,6610 }, {  28,6610 }, {  29,6610 },
 {  30,6610 }, {  31,6610 }, {  32,6610 }, {  33,6610 }, {  34,6610 },

 {  35,6610 }, {  36,6610 }, {  37,6610 }, {  38,6610 }, {  39,2645 },
 {  40,6610 }, {  41,6610 }, {  42,6610 }, {  43,6610 }, {  44,6610 },
 {  45,6610 }, {  46,6610 }, {  47,6610 }, {  48,6610 }, {  49,6610 },
 {  50,6610 }, {  51,6610 }, {  52,6610 }, {  53,6610 }, {  54,6610 },
 {  55,6610 }, {  56,6610 }, {  57,6610 }, {  58,6610 }, {  59,6610 },
 {  60,6610 }, {  61,6610 }, {  62,6610 }, {  63,6610 }, {  64,6610 },
 {  65,6610 }, {  66,6610 }, {  67,6610 }, {  68,6610 }, {  69,6610 },
 {  70,6610 }, {  71,6610 }, {  72,6610 }, {  73,6610 }, {  74,6610 },
 {  75,6610 }, {  76,6610 }, {  77,6610 }, {  78,6610 }, {  79,6610 },
 {  80,6610 }, {  81,6610 }, {  82,6610 }, {  83,6610 }, {  84,6610 },

 {  85,6610 }, {  86,6610 }, {  87,6610 }, {  88,6610 }, {  89,6610 },
 {  90,6610 }, {  91,6610 }, {  92,7126 }, {  93,6610 }, {  94,6610 },
 {  95,6610 }, {  96,6610 }, {  97,6610 }, {  98,6610 }, {  99,6610 },
 { 100,6610 }, { 101,6610 }, { 102,6610 }, { 103,6610 }, { 104,6610 },
 { 105,6610 }, { 106,6610 }, { 107,6610 }, { 108,6610 }, { 109,6610 },
 { 110,6610 }, { 111,6610 }, { 112,6610 }, { 113,6610 }, { 114,6610 },
 { 115,6610 }, { 116,6610 }, { 117,6610 }, { 118,6610 }, { 119,6610 },
 { 120,6610 }, { 121,6610 }, { 122,6610 }, { 123,6610 }, { 124,6610 },
 { 125,6610 }, { 126,6610 }, { 127,6610 }, { 128,6610 }, { 129,6610 },
 { 130,6610 }, { 131,6610 }, { 132,6610 }, { 133,6610 }, { 134,6610 },

 { 135,6610 }, { 136,6610 }, { 137,6610 }, { 138,6610 }, { 139,6610 },
 { 140,6610 }, { 141,6610 }, { 142,6610 }, { 143,6610 }, { 144,6610 },
 { 145,6610 }, { 146,6610 }, { 147,6610 }, { 148,6610 }, { 149,6610 },
 { 150,6610 }, { 151,6610 }, { 152,6610 }, { 153,6610 }, { 154,6610 },
 { 155,6610 }, { 156,6610 }, { 157,6610 }, { 158,6610 }, { 159,6610 },
 { 160,6610 }, { 161,6610 }, { 162,6610 }, { 163,6610 }, { 164,6610 },
 { 165,6610 }, { 166,6610 }, { 167,6610 }, { 168,6610 }, { 169,6610 },
 { 170,6610 }, { 171,6610 }, { 172,6610 }, { 173,6610 }, { 174,6610 },
 { 175,6610 }, { 176,6610 }, { 177,6610 }, { 178,6610 }, { 179,6610 },
 { 180,6610 }, { 181,6610 }, { 182,6610 }, { 183,6610 }, { 184,6610 },

 { 185,6610 }, { 186,6610 }, { 187,6610 }, { 188,6610 }, { 189,6610 },
 { 190,6610 }, { 191,6610 }, { 192,6610 }, { 193,6610 }, { 194,6610 },
 { 195,6610 }, { 196,6610 }, { 197,6610 }, { 198,6610 }, { 199,6610 },
 { 200,6610 }, { 201,6610 }, { 202,6610 }, { 203,6610 }, { 204,6610 },
 { 205,6610 }, { 206,6610 }, { 207,6610 }, { 208,6610 }, { 209,6610 },
 { 210,6610 }, { 211,6610 }, { 212,6610 }, { 213,6610 }, { 214,6610 },
 { 215,6610 }, { 216,6610 }, { 217,6610 }, { 218,6610 }, { 219,6610 },
 { 220,6610 }, { 221,6610 }, { 222,6610 }, { 223,6610 }, { 224,6610 },
 { 225,6610 }, { 226,6610 }, { 227,6610 }, { 228,6610 }, { 229,6610 },
 { 230,6610 }, { 231,6610 }, { 232,6610 }, { 233,6610 }, { 234,6610 },

 { 235,6610 }, { 236,6610 }, { 237,6610 }, { 238,6610 }, { 239,6610 },
 { 240,6610 }, { 241,6610 }, { 242,6610 }, { 243,6610 }, { 244,6610 },
 { 245,6610 }, { 246,6610 }, { 247,6610 }, { 248,6610 }, { 249,6610 },
 { 250,6610 }, { 251,6610 }, { 252,6610 }, { 253,6610 }, { 254,6610 },
 { 255,6610 }, { 256,6610 }, {   0,   0 }, {   0,21966 }, {   1,6352 },
 {   2,6352 }, {   3,6352 }, {   4,6352 }, {   5,6352 }, {   6,6352 },
 {   7,6352 }, {   8,6352 }, {   9,6352 }, {  10,6610 }, {  11,6352 },
 {  12,6352 }, {  13,6352 }, {  14,6352 }, {  15,6352 }, {  16,6352 },
 {  17,6352 }, {  18,6352 }, {  19,6352 }, {  20,6352 }, {  21,6352 },
 {  22,6352 }, {  23,6352 }, {  24,6352 }, {  25,6352 }, {  26,6352 },

 {  27,6352 }, {  28,6352 }, {  29,6352 }, {  30,6352 }, {  31,6352 },
 {  32,6352 }, {  33,6352 }, {  34,6352 }, {  35,6352 }, {  36,6352 },
 {  37,6352 }, {  38,6352 }, {  39,2387 }, {  40,6352 }, {  41,6352 },
 {  42,6352 }, {  43,6352 }, {  44,6352 }, {  45,6352 }, {  46,6352 },
 {  47,6352 }, {  48,6352 }, {  49,6352 }, {  50,6352 }, {  51,6352 },
 {  52,6352 }, {  53,6352 }, {  54,6352 }, {  55,6352 }, {  56,6352 },
 {  57,6352 }, {  58,6352 }, {  59,6352 }, {  60,6352 }, {  61,6352 },
 {  62,6352 }, {  63,6352 }, {  64,6352 }, {  65,6352 }, {  66,6352 },
 {  67,6352 }, {  68,6352 }, {  69,6352 }, {  70,6352 }, {  71,6352 },
 {  72,6352 }, {  73,6352 }, {  74,6352 }, {  75,6352 }, {  76,6352 },

 {  77,6352 }, {  78,6352 }, {  79,6352 }, {  80,6352 }, {  81,6352 },
 {  82,6352 }, {  83,6352 }, {  84,6352 }, {  85,6352 }, {  86,6352 },
 {  87,6352 }, {  88,6352 }, {  89,6352 }, {  90,6352 }, {  91,6352 },
 {  92,6868 }, {  93,6352 }, {  94,6352 }, {  95,6352 }, {  96,6352 },
 {  97,6352 }, {  98,6352 }, {  99,6352 }, { 100,6352 }, { 101,6352 },
 { 102,6352 }, { 103,6352 }, { 104,6352 }, { 105,6352 }, { 106,6352 },
 { 107,6352 }, { 108,6352 }, { 109,6352 }, { 110,6352 }, { 111,6352 },
 { 112,6352 }, { 113,6352 }, { 114,6352 }, { 115,6352 }, { 116,6352 },
 { 117,6352 }, { 118,6352 }, { 119,6352 }, { 120,6352 }, { 121,6352 },
 { 122,6352 }, { 123,6352 }, { 124,6352 }, { 125,6352 }, { 126,6352 },

 { 127,6352 }, { 128,6352 }, { 129,6352 }, { 130,6352 }, { 131,6352 },
 { 132,6352 }, { 133,6352 }, { 134,6352 }, { 135,6352 }, { 136,6352 },
 { 137,6352 }, { 138,6352 }, { 139,6352 }, { 140,6352 }, { 141,6352 },
 { 142,6352 }, { 143,6352 }, { 144,6352 }, { 145,6352 }, { 146,6352 },
 { 147,6352 }, { 148,6352 }, { 149,6352 }, { 150,6352 }, { 151,6352 },
 { 152,6352 }, { 153,6352 }, { 154,6352 }, { 155,6352 }, { 156,6352 },
 { 157,6352 }, { 158,6352 }, { 159,6352 }, { 160,6352 }, { 161,6352 },
 { 162,6352 }, { 163,6352 }, { 164,6352 }, { 165,6352 }, { 166,6352 },
 { 167,6352 }, { 168,6352 }, { 169,6352 }, { 170,6352 }, { 171,6352 },
 { 172,6352 }, { 173,6352 }, { 174,6352 }, { 175,6352 }, { 176,6352 },

 { 177,6352 }, { 178,6352 }, { 179,6352 }, { 180,6352 }, { 181,6352 },
 { 182,6352 }, { 183,6352 }, { 184,6352 }, { 185,6352 }, { 186,6352 },
 { 187,6352 }, { 188,6352 }, { 189,6352 }, { 190,6352 }, { 191,6352 },
 { 192,6352 }, { 193,6352 }, { 194,6352 }, { 195,6352 }, { 196,6352 },
 { 197,6352 }, { 198,6352 }, { 199,6352 }, { 200,6352 }, { 201,6352 },
 { 202,6352 }, { 203,6352 }, { 204,6352 }, { 205,6352 }, { 206,6352 },
 { 207,6352 }, { 208,6352 }, { 209,6352 }, { 210,6352 }, { 211,6352 },
 { 212,6352 }, { 213,6352 }, { 214,6352 }, { 215,6352 }, { 216,6352 },
 { 217,6352 }, { 218,6352 }, { 219,6352 }, { 220,6352 }, { 221,6352 },
 { 222,6352 }, { 223,6352 }, { 224,6352 }, { 225,6352 }, { 226,6352 },

 { 227,6352 }, { 228,6352 }, { 229,6352 }, { 230,6352 }, { 231,6352 },
 { 232,6352 }, { 233,6352 }, { 234,6352 }, { 235,6352 }, { 236,6352 },
 { 237,6352 }, { 238,6352 }, { 239,6352 }, { 240,6352 }, { 241,6352 },
 { 242,6352 }, { 243,6352 }, { 244,6352 }, { 245,6352 }, { 246,6352 },
 { 247,6352 }, { 248,6352 }, { 249,6352 }, { 250,6352 }, { 251,6352 },
 { 252,6352 }, { 253,6352 }, { 254,6352 }, { 255,6352 }, { 256,6352 },
 {   0,   0 }, {   0,21708 }, {   1,6868 }, {   2,6868 }, {   3,6868 },
 {   4,6868 }, {   5,6868 }, {   6,6868 }, {   7,6868 }, {   8,6868 },
 {   9,6868 }, {  10,7126 }, {  11,6868 }, {  12,6868 }, {  13,6868 },
 {  14,6868 }, {  15,6868 }, {  16,6868 }, {  17,6868 }, {  18,6868 },

 {  19,6868 }, {  20,6868 }, {  21,6868 }, {  22,6868 }, {  23,6868 },
 {  24,6868 }, {  25,6868 }, {  26,6868 }, {  27,6868 }, {  28,6868 },
 {  29,6868 }, {  30,6868 }, {  31,6868 }, {  32,6868 }, {  33,6868 },
 {  34,6868 }, {  35,6868 }, {  36,7384 }, {  37,6868 }, {  38,6868 },
 {  39,6868 }, {  40,6868 }, {  41,6868 }, {  42,6868 }, {  43,6868 },
 {  44,6868 }, {  45,6868 }, {  46,6868 }, {  47,6868 }, {  48,6868 },
 {  49,6868 }, {  50,6868 }, {  51,6868 }, {  52,6868 }, {  53,6868 },
 {  54,6868 }, {  55,6868 }, {  56,6868 }, {  57,6868 }, {  58,6868 },
 {  59,6868 }, {  60,6868 }, {  61,6868 }, {  62,6868 }, {  63,6868 },
 {  64,6868 }, {  65,6868 }, {  66,6868 }, {  67,6868 }, {  68,6868 },

 {  69,6868 }, {  70,6868 }, {  71,6868 }, {  72,6868 }, {  73,6868 },
 {  74,6868 }, {  75,6868 }, {  76,6868 }, {  77,6868 }, {  78,6868 },
 {  79,6868 }, {  80,6868 }, {  81,6868 }, {  82,6868 }, {  83,6868 },
 {  84,6868 }, {  85,6868 }, {  86,6868 }, {  87,6868 }, {  88,6868 },
 {  89,6868 }, {  90,6868 }, {  91,6868 }, {  92,6868 }, {  93,6868 },
 {  94,6868 }, {  95,6868 }, {  96,6868 }, {  97,6868 }, {  98,6868 },
 {  99,6868 }, { 100,6868 }, { 101,6868 }, { 102,6868 }, { 103,6868 },
 { 104,6868 }, { 105,6868 }, { 106,6868 }, { 107,6868 }, { 108,6868 },
 { 109,6868 }, { 110,6868 }, { 111,6868 }, { 112,6868 }, { 113,6868 },
 { 114,6868 }, { 115,6868 }, { 116,6868 }, { 117,6868 }, { 118,6868 },

 { 119,6868 }, { 120,6868 }, { 121,6868 }, { 122,6868 }, { 123,6868 },
 { 124,6868 }, { 125,6868 }, { 126,6868 }, { 127,6868 }, { 128,6868 },
 { 129,6868 }, { 130,6868 }, { 131,6868 }, { 132,6868 }, { 133,6868 },
 { 134,6868 }, { 135,6868 }, { 136,6868 }, { 137,6868 }, { 138,6868 },
 { 139,6868 }, { 140,6868 }, { 141,6868 }, { 142,6868 }, { 143,6868 },
 { 144,6868 }, { 145,6868 }, { 146,6868 }, { 147,6868 }, { 148,6868 },
 { 149,6868 }, { 150,6868 }, { 151,6868 }, { 152,6868 }, { 153,6868 },
 { 154,6868 }, { 155,6868 }, { 156,6868 }, { 157,6868 }, { 158,6868 },
 { 159,6868 }, { 160,6868 }, { 161,6868 }, { 162,6868 }, { 163,6868 },
 { 164,6868 }, { 165,6868 }, { 166,6868 }, { 167,6868 }, { 168,6868 },

 { 169,6868 }, { 170,6868 }, { 171,6868 }, { 172,6868 }, { 173,6868 },
 { 174,6868 }, { 175,6868 }, { 176,6868 }, { 177,6868 }, { 178,6868 },
 { 179,6868 }, { 180,6868 }, { 181,6868 }, { 182,6868 }, { 183,6868 },
 { 184,6868 }, { 185,6868 }, { 186,6868 }, { 187,6868 }, { 188,6868 },
 { 189,6868 }, { 190,6868 }, { 191,6868 }, { 192,6868 }, { 193,6868 },
 { 194,6868 }, { 195,6868 }, { 196,6868 }, { 197,6868 }, { 198,6868 },
 { 199,6868 }, { 200,6868 }, { 201,6868 }, { 202,6868 }, { 203,6868 },
 { 204,6868 }, { 205,6868 }, { 206,6868 }, { 207,6868 }, { 208,6868 },
 { 209,6868 }, { 210,6868 }, { 211,6868 }, { 212,6868 }, { 213,6868 },
 { 214,6868 }, { 215,6868 }, { 216,6868 }, { 217,6868 }, { 218,6868 },

 { 219,6868 }, { 220,6868 }, { 221,6868 }, { 222,6868 }, { 223,6868 },
 { 224,6868 }, { 225,6868 }, { 226,6868 }, { 227,6868 }, { 228,6868 },
 { 229,6868 }, { 230,6868 }, { 231,6868 }, { 232,6868 }, { 233,6868 },
 { 234,6868 }, { 235,6868 }, { 236,6868 }, { 237,6868 }, { 238,6868 },
 { 239,6868 }, { 240,6868 }, { 241,6868 }, { 242,6868 }, { 243,6868 },
 { 244,6868 }, { 245,6868 }, { 246,6868 }, { 247,6868 }, { 248,6868 },
 { 249,6868 }, { 250,6868 }, { 251,6868 }, { 252,6868 }, { 253,6868 },
 { 254,6868 }, { 255,6868 }, { 256,6868 }, {   0,   0 }, {   0,21450 },
 {   1,6610 }, {   2,6610 }, {   3,6610 }, {   4,6610 }, {   5,6610 },
 {   6,6610 }, {   7,6610 }, {   8,6610 }, {   9,6610 }, {  10,6868 },

 {  11,6610 }, {  12,6610 }, {  13,6610 }, {  14,6610 }, {  15,6610 },
 {  16,6610 }, {  17,6610 }, {  18,6610 }, {  19,6610 }, {  20,6610 },
 {  21,6610 }, {  22,6610 }, {  23,6610 }, {  24,6610 }, {  25,6610 },
 {  26,6610 }, {  27,6610 }, {  28,6610 }, {  29,6610 }, {  30,6610 },
 {  31,6610 }, {  32,6610 }, {  33,6610 }, {  34,6610 }, {  35,6610 },
 {  36,7126 }, {  37,6610 }, {  38,6610 }, {  39,6610 }, {  40,6610 },
 {  41,6610 }, {  42,6610 }, {  43,6610 }, {  44,6610 }, {  45,6610 },
 {  46,6610 }, {  47,6610 }, {  48,6610 }, {  49,6610 }, {  50,6610 },
 {  51,6610 }, {  52,6610 }, {  53,6610 }, {  54,6610 }, {  55,6610 },
 {  56,6610 }, {  57,6610 }, {  58,6610 }, {  59,6610 }, {  60,6610 },

 {  61,6610 }, {  62,6610 }, {  63,6610 }, {  64,6610 }, {  65,6610 },
 {  66,6610 }, {  67,6610 }, {  68,6610 }, {  69,6610 }, {  70,6610 },
 {  71,6610 }, {  72,6610 }, {  73,6610 }, {  74,6610 }, {  75,6610 },
 {  76,6610 }, {  77,6610 }, {  78,6610 }, {  79,6610 }, {  80,6610 },
 {  81,6610 }, {  82,6610 }, {  83,6610 }, {  84,6610 }, {  85,6610 },
 {  86,6610 }, {  87,6610 }, {  88,6610 }, {  89,6610 }, {  90,6610 },
 {  91,6610 }, {  92,6610 }, {  93,6610 }, {  94,6610 }, {  95,6610 },
 {  96,6610 }, {  97,6610 }, {  98,6610 }, {  99,6610 }, { 100,6610 },
 { 101,6610 }, { 102,6610 }, { 103,6610 }, { 104,6610 }, { 105,6610 },
 { 106,6610 }, { 107,6610 }, { 108,6610 }, { 109,6610 }, { 110,6610 },

 { 111,6610 }, { 112,6610 }, { 113,6610 }, { 114,6610 }, { 115,6610 },
 { 116,6610 }, { 117,6610 }, { 118,6610 }, { 119,6610 }, { 120,6610 },
 { 121,6610 }, { 122,6610 }, { 123,6610 }, { 124,6610 }, { 125,6610 },
 { 126,6610 }, { 127,6610 }, { 128,6610 }, { 129,6610 }, { 130,6610 },
 { 131,6610 }, { 132,6610 }, { 133,6610 }, { 134,6610 }, { 135,6610 },
 { 136,6610 }, { 137,6610 }, { 138,6610 }, { 139,6610 }, { 140,6610 },
 { 141,6610 }, { 142,6610 }, { 143,6610 }, { 144,6610 }, { 145,6610 },
 { 146,6610 }, { 147,6610 }, { 148,6610 }, { 149,6610 }, { 150,6610 },
 { 151,6610 }, { 152,6610 }, { 153,6610 }, { 154,6610 }, { 155,6610 },
 { 156,6610 }, { 157,6610 }, { 158,6610 }, { 159,6610 }, { 160,6610 },

 { 161,6610 }, { 162,6610 }, { 163,6610 }, { 164,6610 }, { 165,6610 },
 { 166,6610 }, { 167,6610 }, { 168,6610 }, { 169,6610 }, { 170,6610 },
 { 171,6610 }, { 172,6610 }, { 173,6610 }, { 174,6610 }, { 175,6610 },
 { 176,6610 }, { 177,6610 }, { 178,6610 }, { 179,6610 }, { 180,6610 },
 { 181,6610 }, { 182,6610 }, { 183,6610 }, { 184,6610 }, { 185,6610 },
 { 186,6610 }, { 187,6610 }, { 188,6610 }, { 189,6610 }, { 190,6610 },
 { 191,6610 }, { 192,6610 }, { 193,6610 }, { 194,6610 }, { 195,6610 },
 { 196,6610 }, { 197,6610 }, { 198,6610 }, { 199,6610 }, { 200,6610 },
 { 201,6610 }, { 202,6610 }, { 203,6610 }, { 204,6610 }, { 205,6610 },
 { 206,6610 }, { 207,6610 }, { 208,6610 }, { 209,6610 }, { 210,6610 },

 { 211,6610 }, { 212,6610 }, { 213,6610 }, { 214,6610 }, { 215,6610 },
 { 216,6610 }, { 217,6610 }, { 218,6610 }, { 219,6610 }, { 220,6610 },
 { 221,6610 }, { 222,6610 }, { 223,6610 }, { 224,6610 }, { 225,6610 },
 { 226,6610 }, { 227,6610 }, { 228,6610 }, { 229,6610 }, { 230,6610 },
 { 231,6610 }, { 232,6610 }, { 233,6610 }, { 234,6610 }, { 235,6610 },
 { 236,6610 }, { 237,6610 }, { 238,6610 }, { 239,6610 }, { 240,6610 },
 { 241,6610 }, { 242,6610 }, { 243,6610 }, { 244,6610 }, { 245,6610 },
 { 246,6610 }, { 247,6610 }, { 248,6610 }, { 249,6610 }, { 250,6610 },
 { 251,6610 }, { 252,6610 }, { 253,6610 }, { 254,6610 }, { 255,6610 },
 { 256,6610 }, {   0,   0 }, {   0,21192 }, {   1,4736 }, {   2,4736 },

 {   3,4736 }, {   4,4736 }, {   5,4736 }, {   6,4736 }, {   7,4736 },
 {   8,4736 }, {   9,4736 }, {  10,4736 }, {  11,4736 }, {  12,4736 },
 {  13,4736 }, {  14,4736 }, {  15,4736 }, {  16,4736 }, {  17,4736 },
 {  18,4736 }, {  19,4736 }, {  20,4736 }, {  21,4736 }, {  22,4736 },
 {  23,4736 }, {  24,4736 }, {  25,4736 }, {  26,4736 }, {  27,4736 },
 {  28,4736 }, {  29,4736 }, {  30,4736 }, {  31,4736 }, {  32,4736 },
 {  33,4736 }, {  34,1615 }, {  35,4736 }, {  36,4736 }, {  37,4736 },
 {  38,4736 }, {  39,4736 }, {  40,4736 }, {  41,4736 }, {  42,4736 },
 {  43,4736 }, {  44,4736 }, {  45,4736 }, {  46,4736 }, {  47,4736 },
 {  48,4736 }, {  49,4736 }, {  50,4736 }, {  51,4736 }, {  52,4736 },

 {  53,4736 }, {  54,4736 }, {  55,4736 }, {  56,4736 }, {  57,4736 },
 {  58,4736 }, {  59,4736 }, {  60,4736 }, {  61,4736 }, {  62,4736 },
 {  63,4736 }, {  64,4736 }, {  65,4736 }, {  66,4736 }, {  67,4736 },
 {  68,4736 }, {  69,4736 }, {  70,4736 }, {  71,4736 }, {  72,4736 },
 {  73,4736 }, {  74,4736 }, {  75,4736 }, {  76,4736 }, {  77,4736 },
 {  78,4736 }, {  79,4736 }, {  80,4736 }, {  81,4736 }, {  82,4736 },
 {  83,4736 }, {  84,4736 }, {  85,4736 }, {  86,4736 }, {  87,4736 },
 {  88,4736 }, {  89,4736 }, {  90,4736 }, {  91,4736 }, {  92,4736 },
 {  93,4736 }, {  94,4736 }, {  95,4736 }, {  96,4736 }, {  97,4736 },
 {  98,4736 }, {  99,4736 }, { 100,4736 }, { 101,4736 }, { 102,4736 },

 { 103,4736 }, { 104,4736 }, { 105,4736 }, { 106,4736 }, { 107,4736 },
 { 108,4736 }, { 109,4736 }, { 110,4736 }, { 111,4736 }, { 112,4736 },
 { 113,4736 }, { 114,4736 }, { 115,4736 }, { 116,4736 }, { 117,4736 },
 { 118,4736 }, { 119,4736 }, { 120,4736 }, { 121,4736 }, { 122,4736 },
 { 123,4736 }, { 124,4736 }, { 125,4736 }, { 126,4736 }, { 127,4736 },
 { 128,4736 }, { 129,4736 }, { 130,4736 }, { 131,4736 }, { 132,4736 },
 { 133,4736 }, { 134,4736 }, { 135,4736 }, { 136,4736 }, { 137,4736 },
 { 138,4736 }, { 139,4736 }, { 140,4736 }, { 141,4736 }, { 142,4736 },
 { 143,4736 }, { 144,4736 }, { 145,4736 }, { 146,4736 }, { 147,4736 },
 { 148,4736 }, { 149,4736 }, { 150,4736 }, { 151,4736 }, { 152,4736 },

 { 153,4736 }, { 154,4736 }, { 155,4736 }, { 156,4736 }, { 157,4736 },
 { 158,4736 }, { 159,4736 }, { 160,4736 }, { 161,4736 }, { 162,4736 },
 { 163,4736 }, { 164,4736 }, { 165,4736 }, { 166,4736 }, { 167,4736 },
 { 168,4736 }, { 169,4736 }, { 170,4736 }, { 171,4736 }, { 172,4736 },
 { 173,4736 }, { 174,4736 }, { 175,4736 }, { 176,4736 }, { 177,4736 },
 { 178,4736 }, { 179,4736 }, { 180,4736 }, { 181,4736 }, { 182,4736 },
 { 183,4736 }, { 184,4736 }, { 185,4736 }, { 186,4736 }, { 187,4736 },
 { 188,4736 }, { 189,4736 }, { 190,4736 }, { 191,4736 }, { 192,4736 },
 { 193,4736 }, { 194,4736 }, { 195,4736 }, { 196,4736 }, { 197,4736 },
 { 198,4736 }, { 199,4736 }, { 200,4736 }, { 201,4736 }, { 202,4736 },

 { 203,4736 }, { 204,4736 }, { 205,4736 }, { 206,4736 }, { 207,4736 },
 { 208,4736 }, { 209,4736 }, { 210,4736 }, { 211,4736 }, { 212,4736 },
 { 213,4736 }, { 214,4736 }, { 215,4736 }, { 216,4736 }, { 217,4736 },
 { 218,4736 }, { 219,4736 }, { 220,4736 }, { 221,4736 }, { 222,4736 },
 { 223,4736 }, { 224,4736 }, { 225,4736 }, { 226,4736 }, { 227,4736 },
 { 228,4736 }, { 229,4736 }, { 230,4736 }, { 231,4736 }, { 232,4736 },
 { 233,4736 }, { 234,4736 }, { 235,4736 }, { 236,4736 }, { 237,4736 },
 { 238,4736 }, { 239,4736 }, { 240,4736 }, { 241,4736 }, { 242,4736 },
 { 243,4736 }, { 244,4736 }, { 245,4736 }, { 246,4736 }, { 247,4736 },
 { 248,4736 }, { 249,4736 }, { 250,4736 }, { 251,4736 }, { 252,4736 },

 { 253,4736 }, { 254,4736 }, { 255,4736 }, { 256,4736 }, {   0,   0 },
 {   0,20934 }, {   1,4478 }, {   2,4478 }, {   3,4478 }, {   4,4478 },
 {   5,4478 }, {   6,4478 }, {   7,4478 }, {   8,4478 }, {   9,4478 },
 {  10,4478 }, {  11,4478 }, {  12,4478 }, {  13,4478 }, {  14,4478 },
 {  15,4478 }, {  16,4478 }, {  17,4478 }, {  18,4478 }, {  19,4478 },
 {  20,4478 }, {  21,4478 }, {  22,4478 }, {  23,4478 }, {  24,4478 },
 {  25,4478 }, {  26,4478 }, {  27,4478 }, {  28,4478 }, {  29,4478 },
 {  30,4478 }, {  31,4478 }, {  32,4478 }, {  33,4478 }, {  34,1357 },
 {  35,4478 }, {  36,4478 }, {  37,4478 }, {  38,4478 }, {  39,4478 },
 {  40,4478 }, {  41,4478 }, {  42,4478 }, {  43,4478 }, {  44,4478 },

 {  45,4478 }, {  46,4478 }, {  47,4478 }, {  48,4478 }, {  49,4478 },
 {  50,4478 }, {  51,4478 }, {  52,4478 }, {  53,4478 }, {  54,4478 },
 {  55,4478 }, {  56,4478 }, {  57,4478 }, {  58,4478 }, {  59,4478 },
 {  60,4478 }, {  61,4478 }, {  62,4478 }, {  63,4478 }, {  64,4478 },
 {  65,4478 }, {  66,4478 }, {  67,4478 }, {  68,4478 }, {  69,4478 },
 {  70,4478 }, {  71,4478 }, {  72,4478 }, {  73,4478 }, {  74,4478 },
 {  75,4478 }, {  76,4478 }, {  77,4478 }, {  78,4478 }, {  79,4478 },
 {  80,4478 }, {  81,4478 }, {  82,4478 }, {  83,4478 }, {  84,4478 },
 {  85,4478 }, {  86,4478 }, {  87,4478 }, {  88,4478 }, {  89,4478 },
 {  90,4478 }, {  91,4478 }, {  92,4478 }, {  93,4478 }, {  94,4478 },

 {  95,4478 }, {  96,4478 }, {  97,4478 }, {  98,4478 }, {  99,4478 },
 { 100,4478 }, { 101,4478 }, { 102,4478 }, { 103,4478 }, { 104,4478 },
 { 105,4478 }, { 106,4478 }, { 107,4478 }, { 108,4478 }, { 109,4478 },
 { 110,4478 }, { 111,4478 }, { 112,4478 }, { 113,4478 }, { 114,4478 },
 { 115,4478 }, { 116,4478 }, { 117,4478 }, { 118,4478 }, { 119,4478 },
 { 120,4478 }, { 121,4478 }, { 122,4478 }, { 123,4478 }, { 124,4478 },
 { 125,4478 }, { 126,4478 }, { 127,4478 }, { 128,4478 }, { 129,4478 },
 { 130,4478 }, { 131,4478 }, { 132,4478 }, { 133,4478 }, { 134,4478 },
 { 135,4478 }, { 136,4478 }, { 137,4478 }, { 138,4478 }, { 139,4478 },
 { 140,4478 }, { 141,4478 }, { 142,4478 }, { 143,4478 }, { 144,4478 },

 { 145,4478 }, { 146,4478 }, { 147,4478 }, { 148,4478 }, { 149,4478 },
 { 150,4478 }, { 151,4478 }, { 152,4478 }, { 153,4478 }, { 154,4478 },
 { 155,4478 }, { 156,4478 }, { 157,4478 }, { 158,4478 }, { 159,4478 },
 { 160,4478 }, { 161,4478 }, { 162,4478 }, { 163,4478 }, { 164,4478 },
 { 165,4478 }, { 166,4478 }, { 167,4478 }, { 168,4478 }, { 169,4478 },
 { 170,4478 }, { 171,4478 }, { 172,4478 }, { 173,4478 }, { 174,4478 },
 { 175,4478 }, { 176,4478 }, { 177,4478 }, { 178,4478 }, { 179,4478 },
 { 180,4478 }, { 181,4478 }, { 182,4478 }, { 183,4478 }, { 184,4478 },
 { 185,4478 }, { 186,4478 }, { 187,4478 }, { 188,4478 }, { 189,4478 },
 { 190,4478 }, { 191,4478 }, { 192,4478 }, { 193,4478 }, { 194,4478 },

 { 195,4478 }, { 196,4478 }, { 197,4478 }, { 198,4478 }, { 199,4478 },
 { 200,4478 }, { 201,4478 }, { 202,4478 }, { 203,4478 }, { 204,4478 },
 { 205,4478 }, { 206,4478 }, { 207,4478 }, { 208,4478 }, { 209,4478 },
 { 210,4478 }, { 211,4478 }, { 212,4478 }, { 213,4478 }, { 214,4478 },
 { 215,4478 }, { 216,4478 }, { 217,4478 }, { 218,4478 }, { 219,4478 },
 { 220,4478 }, { 221,4478 }, { 222,4478 }, { 223,4478 }, { 224,4478 },
 { 225,4478 }, { 226,4478 }, { 227,4478 }, { 228,4478 }, { 229,4478 },
 { 230,4478 }, { 231,4478 }, { 232,4478 }, { 233,4478 }, { 234,4478 },
 { 235,4478 }, { 236,4478 }, { 237,4478 }, { 238,4478 }, { 239,4478 },
 { 240,4478 }, { 241,4478 }, { 242,4478 }, { 243,4478 }, { 244,4478 },

 { 245,4478 }, { 246,4478 }, { 247,4478 }, { 248,4478 }, { 249,4478 },
 { 250,4478 }, { 251,4478 }, { 252,4478 }, { 253,4478 }, { 254,4478 },
 { 255,4478 }, { 256,4478 }, {   0,   0 }, {   0,20676 }, {   1,4736 },
 {   2,4736 }, {   3,4736 }, {   4,4736 }, {   5,4736 }, {   6,4736 },
 {   7,4736 }, {   8,4736 }, {   9,4736 }, {  10,4736 }, {  11,4736 },
 {  12,4736 }, {  13,4736 }, {  14,4736 }, {  15,4736 }, {  16,4736 },
 {  17,4736 }, {  18,4736 }, {  19,4736 }, {  20,4736 }, {  21,4736 },
 {  22,4736 }, {  23,4736 }, {  24,4736 }, {  25,4736 }, {  26,4736 },
 {  27,4736 }, {  28,4736 }, {  29,4736 }, {  30,4736 }, {  31,4736 },
 {  32,4736 }, {  33,4736 }, {  34,4736 }, {  35,4736 }, {  36,4736 },

 {  37,4736 }, {  38,4736 }, {  39,1090 }, {  40,4736 }, {  41,4736 },
 {  42,4736 }, {  43,4736 }, {  44,4736 }, {  45,4736 }, {  46,4736 },
 {  47,4736 }, {  48,4736 }, {  49,4736 }, {  50,4736 }, {  51,4736 },
 {  52,4736 }, {  53,4736 }, {  54,4736 }, {  55,4736 }, {  56,4736 },
 {  57,4736 }, {  58,4736 }, {  59,4736 }, {  60,4736 }, {  61,4736 },
 {  62,4736 }, {  63,4736 }, {  64,4736 }, {  65,4736 }, {  66,4736 },
 {  67,4736 }, {  68,4736 }, {  69,4736 }, {  70,4736 }, {  71,4736 },
 {  72,4736 }, {  73,4736 }, {  74,4736 }, {  75,4736 }, {  76,4736 },
 {  77,4736 }, {  78,4736 }, {  79,4736 }, {  80,4736 }, {  81,4736 },
 {  82,4736 }, {  83,4736 }, {  84,4736 }, {  85,4736 }, {  86,4736 },

 {  87,4736 }, {  88,4736 }, {  89,4736 }, {  90,4736 }, {  91,4736 },
 {  92,4736 }, {  93,4736 }, {  94,4736 }, {  95,4736 }, {  96,4736 },
 {  97,4736 }, {  98,4736 }, {  99,4736 }, { 100,4736 }, { 101,4736 },
 { 102,4736 }, { 103,4736 }, { 104,4736 }, { 105,4736 }, { 106,4736 },
 { 107,4736 }, { 108,4736 }, { 109,4736 }, { 110,4736 }, { 111,4736 },
 { 112,4736 }, { 113,4736 }, { 114,4736 }, { 115,4736 }, { 116,4736 },
 { 117,4736 }, { 118,4736 }, { 119,4736 }, { 120,4736 }, { 121,4736 },
 { 122,4736 }, { 123,4736 }, { 124,4736 }, { 125,4736 }, { 126,4736 },
 { 127,4736 }, { 128,4736 }, { 129,4736 }, { 130,4736 }, { 131,4736 },
 { 132,4736 }, { 133,4736 }, { 134,4736 }, { 135,4736 }, { 136,4736 },

 { 137,4736 }, { 138,4736 }, { 139,4736 }, { 140,4736 }, { 141,4736 },
 { 142,4736 }, { 143,4736 }, { 144,4736 }, { 145,4736 }, { 146,4736 },
 { 147,4736 }, { 148,4736 }, { 149,4736 }, { 150,4736 }, { 151,4736 },
 { 152,4736 }, { 153,4736 }, { 154,4736 }, { 155,4736 }, { 156,4736 },
 { 157,4736 }, { 158,4736 }, { 159,4736 }, { 160,4736 }, { 161,4736 },
 { 162,4736 }, { 163,4736 }, { 164,4736 }, { 165,4736 }, { 166,4736 },
 { 167,4736 }, { 168,4736 }, { 169,4736 }, { 170,4736 }, { 171,4736 },
 { 172,4736 }, { 173,4736 }, { 174,4736 }, { 175,4736 }, { 176,4736 },
 { 177,4736 }, { 178,4736 }, { 179,4736 }, { 180,4736 }, { 181,4736 },
 { 182,4736 }, { 183,4736 }, { 184,4736 }, { 185,4736 }, { 186,4736 },

 { 187,4736 }, { 188,4736 }, { 189,4736 }, { 190,4736 }, { 191,4736 },
 { 192,4736 }, { 193,4736 }, { 194,4736 }, { 195,4736 }, { 196,4736 },
 { 197,4736 }, { 198,4736 }, { 199,4736 }, { 200,4736 }, { 201,4736 },
 { 202,4736 }, { 203,4736 }, { 204,4736 }, { 205,4736 }, { 206,4736 },
 { 207,4736 }, { 208,4736 }, { 209,4736 }, { 210,4736 }, { 211,4736 },
 { 212,4736 }, { 213,4736 }, { 214,4736 }, { 215,4736 }, { 216,4736 },
 { 217,4736 }, { 218,4736 }, { 219,4736 }, { 220,4736 }, { 221,4736 },
 { 222,4736 }, { 223,4736 }, { 224,4736 }, { 225,4736 }, { 226,4736 },
 { 227,4736 }, { 228,4736 }, { 229,4736 }, { 230,4736 }, { 231,4736 },
 { 232,4736 }, { 233,4736 }, { 234,4736 }, { 235,4736 }, { 236,4736 },

 { 237,4736 }, { 238,4736 }, { 239,4736 }, { 240,4736 }, { 241,4736 },
 { 242,4736 }, { 243,4736 }, { 244,4736 }, { 245,4736 }, { 246,4736 },
 { 247,4736 }, { 248,4736 }, { 249,4736 }, { 250,4736 }, { 251,4736 },
 { 252,4736 }, { 253,4736 }, { 254,4736 }, { 255,4736 }, { 256,4736 },
 {   0,   0 }, {   0,20418 }, {   1,4478 }, {   2,4478 }, {   3,4478 },
 {   4,4478 }, {   5,4478 }, {   6,4478 }, {   7,4478 }, {   8,4478 },
 {   9,4478 }, {  10,4478 }, {  11,4478 }, {  12,4478 }, {  13,4478 },
 {  14,4478 }, {  15,4478 }, {  16,4478 }, {  17,4478 }, {  18,4478 },
 {  19,4478 }, {  20,4478 }, {  21,4478 }, {  22,4478 }, {  23,4478 },
 {  24,4478 }, {  25,4478 }, {  26,4478 }, {  27,4478 }, {  28,4478 },

 {  29,4478 }, {  30,4478 }, {  31,4478 }, {  32,4478 }, {  33,4478 },
 {  34,4478 }, {  35,4478 }, {  36,4478 }, {  37,4478 }, {  38,4478 },
 {  39, 832 }, {  40,4478 }, {  41,4478 }, {  42,4478 }, {  43,4478 },
 {  44,4478 }, {  45,4478 }, {  46,4478 }, {  47,4478 }, {  48,4478 },
 {  49,4478 }, {  50,4478 }, {  51,4478 }, {  52,4478 }, {  53,4478 },
 {  54,4478 }, {  55,4478 }, {  56,4478 }, {  57,4478 }, {  58,4478 },
 {  59,4478 }, {  60,4478 }, {  61,4478 }, {  62,4478 }, {  63,4478 },
 {  64,4478 }, {  65,4478 }, {  66,4478 }, {  67,4478 }, {  68,4478 },
 {  69,4478 }, {  70,4478 }, {  71,4478 }, {  72,4478 }, {  73,4478 },
 {  74,4478 }, {  75,4478 }, {  76,4478 }, {  77,4478 }, {  78,4478 },

 {  79,4478 }, {  80,4478 }, {  81,4478 }, {  82,4478 }, {  83,4478 },
 {  84,4478 }, {  85,4478 }, {  86,4478 }, {  87,4478 }, {  88,4478 },
 {  89,4478 }, {  90,4478 }, {  91,4478 }, {  92,4478 }, {  93,4478 },
 {  94,4478 }, {  95,4478 }, {  96,4478 }, {  97,4478 }, {  98,4478 },
 {  99,4478 }, { 100,4478 }, { 101,4478 }, { 102,4478 }, { 103,4478 },
 { 104,4478 }, { 105,4478 }, { 106,4478 }, { 107,4478 }, { 108,4478 },
 { 109,4478 }, { 110,4478 }, { 111,4478 }, { 112,4478 }, { 113,4478 },
 { 114,4478 }, { 115,4478 }, { 116,4478 }, { 117,4478 }, { 118,4478 },
 { 119,4478 }, { 120,4478 }, { 121,4478 }, { 122,4478 }, { 123,4478 },
 { 124,4478 }, { 125,4478 }, { 126,4478 }, { 127,4478 }, { 128,4478 },

 { 129,4478 }, { 130,4478 }, { 131,4478 }, { 132,4478 }, { 133,4478 },
 { 134,4478 }, { 135,4478 }, { 136,4478 }, { 137,4478 }, { 138,4478 },
 { 139,4478 }, { 140,4478 }, { 141,4478 }, { 142,4478 }, { 143,4478 },
 { 144,4478 }, { 145,4478 }, { 146,4478 }, { 147,4478 }, { 148,4478 },
 { 149,4478 }, { 150,4478 }, { 151,4478 }, { 152,4478 }, { 153,4478 },
 { 154,4478 }, { 155,4478 }, { 156,4478 }, { 157,4478 }, { 158,4478 },
 { 159,4478 }, { 160,4478 }, { 161,4478 }, { 162,4478 }, { 163,4478 },
 { 164,4478 }, { 165,4478 }, { 166,4478 }, { 167,4478 }, { 168,4478 },
 { 169,4478 }, { 170,4478 }, { 171,4478 }, { 172,4478 }, { 173,4478 },
 { 174,4478 }, { 175,4478 }, { 176,4478 }, { 177,4478 }, { 178,4478 },

 { 179,4478 }, { 180,4478 }, { 181,4478 }, { 182,4478 }, { 183,4478 },
 { 184,4478 }, { 185,4478 }, { 186,4478 }, { 187,4478 }, { 188,4478 },
 { 189,4478 }, { 190,4478 }, { 191,4478 }, { 192,4478 }, { 193,4478 },
 { 194,4478 }, { 195,4478 }, { 196,4478 }, { 197,4478 }, { 198,4478 },
 { 199,4478 }, { 200,4478 }, { 201,4478 }, { 202,4478 }, { 203,4478 },
 { 204,4478 }, { 205,4478 }, { 206,4478 }, { 207,4478 }, { 208,4478 },
 { 209,4478 }, { 210,4478 }, { 211,4478 }, { 212,4478 }, { 213,4478 },
 { 214,4478 }, { 215,4478 }, { 216,4478 }, { 217,4478 }, { 218,4478 },
 { 219,4478 }, { 220,4478 }, { 221,4478 }, { 222,4478 }, { 223,4478 },
 { 224,4478 }, { 225,4478 }, { 226,4478 }, { 227,4478 }, { 228,4478 },

 { 229,4478 }, { 230,4478 }, { 231,4478 }, { 232,4478 }, { 233,4478 },
 { 234,4478 }, { 235,4478 }, { 236,4478 }, { 237,4478 }, { 238,4478 },
 { 239,4478 }, { 240,4478 }, { 241,4478 }, { 242,4478 }, { 243,4478 },
 { 244,4478 }, { 245,4478 }, { 246,4478 }, { 247,4478 }, { 248,4478 },
 { 249,4478 }, { 250,4478 }, { 251,4478 }, { 252,4478 }, { 253,4478 },
 { 254,4478 }, { 255,4478 }, { 256,4478 }, {   0,   0 }, {   0,20160 },
 {   1, 593 }, {   2, 593 }, {   3, 593 }, {   4, 593 }, {   5, 593 },
 {   6, 593 }, {   7, 593 }, {   8, 593 }, {   9, 593 }, {  10, 597 },
 {  11, 593 }, {  12, 593 }, {  13, 593 }, {  14, 593 }, {  15, 593 },
 {  16, 593 }, {  17, 593 }, {  18, 593 }, {  19, 593 }, {  20, 593 },

 {  21, 593 }, {  22, 593 }, {  23, 593 }, {  24, 593 }, {  25, 593 },
 {  26, 593 }, {  27, 593 }, {  28, 593 }, {  29, 593 }, {  30, 593 },
 {  31, 593 }, {  32, 593 }, {  33, 593 }, {  34, 593 }, {  35, 593 },
 {  36, 593 }, {  37, 593 }, {  38, 593 }, {  39, 593 }, {  40, 593 },
 {  41, 593 }, {  42, 593 }, {  43, 593 }, {  44, 593 }, {  45, 593 },
 {  46, 593 }, {  47, 593 }, {  48, 593 }, {  49, 593 }, {  50, 593 },
 {  51, 593 }, {  52, 593 }, {  53, 593 }, {  54, 593 }, {  55, 593 },
 {  56, 593 }, {  57, 593 }, {  58, 593 }, {  59, 593 }, {  60, 593 },
 {  61, 593 }, {  62, 593 }, {  63, 593 }, {  64, 593 }, {  65, 593 },
 {  66, 593 }, {  67, 593 }, {  68, 593 }, {  69, 593 }, {  70, 593 },

 {  71, 593 }, {  72, 593 }, {  73, 593 }, {  74, 593 }, {  75, 593 },
 {  76, 593 }, {  77, 593 }, {  78, 593 }, {  79, 593 }, {  80, 593 },
 {  81, 593 }, {  82, 593 }, {  83, 593 }, {  84, 593 }, {  85, 593 },
 {  86, 593 }, {  87, 593 }, {  88, 593 }, {  89, 593 }, {  90, 593 },
 {  91, 593 }, {  92, 637 }, {  93, 593 }, {  94, 593 }, {  95, 593 },
 {  96, 593 }, {  97, 593 }, {  98, 593 }, {  99, 593 }, { 100, 593 },
 { 101, 593 }, { 102, 593 }, { 103, 593 }, { 104, 593 }, { 105, 593 },
 { 106, 593 }, { 107, 593 }, { 108, 593 }, { 109, 593 }, { 110, 593 },
 { 111, 593 }, { 112, 593 }, { 113, 593 }, { 114, 593 }, { 115, 593 },
 { 116, 593 }, { 117, 593 }, { 118, 593 }, { 119, 593 }, { 120, 593 },

 { 121, 593 }, { 122, 593 }, { 123, 593 }, { 124, 593 }, { 125, 593 },
 { 126, 593 }, { 127, 593 }, { 128, 593 }, { 129, 593 }, { 130, 593 },
 { 131, 593 }, { 132, 593 }, { 133, 593 }, { 134, 593 }, { 135, 593 },
 { 136, 593 }, { 137, 593 }, { 138, 593 }, { 139, 593 }, { 140, 593 },
 { 141, 593 }, { 142, 593 }, { 143, 593 }, { 144, 593 }, { 145, 593 },
 { 146, 593 }, { 147, 593 }, { 148, 593 }, { 149, 593 }, { 150, 593 },
 { 151, 593 }, { 152, 593 }, { 153, 593 }, { 154, 593 }, { 155, 593 },
 { 156, 593 }, { 157, 593 }, { 158, 593 }, { 159, 593 }, { 160, 593 },
 { 161, 593 }, { 162, 593 }, { 163, 593 }, { 164, 593 }, { 165, 593 },
 { 166, 593 }, { 167, 593 }, { 168, 593 }, { 169, 593 }, { 170, 593 },

 { 171, 593 }, { 172, 593 }, { 173, 593 }, { 174, 593 }, { 175, 593 },
 { 176, 593 }, { 177, 593 }, { 178, 593 }, { 179, 593 }, { 180, 593 },
 { 181, 593 }, { 182, 593 }, { 183, 593 }, { 184, 593 }, { 185, 593 },
 { 186, 593 }, { 187, 593 }, { 188, 593 }, { 189, 593 }, { 190, 593 },
 { 191, 593 }, { 192, 593 }, { 193, 593 }, { 194, 593 }, { 195, 593 },
 { 196, 593 }, { 197, 593 }, { 198, 593 }, { 199, 593 }, { 200, 593 },
 { 201, 593 }, { 202, 593 }, { 203, 593 }, { 204, 593 }, { 205, 593 },
 { 206, 593 }, { 207, 593 }, { 208, 593 }, { 209, 593 }, { 210, 593 },
 { 211, 593 }, { 212, 593 }, { 213, 593 }, { 214, 593 }, { 215, 593 },
 { 216, 593 }, { 217, 593 }, { 218, 593 }, { 219, 593 }, { 220, 593 },

 { 221, 593 }, { 222, 593 }, { 223, 593 }, { 224, 593 }, { 225, 593 },
 { 226, 593 }, { 227, 593 }, { 228, 593 }, { 229, 593 }, { 230, 593 },
 { 231, 593 }, { 232, 593 }, { 233, 593 }, { 234, 593 }, { 235, 593 },
 { 236, 593 }, { 237, 593 }, { 238, 593 }, { 239, 593 }, { 240, 593 },
 { 241, 593 }, { 242, 593 }, { 243, 593 }, { 244, 593 }, { 245, 593 },
 { 246, 593 }, { 247, 593 }, { 248, 593 }, { 249, 593 }, { 250, 593 },
 { 251, 593 }, { 252, 593 }, { 253, 593 }, { 254, 593 }, { 255, 593 },
 { 256, 593 }, {   0,   0 }, {   0,19902 }, {   1, 335 }, {   2, 335 },
 {   3, 335 }, {   4, 335 }, {   5, 335 }, {   6, 335 }, {   7, 335 },
 {   8, 335 }, {   9, 335 }, {  10, 339 }, {  11, 335 }, {  12, 335 },

 {  13, 335 }, {  14, 335 }, {  15, 335 }, {  16, 335 }, {  17, 335 },
 {  18, 335 }, {  19, 335 }, {  20, 335 }, {  21, 335 }, {  22, 335 },
 {  23, 335 }, {  24, 335 }, {  25, 335 }, {  26, 335 }, {  27, 335 },
 {  28, 335 }, {  29, 335 }, {  30, 335 }, {  31, 335 }, {  32, 335 },
 {  33, 335 }, {  34, 335 }, {  35, 335 }, {  36, 335 }, {  37, 335 },
 {  38, 335 }, {  39, 335 }, {  40, 335 }, {  41, 335 }, {  42, 335 },
 {  43, 335 }, {  44, 335 }, {  45, 335 }, {  46, 335 }, {  47, 335 },
 {  48, 335 }, {  49, 335 }, {  50, 335 }, {  51, 335 }, {  52, 335 },
 {  53, 335 }, {  54, 335 }, {  55, 335 }, {  56, 335 }, {  57, 335 },
 {  58, 335 }, {  59, 335 }, {  60, 335 }, {  61, 335 }, {  62, 335 },

 {  63, 335 }, {  64, 335 }, {  65, 335 }, {  66, 335 }, {  67, 335 },
 {  68, 335 }, {  69, 335 }, {  70, 335 }, {  71, 335 }, {  72, 335 },
 {  73, 335 }, {  74, 335 }, {  75, 335 }, {  76, 335 }, {  77, 335 },
 {  78, 335 }, {  79, 335 }, {  80, 335 }, {  81, 335 }, {  82, 335 },
 {  83, 335 }, {  84, 335 }, {  85, 335 }, {  86, 335 }, {  87, 335 },
 {  88, 335 }, {  89, 335 }, {  90, 335 }, {  91, 335 }, {  92, 379 },
 {  93, 335 }, {  94, 335 }, {  95, 335 }, {  96, 335 }, {  97, 335 },
 {  98, 335 }, {  99, 335 }, { 100, 335 }, { 101, 335 }, { 102, 335 },
 { 103, 335 }, { 104, 335 }, { 105, 335 }, { 106, 335 }, { 107, 335 },
 { 108, 335 }, { 109, 335 }, { 110, 335 }, { 111, 335 }, { 112, 335 },

 { 113, 335 }, { 114, 335 }, { 115, 335 }, { 116, 335 }, { 117, 335 },
 { 118, 335 }, { 119, 335 }, { 120, 335 }, { 121, 335 }, { 122, 335 },
 { 123, 335 }, { 124, 335 }, { 125, 335 }, { 126, 335 }, { 127, 335 },
 { 128, 335 }, { 129, 335 }, { 130, 335 }, { 131, 335 }, { 132, 335 },
 { 133, 335 }, { 134, 335 }, { 135, 335 }, { 136, 335 }, { 137, 335 },
 { 138, 335 }, { 139, 335 }, { 140, 335 }, { 141, 335 }, { 142, 335 },
 { 143, 335 }, { 144, 335 }, { 145, 335 }, { 146, 335 }, { 147, 335 },
 { 148, 335 }, { 149, 335 }, { 150, 335 }, { 151, 335 }, { 152, 335 },
 { 153, 335 }, { 154, 335 }, { 155, 335 }, { 156, 335 }, { 157, 335 },
 { 158, 335 }, { 159, 335 }, { 160, 335 }, { 161, 335 }, { 162, 335 },

 { 163, 335 }, { 164, 335 }, { 165, 335 }, { 166, 335 }, { 167, 335 },
 { 168, 335 }, { 169, 335 }, { 170, 335 }, { 171, 335 }, { 172, 335 },
 { 173, 335 }, { 174, 335 }, { 175, 335 }, { 176, 335 }, { 177, 335 },
 { 178, 335 }, { 179, 335 }, { 180, 335 }, { 181, 335 }, { 182, 335 },
 { 183, 335 }, { 184, 335 }, { 185, 335 }, { 186, 335 }, { 187, 335 },
 { 188, 335 }, { 189, 335 }, { 190, 335 }, { 191, 335 }, { 192, 335 },
 { 193, 335 }, { 194, 335 }, { 195, 335 }, { 196, 335 }, { 197, 335 },
 { 198, 335 }, { 199, 335 }, { 200, 335 }, { 201, 335 }, { 202, 335 },
 { 203, 335 }, { 204, 335 }, { 205, 335 }, { 206, 335 }, { 207, 335 },
 { 208, 335 }, { 209, 335 }, { 210, 335 }, { 211, 335 }, { 212, 335 },

 { 213, 335 }, { 214, 335 }, { 215, 335 }, { 216, 335 }, { 217, 335 },
 { 218, 335 }, { 219, 335 }, { 220, 335 }, { 221, 335 }, { 222, 335 },
 { 223, 335 }, { 224, 335 }, { 225, 335 }, { 226, 335 }, { 227, 335 },
 { 228, 335 }, { 229, 335 }, { 230, 335 }, { 231, 335 }, { 232, 335 },
 { 233, 335 }, { 234, 335 }, { 235, 335 }, { 236, 335 }, { 237, 335 },
 { 238, 335 }, { 239, 335 }, { 240, 335 }, { 241, 335 }, { 242, 335 },
 { 243, 335 }, { 244, 335 }, { 245, 335 }, { 246, 335 }, { 247, 335 },
 { 248, 335 }, { 249, 335 }, { 250, 335 }, { 251, 335 }, { 252, 335 },
 { 253, 335 }, { 254, 335 }, { 255, 335 }, { 256, 335 }, {   0,  66 },
 {   0,19644 }, {   0,   1 }, {   0,19642 }, {   0,  38 }, {   0,19640 },

 {   0,   0 }, {   0,   1 }, {   0,19637 }, {   0,  54 }, {   0,19635 },
 {   0,   0 }, {   9,5320 }, {  10,5320 }, {   0,   0 }, {  12,5320 },
 {  13,5320 }, {   9,5315 }, {  10,5315 }, {   0,   0 }, {  12,5315 },
 {  13,5315 }, {   0,  13 }, {   0,19622 }, {   0,  53 }, {   0,19620 },
 {   0,   0 }, {   0,  53 }, {   0,19617 }, {   0,  16 }, {   0,19615 },
 {   0,   0 }, {   0,   6 }, {   0,19612 }, {   0,   0 }, {  32,5320 },
 {   0,   6 }, {   0,19608 }, {   0,   0 }, {   0,   0 }, {  32,5315 },
 {   0,  40 }, {   0,19603 }, {  33,5568 }, {   0,   0 }, {  35,5568 },
 {   0,   0 }, {  37,5568 }, {  38,5568 }, {   0,  54 }, {   0,19595 },
 {   0,   0 }, {  42,5568 }, {  43,5568 }, {   0,   0 }, {  45,5568 },

 {   0,   0 }, {  47,5568 }, {   0,  16 }, {   0,19586 }, {   0,  19 },
 {   0,19584 }, {   0,  18 }, {   0,19582 }, {   0,   0 }, {   0,  16 },
 {   0,19579 }, {   0,  41 }, {   0,19577 }, {   0,   0 }, {  60,5568 },
 {  61,5579 }, {  62,5568 }, {  63,5568 }, {  64,5568 }, {  42, 348 },
 {  34, 346 }, {   0,  25 }, {   0,19567 }, {  42,8677 }, {  47, 353 },
 {   0,  26 }, {   0,19563 }, {  33,5528 }, {   0,   0 }, {  35,5528 },
 {  58, 100 }, {  37,5528 }, {  38,5528 }, {  61, 102 }, {   0,   0 },
 {   0,   0 }, {  42,5528 }, {  43,5528 }, {   0,   0 }, {  45,5528 },
 {   0,   0 }, {  47,5528 }, {  39, 331 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  34, 320 }, {   0,   0 }, {  94,5568 }, {  39, 324 },

 {  96,5568 }, {   0,   0 }, {  45,9621 }, {   0,   0 }, {  60,5528 },
 {  61,5528 }, {  62,5528 }, {  63,5528 }, {  64,5528 }, {   0,  66 },
 {   0,19529 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  25 }, {   0,19523 }, {   0,  32 }, {   0,19521 }, {   0,  46 },
 {   0,19519 }, {   0,  45 }, {   0,19517 }, {   0,  47 }, {   0,19515 },
 {   0,   8 }, {   0,19513 }, {   0,   0 }, { 124,5568 }, {   0,   0 },
 { 126,5568 }, {   0,  14 }, {   0,19507 }, {   0,  12 }, {   0,19505 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5528 }, {   0,   0 },
 {  96,5528 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5552 }, {  49,5552 },
 {  50,5552 }, {  51,5552 }, {  52,5552 }, {  53,5552 }, {  54,5552 },
 {  55,5552 }, {  56,5552 }, {  57,5552 }, { 124,5528 }, {   0,   0 },
 { 126,5528 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5809 }, {  66,5809 }, {  67,5809 }, {  68,5809 }, {  69,5809 },
 {  70,5809 }, {  71,5809 }, {  72,5809 }, {  73,5809 }, {  74,5809 },
 {  75,5809 }, {  76,5809 }, {  77,5809 }, {  78,5809 }, {  79,5809 },
 {  80,5809 }, {  81,5809 }, {  82,5809 }, {  83,5809 }, {  84,5809 },
 {  85,5809 }, {  86,5809 }, {  87,5809 }, {  88,5809 }, {  89,5809 },

 {  90,5809 }, {  85,10766 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5809 }, {   0,   0 }, {  97,5809 }, {  98,5809 }, {  99,5809 },
 { 100,5809 }, { 101,5809 }, { 102,5809 }, { 103,5809 }, { 104,5809 },
 { 105,5809 }, { 106,5809 }, { 107,5809 }, { 108,5809 }, { 109,5809 },
 { 110,5809 }, { 111,5809 }, { 112,5809 }, { 113,5809 }, { 114,5809 },
 { 115,5809 }, { 116,5809 }, { 117,5809 }, { 118,5809 }, { 119,5809 },
 { 120,5809 }, { 121,5809 }, { 122,5809 }, { 117,10789 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5809 }, { 129,5809 },
 { 130,5809 }, { 131,5809 }, { 132,5809 }, { 133,5809 }, { 134,5809 },
 { 135,5809 }, { 136,5809 }, { 137,5809 }, { 138,5809 }, { 139,5809 },

 { 140,5809 }, { 141,5809 }, { 142,5809 }, { 143,5809 }, { 144,5809 },
 { 145,5809 }, { 146,5809 }, { 147,5809 }, { 148,5809 }, { 149,5809 },
 { 150,5809 }, { 151,5809 }, { 152,5809 }, { 153,5809 }, { 154,5809 },
 { 155,5809 }, { 156,5809 }, { 157,5809 }, { 158,5809 }, { 159,5809 },
 { 160,5809 }, { 161,5809 }, { 162,5809 }, { 163,5809 }, { 164,5809 },
 { 165,5809 }, { 166,5809 }, { 167,5809 }, { 168,5809 }, { 169,5809 },
 { 170,5809 }, { 171,5809 }, { 172,5809 }, { 173,5809 }, { 174,5809 },
 { 175,5809 }, { 176,5809 }, { 177,5809 }, { 178,5809 }, { 179,5809 },
 { 180,5809 }, { 181,5809 }, { 182,5809 }, { 183,5809 }, { 184,5809 },
 { 185,5809 }, { 186,5809 }, { 187,5809 }, { 188,5809 }, { 189,5809 },

 { 190,5809 }, { 191,5809 }, { 192,5809 }, { 193,5809 }, { 194,5809 },
 { 195,5809 }, { 196,5809 }, { 197,5809 }, { 198,5809 }, { 199,5809 },
 { 200,5809 }, { 201,5809 }, { 202,5809 }, { 203,5809 }, { 204,5809 },
 { 205,5809 }, { 206,5809 }, { 207,5809 }, { 208,5809 }, { 209,5809 },
 { 210,5809 }, { 211,5809 }, { 212,5809 }, { 213,5809 }, { 214,5809 },
 { 215,5809 }, { 216,5809 }, { 217,5809 }, { 218,5809 }, { 219,5809 },
 { 220,5809 }, { 221,5809 }, { 222,5809 }, { 223,5809 }, { 224,5809 },
 { 225,5809 }, { 226,5809 }, { 227,5809 }, { 228,5809 }, { 229,5809 },
 { 230,5809 }, { 231,5809 }, { 232,5809 }, { 233,5809 }, { 234,5809 },
 { 235,5809 }, { 236,5809 }, { 237,5809 }, { 238,5809 }, { 239,5809 },

 { 240,5809 }, { 241,5809 }, { 242,5809 }, { 243,5809 }, { 244,5809 },
 { 245,5809 }, { 246,5809 }, { 247,5809 }, { 248,5809 }, { 249,5809 },
 { 250,5809 }, { 251,5809 }, { 252,5809 }, { 253,5809 }, { 254,5809 },
 { 255,5809 }, {   0,  53 }, {   0,19272 }, {   0,  44 }, {   0,19270 },
 {   0,  11 }, {   0,19268 }, {   0,   0 }, {   0,   0 }, {   0,   7 },
 {   0,19264 }, {   0,   0 }, {   0,  53 }, {   0,19261 }, {   0,   4 },
 {   0,19259 }, {   0,  42 }, {   0,19257 }, {   0,  20 }, {   0,19255 },
 {   0,   0 }, {   0,  18 }, {   0,19252 }, {   0,  17 }, {   0,19250 },
 {   0,  18 }, {   0,19248 }, {   0,  28 }, {   0,19246 }, {   0,  34 },
 {   0,19244 }, {   0,  53 }, {   0,19242 }, {   0,  59 }, {   0,19240 },

 {  33,5205 }, {   0,   0 }, {  35,5205 }, {  34,  38 }, {  37,5205 },
 {  38,5205 }, {   0,  39 }, {   0,19232 }, {  39,  50 }, {  42,5205 },
 {  43,5205 }, {  33,5194 }, {  45,5205 }, {  35,5194 }, {  47,5205 },
 {  37,5194 }, {  38,5194 }, {  42,   0 }, {   0,  15 }, {   0,19220 },
 {  42,5194 }, {  43,5194 }, {  47,   5 }, {  45,5798 }, {   0,   0 },
 {  47,5194 }, {   0,   0 }, {  60,5205 }, {  61,5205 }, {  62,5205 },
 {  63,5205 }, {  64,5205 }, {  45,9291 }, {   0,  29 }, {   0,19205 },
 {   0,   0 }, {  45,13058 }, {   0,   0 }, {  60,5194 }, {  61,5194 },
 {  62,5194 }, {  63,5194 }, {  64,5194 }, {  46,-277 }, {   0,   0 },
 {  48,6037 }, {  49,6037 }, {  50,6037 }, {  51,6037 }, {  52,6037 },

 {  53,6037 }, {  54,6037 }, {  55,6037 }, {  56,6037 }, {  57,6037 },
 {   0,  30 }, {   0,19183 }, {   0,  23 }, {   0,19181 }, {   0,  24 },
 {   0,19179 }, {  94,5205 }, {   0,   0 }, {  96,5205 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  53 }, {   0,19171 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5194 }, {   0,   0 }, {  96,5194 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,5205 }, {   0,   0 }, { 126,5205 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  57 },

 {   0,19139 }, {  33,5104 }, { 124,5194 }, {  35,5104 }, { 126,5194 },
 {  37,5104 }, {  38,5104 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,6223 }, {  43,5104 }, {   0,   0 }, {  45,5104 }, {   0,   0 },
 {  47,5104 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5104 }, {  61,5104 },
 {  62,5104 }, {  63,5104 }, {  64,5104 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,6223 }, {   0,   0 }, {  48,6480 }, {  49,6480 },

 {  50,6480 }, {  51,6480 }, {  52,6480 }, {  53,6480 }, {  54,6480 },
 {  55,6480 }, {  56,6480 }, {  57,6480 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5104 }, {   0,   0 }, {  96,5104 },
 {  65,6737 }, {  66,6737 }, {  67,6737 }, {  68,6737 }, {  69,6994 },
 {  70,6737 }, {  71,6737 }, {  72,6737 }, {  73,6737 }, {  74,6737 },
 {  75,6737 }, {  76,6737 }, {  77,6737 }, {  78,6737 }, {  79,6737 },
 {  80,6737 }, {  81,6737 }, {  82,6737 }, {  83,6737 }, {  84,6737 },
 {  85,6737 }, {  86,6737 }, {  87,6737 }, {  88,6737 }, {  89,6737 },
 {  90,6737 }, {   0,   0 }, { 124,5104 }, {   0,   0 }, { 126,5104 },
 {  95,6737 }, {   0,   0 }, {  97,6737 }, {  98,6737 }, {  99,6737 },

 { 100,6737 }, { 101,6994 }, { 102,6737 }, { 103,6737 }, { 104,6737 },
 { 105,6737 }, { 106,6737 }, { 107,6737 }, { 108,6737 }, { 109,6737 },
 { 110,6737 }, { 111,6737 }, { 112,6737 }, { 113,6737 }, { 114,6737 },
 { 115,6737 }, { 116,6737 }, { 117,6737 }, { 118,6737 }, { 119,6737 },
 { 120,6737 }, { 121,6737 }, { 122,6737 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6737 }, { 129,6737 },
 { 130,6737 }, { 131,6737 }, { 132,6737 }, { 133,6737 }, { 134,6737 },
 { 135,6737 }, { 136,6737 }, { 137,6737 }, { 138,6737 }, { 139,6737 },
 { 140,6737 }, { 141,6737 }, { 142,6737 }, { 143,6737 }, { 144,6737 },
 { 145,6737 }, { 146,6737 }, { 147,6737 }, { 148,6737 }, { 149,6737 },

 { 150,6737 }, { 151,6737 }, { 152,6737 }, { 153,6737 }, { 154,6737 },
 { 155,6737 }, { 156,6737 }, { 157,6737 }, { 158,6737 }, { 159,6737 },
 { 160,6737 }, { 161,6737 }, { 162,6737 }, { 163,6737 }, { 164,6737 },
 { 165,6737 }, { 166,6737 }, { 167,6737 }, { 168,6737 }, { 169,6737 },
 { 170,6737 }, { 171,6737 }, { 172,6737 }, { 173,6737 }, { 174,6737 },
 { 175,6737 }, { 176,6737 }, { 177,6737 }, { 178,6737 }, { 179,6737 },
 { 180,6737 }, { 181,6737 }, { 182,6737 }, { 183,6737 }, { 184,6737 },
 { 185,6737 }, { 186,6737 }, { 187,6737 }, { 188,6737 }, { 189,6737 },
 { 190,6737 }, { 191,6737 }, { 192,6737 }, { 193,6737 }, { 194,6737 },
 { 195,6737 }, { 196,6737 }, { 197,6737 }, { 198,6737 }, { 199,6737 },

 { 200,6737 }, { 201,6737 }, { 202,6737 }, { 203,6737 }, { 204,6737 },
 { 205,6737 }, { 206,6737 }, { 207,6737 }, { 208,6737 }, { 209,6737 },
 { 210,6737 }, { 211,6737 }, { 212,6737 }, { 213,6737 }, { 214,6737 },
 { 215,6737 }, { 216,6737 }, { 217,6737 }, { 218,6737 }, { 219,6737 },
 { 220,6737 }, { 221,6737 }, { 222,6737 }, { 223,6737 }, { 224,6737 },
 { 225,6737 }, { 226,6737 }, { 227,6737 }, { 228,6737 }, { 229,6737 },
 { 230,6737 }, { 231,6737 }, { 232,6737 }, { 233,6737 }, { 234,6737 },
 { 235,6737 }, { 236,6737 }, { 237,6737 }, { 238,6737 }, { 239,6737 },
 { 240,6737 }, { 241,6737 }, { 242,6737 }, { 243,6737 }, { 244,6737 },
 { 245,6737 }, { 246,6737 }, { 247,6737 }, { 248,6737 }, { 249,6737 },

 { 250,6737 }, { 251,6737 }, { 252,6737 }, { 253,6737 }, { 254,6737 },
 { 255,6737 }, {   0,  53 }, {   0,18882 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  53 }, {   0,18871 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,4815 }, {   0,   0 }, {  35,4815 }, {   0,   0 }, {  37,4815 },
 {  38,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4815 },

 {  43,4815 }, {  33,4804 }, {  45,4815 }, {  35,4804 }, {  47,4815 },
 {  37,4804 }, {  38,4804 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,4804 }, {  43,4804 }, {   0,   0 }, {  45,4804 }, {   0,   0 },
 {  47,4804 }, {   0,   0 }, {  60,4815 }, {  61,6994 }, {  62,7005 },
 {  63,4815 }, {  64,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,4804 }, {  61,4804 },
 {  62,7061 }, {  63,4804 }, {  64,4804 }, {   0,   0 }, {   0,  53 },
 {   0,18804 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  94,4815 }, {   0,   0 }, {  96,4815 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,4804 }, {   0,   0 }, {  96,4804 },
 {   0,   0 }, {   0,  65 }, {   0,18772 }, {  33,4737 }, {   0,   0 },
 {  35,4737 }, {   0,   0 }, {  37,4737 }, {  38,4737 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4737 }, {  43,4737 }, {   0,   0 },
 {  45,4737 }, { 124,4815 }, {  47,4737 }, { 126,4815 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124,4804 }, {   0,   0 }, { 126,4804 },
 {  60,4737 }, {  61,7034 }, {  62,4737 }, {  63,4737 }, {  64,4737 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,7068 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,7068 }, {  49,7068 }, {  50,7068 }, {  51,7068 }, {  52,7068 },
 {  53,7068 }, {  54,7068 }, {  55,7068 }, {  56,7068 }, {  57,7068 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4737 },
 {   0,   0 }, {  96,4737 }, {  65,7068 }, {  66,7068 }, {  67,7068 },
 {  68,7068 }, {  69,7068 }, {  70,7068 }, {  71,7068 }, {  72,7068 },
 {  73,7068 }, {  74,7068 }, {  75,7068 }, {  76,7068 }, {  77,7068 },
 {  78,7068 }, {  79,7068 }, {  80,7068 }, {  81,7068 }, {  82,7068 },

 {  83,7068 }, {  84,7068 }, {  85,7068 }, {  86,7068 }, {  87,7068 },
 {  88,7068 }, {  89,7068 }, {  90,7068 }, {   0,   0 }, { 124,4737 },
 {   0,   0 }, { 126,4737 }, {  95,7068 }, {   0,   0 }, {  97,7068 },
 {  98,7068 }, {  99,7068 }, { 100,7068 }, { 101,7068 }, { 102,7068 },
 { 103,7068 }, { 104,7068 }, { 105,7068 }, { 106,7068 }, { 107,7068 },
 { 108,7068 }, { 109,7068 }, { 110,7068 }, { 111,7068 }, { 112,7068 },
 { 113,7068 }, { 114,7068 }, { 115,7068 }, { 116,7068 }, { 117,7068 },
 { 118,7068 }, { 119,7068 }, { 120,7068 }, { 121,7068 }, { 122,7068 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,7068 }, { 129,7068 }, { 130,7068 }, { 131,7068 }, { 132,7068 },

 { 133,7068 }, { 134,7068 }, { 135,7068 }, { 136,7068 }, { 137,7068 },
 { 138,7068 }, { 139,7068 }, { 140,7068 }, { 141,7068 }, { 142,7068 },
 { 143,7068 }, { 144,7068 }, { 145,7068 }, { 146,7068 }, { 147,7068 },
 { 148,7068 }, { 149,7068 }, { 150,7068 }, { 151,7068 }, { 152,7068 },
 { 153,7068 }, { 154,7068 }, { 155,7068 }, { 156,7068 }, { 157,7068 },
 { 158,7068 }, { 159,7068 }, { 160,7068 }, { 161,7068 }, { 162,7068 },
 { 163,7068 }, { 164,7068 }, { 165,7068 }, { 166,7068 }, { 167,7068 },
 { 168,7068 }, { 169,7068 }, { 170,7068 }, { 171,7068 }, { 172,7068 },
 { 173,7068 }, { 174,7068 }, { 175,7068 }, { 176,7068 }, { 177,7068 },
 { 178,7068 }, { 179,7068 }, { 180,7068 }, { 181,7068 }, { 182,7068 },

 { 183,7068 }, { 184,7068 }, { 185,7068 }, { 186,7068 }, { 187,7068 },
 { 188,7068 }, { 189,7068 }, { 190,7068 }, { 191,7068 }, { 192,7068 },
 { 193,7068 }, { 194,7068 }, { 195,7068 }, { 196,7068 }, { 197,7068 },
 { 198,7068 }, { 199,7068 }, { 200,7068 }, { 201,7068 }, { 202,7068 },
 { 203,7068 }, { 204,7068 }, { 205,7068 }, { 206,7068 }, { 207,7068 },
 { 208,7068 }, { 209,7068 }, { 210,7068 }, { 211,7068 }, { 212,7068 },
 { 213,7068 }, { 214,7068 }, { 215,7068 }, { 216,7068 }, { 217,7068 },
 { 218,7068 }, { 219,7068 }, { 220,7068 }, { 221,7068 }, { 222,7068 },
 { 223,7068 }, { 224,7068 }, { 225,7068 }, { 226,7068 }, { 227,7068 },
 { 228,7068 }, { 229,7068 }, { 230,7068 }, { 231,7068 }, { 232,7068 },

 { 233,7068 }, { 234,7068 }, { 235,7068 }, { 236,7068 }, { 237,7068 },
 { 238,7068 }, { 239,7068 }, { 240,7068 }, { 241,7068 }, { 242,7068 },
 { 243,7068 }, { 244,7068 }, { 245,7068 }, { 246,7068 }, { 247,7068 },
 { 248,7068 }, { 249,7068 }, { 250,7068 }, { 251,7068 }, { 252,7068 },
 { 253,7068 }, { 254,7068 }, { 255,7068 }, {   0,  65 }, {   0,18515 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,6811 }, {   0,   0 }, {   0,   0 }, {  39,-998 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6811 }, {  49,6811 }, {  50,6811 },
 {  51,6811 }, {  52,6811 }, {  53,6811 }, {  54,6811 }, {  55,6811 },
 {  56,6811 }, {  57,6811 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6811 },
 {  66,6811 }, {  67,6811 }, {  68,6811 }, {  69,6811 }, {  70,6811 },
 {  71,6811 }, {  72,6811 }, {  73,6811 }, {  74,6811 }, {  75,6811 },

 {  76,6811 }, {  77,6811 }, {  78,6811 }, {  79,6811 }, {  80,6811 },
 {  81,6811 }, {  82,6811 }, {  83,6811 }, {  84,6811 }, {  85,6811 },
 {  86,6811 }, {  87,6811 }, {  88,6811 }, {  89,6811 }, {  90,6811 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6811 },
 {   0,   0 }, {  97,6811 }, {  98,6811 }, {  99,6811 }, { 100,6811 },
 { 101,6811 }, { 102,6811 }, { 103,6811 }, { 104,6811 }, { 105,6811 },
 { 106,6811 }, { 107,6811 }, { 108,6811 }, { 109,6811 }, { 110,6811 },
 { 111,6811 }, { 112,6811 }, { 113,6811 }, { 114,6811 }, { 115,6811 },
 { 116,6811 }, { 117,6811 }, { 118,6811 }, { 119,6811 }, { 120,6811 },
 { 121,6811 }, { 122,6811 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,6811 }, { 129,6811 }, { 130,6811 },
 { 131,6811 }, { 132,6811 }, { 133,6811 }, { 134,6811 }, { 135,6811 },
 { 136,6811 }, { 137,6811 }, { 138,6811 }, { 139,6811 }, { 140,6811 },
 { 141,6811 }, { 142,6811 }, { 143,6811 }, { 144,6811 }, { 145,6811 },
 { 146,6811 }, { 147,6811 }, { 148,6811 }, { 149,6811 }, { 150,6811 },
 { 151,6811 }, { 152,6811 }, { 153,6811 }, { 154,6811 }, { 155,6811 },
 { 156,6811 }, { 157,6811 }, { 158,6811 }, { 159,6811 }, { 160,6811 },
 { 161,6811 }, { 162,6811 }, { 163,6811 }, { 164,6811 }, { 165,6811 },
 { 166,6811 }, { 167,6811 }, { 168,6811 }, { 169,6811 }, { 170,6811 },
 { 171,6811 }, { 172,6811 }, { 173,6811 }, { 174,6811 }, { 175,6811 },

 { 176,6811 }, { 177,6811 }, { 178,6811 }, { 179,6811 }, { 180,6811 },
 { 181,6811 }, { 182,6811 }, { 183,6811 }, { 184,6811 }, { 185,6811 },
 { 186,6811 }, { 187,6811 }, { 188,6811 }, { 189,6811 }, { 190,6811 },
 { 191,6811 }, { 192,6811 }, { 193,6811 }, { 194,6811 }, { 195,6811 },
 { 196,6811 }, { 197,6811 }, { 198,6811 }, { 199,6811 }, { 200,6811 },
 { 201,6811 }, { 202,6811 }, { 203,6811 }, { 204,6811 }, { 205,6811 },
 { 206,6811 }, { 207,6811 }, { 208,6811 }, { 209,6811 }, { 210,6811 },
 { 211,6811 }, { 212,6811 }, { 213,6811 }, { 214,6811 }, { 215,6811 },
 { 216,6811 }, { 217,6811 }, { 218,6811 }, { 219,6811 }, { 220,6811 },
 { 221,6811 }, { 222,6811 }, { 223,6811 }, { 224,6811 }, { 225,6811 },

 { 226,6811 }, { 227,6811 }, { 228,6811 }, { 229,6811 }, { 230,6811 },
 { 231,6811 }, { 232,6811 }, { 233,6811 }, { 234,6811 }, { 235,6811 },
 { 236,6811 }, { 237,6811 }, { 238,6811 }, { 239,6811 }, { 240,6811 },
 { 241,6811 }, { 242,6811 }, { 243,6811 }, { 244,6811 }, { 245,6811 },
 { 246,6811 }, { 247,6811 }, { 248,6811 }, { 249,6811 }, { 250,6811 },
 { 251,6811 }, { 252,6811 }, { 253,6811 }, { 254,6811 }, { 255,6811 },
 {   0,  65 }, {   0,18258 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,6554 }, {   0,   0 }, {   0,   0 },
 {  39,-1249 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6554 },
 {  49,6554 }, {  50,6554 }, {  51,6554 }, {  52,6554 }, {  53,6554 },
 {  54,6554 }, {  55,6554 }, {  56,6554 }, {  57,6554 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6554 }, {  66,6554 }, {  67,6554 }, {  68,6554 },

 {  69,6554 }, {  70,6554 }, {  71,6554 }, {  72,6554 }, {  73,6554 },
 {  74,6554 }, {  75,6554 }, {  76,6554 }, {  77,6554 }, {  78,6554 },
 {  79,6554 }, {  80,6554 }, {  81,6554 }, {  82,6554 }, {  83,6554 },
 {  84,6554 }, {  85,6554 }, {  86,6554 }, {  87,6554 }, {  88,6554 },
 {  89,6554 }, {  90,6554 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,6554 }, {   0,   0 }, {  97,6554 }, {  98,6554 },
 {  99,6554 }, { 100,6554 }, { 101,6554 }, { 102,6554 }, { 103,6554 },
 { 104,6554 }, { 105,6554 }, { 106,6554 }, { 107,6554 }, { 108,6554 },
 { 109,6554 }, { 110,6554 }, { 111,6554 }, { 112,6554 }, { 113,6554 },
 { 114,6554 }, { 115,6554 }, { 116,6554 }, { 117,6554 }, { 118,6554 },

 { 119,6554 }, { 120,6554 }, { 121,6554 }, { 122,6554 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6554 },
 { 129,6554 }, { 130,6554 }, { 131,6554 }, { 132,6554 }, { 133,6554 },
 { 134,6554 }, { 135,6554 }, { 136,6554 }, { 137,6554 }, { 138,6554 },
 { 139,6554 }, { 140,6554 }, { 141,6554 }, { 142,6554 }, { 143,6554 },
 { 144,6554 }, { 145,6554 }, { 146,6554 }, { 147,6554 }, { 148,6554 },
 { 149,6554 }, { 150,6554 }, { 151,6554 }, { 152,6554 }, { 153,6554 },
 { 154,6554 }, { 155,6554 }, { 156,6554 }, { 157,6554 }, { 158,6554 },
 { 159,6554 }, { 160,6554 }, { 161,6554 }, { 162,6554 }, { 163,6554 },
 { 164,6554 }, { 165,6554 }, { 166,6554 }, { 167,6554 }, { 168,6554 },

 { 169,6554 }, { 170,6554 }, { 171,6554 }, { 172,6554 }, { 173,6554 },
 { 174,6554 }, { 175,6554 }, { 176,6554 }, { 177,6554 }, { 178,6554 },
 { 179,6554 }, { 180,6554 }, { 181,6554 }, { 182,6554 }, { 183,6554 },
 { 184,6554 }, { 185,6554 }, { 186,6554 }, { 187,6554 }, { 188,6554 },
 { 189,6554 }, { 190,6554 }, { 191,6554 }, { 192,6554 }, { 193,6554 },
 { 194,6554 }, { 195,6554 }, { 196,6554 }, { 197,6554 }, { 198,6554 },
 { 199,6554 }, { 200,6554 }, { 201,6554 }, { 202,6554 }, { 203,6554 },
 { 204,6554 }, { 205,6554 }, { 206,6554 }, { 207,6554 }, { 208,6554 },
 { 209,6554 }, { 210,6554 }, { 211,6554 }, { 212,6554 }, { 213,6554 },
 { 214,6554 }, { 215,6554 }, { 216,6554 }, { 217,6554 }, { 218,6554 },

 { 219,6554 }, { 220,6554 }, { 221,6554 }, { 222,6554 }, { 223,6554 },
 { 224,6554 }, { 225,6554 }, { 226,6554 }, { 227,6554 }, { 228,6554 },
 { 229,6554 }, { 230,6554 }, { 231,6554 }, { 232,6554 }, { 233,6554 },
 { 234,6554 }, { 235,6554 }, { 236,6554 }, { 237,6554 }, { 238,6554 },
 { 239,6554 }, { 240,6554 }, { 241,6554 }, { 242,6554 }, { 243,6554 },
 { 244,6554 }, { 245,6554 }, { 246,6554 }, { 247,6554 }, { 248,6554 },
 { 249,6554 }, { 250,6554 }, { 251,6554 }, { 252,6554 }, { 253,6554 },
 { 254,6554 }, { 255,6554 }, {   0,  65 }, {   0,18001 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,6297 },
 {   0,   0 }, {   0,   0 }, {  39,-1504 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,6297 }, {  49,6297 }, {  50,6297 }, {  51,6297 },
 {  52,6297 }, {  53,6297 }, {  54,6297 }, {  55,6297 }, {  56,6297 },
 {  57,6297 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6297 }, {  66,6297 },
 {  67,6297 }, {  68,6297 }, {  69,6297 }, {  70,6297 }, {  71,6297 },
 {  72,6297 }, {  73,6297 }, {  74,6297 }, {  75,6297 }, {  76,6297 },
 {  77,6297 }, {  78,6297 }, {  79,6297 }, {  80,6297 }, {  81,6297 },
 {  82,6297 }, {  83,6297 }, {  84,6297 }, {  85,6297 }, {  86,6297 },
 {  87,6297 }, {  88,6297 }, {  89,6297 }, {  90,6297 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6297 }, {   0,   0 },
 {  97,6297 }, {  98,6297 }, {  99,6297 }, { 100,6297 }, { 101,6297 },
 { 102,6297 }, { 103,6297 }, { 104,6297 }, { 105,6297 }, { 106,6297 },
 { 107,6297 }, { 108,6297 }, { 109,6297 }, { 110,6297 }, { 111,6297 },

 { 112,6297 }, { 113,6297 }, { 114,6297 }, { 115,6297 }, { 116,6297 },
 { 117,6297 }, { 118,6297 }, { 119,6297 }, { 120,6297 }, { 121,6297 },
 { 122,6297 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,6297 }, { 129,6297 }, { 130,6297 }, { 131,6297 },
 { 132,6297 }, { 133,6297 }, { 134,6297 }, { 135,6297 }, { 136,6297 },
 { 137,6297 }, { 138,6297 }, { 139,6297 }, { 140,6297 }, { 141,6297 },
 { 142,6297 }, { 143,6297 }, { 144,6297 }, { 145,6297 }, { 146,6297 },
 { 147,6297 }, { 148,6297 }, { 149,6297 }, { 150,6297 }, { 151,6297 },
 { 152,6297 }, { 153,6297 }, { 154,6297 }, { 155,6297 }, { 156,6297 },
 { 157,6297 }, { 158,6297 }, { 159,6297 }, { 160,6297 }, { 161,6297 },

 { 162,6297 }, { 163,6297 }, { 164,6297 }, { 165,6297 }, { 166,6297 },
 { 167,6297 }, { 168,6297 }, { 169,6297 }, { 170,6297 }, { 171,6297 },
 { 172,6297 }, { 173,6297 }, { 174,6297 }, { 175,6297 }, { 176,6297 },
 { 177,6297 }, { 178,6297 }, { 179,6297 }, { 180,6297 }, { 181,6297 },
 { 182,6297 }, { 183,6297 }, { 184,6297 }, { 185,6297 }, { 186,6297 },
 { 187,6297 }, { 188,6297 }, { 189,6297 }, { 190,6297 }, { 191,6297 },
 { 192,6297 }, { 193,6297 }, { 194,6297 }, { 195,6297 }, { 196,6297 },
 { 197,6297 }, { 198,6297 }, { 199,6297 }, { 200,6297 }, { 201,6297 },
 { 202,6297 }, { 203,6297 }, { 204,6297 }, { 205,6297 }, { 206,6297 },
 { 207,6297 }, { 208,6297 }, { 209,6297 }, { 210,6297 }, { 211,6297 },

 { 212,6297 }, { 213,6297 }, { 214,6297 }, { 215,6297 }, { 216,6297 },
 { 217,6297 }, { 218,6297 }, { 219,6297 }, { 220,6297 }, { 221,6297 },
 { 222,6297 }, { 223,6297 }, { 224,6297 }, { 225,6297 }, { 226,6297 },
 { 227,6297 }, { 228,6297 }, { 229,6297 }, { 230,6297 }, { 231,6297 },
 { 232,6297 }, { 233,6297 }, { 234,6297 }, { 235,6297 }, { 236,6297 },
 { 237,6297 }, { 238,6297 }, { 239,6297 }, { 240,6297 }, { 241,6297 },
 { 242,6297 }, { 243,6297 }, { 244,6297 }, { 245,6297 }, { 246,6297 },
 { 247,6297 }, { 248,6297 }, { 249,6297 }, { 250,6297 }, { 251,6297 },
 { 252,6297 }, { 253,6297 }, { 254,6297 }, { 255,6297 }, {   0,  65 },
 {   0,17744 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,6040 }, {   0,   0 }, {  38,-1526 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6040 }, {  49,6040 },
 {  50,6040 }, {  51,6040 }, {  52,6040 }, {  53,6040 }, {  54,6040 },

 {  55,6040 }, {  56,6040 }, {  57,6040 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,6040 }, {  66,6040 }, {  67,6040 }, {  68,6040 }, {  69,6040 },
 {  70,6040 }, {  71,6040 }, {  72,6040 }, {  73,6040 }, {  74,6040 },
 {  75,6040 }, {  76,6040 }, {  77,6040 }, {  78,6040 }, {  79,6040 },
 {  80,6040 }, {  81,6040 }, {  82,6040 }, {  83,6040 }, {  84,6040 },
 {  85,6040 }, {  86,6040 }, {  87,6040 }, {  88,6040 }, {  89,6040 },
 {  90,6040 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,6040 }, {   0,   0 }, {  97,6040 }, {  98,6040 }, {  99,6040 },
 { 100,6040 }, { 101,6040 }, { 102,6040 }, { 103,6040 }, { 104,6040 },

 { 105,6040 }, { 106,6040 }, { 107,6040 }, { 108,6040 }, { 109,6040 },
 { 110,6040 }, { 111,6040 }, { 112,6040 }, { 113,6040 }, { 114,6040 },
 { 115,6040 }, { 116,6040 }, { 117,6040 }, { 118,6040 }, { 119,6040 },
 { 120,6040 }, { 121,6040 }, { 122,6040 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6040 }, { 129,6040 },
 { 130,6040 }, { 131,6040 }, { 132,6040 }, { 133,6040 }, { 134,6040 },
 { 135,6040 }, { 136,6040 }, { 137,6040 }, { 138,6040 }, { 139,6040 },
 { 140,6040 }, { 141,6040 }, { 142,6040 }, { 143,6040 }, { 144,6040 },
 { 145,6040 }, { 146,6040 }, { 147,6040 }, { 148,6040 }, { 149,6040 },
 { 150,6040 }, { 151,6040 }, { 152,6040 }, { 153,6040 }, { 154,6040 },

 { 155,6040 }, { 156,6040 }, { 157,6040 }, { 158,6040 }, { 159,6040 },
 { 160,6040 }, { 161,6040 }, { 162,6040 }, { 163,6040 }, { 164,6040 },
 { 165,6040 }, { 166,6040 }, { 167,6040 }, { 168,6040 }, { 169,6040 },
 { 170,6040 }, { 171,6040 }, { 172,6040 }, { 173,6040 }, { 174,6040 },
 { 175,6040 }, { 176,6040 }, { 177,6040 }, { 178,6040 }, { 179,6040 },
 { 180,6040 }, { 181,6040 }, { 182,6040 }, { 183,6040 }, { 184,6040 },
 { 185,6040 }, { 186,6040 }, { 187,6040 }, { 188,6040 }, { 189,6040 },
 { 190,6040 }, { 191,6040 }, { 192,6040 }, { 193,6040 }, { 194,6040 },
 { 195,6040 }, { 196,6040 }, { 197,6040 }, { 198,6040 }, { 199,6040 },
 { 200,6040 }, { 201,6040 }, { 202,6040 }, { 203,6040 }, { 204,6040 },

 { 205,6040 }, { 206,6040 }, { 207,6040 }, { 208,6040 }, { 209,6040 },
 { 210,6040 }, { 211,6040 }, { 212,6040 }, { 213,6040 }, { 214,6040 },
 { 215,6040 }, { 216,6040 }, { 217,6040 }, { 218,6040 }, { 219,6040 },
 { 220,6040 }, { 221,6040 }, { 222,6040 }, { 223,6040 }, { 224,6040 },
 { 225,6040 }, { 226,6040 }, { 227,6040 }, { 228,6040 }, { 229,6040 },
 { 230,6040 }, { 231,6040 }, { 232,6040 }, { 233,6040 }, { 234,6040 },
 { 235,6040 }, { 236,6040 }, { 237,6040 }, { 238,6040 }, { 239,6040 },
 { 240,6040 }, { 241,6040 }, { 242,6040 }, { 243,6040 }, { 244,6040 },
 { 245,6040 }, { 246,6040 }, { 247,6040 }, { 248,6040 }, { 249,6040 },
 { 250,6040 }, { 251,6040 }, { 252,6040 }, { 253,6040 }, { 254,6040 },

 { 255,6040 }, {   0,  65 }, {   0,17487 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5783 }, {   0,   0 },
 {   0,   0 }, {  39,-1781 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,5783 }, {  49,5783 }, {  50,5783 }, {  51,5783 }, {  52,5783 },
 {  53,5783 }, {  54,5783 }, {  55,5783 }, {  56,5783 }, {  57,5783 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5783 }, {  66,5783 }, {  67,5783 },
 {  68,5783 }, {  69,5783 }, {  70,5783 }, {  71,5783 }, {  72,5783 },
 {  73,5783 }, {  74,5783 }, {  75,5783 }, {  76,5783 }, {  77,5783 },
 {  78,5783 }, {  79,5783 }, {  80,5783 }, {  81,5783 }, {  82,5783 },
 {  83,5783 }, {  84,5783 }, {  85,5783 }, {  86,5783 }, {  87,5783 },
 {  88,5783 }, {  89,5783 }, {  90,5783 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5783 }, {   0,   0 }, {  97,5783 },

 {  98,5783 }, {  99,5783 }, { 100,5783 }, { 101,5783 }, { 102,5783 },
 { 103,5783 }, { 104,5783 }, { 105,5783 }, { 106,5783 }, { 107,5783 },
 { 108,5783 }, { 109,5783 }, { 110,5783 }, { 111,5783 }, { 112,5783 },
 { 113,5783 }, { 114,5783 }, { 115,5783 }, { 116,5783 }, { 117,5783 },
 { 118,5783 }, { 119,5783 }, { 120,5783 }, { 121,5783 }, { 122,5783 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5783 }, { 129,5783 }, { 130,5783 }, { 131,5783 }, { 132,5783 },
 { 133,5783 }, { 134,5783 }, { 135,5783 }, { 136,5783 }, { 137,5783 },
 { 138,5783 }, { 139,5783 }, { 140,5783 }, { 141,5783 }, { 142,5783 },
 { 143,5783 }, { 144,5783 }, { 145,5783 }, { 146,5783 }, { 147,5783 },

 { 148,5783 }, { 149,5783 }, { 150,5783 }, { 151,5783 }, { 152,5783 },
 { 153,5783 }, { 154,5783 }, { 155,5783 }, { 156,5783 }, { 157,5783 },
 { 158,5783 }, { 159,5783 }, { 160,5783 }, { 161,5783 }, { 162,5783 },
 { 163,5783 }, { 164,5783 }, { 165,5783 }, { 166,5783 }, { 167,5783 },
 { 168,5783 }, { 169,5783 }, { 170,5783 }, { 171,5783 }, { 172,5783 },
 { 173,5783 }, { 174,5783 }, { 175,5783 }, { 176,5783 }, { 177,5783 },
 { 178,5783 }, { 179,5783 }, { 180,5783 }, { 181,5783 }, { 182,5783 },
 { 183,5783 }, { 184,5783 }, { 185,5783 }, { 186,5783 }, { 187,5783 },
 { 188,5783 }, { 189,5783 }, { 190,5783 }, { 191,5783 }, { 192,5783 },
 { 193,5783 }, { 194,5783 }, { 195,5783 }, { 196,5783 }, { 197,5783 },

 { 198,5783 }, { 199,5783 }, { 200,5783 }, { 201,5783 }, { 202,5783 },
 { 203,5783 }, { 204,5783 }, { 205,5783 }, { 206,5783 }, { 207,5783 },
 { 208,5783 }, { 209,5783 }, { 210,5783 }, { 211,5783 }, { 212,5783 },
 { 213,5783 }, { 214,5783 }, { 215,5783 }, { 216,5783 }, { 217,5783 },
 { 218,5783 }, { 219,5783 }, { 220,5783 }, { 221,5783 }, { 222,5783 },
 { 223,5783 }, { 224,5783 }, { 225,5783 }, { 226,5783 }, { 227,5783 },
 { 228,5783 }, { 229,5783 }, { 230,5783 }, { 231,5783 }, { 232,5783 },
 { 233,5783 }, { 234,5783 }, { 235,5783 }, { 236,5783 }, { 237,5783 },
 { 238,5783 }, { 239,5783 }, { 240,5783 }, { 241,5783 }, { 242,5783 },
 { 243,5783 }, { 244,5783 }, { 245,5783 }, { 246,5783 }, { 247,5783 },

 { 248,5783 }, { 249,5783 }, { 250,5783 }, { 251,5783 }, { 252,5783 },
 { 253,5783 }, { 254,5783 }, { 255,5783 }, {   0,  10 }, {   0,17230 },
 {   1,5783 }, {   2,5783 }, {   3,5783 }, {   4,5783 }, {   5,5783 },
 {   6,5783 }, {   7,5783 }, {   8,5783 }, {   9,5783 }, {  10,5783 },
 {  11,5783 }, {  12,5783 }, {  13,5783 }, {  14,5783 }, {  15,5783 },
 {  16,5783 }, {  17,5783 }, {  18,5783 }, {  19,5783 }, {  20,5783 },
 {  21,5783 }, {  22,5783 }, {  23,5783 }, {  24,5783 }, {  25,5783 },
 {  26,5783 }, {  27,5783 }, {  28,5783 }, {  29,5783 }, {  30,5783 },
 {  31,5783 }, {  32,5783 }, {  33,5783 }, {  34,5783 }, {  35,5783 },
 {  36,5783 }, {  37,5783 }, {  38,5783 }, {   0,   0 }, {  40,5783 },

 {  41,5783 }, {  42,5783 }, {  43,5783 }, {  44,5783 }, {  45,5783 },
 {  46,5783 }, {  47,5783 }, {  48,5783 }, {  49,5783 }, {  50,5783 },
 {  51,5783 }, {  52,5783 }, {  53,5783 }, {  54,5783 }, {  55,5783 },
 {  56,5783 }, {  57,5783 }, {  58,5783 }, {  59,5783 }, {  60,5783 },
 {  61,5783 }, {  62,5783 }, {  63,5783 }, {  64,5783 }, {  65,5783 },
 {  66,5783 }, {  67,5783 }, {  68,5783 }, {  69,5783 }, {  70,5783 },
 {  71,5783 }, {  72,5783 }, {  73,5783 }, {  74,5783 }, {  75,5783 },
 {  76,5783 }, {  77,5783 }, {  78,5783 }, {  79,5783 }, {  80,5783 },
 {  81,5783 }, {  82,5783 }, {  83,5783 }, {  84,5783 }, {  85,5783 },
 {  86,5783 }, {  87,5783 }, {  88,5783 }, {  89,5783 }, {  90,5783 },

 {  91,5783 }, {  92,5783 }, {  93,5783 }, {  94,5783 }, {  95,5783 },
 {  96,5783 }, {  97,5783 }, {  98,5783 }, {  99,5783 }, { 100,5783 },
 { 101,5783 }, { 102,5783 }, { 103,5783 }, { 104,5783 }, { 105,5783 },
 { 106,5783 }, { 107,5783 }, { 108,5783 }, { 109,5783 }, { 110,5783 },
 { 111,5783 }, { 112,5783 }, { 113,5783 }, { 114,5783 }, { 115,5783 },
 { 116,5783 }, { 117,5783 }, { 118,5783 }, { 119,5783 }, { 120,5783 },
 { 121,5783 }, { 122,5783 }, { 123,5783 }, { 124,5783 }, { 125,5783 },
 { 126,5783 }, { 127,5783 }, { 128,5783 }, { 129,5783 }, { 130,5783 },
 { 131,5783 }, { 132,5783 }, { 133,5783 }, { 134,5783 }, { 135,5783 },
 { 136,5783 }, { 137,5783 }, { 138,5783 }, { 139,5783 }, { 140,5783 },

 { 141,5783 }, { 142,5783 }, { 143,5783 }, { 144,5783 }, { 145,5783 },
 { 146,5783 }, { 147,5783 }, { 148,5783 }, { 149,5783 }, { 150,5783 },
 { 151,5783 }, { 152,5783 }, { 153,5783 }, { 154,5783 }, { 155,5783 },
 { 156,5783 }, { 157,5783 }, { 158,5783 }, { 159,5783 }, { 160,5783 },
 { 161,5783 }, { 162,5783 }, { 163,5783 }, { 164,5783 }, { 165,5783 },
 { 166,5783 }, { 167,5783 }, { 168,5783 }, { 169,5783 }, { 170,5783 },
 { 171,5783 }, { 172,5783 }, { 173,5783 }, { 174,5783 }, { 175,5783 },
 { 176,5783 }, { 177,5783 }, { 178,5783 }, { 179,5783 }, { 180,5783 },
 { 181,5783 }, { 182,5783 }, { 183,5783 }, { 184,5783 }, { 185,5783 },
 { 186,5783 }, { 187,5783 }, { 188,5783 }, { 189,5783 }, { 190,5783 },

 { 191,5783 }, { 192,5783 }, { 193,5783 }, { 194,5783 }, { 195,5783 },
 { 196,5783 }, { 197,5783 }, { 198,5783 }, { 199,5783 }, { 200,5783 },
 { 201,5783 }, { 202,5783 }, { 203,5783 }, { 204,5783 }, { 205,5783 },
 { 206,5783 }, { 207,5783 }, { 208,5783 }, { 209,5783 }, { 210,5783 },
 { 211,5783 }, { 212,5783 }, { 213,5783 }, { 214,5783 }, { 215,5783 },
 { 216,5783 }, { 217,5783 }, { 218,5783 }, { 219,5783 }, { 220,5783 },
 { 221,5783 }, { 222,5783 }, { 223,5783 }, { 224,5783 }, { 225,5783 },
 { 226,5783 }, { 227,5783 }, { 228,5783 }, { 229,5783 }, { 230,5783 },
 { 231,5783 }, { 232,5783 }, { 233,5783 }, { 234,5783 }, { 235,5783 },
 { 236,5783 }, { 237,5783 }, { 238,5783 }, { 239,5783 }, { 240,5783 },

 { 241,5783 }, { 242,5783 }, { 243,5783 }, { 244,5783 }, { 245,5783 },
 { 246,5783 }, { 247,5783 }, { 248,5783 }, { 249,5783 }, { 250,5783 },
 { 251,5783 }, { 252,5783 }, { 253,5783 }, { 254,5783 }, { 255,5783 },
 { 256,5783 }, {   0,   5 }, {   0,16972 }, {   1,5783 }, {   2,5783 },
 {   3,5783 }, {   4,5783 }, {   5,5783 }, {   6,5783 }, {   7,5783 },
 {   8,5783 }, {   9,5783 }, {  10,5783 }, {  11,5783 }, {  12,5783 },
 {  13,5783 }, {  14,5783 }, {  15,5783 }, {  16,5783 }, {  17,5783 },
 {  18,5783 }, {  19,5783 }, {  20,5783 }, {  21,5783 }, {  22,5783 },
 {  23,5783 }, {  24,5783 }, {  25,5783 }, {  26,5783 }, {  27,5783 },
 {  28,5783 }, {  29,5783 }, {  30,5783 }, {  31,5783 }, {  32,5783 },

 {  33,5783 }, {  34,5783 }, {  35,5783 }, {  36,5783 }, {  37,5783 },
 {  38,5783 }, {  39,5783 }, {  40,5783 }, {  41,5783 }, {   0,   0 },
 {  43,5783 }, {  44,5783 }, {  45,5783 }, {  46,5783 }, {   0,   0 },
 {  48,5783 }, {  49,5783 }, {  50,5783 }, {  51,5783 }, {  52,5783 },
 {  53,5783 }, {  54,5783 }, {  55,5783 }, {  56,5783 }, {  57,5783 },
 {  58,5783 }, {  59,5783 }, {  60,5783 }, {  61,5783 }, {  62,5783 },
 {  63,5783 }, {  64,5783 }, {  65,5783 }, {  66,5783 }, {  67,5783 },
 {  68,5783 }, {  69,5783 }, {  70,5783 }, {  71,5783 }, {  72,5783 },
 {  73,5783 }, {  74,5783 }, {  75,5783 }, {  76,5783 }, {  77,5783 },
 {  78,5783 }, {  79,5783 }, {  80,5783 }, {  81,5783 }, {  82,5783 },

 {  83,5783 }, {  84,5783 }, {  85,5783 }, {  86,5783 }, {  87,5783 },
 {  88,5783 }, {  89,5783 }, {  90,5783 }, {  91,5783 }, {  92,5783 },
 {  93,5783 }, {  94,5783 }, {  95,5783 }, {  96,5783 }, {  97,5783 },
 {  98,5783 }, {  99,5783 }, { 100,5783 }, { 101,5783 }, { 102,5783 },
 { 103,5783 }, { 104,5783 }, { 105,5783 }, { 106,5783 }, { 107,5783 },
 { 108,5783 }, { 109,5783 }, { 110,5783 }, { 111,5783 }, { 112,5783 },
 { 113,5783 }, { 114,5783 }, { 115,5783 }, { 116,5783 }, { 117,5783 },
 { 118,5783 }, { 119,5783 }, { 120,5783 }, { 121,5783 }, { 122,5783 },
 { 123,5783 }, { 124,5783 }, { 125,5783 }, { 126,5783 }, { 127,5783 },
 { 128,5783 }, { 129,5783 }, { 130,5783 }, { 131,5783 }, { 132,5783 },

 { 133,5783 }, { 134,5783 }, { 135,5783 }, { 136,5783 }, { 137,5783 },
 { 138,5783 }, { 139,5783 }, { 140,5783 }, { 141,5783 }, { 142,5783 },
 { 143,5783 }, { 144,5783 }, { 145,5783 }, { 146,5783 }, { 147,5783 },
 { 148,5783 }, { 149,5783 }, { 150,5783 }, { 151,5783 }, { 152,5783 },
 { 153,5783 }, { 154,5783 }, { 155,5783 }, { 156,5783 }, { 157,5783 },
 { 158,5783 }, { 159,5783 }, { 160,5783 }, { 161,5783 }, { 162,5783 },
 { 163,5783 }, { 164,5783 }, { 165,5783 }, { 166,5783 }, { 167,5783 },
 { 168,5783 }, { 169,5783 }, { 170,5783 }, { 171,5783 }, { 172,5783 },
 { 173,5783 }, { 174,5783 }, { 175,5783 }, { 176,5783 }, { 177,5783 },
 { 178,5783 }, { 179,5783 }, { 180,5783 }, { 181,5783 }, { 182,5783 },

 { 183,5783 }, { 184,5783 }, { 185,5783 }, { 186,5783 }, { 187,5783 },
 { 188,5783 }, { 189,5783 }, { 190,5783 }, { 191,5783 }, { 192,5783 },
 { 193,5783 }, { 194,5783 }, { 195,5783 }, { 196,5783 }, { 197,5783 },
 { 198,5783 }, { 199,5783 }, { 200,5783 }, { 201,5783 }, { 202,5783 },
 { 203,5783 }, { 204,5783 }, { 205,5783 }, { 206,5783 }, { 207,5783 },
 { 208,5783 }, { 209,5783 }, { 210,5783 }, { 211,5783 }, { 212,5783 },
 { 213,5783 }, { 214,5783 }, { 215,5783 }, { 216,5783 }, { 217,5783 },
 { 218,5783 }, { 219,5783 }, { 220,5783 }, { 221,5783 }, { 222,5783 },
 { 223,5783 }, { 224,5783 }, { 225,5783 }, { 226,5783 }, { 227,5783 },
 { 228,5783 }, { 229,5783 }, { 230,5783 }, { 231,5783 }, { 232,5783 },

 { 233,5783 }, { 234,5783 }, { 235,5783 }, { 236,5783 }, { 237,5783 },
 { 238,5783 }, { 239,5783 }, { 240,5783 }, { 241,5783 }, { 242,5783 },
 { 243,5783 }, { 244,5783 }, { 245,5783 }, { 246,5783 }, { 247,5783 },
 { 248,5783 }, { 249,5783 }, { 250,5783 }, { 251,5783 }, { 252,5783 },
 { 253,5783 }, { 254,5783 }, { 255,5783 }, { 256,5783 }, {   0,   5 },
 {   0,16714 }, {   1,5525 }, {   2,5525 }, {   3,5525 }, {   4,5525 },
 {   5,5525 }, {   6,5525 }, {   7,5525 }, {   8,5525 }, {   9,5525 },
 {  10,5525 }, {  11,5525 }, {  12,5525 }, {  13,5525 }, {  14,5525 },
 {  15,5525 }, {  16,5525 }, {  17,5525 }, {  18,5525 }, {  19,5525 },
 {  20,5525 }, {  21,5525 }, {  22,5525 }, {  23,5525 }, {  24,5525 },

 {  25,5525 }, {  26,5525 }, {  27,5525 }, {  28,5525 }, {  29,5525 },
 {  30,5525 }, {  31,5525 }, {  32,5525 }, {  33,5525 }, {  34,5525 },
 {  35,5525 }, {  36,5525 }, {  37,5525 }, {  38,5525 }, {  39,5525 },
 {  40,5525 }, {  41,5525 }, {   0,   0 }, {  43,5525 }, {  44,5525 },
 {  45,5525 }, {  46,5525 }, {   0,   0 }, {  48,5525 }, {  49,5525 },
 {  50,5525 }, {  51,5525 }, {  52,5525 }, {  53,5525 }, {  54,5525 },
 {  55,5525 }, {  56,5525 }, {  57,5525 }, {  58,5525 }, {  59,5525 },
 {  60,5525 }, {  61,5525 }, {  62,5525 }, {  63,5525 }, {  64,5525 },
 {  65,5525 }, {  66,5525 }, {  67,5525 }, {  68,5525 }, {  69,5525 },
 {  70,5525 }, {  71,5525 }, {  72,5525 }, {  73,5525 }, {  74,5525 },

 {  75,5525 }, {  76,5525 }, {  77,5525 }, {  78,5525 }, {  79,5525 },
 {  80,5525 }, {  81,5525 }, {  82,5525 }, {  83,5525 }, {  84,5525 },
 {  85,5525 }, {  86,5525 }, {  87,5525 }, {  88,5525 }, {  89,5525 },
 {  90,5525 }, {  91,5525 }, {  92,5525 }, {  93,5525 }, {  94,5525 },
 {  95,5525 }, {  96,5525 }, {  97,5525 }, {  98,5525 }, {  99,5525 },
 { 100,5525 }, { 101,5525 }, { 102,5525 }, { 103,5525 }, { 104,5525 },
 { 105,5525 }, { 106,5525 }, { 107,5525 }, { 108,5525 }, { 109,5525 },
 { 110,5525 }, { 111,5525 }, { 112,5525 }, { 113,5525 }, { 114,5525 },
 { 115,5525 }, { 116,5525 }, { 117,5525 }, { 118,5525 }, { 119,5525 },
 { 120,5525 }, { 121,5525 }, { 122,5525 }, { 123,5525 }, { 124,5525 },

 { 125,5525 }, { 126,5525 }, { 127,5525 }, { 128,5525 }, { 129,5525 },
 { 130,5525 }, { 131,5525 }, { 132,5525 }, { 133,5525 }, { 134,5525 },
 { 135,5525 }, { 136,5525 }, { 137,5525 }, { 138,5525 }, { 139,5525 },
 { 140,5525 }, { 141,5525 }, { 142,5525 }, { 143,5525 }, { 144,5525 },
 { 145,5525 }, { 146,5525 }, { 147,5525 }, { 148,5525 }, { 149,5525 },
 { 150,5525 }, { 151,5525 }, { 152,5525 }, { 153,5525 }, { 154,5525 },
 { 155,5525 }, { 156,5525 }, { 157,5525 }, { 158,5525 }, { 159,5525 },
 { 160,5525 }, { 161,5525 }, { 162,5525 }, { 163,5525 }, { 164,5525 },
 { 165,5525 }, { 166,5525 }, { 167,5525 }, { 168,5525 }, { 169,5525 },
 { 170,5525 }, { 171,5525 }, { 172,5525 }, { 173,5525 }, { 174,5525 },

 { 175,5525 }, { 176,5525 }, { 177,5525 }, { 178,5525 }, { 179,5525 },
 { 180,5525 }, { 181,5525 }, { 182,5525 }, { 183,5525 }, { 184,5525 },
 { 185,5525 }, { 186,5525 }, { 187,5525 }, { 188,5525 }, { 189,5525 },
 { 190,5525 }, { 191,5525 }, { 192,5525 }, { 193,5525 }, { 194,5525 },
 { 195,5525 }, { 196,5525 }, { 197,5525 }, { 198,5525 }, { 199,5525 },
 { 200,5525 }, { 201,5525 }, { 202,5525 }, { 203,5525 }, { 204,5525 },
 { 205,5525 }, { 206,5525 }, { 207,5525 }, { 208,5525 }, { 209,5525 },
 { 210,5525 }, { 211,5525 }, { 212,5525 }, { 213,5525 }, { 214,5525 },
 { 215,5525 }, { 216,5525 }, { 217,5525 }, { 218,5525 }, { 219,5525 },
 { 220,5525 }, { 221,5525 }, { 222,5525 }, { 223,5525 }, { 224,5525 },

 { 225,5525 }, { 226,5525 }, { 227,5525 }, { 228,5525 }, { 229,5525 },
 { 230,5525 }, { 231,5525 }, { 232,5525 }, { 233,5525 }, { 234,5525 },
 { 235,5525 }, { 236,5525 }, { 237,5525 }, { 238,5525 }, { 239,5525 },
 { 240,5525 }, { 241,5525 }, { 242,5525 }, { 243,5525 }, { 244,5525 },
 { 245,5525 }, { 246,5525 }, { 247,5525 }, { 248,5525 }, { 249,5525 },
 { 250,5525 }, { 251,5525 }, { 252,5525 }, { 253,5525 }, { 254,5525 },
 { 255,5525 }, { 256,5525 }, {   0,  43 }, {   0,16456 }, {   1,5653 },
 {   2,5653 }, {   3,5653 }, {   4,5653 }, {   5,5653 }, {   6,5653 },
 {   7,5653 }, {   8,5653 }, {   9,5653 }, {  10,5653 }, {  11,5653 },
 {  12,5653 }, {  13,5653 }, {  14,5653 }, {  15,5653 }, {  16,5653 },

 {  17,5653 }, {  18,5653 }, {  19,5653 }, {  20,5653 }, {  21,5653 },
 {  22,5653 }, {  23,5653 }, {  24,5653 }, {  25,5653 }, {  26,5653 },
 {  27,5653 }, {  28,5653 }, {  29,5653 }, {  30,5653 }, {  31,5653 },
 {  32,5653 }, {  33,5653 }, {   0,   0 }, {  35,5653 }, {  36,5653 },
 {  37,5653 }, {  38,5653 }, {  39,5653 }, {  40,5653 }, {  41,5653 },
 {  42,5653 }, {  43,5653 }, {  44,5653 }, {  45,5653 }, {  46,5653 },
 {  47,5653 }, {  48,5653 }, {  49,5653 }, {  50,5653 }, {  51,5653 },
 {  52,5653 }, {  53,5653 }, {  54,5653 }, {  55,5653 }, {  56,5653 },
 {  57,5653 }, {  58,5653 }, {  59,5653 }, {  60,5653 }, {  61,5653 },
 {  62,5653 }, {  63,5653 }, {  64,5653 }, {  65,5653 }, {  66,5653 },

 {  67,5653 }, {  68,5653 }, {  69,5653 }, {  70,5653 }, {  71,5653 },
 {  72,5653 }, {  73,5653 }, {  74,5653 }, {  75,5653 }, {  76,5653 },
 {  77,5653 }, {  78,5653 }, {  79,5653 }, {  80,5653 }, {  81,5653 },
 {  82,5653 }, {  83,5653 }, {  84,5653 }, {  85,5653 }, {  86,5653 },
 {  87,5653 }, {  88,5653 }, {  89,5653 }, {  90,5653 }, {  91,5653 },
 {  92,5653 }, {  93,5653 }, {  94,5653 }, {  95,5653 }, {  96,5653 },
 {  97,5653 }, {  98,5653 }, {  99,5653 }, { 100,5653 }, { 101,5653 },
 { 102,5653 }, { 103,5653 }, { 104,5653 }, { 105,5653 }, { 106,5653 },
 { 107,5653 }, { 108,5653 }, { 109,5653 }, { 110,5653 }, { 111,5653 },
 { 112,5653 }, { 113,5653 }, { 114,5653 }, { 115,5653 }, { 116,5653 },

 { 117,5653 }, { 118,5653 }, { 119,5653 }, { 120,5653 }, { 121,5653 },
 { 122,5653 }, { 123,5653 }, { 124,5653 }, { 125,5653 }, { 126,5653 },
 { 127,5653 }, { 128,5653 }, { 129,5653 }, { 130,5653 }, { 131,5653 },
 { 132,5653 }, { 133,5653 }, { 134,5653 }, { 135,5653 }, { 136,5653 },
 { 137,5653 }, { 138,5653 }, { 139,5653 }, { 140,5653 }, { 141,5653 },
 { 142,5653 }, { 143,5653 }, { 144,5653 }, { 145,5653 }, { 146,5653 },
 { 147,5653 }, { 148,5653 }, { 149,5653 }, { 150,5653 }, { 151,5653 },
 { 152,5653 }, { 153,5653 }, { 154,5653 }, { 155,5653 }, { 156,5653 },
 { 157,5653 }, { 158,5653 }, { 159,5653 }, { 160,5653 }, { 161,5653 },
 { 162,5653 }, { 163,5653 }, { 164,5653 }, { 165,5653 }, { 166,5653 },

 { 167,5653 }, { 168,5653 }, { 169,5653 }, { 170,5653 }, { 171,5653 },
 { 172,5653 }, { 173,5653 }, { 174,5653 }, { 175,5653 }, { 176,5653 },
 { 177,5653 }, { 178,5653 }, { 179,5653 }, { 180,5653 }, { 181,5653 },
 { 182,5653 }, { 183,5653 }, { 184,5653 }, { 185,5653 }, { 186,5653 },
 { 187,5653 }, { 188,5653 }, { 189,5653 }, { 190,5653 }, { 191,5653 },
 { 192,5653 }, { 193,5653 }, { 194,5653 }, { 195,5653 }, { 196,5653 },
 { 197,5653 }, { 198,5653 }, { 199,5653 }, { 200,5653 }, { 201,5653 },
 { 202,5653 }, { 203,5653 }, { 204,5653 }, { 205,5653 }, { 206,5653 },
 { 207,5653 }, { 208,5653 }, { 209,5653 }, { 210,5653 }, { 211,5653 },
 { 212,5653 }, { 213,5653 }, { 214,5653 }, { 215,5653 }, { 216,5653 },

 { 217,5653 }, { 218,5653 }, { 219,5653 }, { 220,5653 }, { 221,5653 },
 { 222,5653 }, { 223,5653 }, { 224,5653 }, { 225,5653 }, { 226,5653 },
 { 227,5653 }, { 228,5653 }, { 229,5653 }, { 230,5653 }, { 231,5653 },
 { 232,5653 }, { 233,5653 }, { 234,5653 }, { 235,5653 }, { 236,5653 },
 { 237,5653 }, { 238,5653 }, { 239,5653 }, { 240,5653 }, { 241,5653 },
 { 242,5653 }, { 243,5653 }, { 244,5653 }, { 245,5653 }, { 246,5653 },
 { 247,5653 }, { 248,5653 }, { 249,5653 }, { 250,5653 }, { 251,5653 },
 { 252,5653 }, { 253,5653 }, { 254,5653 }, { 255,5653 }, { 256,5653 },
 {   0,   9 }, {   0,16198 }, {   1,5653 }, {   2,5653 }, {   3,5653 },
 {   4,5653 }, {   5,5653 }, {   6,5653 }, {   7,5653 }, {   8,5653 },

 {   9,5653 }, {  10,5653 }, {  11,5653 }, {  12,5653 }, {  13,5653 },
 {  14,5653 }, {  15,5653 }, {  16,5653 }, {  17,5653 }, {  18,5653 },
 {  19,5653 }, {  20,5653 }, {  21,5653 }, {  22,5653 }, {  23,5653 },
 {  24,5653 }, {  25,5653 }, {  26,5653 }, {  27,5653 }, {  28,5653 },
 {  29,5653 }, {  30,5653 }, {  31,5653 }, {  32,5653 }, {  33,5653 },
 {  34,5653 }, {  35,5653 }, {  36,5653 }, {  37,5653 }, {  38,5653 },
 {   0,   0 }, {  40,5653 }, {  41,5653 }, {  42,5653 }, {  43,5653 },
 {  44,5653 }, {  45,5653 }, {  46,5653 }, {  47,5653 }, {  48,5653 },
 {  49,5653 }, {  50,5653 }, {  51,5653 }, {  52,5653 }, {  53,5653 },
 {  54,5653 }, {  55,5653 }, {  56,5653 }, {  57,5653 }, {  58,5653 },

 {  59,5653 }, {  60,5653 }, {  61,5653 }, {  62,5653 }, {  63,5653 },
 {  64,5653 }, {  65,5653 }, {  66,5653 }, {  67,5653 }, {  68,5653 },
 {  69,5653 }, {  70,5653 }, {  71,5653 }, {  72,5653 }, {  73,5653 },
 {  74,5653 }, {  75,5653 }, {  76,5653 }, {  77,5653 }, {  78,5653 },
 {  79,5653 }, {  80,5653 }, {  81,5653 }, {  82,5653 }, {  83,5653 },
 {  84,5653 }, {  85,5653 }, {  86,5653 }, {  87,5653 }, {  88,5653 },
 {  89,5653 }, {  90,5653 }, {  91,5653 }, {  92,5653 }, {  93,5653 },
 {  94,5653 }, {  95,5653 }, {  96,5653 }, {  97,5653 }, {  98,5653 },
 {  99,5653 }, { 100,5653 }, { 101,5653 }, { 102,5653 }, { 103,5653 },
 { 104,5653 }, { 105,5653 }, { 106,5653 }, { 107,5653 }, { 108,5653 },

 { 109,5653 }, { 110,5653 }, { 111,5653 }, { 112,5653 }, { 113,5653 },
 { 114,5653 }, { 115,5653 }, { 116,5653 }, { 117,5653 }, { 118,5653 },
 { 119,5653 }, { 120,5653 }, { 121,5653 }, { 122,5653 }, { 123,5653 },
 { 124,5653 }, { 125,5653 }, { 126,5653 }, { 127,5653 }, { 128,5653 },
 { 129,5653 }, { 130,5653 }, { 131,5653 }, { 132,5653 }, { 133,5653 },
 { 134,5653 }, { 135,5653 }, { 136,5653 }, { 137,5653 }, { 138,5653 },
 { 139,5653 }, { 140,5653 }, { 141,5653 }, { 142,5653 }, { 143,5653 },
 { 144,5653 }, { 145,5653 }, { 146,5653 }, { 147,5653 }, { 148,5653 },
 { 149,5653 }, { 150,5653 }, { 151,5653 }, { 152,5653 }, { 153,5653 },
 { 154,5653 }, { 155,5653 }, { 156,5653 }, { 157,5653 }, { 158,5653 },

 { 159,5653 }, { 160,5653 }, { 161,5653 }, { 162,5653 }, { 163,5653 },
 { 164,5653 }, { 165,5653 }, { 166,5653 }, { 167,5653 }, { 168,5653 },
 { 169,5653 }, { 170,5653 }, { 171,5653 }, { 172,5653 }, { 173,5653 },
 { 174,5653 }, { 175,5653 }, { 176,5653 }, { 177,5653 }, { 178,5653 },
 { 179,5653 }, { 180,5653 }, { 181,5653 }, { 182,5653 }, { 183,5653 },
 { 184,5653 }, { 185,5653 }, { 186,5653 }, { 187,5653 }, { 188,5653 },
 { 189,5653 }, { 190,5653 }, { 191,5653 }, { 192,5653 }, { 193,5653 },
 { 194,5653 }, { 195,5653 }, { 196,5653 }, { 197,5653 }, { 198,5653 },
 { 199,5653 }, { 200,5653 }, { 201,5653 }, { 202,5653 }, { 203,5653 },
 { 204,5653 }, { 205,5653 }, { 206,5653 }, { 207,5653 }, { 208,5653 },

 { 209,5653 }, { 210,5653 }, { 211,5653 }, { 212,5653 }, { 213,5653 },
 { 214,5653 }, { 215,5653 }, { 216,5653 }, { 217,5653 }, { 218,5653 },
 { 219,5653 }, { 220,5653 }, { 221,5653 }, { 222,5653 }, { 223,5653 },
 { 224,5653 }, { 225,5653 }, { 226,5653 }, { 227,5653 }, { 228,5653 },
 { 229,5653 }, { 230,5653 }, { 231,5653 }, { 232,5653 }, { 233,5653 },
 { 234,5653 }, { 235,5653 }, { 236,5653 }, { 237,5653 }, { 238,5653 },
 { 239,5653 }, { 240,5653 }, { 241,5653 }, { 242,5653 }, { 243,5653 },
 { 244,5653 }, { 245,5653 }, { 246,5653 }, { 247,5653 }, { 248,5653 },
 { 249,5653 }, { 250,5653 }, { 251,5653 }, { 252,5653 }, { 253,5653 },
 { 254,5653 }, { 255,5653 }, { 256,5653 }, {   0,  21 }, {   0,15940 },

 {   1,5653 }, {   2,5653 }, {   3,5653 }, {   4,5653 }, {   5,5653 },
 {   6,5653 }, {   7,5653 }, {   8,5653 }, {   9,5653 }, {  10,5653 },
 {  11,5653 }, {  12,5653 }, {  13,5653 }, {  14,5653 }, {  15,5653 },
 {  16,5653 }, {  17,5653 }, {  18,5653 }, {  19,5653 }, {  20,5653 },
 {  21,5653 }, {  22,5653 }, {  23,5653 }, {  24,5653 }, {  25,5653 },
 {  26,5653 }, {  27,5653 }, {  28,5653 }, {  29,5653 }, {  30,5653 },
 {  31,5653 }, {  32,5653 }, {  33,5653 }, {  34,5653 }, {  35,5653 },
 {  36,5653 }, {  37,5653 }, {  38,5653 }, {   0,   0 }, {  40,5653 },
 {  41,5653 }, {  42,5653 }, {  43,5653 }, {  44,5653 }, {  45,5653 },
 {  46,5653 }, {  47,5653 }, {  48,5653 }, {  49,5653 }, {  50,5653 },

 {  51,5653 }, {  52,5653 }, {  53,5653 }, {  54,5653 }, {  55,5653 },
 {  56,5653 }, {  57,5653 }, {  58,5653 }, {  59,5653 }, {  60,5653 },
 {  61,5653 }, {  62,5653 }, {  63,5653 }, {  64,5653 }, {  65,5653 },
 {  66,5653 }, {  67,5653 }, {  68,5653 }, {  69,5653 }, {  70,5653 },
 {  71,5653 }, {  72,5653 }, {  73,5653 }, {  74,5653 }, {  75,5653 },
 {  76,5653 }, {  77,5653 }, {  78,5653 }, {  79,5653 }, {  80,5653 },
 {  81,5653 }, {  82,5653 }, {  83,5653 }, {  84,5653 }, {  85,5653 },
 {  86,5653 }, {  87,5653 }, {  88,5653 }, {  89,5653 }, {  90,5653 },
 {  91,5653 }, {  92,5653 }, {  93,5653 }, {  94,5653 }, {  95,5653 },
 {  96,5653 }, {  97,5653 }, {  98,5653 }, {  99,5653 }, { 100,5653 },

 { 101,5653 }, { 102,5653 }, { 103,5653 }, { 104,5653 }, { 105,5653 },
 { 106,5653 }, { 107,5653 }, { 108,5653 }, { 109,5653 }, { 110,5653 },
 { 111,5653 }, { 112,5653 }, { 113,5653 }, { 114,5653 }, { 115,5653 },
 { 116,5653 }, { 117,5653 }, { 118,5653 }, { 119,5653 }, { 120,5653 },
 { 121,5653 }, { 122,5653 }, { 123,5653 }, { 124,5653 }, { 125,5653 },
 { 126,5653 }, { 127,5653 }, { 128,5653 }, { 129,5653 }, { 130,5653 },
 { 131,5653 }, { 132,5653 }, { 133,5653 }, { 134,5653 }, { 135,5653 },
 { 136,5653 }, { 137,5653 }, { 138,5653 }, { 139,5653 }, { 140,5653 },
 { 141,5653 }, { 142,5653 }, { 143,5653 }, { 144,5653 }, { 145,5653 },
 { 146,5653 }, { 147,5653 }, { 148,5653 }, { 149,5653 }, { 150,5653 },

 { 151,5653 }, { 152,5653 }, { 153,5653 }, { 154,5653 }, { 155,5653 },
 { 156,5653 }, { 157,5653 }, { 158,5653 }, { 159,5653 }, { 160,5653 },
 { 161,5653 }, { 162,5653 }, { 163,5653 }, { 164,5653 }, { 165,5653 },
 { 166,5653 }, { 167,5653 }, { 168,5653 }, { 169,5653 }, { 170,5653 },
 { 171,5653 }, { 172,5653 }, { 173,5653 }, { 174,5653 }, { 175,5653 },
 { 176,5653 }, { 177,5653 }, { 178,5653 }, { 179,5653 }, { 180,5653 },
 { 181,5653 }, { 182,5653 }, { 183,5653 }, { 184,5653 }, { 185,5653 },
 { 186,5653 }, { 187,5653 }, { 188,5653 }, { 189,5653 }, { 190,5653 },
 { 191,5653 }, { 192,5653 }, { 193,5653 }, { 194,5653 }, { 195,5653 },
 { 196,5653 }, { 197,5653 }, { 198,5653 }, { 199,5653 }, { 200,5653 },

 { 201,5653 }, { 202,5653 }, { 203,5653 }, { 204,5653 }, { 205,5653 },
 { 206,5653 }, { 207,5653 }, { 208,5653 }, { 209,5653 }, { 210,5653 },
 { 211,5653 }, { 212,5653 }, { 213,5653 }, { 214,5653 }, { 215,5653 },
 { 216,5653 }, { 217,5653 }, { 218,5653 }, { 219,5653 }, { 220,5653 },
 { 221,5653 }, { 222,5653 }, { 223,5653 }, { 224,5653 }, { 225,5653 },
 { 226,5653 }, { 227,5653 }, { 228,5653 }, { 229,5653 }, { 230,5653 },
 { 231,5653 }, { 232,5653 }, { 233,5653 }, { 234,5653 }, { 235,5653 },
 { 236,5653 }, { 237,5653 }, { 238,5653 }, { 239,5653 }, { 240,5653 },
 { 241,5653 }, { 242,5653 }, { 243,5653 }, { 244,5653 }, { 245,5653 },
 { 246,5653 }, { 247,5653 }, { 248,5653 }, { 249,5653 }, { 250,5653 },

 { 251,5653 }, { 252,5653 }, { 253,5653 }, { 254,5653 }, { 255,5653 },
 { 256,5653 }, {   0,  18 }, {   0,15682 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  18 }, {   0,15677 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,5653 }, {  10,5658 }, {   0,   0 }, {  12,5653 },
 {  13,5658 }, {   9,5669 }, {  10,5669 }, {   0,   0 }, {  12,5669 },
 {  13,5669 }, {   0,   0 }, {   0,  18 }, {   0,15661 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,5653 }, {  10,5653 }, {  32,5653 },
 {  12,5653 }, {  13,5653 }, {   0,   0 }, {   0,   0 }, {  32,5669 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  39,-3573 }, {  45,-3570 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-3571 }, {   0,   0 }, {   0,   0 },
 {  32,5653 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-3589 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3587 }, {   0,  22 },
 {   0,15614 }, {   1,5911 }, {   2,5911 }, {   3,5911 }, {   4,5911 },
 {   5,5911 }, {   6,5911 }, {   7,5911 }, {   8,5911 }, {   9,5911 },
 {  10,5911 }, {  11,5911 }, {  12,5911 }, {  13,5911 }, {  14,5911 },
 {  15,5911 }, {  16,5911 }, {  17,5911 }, {  18,5911 }, {  19,5911 },
 {  20,5911 }, {  21,5911 }, {  22,5911 }, {  23,5911 }, {  24,5911 },

 {  25,5911 }, {  26,5911 }, {  27,5911 }, {  28,5911 }, {  29,5911 },
 {  30,5911 }, {  31,5911 }, {  32,5911 }, {  33,5911 }, {  34,5911 },
 {  35,5911 }, {  36,5911 }, {  37,5911 }, {  38,5911 }, {   0,   0 },
 {  40,5911 }, {  41,5911 }, {  42,5911 }, {  43,5911 }, {  44,5911 },
 {  45,5911 }, {  46,5911 }, {  47,5911 }, {  48,5911 }, {  49,5911 },
 {  50,5911 }, {  51,5911 }, {  52,5911 }, {  53,5911 }, {  54,5911 },
 {  55,5911 }, {  56,5911 }, {  57,5911 }, {  58,5911 }, {  59,5911 },
 {  60,5911 }, {  61,5911 }, {  62,5911 }, {  63,5911 }, {  64,5911 },
 {  65,5911 }, {  66,5911 }, {  67,5911 }, {  68,5911 }, {  69,5911 },
 {  70,5911 }, {  71,5911 }, {  72,5911 }, {  73,5911 }, {  74,5911 },

 {  75,5911 }, {  76,5911 }, {  77,5911 }, {  78,5911 }, {  79,5911 },
 {  80,5911 }, {  81,5911 }, {  82,5911 }, {  83,5911 }, {  84,5911 },
 {  85,5911 }, {  86,5911 }, {  87,5911 }, {  88,5911 }, {  89,5911 },
 {  90,5911 }, {  91,5911 }, {   0,   0 }, {  93,5911 }, {  94,5911 },
 {  95,5911 }, {  96,5911 }, {  97,5911 }, {  98,5911 }, {  99,5911 },
 { 100,5911 }, { 101,5911 }, { 102,5911 }, { 103,5911 }, { 104,5911 },
 { 105,5911 }, { 106,5911 }, { 107,5911 }, { 108,5911 }, { 109,5911 },
 { 110,5911 }, { 111,5911 }, { 112,5911 }, { 113,5911 }, { 114,5911 },
 { 115,5911 }, { 116,5911 }, { 117,5911 }, { 118,5911 }, { 119,5911 },
 { 120,5911 }, { 121,5911 }, { 122,5911 }, { 123,5911 }, { 124,5911 },

 { 125,5911 }, { 126,5911 }, { 127,5911 }, { 128,5911 }, { 129,5911 },
 { 130,5911 }, { 131,5911 }, { 132,5911 }, { 133,5911 }, { 134,5911 },
 { 135,5911 }, { 136,5911 }, { 137,5911 }, { 138,5911 }, { 139,5911 },
 { 140,5911 }, { 141,5911 }, { 142,5911 }, { 143,5911 }, { 144,5911 },
 { 145,5911 }, { 146,5911 }, { 147,5911 }, { 148,5911 }, { 149,5911 },
 { 150,5911 }, { 151,5911 }, { 152,5911 }, { 153,5911 }, { 154,5911 },
 { 155,5911 }, { 156,5911 }, { 157,5911 }, { 158,5911 }, { 159,5911 },
 { 160,5911 }, { 161,5911 }, { 162,5911 }, { 163,5911 }, { 164,5911 },
 { 165,5911 }, { 166,5911 }, { 167,5911 }, { 168,5911 }, { 169,5911 },
 { 170,5911 }, { 171,5911 }, { 172,5911 }, { 173,5911 }, { 174,5911 },

 { 175,5911 }, { 176,5911 }, { 177,5911 }, { 178,5911 }, { 179,5911 },
 { 180,5911 }, { 181,5911 }, { 182,5911 }, { 183,5911 }, { 184,5911 },
 { 185,5911 }, { 186,5911 }, { 187,5911 }, { 188,5911 }, { 189,5911 },
 { 190,5911 }, { 191,5911 }, { 192,5911 }, { 193,5911 }, { 194,5911 },
 { 195,5911 }, { 196,5911 }, { 197,5911 }, { 198,5911 }, { 199,5911 },
 { 200,5911 }, { 201,5911 }, { 202,5911 }, { 203,5911 }, { 204,5911 },
 { 205,5911 }, { 206,5911 }, { 207,5911 }, { 208,5911 }, { 209,5911 },
 { 210,5911 }, { 211,5911 }, { 212,5911 }, { 213,5911 }, { 214,5911 },
 { 215,5911 }, { 216,5911 }, { 217,5911 }, { 218,5911 }, { 219,5911 },
 { 220,5911 }, { 221,5911 }, { 222,5911 }, { 223,5911 }, { 224,5911 },

 { 225,5911 }, { 226,5911 }, { 227,5911 }, { 228,5911 }, { 229,5911 },
 { 230,5911 }, { 231,5911 }, { 232,5911 }, { 233,5911 }, { 234,5911 },
 { 235,5911 }, { 236,5911 }, { 237,5911 }, { 238,5911 }, { 239,5911 },
 { 240,5911 }, { 241,5911 }, { 242,5911 }, { 243,5911 }, { 244,5911 },
 { 245,5911 }, { 246,5911 }, { 247,5911 }, { 248,5911 }, { 249,5911 },
 { 250,5911 }, { 251,5911 }, { 252,5911 }, { 253,5911 }, { 254,5911 },
 { 255,5911 }, { 256,5911 }, {   0,  22 }, {   0,15356 }, {   1,5653 },
 {   2,5653 }, {   3,5653 }, {   4,5653 }, {   5,5653 }, {   6,5653 },
 {   7,5653 }, {   8,5653 }, {   9,5653 }, {  10,5653 }, {  11,5653 },
 {  12,5653 }, {  13,5653 }, {  14,5653 }, {  15,5653 }, {  16,5653 },

 {  17,5653 }, {  18,5653 }, {  19,5653 }, {  20,5653 }, {  21,5653 },
 {  22,5653 }, {  23,5653 }, {  24,5653 }, {  25,5653 }, {  26,5653 },
 {  27,5653 }, {  28,5653 }, {  29,5653 }, {  30,5653 }, {  31,5653 },
 {  32,5653 }, {  33,5653 }, {  34,5653 }, {  35,5653 }, {  36,5653 },
 {  37,5653 }, {  38,5653 }, {   0,   0 }, {  40,5653 }, {  41,5653 },
 {  42,5653 }, {  43,5653 }, {  44,5653 }, {  45,5653 }, {  46,5653 },
 {  47,5653 }, {  48,5653 }, {  49,5653 }, {  50,5653 }, {  51,5653 },
 {  52,5653 }, {  53,5653 }, {  54,5653 }, {  55,5653 }, {  56,5653 },
 {  57,5653 }, {  58,5653 }, {  59,5653 }, {  60,5653 }, {  61,5653 },
 {  62,5653 }, {  63,5653 }, {  64,5653 }, {  65,5653 }, {  66,5653 },

 {  67,5653 }, {  68,5653 }, {  69,5653 }, {  70,5653 }, {  71,5653 },
 {  72,5653 }, {  73,5653 }, {  74,5653 }, {  75,5653 }, {  76,5653 },
 {  77,5653 }, {  78,5653 }, {  79,5653 }, {  80,5653 }, {  81,5653 },
 {  82,5653 }, {  83,5653 }, {  84,5653 }, {  85,5653 }, {  86,5653 },
 {  87,5653 }, {  88,5653 }, {  89,5653 }, {  90,5653 }, {  91,5653 },
 {   0,   0 }, {  93,5653 }, {  94,5653 }, {  95,5653 }, {  96,5653 },
 {  97,5653 }, {  98,5653 }, {  99,5653 }, { 100,5653 }, { 101,5653 },
 { 102,5653 }, { 103,5653 }, { 104,5653 }, { 105,5653 }, { 106,5653 },
 { 107,5653 }, { 108,5653 }, { 109,5653 }, { 110,5653 }, { 111,5653 },
 { 112,5653 }, { 113,5653 }, { 114,5653 }, { 115,5653 }, { 116,5653 },

 { 117,5653 }, { 118,5653 }, { 119,5653 }, { 120,5653 }, { 121,5653 },
 { 122,5653 }, { 123,5653 }, { 124,5653 }, { 125,5653 }, { 126,5653 },
 { 127,5653 }, { 128,5653 }, { 129,5653 }, { 130,5653 }, { 131,5653 },
 { 132,5653 }, { 133,5653 }, { 134,5653 }, { 135,5653 }, { 136,5653 },
 { 137,5653 }, { 138,5653 }, { 139,5653 }, { 140,5653 }, { 141,5653 },
 { 142,5653 }, { 143,5653 }, { 144,5653 }, { 145,5653 }, { 146,5653 },
 { 147,5653 }, { 148,5653 }, { 149,5653 }, { 150,5653 }, { 151,5653 },
 { 152,5653 }, { 153,5653 }, { 154,5653 }, { 155,5653 }, { 156,5653 },
 { 157,5653 }, { 158,5653 }, { 159,5653 }, { 160,5653 }, { 161,5653 },
 { 162,5653 }, { 163,5653 }, { 164,5653 }, { 165,5653 }, { 166,5653 },

 { 167,5653 }, { 168,5653 }, { 169,5653 }, { 170,5653 }, { 171,5653 },
 { 172,5653 }, { 173,5653 }, { 174,5653 }, { 175,5653 }, { 176,5653 },
 { 177,5653 }, { 178,5653 }, { 179,5653 }, { 180,5653 }, { 181,5653 },
 { 182,5653 }, { 183,5653 }, { 184,5653 }, { 185,5653 }, { 186,5653 },
 { 187,5653 }, { 188,5653 }, { 189,5653 }, { 190,5653 }, { 191,5653 },
 { 192,5653 }, { 193,5653 }, { 194,5653 }, { 195,5653 }, { 196,5653 },
 { 197,5653 }, { 198,5653 }, { 199,5653 }, { 200,5653 }, { 201,5653 },
 { 202,5653 }, { 203,5653 }, { 204,5653 }, { 205,5653 }, { 206,5653 },
 { 207,5653 }, { 208,5653 }, { 209,5653 }, { 210,5653 }, { 211,5653 },
 { 212,5653 }, { 213,5653 }, { 214,5653 }, { 215,5653 }, { 216,5653 },

 { 217,5653 }, { 218,5653 }, { 219,5653 }, { 220,5653 }, { 221,5653 },
 { 222,5653 }, { 223,5653 }, { 224,5653 }, { 225,5653 }, { 226,5653 },
 { 227,5653 }, { 228,5653 }, { 229,5653 }, { 230,5653 }, { 231,5653 },
 { 232,5653 }, { 233,5653 }, { 234,5653 }, { 235,5653 }, { 236,5653 },
 { 237,5653 }, { 238,5653 }, { 239,5653 }, { 240,5653 }, { 241,5653 },
 { 242,5653 }, { 243,5653 }, { 244,5653 }, { 245,5653 }, { 246,5653 },
 { 247,5653 }, { 248,5653 }, { 249,5653 }, { 250,5653 }, { 251,5653 },
 { 252,5653 }, { 253,5653 }, { 254,5653 }, { 255,5653 }, { 256,5653 },
 {   0,  31 }, {   0,15098 }, {   1,-4148 }, {   2,-4148 }, {   3,-4148 },
 {   4,-4148 }, {   5,-4148 }, {   6,-4148 }, {   7,-4148 }, {   8,-4148 },

 {   9,-4148 }, {  10,-4148 }, {  11,-4148 }, {  12,-4148 }, {  13,-4148 },
 {  14,-4148 }, {  15,-4148 }, {  16,-4148 }, {  17,-4148 }, {  18,-4148 },
 {  19,-4148 }, {  20,-4148 }, {  21,-4148 }, {  22,-4148 }, {  23,-4148 },
 {  24,-4148 }, {  25,-4148 }, {  26,-4148 }, {  27,-4148 }, {  28,-4148 },
 {  29,-4148 }, {  30,-4148 }, {  31,-4148 }, {  32,-4148 }, {  33,-4148 },
 {  34,-4148 }, {  35,-4148 }, {  36,-4148 }, {  37,-4148 }, {  38,-4148 },
 {  39,-4148 }, {  40,-4148 }, {  41,-4148 }, {  42,-4148 }, {  43,-4148 },
 {  44,-4148 }, {  45,-4148 }, {  46,-4148 }, {  47,-4148 }, {  48,5653 },
 {  49,5653 }, {  50,5653 }, {  51,5653 }, {  52,5653 }, {  53,5653 },
 {  54,5653 }, {  55,5653 }, {  56,-4148 }, {  57,-4148 }, {  58,-4148 },

 {  59,-4148 }, {  60,-4148 }, {  61,-4148 }, {  62,-4148 }, {  63,-4148 },
 {  64,-4148 }, {  65,-4148 }, {  66,-4148 }, {  67,-4148 }, {  68,-4148 },
 {  69,-4148 }, {  70,-4148 }, {  71,-4148 }, {  72,-4148 }, {  73,-4148 },
 {  74,-4148 }, {  75,-4148 }, {  76,-4148 }, {  77,-4148 }, {  78,-4148 },
 {  79,-4148 }, {  80,-4148 }, {  81,-4148 }, {  82,-4148 }, {  83,-4148 },
 {  84,-4148 }, {  85,5661 }, {  86,-4148 }, {  87,-4148 }, {  88,-4148 },
 {  89,-4148 }, {  90,-4148 }, {  91,-4148 }, {  92,-4148 }, {  93,-4148 },
 {  94,-4148 }, {  95,-4148 }, {  96,-4148 }, {  97,-4148 }, {  98,-4148 },
 {  99,-4148 }, { 100,-4148 }, { 101,-4148 }, { 102,-4148 }, { 103,-4148 },
 { 104,-4148 }, { 105,-4148 }, { 106,-4148 }, { 107,-4148 }, { 108,-4148 },

 { 109,-4148 }, { 110,-4148 }, { 111,-4148 }, { 112,-4148 }, { 113,-4148 },
 { 114,-4148 }, { 115,-4148 }, { 116,-4148 }, { 117,5684 }, { 118,-4148 },
 { 119,-4148 }, { 120,5722 }, { 121,-4148 }, { 122,-4148 }, { 123,-4148 },
 { 124,-4148 }, { 125,-4148 }, { 126,-4148 }, { 127,-4148 }, { 128,-4148 },
 { 129,-4148 }, { 130,-4148 }, { 131,-4148 }, { 132,-4148 }, { 133,-4148 },
 { 134,-4148 }, { 135,-4148 }, { 136,-4148 }, { 137,-4148 }, { 138,-4148 },
 { 139,-4148 }, { 140,-4148 }, { 141,-4148 }, { 142,-4148 }, { 143,-4148 },
 { 144,-4148 }, { 145,-4148 }, { 146,-4148 }, { 147,-4148 }, { 148,-4148 },
 { 149,-4148 }, { 150,-4148 }, { 151,-4148 }, { 152,-4148 }, { 153,-4148 },
 { 154,-4148 }, { 155,-4148 }, { 156,-4148 }, { 157,-4148 }, { 158,-4148 },

 { 159,-4148 }, { 160,-4148 }, { 161,-4148 }, { 162,-4148 }, { 163,-4148 },
 { 164,-4148 }, { 165,-4148 }, { 166,-4148 }, { 167,-4148 }, { 168,-4148 },
 { 169,-4148 }, { 170,-4148 }, { 171,-4148 }, { 172,-4148 }, { 173,-4148 },
 { 174,-4148 }, { 175,-4148 }, { 176,-4148 }, { 177,-4148 }, { 178,-4148 },
 { 179,-4148 }, { 180,-4148 }, { 181,-4148 }, { 182,-4148 }, { 183,-4148 },
 { 184,-4148 }, { 185,-4148 }, { 186,-4148 }, { 187,-4148 }, { 188,-4148 },
 { 189,-4148 }, { 190,-4148 }, { 191,-4148 }, { 192,-4148 }, { 193,-4148 },
 { 194,-4148 }, { 195,-4148 }, { 196,-4148 }, { 197,-4148 }, { 198,-4148 },
 { 199,-4148 }, { 200,-4148 }, { 201,-4148 }, { 202,-4148 }, { 203,-4148 },
 { 204,-4148 }, { 205,-4148 }, { 206,-4148 }, { 207,-4148 }, { 208,-4148 },

 { 209,-4148 }, { 210,-4148 }, { 211,-4148 }, { 212,-4148 }, { 213,-4148 },
 { 214,-4148 }, { 215,-4148 }, { 216,-4148 }, { 217,-4148 }, { 218,-4148 },
 { 219,-4148 }, { 220,-4148 }, { 221,-4148 }, { 222,-4148 }, { 223,-4148 },
 { 224,-4148 }, { 225,-4148 }, { 226,-4148 }, { 227,-4148 }, { 228,-4148 },
 { 229,-4148 }, { 230,-4148 }, { 231,-4148 }, { 232,-4148 }, { 233,-4148 },
 { 234,-4148 }, { 235,-4148 }, { 236,-4148 }, { 237,-4148 }, { 238,-4148 },
 { 239,-4148 }, { 240,-4148 }, { 241,-4148 }, { 242,-4148 }, { 243,-4148 },
 { 244,-4148 }, { 245,-4148 }, { 246,-4148 }, { 247,-4148 }, { 248,-4148 },
 { 249,-4148 }, { 250,-4148 }, { 251,-4148 }, { 252,-4148 }, { 253,-4148 },
 { 254,-4148 }, { 255,-4148 }, { 256,-4148 }, {   0,  35 }, {   0,14840 },

 {   1,5568 }, {   2,5568 }, {   3,5568 }, {   4,5568 }, {   5,5568 },
 {   6,5568 }, {   7,5568 }, {   8,5568 }, {   9,5568 }, {  10,5568 },
 {  11,5568 }, {  12,5568 }, {  13,5568 }, {  14,5568 }, {  15,5568 },
 {  16,5568 }, {  17,5568 }, {  18,5568 }, {  19,5568 }, {  20,5568 },
 {  21,5568 }, {  22,5568 }, {  23,5568 }, {  24,5568 }, {  25,5568 },
 {  26,5568 }, {  27,5568 }, {  28,5568 }, {  29,5568 }, {  30,5568 },
 {  31,5568 }, {  32,5568 }, {  33,5568 }, {  34,5568 }, {  35,5568 },
 {   0,   0 }, {  37,5568 }, {  38,5568 }, {  39,5568 }, {  40,5568 },
 {  41,5568 }, {  42,5568 }, {  43,5568 }, {  44,5568 }, {  45,5568 },
 {  46,5568 }, {  47,5568 }, {  48,5568 }, {  49,5568 }, {  50,5568 },

 {  51,5568 }, {  52,5568 }, {  53,5568 }, {  54,5568 }, {  55,5568 },
 {  56,5568 }, {  57,5568 }, {  58,5568 }, {  59,5568 }, {  60,5568 },
 {  61,5568 }, {  62,5568 }, {  63,5568 }, {  64,5568 }, {  65,5568 },
 {  66,5568 }, {  67,5568 }, {  68,5568 }, {  69,5568 }, {  70,5568 },
 {  71,5568 }, {  72,5568 }, {  73,5568 }, {  74,5568 }, {  75,5568 },
 {  76,5568 }, {  77,5568 }, {  78,5568 }, {  79,5568 }, {  80,5568 },
 {  81,5568 }, {  82,5568 }, {  83,5568 }, {  84,5568 }, {  85,5568 },
 {  86,5568 }, {  87,5568 }, {  88,5568 }, {  89,5568 }, {  90,5568 },
 {  91,5568 }, {  92,5568 }, {  93,5568 }, {  94,5568 }, {  95,5568 },
 {  96,5568 }, {  97,5568 }, {  98,5568 }, {  99,5568 }, { 100,5568 },

 { 101,5568 }, { 102,5568 }, { 103,5568 }, { 104,5568 }, { 105,5568 },
 { 106,5568 }, { 107,5568 }, { 108,5568 }, { 109,5568 }, { 110,5568 },
 { 111,5568 }, { 112,5568 }, { 113,5568 }, { 114,5568 }, { 115,5568 },
 { 116,5568 }, { 117,5568 }, { 118,5568 }, { 119,5568 }, { 120,5568 },
 { 121,5568 }, { 122,5568 }, { 123,5568 }, { 124,5568 }, { 125,5568 },
 { 126,5568 }, { 127,5568 }, { 128,5568 }, { 129,5568 }, { 130,5568 },
 { 131,5568 }, { 132,5568 }, { 133,5568 }, { 134,5568 }, { 135,5568 },
 { 136,5568 }, { 137,5568 }, { 138,5568 }, { 139,5568 }, { 140,5568 },
 { 141,5568 }, { 142,5568 }, { 143,5568 }, { 144,5568 }, { 145,5568 },
 { 146,5568 }, { 147,5568 }, { 148,5568 }, { 149,5568 }, { 150,5568 },

 { 151,5568 }, { 152,5568 }, { 153,5568 }, { 154,5568 }, { 155,5568 },
 { 156,5568 }, { 157,5568 }, { 158,5568 }, { 159,5568 }, { 160,5568 },
 { 161,5568 }, { 162,5568 }, { 163,5568 }, { 164,5568 }, { 165,5568 },
 { 166,5568 }, { 167,5568 }, { 168,5568 }, { 169,5568 }, { 170,5568 },
 { 171,5568 }, { 172,5568 }, { 173,5568 }, { 174,5568 }, { 175,5568 },
 { 176,5568 }, { 177,5568 }, { 178,5568 }, { 179,5568 }, { 180,5568 },
 { 181,5568 }, { 182,5568 }, { 183,5568 }, { 184,5568 }, { 185,5568 },
 { 186,5568 }, { 187,5568 }, { 188,5568 }, { 189,5568 }, { 190,5568 },
 { 191,5568 }, { 192,5568 }, { 193,5568 }, { 194,5568 }, { 195,5568 },
 { 196,5568 }, { 197,5568 }, { 198,5568 }, { 199,5568 }, { 200,5568 },

 { 201,5568 }, { 202,5568 }, { 203,5568 }, { 204,5568 }, { 205,5568 },
 { 206,5568 }, { 207,5568 }, { 208,5568 }, { 209,5568 }, { 210,5568 },
 { 211,5568 }, { 212,5568 }, { 213,5568 }, { 214,5568 }, { 215,5568 },
 { 216,5568 }, { 217,5568 }, { 218,5568 }, { 219,5568 }, { 220,5568 },
 { 221,5568 }, { 222,5568 }, { 223,5568 }, { 224,5568 }, { 225,5568 },
 { 226,5568 }, { 227,5568 }, { 228,5568 }, { 229,5568 }, { 230,5568 },
 { 231,5568 }, { 232,5568 }, { 233,5568 }, { 234,5568 }, { 235,5568 },
 { 236,5568 }, { 237,5568 }, { 238,5568 }, { 239,5568 }, { 240,5568 },
 { 241,5568 }, { 242,5568 }, { 243,5568 }, { 244,5568 }, { 245,5568 },
 { 246,5568 }, { 247,5568 }, { 248,5568 }, { 249,5568 }, { 250,5568 },

 { 251,5568 }, { 252,5568 }, { 253,5568 }, { 254,5568 }, { 255,5568 },
 { 256,5568 }, {   0,  35 }, {   0,14582 }, {   1,5310 }, {   2,5310 },
 {   3,5310 }, {   4,5310 }, {   5,5310 }, {   6,5310 }, {   7,5310 },
 {   8,5310 }, {   9,5310 }, {  10,5310 }, {  11,5310 }, {  12,5310 },
 {  13,5310 }, {  14,5310 }, {  15,5310 }, {  16,5310 }, {  17,5310 },
 {  18,5310 }, {  19,5310 }, {  20,5310 }, {  21,5310 }, {  22,5310 },
 {  23,5310 }, {  24,5310 }, {  25,5310 }, {  26,5310 }, {  27,5310 },
 {  28,5310 }, {  29,5310 }, {  30,5310 }, {  31,5310 }, {  32,5310 },
 {  33,5310 }, {  34,5310 }, {  35,5310 }, {   0,   0 }, {  37,5310 },
 {  38,5310 }, {  39,5310 }, {  40,5310 }, {  41,5310 }, {  42,5310 },

 {  43,5310 }, {  44,5310 }, {  45,5310 }, {  46,5310 }, {  47,5310 },
 {  48,5310 }, {  49,5310 }, {  50,5310 }, {  51,5310 }, {  52,5310 },
 {  53,5310 }, {  54,5310 }, {  55,5310 }, {  56,5310 }, {  57,5310 },
 {  58,5310 }, {  59,5310 }, {  60,5310 }, {  61,5310 }, {  62,5310 },
 {  63,5310 }, {  64,5310 }, {  65,5310 }, {  66,5310 }, {  67,5310 },
 {  68,5310 }, {  69,5310 }, {  70,5310 }, {  71,5310 }, {  72,5310 },
 {  73,5310 }, {  74,5310 }, {  75,5310 }, {  76,5310 }, {  77,5310 },
 {  78,5310 }, {  79,5310 }, {  80,5310 }, {  81,5310 }, {  82,5310 },
 {  83,5310 }, {  84,5310 }, {  85,5310 }, {  86,5310 }, {  87,5310 },
 {  88,5310 }, {  89,5310 }, {  90,5310 }, {  91,5310 }, {  92,5310 },

 {  93,5310 }, {  94,5310 }, {  95,5310 }, {  96,5310 }, {  97,5310 },
 {  98,5310 }, {  99,5310 }, { 100,5310 }, { 101,5310 }, { 102,5310 },
 { 103,5310 }, { 104,5310 }, { 105,5310 }, { 106,5310 }, { 107,5310 },
 { 108,5310 }, { 109,5310 }, { 110,5310 }, { 111,5310 }, { 112,5310 },
 { 113,5310 }, { 114,5310 }, { 115,5310 }, { 116,5310 }, { 117,5310 },
 { 118,5310 }, { 119,5310 }, { 120,5310 }, { 121,5310 }, { 122,5310 },
 { 123,5310 }, { 124,5310 }, { 125,5310 }, { 126,5310 }, { 127,5310 },
 { 128,5310 }, { 129,5310 }, { 130,5310 }, { 131,5310 }, { 132,5310 },
 { 133,5310 }, { 134,5310 }, { 135,5310 }, { 136,5310 }, { 137,5310 },
 { 138,5310 }, { 139,5310 }, { 140,5310 }, { 141,5310 }, { 142,5310 },

 { 143,5310 }, { 144,5310 }, { 145,5310 }, { 146,5310 }, { 147,5310 },
 { 148,5310 }, { 149,5310 }, { 150,5310 }, { 151,5310 }, { 152,5310 },
 { 153,5310 }, { 154,5310 }, { 155,5310 }, { 156,5310 }, { 157,5310 },
 { 158,5310 }, { 159,5310 }, { 160,5310 }, { 161,5310 }, { 162,5310 },
 { 163,5310 }, { 164,5310 }, { 165,5310 }, { 166,5310 }, { 167,5310 },
 { 168,5310 }, { 169,5310 }, { 170,5310 }, { 171,5310 }, { 172,5310 },
 { 173,5310 }, { 174,5310 }, { 175,5310 }, { 176,5310 }, { 177,5310 },
 { 178,5310 }, { 179,5310 }, { 180,5310 }, { 181,5310 }, { 182,5310 },
 { 183,5310 }, { 184,5310 }, { 185,5310 }, { 186,5310 }, { 187,5310 },
 { 188,5310 }, { 189,5310 }, { 190,5310 }, { 191,5310 }, { 192,5310 },

 { 193,5310 }, { 194,5310 }, { 195,5310 }, { 196,5310 }, { 197,5310 },
 { 198,5310 }, { 199,5310 }, { 200,5310 }, { 201,5310 }, { 202,5310 },
 { 203,5310 }, { 204,5310 }, { 205,5310 }, { 206,5310 }, { 207,5310 },
 { 208,5310 }, { 209,5310 }, { 210,5310 }, { 211,5310 }, { 212,5310 },
 { 213,5310 }, { 214,5310 }, { 215,5310 }, { 216,5310 }, { 217,5310 },
 { 218,5310 }, { 219,5310 }, { 220,5310 }, { 221,5310 }, { 222,5310 },
 { 223,5310 }, { 224,5310 }, { 225,5310 }, { 226,5310 }, { 227,5310 },
 { 228,5310 }, { 229,5310 }, { 230,5310 }, { 231,5310 }, { 232,5310 },
 { 233,5310 }, { 234,5310 }, { 235,5310 }, { 236,5310 }, { 237,5310 },
 { 238,5310 }, { 239,5310 }, { 240,5310 }, { 241,5310 }, { 242,5310 },

 { 243,5310 }, { 244,5310 }, { 245,5310 }, { 246,5310 }, { 247,5310 },
 { 248,5310 }, { 249,5310 }, { 250,5310 }, { 251,5310 }, { 252,5310 },
 { 253,5310 }, { 254,5310 }, { 255,5310 }, { 256,5310 }, {   0,  37 },
 {   0,14324 }, {   0,   1 }, {   0,14322 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   0 }, {   0,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 },

 {   0,   0 }, {  36,-4920 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5310 }, {  66,5310 }, {  67,5310 }, {  68,5310 }, {  69,5310 },
 {  70,5310 }, {  71,5310 }, {  72,5310 }, {  73,5310 }, {  74,5310 },
 {  75,5310 }, {  76,5310 }, {  77,5310 }, {  78,5310 }, {  79,5310 },
 {  80,5310 }, {  81,5310 }, {  82,5310 }, {  83,5310 }, {  84,5310 },

 {  85,5310 }, {  86,5310 }, {  87,5310 }, {  88,5310 }, {  89,5310 },
 {  90,5310 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5310 }, {   0,   0 }, {  97,5310 }, {  98,5310 }, {  99,5310 },
 { 100,5310 }, { 101,5310 }, { 102,5310 }, { 103,5310 }, { 104,5310 },
 { 105,5310 }, { 106,5310 }, { 107,5310 }, { 108,5310 }, { 109,5310 },
 { 110,5310 }, { 111,5310 }, { 112,5310 }, { 113,5310 }, { 114,5310 },
 { 115,5310 }, { 116,5310 }, { 117,5310 }, { 118,5310 }, { 119,5310 },
 { 120,5310 }, { 121,5310 }, { 122,5310 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5310 }, { 129,5310 },
 { 130,5310 }, { 131,5310 }, { 132,5310 }, { 133,5310 }, { 134,5310 },

 { 135,5310 }, { 136,5310 }, { 137,5310 }, { 138,5310 }, { 139,5310 },
 { 140,5310 }, { 141,5310 }, { 142,5310 }, { 143,5310 }, { 144,5310 },
 { 145,5310 }, { 146,5310 }, { 147,5310 }, { 148,5310 }, { 149,5310 },
 { 150,5310 }, { 151,5310 }, { 152,5310 }, { 153,5310 }, { 154,5310 },
 { 155,5310 }, { 156,5310 }, { 157,5310 }, { 158,5310 }, { 159,5310 },
 { 160,5310 }, { 161,5310 }, { 162,5310 }, { 163,5310 }, { 164,5310 },
 { 165,5310 }, { 166,5310 }, { 167,5310 }, { 168,5310 }, { 169,5310 },
 { 170,5310 }, { 171,5310 }, { 172,5310 }, { 173,5310 }, { 174,5310 },
 { 175,5310 }, { 176,5310 }, { 177,5310 }, { 178,5310 }, { 179,5310 },
 { 180,5310 }, { 181,5310 }, { 182,5310 }, { 183,5310 }, { 184,5310 },

 { 185,5310 }, { 186,5310 }, { 187,5310 }, { 188,5310 }, { 189,5310 },
 { 190,5310 }, { 191,5310 }, { 192,5310 }, { 193,5310 }, { 194,5310 },
 { 195,5310 }, { 196,5310 }, { 197,5310 }, { 198,5310 }, { 199,5310 },
 { 200,5310 }, { 201,5310 }, { 202,5310 }, { 203,5310 }, { 204,5310 },
 { 205,5310 }, { 206,5310 }, { 207,5310 }, { 208,5310 }, { 209,5310 },
 { 210,5310 }, { 211,5310 }, { 212,5310 }, { 213,5310 }, { 214,5310 },
 { 215,5310 }, { 216,5310 }, { 217,5310 }, { 218,5310 }, { 219,5310 },
 { 220,5310 }, { 221,5310 }, { 222,5310 }, { 223,5310 }, { 224,5310 },
 { 225,5310 }, { 226,5310 }, { 227,5310 }, { 228,5310 }, { 229,5310 },
 { 230,5310 }, { 231,5310 }, { 232,5310 }, { 233,5310 }, { 234,5310 },

 { 235,5310 }, { 236,5310 }, { 237,5310 }, { 238,5310 }, { 239,5310 },
 { 240,5310 }, { 241,5310 }, { 242,5310 }, { 243,5310 }, { 244,5310 },
 { 245,5310 }, { 246,5310 }, { 247,5310 }, { 248,5310 }, { 249,5310 },
 { 250,5310 }, { 251,5310 }, { 252,5310 }, { 253,5310 }, { 254,5310 },
 { 255,5310 }, {   0,  54 }, {   0,14067 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  52 }, {   0,14056 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {  33, -11 }, {  45,   0 }, {  35, -11 }, {  47,   0 },
 {  37, -11 }, {  38, -11 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42, -11 }, {  43, -11 }, {   0,   0 }, {  45, -11 }, {   0,   0 },
 {  47, -11 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60, -11 }, {  61, -11 },
 {  62, -11 }, {  63, -11 }, {  64, -11 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  55 }, {   0,13977 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94, -11 }, {   0,   0 }, {  96, -11 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124, -11 }, {   0,   0 }, { 126, -11 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5302 }, {  66,5302 }, {  67,5302 },
 {  68,5302 }, {  69,5302 }, {  70,5302 }, {  71,5302 }, {  72,5302 },
 {  73,5302 }, {  74,5302 }, {  75,5302 }, {  76,5302 }, {  77,5302 },
 {  78,5302 }, {  79,5302 }, {  80,5302 }, {  81,5302 }, {  82,5302 },
 {  83,5302 }, {  84,5302 }, {  85,5302 }, {  86,5302 }, {  87,5302 },

 {  88,5302 }, {  89,5302 }, {  90,5302 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5302 }, {   0,   0 }, {  97,5302 },
 {  98,5302 }, {  99,5302 }, { 100,5302 }, { 101,5302 }, { 102,5302 },
 { 103,5302 }, { 104,5302 }, { 105,5302 }, { 106,5302 }, { 107,5302 },
 { 108,5302 }, { 109,5302 }, { 110,5302 }, { 111,5302 }, { 112,5302 },
 { 113,5302 }, { 114,5302 }, { 115,5302 }, { 116,5302 }, { 117,5302 },
 { 118,5302 }, { 119,5302 }, { 120,5302 }, { 121,5302 }, { 122,5302 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5302 }, { 129,5302 }, { 130,5302 }, { 131,5302 }, { 132,5302 },
 { 133,5302 }, { 134,5302 }, { 135,5302 }, { 136,5302 }, { 137,5302 },

 { 138,5302 }, { 139,5302 }, { 140,5302 }, { 141,5302 }, { 142,5302 },
 { 143,5302 }, { 144,5302 }, { 145,5302 }, { 146,5302 }, { 147,5302 },
 { 148,5302 }, { 149,5302 }, { 150,5302 }, { 151,5302 }, { 152,5302 },
 { 153,5302 }, { 154,5302 }, { 155,5302 }, { 156,5302 }, { 157,5302 },
 { 158,5302 }, { 159,5302 }, { 160,5302 }, { 161,5302 }, { 162,5302 },
 { 163,5302 }, { 164,5302 }, { 165,5302 }, { 166,5302 }, { 167,5302 },
 { 168,5302 }, { 169,5302 }, { 170,5302 }, { 171,5302 }, { 172,5302 },
 { 173,5302 }, { 174,5302 }, { 175,5302 }, { 176,5302 }, { 177,5302 },
 { 178,5302 }, { 179,5302 }, { 180,5302 }, { 181,5302 }, { 182,5302 },
 { 183,5302 }, { 184,5302 }, { 185,5302 }, { 186,5302 }, { 187,5302 },

 { 188,5302 }, { 189,5302 }, { 190,5302 }, { 191,5302 }, { 192,5302 },
 { 193,5302 }, { 194,5302 }, { 195,5302 }, { 196,5302 }, { 197,5302 },
 { 198,5302 }, { 199,5302 }, { 200,5302 }, { 201,5302 }, { 202,5302 },
 { 203,5302 }, { 204,5302 }, { 205,5302 }, { 206,5302 }, { 207,5302 },
 { 208,5302 }, { 209,5302 }, { 210,5302 }, { 211,5302 }, { 212,5302 },
 { 213,5302 }, { 214,5302 }, { 215,5302 }, { 216,5302 }, { 217,5302 },
 { 218,5302 }, { 219,5302 }, { 220,5302 }, { 221,5302 }, { 222,5302 },
 { 223,5302 }, { 224,5302 }, { 225,5302 }, { 226,5302 }, { 227,5302 },
 { 228,5302 }, { 229,5302 }, { 230,5302 }, { 231,5302 }, { 232,5302 },
 { 233,5302 }, { 234,5302 }, { 235,5302 }, { 236,5302 }, { 237,5302 },

 { 238,5302 }, { 239,5302 }, { 240,5302 }, { 241,5302 }, { 242,5302 },
 { 243,5302 }, { 244,5302 }, { 245,5302 }, { 246,5302 }, { 247,5302 },
 { 248,5302 }, { 249,5302 }, { 250,5302 }, { 251,5302 }, { 252,5302 },
 { 253,5302 }, { 254,5302 }, { 255,5302 }, {   0,  33 }, {   0,13720 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-5801 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,5302 }, {  49,5302 }, {  50,5302 },
 {  51,5302 }, {  52,5302 }, {  53,5302 }, {  54,5302 }, {  55,5302 },
 {  56,5302 }, {  57,5302 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5302 },
 {  66,5302 }, {  67,5302 }, {  68,5302 }, {  69,5302 }, {  70,5302 },
 {  71,5302 }, {  72,5302 }, {  73,5302 }, {  74,5302 }, {  75,5302 },
 {  76,5302 }, {  77,5302 }, {  78,5302 }, {  79,5302 }, {  80,5302 },

 {  81,5302 }, {  82,5302 }, {  83,5302 }, {  84,5302 }, {  85,5302 },
 {  86,5302 }, {  87,5302 }, {  88,5302 }, {  89,5302 }, {  90,5302 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5302 },
 {   0,   0 }, {  97,5302 }, {  98,5302 }, {  99,5302 }, { 100,5302 },
 { 101,5302 }, { 102,5302 }, { 103,5302 }, { 104,5302 }, { 105,5302 },
 { 106,5302 }, { 107,5302 }, { 108,5302 }, { 109,5302 }, { 110,5302 },
 { 111,5302 }, { 112,5302 }, { 113,5302 }, { 114,5302 }, { 115,5302 },
 { 116,5302 }, { 117,5302 }, { 118,5302 }, { 119,5302 }, { 120,5302 },
 { 121,5302 }, { 122,5302 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5302 }, { 129,5302 }, { 130,5302 },

 { 131,5302 }, { 132,5302 }, { 133,5302 }, { 134,5302 }, { 135,5302 },
 { 136,5302 }, { 137,5302 }, { 138,5302 }, { 139,5302 }, { 140,5302 },
 { 141,5302 }, { 142,5302 }, { 143,5302 }, { 144,5302 }, { 145,5302 },
 { 146,5302 }, { 147,5302 }, { 148,5302 }, { 149,5302 }, { 150,5302 },
 { 151,5302 }, { 152,5302 }, { 153,5302 }, { 154,5302 }, { 155,5302 },
 { 156,5302 }, { 157,5302 }, { 158,5302 }, { 159,5302 }, { 160,5302 },
 { 161,5302 }, { 162,5302 }, { 163,5302 }, { 164,5302 }, { 165,5302 },
 { 166,5302 }, { 167,5302 }, { 168,5302 }, { 169,5302 }, { 170,5302 },
 { 171,5302 }, { 172,5302 }, { 173,5302 }, { 174,5302 }, { 175,5302 },
 { 176,5302 }, { 177,5302 }, { 178,5302 }, { 179,5302 }, { 180,5302 },

 { 181,5302 }, { 182,5302 }, { 183,5302 }, { 184,5302 }, { 185,5302 },
 { 186,5302 }, { 187,5302 }, { 188,5302 }, { 189,5302 }, { 190,5302 },
 { 191,5302 }, { 192,5302 }, { 193,5302 }, { 194,5302 }, { 195,5302 },
 { 196,5302 }, { 197,5302 }, { 198,5302 }, { 199,5302 }, { 200,5302 },
 { 201,5302 }, { 202,5302 }, { 203,5302 }, { 204,5302 }, { 205,5302 },
 { 206,5302 }, { 207,5302 }, { 208,5302 }, { 209,5302 }, { 210,5302 },
 { 211,5302 }, { 212,5302 }, { 213,5302 }, { 214,5302 }, { 215,5302 },
 { 216,5302 }, { 217,5302 }, { 218,5302 }, { 219,5302 }, { 220,5302 },
 { 221,5302 }, { 222,5302 }, { 223,5302 }, { 224,5302 }, { 225,5302 },
 { 226,5302 }, { 227,5302 }, { 228,5302 }, { 229,5302 }, { 230,5302 },

 { 231,5302 }, { 232,5302 }, { 233,5302 }, { 234,5302 }, { 235,5302 },
 { 236,5302 }, { 237,5302 }, { 238,5302 }, { 239,5302 }, { 240,5302 },
 { 241,5302 }, { 242,5302 }, { 243,5302 }, { 244,5302 }, { 245,5302 },
 { 246,5302 }, { 247,5302 }, { 248,5302 }, { 249,5302 }, { 250,5302 },
 { 251,5302 }, { 252,5302 }, { 253,5302 }, { 254,5302 }, { 255,5302 },
 {   0,   1 }, {   0,13463 }, {   1,5302 }, {   2,5302 }, {   3,5302 },
 {   4,5302 }, {   5,5302 }, {   6,5302 }, {   7,5302 }, {   8,5302 },
 {   9,5302 }, {   0,   0 }, {  11,5302 }, {  12,5302 }, {   0,   0 },
 {  14,5302 }, {  15,5302 }, {  16,5302 }, {  17,5302 }, {  18,5302 },
 {  19,5302 }, {  20,5302 }, {  21,5302 }, {  22,5302 }, {  23,5302 },

 {  24,5302 }, {  25,5302 }, {  26,5302 }, {  27,5302 }, {  28,5302 },
 {  29,5302 }, {  30,5302 }, {  31,5302 }, {  32,5302 }, {  33,5560 },
 {  34,5302 }, {  35,5560 }, {  36,5302 }, {  37,5560 }, {  38,5560 },
 {  39,5302 }, {  40,5302 }, {  41,5302 }, {  42,5560 }, {  43,5560 },
 {  44,5302 }, {  45,5560 }, {  46,5302 }, {  47,5560 }, {  48,5302 },
 {  49,5302 }, {  50,5302 }, {  51,5302 }, {  52,5302 }, {  53,5302 },
 {  54,5302 }, {  55,5302 }, {  56,5302 }, {  57,5302 }, {  58,5302 },
 {  59,5302 }, {  60,5560 }, {  61,5560 }, {  62,5560 }, {  63,5560 },
 {  64,5560 }, {  65,5302 }, {  66,5302 }, {  67,5302 }, {  68,5302 },
 {  69,5302 }, {  70,5302 }, {  71,5302 }, {  72,5302 }, {  73,5302 },

 {  74,5302 }, {  75,5302 }, {  76,5302 }, {  77,5302 }, {  78,5302 },
 {  79,5302 }, {  80,5302 }, {  81,5302 }, {  82,5302 }, {  83,5302 },
 {  84,5302 }, {  85,5302 }, {  86,5302 }, {  87,5302 }, {  88,5302 },
 {  89,5302 }, {  90,5302 }, {  91,5302 }, {  92,5302 }, {  93,5302 },
 {  94,5560 }, {  95,5302 }, {  96,5560 }, {  97,5302 }, {  98,5302 },
 {  99,5302 }, { 100,5302 }, { 101,5302 }, { 102,5302 }, { 103,5302 },
 { 104,5302 }, { 105,5302 }, { 106,5302 }, { 107,5302 }, { 108,5302 },
 { 109,5302 }, { 110,5302 }, { 111,5302 }, { 112,5302 }, { 113,5302 },
 { 114,5302 }, { 115,5302 }, { 116,5302 }, { 117,5302 }, { 118,5302 },
 { 119,5302 }, { 120,5302 }, { 121,5302 }, { 122,5302 }, { 123,5302 },

 { 124,5560 }, { 125,5302 }, { 126,5560 }, { 127,5302 }, { 128,5302 },
 { 129,5302 }, { 130,5302 }, { 131,5302 }, { 132,5302 }, { 133,5302 },
 { 134,5302 }, { 135,5302 }, { 136,5302 }, { 137,5302 }, { 138,5302 },
 { 139,5302 }, { 140,5302 }, { 141,5302 }, { 142,5302 }, { 143,5302 },
 { 144,5302 }, { 145,5302 }, { 146,5302 }, { 147,5302 }, { 148,5302 },
 { 149,5302 }, { 150,5302 }, { 151,5302 }, { 152,5302 }, { 153,5302 },
 { 154,5302 }, { 155,5302 }, { 156,5302 }, { 157,5302 }, { 158,5302 },
 { 159,5302 }, { 160,5302 }, { 161,5302 }, { 162,5302 }, { 163,5302 },
 { 164,5302 }, { 165,5302 }, { 166,5302 }, { 167,5302 }, { 168,5302 },
 { 169,5302 }, { 170,5302 }, { 171,5302 }, { 172,5302 }, { 173,5302 },

 { 174,5302 }, { 175,5302 }, { 176,5302 }, { 177,5302 }, { 178,5302 },
 { 179,5302 }, { 180,5302 }, { 181,5302 }, { 182,5302 }, { 183,5302 },
 { 184,5302 }, { 185,5302 }, { 186,5302 }, { 187,5302 }, { 188,5302 },
 { 189,5302 }, { 190,5302 }, { 191,5302 }, { 192,5302 }, { 193,5302 },
 { 194,5302 }, { 195,5302 }, { 196,5302 }, { 197,5302 }, { 198,5302 },
 { 199,5302 }, { 200,5302 }, { 201,5302 }, { 202,5302 }, { 203,5302 },
 { 204,5302 }, { 205,5302 }, { 206,5302 }, { 207,5302 }, { 208,5302 },
 { 209,5302 }, { 210,5302 }, { 211,5302 }, { 212,5302 }, { 213,5302 },
 { 214,5302 }, { 215,5302 }, { 216,5302 }, { 217,5302 }, { 218,5302 },
 { 219,5302 }, { 220,5302 }, { 221,5302 }, { 222,5302 }, { 223,5302 },

 { 224,5302 }, { 225,5302 }, { 226,5302 }, { 227,5302 }, { 228,5302 },
 { 229,5302 }, { 230,5302 }, { 231,5302 }, { 232,5302 }, { 233,5302 },
 { 234,5302 }, { 235,5302 }, { 236,5302 }, { 237,5302 }, { 238,5302 },
 { 239,5302 }, { 240,5302 }, { 241,5302 }, { 242,5302 }, { 243,5302 },
 { 244,5302 }, { 245,5302 }, { 246,5302 }, { 247,5302 }, { 248,5302 },
 { 249,5302 }, { 250,5302 }, { 251,5302 }, { 252,5302 }, { 253,5302 },
 { 254,5302 }, { 255,5302 }, { 256,5302 }, {   0,  58 }, {   0,13205 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5560 },

 {  66,5560 }, {  67,5560 }, {  68,5560 }, {  69,5817 }, {  70,5560 },
 {  71,5560 }, {  72,5560 }, {  73,5560 }, {  74,5560 }, {  75,5560 },
 {  76,5560 }, {  77,5560 }, {  78,5560 }, {  79,5560 }, {  80,5560 },
 {  81,5560 }, {  82,5560 }, {  83,5560 }, {  84,5560 }, {  85,5560 },
 {  86,5560 }, {  87,5560 }, {  88,5560 }, {  89,5560 }, {  90,5560 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5560 },
 {   0,   0 }, {  97,5560 }, {  98,5560 }, {  99,5560 }, { 100,5560 },
 { 101,5817 }, { 102,5560 }, { 103,5560 }, { 104,5560 }, { 105,5560 },
 { 106,5560 }, { 107,5560 }, { 108,5560 }, { 109,5560 }, { 110,5560 },
 { 111,5560 }, { 112,5560 }, { 113,5560 }, { 114,5560 }, { 115,5560 },

 { 116,5560 }, { 117,5560 }, { 118,5560 }, { 119,5560 }, { 120,5560 },
 { 121,5560 }, { 122,5560 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5560 }, { 129,5560 }, { 130,5560 },
 { 131,5560 }, { 132,5560 }, { 133,5560 }, { 134,5560 }, { 135,5560 },
 { 136,5560 }, { 137,5560 }, { 138,5560 }, { 139,5560 }, { 140,5560 },
 { 141,5560 }, { 142,5560 }, { 143,5560 }, { 144,5560 }, { 145,5560 },
 { 146,5560 }, { 147,5560 }, { 148,5560 }, { 149,5560 }, { 150,5560 },
 { 151,5560 }, { 152,5560 }, { 153,5560 }, { 154,5560 }, { 155,5560 },
 { 156,5560 }, { 157,5560 }, { 158,5560 }, { 159,5560 }, { 160,5560 },
 { 161,5560 }, { 162,5560 }, { 163,5560 }, { 164,5560 }, { 165,5560 },

 { 166,5560 }, { 167,5560 }, { 168,5560 }, { 169,5560 }, { 170,5560 },
 { 171,5560 }, { 172,5560 }, { 173,5560 }, { 174,5560 }, { 175,5560 },
 { 176,5560 }, { 177,5560 }, { 178,5560 }, { 179,5560 }, { 180,5560 },
 { 181,5560 }, { 182,5560 }, { 183,5560 }, { 184,5560 }, { 185,5560 },
 { 186,5560 }, { 187,5560 }, { 188,5560 }, { 189,5560 }, { 190,5560 },
 { 191,5560 }, { 192,5560 }, { 193,5560 }, { 194,5560 }, { 195,5560 },
 { 196,5560 }, { 197,5560 }, { 198,5560 }, { 199,5560 }, { 200,5560 },
 { 201,5560 }, { 202,5560 }, { 203,5560 }, { 204,5560 }, { 205,5560 },
 { 206,5560 }, { 207,5560 }, { 208,5560 }, { 209,5560 }, { 210,5560 },
 { 211,5560 }, { 212,5560 }, { 213,5560 }, { 214,5560 }, { 215,5560 },

 { 216,5560 }, { 217,5560 }, { 218,5560 }, { 219,5560 }, { 220,5560 },
 { 221,5560 }, { 222,5560 }, { 223,5560 }, { 224,5560 }, { 225,5560 },
 { 226,5560 }, { 227,5560 }, { 228,5560 }, { 229,5560 }, { 230,5560 },
 { 231,5560 }, { 232,5560 }, { 233,5560 }, { 234,5560 }, { 235,5560 },
 { 236,5560 }, { 237,5560 }, { 238,5560 }, { 239,5560 }, { 240,5560 },
 { 241,5560 }, { 242,5560 }, { 243,5560 }, { 244,5560 }, { 245,5560 },
 { 246,5560 }, { 247,5560 }, { 248,5560 }, { 249,5560 }, { 250,5560 },
 { 251,5560 }, { 252,5560 }, { 253,5560 }, { 254,5560 }, { 255,5560 },
 {   0,   2 }, {   0,12948 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  58 }, {   0,12916 }, {  33,5817 },
 {   0,   0 }, {  35,5817 }, {   0,   0 }, {  37,5817 }, {  38,5817 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,5817 }, {  43,5817 },
 {   0,   0 }, {  45,5817 }, {   0,   0 }, {  47,5817 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  60,5817 }, {  61,5817 }, {  62,5817 }, {  63,5817 },
 {  64,5817 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,-6324 },
 {   0,   0 }, {  48,5817 }, {  49,5817 }, {  50,5817 }, {  51,5817 },
 {  52,5817 }, {  53,5817 }, {  54,5817 }, {  55,5817 }, {  56,5817 },
 {  57,5817 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,5817 }, {   0,   0 }, {  96,5817 }, {  65,5271 }, {  66,5271 },
 {  67,5271 }, {  68,5271 }, {  69,5528 }, {  70,5271 }, {  71,5271 },
 {  72,5271 }, {  73,5271 }, {  74,5271 }, {  75,5271 }, {  76,5271 },

 {  77,5271 }, {  78,5271 }, {  79,5271 }, {  80,5271 }, {  81,5271 },
 {  82,5271 }, {  83,5271 }, {  84,5271 }, {  85,5271 }, {  86,5271 },
 {  87,5271 }, {  88,5271 }, {  89,5271 }, {  90,5271 }, {   0,   0 },
 { 124,5817 }, {   0,   0 }, { 126,5817 }, {  95,5271 }, {   0,   0 },
 {  97,5271 }, {  98,5271 }, {  99,5271 }, { 100,5271 }, { 101,5528 },
 { 102,5271 }, { 103,5271 }, { 104,5271 }, { 105,5271 }, { 106,5271 },
 { 107,5271 }, { 108,5271 }, { 109,5271 }, { 110,5271 }, { 111,5271 },
 { 112,5271 }, { 113,5271 }, { 114,5271 }, { 115,5271 }, { 116,5271 },
 { 117,5271 }, { 118,5271 }, { 119,5271 }, { 120,5271 }, { 121,5271 },
 { 122,5271 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, { 128,5271 }, { 129,5271 }, { 130,5271 }, { 131,5271 },
 { 132,5271 }, { 133,5271 }, { 134,5271 }, { 135,5271 }, { 136,5271 },
 { 137,5271 }, { 138,5271 }, { 139,5271 }, { 140,5271 }, { 141,5271 },
 { 142,5271 }, { 143,5271 }, { 144,5271 }, { 145,5271 }, { 146,5271 },
 { 147,5271 }, { 148,5271 }, { 149,5271 }, { 150,5271 }, { 151,5271 },
 { 152,5271 }, { 153,5271 }, { 154,5271 }, { 155,5271 }, { 156,5271 },
 { 157,5271 }, { 158,5271 }, { 159,5271 }, { 160,5271 }, { 161,5271 },
 { 162,5271 }, { 163,5271 }, { 164,5271 }, { 165,5271 }, { 166,5271 },
 { 167,5271 }, { 168,5271 }, { 169,5271 }, { 170,5271 }, { 171,5271 },
 { 172,5271 }, { 173,5271 }, { 174,5271 }, { 175,5271 }, { 176,5271 },

 { 177,5271 }, { 178,5271 }, { 179,5271 }, { 180,5271 }, { 181,5271 },
 { 182,5271 }, { 183,5271 }, { 184,5271 }, { 185,5271 }, { 186,5271 },
 { 187,5271 }, { 188,5271 }, { 189,5271 }, { 190,5271 }, { 191,5271 },
 { 192,5271 }, { 193,5271 }, { 194,5271 }, { 195,5271 }, { 196,5271 },
 { 197,5271 }, { 198,5271 }, { 199,5271 }, { 200,5271 }, { 201,5271 },
 { 202,5271 }, { 203,5271 }, { 204,5271 }, { 205,5271 }, { 206,5271 },
 { 207,5271 }, { 208,5271 }, { 209,5271 }, { 210,5271 }, { 211,5271 },
 { 212,5271 }, { 213,5271 }, { 214,5271 }, { 215,5271 }, { 216,5271 },
 { 217,5271 }, { 218,5271 }, { 219,5271 }, { 220,5271 }, { 221,5271 },
 { 222,5271 }, { 223,5271 }, { 224,5271 }, { 225,5271 }, { 226,5271 },

 { 227,5271 }, { 228,5271 }, { 229,5271 }, { 230,5271 }, { 231,5271 },
 { 232,5271 }, { 233,5271 }, { 234,5271 }, { 235,5271 }, { 236,5271 },
 { 237,5271 }, { 238,5271 }, { 239,5271 }, { 240,5271 }, { 241,5271 },
 { 242,5271 }, { 243,5271 }, { 244,5271 }, { 245,5271 }, { 246,5271 },
 { 247,5271 }, { 248,5271 }, { 249,5271 }, { 250,5271 }, { 251,5271 },
 { 252,5271 }, { 253,5271 }, { 254,5271 }, { 255,5271 }, {   0,  57 },
 {   0,12659 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,-257 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 257 }, {  66, 257 }, {  67, 257 }, {  68, 257 }, {  69, 514 },

 {  70, 257 }, {  71, 257 }, {  72, 257 }, {  73, 257 }, {  74, 257 },
 {  75, 257 }, {  76, 257 }, {  77, 257 }, {  78, 257 }, {  79, 257 },
 {  80, 257 }, {  81, 257 }, {  82, 257 }, {  83, 257 }, {  84, 257 },
 {  85, 257 }, {  86, 257 }, {  87, 257 }, {  88, 257 }, {  89, 257 },
 {  90, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95, 257 }, {   0,   0 }, {  97, 257 }, {  98, 257 }, {  99, 257 },
 { 100, 257 }, { 101, 514 }, { 102, 257 }, { 103, 257 }, { 104, 257 },
 { 105, 257 }, { 106, 257 }, { 107, 257 }, { 108, 257 }, { 109, 257 },
 { 110, 257 }, { 111, 257 }, { 112, 257 }, { 113, 257 }, { 114, 257 },
 { 115, 257 }, { 116, 257 }, { 117, 257 }, { 118, 257 }, { 119, 257 },

 { 120, 257 }, { 121, 257 }, { 122, 257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128, 257 }, { 129, 257 },
 { 130, 257 }, { 131, 257 }, { 132, 257 }, { 133, 257 }, { 134, 257 },
 { 135, 257 }, { 136, 257 }, { 137, 257 }, { 138, 257 }, { 139, 257 },
 { 140, 257 }, { 141, 257 }, { 142, 257 }, { 143, 257 }, { 144, 257 },
 { 145, 257 }, { 146, 257 }, { 147, 257 }, { 148, 257 }, { 149, 257 },
 { 150, 257 }, { 151, 257 }, { 152, 257 }, { 153, 257 }, { 154, 257 },
 { 155, 257 }, { 156, 257 }, { 157, 257 }, { 158, 257 }, { 159, 257 },
 { 160, 257 }, { 161, 257 }, { 162, 257 }, { 163, 257 }, { 164, 257 },
 { 165, 257 }, { 166, 257 }, { 167, 257 }, { 168, 257 }, { 169, 257 },

 { 170, 257 }, { 171, 257 }, { 172, 257 }, { 173, 257 }, { 174, 257 },
 { 175, 257 }, { 176, 257 }, { 177, 257 }, { 178, 257 }, { 179, 257 },
 { 180, 257 }, { 181, 257 }, { 182, 257 }, { 183, 257 }, { 184, 257 },
 { 185, 257 }, { 186, 257 }, { 187, 257 }, { 188, 257 }, { 189, 257 },
 { 190, 257 }, { 191, 257 }, { 192, 257 }, { 193, 257 }, { 194, 257 },
 { 195, 257 }, { 196, 257 }, { 197, 257 }, { 198, 257 }, { 199, 257 },
 { 200, 257 }, { 201, 257 }, { 202, 257 }, { 203, 257 }, { 204, 257 },
 { 205, 257 }, { 206, 257 }, { 207, 257 }, { 208, 257 }, { 209, 257 },
 { 210, 257 }, { 211, 257 }, { 212, 257 }, { 213, 257 }, { 214, 257 },
 { 215, 257 }, { 216, 257 }, { 217, 257 }, { 218, 257 }, { 219, 257 },

 { 220, 257 }, { 221, 257 }, { 222, 257 }, { 223, 257 }, { 224, 257 },
 { 225, 257 }, { 226, 257 }, { 227, 257 }, { 228, 257 }, { 229, 257 },
 { 230, 257 }, { 231, 257 }, { 232, 257 }, { 233, 257 }, { 234, 257 },
 { 235, 257 }, { 236, 257 }, { 237, 257 }, { 238, 257 }, { 239, 257 },
 { 240, 257 }, { 241, 257 }, { 242, 257 }, { 243, 257 }, { 244, 257 },
 { 245, 257 }, { 246, 257 }, { 247, 257 }, { 248, 257 }, { 249, 257 },
 { 250, 257 }, { 251, 257 }, { 252, 257 }, { 253, 257 }, { 254, 257 },
 { 255, 257 }, {   0,  62 }, {   0,12402 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5560 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,5560 }, {  49,5560 }, {  50,5560 }, {  51,5560 }, {  52,5560 },
 {  53,5560 }, {  54,5560 }, {  55,5560 }, {  56,5560 }, {  57,5560 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,5560 }, {  66,5560 }, {  67,5560 },
 {  68,5560 }, {  69,5560 }, {  70,5560 }, {  71,5560 }, {  72,5560 },
 {  73,5560 }, {  74,5560 }, {  75,5560 }, {  76,5560 }, {  77,5560 },
 {  78,5560 }, {  79,5560 }, {  80,5560 }, {  81,5560 }, {  82,5560 },
 {  83,5560 }, {  84,5560 }, {  85,5560 }, {  86,5560 }, {  87,5560 },
 {  88,5560 }, {  89,5560 }, {  90,5560 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5560 }, {   0,   0 }, {  97,5560 },
 {  98,5560 }, {  99,5560 }, { 100,5560 }, { 101,5560 }, { 102,5560 },
 { 103,5560 }, { 104,5560 }, { 105,5560 }, { 106,5560 }, { 107,5560 },
 { 108,5560 }, { 109,5560 }, { 110,5560 }, { 111,5560 }, { 112,5560 },

 { 113,5560 }, { 114,5560 }, { 115,5560 }, { 116,5560 }, { 117,5560 },
 { 118,5560 }, { 119,5560 }, { 120,5560 }, { 121,5560 }, { 122,5560 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5560 }, { 129,5560 }, { 130,5560 }, { 131,5560 }, { 132,5560 },
 { 133,5560 }, { 134,5560 }, { 135,5560 }, { 136,5560 }, { 137,5560 },
 { 138,5560 }, { 139,5560 }, { 140,5560 }, { 141,5560 }, { 142,5560 },
 { 143,5560 }, { 144,5560 }, { 145,5560 }, { 146,5560 }, { 147,5560 },
 { 148,5560 }, { 149,5560 }, { 150,5560 }, { 151,5560 }, { 152,5560 },
 { 153,5560 }, { 154,5560 }, { 155,5560 }, { 156,5560 }, { 157,5560 },
 { 158,5560 }, { 159,5560 }, { 160,5560 }, { 161,5560 }, { 162,5560 },

 { 163,5560 }, { 164,5560 }, { 165,5560 }, { 166,5560 }, { 167,5560 },
 { 168,5560 }, { 169,5560 }, { 170,5560 }, { 171,5560 }, { 172,5560 },
 { 173,5560 }, { 174,5560 }, { 175,5560 }, { 176,5560 }, { 177,5560 },
 { 178,5560 }, { 179,5560 }, { 180,5560 }, { 181,5560 }, { 182,5560 },
 { 183,5560 }, { 184,5560 }, { 185,5560 }, { 186,5560 }, { 187,5560 },
 { 188,5560 }, { 189,5560 }, { 190,5560 }, { 191,5560 }, { 192,5560 },
 { 193,5560 }, { 194,5560 }, { 195,5560 }, { 196,5560 }, { 197,5560 },
 { 198,5560 }, { 199,5560 }, { 200,5560 }, { 201,5560 }, { 202,5560 },
 { 203,5560 }, { 204,5560 }, { 205,5560 }, { 206,5560 }, { 207,5560 },
 { 208,5560 }, { 209,5560 }, { 210,5560 }, { 211,5560 }, { 212,5560 },

 { 213,5560 }, { 214,5560 }, { 215,5560 }, { 216,5560 }, { 217,5560 },
 { 218,5560 }, { 219,5560 }, { 220,5560 }, { 221,5560 }, { 222,5560 },
 { 223,5560 }, { 224,5560 }, { 225,5560 }, { 226,5560 }, { 227,5560 },
 { 228,5560 }, { 229,5560 }, { 230,5560 }, { 231,5560 }, { 232,5560 },
 { 233,5560 }, { 234,5560 }, { 235,5560 }, { 236,5560 }, { 237,5560 },
 { 238,5560 }, { 239,5560 }, { 240,5560 }, { 241,5560 }, { 242,5560 },
 { 243,5560 }, { 244,5560 }, { 245,5560 }, { 246,5560 }, { 247,5560 },
 { 248,5560 }, { 249,5560 }, { 250,5560 }, { 251,5560 }, { 252,5560 },
 { 253,5560 }, { 254,5560 }, { 255,5560 }, {   0,  62 }, {   0,12145 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,5303 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  43,5560 }, {   0,   0 }, {  45,5560 },
 {   0,   0 }, {   0,   0 }, {  48,5570 }, {  49,5570 }, {  50,5570 },
 {  51,5570 }, {  52,5570 }, {  53,5570 }, {  54,5570 }, {  55,5570 },

 {  56,5570 }, {  57,5570 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5303 },
 {  66,5303 }, {  67,5303 }, {  68,5303 }, {  69,5303 }, {  70,5303 },
 {  71,5303 }, {  72,5303 }, {  73,5303 }, {  74,5303 }, {  75,5303 },
 {  76,5303 }, {  77,5303 }, {  78,5303 }, {  79,5303 }, {  80,5303 },
 {  81,5303 }, {  82,5303 }, {  83,5303 }, {  84,5303 }, {  85,5303 },
 {  86,5303 }, {  87,5303 }, {  88,5303 }, {  89,5303 }, {  90,5303 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5303 },
 {   0,   0 }, {  97,5303 }, {  98,5303 }, {  99,5303 }, { 100,5303 },
 { 101,5303 }, { 102,5303 }, { 103,5303 }, { 104,5303 }, { 105,5303 },

 { 106,5303 }, { 107,5303 }, { 108,5303 }, { 109,5303 }, { 110,5303 },
 { 111,5303 }, { 112,5303 }, { 113,5303 }, { 114,5303 }, { 115,5303 },
 { 116,5303 }, { 117,5303 }, { 118,5303 }, { 119,5303 }, { 120,5303 },
 { 121,5303 }, { 122,5303 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5303 }, { 129,5303 }, { 130,5303 },
 { 131,5303 }, { 132,5303 }, { 133,5303 }, { 134,5303 }, { 135,5303 },
 { 136,5303 }, { 137,5303 }, { 138,5303 }, { 139,5303 }, { 140,5303 },
 { 141,5303 }, { 142,5303 }, { 143,5303 }, { 144,5303 }, { 145,5303 },
 { 146,5303 }, { 147,5303 }, { 148,5303 }, { 149,5303 }, { 150,5303 },
 { 151,5303 }, { 152,5303 }, { 153,5303 }, { 154,5303 }, { 155,5303 },

 { 156,5303 }, { 157,5303 }, { 158,5303 }, { 159,5303 }, { 160,5303 },
 { 161,5303 }, { 162,5303 }, { 163,5303 }, { 164,5303 }, { 165,5303 },
 { 166,5303 }, { 167,5303 }, { 168,5303 }, { 169,5303 }, { 170,5303 },
 { 171,5303 }, { 172,5303 }, { 173,5303 }, { 174,5303 }, { 175,5303 },
 { 176,5303 }, { 177,5303 }, { 178,5303 }, { 179,5303 }, { 180,5303 },
 { 181,5303 }, { 182,5303 }, { 183,5303 }, { 184,5303 }, { 185,5303 },
 { 186,5303 }, { 187,5303 }, { 188,5303 }, { 189,5303 }, { 190,5303 },
 { 191,5303 }, { 192,5303 }, { 193,5303 }, { 194,5303 }, { 195,5303 },
 { 196,5303 }, { 197,5303 }, { 198,5303 }, { 199,5303 }, { 200,5303 },
 { 201,5303 }, { 202,5303 }, { 203,5303 }, { 204,5303 }, { 205,5303 },

 { 206,5303 }, { 207,5303 }, { 208,5303 }, { 209,5303 }, { 210,5303 },
 { 211,5303 }, { 212,5303 }, { 213,5303 }, { 214,5303 }, { 215,5303 },
 { 216,5303 }, { 217,5303 }, { 218,5303 }, { 219,5303 }, { 220,5303 },
 { 221,5303 }, { 222,5303 }, { 223,5303 }, { 224,5303 }, { 225,5303 },
 { 226,5303 }, { 227,5303 }, { 228,5303 }, { 229,5303 }, { 230,5303 },
 { 231,5303 }, { 232,5303 }, { 233,5303 }, { 234,5303 }, { 235,5303 },
 { 236,5303 }, { 237,5303 }, { 238,5303 }, { 239,5303 }, { 240,5303 },
 { 241,5303 }, { 242,5303 }, { 243,5303 }, { 244,5303 }, { 245,5303 },
 { 246,5303 }, { 247,5303 }, { 248,5303 }, { 249,5303 }, { 250,5303 },
 { 251,5303 }, { 252,5303 }, { 253,5303 }, { 254,5303 }, { 255,5303 },

 {   0,  49 }, {   0,11888 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  51 }, {   0,11877 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-2179 },
 {   0,   0 }, {  35,-2179 }, {   0,   0 }, {  37,-2179 }, {  38,-2179 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-2179 }, {  43,-2179 },
 {  33,-2190 }, {  45,-2179 }, {  35,-2190 }, {  47,-2179 }, {  37,-2190 },

 {  38,-2190 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-2190 },
 {  43,-2190 }, {   0,   0 }, {  45,-2190 }, {   0,   0 }, {  47,-2190 },
 {   0,   0 }, {  60,-2179 }, {  61,-2179 }, {  62,-2179 }, {  63,-2179 },
 {  64,-2179 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,-2190 }, {  61,-2190 }, {  62,-2190 },
 {  63,-2190 }, {  64,-2190 }, {   0,   0 }, {   0,  48 }, {   0,11810 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-2179 }, {   0,   0 }, {  96,-2179 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-2190 }, {   0,   0 }, {  96,-2190 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,-2257 }, {   0,   0 }, {  35,-2257 },
 {   0,   0 }, {  37,-2257 }, {  38,-2257 }, {   0,  50 }, {   0,11770 },
 {   0,   0 }, {  42,-2257 }, {  43,-2257 }, {   0,   0 }, {  45,-2257 },
 { 124,-2179 }, {  47,-2257 }, { 126,-2179 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,-2190 }, {   0,   0 }, { 126,-2190 }, {  60,-2257 },
 {  61,-2257 }, {  62,-2257 }, {  63,-2257 }, {  64,-2257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  33,-2297 }, {   0,   0 }, {  35,-2297 },
 {   0,   0 }, {  37,-2297 }, {  38,-2297 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,-2297 }, {  43,-2297 }, {   0,   0 }, {  45,-2297 },
 {   0,   0 }, {  47,-2297 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-2257 }, {   0,   0 },
 {  96,-2257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,-2297 },
 {  61,-2297 }, {  62,-2297 }, {  63,-2297 }, {  64,-2297 }, {   0,  65 },
 {   0,11704 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-2257 }, {   0,   0 },
 { 126,-2257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-2297 }, {   0,   0 },
 {  96,-2297 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, { 124,-2297 }, {   0,   0 },
 { 126,-2297 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },

 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },

 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },

 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, {   0,  10 }, {   0,11447 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },

 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },

 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },

 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },

 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },

 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,   5 },

 {   0,11189 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {   0,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },

 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },

 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },

 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },

 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },

 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,   3 }, {   0,10931 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  33,4613 }, {   0,   0 }, {  35,4613 }, {   0,   0 },
 {  37,4613 }, {  38,4613 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  42,4613 }, {  43,4613 }, {   0,   0 }, {  45,4613 }, {   0,   0 },
 {  47,4613 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,4613 }, {  61,4613 },
 {  62,4613 }, {  63,4613 }, {  64,4613 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  94,4613 }, {   0,   0 }, {  96,4613 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124,4613 }, {   0,   0 }, { 126,4613 },
 {   0,  43 }, {   0,10803 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 },

 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 },
 {   0,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },

 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },

 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },

 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },

 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,   9 }, {   0,10545 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },

 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },

 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },

 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },

 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },

 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },

 { 256,   0 }, {   0,  21 }, {   0,10287 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },

 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },

 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },

 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },

 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },

 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  18 },
 {   0,10029 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  18 },
 {   0,10024 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 },
 {  10,   5 }, {   0,   0 }, {  12,   0 }, {  13,   5 }, {   9,  16 },
 {  10,  16 }, {   0,   0 }, {  12,  16 }, {  13,  16 }, {   0,   0 },
 {   0,  18 }, {   0,10008 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,   0 }, {  10,   0 }, {  32,   0 }, {  12,   0 }, {  13,   0 },
 {   0,   0 }, {   0,   0 }, {  32,  16 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-9226 },
 {  45,-9223 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-9224 }, {   0,   0 }, {   0,   0 }, {  32,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-9242 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-9240 }, {   0,  18 }, {   0,9961 }, {   1,4029 },
 {   2,4029 }, {   3,4029 }, {   4,4029 }, {   5,4029 }, {   6,4029 },
 {   7,4029 }, {   8,4029 }, {   9,4287 }, {  10, -63 }, {  11,4029 },
 {  12,4287 }, {  13, -63 }, {  14,4029 }, {  15,4029 }, {  16,4029 },
 {  17,4029 }, {  18,4029 }, {  19,4029 }, {  20,4029 }, {  21,4029 },

 {  22,4029 }, {  23,4029 }, {  24,4029 }, {  25,4029 }, {  26,4029 },
 {  27,4029 }, {  28,4029 }, {  29,4029 }, {  30,4029 }, {  31,4029 },
 {  32,4287 }, {  33,4029 }, {  34,4029 }, {  35,4029 }, {  36,4029 },
 {  37,4029 }, {  38,4029 }, {  39,4029 }, {  40,4029 }, {  41,4029 },
 {  42,4029 }, {  43,4029 }, {  44,4029 }, {  45,4545 }, {  46,4029 },
 {  47,4029 }, {  48,4029 }, {  49,4029 }, {  50,4029 }, {  51,4029 },
 {  52,4029 }, {  53,4029 }, {  54,4029 }, {  55,4029 }, {  56,4029 },
 {  57,4029 }, {  58,4029 }, {  59,4029 }, {  60,4029 }, {  61,4029 },
 {  62,4029 }, {  63,4029 }, {  64,4029 }, {  65,4029 }, {  66,4029 },
 {  67,4029 }, {  68,4029 }, {  69,4029 }, {  70,4029 }, {  71,4029 },

 {  72,4029 }, {  73,4029 }, {  74,4029 }, {  75,4029 }, {  76,4029 },
 {  77,4029 }, {  78,4029 }, {  79,4029 }, {  80,4029 }, {  81,4029 },
 {  82,4029 }, {  83,4029 }, {  84,4029 }, {  85,4029 }, {  86,4029 },
 {  87,4029 }, {  88,4029 }, {  89,4029 }, {  90,4029 }, {  91,4029 },
 {  92,4029 }, {  93,4029 }, {  94,4029 }, {  95,4029 }, {  96,4029 },
 {  97,4029 }, {  98,4029 }, {  99,4029 }, { 100,4029 }, { 101,4029 },
 { 102,4029 }, { 103,4029 }, { 104,4029 }, { 105,4029 }, { 106,4029 },
 { 107,4029 }, { 108,4029 }, { 109,4029 }, { 110,4029 }, { 111,4029 },
 { 112,4029 }, { 113,4029 }, { 114,4029 }, { 115,4029 }, { 116,4029 },
 { 117,4029 }, { 118,4029 }, { 119,4029 }, { 120,4029 }, { 121,4029 },

 { 122,4029 }, { 123,4029 }, { 124,4029 }, { 125,4029 }, { 126,4029 },
 { 127,4029 }, { 128,4029 }, { 129,4029 }, { 130,4029 }, { 131,4029 },
 { 132,4029 }, { 133,4029 }, { 134,4029 }, { 135,4029 }, { 136,4029 },
 { 137,4029 }, { 138,4029 }, { 139,4029 }, { 140,4029 }, { 141,4029 },
 { 142,4029 }, { 143,4029 }, { 144,4029 }, { 145,4029 }, { 146,4029 },
 { 147,4029 }, { 148,4029 }, { 149,4029 }, { 150,4029 }, { 151,4029 },
 { 152,4029 }, { 153,4029 }, { 154,4029 }, { 155,4029 }, { 156,4029 },
 { 157,4029 }, { 158,4029 }, { 159,4029 }, { 160,4029 }, { 161,4029 },
 { 162,4029 }, { 163,4029 }, { 164,4029 }, { 165,4029 }, { 166,4029 },
 { 167,4029 }, { 168,4029 }, { 169,4029 }, { 170,4029 }, { 171,4029 },

 { 172,4029 }, { 173,4029 }, { 174,4029 }, { 175,4029 }, { 176,4029 },
 { 177,4029 }, { 178,4029 }, { 179,4029 }, { 180,4029 }, { 181,4029 },
 { 182,4029 }, { 183,4029 }, { 184,4029 }, { 185,4029 }, { 186,4029 },
 { 187,4029 }, { 188,4029 }, { 189,4029 }, { 190,4029 }, { 191,4029 },
 { 192,4029 }, { 193,4029 }, { 194,4029 }, { 195,4029 }, { 196,4029 },
 { 197,4029 }, { 198,4029 }, { 199,4029 }, { 200,4029 }, { 201,4029 },
 { 202,4029 }, { 203,4029 }, { 204,4029 }, { 205,4029 }, { 206,4029 },
 { 207,4029 }, { 208,4029 }, { 209,4029 }, { 210,4029 }, { 211,4029 },
 { 212,4029 }, { 213,4029 }, { 214,4029 }, { 215,4029 }, { 216,4029 },
 { 217,4029 }, { 218,4029 }, { 219,4029 }, { 220,4029 }, { 221,4029 },

 { 222,4029 }, { 223,4029 }, { 224,4029 }, { 225,4029 }, { 226,4029 },
 { 227,4029 }, { 228,4029 }, { 229,4029 }, { 230,4029 }, { 231,4029 },
 { 232,4029 }, { 233,4029 }, { 234,4029 }, { 235,4029 }, { 236,4029 },
 { 237,4029 }, { 238,4029 }, { 239,4029 }, { 240,4029 }, { 241,4029 },
 { 242,4029 }, { 243,4029 }, { 244,4029 }, { 245,4029 }, { 246,4029 },
 { 247,4029 }, { 248,4029 }, { 249,4029 }, { 250,4029 }, { 251,4029 },
 { 252,4029 }, { 253,4029 }, { 254,4029 }, { 255,4029 }, { 256,4029 },
 {   0,  22 }, {   0,9703 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 },

 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },

 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {   0,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },

 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },

 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },

 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  29 }, {   0,9445 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,  27 }, {   0,9437 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,9414 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,4287 }, {  49,4287 }, {  50,4287 },
 {  51,4287 }, {  52,4287 }, {  53,4287 }, {  54,4287 }, {  55,4287 },

 {  48,4287 }, {  49,4287 }, {  50,4287 }, {  51,4287 }, {  52,4287 },
 {  53,4287 }, {  54,4287 }, {  55,4287 }, {  56,4287 }, {  57,4287 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,9376 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4287 }, {  66,4287 }, {  67,4287 },
 {  68,4287 }, {  69,4287 }, {  70,4287 }, {  48,4287 }, {  49,4287 },
 {  50,4287 }, {  51,4287 }, {  52,4287 }, {  53,4287 }, {  54,4287 },
 {  55,4287 }, {  56,4287 }, {  57,4287 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4287 }, {  66,4287 }, {  67,4287 }, {  68,4287 }, {  69,4287 },
 {  70,4287 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,4287 },

 {  98,4287 }, {  99,4287 }, { 100,4287 }, { 101,4287 }, { 102,4287 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,4287 }, {  49,4287 }, {  50,4287 }, {  51,4287 },
 {  52,4287 }, {  53,4287 }, {  54,4287 }, {  55,4287 }, {  56,4287 },
 {  57,4287 }, {   0,   0 }, {  97,4287 }, {  98,4287 }, {  99,4287 },
 { 100,4287 }, { 101,4287 }, { 102,4287 }, {  65,4287 }, {  66,4287 },
 {  67,4287 }, {  68,4287 }, {  69,4287 }, {  70,4287 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,4287 }, {  98,4287 }, {  99,4287 }, { 100,4287 }, { 101,4287 },
 { 102,4287 }, {   0,  35 }, {   0,9272 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },

 {  33,   0 }, {  34,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },

 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },

 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },

 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },

 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  36 },
 {   0,9014 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-10230 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3997 }, {  49,3997 },
 {  50,3997 }, {  51,3997 }, {  52,3997 }, {  53,3997 }, {  54,3997 },
 {  55,3997 }, {  56,3997 }, {  57,3997 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,3997 }, {  66,3997 }, {  67,3997 }, {  68,3997 }, {  69,3997 },
 {  70,3997 }, {  71,3997 }, {  72,3997 }, {  73,3997 }, {  74,3997 },

 {  75,3997 }, {  76,3997 }, {  77,3997 }, {  78,3997 }, {  79,3997 },
 {  80,3997 }, {  81,3997 }, {  82,3997 }, {  83,3997 }, {  84,3997 },
 {  85,3997 }, {  86,3997 }, {  87,3997 }, {  88,3997 }, {  89,3997 },
 {  90,3997 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,3997 }, {   0,   0 }, {  97,3997 }, {  98,3997 }, {  99,3997 },
 { 100,3997 }, { 101,3997 }, { 102,3997 }, { 103,3997 }, { 104,3997 },
 { 105,3997 }, { 106,3997 }, { 107,3997 }, { 108,3997 }, { 109,3997 },
 { 110,3997 }, { 111,3997 }, { 112,3997 }, { 113,3997 }, { 114,3997 },
 { 115,3997 }, { 116,3997 }, { 117,3997 }, { 118,3997 }, { 119,3997 },
 { 120,3997 }, { 121,3997 }, { 122,3997 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,3997 }, { 129,3997 },
 { 130,3997 }, { 131,3997 }, { 132,3997 }, { 133,3997 }, { 134,3997 },
 { 135,3997 }, { 136,3997 }, { 137,3997 }, { 138,3997 }, { 139,3997 },
 { 140,3997 }, { 141,3997 }, { 142,3997 }, { 143,3997 }, { 144,3997 },
 { 145,3997 }, { 146,3997 }, { 147,3997 }, { 148,3997 }, { 149,3997 },
 { 150,3997 }, { 151,3997 }, { 152,3997 }, { 153,3997 }, { 154,3997 },
 { 155,3997 }, { 156,3997 }, { 157,3997 }, { 158,3997 }, { 159,3997 },
 { 160,3997 }, { 161,3997 }, { 162,3997 }, { 163,3997 }, { 164,3997 },
 { 165,3997 }, { 166,3997 }, { 167,3997 }, { 168,3997 }, { 169,3997 },
 { 170,3997 }, { 171,3997 }, { 172,3997 }, { 173,3997 }, { 174,3997 },

 { 175,3997 }, { 176,3997 }, { 177,3997 }, { 178,3997 }, { 179,3997 },
 { 180,3997 }, { 181,3997 }, { 182,3997 }, { 183,3997 }, { 184,3997 },
 { 185,3997 }, { 186,3997 }, { 187,3997 }, { 188,3997 }, { 189,3997 },
 { 190,3997 }, { 191,3997 }, { 192,3997 }, { 193,3997 }, { 194,3997 },
 { 195,3997 }, { 196,3997 }, { 197,3997 }, { 198,3997 }, { 199,3997 },
 { 200,3997 }, { 201,3997 }, { 202,3997 }, { 203,3997 }, { 204,3997 },
 { 205,3997 }, { 206,3997 }, { 207,3997 }, { 208,3997 }, { 209,3997 },
 { 210,3997 }, { 211,3997 }, { 212,3997 }, { 213,3997 }, { 214,3997 },
 { 215,3997 }, { 216,3997 }, { 217,3997 }, { 218,3997 }, { 219,3997 },
 { 220,3997 }, { 221,3997 }, { 222,3997 }, { 223,3997 }, { 224,3997 },

 { 225,3997 }, { 226,3997 }, { 227,3997 }, { 228,3997 }, { 229,3997 },
 { 230,3997 }, { 231,3997 }, { 232,3997 }, { 233,3997 }, { 234,3997 },
 { 235,3997 }, { 236,3997 }, { 237,3997 }, { 238,3997 }, { 239,3997 },
 { 240,3997 }, { 241,3997 }, { 242,3997 }, { 243,3997 }, { 244,3997 },
 { 245,3997 }, { 246,3997 }, { 247,3997 }, { 248,3997 }, { 249,3997 },
 { 250,3997 }, { 251,3997 }, { 252,3997 }, { 253,3997 }, { 254,3997 },
 { 255,3997 }, {   0,  27 }, {   0,8757 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,8734 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,3997 }, {  49,3997 }, {  50,3997 }, {  51,3997 }, {  52,3997 },
 {  53,3997 }, {  54,3997 }, {  55,3997 }, {  56,3997 }, {  57,3997 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,3997 }, {  66,3997 }, {  67,3997 },

 {  68,3997 }, {  69,3997 }, {  70,3997 }, {  48,3997 }, {  49,3997 },
 {  50,3997 }, {  51,3997 }, {  52,3997 }, {  53,3997 }, {  54,3997 },
 {  55,3997 }, {  56,3997 }, {  57,3997 }, {   0,  56 }, {   0,8675 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,3997 }, {  66,3997 }, {  67,3997 }, {  68,3997 }, {  69,3997 },
 {  70,3997 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,3997 },
 {  98,3997 }, {  99,3997 }, { 100,3997 }, { 101,3997 }, { 102,3997 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  36,3997 }, {   0,   0 }, {  97,3997 }, {  98,3997 }, {  99,3997 },
 { 100,3997 }, { 101,3997 }, { 102,3997 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3997 }, {  49,3997 }, {  50,3997 },
 {  51,3997 }, {  52,3997 }, {  53,3997 }, {  54,3997 }, {  55,3997 },
 {  56,3997 }, {  57,3997 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3997 },
 {  66,3997 }, {  67,3997 }, {  68,3997 }, {  69,3997 }, {  70,3997 },
 {  71,3997 }, {  72,3997 }, {  73,3997 }, {  74,3997 }, {  75,3997 },
 {  76,3997 }, {  77,3997 }, {  78,3997 }, {  79,3997 }, {  80,3997 },
 {  81,3997 }, {  82,3997 }, {  83,3997 }, {  84,3997 }, {  85,3997 },

 {  86,3997 }, {  87,3997 }, {  88,3997 }, {  89,3997 }, {  90,3997 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3997 },
 {   0,   0 }, {  97,3997 }, {  98,3997 }, {  99,3997 }, { 100,3997 },
 { 101,3997 }, { 102,3997 }, { 103,3997 }, { 104,3997 }, { 105,3997 },
 { 106,3997 }, { 107,3997 }, { 108,3997 }, { 109,3997 }, { 110,3997 },
 { 111,3997 }, { 112,3997 }, { 113,3997 }, { 114,3997 }, { 115,3997 },
 { 116,3997 }, { 117,3997 }, { 118,3997 }, { 119,3997 }, { 120,3997 },
 { 121,3997 }, { 122,3997 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,3997 }, { 129,3997 }, { 130,3997 },
 { 131,3997 }, { 132,3997 }, { 133,3997 }, { 134,3997 }, { 135,3997 },

 { 136,3997 }, { 137,3997 }, { 138,3997 }, { 139,3997 }, { 140,3997 },
 { 141,3997 }, { 142,3997 }, { 143,3997 }, { 144,3997 }, { 145,3997 },
 { 146,3997 }, { 147,3997 }, { 148,3997 }, { 149,3997 }, { 150,3997 },
 { 151,3997 }, { 152,3997 }, { 153,3997 }, { 154,3997 }, { 155,3997 },
 { 156,3997 }, { 157,3997 }, { 158,3997 }, { 159,3997 }, { 160,3997 },
 { 161,3997 }, { 162,3997 }, { 163,3997 }, { 164,3997 }, { 165,3997 },
 { 166,3997 }, { 167,3997 }, { 168,3997 }, { 169,3997 }, { 170,3997 },
 { 171,3997 }, { 172,3997 }, { 173,3997 }, { 174,3997 }, { 175,3997 },
 { 176,3997 }, { 177,3997 }, { 178,3997 }, { 179,3997 }, { 180,3997 },
 { 181,3997 }, { 182,3997 }, { 183,3997 }, { 184,3997 }, { 185,3997 },

 { 186,3997 }, { 187,3997 }, { 188,3997 }, { 189,3997 }, { 190,3997 },
 { 191,3997 }, { 192,3997 }, { 193,3997 }, { 194,3997 }, { 195,3997 },
 { 196,3997 }, { 197,3997 }, { 198,3997 }, { 199,3997 }, { 200,3997 },
 { 201,3997 }, { 202,3997 }, { 203,3997 }, { 204,3997 }, { 205,3997 },
 { 206,3997 }, { 207,3997 }, { 208,3997 }, { 209,3997 }, { 210,3997 },
 { 211,3997 }, { 212,3997 }, { 213,3997 }, { 214,3997 }, { 215,3997 },
 { 216,3997 }, { 217,3997 }, { 218,3997 }, { 219,3997 }, { 220,3997 },
 { 221,3997 }, { 222,3997 }, { 223,3997 }, { 224,3997 }, { 225,3997 },
 { 226,3997 }, { 227,3997 }, { 228,3997 }, { 229,3997 }, { 230,3997 },
 { 231,3997 }, { 232,3997 }, { 233,3997 }, { 234,3997 }, { 235,3997 },

 { 236,3997 }, { 237,3997 }, { 238,3997 }, { 239,3997 }, { 240,3997 },
 { 241,3997 }, { 242,3997 }, { 243,3997 }, { 244,3997 }, { 245,3997 },
 { 246,3997 }, { 247,3997 }, { 248,3997 }, { 249,3997 }, { 250,3997 },
 { 251,3997 }, { 252,3997 }, { 253,3997 }, { 254,3997 }, { 255,3997 },
 {   0,  33 }, {   0,8418 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-11103 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },

 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },

 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },

 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },

 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, {   0,   1 }, {   0,8161 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 }, {  11,   0 },
 {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },

 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },

 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },

 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },

 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },

 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,   1 }, {   0,7903 }, {   1,-258 }, {   2,-258 }, {   3,-258 },
 {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 },
 {   9,-258 }, {   0,   0 }, {  11,-258 }, {  12,-258 }, {   0,   0 },

 {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 },
 {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 },
 {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 },
 {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,-258 }, {  33,   0 },
 {  34,-258 }, {  35,   0 }, {  36,-258 }, {  37,   0 }, {  38,   0 },
 {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,   0 }, {  43,   0 },
 {  44,-258 }, {  45,   0 }, {  46,-258 }, {  47,   0 }, {  48,-258 },
 {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 },
 {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 },
 {  59,-258 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },

 {  64,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 },
 {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 },
 {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 },
 {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 },
 {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 },
 {  94,   0 }, {  95,-258 }, {  96,   0 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 },
 { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 },
 { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 },

 { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 },
 { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 },
 { 124,   0 }, { 125,-258 }, { 126,   0 }, { 127,-258 }, { 128,-258 },
 { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 },
 { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 },
 { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 },
 { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 },
 { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 },
 { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 },
 { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 },

 { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 },
 { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 },
 { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 },
 { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 },
 { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 },
 { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 },
 { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 },
 { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 },
 { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 },
 { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 },

 { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 },
 { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 },
 { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 },
 { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 },
 { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 },
 { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 },
 { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 },
 { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 },
 { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  63 }, {   0,7645 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,3224 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3224 }, {  49,3224 }, {  50,3224 },
 {  51,3224 }, {  52,3224 }, {  53,3224 }, {  54,3224 }, {  55,3224 },

 {  56,3224 }, {  57,3224 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3224 },
 {  66,3224 }, {  67,3224 }, {  68,3224 }, {  69,3224 }, {  70,3224 },
 {  71,3224 }, {  72,3224 }, {  73,3224 }, {  74,3224 }, {  75,3224 },
 {  76,3224 }, {  77,3224 }, {  78,3224 }, {  79,3224 }, {  80,3224 },
 {  81,3224 }, {  82,3224 }, {  83,3224 }, {  84,3224 }, {  85,3224 },
 {  86,3224 }, {  87,3224 }, {  88,3224 }, {  89,3224 }, {  90,3224 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3224 },
 {   0,   0 }, {  97,3224 }, {  98,3224 }, {  99,3224 }, { 100,3224 },
 { 101,3224 }, { 102,3224 }, { 103,3224 }, { 104,3224 }, { 105,3224 },

 { 106,3224 }, { 107,3224 }, { 108,3224 }, { 109,3224 }, { 110,3224 },
 { 111,3224 }, { 112,3224 }, { 113,3224 }, { 114,3224 }, { 115,3224 },
 { 116,3224 }, { 117,3224 }, { 118,3224 }, { 119,3224 }, { 120,3224 },
 { 121,3224 }, { 122,3224 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,3224 }, { 129,3224 }, { 130,3224 },
 { 131,3224 }, { 132,3224 }, { 133,3224 }, { 134,3224 }, { 135,3224 },
 { 136,3224 }, { 137,3224 }, { 138,3224 }, { 139,3224 }, { 140,3224 },
 { 141,3224 }, { 142,3224 }, { 143,3224 }, { 144,3224 }, { 145,3224 },
 { 146,3224 }, { 147,3224 }, { 148,3224 }, { 149,3224 }, { 150,3224 },
 { 151,3224 }, { 152,3224 }, { 153,3224 }, { 154,3224 }, { 155,3224 },

 { 156,3224 }, { 157,3224 }, { 158,3224 }, { 159,3224 }, { 160,3224 },
 { 161,3224 }, { 162,3224 }, { 163,3224 }, { 164,3224 }, { 165,3224 },
 { 166,3224 }, { 167,3224 }, { 168,3224 }, { 169,3224 }, { 170,3224 },
 { 171,3224 }, { 172,3224 }, { 173,3224 }, { 174,3224 }, { 175,3224 },
 { 176,3224 }, { 177,3224 }, { 178,3224 }, { 179,3224 }, { 180,3224 },
 { 181,3224 }, { 182,3224 }, { 183,3224 }, { 184,3224 }, { 185,3224 },
 { 186,3224 }, { 187,3224 }, { 188,3224 }, { 189,3224 }, { 190,3224 },
 { 191,3224 }, { 192,3224 }, { 193,3224 }, { 194,3224 }, { 195,3224 },
 { 196,3224 }, { 197,3224 }, { 198,3224 }, { 199,3224 }, { 200,3224 },
 { 201,3224 }, { 202,3224 }, { 203,3224 }, { 204,3224 }, { 205,3224 },

 { 206,3224 }, { 207,3224 }, { 208,3224 }, { 209,3224 }, { 210,3224 },
 { 211,3224 }, { 212,3224 }, { 213,3224 }, { 214,3224 }, { 215,3224 },
 { 216,3224 }, { 217,3224 }, { 218,3224 }, { 219,3224 }, { 220,3224 },
 { 221,3224 }, { 222,3224 }, { 223,3224 }, { 224,3224 }, { 225,3224 },
 { 226,3224 }, { 227,3224 }, { 228,3224 }, { 229,3224 }, { 230,3224 },
 { 231,3224 }, { 232,3224 }, { 233,3224 }, { 234,3224 }, { 235,3224 },
 { 236,3224 }, { 237,3224 }, { 238,3224 }, { 239,3224 }, { 240,3224 },
 { 241,3224 }, { 242,3224 }, { 243,3224 }, { 244,3224 }, { 245,3224 },
 { 246,3224 }, { 247,3224 }, { 248,3224 }, { 249,3224 }, { 250,3224 },
 { 251,3224 }, { 252,3224 }, { 253,3224 }, { 254,3224 }, { 255,3224 },

 {   0,  63 }, {   0,7388 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,2967 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  43, 803 },
 {   0,   0 }, {  45, 803 }, {   0,   0 }, {   0,   0 }, {  48,3224 },

 {  49,3224 }, {  50,3224 }, {  51,3224 }, {  52,3224 }, {  53,3224 },
 {  54,3224 }, {  55,3224 }, {  56,3224 }, {  57,3224 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,2967 }, {  66,2967 }, {  67,2967 }, {  68,2967 },
 {  69,2967 }, {  70,2967 }, {  71,2967 }, {  72,2967 }, {  73,2967 },
 {  74,2967 }, {  75,2967 }, {  76,2967 }, {  77,2967 }, {  78,2967 },
 {  79,2967 }, {  80,2967 }, {  81,2967 }, {  82,2967 }, {  83,2967 },
 {  84,2967 }, {  85,2967 }, {  86,2967 }, {  87,2967 }, {  88,2967 },
 {  89,2967 }, {  90,2967 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,2967 }, {   0,   0 }, {  97,2967 }, {  98,2967 },

 {  99,2967 }, { 100,2967 }, { 101,2967 }, { 102,2967 }, { 103,2967 },
 { 104,2967 }, { 105,2967 }, { 106,2967 }, { 107,2967 }, { 108,2967 },
 { 109,2967 }, { 110,2967 }, { 111,2967 }, { 112,2967 }, { 113,2967 },
 { 114,2967 }, { 115,2967 }, { 116,2967 }, { 117,2967 }, { 118,2967 },
 { 119,2967 }, { 120,2967 }, { 121,2967 }, { 122,2967 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,2967 },
 { 129,2967 }, { 130,2967 }, { 131,2967 }, { 132,2967 }, { 133,2967 },
 { 134,2967 }, { 135,2967 }, { 136,2967 }, { 137,2967 }, { 138,2967 },
 { 139,2967 }, { 140,2967 }, { 141,2967 }, { 142,2967 }, { 143,2967 },
 { 144,2967 }, { 145,2967 }, { 146,2967 }, { 147,2967 }, { 148,2967 },

 { 149,2967 }, { 150,2967 }, { 151,2967 }, { 152,2967 }, { 153,2967 },
 { 154,2967 }, { 155,2967 }, { 156,2967 }, { 157,2967 }, { 158,2967 },
 { 159,2967 }, { 160,2967 }, { 161,2967 }, { 162,2967 }, { 163,2967 },
 { 164,2967 }, { 165,2967 }, { 166,2967 }, { 167,2967 }, { 168,2967 },
 { 169,2967 }, { 170,2967 }, { 171,2967 }, { 172,2967 }, { 173,2967 },
 { 174,2967 }, { 175,2967 }, { 176,2967 }, { 177,2967 }, { 178,2967 },
 { 179,2967 }, { 180,2967 }, { 181,2967 }, { 182,2967 }, { 183,2967 },
 { 184,2967 }, { 185,2967 }, { 186,2967 }, { 187,2967 }, { 188,2967 },
 { 189,2967 }, { 190,2967 }, { 191,2967 }, { 192,2967 }, { 193,2967 },
 { 194,2967 }, { 195,2967 }, { 196,2967 }, { 197,2967 }, { 198,2967 },

 { 199,2967 }, { 200,2967 }, { 201,2967 }, { 202,2967 }, { 203,2967 },
 { 204,2967 }, { 205,2967 }, { 206,2967 }, { 207,2967 }, { 208,2967 },
 { 209,2967 }, { 210,2967 }, { 211,2967 }, { 212,2967 }, { 213,2967 },
 { 214,2967 }, { 215,2967 }, { 216,2967 }, { 217,2967 }, { 218,2967 },
 { 219,2967 }, { 220,2967 }, { 221,2967 }, { 222,2967 }, { 223,2967 },
 { 224,2967 }, { 225,2967 }, { 226,2967 }, { 227,2967 }, { 228,2967 },
 { 229,2967 }, { 230,2967 }, { 231,2967 }, { 232,2967 }, { 233,2967 },
 { 234,2967 }, { 235,2967 }, { 236,2967 }, { 237,2967 }, { 238,2967 },
 { 239,2967 }, { 240,2967 }, { 241,2967 }, { 242,2967 }, { 243,2967 },
 { 244,2967 }, { 245,2967 }, { 246,2967 }, { 247,2967 }, { 248,2967 },

 { 249,2967 }, { 250,2967 }, { 251,2967 }, { 252,2967 }, { 253,2967 },
 { 254,2967 }, { 255,2967 }, {   0,   2 }, {   0,7131 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  58 },
 {   0,7099 }, {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 },
 {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  42,   0 }, {  43,   0 }, {   0,   0 }, {  45,   0 }, {   0,   0 },
 {  47,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 },
 {  65,-546 }, {  66,-546 }, {  67,-546 }, {  68,-546 }, {  69,-289 },
 {  70,-546 }, {  71,-546 }, {  72,-546 }, {  73,-546 }, {  74,-546 },
 {  75,-546 }, {  76,-546 }, {  77,-546 }, {  78,-546 }, {  79,-546 },
 {  80,-546 }, {  81,-546 }, {  82,-546 }, {  83,-546 }, {  84,-546 },
 {  85,-546 }, {  86,-546 }, {  87,-546 }, {  88,-546 }, {  89,-546 },
 {  90,-546 }, {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 },
 {  95,-546 }, {   0,   0 }, {  97,-546 }, {  98,-546 }, {  99,-546 },
 { 100,-546 }, { 101,-289 }, { 102,-546 }, { 103,-546 }, { 104,-546 },
 { 105,-546 }, { 106,-546 }, { 107,-546 }, { 108,-546 }, { 109,-546 },

 { 110,-546 }, { 111,-546 }, { 112,-546 }, { 113,-546 }, { 114,-546 },
 { 115,-546 }, { 116,-546 }, { 117,-546 }, { 118,-546 }, { 119,-546 },
 { 120,-546 }, { 121,-546 }, { 122,-546 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-546 }, { 129,-546 },
 { 130,-546 }, { 131,-546 }, { 132,-546 }, { 133,-546 }, { 134,-546 },
 { 135,-546 }, { 136,-546 }, { 137,-546 }, { 138,-546 }, { 139,-546 },
 { 140,-546 }, { 141,-546 }, { 142,-546 }, { 143,-546 }, { 144,-546 },
 { 145,-546 }, { 146,-546 }, { 147,-546 }, { 148,-546 }, { 149,-546 },
 { 150,-546 }, { 151,-546 }, { 152,-546 }, { 153,-546 }, { 154,-546 },
 { 155,-546 }, { 156,-546 }, { 157,-546 }, { 158,-546 }, { 159,-546 },

 { 160,-546 }, { 161,-546 }, { 162,-546 }, { 163,-546 }, { 164,-546 },
 { 165,-546 }, { 166,-546 }, { 167,-546 }, { 168,-546 }, { 169,-546 },
 { 170,-546 }, { 171,-546 }, { 172,-546 }, { 173,-546 }, { 174,-546 },
 { 175,-546 }, { 176,-546 }, { 177,-546 }, { 178,-546 }, { 179,-546 },
 { 180,-546 }, { 181,-546 }, { 182,-546 }, { 183,-546 }, { 184,-546 },
 { 185,-546 }, { 186,-546 }, { 187,-546 }, { 188,-546 }, { 189,-546 },
 { 190,-546 }, { 191,-546 }, { 192,-546 }, { 193,-546 }, { 194,-546 },
 { 195,-546 }, { 196,-546 }, { 197,-546 }, { 198,-546 }, { 199,-546 },
 { 200,-546 }, { 201,-546 }, { 202,-546 }, { 203,-546 }, { 204,-546 },
 { 205,-546 }, { 206,-546 }, { 207,-546 }, { 208,-546 }, { 209,-546 },

 { 210,-546 }, { 211,-546 }, { 212,-546 }, { 213,-546 }, { 214,-546 },
 { 215,-546 }, { 216,-546 }, { 217,-546 }, { 218,-546 }, { 219,-546 },
 { 220,-546 }, { 221,-546 }, { 222,-546 }, { 223,-546 }, { 224,-546 },
 { 225,-546 }, { 226,-546 }, { 227,-546 }, { 228,-546 }, { 229,-546 },
 { 230,-546 }, { 231,-546 }, { 232,-546 }, { 233,-546 }, { 234,-546 },
 { 235,-546 }, { 236,-546 }, { 237,-546 }, { 238,-546 }, { 239,-546 },
 { 240,-546 }, { 241,-546 }, { 242,-546 }, { 243,-546 }, { 244,-546 },
 { 245,-546 }, { 246,-546 }, { 247,-546 }, { 248,-546 }, { 249,-546 },
 { 250,-546 }, { 251,-546 }, { 252,-546 }, { 253,-546 }, { 254,-546 },
 { 255,-546 }, {   0,  62 }, {   0,6842 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },

 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },

 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },

 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },

 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },

 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  61 }, {   0,6585 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  60 }, {   0,6575 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  36,-267 }, {   0,   0 }, {  48,2678 }, {  49,2678 }, {  50,2678 },
 {  51,2678 }, {  52,2678 }, {  53,2678 }, {  54,2678 }, {  55,2678 },
 {  56,2678 }, {  57,2678 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2925 },
 {  66,2925 }, {  67,2925 }, {  68,2925 }, {  69,2925 }, {  70,2925 },
 {  71,2925 }, {  72,2925 }, {  73,2925 }, {  74,2925 }, {  75,2925 },
 {  76,2925 }, {  77,2925 }, {  78,2925 }, {  79,2925 }, {  80,2925 },
 {  81,2925 }, {  82,2925 }, {  83,2925 }, {  84,2925 }, {  85,2925 },

 {  86,2925 }, {  87,2925 }, {  88,2925 }, {  89,2925 }, {  90,2925 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2925 },
 {   0,   0 }, {  97,2925 }, {  98,2925 }, {  99,2925 }, { 100,2925 },
 { 101,2925 }, { 102,2925 }, { 103,2925 }, { 104,2925 }, { 105,2925 },
 { 106,2925 }, { 107,2925 }, { 108,2925 }, { 109,2925 }, { 110,2925 },
 { 111,2925 }, { 112,2925 }, { 113,2925 }, { 114,2925 }, { 115,2925 },
 { 116,2925 }, { 117,2925 }, { 118,2925 }, { 119,2925 }, { 120,2925 },
 { 121,2925 }, { 122,2925 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,2925 }, { 129,2925 }, { 130,2925 },
 { 131,2925 }, { 132,2925 }, { 133,2925 }, { 134,2925 }, { 135,2925 },

 { 136,2925 }, { 137,2925 }, { 138,2925 }, { 139,2925 }, { 140,2925 },
 { 141,2925 }, { 142,2925 }, { 143,2925 }, { 144,2925 }, { 145,2925 },
 { 146,2925 }, { 147,2925 }, { 148,2925 }, { 149,2925 }, { 150,2925 },
 { 151,2925 }, { 152,2925 }, { 153,2925 }, { 154,2925 }, { 155,2925 },
 { 156,2925 }, { 157,2925 }, { 158,2925 }, { 159,2925 }, { 160,2925 },
 { 161,2925 }, { 162,2925 }, { 163,2925 }, { 164,2925 }, { 165,2925 },
 { 166,2925 }, { 167,2925 }, { 168,2925 }, { 169,2925 }, { 170,2925 },
 { 171,2925 }, { 172,2925 }, { 173,2925 }, { 174,2925 }, { 175,2925 },
 { 176,2925 }, { 177,2925 }, { 178,2925 }, { 179,2925 }, { 180,2925 },
 { 181,2925 }, { 182,2925 }, { 183,2925 }, { 184,2925 }, { 185,2925 },

 { 186,2925 }, { 187,2925 }, { 188,2925 }, { 189,2925 }, { 190,2925 },
 { 191,2925 }, { 192,2925 }, { 193,2925 }, { 194,2925 }, { 195,2925 },
 { 196,2925 }, { 197,2925 }, { 198,2925 }, { 199,2925 }, { 200,2925 },
 { 201,2925 }, { 202,2925 }, { 203,2925 }, { 204,2925 }, { 205,2925 },
 { 206,2925 }, { 207,2925 }, { 208,2925 }, { 209,2925 }, { 210,2925 },
 { 211,2925 }, { 212,2925 }, { 213,2925 }, { 214,2925 }, { 215,2925 },
 { 216,2925 }, { 217,2925 }, { 218,2925 }, { 219,2925 }, { 220,2925 },
 { 221,2925 }, { 222,2925 }, { 223,2925 }, { 224,2925 }, { 225,2925 },
 { 226,2925 }, { 227,2925 }, { 228,2925 }, { 229,2925 }, { 230,2925 },
 { 231,2925 }, { 232,2925 }, { 233,2925 }, { 234,2925 }, { 235,2925 },

 { 236,2925 }, { 237,2925 }, { 238,2925 }, { 239,2925 }, { 240,2925 },
 { 241,2925 }, { 242,2925 }, { 243,2925 }, { 244,2925 }, { 245,2925 },
 { 246,2925 }, { 247,2925 }, { 248,2925 }, { 249,2925 }, { 250,2925 },
 { 251,2925 }, { 252,2925 }, { 253,2925 }, { 254,2925 }, { 255,2925 },
 {   0,   3 }, {   0,6318 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,   0 },
 {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 }, {  43,   0 },
 {   0,   0 }, {  45,   0 }, {   0,   0 }, {  47,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,  18 }, {   0,6190 },

 {   1,2797 }, {   2,2797 }, {   3,2797 }, {   4,2797 }, {   5,2797 },
 {   6,2797 }, {   7,2797 }, {   8,2797 }, {   9,3055 }, {  10,3313 },
 {  11,2797 }, {  12,3055 }, {  13,3313 }, {  14,2797 }, {  15,2797 },
 {  16,2797 }, {  17,2797 }, {  18,2797 }, {  19,2797 }, {  20,2797 },
 {  21,2797 }, {  22,2797 }, {  23,2797 }, {  24,2797 }, {  25,2797 },
 {  26,2797 }, {  27,2797 }, {  28,2797 }, {  29,2797 }, {  30,2797 },
 {  31,2797 }, {  32,3055 }, {  33,2797 }, {  34,2797 }, {  35,2797 },
 {  36,2797 }, {  37,2797 }, {  38,2797 }, {  39,2797 }, {  40,2797 },
 {  41,2797 }, {  42,2797 }, {  43,2797 }, {  44,2797 }, {  45,3360 },
 {  46,2797 }, {  47,2797 }, {  48,2797 }, {  49,2797 }, {  50,2797 },

 {  51,2797 }, {  52,2797 }, {  53,2797 }, {  54,2797 }, {  55,2797 },
 {  56,2797 }, {  57,2797 }, {  58,2797 }, {  59,2797 }, {  60,2797 },
 {  61,2797 }, {  62,2797 }, {  63,2797 }, {  64,2797 }, {  65,2797 },
 {  66,2797 }, {  67,2797 }, {  68,2797 }, {  69,2797 }, {  70,2797 },
 {  71,2797 }, {  72,2797 }, {  73,2797 }, {  74,2797 }, {  75,2797 },
 {  76,2797 }, {  77,2797 }, {  78,2797 }, {  79,2797 }, {  80,2797 },
 {  81,2797 }, {  82,2797 }, {  83,2797 }, {  84,2797 }, {  85,2797 },
 {  86,2797 }, {  87,2797 }, {  88,2797 }, {  89,2797 }, {  90,2797 },
 {  91,2797 }, {  92,2797 }, {  93,2797 }, {  94,2797 }, {  95,2797 },
 {  96,2797 }, {  97,2797 }, {  98,2797 }, {  99,2797 }, { 100,2797 },

 { 101,2797 }, { 102,2797 }, { 103,2797 }, { 104,2797 }, { 105,2797 },
 { 106,2797 }, { 107,2797 }, { 108,2797 }, { 109,2797 }, { 110,2797 },
 { 111,2797 }, { 112,2797 }, { 113,2797 }, { 114,2797 }, { 115,2797 },
 { 116,2797 }, { 117,2797 }, { 118,2797 }, { 119,2797 }, { 120,2797 },
 { 121,2797 }, { 122,2797 }, { 123,2797 }, { 124,2797 }, { 125,2797 },
 { 126,2797 }, { 127,2797 }, { 128,2797 }, { 129,2797 }, { 130,2797 },
 { 131,2797 }, { 132,2797 }, { 133,2797 }, { 134,2797 }, { 135,2797 },
 { 136,2797 }, { 137,2797 }, { 138,2797 }, { 139,2797 }, { 140,2797 },
 { 141,2797 }, { 142,2797 }, { 143,2797 }, { 144,2797 }, { 145,2797 },
 { 146,2797 }, { 147,2797 }, { 148,2797 }, { 149,2797 }, { 150,2797 },

 { 151,2797 }, { 152,2797 }, { 153,2797 }, { 154,2797 }, { 155,2797 },
 { 156,2797 }, { 157,2797 }, { 158,2797 }, { 159,2797 }, { 160,2797 },
 { 161,2797 }, { 162,2797 }, { 163,2797 }, { 164,2797 }, { 165,2797 },
 { 166,2797 }, { 167,2797 }, { 168,2797 }, { 169,2797 }, { 170,2797 },
 { 171,2797 }, { 172,2797 }, { 173,2797 }, { 174,2797 }, { 175,2797 },
 { 176,2797 }, { 177,2797 }, { 178,2797 }, { 179,2797 }, { 180,2797 },
 { 181,2797 }, { 182,2797 }, { 183,2797 }, { 184,2797 }, { 185,2797 },
 { 186,2797 }, { 187,2797 }, { 188,2797 }, { 189,2797 }, { 190,2797 },
 { 191,2797 }, { 192,2797 }, { 193,2797 }, { 194,2797 }, { 195,2797 },
 { 196,2797 }, { 197,2797 }, { 198,2797 }, { 199,2797 }, { 200,2797 },

 { 201,2797 }, { 202,2797 }, { 203,2797 }, { 204,2797 }, { 205,2797 },
 { 206,2797 }, { 207,2797 }, { 208,2797 }, { 209,2797 }, { 210,2797 },
 { 211,2797 }, { 212,2797 }, { 213,2797 }, { 214,2797 }, { 215,2797 },
 { 216,2797 }, { 217,2797 }, { 218,2797 }, { 219,2797 }, { 220,2797 },
 { 221,2797 }, { 222,2797 }, { 223,2797 }, { 224,2797 }, { 225,2797 },
 { 226,2797 }, { 227,2797 }, { 228,2797 }, { 229,2797 }, { 230,2797 },
 { 231,2797 }, { 232,2797 }, { 233,2797 }, { 234,2797 }, { 235,2797 },
 { 236,2797 }, { 237,2797 }, { 238,2797 }, { 239,2797 }, { 240,2797 },
 { 241,2797 }, { 242,2797 }, { 243,2797 }, { 244,2797 }, { 245,2797 },
 { 246,2797 }, { 247,2797 }, { 248,2797 }, { 249,2797 }, { 250,2797 },

 { 251,2797 }, { 252,2797 }, { 253,2797 }, { 254,2797 }, { 255,2797 },
 { 256,2797 }, {   0,  18 }, {   0,5932 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9, 258 }, {  10,-4092 }, {  11,   0 }, {  12, 258 },
 {  13,-4092 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },

 {  43,   0 }, {  44,   0 }, {  45, 516 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },

 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },

 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },

 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },

 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  18 },
 {   0,5674 }, {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 },
 {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 },
 {  10,-4350 }, {  11,-258 }, {  12,   0 }, {  13,-4350 }, {  14,-258 },
 {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 },
 {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 },
 {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 },
 {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 },

 {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 },
 {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 },
 {  45, 258 }, {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 },
 {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 },
 {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 },
 {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 },
 {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 },
 {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 },
 {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 },
 {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 },

 {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 },
 {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 },
 {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 },
 { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 },
 { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 },
 { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 },
 { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 },
 { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 },
 { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 },
 { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 },

 { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 },
 { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 },
 { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 },
 { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 },
 { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 },
 { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 },
 { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 },
 { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 },
 { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 },
 { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 },

 { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 },
 { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 },
 { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 },
 { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 },
 { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 },
 { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 },
 { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 },
 { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 },
 { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 },
 { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 },

 { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 },
 { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 },
 { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 },
 { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 },
 { 255,-258 }, { 256,-258 }, {   0,  18 }, {   0,5416 }, {   1,-516 },
 {   2,-516 }, {   3,-516 }, {   4,-516 }, {   5,-516 }, {   6,-516 },
 {   7,-516 }, {   8,-516 }, {   9,-258 }, {  10,-4608 }, {  11,-516 },
 {  12,-258 }, {  13,-4608 }, {  14,-516 }, {  15,-516 }, {  16,-516 },
 {  17,-516 }, {  18,-516 }, {  19,-516 }, {  20,-516 }, {  21,-516 },
 {  22,-516 }, {  23,-516 }, {  24,-516 }, {  25,-516 }, {  26,-516 },

 {  27,-516 }, {  28,-516 }, {  29,-516 }, {  30,-516 }, {  31,-516 },
 {  32,-258 }, {  33,-516 }, {  34,-516 }, {  35,-516 }, {  36,-516 },
 {  37,-516 }, {  38,-516 }, {  39,-516 }, {  40,-516 }, {  41,-516 },
 {  42,-516 }, {  43,-516 }, {  44,-516 }, {  45,2844 }, {  46,-516 },
 {  47,-516 }, {  48,-516 }, {  49,-516 }, {  50,-516 }, {  51,-516 },
 {  52,-516 }, {  53,-516 }, {  54,-516 }, {  55,-516 }, {  56,-516 },
 {  57,-516 }, {  58,-516 }, {  59,-516 }, {  60,-516 }, {  61,-516 },
 {  62,-516 }, {  63,-516 }, {  64,-516 }, {  65,-516 }, {  66,-516 },
 {  67,-516 }, {  68,-516 }, {  69,-516 }, {  70,-516 }, {  71,-516 },
 {  72,-516 }, {  73,-516 }, {  74,-516 }, {  75,-516 }, {  76,-516 },

 {  77,-516 }, {  78,-516 }, {  79,-516 }, {  80,-516 }, {  81,-516 },
 {  82,-516 }, {  83,-516 }, {  84,-516 }, {  85,-516 }, {  86,-516 },
 {  87,-516 }, {  88,-516 }, {  89,-516 }, {  90,-516 }, {  91,-516 },
 {  92,-516 }, {  93,-516 }, {  94,-516 }, {  95,-516 }, {  96,-516 },
 {  97,-516 }, {  98,-516 }, {  99,-516 }, { 100,-516 }, { 101,-516 },
 { 102,-516 }, { 103,-516 }, { 104,-516 }, { 105,-516 }, { 106,-516 },
 { 107,-516 }, { 108,-516 }, { 109,-516 }, { 110,-516 }, { 111,-516 },
 { 112,-516 }, { 113,-516 }, { 114,-516 }, { 115,-516 }, { 116,-516 },
 { 117,-516 }, { 118,-516 }, { 119,-516 }, { 120,-516 }, { 121,-516 },
 { 122,-516 }, { 123,-516 }, { 124,-516 }, { 125,-516 }, { 126,-516 },

 { 127,-516 }, { 128,-516 }, { 129,-516 }, { 130,-516 }, { 131,-516 },
 { 132,-516 }, { 133,-516 }, { 134,-516 }, { 135,-516 }, { 136,-516 },
 { 137,-516 }, { 138,-516 }, { 139,-516 }, { 140,-516 }, { 141,-516 },
 { 142,-516 }, { 143,-516 }, { 144,-516 }, { 145,-516 }, { 146,-516 },
 { 147,-516 }, { 148,-516 }, { 149,-516 }, { 150,-516 }, { 151,-516 },
 { 152,-516 }, { 153,-516 }, { 154,-516 }, { 155,-516 }, { 156,-516 },
 { 157,-516 }, { 158,-516 }, { 159,-516 }, { 160,-516 }, { 161,-516 },
 { 162,-516 }, { 163,-516 }, { 164,-516 }, { 165,-516 }, { 166,-516 },
 { 167,-516 }, { 168,-516 }, { 169,-516 }, { 170,-516 }, { 171,-516 },
 { 172,-516 }, { 173,-516 }, { 174,-516 }, { 175,-516 }, { 176,-516 },

 { 177,-516 }, { 178,-516 }, { 179,-516 }, { 180,-516 }, { 181,-516 },
 { 182,-516 }, { 183,-516 }, { 184,-516 }, { 185,-516 }, { 186,-516 },
 { 187,-516 }, { 188,-516 }, { 189,-516 }, { 190,-516 }, { 191,-516 },
 { 192,-516 }, { 193,-516 }, { 194,-516 }, { 195,-516 }, { 196,-516 },
 { 197,-516 }, { 198,-516 }, { 199,-516 }, { 200,-516 }, { 201,-516 },
 { 202,-516 }, { 203,-516 }, { 204,-516 }, { 205,-516 }, { 206,-516 },
 { 207,-516 }, { 208,-516 }, { 209,-516 }, { 210,-516 }, { 211,-516 },
 { 212,-516 }, { 213,-516 }, { 214,-516 }, { 215,-516 }, { 216,-516 },
 { 217,-516 }, { 218,-516 }, { 219,-516 }, { 220,-516 }, { 221,-516 },
 { 222,-516 }, { 223,-516 }, { 224,-516 }, { 225,-516 }, { 226,-516 },

 { 227,-516 }, { 228,-516 }, { 229,-516 }, { 230,-516 }, { 231,-516 },
 { 232,-516 }, { 233,-516 }, { 234,-516 }, { 235,-516 }, { 236,-516 },
 { 237,-516 }, { 238,-516 }, { 239,-516 }, { 240,-516 }, { 241,-516 },
 { 242,-516 }, { 243,-516 }, { 244,-516 }, { 245,-516 }, { 246,-516 },
 { 247,-516 }, { 248,-516 }, { 249,-516 }, { 250,-516 }, { 251,-516 },
 { 252,-516 }, { 253,-516 }, { 254,-516 }, { 255,-516 }, { 256,-516 },
 {   0,  29 }, {   0,5158 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,5150 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0,5127 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-14047 },
 {  49,-14047 }, {  50,-14047 }, {  51,-14047 }, {  52,-14047 }, {  53,-14047 },
 {  54,-14047 }, {  55,-14047 }, {  48,2836 }, {  49,2836 }, {  50,2836 },
 {  51,2836 }, {  52,2836 }, {  53,2836 }, {  54,2836 }, {  55,2836 },
 {  56,2836 }, {  57,2836 }, {   0,   0 }, {   0,   0 }, {   0,  30 },

 {   0,5089 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2836 },
 {  66,2836 }, {  67,2836 }, {  68,2836 }, {  69,2836 }, {  70,2836 },
 {  48,2836 }, {  49,2836 }, {  50,2836 }, {  51,2836 }, {  52,2836 },
 {  53,2836 }, {  54,2836 }, {  55,2836 }, {  56,2836 }, {  57,2836 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,2836 }, {  66,2836 }, {  67,2836 },
 {  68,2836 }, {  69,2836 }, {  70,2836 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,2836 }, {  98,2836 }, {  99,2836 }, { 100,2836 },
 { 101,2836 }, { 102,2836 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-14094 }, {  49,-14094 },

 {  50,-14094 }, {  51,-14094 }, {  52,-14094 }, {  53,-14094 }, {  54,-14094 },
 {  55,-14094 }, {  56,-14094 }, {  57,-14094 }, {   0,   0 }, {  97,2836 },
 {  98,2836 }, {  99,2836 }, { 100,2836 }, { 101,2836 }, { 102,2836 },
 {  65,-14094 }, {  66,-14094 }, {  67,-14094 }, {  68,-14094 }, {  69,-14094 },
 {  70,-14094 }, {   0,  36 }, {   0,5017 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,-14094 }, {  98,-14094 }, {  99,-14094 },

 { 100,-14094 }, { 101,-14094 }, { 102,-14094 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-14227 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },

 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },

 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },

 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  27 }, {   0,4760 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,  27 }, {   0,4737 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,2507 }, {  49,2507 }, {  50,2507 },
 {  51,2507 }, {  52,2507 }, {  53,2507 }, {  54,2507 }, {  55,2507 },
 {  56,2507 }, {  57,2507 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2507 },
 {  66,2507 }, {  67,2507 }, {  68,2507 }, {  69,2507 }, {  70,2507 },

 {  48,2507 }, {  49,2507 }, {  50,2507 }, {  51,2507 }, {  52,2507 },
 {  53,2507 }, {  54,2507 }, {  55,2507 }, {  56,2507 }, {  57,2507 },
 {   0,  56 }, {   0,4678 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,2507 }, {  66,2507 }, {  67,2507 },
 {  68,2507 }, {  69,2507 }, {  70,2507 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,2507 }, {  98,2507 }, {  99,2507 }, { 100,2507 },
 { 101,2507 }, { 102,2507 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 }, {  97,2507 },

 {  98,2507 }, {  99,2507 }, { 100,2507 }, { 101,2507 }, { 102,2507 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },

 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },

 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },

 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },

 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, {   0,  63 }, {   0,4421 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },

 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },

 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },

 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },

 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  60 },
 {   0,4164 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,1993 }, {  66,1993 }, {  67,1993 }, {  68,1993 }, {  69,1993 },
 {  70,1993 }, {  71,1993 }, {  72,1993 }, {  73,1993 }, {  74,1993 },

 {  75,1993 }, {  76,1993 }, {  77,1993 }, {  78,1993 }, {  79,1993 },
 {  80,1993 }, {  81,1993 }, {  82,1993 }, {  83,1993 }, {  84,1993 },
 {  85,1993 }, {  86,1993 }, {  87,1993 }, {  88,1993 }, {  89,1993 },
 {  90,1993 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,1993 }, {   0,   0 }, {  97,1993 }, {  98,1993 }, {  99,1993 },
 { 100,1993 }, { 101,1993 }, { 102,1993 }, { 103,1993 }, { 104,1993 },
 { 105,1993 }, { 106,1993 }, { 107,1993 }, { 108,1993 }, { 109,1993 },
 { 110,1993 }, { 111,1993 }, { 112,1993 }, { 113,1993 }, { 114,1993 },
 { 115,1993 }, { 116,1993 }, { 117,1993 }, { 118,1993 }, { 119,1993 },
 { 120,1993 }, { 121,1993 }, { 122,1993 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,1993 }, { 129,1993 },
 { 130,1993 }, { 131,1993 }, { 132,1993 }, { 133,1993 }, { 134,1993 },
 { 135,1993 }, { 136,1993 }, { 137,1993 }, { 138,1993 }, { 139,1993 },
 { 140,1993 }, { 141,1993 }, { 142,1993 }, { 143,1993 }, { 144,1993 },
 { 145,1993 }, { 146,1993 }, { 147,1993 }, { 148,1993 }, { 149,1993 },
 { 150,1993 }, { 151,1993 }, { 152,1993 }, { 153,1993 }, { 154,1993 },
 { 155,1993 }, { 156,1993 }, { 157,1993 }, { 158,1993 }, { 159,1993 },
 { 160,1993 }, { 161,1993 }, { 162,1993 }, { 163,1993 }, { 164,1993 },
 { 165,1993 }, { 166,1993 }, { 167,1993 }, { 168,1993 }, { 169,1993 },
 { 170,1993 }, { 171,1993 }, { 172,1993 }, { 173,1993 }, { 174,1993 },

 { 175,1993 }, { 176,1993 }, { 177,1993 }, { 178,1993 }, { 179,1993 },
 { 180,1993 }, { 181,1993 }, { 182,1993 }, { 183,1993 }, { 184,1993 },
 { 185,1993 }, { 186,1993 }, { 187,1993 }, { 188,1993 }, { 189,1993 },
 { 190,1993 }, { 191,1993 }, { 192,1993 }, { 193,1993 }, { 194,1993 },
 { 195,1993 }, { 196,1993 }, { 197,1993 }, { 198,1993 }, { 199,1993 },
 { 200,1993 }, { 201,1993 }, { 202,1993 }, { 203,1993 }, { 204,1993 },
 { 205,1993 }, { 206,1993 }, { 207,1993 }, { 208,1993 }, { 209,1993 },
 { 210,1993 }, { 211,1993 }, { 212,1993 }, { 213,1993 }, { 214,1993 },
 { 215,1993 }, { 216,1993 }, { 217,1993 }, { 218,1993 }, { 219,1993 },
 { 220,1993 }, { 221,1993 }, { 222,1993 }, { 223,1993 }, { 224,1993 },

 { 225,1993 }, { 226,1993 }, { 227,1993 }, { 228,1993 }, { 229,1993 },
 { 230,1993 }, { 231,1993 }, { 232,1993 }, { 233,1993 }, { 234,1993 },
 { 235,1993 }, { 236,1993 }, { 237,1993 }, { 238,1993 }, { 239,1993 },
 { 240,1993 }, { 241,1993 }, { 242,1993 }, { 243,1993 }, { 244,1993 },
 { 245,1993 }, { 246,1993 }, { 247,1993 }, { 248,1993 }, { 249,1993 },
 { 250,1993 }, { 251,1993 }, { 252,1993 }, { 253,1993 }, { 254,1993 },
 { 255,1993 }, {   0,  60 }, {   0,3907 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,1993 }, {  66,1993 }, {  67,1993 },

 {  68,1993 }, {  69,1993 }, {  70,1993 }, {  71,1993 }, {  72,1993 },
 {  73,1993 }, {  74,1993 }, {  75,1993 }, {  76,1993 }, {  77,1993 },
 {  78,1993 }, {  79,1993 }, {  80,1993 }, {  81,1993 }, {  82,1993 },
 {  83,1993 }, {  84,1993 }, {  85,1993 }, {  86,1993 }, {  87,1993 },
 {  88,1993 }, {  89,1993 }, {  90,1993 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,1993 }, {   0,   0 }, {  97,1993 },
 {  98,1993 }, {  99,1993 }, { 100,1993 }, { 101,1993 }, { 102,1993 },
 { 103,1993 }, { 104,1993 }, { 105,1993 }, { 106,1993 }, { 107,1993 },
 { 108,1993 }, { 109,1993 }, { 110,1993 }, { 111,1993 }, { 112,1993 },
 { 113,1993 }, { 114,1993 }, { 115,1993 }, { 116,1993 }, { 117,1993 },

 { 118,1993 }, { 119,1993 }, { 120,1993 }, { 121,1993 }, { 122,1993 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,1993 }, { 129,1993 }, { 130,1993 }, { 131,1993 }, { 132,1993 },
 { 133,1993 }, { 134,1993 }, { 135,1993 }, { 136,1993 }, { 137,1993 },
 { 138,1993 }, { 139,1993 }, { 140,1993 }, { 141,1993 }, { 142,1993 },
 { 143,1993 }, { 144,1993 }, { 145,1993 }, { 146,1993 }, { 147,1993 },
 { 148,1993 }, { 149,1993 }, { 150,1993 }, { 151,1993 }, { 152,1993 },
 { 153,1993 }, { 154,1993 }, { 155,1993 }, { 156,1993 }, { 157,1993 },
 { 158,1993 }, { 159,1993 }, { 160,1993 }, { 161,1993 }, { 162,1993 },
 { 163,1993 }, { 164,1993 }, { 165,1993 }, { 166,1993 }, { 167,1993 },

 { 168,1993 }, { 169,1993 }, { 170,1993 }, { 171,1993 }, { 172,1993 },
 { 173,1993 }, { 174,1993 }, { 175,1993 }, { 176,1993 }, { 177,1993 },
 { 178,1993 }, { 179,1993 }, { 180,1993 }, { 181,1993 }, { 182,1993 },
 { 183,1993 }, { 184,1993 }, { 185,1993 }, { 186,1993 }, { 187,1993 },
 { 188,1993 }, { 189,1993 }, { 190,1993 }, { 191,1993 }, { 192,1993 },
 { 193,1993 }, { 194,1993 }, { 195,1993 }, { 196,1993 }, { 197,1993 },
 { 198,1993 }, { 199,1993 }, { 200,1993 }, { 201,1993 }, { 202,1993 },
 { 203,1993 }, { 204,1993 }, { 205,1993 }, { 206,1993 }, { 207,1993 },
 { 208,1993 }, { 209,1993 }, { 210,1993 }, { 211,1993 }, { 212,1993 },
 { 213,1993 }, { 214,1993 }, { 215,1993 }, { 216,1993 }, { 217,1993 },

 { 218,1993 }, { 219,1993 }, { 220,1993 }, { 221,1993 }, { 222,1993 },
 { 223,1993 }, { 224,1993 }, { 225,1993 }, { 226,1993 }, { 227,1993 },
 { 228,1993 }, { 229,1993 }, { 230,1993 }, { 231,1993 }, { 232,1993 },
 { 233,1993 }, { 234,1993 }, { 235,1993 }, { 236,1993 }, { 237,1993 },
 { 238,1993 }, { 239,1993 }, { 240,1993 }, { 241,1993 }, { 242,1993 },
 { 243,1993 }, { 244,1993 }, { 245,1993 }, { 246,1993 }, { 247,1993 },
 { 248,1993 }, { 249,1993 }, { 250,1993 }, { 251,1993 }, { 252,1993 },
 { 253,1993 }, { 254,1993 }, { 255,1993 }, {   0,  62 }, {   0,3650 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,1993 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,1993 }, {  49,1993 }, {  50,1993 },
 {  51,1993 }, {  52,1993 }, {  53,1993 }, {  54,1993 }, {  55,1993 },
 {  56,1993 }, {  57,1993 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1993 },
 {  66,1993 }, {  67,1993 }, {  68,1993 }, {  69,1993 }, {  70,1993 },
 {  71,1993 }, {  72,1993 }, {  73,1993 }, {  74,1993 }, {  75,1993 },
 {  76,1993 }, {  77,1993 }, {  78,1993 }, {  79,1993 }, {  80,1993 },
 {  81,1993 }, {  82,1993 }, {  83,1993 }, {  84,1993 }, {  85,1993 },
 {  86,1993 }, {  87,1993 }, {  88,1993 }, {  89,1993 }, {  90,1993 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,1993 },
 {   0,   0 }, {  97,1993 }, {  98,1993 }, {  99,1993 }, { 100,1993 },
 { 101,1993 }, { 102,1993 }, { 103,1993 }, { 104,1993 }, { 105,1993 },
 { 106,1993 }, { 107,1993 }, { 108,1993 }, { 109,1993 }, { 110,1993 },

 { 111,1993 }, { 112,1993 }, { 113,1993 }, { 114,1993 }, { 115,1993 },
 { 116,1993 }, { 117,1993 }, { 118,1993 }, { 119,1993 }, { 120,1993 },
 { 121,1993 }, { 122,1993 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,1993 }, { 129,1993 }, { 130,1993 },
 { 131,1993 }, { 132,1993 }, { 133,1993 }, { 134,1993 }, { 135,1993 },
 { 136,1993 }, { 137,1993 }, { 138,1993 }, { 139,1993 }, { 140,1993 },
 { 141,1993 }, { 142,1993 }, { 143,1993 }, { 144,1993 }, { 145,1993 },
 { 146,1993 }, { 147,1993 }, { 148,1993 }, { 149,1993 }, { 150,1993 },
 { 151,1993 }, { 152,1993 }, { 153,1993 }, { 154,1993 }, { 155,1993 },
 { 156,1993 }, { 157,1993 }, { 158,1993 }, { 159,1993 }, { 160,1993 },

 { 161,1993 }, { 162,1993 }, { 163,1993 }, { 164,1993 }, { 165,1993 },
 { 166,1993 }, { 167,1993 }, { 168,1993 }, { 169,1993 }, { 170,1993 },
 { 171,1993 }, { 172,1993 }, { 173,1993 }, { 174,1993 }, { 175,1993 },
 { 176,1993 }, { 177,1993 }, { 178,1993 }, { 179,1993 }, { 180,1993 },
 { 181,1993 }, { 182,1993 }, { 183,1993 }, { 184,1993 }, { 185,1993 },
 { 186,1993 }, { 187,1993 }, { 188,1993 }, { 189,1993 }, { 190,1993 },
 { 191,1993 }, { 192,1993 }, { 193,1993 }, { 194,1993 }, { 195,1993 },
 { 196,1993 }, { 197,1993 }, { 198,1993 }, { 199,1993 }, { 200,1993 },
 { 201,1993 }, { 202,1993 }, { 203,1993 }, { 204,1993 }, { 205,1993 },
 { 206,1993 }, { 207,1993 }, { 208,1993 }, { 209,1993 }, { 210,1993 },

 { 211,1993 }, { 212,1993 }, { 213,1993 }, { 214,1993 }, { 215,1993 },
 { 216,1993 }, { 217,1993 }, { 218,1993 }, { 219,1993 }, { 220,1993 },
 { 221,1993 }, { 222,1993 }, { 223,1993 }, { 224,1993 }, { 225,1993 },
 { 226,1993 }, { 227,1993 }, { 228,1993 }, { 229,1993 }, { 230,1993 },
 { 231,1993 }, { 232,1993 }, { 233,1993 }, { 234,1993 }, { 235,1993 },
 { 236,1993 }, { 237,1993 }, { 238,1993 }, { 239,1993 }, { 240,1993 },
 { 241,1993 }, { 242,1993 }, { 243,1993 }, { 244,1993 }, { 245,1993 },
 { 246,1993 }, { 247,1993 }, { 248,1993 }, { 249,1993 }, { 250,1993 },
 { 251,1993 }, { 252,1993 }, { 253,1993 }, { 254,1993 }, { 255,1993 },
 {   0,  18 }, {   0,3393 }, {   1,   0 }, {   2,   0 }, {   3,   0 },

 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9, 258 }, {  10, 516 }, {  11,   0 }, {  12, 258 }, {  13, 516 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45, 563 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },

 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },

 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },

 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },

 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },

 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  18 }, {   0,3135 },
 {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 },
 {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10, 258 },
 {  11,-258 }, {  12,   0 }, {  13, 258 }, {  14,-258 }, {  15,-258 },
 {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 },
 {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 },
 {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 },
 {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 },
 {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 }, {  40,-258 },
 {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 305 },

 {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 },
 {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 },
 {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 },
 {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 },
 {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 },
 {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 },
 {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 },
 {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 },
 {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 },
 {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 },

 {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 },
 { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 },
 { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 },
 { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 },
 { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 },
 { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 },
 { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 },
 { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 },
 { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 },
 { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 },

 { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 },
 { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 },
 { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 },
 { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 },
 { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 },
 { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 },
 { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 },
 { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 },
 { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 },
 { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 },

 { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 },
 { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 },
 { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 },
 { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 },
 { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 },
 { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 },
 { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 },
 { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 },
 { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 },
 { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 },

 { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 },
 { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 },
 { 256,-258 }, {   0,  18 }, {   0,2877 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,-7131 }, {  10,-7131 }, {   0,   0 }, {  12,-7131 },
 {  13,-7131 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,-7131 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  39,-16373 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-16371 }, {   0,  18 }, {   0,2830 },
 {   1,-563 }, {   2,-563 }, {   3,-563 }, {   4,-563 }, {   5,-563 },
 {   6,-563 }, {   7,-563 }, {   8,-563 }, {   9,-305 }, {  10, -47 },
 {  11,-563 }, {  12,-305 }, {  13, -47 }, {  14,-563 }, {  15,-563 },
 {  16,-563 }, {  17,-563 }, {  18,-563 }, {  19,-563 }, {  20,-563 },
 {  21,-563 }, {  22,-563 }, {  23,-563 }, {  24,-563 }, {  25,-563 },
 {  26,-563 }, {  27,-563 }, {  28,-563 }, {  29,-563 }, {  30,-563 },
 {  31,-563 }, {  32,-305 }, {  33,-563 }, {  34,-563 }, {  35,-563 },
 {  36,-563 }, {  37,-563 }, {  38,-563 }, {  39,-563 }, {  40,-563 },

 {  41,-563 }, {  42,-563 }, {  43,-563 }, {  44,-563 }, {  45,1430 },
 {  46,-563 }, {  47,-563 }, {  48,-563 }, {  49,-563 }, {  50,-563 },
 {  51,-563 }, {  52,-563 }, {  53,-563 }, {  54,-563 }, {  55,-563 },
 {  56,-563 }, {  57,-563 }, {  58,-563 }, {  59,-563 }, {  60,-563 },
 {  61,-563 }, {  62,-563 }, {  63,-563 }, {  64,-563 }, {  65,-563 },
 {  66,-563 }, {  67,-563 }, {  68,-563 }, {  69,-563 }, {  70,-563 },
 {  71,-563 }, {  72,-563 }, {  73,-563 }, {  74,-563 }, {  75,-563 },
 {  76,-563 }, {  77,-563 }, {  78,-563 }, {  79,-563 }, {  80,-563 },
 {  81,-563 }, {  82,-563 }, {  83,-563 }, {  84,-563 }, {  85,-563 },
 {  86,-563 }, {  87,-563 }, {  88,-563 }, {  89,-563 }, {  90,-563 },

 {  91,-563 }, {  92,-563 }, {  93,-563 }, {  94,-563 }, {  95,-563 },
 {  96,-563 }, {  97,-563 }, {  98,-563 }, {  99,-563 }, { 100,-563 },
 { 101,-563 }, { 102,-563 }, { 103,-563 }, { 104,-563 }, { 105,-563 },
 { 106,-563 }, { 107,-563 }, { 108,-563 }, { 109,-563 }, { 110,-563 },
 { 111,-563 }, { 112,-563 }, { 113,-563 }, { 114,-563 }, { 115,-563 },
 { 116,-563 }, { 117,-563 }, { 118,-563 }, { 119,-563 }, { 120,-563 },
 { 121,-563 }, { 122,-563 }, { 123,-563 }, { 124,-563 }, { 125,-563 },
 { 126,-563 }, { 127,-563 }, { 128,-563 }, { 129,-563 }, { 130,-563 },
 { 131,-563 }, { 132,-563 }, { 133,-563 }, { 134,-563 }, { 135,-563 },
 { 136,-563 }, { 137,-563 }, { 138,-563 }, { 139,-563 }, { 140,-563 },

 { 141,-563 }, { 142,-563 }, { 143,-563 }, { 144,-563 }, { 145,-563 },
 { 146,-563 }, { 147,-563 }, { 148,-563 }, { 149,-563 }, { 150,-563 },
 { 151,-563 }, { 152,-563 }, { 153,-563 }, { 154,-563 }, { 155,-563 },
 { 156,-563 }, { 157,-563 }, { 158,-563 }, { 159,-563 }, { 160,-563 },
 { 161,-563 }, { 162,-563 }, { 163,-563 }, { 164,-563 }, { 165,-563 },
 { 166,-563 }, { 167,-563 }, { 168,-563 }, { 169,-563 }, { 170,-563 },
 { 171,-563 }, { 172,-563 }, { 173,-563 }, { 174,-563 }, { 175,-563 },
 { 176,-563 }, { 177,-563 }, { 178,-563 }, { 179,-563 }, { 180,-563 },
 { 181,-563 }, { 182,-563 }, { 183,-563 }, { 184,-563 }, { 185,-563 },
 { 186,-563 }, { 187,-563 }, { 188,-563 }, { 189,-563 }, { 190,-563 },

 { 191,-563 }, { 192,-563 }, { 193,-563 }, { 194,-563 }, { 195,-563 },
 { 196,-563 }, { 197,-563 }, { 198,-563 }, { 199,-563 }, { 200,-563 },
 { 201,-563 }, { 202,-563 }, { 203,-563 }, { 204,-563 }, { 205,-563 },
 { 206,-563 }, { 207,-563 }, { 208,-563 }, { 209,-563 }, { 210,-563 },
 { 211,-563 }, { 212,-563 }, { 213,-563 }, { 214,-563 }, { 215,-563 },
 { 216,-563 }, { 217,-563 }, { 218,-563 }, { 219,-563 }, { 220,-563 },
 { 221,-563 }, { 222,-563 }, { 223,-563 }, { 224,-563 }, { 225,-563 },
 { 226,-563 }, { 227,-563 }, { 228,-563 }, { 229,-563 }, { 230,-563 },
 { 231,-563 }, { 232,-563 }, { 233,-563 }, { 234,-563 }, { 235,-563 },
 { 236,-563 }, { 237,-563 }, { 238,-563 }, { 239,-563 }, { 240,-563 },

 { 241,-563 }, { 242,-563 }, { 243,-563 }, { 244,-563 }, { 245,-563 },
 { 246,-563 }, { 247,-563 }, { 248,-563 }, { 249,-563 }, { 250,-563 },
 { 251,-563 }, { 252,-563 }, { 253,-563 }, { 254,-563 }, { 255,-563 },
 { 256,-563 }, {   0,  18 }, {   0,2572 }, {   1,-3360 }, {   2,-3360 },
 {   3,-3360 }, {   4,-3360 }, {   5,-3360 }, {   6,-3360 }, {   7,-3360 },
 {   8,-3360 }, {   9,-3102 }, {  10,-7452 }, {  11,-3360 }, {  12,-3102 },
 {  13,-7452 }, {  14,-3360 }, {  15,-3360 }, {  16,-3360 }, {  17,-3360 },
 {  18,-3360 }, {  19,-3360 }, {  20,-3360 }, {  21,-3360 }, {  22,-3360 },
 {  23,-3360 }, {  24,-3360 }, {  25,-3360 }, {  26,-3360 }, {  27,-3360 },
 {  28,-3360 }, {  29,-3360 }, {  30,-3360 }, {  31,-3360 }, {  32,-3102 },

 {  33,-3360 }, {  34,-3360 }, {  35,-3360 }, {  36,-3360 }, {  37,-3360 },
 {  38,-3360 }, {  39,-3360 }, {  40,-3360 }, {  41,-3360 }, {  42,-3360 },
 {  43,-3360 }, {  44,-3360 }, {  45,   0 }, {  46,-3360 }, {  47,-3360 },
 {  48,-3360 }, {  49,-3360 }, {  50,-3360 }, {  51,-3360 }, {  52,-3360 },
 {  53,-3360 }, {  54,-3360 }, {  55,-3360 }, {  56,-3360 }, {  57,-3360 },
 {  58,-3360 }, {  59,-3360 }, {  60,-3360 }, {  61,-3360 }, {  62,-3360 },
 {  63,-3360 }, {  64,-3360 }, {  65,-3360 }, {  66,-3360 }, {  67,-3360 },
 {  68,-3360 }, {  69,-3360 }, {  70,-3360 }, {  71,-3360 }, {  72,-3360 },
 {  73,-3360 }, {  74,-3360 }, {  75,-3360 }, {  76,-3360 }, {  77,-3360 },
 {  78,-3360 }, {  79,-3360 }, {  80,-3360 }, {  81,-3360 }, {  82,-3360 },

 {  83,-3360 }, {  84,-3360 }, {  85,-3360 }, {  86,-3360 }, {  87,-3360 },
 {  88,-3360 }, {  89,-3360 }, {  90,-3360 }, {  91,-3360 }, {  92,-3360 },
 {  93,-3360 }, {  94,-3360 }, {  95,-3360 }, {  96,-3360 }, {  97,-3360 },
 {  98,-3360 }, {  99,-3360 }, { 100,-3360 }, { 101,-3360 }, { 102,-3360 },
 { 103,-3360 }, { 104,-3360 }, { 105,-3360 }, { 106,-3360 }, { 107,-3360 },
 { 108,-3360 }, { 109,-3360 }, { 110,-3360 }, { 111,-3360 }, { 112,-3360 },
 { 113,-3360 }, { 114,-3360 }, { 115,-3360 }, { 116,-3360 }, { 117,-3360 },
 { 118,-3360 }, { 119,-3360 }, { 120,-3360 }, { 121,-3360 }, { 122,-3360 },
 { 123,-3360 }, { 124,-3360 }, { 125,-3360 }, { 126,-3360 }, { 127,-3360 },
 { 128,-3360 }, { 129,-3360 }, { 130,-3360 }, { 131,-3360 }, { 132,-3360 },

 { 133,-3360 }, { 134,-3360 }, { 135,-3360 }, { 136,-3360 }, { 137,-3360 },
 { 138,-3360 }, { 139,-3360 }, { 140,-3360 }, { 141,-3360 }, { 142,-3360 },
 { 143,-3360 }, { 144,-3360 }, { 145,-3360 }, { 146,-3360 }, { 147,-3360 },
 { 148,-3360 }, { 149,-3360 }, { 150,-3360 }, { 151,-3360 }, { 152,-3360 },
 { 153,-3360 }, { 154,-3360 }, { 155,-3360 }, { 156,-3360 }, { 157,-3360 },
 { 158,-3360 }, { 159,-3360 }, { 160,-3360 }, { 161,-3360 }, { 162,-3360 },
 { 163,-3360 }, { 164,-3360 }, { 165,-3360 }, { 166,-3360 }, { 167,-3360 },
 { 168,-3360 }, { 169,-3360 }, { 170,-3360 }, { 171,-3360 }, { 172,-3360 },
 { 173,-3360 }, { 174,-3360 }, { 175,-3360 }, { 176,-3360 }, { 177,-3360 },
 { 178,-3360 }, { 179,-3360 }, { 180,-3360 }, { 181,-3360 }, { 182,-3360 },

 { 183,-3360 }, { 184,-3360 }, { 185,-3360 }, { 186,-3360 }, { 187,-3360 },
 { 188,-3360 }, { 189,-3360 }, { 190,-3360 }, { 191,-3360 }, { 192,-3360 },
 { 193,-3360 }, { 194,-3360 }, { 195,-3360 }, { 196,-3360 }, { 197,-3360 },
 { 198,-3360 }, { 199,-3360 }, { 200,-3360 }, { 201,-3360 }, { 202,-3360 },
 { 203,-3360 }, { 204,-3360 }, { 205,-3360 }, { 206,-3360 }, { 207,-3360 },
 { 208,-3360 }, { 209,-3360 }, { 210,-3360 }, { 211,-3360 }, { 212,-3360 },
 { 213,-3360 }, { 214,-3360 }, { 215,-3360 }, { 216,-3360 }, { 217,-3360 },
 { 218,-3360 }, { 219,-3360 }, { 220,-3360 }, { 221,-3360 }, { 222,-3360 },
 { 223,-3360 }, { 224,-3360 }, { 225,-3360 }, { 226,-3360 }, { 227,-3360 },
 { 228,-3360 }, { 229,-3360 }, { 230,-3360 }, { 231,-3360 }, { 232,-3360 },

 { 233,-3360 }, { 234,-3360 }, { 235,-3360 }, { 236,-3360 }, { 237,-3360 },
 { 238,-3360 }, { 239,-3360 }, { 240,-3360 }, { 241,-3360 }, { 242,-3360 },
 { 243,-3360 }, { 244,-3360 }, { 245,-3360 }, { 246,-3360 }, { 247,-3360 },
 { 248,-3360 }, { 249,-3360 }, { 250,-3360 }, { 251,-3360 }, { 252,-3360 },
 { 253,-3360 }, { 254,-3360 }, { 255,-3360 }, { 256,-3360 }, {   0,  27 },
 {   0,2314 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,2291 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1172 }, {  49,1172 },
 {  50,1172 }, {  51,1172 }, {  52,1172 }, {  53,1172 }, {  54,1172 },
 {  55,1172 }, {  56,1172 }, {  57,1172 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0,2253 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,1172 }, {  66,1172 }, {  67,1172 }, {  68,1172 }, {  69,1172 },
 {  70,1172 }, {  48,1172 }, {  49,1172 }, {  50,1172 }, {  51,1172 },

 {  52,1172 }, {  53,1172 }, {  54,1172 }, {  55,1172 }, {  56,1172 },
 {  57,1172 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,2230 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1172 }, {  66,1172 },
 {  67,1172 }, {  68,1172 }, {  69,1172 }, {  70,1172 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,1172 }, {  98,1172 }, {  99,1172 },
 { 100,1172 }, { 101,1172 }, { 102,1172 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1172 },
 {  49,1172 }, {  50,1172 }, {  51,1172 }, {  52,1172 }, {  53,1172 },
 {  54,1172 }, {  55,1172 }, {  56,1172 }, {  57,1172 }, {   0,   0 },
 {  97,1172 }, {  98,1172 }, {  99,1172 }, { 100,1172 }, { 101,1172 },

 { 102,1172 }, {  65,1172 }, {  66,1172 }, {  67,1172 }, {  68,1172 },
 {  69,1172 }, {  70,1172 }, {  48,1172 }, {  49,1172 }, {  50,1172 },
 {  51,1172 }, {  52,1172 }, {  53,1172 }, {  54,1172 }, {  55,1172 },
 {  56,1172 }, {  57,1172 }, {   0,  63 }, {   0,2171 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1172 },
 {  66,1172 }, {  67,1172 }, {  68,1172 }, {  69,1172 }, {  70,1172 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,1172 }, {  98,1172 },
 {  99,1172 }, { 100,1172 }, { 101,1172 }, { 102,1172 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,1172 },
 {   0,   0 }, {  97,1172 }, {  98,1172 }, {  99,1172 }, { 100,1172 },
 { 101,1172 }, { 102,1172 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,1172 }, {  49,1172 }, {  50,1172 }, {  51,1172 },
 {  52,1172 }, {  53,1172 }, {  54,1172 }, {  55,1172 }, {  56,1172 },
 {  57,1172 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1172 }, {  66,1172 },
 {  67,1172 }, {  68,1172 }, {  69,1172 }, {  70,1172 }, {  71,1172 },
 {  72,1172 }, {  73,1172 }, {  74,1172 }, {  75,1172 }, {  76,1172 },
 {  77,1172 }, {  78,1172 }, {  79,1172 }, {  80,1172 }, {  81,1172 },

 {  82,1172 }, {  83,1172 }, {  84,1172 }, {  85,1172 }, {  86,1172 },
 {  87,1172 }, {  88,1172 }, {  89,1172 }, {  90,1172 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,1172 }, {   0,   0 },
 {  97,1172 }, {  98,1172 }, {  99,1172 }, { 100,1172 }, { 101,1172 },
 { 102,1172 }, { 103,1172 }, { 104,1172 }, { 105,1172 }, { 106,1172 },
 { 107,1172 }, { 108,1172 }, { 109,1172 }, { 110,1172 }, { 111,1172 },
 { 112,1172 }, { 113,1172 }, { 114,1172 }, { 115,1172 }, { 116,1172 },
 { 117,1172 }, { 118,1172 }, { 119,1172 }, { 120,1172 }, { 121,1172 },
 { 122,1172 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,1172 }, { 129,1172 }, { 130,1172 }, { 131,1172 },

 { 132,1172 }, { 133,1172 }, { 134,1172 }, { 135,1172 }, { 136,1172 },
 { 137,1172 }, { 138,1172 }, { 139,1172 }, { 140,1172 }, { 141,1172 },
 { 142,1172 }, { 143,1172 }, { 144,1172 }, { 145,1172 }, { 146,1172 },
 { 147,1172 }, { 148,1172 }, { 149,1172 }, { 150,1172 }, { 151,1172 },
 { 152,1172 }, { 153,1172 }, { 154,1172 }, { 155,1172 }, { 156,1172 },
 { 157,1172 }, { 158,1172 }, { 159,1172 }, { 160,1172 }, { 161,1172 },
 { 162,1172 }, { 163,1172 }, { 164,1172 }, { 165,1172 }, { 166,1172 },
 { 167,1172 }, { 168,1172 }, { 169,1172 }, { 170,1172 }, { 171,1172 },
 { 172,1172 }, { 173,1172 }, { 174,1172 }, { 175,1172 }, { 176,1172 },
 { 177,1172 }, { 178,1172 }, { 179,1172 }, { 180,1172 }, { 181,1172 },

 { 182,1172 }, { 183,1172 }, { 184,1172 }, { 185,1172 }, { 186,1172 },
 { 187,1172 }, { 188,1172 }, { 189,1172 }, { 190,1172 }, { 191,1172 },
 { 192,1172 }, { 193,1172 }, { 194,1172 }, { 195,1172 }, { 196,1172 },
 { 197,1172 }, { 198,1172 }, { 199,1172 }, { 200,1172 }, { 201,1172 },
 { 202,1172 }, { 203,1172 }, { 204,1172 }, { 205,1172 }, { 206,1172 },
 { 207,1172 }, { 208,1172 }, { 209,1172 }, { 210,1172 }, { 211,1172 },
 { 212,1172 }, { 213,1172 }, { 214,1172 }, { 215,1172 }, { 216,1172 },
 { 217,1172 }, { 218,1172 }, { 219,1172 }, { 220,1172 }, { 221,1172 },
 { 222,1172 }, { 223,1172 }, { 224,1172 }, { 225,1172 }, { 226,1172 },
 { 227,1172 }, { 228,1172 }, { 229,1172 }, { 230,1172 }, { 231,1172 },

 { 232,1172 }, { 233,1172 }, { 234,1172 }, { 235,1172 }, { 236,1172 },
 { 237,1172 }, { 238,1172 }, { 239,1172 }, { 240,1172 }, { 241,1172 },
 { 242,1172 }, { 243,1172 }, { 244,1172 }, { 245,1172 }, { 246,1172 },
 { 247,1172 }, { 248,1172 }, { 249,1172 }, { 250,1172 }, { 251,1172 },
 { 252,1172 }, { 253,1172 }, { 254,1172 }, { 255,1172 }, {   0,  64 },
 {   0,1914 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,1172 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1172 }, {  49,1172 },
 {  50,1172 }, {  51,1172 }, {  52,1172 }, {  53,1172 }, {  54,1172 },
 {  55,1172 }, {  56,1172 }, {  57,1172 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,1172 }, {  66,1172 }, {  67,1172 }, {  68,1172 }, {  69,1172 },
 {  70,1172 }, {  71,1172 }, {  72,1172 }, {  73,1172 }, {  74,1172 },

 {  75,1172 }, {  76,1172 }, {  77,1172 }, {  78,1172 }, {  79,1172 },
 {  80,1172 }, {  81,1172 }, {  82,1172 }, {  83,1172 }, {  84,1172 },
 {  85,1172 }, {  86,1172 }, {  87,1172 }, {  88,1172 }, {  89,1172 },
 {  90,1172 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,1172 }, {   0,   0 }, {  97,1172 }, {  98,1172 }, {  99,1172 },
 { 100,1172 }, { 101,1172 }, { 102,1172 }, { 103,1172 }, { 104,1172 },
 { 105,1172 }, { 106,1172 }, { 107,1172 }, { 108,1172 }, { 109,1172 },
 { 110,1172 }, { 111,1172 }, { 112,1172 }, { 113,1172 }, { 114,1172 },
 { 115,1172 }, { 116,1172 }, { 117,1172 }, { 118,1172 }, { 119,1172 },
 { 120,1172 }, { 121,1172 }, { 122,1172 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,1172 }, { 129,1172 },
 { 130,1172 }, { 131,1172 }, { 132,1172 }, { 133,1172 }, { 134,1172 },
 { 135,1172 }, { 136,1172 }, { 137,1172 }, { 138,1172 }, { 139,1172 },
 { 140,1172 }, { 141,1172 }, { 142,1172 }, { 143,1172 }, { 144,1172 },
 { 145,1172 }, { 146,1172 }, { 147,1172 }, { 148,1172 }, { 149,1172 },
 { 150,1172 }, { 151,1172 }, { 152,1172 }, { 153,1172 }, { 154,1172 },
 { 155,1172 }, { 156,1172 }, { 157,1172 }, { 158,1172 }, { 159,1172 },
 { 160,1172 }, { 161,1172 }, { 162,1172 }, { 163,1172 }, { 164,1172 },
 { 165,1172 }, { 166,1172 }, { 167,1172 }, { 168,1172 }, { 169,1172 },
 { 170,1172 }, { 171,1172 }, { 172,1172 }, { 173,1172 }, { 174,1172 },

 { 175,1172 }, { 176,1172 }, { 177,1172 }, { 178,1172 }, { 179,1172 },
 { 180,1172 }, { 181,1172 }, { 182,1172 }, { 183,1172 }, { 184,1172 },
 { 185,1172 }, { 186,1172 }, { 187,1172 }, { 188,1172 }, { 189,1172 },
 { 190,1172 }, { 191,1172 }, { 192,1172 }, { 193,1172 }, { 194,1172 },
 { 195,1172 }, { 196,1172 }, { 197,1172 }, { 198,1172 }, { 199,1172 },
 { 200,1172 }, { 201,1172 }, { 202,1172 }, { 203,1172 }, { 204,1172 },
 { 205,1172 }, { 206,1172 }, { 207,1172 }, { 208,1172 }, { 209,1172 },
 { 210,1172 }, { 211,1172 }, { 212,1172 }, { 213,1172 }, { 214,1172 },
 { 215,1172 }, { 216,1172 }, { 217,1172 }, { 218,1172 }, { 219,1172 },
 { 220,1172 }, { 221,1172 }, { 222,1172 }, { 223,1172 }, { 224,1172 },

 { 225,1172 }, { 226,1172 }, { 227,1172 }, { 228,1172 }, { 229,1172 },
 { 230,1172 }, { 231,1172 }, { 232,1172 }, { 233,1172 }, { 234,1172 },
 { 235,1172 }, { 236,1172 }, { 237,1172 }, { 238,1172 }, { 239,1172 },
 { 240,1172 }, { 241,1172 }, { 242,1172 }, { 243,1172 }, { 244,1172 },
 { 245,1172 }, { 246,1172 }, { 247,1172 }, { 248,1172 }, { 249,1172 },
 { 250,1172 }, { 251,1172 }, { 252,1172 }, { 253,1172 }, { 254,1172 },
 { 255,1172 }, {   0,  62 }, {   0,1657 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },

 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },

 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },

 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },

 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  18 }, {   0,1400 },
 {   1,-1993 }, {   2,-1993 }, {   3,-1993 }, {   4,-1993 }, {   5,-1993 },
 {   6,-1993 }, {   7,-1993 }, {   8,-1993 }, {   9,-1735 }, {  10,-1477 },

 {  11,-1993 }, {  12,-1735 }, {  13,-1477 }, {  14,-1993 }, {  15,-1993 },
 {  16,-1993 }, {  17,-1993 }, {  18,-1993 }, {  19,-1993 }, {  20,-1993 },
 {  21,-1993 }, {  22,-1993 }, {  23,-1993 }, {  24,-1993 }, {  25,-1993 },
 {  26,-1993 }, {  27,-1993 }, {  28,-1993 }, {  29,-1993 }, {  30,-1993 },
 {  31,-1993 }, {  32,-1735 }, {  33,-1993 }, {  34,-1993 }, {  35,-1993 },
 {  36,-1993 }, {  37,-1993 }, {  38,-1993 }, {  39,-1993 }, {  40,-1993 },
 {  41,-1993 }, {  42,-1993 }, {  43,-1993 }, {  44,-1993 }, {  45,   0 },
 {  46,-1993 }, {  47,-1993 }, {  48,-1993 }, {  49,-1993 }, {  50,-1993 },
 {  51,-1993 }, {  52,-1993 }, {  53,-1993 }, {  54,-1993 }, {  55,-1993 },
 {  56,-1993 }, {  57,-1993 }, {  58,-1993 }, {  59,-1993 }, {  60,-1993 },

 {  61,-1993 }, {  62,-1993 }, {  63,-1993 }, {  64,-1993 }, {  65,-1993 },
 {  66,-1993 }, {  67,-1993 }, {  68,-1993 }, {  69,-1993 }, {  70,-1993 },
 {  71,-1993 }, {  72,-1993 }, {  73,-1993 }, {  74,-1993 }, {  75,-1993 },
 {  76,-1993 }, {  77,-1993 }, {  78,-1993 }, {  79,-1993 }, {  80,-1993 },
 {  81,-1993 }, {  82,-1993 }, {  83,-1993 }, {  84,-1993 }, {  85,-1993 },
 {  86,-1993 }, {  87,-1993 }, {  88,-1993 }, {  89,-1993 }, {  90,-1993 },
 {  91,-1993 }, {  92,-1993 }, {  93,-1993 }, {  94,-1993 }, {  95,-1993 },
 {  96,-1993 }, {  97,-1993 }, {  98,-1993 }, {  99,-1993 }, { 100,-1993 },
 { 101,-1993 }, { 102,-1993 }, { 103,-1993 }, { 104,-1993 }, { 105,-1993 },
 { 106,-1993 }, { 107,-1993 }, { 108,-1993 }, { 109,-1993 }, { 110,-1993 },

 { 111,-1993 }, { 112,-1993 }, { 113,-1993 }, { 114,-1993 }, { 115,-1993 },
 { 116,-1993 }, { 117,-1993 }, { 118,-1993 }, { 119,-1993 }, { 120,-1993 },
 { 121,-1993 }, { 122,-1993 }, { 123,-1993 }, { 124,-1993 }, { 125,-1993 },
 { 126,-1993 }, { 127,-1993 }, { 128,-1993 }, { 129,-1993 }, { 130,-1993 },
 { 131,-1993 }, { 132,-1993 }, { 133,-1993 }, { 134,-1993 }, { 135,-1993 },
 { 136,-1993 }, { 137,-1993 }, { 138,-1993 }, { 139,-1993 }, { 140,-1993 },
 { 141,-1993 }, { 142,-1993 }, { 143,-1993 }, { 144,-1993 }, { 145,-1993 },
 { 146,-1993 }, { 147,-1993 }, { 148,-1993 }, { 149,-1993 }, { 150,-1993 },
 { 151,-1993 }, { 152,-1993 }, { 153,-1993 }, { 154,-1993 }, { 155,-1993 },
 { 156,-1993 }, { 157,-1993 }, { 158,-1993 }, { 159,-1993 }, { 160,-1993 },

 { 161,-1993 }, { 162,-1993 }, { 163,-1993 }, { 164,-1993 }, { 165,-1993 },
 { 166,-1993 }, { 167,-1993 }, { 168,-1993 }, { 169,-1993 }, { 170,-1993 },
 { 171,-1993 }, { 172,-1993 }, { 173,-1993 }, { 174,-1993 }, { 175,-1993 },
 { 176,-1993 }, { 177,-1993 }, { 178,-1993 }, { 179,-1993 }, { 180,-1993 },
 { 181,-1993 }, { 182,-1993 }, { 183,-1993 }, { 184,-1993 }, { 185,-1993 },
 { 186,-1993 }, { 187,-1993 }, { 188,-1993 }, { 189,-1993 }, { 190,-1993 },
 { 191,-1993 }, { 192,-1993 }, { 193,-1993 }, { 194,-1993 }, { 195,-1993 },
 { 196,-1993 }, { 197,-1993 }, { 198,-1993 }, { 199,-1993 }, { 200,-1993 },
 { 201,-1993 }, { 202,-1993 }, { 203,-1993 }, { 204,-1993 }, { 205,-1993 },
 { 206,-1993 }, { 207,-1993 }, { 208,-1993 }, { 209,-1993 }, { 210,-1993 },

 { 211,-1993 }, { 212,-1993 }, { 213,-1993 }, { 214,-1993 }, { 215,-1993 },
 { 216,-1993 }, { 217,-1993 }, { 218,-1993 }, { 219,-1993 }, { 220,-1993 },
 { 221,-1993 }, { 222,-1993 }, { 223,-1993 }, { 224,-1993 }, { 225,-1993 },
 { 226,-1993 }, { 227,-1993 }, { 228,-1993 }, { 229,-1993 }, { 230,-1993 },
 { 231,-1993 }, { 232,-1993 }, { 233,-1993 }, { 234,-1993 }, { 235,-1993 },
 { 236,-1993 }, { 237,-1993 }, { 238,-1993 }, { 239,-1993 }, { 240,-1993 },
 { 241,-1993 }, { 242,-1993 }, { 243,-1993 }, { 244,-1993 }, { 245,-1993 },
 { 246,-1993 }, { 247,-1993 }, { 248,-1993 }, { 249,-1993 }, { 250,-1993 },
 { 251,-1993 }, { 252,-1993 }, { 253,-1993 }, { 254,-1993 }, { 255,-1993 },
 { 256,-1993 }, {   0,  27 }, {   0,1142 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,1119 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 657 }, {  49, 657 }, {  50, 657 }, {  51, 657 }, {  52, 657 },

 {  53, 657 }, {  54, 657 }, {  55, 657 }, {  56, 657 }, {  57, 657 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,1081 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 657 }, {  66, 657 }, {  67, 657 },
 {  68, 657 }, {  69, 657 }, {  70, 657 }, {  48,-18062 }, {  49,-18062 },
 {  50,-18062 }, {  51,-18062 }, {  52,-18062 }, {  53,-18062 }, {  54,-18062 },
 {  55,-18062 }, {  56,-18062 }, {  57,-18062 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0,1058 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-18062 }, {  66,-18062 }, {  67,-18062 }, {  68,-18062 }, {  69,-18062 },
 {  70,-18062 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 657 },
 {  98, 657 }, {  99, 657 }, { 100, 657 }, { 101, 657 }, { 102, 657 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48, 619 }, {  49, 619 }, {  50, 619 }, {  51, 619 },
 {  52, 619 }, {  53, 619 }, {  54, 619 }, {  55, 619 }, {  56, 619 },
 {  57, 619 }, {   0,   0 }, {  97,-18062 }, {  98,-18062 }, {  99,-18062 },
 { 100,-18062 }, { 101,-18062 }, { 102,-18062 }, {  65, 619 }, {  66, 619 },
 {  67, 619 }, {  68, 619 }, {  69, 619 }, {  70, 619 }, {  48,-18121 },
 {  49,-18121 }, {  50,-18121 }, {  51,-18121 }, {  52,-18121 }, {  53,-18121 },
 {  54,-18121 }, {  55,-18121 }, {  56,-18121 }, {  57,-18121 }, {   0,  63 },
 {   0, 999 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-18121 }, {  66,-18121 }, {  67,-18121 }, {  68,-18121 },

 {  69,-18121 }, {  70,-18121 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97, 619 }, {  98, 619 }, {  99, 619 }, { 100, 619 }, { 101, 619 },
 { 102, 619 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   0 }, {   0,   0 }, {  97,-18121 }, {  98,-18121 },
 {  99,-18121 }, { 100,-18121 }, { 101,-18121 }, { 102,-18121 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },

 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },

 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },

 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, {   0,  64 }, {   0, 742 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },

 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },

 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },

 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },

 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },

 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  27 }, {   0, 485 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0, 462 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  48,  61 }, {  49,  61 }, {  50,  61 },
 {  51,  61 }, {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 },
 {  56,  61 }, {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0, 424 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 },
 {  66,  61 }, {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 },
 {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 },
 {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 401 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 },
 {  68,  61 }, {  69,  61 }, {  70,  61 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 },
 { 101,  61 }, { 102,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,  82 }, {  49,  82 },
 {  50,  82 }, {  51,  82 }, {  52,  82 }, {  53,  82 }, {  54,  82 },
 {  55,  82 }, {  56,  82 }, {  57,  82 }, {   0,   0 }, {  97,  61 },
 {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 },
 {  65,  82 }, {  66,  82 }, {  67,  82 }, {  68,  82 }, {  69,  82 },
 {  70,  82 }, {  48,  82 }, {  49,  82 }, {  50,  82 }, {  51,  82 },
 {  52,  82 }, {  53,  82 }, {  54,  82 }, {  55,  82 }, {  56,  82 },
 {  57,  82 }, {   0,  27 }, {   0, 342 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  82 }, {  66,  82 },
 {  67,  82 }, {  68,  82 }, {  69,  82 }, {  70,  82 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,  82 }, {  98,  82 }, {  99,  82 },
 { 100,  82 }, { 101,  82 }, { 102,  82 }, {   0,   0 }, {   0,  27 },
 {   0, 319 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,  82 }, {  98,  82 }, {  99,  82 }, { 100,  82 }, { 101,  82 },
 { 102,  82 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 },

 {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 281 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 },
 {  68,  61 }, {  69,  61 }, {  70,  61 }, {  48,  61 }, {  49,  61 },
 {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 }, {  54,  61 },
 {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0, 258 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 }, {  69,  61 },
 {  70,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  61 },
 {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,-18900 }, {  49,-18900 }, {  50,-18900 }, {  51,-18900 },
 {  52,-18900 }, {  53,-18900 }, {  54,-18900 }, {  55,-18900 }, {  56,-18900 },
 {  57,-18900 }, {   0,   0 }, {  97,  61 }, {  98,  61 }, {  99,  61 },
 { 100,  61 }, { 101,  61 }, { 102,  61 }, {  65,-18900 }, {  66,-18900 },
 {  67,-18900 }, {  68,-18900 }, {  69,-18900 }, {  70,-18900 }, {  48,-18921 },
 {  49,-18921 }, {  50,-18921 }, {  51,-18921 }, {  52,-18921 }, {  53,-18921 },
 {  54,-18921 }, {  55,-18921 }, {  56,-18921 }, {  57,-18921 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-18921 }, {  66,-18921 }, {  67,-18921 }, {  68,-18921 },

 {  69,-18921 }, {  70,-18921 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,-18900 }, {  98,-18900 }, {  99,-18900 }, { 100,-18900 }, { 101,-18900 },
 { 102,-18900 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-18921 }, {  98,-18921 },
 {  99,-18921 }, { 100,-18921 }, { 101,-18921 }, { 102,-18921 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 257,  68 }, {   1,   0 },
    };

static const struct yy_trans_info *yy_start_state_list[25] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scan.l"

#line 47 "scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;
bool		escape_string_warning = true;
bool		standard_conforming_strings = true;

/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category, collabel) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Set the type of yyextra.  All state variables used by the scanner should
 * be in yyextra, *not* statically allocated.
 */
#define YY_EXTRA_TYPE core_yy_extra_type *

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

/*
 * Sometimes, we do want yylloc to point into the middle of a token; this is
 * useful for instance to throw an error about an escape sequence within a
 * string literal.  But if we find no error there, we want to revert yylloc
 * to the token start, so that that's the location reported to the parser.
 * Use PUSH_YYLLOC/POP_YYLLOC to save/restore yylloc around such code.
 * (Currently the implied "stack" is just one location, but someday we might
 * need to nest these.)
 */
#define PUSH_YYLLOC()	(yyextra->save_yylloc = *(yylloc))
#define POP_YYLLOC()	(*(yylloc) = yyextra->save_yylloc)

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval);
static void addunicode(pg_wchar c, yyscan_t yyscanner);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

/*
 * Work around a bug in flex 2.5.35: it emits a couple of functions that
 * it forgets to emit declarations for.  Since we use -Wmissing-prototypes,
 * this would cause warnings.  Providing our own declarations should be
 * harmless even when the bug gets fixed.
 */
extern int	core_yyget_column(yyscan_t yyscanner);
extern void core_yyset_column(int column_no, yyscan_t yyscanner);

#line 6452 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal byte string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {decimalfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 6602 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10
#define xeu 11

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 423 "scan.l"


#line 6898 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 425 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 429 "scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 3:
YY_RULE_SETUP
#line 439 "scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 445 "scan.l"
{
					if (yyextra->xcdepth <= 0)
						BEGIN(INITIAL);
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 452 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 456 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 460 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 464 "scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 8:
YY_RULE_SETUP
#line 469 "scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 9:
/* rule 9 can match eol */
#line 482 "scan.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 482 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 485 "scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 487 "scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 499 "scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 501 "scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						return IDENT;
					}
				}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 527 "scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 537 "scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 544 "scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when standard_conforming_strings is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 556 "scan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					yyextra->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 568 "scan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(yyextra->state_before_str_stop);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
#line 577 "scan.l"
case 19:
/* rule 19 can match eol */
#line 578 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 578 "scan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);

					switch (yyextra->state_before_str_stop)
					{
						case xb:
							yylval->str = litbufdup(yyscanner);
							return BCONST;
						case xh:
							yylval->str = litbufdup(yyscanner);
							return XCONST;
						case xq:
						case xe:
							/*
							 * Check that the data remains valid, if it might
							 * have been made invalid by unescaping any chars.
							 */
							if (yyextra->saw_non_ascii)
								pg_verifymbstr(yyextra->literalbuf,
											   yyextra->literallen,
											   false);
							yylval->str = litbufdup(yyscanner);
							return SCONST;
						case xus:
							yylval->str = litbufdup(yyscanner);
							return USCONST;
						default:
							yyerror("unhandled previous state in xqs");
					}
				}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 615 "scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 618 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 621 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 624 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/*
					 * For consistency with other productions, issue any
					 * escape warning with cursor pointing to start of string.
					 * We might want to change that, someday.
					 */
					check_escape_warning(yyscanner);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 652 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();

					BEGIN(xe);
				}
	YY_BREAK
case 25:
#line 673 "scan.l"
case 26:
/* rule 26 can match eol */
#line 674 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xeu):
#line 674 "scan.l"
{
					/* Set the error cursor to point at missing esc seq */
					SET_YYLLOC();
					yyerror("invalid Unicode surrogate pair");
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 679 "scan.l"
{
					/* Set the error cursor to point at malformed esc seq */
					SET_YYLLOC();
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 688 "scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 704 "scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 712 "scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 720 "scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 724 "scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 726 "scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 732 "scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 739 "scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 759 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 762 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 765 "scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 769 "scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 771 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 776 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 781 "scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 793 "scan.l"
{
					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					/* can't truncate till after we de-escape the ident */
					yylval->str = litbufdup(yyscanner);
					return UIDENT;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 801 "scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 804 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 807 "scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 809 "scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 821 "scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 826 "scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 831 "scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 836 "scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 841 "scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 846 "scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 851 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 857 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 863 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 868 "scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 976 "scan.l"
{
					SET_YYLLOC();
					yylval->ival = atol(yytext + 1);
					return PARAM;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 981 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after parameter");
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 986 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 990 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 995 "scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 1001 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 1006 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 1010 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1014 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1018 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1024 "scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1049 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1054 "scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1059 "scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 7835 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

YYLTYPE *yyget_lloc  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylloc;
}
    
void yyset_lloc (YYLTYPE *  yylloc_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylloc = yylloc_param;
}
    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1059 "scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call, or via an error
 * callback such as setup_scanner_errposition_callback().  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l, parser.c, and gram.y), since it requires the
 * yyscanner struct to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * Error context callback for inserting scanner error location.
 *
 * Note that this will be called for *any* error occurring while the
 * callback is installed.  We avoid inserting an irrelevant error location
 * if the error is a query cancel --- are there any other important cases?
 */
static void
scb_error_callback(void *arg)
{
	ScannerCallbackState *scbstate = (ScannerCallbackState *) arg;

	if (geterrcode() != ERRCODE_QUERY_CANCELED)
		(void) scanner_errposition(scbstate->location, scbstate->yyscanner);
}

/*
 * setup_scanner_errposition_callback
 *		Arrange for non-scanner errors to report an error position
 *
 * Sometimes the scanner calls functions that aren't part of the scanner
 * subsystem and can't reasonably be passed the yyscanner pointer; yet
 * we would like any errors thrown in those functions to be tagged with an
 * error location.  Use this function to set up an error context stack
 * entry that will accomplish that.  Usage pattern:
 *
 *		declare a local variable "ScannerCallbackState scbstate"
 *		...
 *		setup_scanner_errposition_callback(&scbstate, yyscanner, location);
 *		call function that might throw error;
 *		cancel_scanner_errposition_callback(&scbstate);
 */
void
setup_scanner_errposition_callback(ScannerCallbackState *scbstate,
								   core_yyscan_t yyscanner,
								   int location)
{
	/* Setup error traceback support for ereport() */
	scbstate->yyscanner = yyscanner;
	scbstate->location = location;
	scbstate->errcallback.callback = scb_error_callback;
	scbstate->errcallback.arg = (void *) scbstate;
	scbstate->errcallback.previous = error_context_stack;
	error_context_stack = &scbstate->errcallback;
}

/*
 * Cancel a previously-set-up errposition callback.
 */
void
cancel_scanner_errposition_callback(ScannerCallbackState *scbstate)
{
	/* Pop the error context stack */
	error_context_stack = scbstate->errcallback.previous;
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		yyextra->literalalloc = pg_nextpower2_32(yyextra->literallen + yleng + 1);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {integer}.  Note this will also do the right thing with {decimal},
 * ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(token, &endptr, 10);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	ScannerCallbackState scbstate;
	char		buf[MAX_UNICODE_EQUIVALENT_STRING + 1];

	if (!is_valid_unicode_codepoint(c))
		yyerror("invalid Unicode escape value");

	/*
	 * We expect that pg_unicode_to_server() will complain about any
	 * unconvertible code point, so we don't have to set saw_non_ascii.
	 */
	setup_scanner_errposition_callback(&scbstate, yyscanner, *(yylloc));
	pg_unicode_to_server(c, (unsigned char *) buf);
	cancel_scanner_errposition_callback(&scbstate);
	addlit(buf, strlen(buf), yyscanner);
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
		errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;		/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}

void
core_yyfree(void *ptr, core_yyscan_t yyscanner)
{
	if (ptr)
		pfree(ptr);
}

