/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.StructuredSleigh.RVal;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;

public class RawExpr extends Expr {
	private final String expr;

	private RawExpr(StructuredSleigh ctx, String expr, DataType type) {
		super(ctx, type);
		this.expr = expr;
	}

	protected RawExpr(StructuredSleigh ctx, String expr) {
		this(ctx, expr, VoidDataType.dataType);
	}

	@Override
	public RVal cast(DataType type) {
		return new RawExpr(ctx, expr, type);
	}

	@Override
	public StringTree generate(RValInternal parent) {
		if (parent instanceof AssignStmt as && as.lhs == this) {
			return StringTree.single(expr);
		}
		StringTree st = new StringTree();
		st.append("(");
		st.append(expr);
		st.append(")");
		return st;
	}
}
