/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import db.Transaction;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Function;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import java.util.Date;

public class SnapshotRow {
    private final TraceSnapshot snapshot;
    private final ServiceProvider serviceProvider;
    private final Trace trace;

    public SnapshotRow(TraceSnapshot snapshot, ServiceProvider serviceProvider) {
        this.snapshot = snapshot;
        this.serviceProvider = serviceProvider;
        this.trace = snapshot.getTrace();
    }

    public TraceSnapshot getSnapshot() {
        return this.snapshot;
    }

    public TraceSchedule getTime() {
        long snap = this.snapshot.getKey();
        if (snap < 0L) {
            return this.snapshot.getSchedule();
        }
        return TraceSchedule.snap((long)snap);
    }

    public long getSnap() {
        return this.snapshot.getKey();
    }

    public Date getTimeStamp() {
        return new Date(this.snapshot.getRealTime());
    }

    private Address getProgramCounterByStack() {
        TraceStack stack;
        TraceThread thread = this.snapshot.getEventThread();
        if (thread == null) {
            return null;
        }
        long snap = this.getTime().getSnap();
        try {
            stack = this.trace.getStackManager().getLatestStack(thread, snap);
        }
        catch (IllegalStateException e) {
            return null;
        }
        if (stack == null) {
            return null;
        }
        TraceStackFrame frame = stack.getFrame(snap, 0, false);
        if (frame == null) {
            return null;
        }
        return frame.getProgramCounter(snap);
    }

    private Address getProgramCounterByRegister() {
        TraceThread thread = this.getEventThread();
        if (thread == null) {
            return null;
        }
        long viewSnap = this.snapshot.getKey();
        long snap = this.getTime().getSnap();
        record MostRecentValue(TracePlatform platform, long snap, RegisterValue value) {
            static MostRecentValue choose(MostRecentValue a, MostRecentValue b) {
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                if (Long.compareUnsigned(a.snap, b.snap) > 0) {
                    return a;
                }
                return b;
            }

            static MostRecentValue get(TracePlatform platform, TraceThread thread, long viewSnap, long snap) {
                TraceMemorySpace regs;
                Register reg = platform.getLanguage().getProgramCounter();
                TraceMemoryManager mm = thread.getTrace().getMemoryManager();
                TraceMemorySpace traceMemorySpace = regs = reg.getAddressSpace().isRegisterSpace() ? mm.getMemoryRegisterSpace(thread, false) : mm.getMemorySpace(reg.getAddressSpace(), false);
                if (regs == null) {
                    return null;
                }
                if (regs.getState(platform, viewSnap, reg) == TraceMemoryState.KNOWN) {
                    RegisterValue value = regs.getValue(platform, viewSnap, reg);
                    return value == null ? null : new MostRecentValue(platform, viewSnap, value);
                }
                RegisterValue value = regs.getValue(platform, snap, reg);
                return value == null ? null : new MostRecentValue(platform, snap, value);
            }

            Address mapToHost() {
                AddressSpace codeSpace = this.platform.getAddressFactory().getDefaultAddressSpace();
                return this.platform.mapGuestToHost(codeSpace.getAddress(this.value.getUnsignedValue().longValue(), true));
            }
        }
        MostRecentValue choice = MostRecentValue.get(this.trace.getPlatformManager().getHostPlatform(), thread, viewSnap, snap);
        for (TraceGuestPlatform guest : this.trace.getPlatformManager().getGuestPlatforms()) {
            choice = MostRecentValue.choose(choice, MostRecentValue.get((TracePlatform)guest, thread, viewSnap, snap));
        }
        return choice == null ? null : choice.mapToHost();
    }

    public Address getProgramCounter() {
        Address byStack = this.getProgramCounterByStack();
        return byStack != null ? byStack : this.getProgramCounterByRegister();
    }

    public Function getFunction() {
        Address pc = this.getProgramCounter();
        if (pc == null) {
            return null;
        }
        return DebuggerStaticMappingUtils.getFunction(pc, this.trace, this.getTime().getSnap(), this.serviceProvider);
    }

    public String getModuleName() {
        Address pc = this.getProgramCounter();
        if (pc == null) {
            return null;
        }
        return DebuggerStaticMappingUtils.getModuleName(pc, this.trace, this.getTime().getSnap());
    }

    private TraceThread getEventThread() {
        TraceThread thread = this.snapshot.getEventThread();
        if (thread != null) {
            return thread;
        }
        return this.getTime().getLastThread(this.trace);
    }

    public String getEventThreadName() {
        TraceThread thread = this.getEventThread();
        return thread == null ? "" : thread.getName(this.getTime().getSnap());
    }

    public TraceSchedule getSchedule() {
        return this.snapshot.getSchedule();
    }

    public String getDescription() {
        return this.snapshot.getDescription();
    }

    public void setDescription(String description) {
        try (Transaction tx = this.trace.openTransaction("Modify snapshot description");){
            this.snapshot.setDescription(description);
        }
    }
}

