/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sarif;

import com.contrastsecurity.sarif.Message;
import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.ThreadFlow;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"message", "threadFlows", "properties"})
public class CodeFlow {
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message message;
    @JsonProperty(value="threadFlows")
    @JsonPropertyDescription(value="An array of one or more unique threadFlow objects, each of which describes the progress of a program through a thread of execution.")
    private List<ThreadFlow> threadFlows = null;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="message")
    public Message getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(Message message) {
        this.message = message;
    }

    public CodeFlow withMessage(Message message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="threadFlows")
    public List<ThreadFlow> getThreadFlows() {
        return this.threadFlows;
    }

    @JsonProperty(value="threadFlows")
    public void setThreadFlows(List<ThreadFlow> threadFlows) {
        this.threadFlows = threadFlows;
    }

    public CodeFlow withThreadFlows(List<ThreadFlow> threadFlows) {
        this.threadFlows = threadFlows;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public CodeFlow withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeFlow.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("threadFlows");
        sb.append('=');
        sb.append(this.threadFlows == null ? "<null>" : this.threadFlows);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.threadFlows == null ? 0 : this.threadFlows.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CodeFlow)) {
            return false;
        }
        CodeFlow rhs = (CodeFlow)other;
        return (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.threadFlows == rhs.threadFlows || this.threadFlows != null && this.threadFlows.equals(rhs.threadFlows)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

