/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.grammars;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AssemblySentential<NT extends AssemblyNonTerminal>
implements Comparable<AssemblySentential<NT>>,
Iterable<AssemblySymbol> {
    private List<AssemblySymbol> symbols;
    private final List<AssemblySymbol> unmodifiableSymbols;
    private boolean finished = false;
    public static final AssemblyStringTerminal WHITE_SPACE = new WhiteSpace();
    private static final Pattern PAT_COMMA_WS = Pattern.compile(",\\s+");

    public AssemblySentential(List<? extends AssemblySymbol> symbols) {
        this.symbols = new ArrayList<AssemblySymbol>(symbols);
        this.unmodifiableSymbols = Collections.unmodifiableList(symbols);
    }

    public AssemblySentential() {
        this.symbols = new ArrayList<AssemblySymbol>();
        this.unmodifiableSymbols = Collections.unmodifiableList(this.symbols);
    }

    public AssemblySentential(AssemblySymbol ... syms) {
        this.symbols = Arrays.asList(syms);
        this.unmodifiableSymbols = Collections.unmodifiableList(this.symbols);
    }

    public String toString() {
        if (this.symbols.isEmpty()) {
            return "e";
        }
        Iterator<AssemblySymbol> symIt = this.symbols.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(symIt.next());
        while (symIt.hasNext()) {
            sb.append(" ");
            sb.append(symIt.next());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(AssemblySentential<NT> that) {
        int min = Math.min(this.symbols.size(), that.symbols.size());
        for (int i = 0; i < min; ++i) {
            AssemblySymbol b;
            AssemblySymbol a = this.symbols.get(i);
            int result = a.compareTo(b = that.symbols.get(i));
            if (result == 0) continue;
            return result;
        }
        if (that.symbols.size() > min) {
            return -1;
        }
        if (this.symbols.size() > min) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 0;
        for (AssemblySymbol sym : this.symbols) {
            result *= 31;
            result += sym.hashCode();
        }
        return result;
    }

    public boolean addSymbol(AssemblySymbol symbol) {
        return this.symbols.add(symbol);
    }

    public boolean addWS() {
        WhiteSpace last = this.lastWhiteSpace();
        if (last != null) {
            return false;
        }
        return this.addSymbol(WHITE_SPACE);
    }

    public void addCommaWS() {
        this.addSymbol(new AssemblyStringTerminal(",", null));
        this.addWS();
    }

    public void addSeparatorPart(String str) {
        String tstr = str.trim();
        if (tstr.equals("")) {
            this.addWS();
            return;
        }
        char first = tstr.charAt(0);
        if (!str.startsWith(tstr)) {
            this.addWS();
        }
        if (!Character.isLetterOrDigit(first)) {
            this.addWS();
        }
        this.addSymbol(new AssemblyStringTerminal(tstr, null));
        char last = tstr.charAt(tstr.length() - 1);
        if (!str.endsWith(tstr)) {
            this.addWS();
        }
        if (!Character.isLetterOrDigit(last)) {
            this.addWS();
        }
    }

    public List<AssemblySymbol> getSymbols() {
        return this.unmodifiableSymbols;
    }

    public AssemblySymbol getSymbol(int pos) {
        return this.symbols.get(pos);
    }

    private static void forMatchUnmatch(String str, Pattern pat, Consumer<String> matched, Consumer<String> unmatched) {
        int startU = 0;
        Matcher mat = pat.matcher(str);
        while (mat.find()) {
            if (startU < mat.start()) {
                unmatched.accept(str.substring(startU, mat.start()));
            }
            matched.accept(mat.group());
            startU = mat.end();
        }
        if (startU < str.length()) {
            unmatched.accept(str.substring(startU));
        }
    }

    public void addSeparators(String str) {
        AssemblySentential.forMatchUnmatch(str, PAT_COMMA_WS, matched -> this.addCommaWS(), this::addSeparatorPart);
    }

    private WhiteSpace lastWhiteSpace() {
        if (this.symbols.size() == 0) {
            return null;
        }
        AssemblySymbol last = this.symbols.get(this.symbols.size() - 1);
        if (last instanceof WhiteSpace) {
            return (WhiteSpace)last;
        }
        return null;
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.symbols = this.unmodifiableSymbols;
        this.finished = true;
    }

    @Override
    public Iterator<AssemblySymbol> iterator() {
        return this.unmodifiableSymbols.iterator();
    }

    public AssemblySentential<NT> sub(int fromIndex, int toIndex) {
        return new AssemblySentential<NT>(this.symbols.subList(fromIndex, toIndex));
    }

    public int size() {
        return this.symbols.size();
    }

    private static class WhiteSpace
    extends AssemblyStringTerminal {
        private WhiteSpace() {
            super(" ", null);
        }

        @Override
        public String toString() {
            return "_";
        }

        @Override
        public Collection<AssemblyParseToken> match(String buffer, int pos, AssemblyGrammar grammar, AssemblyNumericSymbols symbols) {
            int b;
            if (buffer.length() == 0) {
                return Collections.singleton(new WhiteSpaceParseToken(grammar, this, ""));
            }
            for (b = pos; b < buffer.length() && Character.isWhitespace(buffer.charAt(b)); ++b) {
            }
            if (b == pos) {
                if (pos == buffer.length()) {
                    if (Character.isLetterOrDigit(buffer.charAt(b - 1))) {
                        return Collections.singleton(new TruncatedWhiteSpaceParseToken(grammar, this));
                    }
                    return Collections.singleton(new WhiteSpaceParseToken(grammar, this, ""));
                }
                if (Character.isLetterOrDigit(buffer.charAt(b)) && (b == 0 || Character.isLetterOrDigit(buffer.charAt(b - 1)))) {
                    return Collections.emptySet();
                }
            }
            return Collections.singleton(new WhiteSpaceParseToken(grammar, this, buffer.substring(pos, b)));
        }

        @Override
        public Collection<String> getSuggestions(String got, AssemblyNumericSymbols symbols) {
            return Collections.singleton(" ");
        }

        @Override
        public boolean isWhiteSpace() {
            return true;
        }
    }

    public static class TruncatedWhiteSpaceParseToken
    extends WhiteSpaceParseToken {
        public TruncatedWhiteSpaceParseToken(AssemblyGrammar grammar, AssemblyTerminal term) {
            super(grammar, term, "");
        }
    }

    public static class WhiteSpaceParseToken
    extends AssemblyParseToken {
        public WhiteSpaceParseToken(AssemblyGrammar grammar, AssemblyTerminal term, String str) {
            super(grammar, term, str);
        }
    }
}

