/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.apport;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.apport.MemoryInfo;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ApportHeader
implements StructConverter {
    public static final String NAME = "APPORT_HEADER";
    private Map<String, String> map = new HashMap<String, String>();
    private Map<String, Map<String, String>> smaps = new HashMap<String, Map<String, String>>();
    private Map<Integer, Integer> lineLens = new HashMap<Integer, Integer>();
    private Map<Integer, String> keys = new HashMap<Integer, String>();
    private String signature;
    protected DumpFileReader reader;
    protected long index;
    private TaskMonitor monitor;
    private int lineCount = 0;
    private int memoryRegionOffset;

    ApportHeader(DumpFileReader reader, long index, TaskMonitor monitor) throws IOException {
        this.reader = reader;
        this.index = index;
        this.monitor = monitor;
        this.parse();
    }

    protected void parse() throws IOException {
        if (this.lineCount > 0) {
            return;
        }
        this.reader.setPointerIndex(this.index);
        ArrayList<Integer> lineEnds = new ArrayList<Integer>();
        ArrayList<String> lines = new ArrayList<String>();
        ByteProvider provider = this.reader.getByteProvider();
        byte[] bytes = new byte[(int)this.reader.length()];
        int idx = 0;
        this.monitor.setMessage("Parsing file");
        this.monitor.initialize(this.reader.length());
        int i = 0;
        while ((long)i < this.reader.length()) {
            byte b = provider.readByte((long)i);
            if (b == 10) {
                String l = new String(bytes, 0, idx);
                lines.add(l);
                lineEnds.add(i);
                idx = 0;
                this.lineLens.put(this.lineCount, l.length());
                ++this.lineCount;
                this.monitor.setProgress((long)i);
            } else {
                bytes[idx++] = b;
            }
            if (this.monitor.isCancelled()) break;
            ++i;
        }
        String key = "";
        boolean useSubMap = false;
        HashMap<String, String> submap = null;
        int sub = 0;
        this.monitor.setMessage("Parsing entries");
        this.monitor.initialize((long)lineEnds.size());
        for (int i2 = 0; i2 < lineEnds.size(); ++i2) {
            int sep;
            this.monitor.setProgress((long)i2);
            if (this.monitor.isCancelled()) break;
            String line = (String)lines.get(i2);
            if (line.startsWith("CoreDump")) {
                this.memoryRegionOffset = (Integer)lineEnds.get(i2);
            }
            if ((sep = line.indexOf(":")) < 0 || line.substring(0, sep).contains(" ")) {
                String subkey = key + "[" + sub + "]";
                this.keys.put(i2, subkey);
                if (useSubMap) {
                    submap.put(subkey, line);
                    if (line.length() < 100 && line.contains(": ")) {
                        String[] split = line.split(": ");
                        submap.put(split[0], split[1]);
                    }
                }
                ++sub;
                continue;
            }
            key = line.substring(0, sep);
            String value = line.substring(sep + 1).trim();
            this.keys.put(i2, key);
            boolean bl = useSubMap = value.equals("") || value.equals("base64");
            if (useSubMap) {
                submap = new HashMap<String, String>();
                this.smaps.put(key, submap);
            } else {
                this.map.put(key, value);
                submap = null;
            }
            sub = 0;
        }
    }

    public DataType toDataType() {
        Integer length;
        StructureDataType struct = new StructureDataType(NAME, 0);
        for (int i = 0; i < this.lineCount && (length = this.lineLens.get(i)) >= 0; ++i) {
            String key = this.keys.get(i);
            StringDataType str = new StringDataType();
            Map<String, String> smap = this.smaps.get(key);
            struct.add((DataType)str, length + 1, key, null);
            if (key.equals("CoreDump")) break;
            if (smap == null) continue;
            StructureDataType substruct = new StructureDataType(key, 0);
            for (String skey : smap.keySet()) {
                length = this.lineLens.get(++i);
                str = new StringDataType();
                substruct.add((DataType)str, length + 1, skey, null);
            }
            struct.add((DataType)substruct, substruct.getDisplayName(), null);
        }
        struct.setCategoryPath(new CategoryPath("/APDMP"));
        return struct;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public String getMachineImageType() {
        return this.map.get("Architecture");
    }

    public MemoryInfo getMemoryInfo(int i) {
        Map<String, String> procMap = this.smaps.get("ProcMaps");
        return new MemoryInfo(procMap.get("ProcMaps[" + i + "]"));
    }

    public int getMemoryRegionCount() {
        return this.smaps.get("ProcMaps").size();
    }

    public int getMemoryRegionOffset() {
        return this.memoryRegionOffset;
    }

    public String getBlob(int i) {
        Map<String, String> cd = this.smaps.get("CoreDump");
        return cd.get("CoreDump[" + i + "]");
    }

    public int getBlobCount() {
        Map<String, String> cd = this.smaps.get("CoreDump");
        return cd.size();
    }
}

