/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.QCallback;
import ghidra.app.decompiler.DecompInterface;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecompilerDisposer {
    private static String THREAD_POOL_NAME = "Decompiler Disposer";
    private static ConcurrentQ<AbstractDisposable, AbstractDisposable> queue;

    private DecompilerDisposer() {
    }

    public static void dispose(Process process, OutputStream ouputStream, InputStream inputStream) {
        RuntimeProcessDisposable disposable = new RuntimeProcessDisposable(process, ouputStream, inputStream);
        queue.add((Object)disposable);
    }

    public static void dispose(DecompInterface decompiler) {
        DecompInterfaceDisposable disposable = new DecompInterfaceDisposable(decompiler);
        queue.add((Object)disposable);
    }

    static {
        ConcurrentQBuilder builder = new ConcurrentQBuilder();
        queue = builder.setThreadPoolName(THREAD_POOL_NAME).build((QCallback)new DisposeCallback());
    }

    private static class RuntimeProcessDisposable
    extends AbstractDisposable {
        private Process process;
        private OutputStream ouputStream;
        private InputStream inputStream;

        RuntimeProcessDisposable(Process process, OutputStream ouputStream, InputStream inputStream) {
            this.process = process;
            this.ouputStream = ouputStream;
            this.inputStream = inputStream;
        }

        @Override
        void dispose() {
            try {
                if (this.process != null) {
                    this.process.destroy();
                    this.process = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.ouputStream != null) {
                    this.ouputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class DecompInterfaceDisposable
    extends AbstractDisposable {
        private DecompInterface decompiler;

        DecompInterfaceDisposable(DecompInterface decompiler) {
            this.decompiler = decompiler;
        }

        @Override
        void dispose() {
            this.decompiler.disposeCallback();
        }
    }

    private static class DisposeCallback
    implements QCallback<AbstractDisposable, AbstractDisposable> {
        private DisposeCallback() {
        }

        public AbstractDisposable process(AbstractDisposable disposable, TaskMonitor monitor) {
            disposable.dispose();
            return disposable;
        }
    }

    private static abstract class AbstractDisposable {
        private AbstractDisposable() {
        }

        abstract void dispose();
    }
}

