#compdef gum
# zsh completion for gum
# generated by gum completion

_gum_choose() {
    _arguments -C \
        "--limit=[Maximum number of options to pick]:maximum number of options to pick:" \
        "--no-limit[Pick unlimited number of options (ignores limit)]" \
        "--ordered[Maintain the order of the selected options]" \
        "--height=[Height of the list]:height of the list:" \
        "--cursor=[Prefix to show on item that corresponds to the cursor position]:prefix to show on item that corresponds to the cursor position:" \
        "--show-help[Show help keybinds]" \
        "--timeout=[Timeout until choose returns selected element]:timeout until choose returns selected element:" \
        "--header=[Header value]:header value:" \
        "--cursor-prefix=[Prefix to show on the cursor item (hidden if limit is 1)]:prefix to show on the cursor item (hidden if limit is 1):" \
        "--selected-prefix=[Prefix to show on selected items (hidden if limit is 1)]:prefix to show on selected items (hidden if limit is 1):" \
        "--unselected-prefix=[Prefix to show on unselected items (hidden if limit is 1)]:prefix to show on unselected items (hidden if limit is 1):" \
        "--selected=[Options that should start as selected (selects all if given *)]:options that should start as selected (selects all if given *):" \
        "--select-if-one[Select the given option if there is only one]" \
        "--input-delimiter=[Option delimiter when reading from STDIN]:option delimiter when reading from stdin:" \
        "--output-delimiter=[Option delimiter when writing to STDOUT]:option delimiter when writing to stdout:" \
        "--label-delimiter=[Allows to set a delimiter, so options can be set as label:value]:allows to set a delimiter, so options can be set as label:value:" \
        "--strip-ansi[Strip ANSI sequences when reading from STDIN]" \
        "--padding=[Padding]:padding:" \
        "--cursor.foreground=[Foreground Color]:foreground color:" \
        "--cursor.background=[Background Color]:background color:" \
        "--header.foreground=[Foreground Color]:foreground color:" \
        "--header.background=[Background Color]:background color:" \
        "--item.foreground=[Foreground Color]:foreground color:" \
        "--item.background=[Background Color]:background color:" \
        "--selected.foreground=[Foreground Color]:foreground color:" \
        "--selected.background=[Background Color]:background color:" \

}

_gum_confirm() {
    _arguments -C \
        "--default[Default confirmation action]" \
        "--show-output[Print prompt and chosen action to output]" \
        "--affirmative=[The title of the affirmative action]:the title of the affirmative action:" \
        "--negative=[The title of the negative action]:the title of the negative action:" \
        "--prompt.foreground=[Foreground Color]:foreground color:" \
        "--prompt.background=[Background Color]:background color:" \
        "--selected.foreground=[Foreground Color]:foreground color:" \
        "--selected.background=[Background Color]:background color:" \
        "--unselected.foreground=[Foreground Color]:foreground color:" \
        "--unselected.background=[Background Color]:background color:" \
        "--show-help[Show help key binds]" \
        "--timeout=[Timeout until confirm returns selected value or default if provided]:timeout until confirm returns selected value or default if provided:" \
        "--padding=[Padding]:padding:"
}

_gum_file() {
    _arguments -C \
        '(-c --cursor=)'{-c,--cursor=}"[The cursor character]:the cursor character:" \
        '(-a --all)'{-a,--all}"[Show hidden and 'dot' files]" \
        '(-p --permissions)'{-p,--permissions}"[Show file permissions]" \
        '(-s --size)'{-s,--size}"[Show file size]" \
        "--file[Allow files selection]" \
        "--directory[Allow directories selection]" \
        "--show-help[Show help key binds]" \
        "--timeout=[Timeout until command aborts without a selection]:timeout until command aborts without a selection:" \
        "--header=[Header value]:header value:" \
        "--height=[Maximum number of files to display]:maximum number of files to display:" \
        "--cursor.foreground=[Foreground Color]:foreground color:" \
        "--cursor.background=[Background Color]:background color:" \
        "--symlink.foreground=[Foreground Color]:foreground color:" \
        "--symlink.background=[Background Color]:background color:" \
        "--directory.foreground=[Foreground Color]:foreground color:" \
        "--directory.background=[Background Color]:background color:" \
        "--file.foreground=[Foreground Color]:foreground color:" \
        "--file.background=[Background Color]:background color:" \
        "--permissions.foreground=[Foreground Color]:foreground color:" \
        "--permissions.background=[Background Color]:background color:" \
        "--selected.foreground=[Foreground Color]:foreground color:" \
        "--selected.background=[Background Color]:background color:" \
        "--file-size.foreground=[Foreground Color]:foreground color:" \
        "--file-size.background=[Background Color]:background color:" \
        "--header.foreground=[Foreground Color]:foreground color:" \
        "--header.background=[Background Color]:background color:" \
        "--padding=[Padding]:padding:"
}

_gum_filter() {
    _arguments -C \
        "--indicator=[Character for selection]:character for selection:" \
        "--indicator.foreground=[Foreground Color]:foreground color:" \
        "--indicator.background=[Background Color]:background color:" \
        "--limit=[Maximum number of options to pick]:maximum number of options to pick:" \
        "--no-limit[Pick unlimited number of options (ignores limit)]" \
        "--select-if-one[Select the given option if there is only one]" \
        "--selected=[Options that should start as selected (selects all if given *)]:options that should start as selected (selects all if given *):" \
        "--show-help[Show help keybinds]" \
        "--strict[Only returns if anything matched. Otherwise return Filter]" \
        "--selected-prefix=[Character to indicate selected items (hidden if limit is 1)]:character to indicate selected items (hidden if limit is 1):" \
        "--selected-indicator.foreground=[Foreground Color]:foreground color:" \
        "--selected-indicator.background=[Background Color]:background color:" \
        "--unselected-prefix=[Character to indicate unselected items (hidden if limit is 1)]:character to indicate unselected items (hidden if limit is 1):" \
        "--unselected-prefix.foreground=[Foreground Color]:foreground color:" \
        "--unselected-prefix.background=[Background Color]:background color:" \
        "--header.foreground=[Foreground Color]:foreground color:" \
        "--header.background=[Background Color]:background color:" \
        "--header=[Header value]:header value:" \
        "--text.foreground=[Foreground Color]:foreground color:" \
        "--text.background=[Background Color]:background color:" \
        "--cursor-text.foreground=[Foreground Color]:foreground color:" \
        "--cursor-text.background=[Background Color]:background color:" \
        "--match.foreground=[Foreground Color]:foreground color:" \
        "--match.background=[Background Color]:background color:" \
        "--placeholder=[Placeholder value]:placeholder value:" \
        "--prompt=[Prompt to display]:prompt to display:" \
        "--prompt.foreground=[Foreground Color]:foreground color:" \
        "--prompt.background=[Background Color]:background color:" \
        "--placeholder.foreground=[Foreground Color]:foreground color:" \
        "--placeholder.background=[Background Color]:background color:" \
        "--width=[Input width]:input width:" \
        "--height=[Input height]:input height:" \
        "--value=[Initial filter value]:initial filter value:" \
        "--reverse[Display from the bottom of the screen]" \
        "--fuzzy[Enable fuzzy matching; otherwise match from start of word]" \
        "--fuzzy-sort[Sort fuzzy results by their scores]" \
        "--timeout=[Timeout until filter command aborts]:timeout until filter command aborts:" \
        "--input-delimiter=[Option delimiter when reading from STDIN]:option delimiter when reading from stdin:" \
        "--output-delimiter=[Option delimiter when writing to STDOUT]:option delimiter when writing to stdout:" \
        "--strip-ansi[Strip ANSI sequences when reading from STDIN]" \
        "--padding=[Padding]:padding:" \

}

_gum_format() {
    _arguments -C \
        "--theme=[Glamour theme to use for markdown formatting]:glamour theme to use for markdown formatting:" \
        '(-l --language=)'{-l,--language=}"[Programming language to parse code]:programming language to parse code:" \
        "--strip-ansi[Strip ANSI sequences when reading from STDIN]" \
        '(-t --type=)'{-t,--type=}"[Format to use (markdown,template,code,emoji)]:format to use (markdown,template,code,emoji):(markdown template code emoji)"
}

_gum_input() {
    _arguments -C \
        "--placeholder=[Placeholder value]:placeholder value:" \
        "--prompt=[Prompt to display]:prompt to display:" \
        "--prompt.foreground=[Foreground Color]:foreground color:" \
        "--prompt.background=[Background Color]:background color:" \
        "--placeholder.foreground=[Foreground Color]:foreground color:" \
        "--placeholder.background=[Background Color]:background color:" \
        "--cursor.foreground=[Foreground Color]:foreground color:" \
        "--cursor.background=[Background Color]:background color:" \
        "--cursor.mode=[Cursor mode]:cursor mode:(blink hide static)" \
        "--value=[Initial value (can also be passed via stdin)]:initial value (can also be passed via stdin):" \
        "--char-limit=[Maximum value length (0 for no limit)]:maximum value length (0 for no limit):" \
        "--width=[Input width (0 for terminal width)]:input width (0 for terminal width):" \
        "--password[Mask input characters]" \
        "--show-help[Show help keybinds]" \
        "--header=[Header value]:header value:" \
        "--header.foreground=[Foreground Color]:foreground color:" \
        "--header.background=[Background Color]:background color:" \
        "--timeout=[Timeout until input aborts]:timeout until input aborts:" \
        "--strip-ansi[Strip ANSI sequences when reading from STDIN]" \
        "--padding=[Padding]:padding:"
}

_gum_join() {
    _arguments -C \
        "--align=[Text alignment]:text alignment:(left center right bottom middle top)" \
        "--horizontal[Join (potentially multi-line) strings horizontally]" \
        "--vertical[Join (potentially multi-line) strings vertically]"
}

_gum_pager() {
    _arguments -C \
        "--foreground=[Foreground Color]:foreground color:" \
        "--background=[Background Color]:background color:" \
        "--show-line-numbers[Show line numbers]" \
        "--line-number.foreground=[Foreground Color]:foreground color:" \
        "--line-number.background=[Background Color]:background color:" \
        "--soft-wrap[Soft wrap lines]" \
        "--match.foreground=[Foreground Color]:foreground color:" \
        "--match.background=[Background Color]:background color:" \
        "--match-highlight.foreground=[Foreground Color]:foreground color:" \
        "--match-highlight.background=[Background Color]:background color:" \
        "--timeout=[Timeout until command exits]:timeout until command exits:" \
        "--help.foreground=[Foreground Color]:foreground color:" \
        "--help.background=[Background Color]:background color:" \

}

_gum_spin() {
    _arguments -C \
        "--show-output[Show or pipe output of command during execution (shows both STDOUT and STDERR)]" \
        "--show-error[Show output of command only if the command fails]" \
        "--show-stdout[Show STDOUT output]" \
        "--show-stderr[Show STDERR errput]" \
        '(-s --spinner=)'{-s,--spinner=}"[Spinner type]:spinner type:(line dot minidot jump pulse points globe moon monkey meter hamburger)" \
        "--spinner.foreground=[Foreground Color]:foreground color:" \
        "--spinner.background=[Background Color]:background color:" \
        "--title=[Text to display to user while spinning]:text to display to user while spinning:" \
        "--title.foreground=[Foreground Color]:foreground color:" \
        "--title.background=[Background Color]:background color:" \
        '(-a --align=)'{-a,--align=}"[Alignment of spinner with regard to the title]:alignment of spinner with regard to the title:(left right)" \
        "--timeout=[Timeout until spin command aborts]:timeout until spin command aborts:" \
        "--padding=[Padding]:padding:"
}

_gum_style() {
    _arguments -C \
        "--trim[Trim whitespaces on every input line]" \
        "--strip-ansi[Strip ANSI sequences when reading from STDIN]" \
        "--foreground=[Foreground Color]:foreground color:" \
        "--background=[Background Color]:background color:" \
        "--border=[Border Style]:border style:(none hidden normal rounded thick double)" \
        "--border-background=[Border Background Color]:border background color:" \
        "--border-foreground=[Border Foreground Color]:border foreground color:" \
        "--align=[Text Alignment]:text alignment:(left center right bottom middle top)" \
        "--height=[Text height]:text height:" \
        "--width=[Text width]:text width:" \
        "--margin=[Text margin]:text margin:" \
        "--padding=[Text padding]:text padding:" \
        "--bold[Bold text]" \
        "--faint[Faint text]" \
        "--italic[Italicize text]" \
        "--strikethrough[Strikethrough text]" \
        "--underline[Underline text]"
}

_gum_table() {
    _arguments -C \
        '(-s --separator=)'{-s,--separator=}"[Row separator]:row separator:" \
        '(-c --columns=)'{-c,--columns=}"[Column names]:column names:" \
        '(-w --widths=)'{-w,--widths=}"[Column widths]:column widths:" \
        "--height=[Table height]:table height:" \
        '(-p --print)'{-p,--print}"[static print]" \
        '(-f --file=)'{-f,--file=}"[file path]:file path:" \
        '(-b --border=)'{-b,--border=}"[border style]:border style:(rounded thick normal hidden double none)" \
        "--show-help[Show help keybinds]" \
        "--hide-count[Hide item count on help keybinds]" \
        "--lazy-quotes[If LazyQuotes is true, a quote may appear in an unquoted field and a non-doubled quote may appear in a quoted field]" \
        "--fields-per-record=[Sets the number of expected fields per record]:sets the number of expected fields per record:" \
        "--border.foreground=[Foreground Color]:foreground color:" \
        "--border.background=[Background Color]:background color:" \
        "--cell.foreground=[Foreground Color]:foreground color:" \
        "--cell.background=[Background Color]:background color:" \
        "--header.foreground=[Foreground Color]:foreground color:" \
        "--header.background=[Background Color]:background color:" \
        "--selected.foreground=[Foreground Color]:foreground color:" \
        "--selected.background=[Background Color]:background color:" \
        '(-r --return-column=)'{-r,--return-column=}"[Which column number should be returned instead of whole row as string. Default=0 returns whole Row]:which column number should be returned instead of whole row as string. default=0 returns whole row:" \
        "--timeout=[Timeout until choose returns selected element]:timeout until choose returns selected element:" \
        "--padding=[Padding]:padding:"
}

_gum_write() {
    _arguments -C \
        "--width=[Text area width (0 for terminal width)]:text area width (0 for terminal width):" \
        "--height=[Text area height]:text area height:" \
        "--header=[Header value]:header value:" \
        "--placeholder=[Placeholder value]:placeholder value:" \
        "--prompt=[Prompt to display]:prompt to display:" \
        "--show-cursor-line[Show cursor line]" \
        "--show-line-numbers[Show line numbers]" \
        "--value=[Initial value (can be passed via stdin)]:initial value (can be passed via stdin):" \
        "--char-limit=[Maximum value length (0 for no limit)]:maximum value length (0 for no limit):" \
        "--max-lines=[Maximum number of lines (0 for no limit)]:maximum number of lines (0 for no limit):" \
        "--show-help[Show help key binds]" \
        "--cursor.mode=[Cursor mode]:cursor mode:(blink hide static)" \
        "--timeout=[Timeout until choose returns selected element]:timeout until choose returns selected element:" \
        "--strip-ansi[Strip ANSI sequences when reading from STDIN]" \
        "--base.foreground=[Foreground Color]:foreground color:" \
        "--base.background=[Background Color]:background color:" \
        "--cursor-line-number.foreground=[Foreground Color]:foreground color:" \
        "--cursor-line-number.background=[Background Color]:background color:" \
        "--cursor-line.foreground=[Foreground Color]:foreground color:" \
        "--cursor-line.background=[Background Color]:background color:" \
        "--cursor.foreground=[Foreground Color]:foreground color:" \
        "--cursor.background=[Background Color]:background color:" \
        "--end-of-buffer.foreground=[Foreground Color]:foreground color:" \
        "--end-of-buffer.background=[Background Color]:background color:" \
        "--line-number.foreground=[Foreground Color]:foreground color:" \
        "--line-number.background=[Background Color]:background color:" \
        "--header.foreground=[Foreground Color]:foreground color:" \
        "--header.background=[Background Color]:background color:" \
        "--placeholder.foreground=[Foreground Color]:foreground color:" \
        "--placeholder.background=[Background Color]:background color:" \
        "--prompt.foreground=[Foreground Color]:foreground color:" \
        "--prompt.background=[Background Color]:background color:" \
        "--padding=[Padding]:padding:"
}

_gum_log() {
    _arguments -C \
        '(-o --file=)'{-o,--file=}"[Log to file]:log to file:" \
        '(-f --format)'{-f,--format}"[Format message using printf]" \
        "--formatter=[The log formatter to use]:the log formatter to use:(json logfmt text)" \
        '(-l --level=)'{-l,--level=}"[The log level to use]:the log level to use:(none debug info warn error fatal)" \
        "--prefix=[Prefix to print before the message]:prefix to print before the message:" \
        '(-s --structured)'{-s,--structured}"[Use structured logging]" \
        '(-t --time=)'{-t,--time=}"[The time format to use (kitchen, layout, ansic, rfc822, etc...)]:the time format to use (kitchen, layout, ansic, rfc822, etc...):" \
        "--min-level=[Minimal level to show]:minimal level to show:" \
        "--level.foreground=[Foreground Color]:foreground color:" \
        "--level.background=[Background Color]:background color:" \
        "--time.foreground=[Foreground Color]:foreground color:" \
        "--time.background=[Background Color]:background color:" \
        "--prefix.foreground=[Foreground Color]:foreground color:" \
        "--prefix.background=[Background Color]:background color:" \
        "--message.foreground=[Foreground Color]:foreground color:" \
        "--message.background=[Background Color]:background color:" \
        "--key.foreground=[Foreground Color]:foreground color:" \
        "--key.background=[Background Color]:background color:" \
        "--value.foreground=[Foreground Color]:foreground color:" \
        "--value.background=[Background Color]:background color:" \
        "--separator.foreground=[Foreground Color]:foreground color:" \
        "--separator.background=[Background Color]:background color:" \

}

_gum_version-check() {
    _arguments -C \

}

_gum() {
    local line state
    _arguments -C \
        '(-h --help)'{-h,--help}"[Show context-sensitive help.]" \
        '(-v --version)'{-v,--version}"[Print the version number]" \
        "1: :->cmds" \
        "*::arg:->args"
    case "$state" in
        cmds)
            _values "gum command" \
                "choose[Choose an option from a list of choices]" \
                "confirm[Ask a user to confirm an action]" \
                "file[Pick a file from a folder]" \
                "filter[Filter items from a list]" \
                "format[Format a string using a template]" \
                "input[Prompt for some input]" \
                "join[Join text vertically or horizontally]" \
                "pager[Scroll through a file]" \
                "spin[Display spinner while running a command]" \
                "style[Apply coloring, borders, spacing to text]" \
                "table[Render a table of data]" \
                "write[Prompt for long-form text]" \
                "log[Log messages to output]" \
                "version-check[Semver check current gum version]"
            ;;
        args)
            case "$line[1]" in
                choose)
                    _gum_choose
                    ;;
                confirm)
                    _gum_confirm
                    ;;
                file)
                    _gum_file
                    ;;
                filter)
                    _gum_filter
                    ;;
                format)
                    _gum_format
                    ;;
                input)
                    _gum_input
                    ;;
                join)
                    _gum_join
                    ;;
                pager)
                    _gum_pager
                    ;;
                spin)
                    _gum_spin
                    ;;
                style)
                    _gum_style
                    ;;
                table)
                    _gum_table
                    ;;
                write)
                    _gum_write
                    ;;
                log)
                    _gum_log
                    ;;
                version-check)
                    _gum_version-check
                    ;;
            esac
            ;;
    esac

}

