/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_brx extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "\u090f.\u0907.\u0926\u093f" },
            { "ALL", "\u0905\u0932" },
            { "AMD", "\u090f.\u090f\u092e.\u0926\u093f" },
            { "ANG", "\u090f.\u090f\u0928.\u091c\u093f" },
            { "AOA", "\u090f.\u0905.\u090f" },
            { "ARS", "\u090f.\u0906\u0930.\u090f\u0938" },
            { "AWG", "\u090f.\u0926\u092c\u094d\u0932\u094d\u092f\u0941.\u091c\u093f" },
            { "AZN", "\u090f.\u091c\u0947\u0924.\u090f\u0928" },
            { "BAM", "\u092c\u093f.\u090f.\u090f\u092e" },
            { "BBD", "\u092c\u093f.\u092c\u093f.\u0926\u093f" },
            { "BGN", "\u092c\u093f.\u091c\u093f.\u090f\u0928" },
            { "BHD", "\u092c\u093f.\u0910\u0924\u094d\u0938.\u0926\u093f" },
            { "BIF", "\u092c\u093f.\u0906\u0907.\u090f\u092b" },
            { "BMD", "\u092c\u093f.\u090f\u092e.\u0921\u093f" },
            { "BOB", "\u092c\u093f.\u0905.\u092c\u093f" },
            { "BSD", "\u092c\u093f.\u090f\u0938.\u0926\u093f" },
            { "BWP", "\u092c\u093f.\u0926\u092c\u094d\u0932\u094d\u092f\u0941.\u092a\u093f" },
            { "BYN", "\u092c\u093f.\u0935\u093e\u0908.\u090f\u0928" },
            { "BZD", "\u092c\u093f.\u091c\u0947\u0926.\u0921\u093f" },
            { "CAD", "\u0938\u093f.\u090f $" },
            { "CDF", "\u0938\u093f.\u0926\u093f.\u090f\u092b" },
            { "CHF", "\u0938\u093f.\u0910\u0924\u094d\u0938.\u090f\u092b" },
            { "CLP", "\u0938\u093f.\u090f\u0932.\u092a\u093f" },
            { "CNH", "\u0938\u093f.\u090f\u0928.\u0910\u0924\u094d\u0938" },
            { "CNY", "\u0938\u093f\u090f\u0928\u00a5" },
            { "COP", "\u0938\u093f.\u0905.\u092a\u093f" },
            { "CRC", "\u0938\u093f.\u0906\u0930.\u0938\u093f" },
            { "CUC", "\u0938\u093f.\u0907\u0909.\u0938\u093f" },
            { "CUP", "\u0938\u093f.\u0907\u0909.\u092a\u093f" },
            { "CVE", "\u0938\u093f.\u092d\u093f.\u0907" },
            { "CZK", "\u0938\u093f.\u091c\u0947\u0926.\u0915\u0947" },
            { "DJF", "\u0926\u093f.\u091c\u0947.\u090f\u092b" },
            { "DKK", "\u0926\u093f.\u0915\u0947.\u0915\u0947" },
            { "DOP", "\u0921\u093f.\u0905.\u092a\u093f" },
            { "DZD", "\u0926\u093f.\u091c\u0947\u0924.\u0926\u093f" },
            { "EGP", "\u0908.\u091c\u093f.\u092a\u093f" },
            { "ERN", "\u0907.\u0906\u0930.\u090f\u0928" },
            { "ETB", "\u0907.\u0924\u093f.\u092c\u093f" },
            { "FKP", "\u090f\u092b.\u0915\u0947.\u092a\u093f" },
            { "GEL", "\u091c\u093f.\u0907.\u090f\u0932" },
            { "GHS", "\u091c\u093f.\u0910\u0924\u094d\u0938.\u090f\u0938" },
            { "GIP", "\u091c\u093f.\u0906\u0907.\u092a\u093f" },
            { "GMD", "\u091c\u093f.\u090f\u092e.\u0926\u093f" },
            { "GNF", "\u091c\u093f.\u090f\u0928.\u090f\u092b" },
            { "GTQ", "\u091c\u093f.\u0924\u093f.\u0915\u093f\u0909" },
            { "GYD", "\u091c\u093f.\u0935\u093e\u0908.\u0926\u093f" },
            { "HKD", "\u0910\u0924\u094d\u0938.\u0915\u0947$" },
            { "HNL", "\u0910\u0924\u094d\u0938.\u090f\u0928.\u090f\u0932" },
            { "HRK", "\u0910\u0924\u094d\u0938.\u0906\u0930.\u0915\u0947" },
            { "HTG", "\u0910\u0924\u094d\u0938.\u0924\u093f.\u091c\u093f" },
            { "HUF", "\u0910\u0924\u094d\u0938.\u0907\u0909.\u090f\u092b" },
            { "IQD", "\u0906\u0907.\u0915\u093f\u0909.\u0926\u093f" },
            { "ISK", "\u0906\u0908.\u090f\u0938.\u0915\u0947" },
            { "JMD", "\u091c\u0947.\u090f\u092e.\u0926\u093f" },
            { "JOD", "\u091c\u0947.\u0905.\u0926\u093f" },
            { "KES", "\u0915\u0947.\u0907.\u090f\u0938" },
            { "KGS", "\u0915\u0947.\u091c\u093f.\u090f\u0938" },
            { "KMF", "\u0915\u0947.\u090f\u092e.\u090f\u092b" },
            { "KPW", "\u0915\u0947.\u092a\u093f.\u0926\u092c\u094d\u0932\u094d\u092f\u0941" },
            { "KWD", "\u0915\u0947.\u0926\u092c\u094d\u0932\u094d\u092f\u0941.\u0926\u093f" },
            { "KYD", "\u0915\u0947.\u0935\u093e\u0908.\u0926\u093f" },
            { "KZT", "\u0915\u0947.\u091c\u0947\u0924.\u0924\u093f" },
            { "LBP", "\u090f\u0932.\u092c\u093f.\u092a\u093f" },
            { "LRD", "\u090f\u0932.\u0906\u0930.\u0926\u093f" },
            { "LSL", "\u090f\u0932.\u090f\u0938.\u090f\u0932" },
            { "LYD", "\u090f\u0932.\u0935\u093e\u0908.\u0926\u093f" },
            { "MAD", "\u090f\u092e.\u090f.\u0926\u093f" },
            { "MDL", "\u090f\u092e.\u0921\u093f.\u090f\u0932" },
            { "MGA", "\u090f\u092e.\u091c\u093f.\u090f" },
            { "MKD", "\u090f\u092e.\u0915\u0947.\u0926\u093f" },
            { "MNT", "\u090f\u092e.\u090f\u0928.\u0924\u093f" },
            { "MOP", "\u090f\u092e.\u0905.\u092a\u093f" },
            { "MRU", "\u090f\u092e.\u0906\u0930.\u0907\u0909" },
            { "MUR", "\u090f\u092e.\u0907\u0909.\u0906\u0930" },
            { "MWK", "\u090f\u092e.\u0926\u092c\u094d\u0932\u094d\u092f\u0941.\u0915\u0947" },
            { "MXN", "\u090f\u092e.\u090f\u0915\u094d\u0938 $" },
            { "MZN", "\u090f\u092e.\u091c\u0947\u0924.\u090f\u0928" },
            { "NAD", "\u090f\u0928.\u090f.\u0926\u093f" },
            { "NGN", "\u090f\u0928.\u091c\u093f.\u090f\u0928" },
            { "NIO", "\u090f\u0928.\u0906\u0908.\u0905" },
            { "NOK", "\u090f\u0928.\u0905.\u0915\u0947" },
            { "OMR", "\u0905.\u090f\u092e.\u0906\u0930" },
            { "PAB", "\u092a\u093f.\u090f.\u092c\u093f" },
            { "PEN", "\u092a\u093f.\u0907.\u090f\u0928" },
            { "PLN", "\u092a\u093f.\u090f\u0932.\u090f\u0928" },
            { "PYG", "\u092a\u093f.\u0906\u0908.\u091c\u093f" },
            { "QAR", "\u0915\u093f\u0909.\u090f.\u0906\u0930" },
            { "RON", "\u0906\u0930.\u0905.\u090f\u0928" },
            { "RSD", "\u0906\u0930.\u090f\u0938.\u0926\u093f" },
            { "RUB", "\u0930\u0942\u092c" },
            { "SAR", "\u090f\u0938.\u090f.\u0906\u0930" },
            { "SCR", "\u090f\u0938.\u0938\u093f.\u0906\u0930" },
            { "SDG", "\u090f\u0938.\u0926\u093f.\u091c\u093f" },
            { "SEK", "\u090f\u0938.\u0907.\u0915\u0947" },
            { "SHP", "\u090f\u0938.\u0910\u0924\u094d\u0938.\u092a\u093f" },
            { "SLE", "\u090f\u0938.\u090f\u0932.\u0907" },
            { "SLL", "\u090f\u0938.\u090f\u0932.\u090f\u0932" },
            { "SOS", "\u090f\u0938.\u0905.\u090f\u0938" },
            { "SRD", "\u090f\u0938.\u0906\u0930.\u0921\u093f" },
            { "SSP", "\u090f\u0938.\u090f\u0938.\u092a\u093f" },
            { "STN", "\u090f\u0938.\u0924\u093f.\u090f\u0928" },
            { "SYP", "\u090f\u0938.\u0935\u093e\u0908.\u092a\u093f" },
            { "SZL", "\u090f\u0938.\u091c\u0947\u0924.\u090f\u0932" },
            { "TJS", "\u0924\u093f.\u091c\u0947.\u090f\u0938" },
            { "TMT", "\u0924\u093f.\u090f\u092e.\u0924\u093f" },
            { "TND", "\u0924\u093f.\u090f\u0928.\u0926\u093f" },
            { "TRY", "\u0924\u093f.\u0906\u0930.\u0935\u093e\u0908" },
            { "TTD", "\u0924\u093f.\u0924\u093f.\u0921\u093f" },
            { "TWD", "\u090f\u0928.\u0924\u093f$" },
            { "TZS", "\u0924\u093f.\u091c\u0947\u0924.\u090f\u0938" },
            { "UAH", "\u0907\u0909.\u090f.\u0910\u0924\u094d\u0938" },
            { "UGX", "\u0907\u0909.\u091c\u093f.\u090f\u0915\u094d\u0938" },
            { "USD", "$" },
            { "UYU", "\u0907\u0909.\u0935\u093e\u0908.\u0907\u0909" },
            { "UZS", "\u0907\u0909.\u091c\u0947\u0924.\u090f\u0938" },
            { "VES", "\u092d\u093f.\u0907.\u090f\u0938" },
            { "XCD", "\u0907.\u0938\u093f $" },
            { "XOF", "\u090f\u092b \u0938\u093f.\u090f\u092b.\u090f" },
            { "YER", "\u0935\u093e\u0908.\u0907.\u0906\u0930" },
            { "ZAR", "\u091c\u0947\u0924.\u090f.\u0906\u0930" },
            { "adp", "\u0910\u0928\u094d\u0921\u094b\u0930\u093e \u0915\u093e \u092a\u0947\u0938\u0947\u0924\u093e" },
            { "aed", "\u0907\u0909.\u090f.\u0907 \u0926\u093f\u0930\u094d\u0939\u093e\u092e" },
            { "afa", "\u0905\u092b\u093c\u0917\u093c\u093e\u0928\u0940 1927\u20132002" },
            { "afn", "\u0905\u092b\u093c\u0917\u093c\u093e\u0928\u0940" },
            { "all", "\u0906\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0928\u093f \u0932\u0947\u0915" },
            { "amd", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0928\u093f \u0926\u094d\u0930\u093e\u092e" },
            { "ang", "\u0928\u0947\u0926\u093e\u0930\u0932\u0947\u0923\u094d\u0921\u0928\u093f \u090f\u0928\u094d\u091f\u093f\u0932\u093f\u092f\u093e\u0928 \u0917\u093f\u0932\u094d\u0921\u093e\u0930" },
            { "aoa", "\u0906\u0902\u0917\u0932\u093e\u0928\u093f \u0915\u094d\u0935\u093e\u0928\u094d\u091c\u093e" },
            { "aok", "\u090f\u0902\u0917\u094b\u0932\u093e \u0915\u094d\u0935\u093e\u0928\u091c\u093c\u093e (1977\u20131990)" },
            { "aon", "\u090f\u0902\u0917\u094b\u0932\u093e \u0928\u092f\u093e \u0915\u094d\u0935\u093e\u0928\u091c\u093c\u093e (1990\u201320000)" },
            { "aor", "\u090f\u0902\u0917\u094b\u0932\u093e \u0915\u094d\u0935\u093e\u0928\u091c\u093c\u093e \u0938\u0941\u0927\u093e\u0930\u0940\u0924 (1995\u20131999)" },
            { "ara", "\u0905\u0930\u094d\u091c\u0947\u0923\u094d\u091f\u0940\u0928\u0940 \u0913\u0938\u094d\u091f\u094d\u0930\u093e\u0932" },
            { "arp", "\u0905\u0930\u094d\u091c\u0947\u0923\u094d\u091f\u0940\u0928\u0940 \u092a\u0947\u0938\u094b (1983\u20131985)" },
            { "ars", "\u0906\u0930\u094d\u091c\u0947\u0928\u094d\u091f\u093f\u0928\u093e\u0928\u093f \u092a\u0947\u0938\u2019" },
            { "ats", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u0928 \u0936\u0940\u0932\u0940\u0902\u0917" },
            { "aud", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u0921\u0949\u0932\u0930" },
            { "awg", "\u0906\u0930\u0942\u092c\u093e\u0928 \u092b\u094d\u0932\u2019\u0930\u093f\u0928" },
            { "azm", "\u0906\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928\u0940 \u092e\u0928\u093e\u0924 (1993\u20132006)" },
            { "azn", "\u0906\u091c\u0947\u0930\u092c\u093e\u0908\u091c\u093e\u0928\u0928\u093f \u092e\u0928\u093e\u0924" },
            { "bad", "\u092c\u094b\u0938\u0928\u093f\u092f\u093e \u0939\u0947\u0930\u094d\u091c\u093c\u0947\u0917\u094b\u0935\u093f\u0928\u093e \u0915\u093e \u0926\u0940\u0928\u093e\u0930" },
            { "bam", "\u092c\u0938\u0928\u093f\u092f\u093e-\u0939\u093e\u0930\u094d\u091c\u0947\u0917\u092d\u093f\u0928\u093e\u0928\u093f \u0938\u094b\u0932\u093e\u092f\u0939\u093e\u0925\u093e\u0935 \u092e\u093e\u0930\u094d\u0915" },
            { "bbd", "\u092c\u093e\u0930\u092c\u093e\u0926\u2019\u0938\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "bdt", "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936 \u091f\u0915\u093e" },
            { "bec", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u0928 \u092b\u094d\u0930\u093e\u0901 \u0915\u0928\u0935\u0930\u094d\u091f\u0940\u092c\u0932" },
            { "bef", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u0928 \u092b\u094d\u0930\u093e\u0901" },
            { "bel", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u0928 \u092b\u094d\u0930\u093e\u0901 \u092b\u093f\u0928\u093e\u0928\u0938\u0940\u092f\u0932 (\u0935\u093f\u0924\u094d\u0924\u0940\u092f)" },
            { "bgl", "\u092c\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u093e\u0908 \u0939\u093e\u0930\u094d\u0921 \u0932\u0947\u0935" },
            { "bgn", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e\u0928\u093f \u0932\u0947\u092d" },
            { "bhd", "\u092c\u093e\u0939\u0930\u0948\u0928\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "bif", "\u092c\u0941\u0930\u0942\u0923\u094d\u0921\u0940\u0928\u093f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "bmd", "\u092c\u093e\u0930\u092e\u0941\u0921\u093e\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "bnd", "\u092c\u094d\u0930\u0941\u0928\u0908 \u0921\u0949\u0932\u0930" },
            { "bob", "\u092c\u0932\u093f\u092d\u093f\u092f\u093e\u0928\u093f \u092c\u0932\u093f\u092d\u093f\u092f\u093e\u0928\u2019" },
            { "bop", "\u092c\u094b\u0932\u093f\u0935\u093f\u092f\u093e\u0908 \u092a\u0947\u0938\u094b" },
            { "bov", "\u092c\u094b\u0932\u093f\u0935\u093f\u092f\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "brb", "\u092c\u094d\u0930\u091c\u093c\u0940\u0932\u0940 \u0928\u092f\u093e \u0915\u094d\u0930\u0941\u091c\u093c\u0947\u0930\u094b (1967\u20131986)" },
            { "brc", "\u092c\u094d\u0930\u091c\u093c\u0940\u0932\u0940 \u0915\u094d\u0930\u0941\u091c\u093c\u093e\u0921\u094b" },
            { "bre", "\u092c\u094d\u0930\u091c\u093c\u0940\u0932\u0940 \u0915\u094d\u0930\u0941\u091c\u093c\u0947\u0930\u094b (190\u20131993)" },
            { "brl", "\u092c\u094d\u0930\u093e\u091c\u093f\u0932\u0928\u093f \u0930\u0940\u092f\u093e\u0932" },
            { "brn", "\u092c\u094d\u0930\u091c\u093c\u0940\u0932\u0940 \u0928\u092f\u093e \u0915\u094d\u0930\u0941\u091c\u093c\u093e\u0921\u094b" },
            { "brr", "\u092c\u094d\u0930\u091c\u093c\u0940\u0932\u0940 \u0915\u094d\u0930\u0941\u091c\u093c\u0947\u0930\u094b" },
            { "bsd", "\u092c\u093e\u0939\u093e\u092e\u093e\u0938\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "btn", "\u092d\u0941\u0924\u093e\u0928 \u0915\u093e \u0928\u0917\u0941\u0932\u0924\u094d\u0930\u0941\u092e" },
            { "buk", "\u092c\u0930\u094d\u092e\u0940 (\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930\u0940) \u0915\u094d\u092f\u093e\u091f" },
            { "bwp", "\u092c\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e\u0928\u093f \u092a\u0941\u0932\u093e" },
            { "byb", "\u092c\u0947\u0932\u093e\u0930\u0941\u0938\u0940 \u0928\u092f\u093e \u0930\u0942\u092c\u0932 (194\u20131999)" },
            { "byn", "\u092c\u0947\u0932\u093e\u0930\u0941\u0938\u0928\u093f \u0930\u0942\u092c\u0932" },
            { "byr", "\u092c\u0947\u0932\u093e\u0930\u0941\u0938\u0940 \u0930\u0942\u092c\u0932 (2000\u20132016)" },
            { "bzd", "\u092c\u0947\u0932\u0940\u091c \u0921\u0932\u093e\u0930" },
            { "cad", "\u0915\u093e\u0928\u093e\u0921\u093e\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "cdf", "\u0915\u0902\u0917\u2019\u0928\u093f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "che", "\u0906\u0908\u0930\u0932\u0948\u0923\u094d\u0921 \u0915\u093e \u092f\u0941\u0930\u094b" },
            { "chf", "\u0938\u0941\u0908\u0938 \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "chw", "\u0906\u0908\u0930\u0932\u0948\u0923\u094d\u0921 \u0915\u093e \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "clf", "\u091a\u0940\u0932\u0940 \u0915\u093e \u090a\u0928\u0940\u0926\u093e\u0926\u0947\u0938 \u0926 \u092b\u094b\u092e\u0947\u0902\u091f\u094b" },
            { "clp", "\u091a\u093f\u0932\u0940\u0928\u093f \u092a\u0947\u0938\u2019" },
            { "cnh", "\u091a\u093e\u0907\u0928\u0940\u091c \u092f\u0941\u0935\u093e\u0928 ( \u0939\u093e\u092c\u094d\u0930\u093e\u0902\u0928\u093f \u0917\u094b\u091c\u093e\u0928)" },
            { "cny", "\u091a\u093e\u0907\u0928\u0940\u091c \u092f\u0941\u0935\u093e\u0928" },
            { "cop", "\u0915\u0932\u2019\u092e\u094d\u092c\u092f\u093e\u0928\u093f \u092a\u0947\u0938\u2019" },
            { "cou", "\u092f\u0941\u0928\u0940\u0926\u093e\u0926 \u0926 \u0935\u093e\u0932\u094b\u0930 \u0930\u0947\u0906\u0932" },
            { "crc", "\u0915\u2019\u0938\u094d\u091f\u093e \u0930\u093f\u0915\u093e\u0928\u093f \u0915\u0932\u2019\u0928" },
            { "csd", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e \u0915\u093e \u0921\u0940\u0928\u093e\u0930" },
            { "csk", "\u091a\u0948\u0915\u094b\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u093f\u092f \u0939\u093e\u0930\u094d\u0921 \u0915\u094b\u0930\u0941\u0928\u093e" },
            { "cuc", "\u0915\u093f\u0909\u092c\u093e\u0928\u093f \u0938\u094b\u0932\u093e\u092f\u0939\u093e\u0925\u093e\u0935 \u092a\u0947\u0938\u2019" },
            { "cup", "\u0915\u093f\u0909\u092c\u093e\u0928\u093f \u092a\u0947\u0938\u2019" },
            { "cve", "\u0915\u0947\u092a \u092d\u0947\u0930\u094d\u0926\u0947\u0928\u093f \u090f\u0938\u094d\u0915\u0941\u0926\u2019" },
            { "cyp", "\u0938\u093e\u0908\u092a\u094d\u0930\u0938 \u0915\u093e \u092a\u093e\u090a\u0902\u0921" },
            { "czk", "\u091a\u0947\u0916\u0928\u093f \u0915\u0930\u0941\u0928\u093e" },
            { "ddm", "\u0908\u0938\u094d\u091f \u091c\u0930\u094d\u092e\u0928 \u0913\u0938\u094d\u091f\u092e\u093e\u0930\u094d\u0915" },
            { "dem", "\u0921\u0949\u0908\u091a \u092e\u093e\u0930\u094d\u0915" },
            { "djf", "\u091c\u093f\u092c\u094c\u0924\u093f\u0928\u093f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "dkk", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915\u0928\u093f \u0915\u094d\u0930\u2019\u0928" },
            { "dop", "\u0921\u092e\u093f\u0928\u093f\u0915\u093e\u0928\u093f \u092a\u0947\u0938\u2019" },
            { "dzd", "\u0906\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "ecs", "\u090f\u0915\u094d\u0935\u093e\u0926\u094b\u0930 \u0938\u0941\u0915\u094d\u0930\u0947" },
            { "ecv", "\u090f\u0915\u094d\u0935\u093e\u0926\u094b\u0930 \u092f\u0941\u0928\u0940\u0926\u093e\u0926 \u0926\u0947 \u0935\u093e\u0932\u094b\u0930 \u0915\u0949\u0928\u0938\u094d\u0924\u093e\u0902\u0924\u0947" },
            { "eek", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e\u0908 \u0915\u094d\u0930\u0942\u0928" },
            { "egp", "\u0908\u091c\u093f\u092a\u094d\u0924\u0928\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "ern", "\u090f\u0930\u093f\u0924\u094d\u0930\u0940\u092f\u093e\u0928\u093f \u0928\u093e\u0915\u092b\u093e" },
            { "esa", "\u0939\u0940\u0938\u094d\u092a\u093e\u0928\u0940 \u092a\u0947\u0938\u0947\u0924\u093e (\u090f \u0905\u0915\u093e\u090a\u0901\u091f)" },
            { "esb", "\u0939\u0940\u0938\u094d\u092a\u093e\u0928\u0940 \u092a\u0947\u0938\u0947\u0924\u093e (\u0915\u0928\u0935\u0930\u094d\u091f\u0940\u092c\u0932 \u0905\u0915\u093e\u090a\u0901\u091f)" },
            { "esp", "\u0939\u0940\u0938\u094d\u092a\u093e\u0928\u0940 \u092a\u0947\u0938\u0947\u0924\u093e" },
            { "etb", "\u0907\u0925\u093f\u092f\u2019\u092a\u093f\u092f\u093e\u0928\u093f \u092c\u0940\u0930\u094d\u0930" },
            { "eur", "\u0907\u0909\u0930\u2019" },
            { "fim", "\u092b\u0940\u0928\u0940\u0936 \u092e\u093e\u0930\u094d\u0915\u094d\u0915\u093e" },
            { "fjd", "\u092b\u093c\u093f\u091c\u0940 \u0915\u093e \u0921\u0949\u0932\u0930" },
            { "fkp", "\u092b\u2019\u0915\u0932\u0947\u0923\u094d\u0921 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930\u0928\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "frf", "\u092b\u094d\u0930\u093e\u0901\u0938\u0940\u0938\u0940 \u092b\u094d\u0930\u093e\u0901" },
            { "gbp", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "gek", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0915\u093e \u0915\u0941\u092a\u094b\u0928 \u0932\u093e\u0930\u0940\u0924" },
            { "gel", "\u091c\u0930\u094d\u091c\u093f\u092f\u093e\u0928\u093f \u0932\u093e\u0930\u0940" },
            { "ghc", "\u0918\u093e\u0928\u093e \u091a\u0947\u0926\u0940 (1979\u20132007)" },
            { "ghs", "\u0918\u093e\u0928\u093e\u0928\u093f \u0938\u0947\u0926\u093f" },
            { "gip", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u093e\u0930\u0928\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "gmd", "\u0917\u093e\u092e\u094d\u092c\u093f\u092f\u093e\u0928\u093f \u0926\u093e\u0932\u093e\u0938\u093f" },
            { "gnf", "\u0917\u093f\u0928\u0940\u092f\u093e\u0928\u093f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "gns", "\u0917\u0940\u0928\u0940 \u0938\u0940\u0932\u0940" },
            { "gqe", "\u0910\u0915\u094d\u0935\u093e\u091f\u0930\u0940 \u0917\u0940\u0928\u0940 \u090f\u0915\u094d\u0935\u0947\u0932\u0947 \u0917\u0940\u0928\u0940\u0906\u0928\u093e" },
            { "grd", "\u092f\u0941\u0928\u093e\u0928\u0940 \u0926\u094d\u0930\u093e\u0916\u092e\u093e" },
            { "gtq", "\u0917\u0941\u0906\u0924\u0947\u092e\u093e\u0932\u093e\u0928\u093f \u0915\u094d\u0935\u0947\u0924\u094d\u091c\u093e\u0932" },
            { "gwe", "\u092a\u0941\u0930\u0924\u0941\u0917\u0940 \u0917\u0940\u0928\u0940 \u0915\u093e \u090f\u0938\u094d\u0915\u0941\u090f\u0926\u094b" },
            { "gwp", "\u0917\u0940\u0928\u0940 \u092c\u093f\u0938\u094d\u0938\u093e\u090a \u0915\u093e \u092a\u0947\u0938\u094b" },
            { "gyd", "\u0917\u0941\u092f\u093e\u0928\u093e\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "hkd", "\u0939\u0902\u0915\u0902 \u0921\u0932\u093e\u0930" },
            { "hnl", "\u0939\u0928\u094d\u0926\u0941\u0930\u093e\u0938\u0928\u093f \u0932\u0947\u092e\u094d\u092a\u093f\u0930\u093e" },
            { "hrd", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e\u0908 \u0926\u0940\u0928\u093e\u0930" },
            { "hrk", "\u0915\u094d\u0930\u0935\u0947\u0936\u093f\u092f\u093e\u0928\u093f \u0915\u0941\u0928\u093e" },
            { "htg", "\u0939\u093e\u0908\u0924\u0940\u0928\u093f \u0917\u0942\u0930\u094d\u0926" },
            { "huf", "\u0939\u093e\u0902\u0917\u093e\u0930\u0940\u0928\u093f \u092b\u0930\u093f\u0928\u094d\u0924" },
            { "idr", "\u0907\u0923\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u0930\u0941\u092a\u093f\u092f\u093e" },
            { "iep", "\u0906\u0908\u0930\u0940\u0936 \u092a\u094c\u0902\u0921" },
            { "ilp", "\u0907\u0938\u094d\u0930\u093e\u0907\u0932\u0940 \u092a\u094c\u0902\u0921" },
            { "ils", "\u0907\u091c\u094d\u0930\u093e\u0908\u0932\u0928\u093f \u0917\u094b\u0926\u093e\u0928 \u0936\u0947\u0915\u0947\u0932" },
            { "inr", "\u092d\u093e\u0930\u0924\u0928\u093f \u0930\u0941\u092a\u0940" },
            { "iqd", "\u0908\u0930\u093e\u0915\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "irr", "\u0908\u0930\u093e\u0928\u0940 \u0930\u0940\u092f\u093e\u0932" },
            { "isk", "\u0906\u0908\u0938\u0932\u0947\u0923\u094d\u0921\u0928\u093f \u0915\u094d\u0930\u2019\u0928\u093e" },
            { "itl", "\u0907\u0924\u0932\u0940 \u0915\u093e \u0932\u0940\u0930\u093e" },
            { "jmd", "\u091c\u093e\u092e\u093e\u0908\u0915\u093e\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "jod", "\u091c\u0930\u094d\u0921\u093e\u0928\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "jpy", "\u091c\u093e\u092a\u093e\u0928\u0940\u091c \u092f\u0947\u0928" },
            { "kes", "\u0915\u0947\u0928\u093f\u092f\u093e\u0928\u093f \u0936\u093f\u0932\u093f\u0902" },
            { "kgs", "\u0915\u0940\u0930\u094d\u0917\u0940\u0938\u094d\u0924\u093e\u0928\u0928\u093f \u0938\u2019\u092e" },
            { "khr", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u093e \u0915\u093e \u0930\u093f\u090f\u0932" },
            { "kmf", "\u0915\u092e\u2019\u0930\u2019\u0928\u093f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "kpw", "\u0938\u093e\u0939\u093e \u0915\u0930\u093f\u092f\u093e\u0928\u093f \u0935\u2019\u0928" },
            { "krw", "\u0916\u094b\u0932\u093e \u0915\u0930\u093f\u092f\u093e\u0928\u093f \u0935\u2019\u0928" },
            { "kwd", "\u0915\u0941\u0935\u0948\u0924\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "kyd", "\u0915\u0948\u092e\u0947\u0928 \u0926\u094d\u0935\u0940\u092a\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "kzt", "\u0915\u093e\u091c\u093e\u0916\u0938\u094d\u0924\u093e\u0928\u0928\u093f \u0924\u0947\u0902\u0917\u0947" },
            { "lak", "\u0932\u093e\u0913\u0938 \u0915\u093e \u0915\u0940\u092a" },
            { "lbp", "\u0932\u0947\u092c\u093e\u0928\u2019\u0928\u0928\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "lkr", "\u0936\u094d\u0930\u0940 \u0932\u0902\u0915\u093e \u0930\u0942\u092a\u0940" },
            { "lrd", "\u0932\u0940\u092c\u0947\u0930\u093f\u092f\u093e\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "lsl", "\u0932\u0947\u0938\u2019\u0925\u2019\u0928\u093f \u0932\u091f\u093f" },
            { "ltl", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e\u0908 \u0932\u093f\u0924\u093e" },
            { "ltt", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e\u0908 \u091f\u093e\u0932\u094b\u0928\u093e\u0938" },
            { "luc", "\u0932\u0941\u0915\u094d\u091c\u093c\u092e\u092c\u0941\u0930\u094d\u0917\u0940 \u0915\u0928\u0935\u0930\u094d\u091f\u0940\u092c\u0932 \u092b\u094d\u0930\u093e\u0901" },
            { "luf", "\u0932\u0941\u0915\u094d\u091c\u093c\u092e\u092c\u0941\u0930\u094d\u0917\u0940 \u092b\u094d\u0930\u093e\u0901" },
            { "lul", "\u0932\u0941\u0915\u094d\u091c\u093c\u092e\u092c\u0941\u0930\u094d\u0917\u0940 \u0935\u0940\u0924\u094d\u0924\u0940 \u092b\u094d\u0930\u093e\u0901" },
            { "lvl", "\u0932\u093e\u091f\u0935\u093f\u092f\u093e\u0908 \u0932\u093e\u091f\u094d\u0938" },
            { "lvr", "\u0932\u093e\u091f\u0935\u093f\u092f\u093e\u0908 \u0930\u0942\u092c\u0932" },
            { "lyd", "\u0932\u093f\u092c\u093f\u092f\u093e\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "mad", "\u092e\u0930\u0915\u094d\u0915\u2019\u0928\u093f \u0926\u093f\u0930\u094d\u0939\u093e\u092e" },
            { "maf", "\u092e\u094b\u0930\u0915\u094d\u0915\u093f\u092f \u092b\u094d\u0930\u093e\u0901" },
            { "mdl", "\u092e\u0932\u094d\u0921\u2019\u092d\u093e\u0928\u093f \u0932\u093f\u0909" },
            { "mga", "\u092e\u093e\u0932\u093e\u0917\u093e\u0938\u0940 \u0906\u0930\u093f\u0906\u0930\u0940" },
            { "mgf", "\u092e\u093e\u0926\u093e\u0917\u093e\u0938\u094d\u0915\u0930\u0940 \u092b\u094d\u0930\u093e\u0901" },
            { "mkd", "\u092e\u0947\u0938\u0947\u0921\u2019\u0928\u093f\u092f\u093e\u0928\u093f \u0926\u0947\u0928\u093e\u0930" },
            { "mlf", "\u092e\u093e\u0932\u0940 \u0915\u093e \u092b\u094d\u0930\u093e\u0901" },
            { "mmk", "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930\u0940 \u0915\u094d\u092f\u093e\u091f" },
            { "mnt", "\u092e\u0902\u0917\u0932\u093f\u092f\u093e\u0928\u093f \u0924\u0941\u0917\u094d\u0930\u0940\u0915" },
            { "mop", "\u092e\u093e\u0915\u093e\u0909\u0928\u093f \u092a\u093e\u0924\u093e\u0915\u093e" },
            { "mro", "\u092e\u094c\u0930\u093f\u091f\u093e\u0928\u0940 \u090a\u0917\u0941\u092f\u093e (1973\u20132017)" },
            { "mru", "\u092e\u2019\u0930\u093f\u0936\u093f\u092f\u093e\u0928\u093f \u090a\u0917\u0941\u092f\u093e" },
            { "mtl", "\u092e\u093e\u0932\u094d\u091f\u0940 \u0932\u0940\u0930\u093e" },
            { "mtp", "\u092e\u093e\u0932\u094d\u091f\u0940 \u092a\u094c\u0902\u0921" },
            { "mur", "\u092e\u0930\u093f\u0938\u093f\u092f\u093e\u0928\u093f \u0930\u0941\u092a\u0940" },
            { "mvr", "\u092e\u093e\u0932\u0926\u0940\u0935 \u0926\u094d\u0935\u0940\u092a \u0915\u093e \u0930\u0942\u092b\u093f\u092f\u093e" },
            { "mwk", "\u092e\u093e\u0932\u093e\u0935\u0940\u0928\u093f \u0915\u094d\u0935\u093e\u091a\u093e" },
            { "mxn", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u093e\u0928 \u092a\u0947\u0938\u2019" },
            { "mxp", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u0930\u091c\u0924\u0940 \u092a\u0947\u0938\u094b (1861\u20131992)" },
            { "mxv", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u092f\u0941\u0928\u0940\u0926\u093e\u0926 \u0926 \u0908\u0928\u0935\u0947\u0930\u0938\u093f\u0913\u0928 (\u092f\u0941\u0921\u0940\u0906\u0908)" },
            { "myr", "\u092e\u0932\u0947\u0936\u093f\u092f\u0928 \u0930\u093f\u0902\u0917\u093f\u0924" },
            { "mze", "\u092e\u094b\u091c\u093c\u093e\u0902\u092c\u0940\u0915 \u090f\u0938\u094d\u0915\u0941\u090f\u0926\u094b" },
            { "mzm", "\u092e\u094b\u091c\u093c\u093e\u0902\u092c\u0940\u0915 \u092a\u0941\u0930\u093e\u0928\u093e \u092e\u0947\u0924\u0940\u0915\u093e\u0932" },
            { "mzn", "\u092e\u091c\u093e\u092e\u094d\u092c\u093f\u0915\u0928\u093f \u092e\u0947\u091f\u093f\u0915\u0947\u0932" },
            { "nad", "\u0928\u093e\u092e\u093f\u092c\u093f\u092f\u093e\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "ngn", "\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e\u0928\u093f \u0928\u093e\u092f\u0930\u093e" },
            { "nic", "\u0928\u0940\u0915\u093e\u0930\u093e\u0917\u0941\u0906\u0908 \u0915\u094b\u0930\u094d\u0926\u094b\u092c\u093e" },
            { "nio", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0906\u0928\u093f \u0915\u0930\u094d\u0926\u2019\u092c\u093e" },
            { "nlg", "\u0928\u0947\u0926\u0930\u0932\u0948\u0923\u094d\u0921 \u0917\u0940\u0932\u0921\u0930" },
            { "nok", "\u0928\u0930\u0935\u0948\u0928\u093f \u0915\u094d\u0930\u2019\u0928" },
            { "npr", "\u0928\u0947\u092a\u093e\u0932\u0940 \u0930\u0941\u092a\u0940" },
            { "nzd", "\u0928\u094d\u092f\u0942\u091c\u093c\u0940\u0932\u0948\u0902\u0921 \u0921\u0949\u0932\u0930" },
            { "omr", "\u0905\u092e\u093e\u0928\u0928\u093f \u0930\u093f\u092f\u093e\u0932" },
            { "pab", "\u092a\u093e\u0928\u093e\u092e\u093e\u0928\u093f \u092c\u093e\u0932\u094d\u092c\u2019\u0906" },
            { "pei", "\u092a\u0947\u0930\u0942\u0935\u093e\u0908 \u0908\u0902\u091f\u0940" },
            { "pen", "\u092a\u0947\u0930\u0942\u0928\u093f \u0938\u0932" },
            { "pes", "\u092a\u0947\u0930\u0941\u0935\u093e\u0908 \u0938\u094b\u0932 (1863\u20131965)" },
            { "pgk", "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0941 \u0917\u0940\u0928\u0940 \u0915\u093e \u0915\u0940\u0928\u093e" },
            { "php", "\u092b\u093c\u093f\u0932\u093f\u092a\u0940\u0928 \u0915\u093e \u092a\u0947\u0938\u094b" },
            { "pkr", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u0930\u0941\u092a\u092f\u093e" },
            { "pln", "\u092a\u0932\u0947\u0923\u094d\u0921\u0928\u093f \u091c\u094d\u0932\u2019\u091f\u0940" },
            { "pte", "\u092a\u0941\u0930\u0924\u0941\u0917\u0940 \u090f\u0938\u094d\u0915\u0941\u0926\u094b" },
            { "pyg", "\u092a\u093e\u0930\u093e\u0917\u0941\u0935\u0947\u0928\u093f \u0917\u0941\u0906\u0930\u093e\u0928\u0940" },
            { "qar", "\u0915\u093e\u0924\u093e\u0930\u0928\u093f \u0930\u093f\u092f\u093e\u0932" },
            { "rhd", "\u0930\u094b\u0921\u0947\u0936\u093f\u092f\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "rol", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0908 \u092a\u0941\u0930\u093e\u0928\u0940 \u0932" },
            { "ron", "\u0930\u092e\u093e\u0928\u093f\u092f\u093e\u0928\u093f \u0932\u093f\u0909" },
            { "rsd", "\u0938\u093e\u0930\u094d\u092c\u093f\u092f\u093e\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "rub", "\u0930\u093e\u0938\u093f\u092f\u093e\u0928\u093f \u0930\u0942\u092c\u0932" },
            { "rwf", "\u0930\u0941\u0935\u093e\u0928\u094d\u0926\u093e\u0928\u093f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "sar", "\u0938\u093e\u0909\u0926\u093f \u0930\u093f\u092f\u093e\u0932" },
            { "sbd", "\u0938\u094b\u0932\u094b\u092e\u0928 \u0926\u094d\u0935\u0940\u092a \u0915\u093e \u0921\u0949\u0932\u0930" },
            { "scr", "\u0938\u0948\u0936\u0947\u0932\u094d\u0932\u0947\u0938\u0928\u093f \u0930\u0942\u092a\u0940" },
            { "sdd", "\u0938\u0941\u0926\u093e\u0928\u0940 \u092a\u0941\u0930\u093e\u0928\u093e \u0921\u0949\u0932\u0930" },
            { "sdg", "\u0938\u0941\u0926\u093e\u0928\u0928\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "sdp", "\u0938\u0941\u0926\u093e\u0928\u0940 \u092a\u0941\u0930\u093e\u0928\u093e \u092a\u094c\u0902\u0921" },
            { "sek", "\u0938\u094d\u0935\u0940\u0921\u0947\u0928\u0928\u093f \u0915\u094d\u0930\u2019\u0928\u093e" },
            { "sgd", "\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930 \u0921\u0949\u0932\u0930" },
            { "shp", "\u0938\u0948\u0928\u094d\u091f \u0939\u0947\u0932\u0947\u0928\u093e\u0928\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "sit", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e\u0908 \u0924\u094b\u0932\u093e\u0930" },
            { "skk", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u0940 \u0915\u094b\u0930\u0941\u0928\u093e" },
            { "sle", "\u0938\u0940\u092f\u0947\u0930\u094d\u0930\u093e \u0932\u093f\u092f\u2019\u0928\u0928\u093f \u0932\u0940\u092f\u0928" },
            { "sll", "\u0938\u0940\u092f\u0947\u0930\u094d\u0930\u093e \u0932\u093f\u092f\u2019\u0928\u0928\u093f \u0932\u0940\u092f\u0928 (1964\u20142022)" },
            { "sos", "\u0938\u092e\u093e\u0932\u093f\u092f\u093e\u0928\u093f \u0936\u093f\u0932\u093f\u0902" },
            { "srd", "\u0938\u0941\u0930\u0940\u0928\u093e\u092e\u0928\u093f \u0921\u0932\u093e\u0930" },
            { "srg", "\u0938\u0941\u0930\u0940\u0928\u093e\u092e \u0917\u0940\u0932\u094d\u0921\u0930" },
            { "ssp", "\u0916\u094b\u0932\u093e \u0938\u0941\u0926\u093e\u0928\u093e\u0930\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "std", "\u0938\u093e\u0901\u0935 \u0924\u094b\u092e\u0947 \u090f\u0935\u0902 \u092a\u094d\u0930\u0940\u0928\u094d\u0938\u0940\u092a\u0947 \u0915\u093e \u0921\u094b\u092c\u094d\u0930\u093e (1977\u20132017)" },
            { "stn", "\u0938\u093e\u090a \u0924\u092e\u0947 \u0906\u0930\u094b \u092a\u094d\u0930\u093f\u0928\u094d\u0938\u093f\u092a\u0928\u093f \u0926\u092c\u094d\u0930\u093e" },
            { "sur", "\u0938\u094b\u0935\u093f\u092f\u0924 \u0930\u0942\u092c\u0932" },
            { "svc", "\u090f\u0932 \u0938\u093e\u0932\u0935\u093e\u0926\u0930 \u0915\u094b\u0932\u094b\u0928" },
            { "syp", "\u0938\u0940\u0930\u093f\u092f\u093e\u0928\u093f \u092a\u093e\u0909\u0923\u094d\u0921" },
            { "szl", "\u0938\u094d\u0935\u093e\u091c\u0940 \u0932\u0940\u0932\u093e\u0902\u0917\u0947\u0928\u0940" },
            { "thb", "\u0925\u093e\u0908 \u092c\u093e\u0939\u094d\u091f" },
            { "tjr", "\u0924\u093e\u091c\u0940\u0915\u093c\u0940\u0938\u094d\u0924\u093e\u0928\u0940 \u0930\u0942\u092c\u0932" },
            { "tjs", "\u0924\u093e\u091c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0928\u093f \u0938\u092e\u2019\u0928\u093f" },
            { "tmm", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u0940\u0938\u094d\u0924\u093e\u0928\u0940 \u092e\u093e\u0928\u093e\u091f" },
            { "tmt", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u0940\u0938\u094d\u0924\u093e\u0928\u0928\u093f \u092e\u093e\u0928\u093e\u0924" },
            { "tnd", "\u0924\u094d\u0938\u0941\u0928\u0940\u0938\u0940\u092f\u093e\u0928\u093f \u0926\u093f\u0928\u093e\u0930" },
            { "top", "\u091f\u0949\u0902\u0917\u093e \u092a\u093e\u0908\u0902\u0917\u093e" },
            { "tpe", "\u0924\u0940\u092e\u094b\u0930\u0940 \u090f\u0938\u094d\u0915\u0941\u0926\u094b" },
            { "trl", "\u0924\u0941\u0930\u094d\u0915\u0940 \u0932\u0940\u0930\u093e" },
            { "try", "\u0924\u0941\u0930\u094d\u0915\u0940\u0928\u093f \u0932\u0940\u0930\u093e" },
            { "ttd", "\u0924\u094d\u0930\u093f\u0928\u093f\u0926\u093e\u0926 \u0906\u0930\u094b \u0924\u092c\u093e\u0917\u2019 \u0921\u0932\u093e\u0930" },
            { "twd", "\u0924\u093e\u0908\u0935\u093e\u0928\u0928\u093f \u0917\u094b\u0926\u093e\u0928 \u0921\u0932\u093e\u0930" },
            { "tzs", "\u0924\u093e\u0928\u094d\u091c\u093e\u0928\u093f\u092f\u093e\u0928\u093f \u0936\u093f\u0932\u093f\u0902" },
            { "uah", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928\u0928\u093f \u0939\u094d\u0930\u0940\u092d\u0928\u093f\u092f\u093e" },
            { "uak", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928\u0940 \u0915\u093e\u0930\u094d\u092c\u094b\u0935\u093e\u0928\u0947\u0924\u094d\u091c\u093c" },
            { "ugs", "\u092f\u0941\u0917\u093e\u0901\u0921\u093e\u0908 \u0936\u0940\u0932\u0940\u0902\u0917 (1996\u20131987)" },
            { "ugx", "\u0909\u0917\u093e\u0923\u094d\u0921\u093e\u0928\u093f \u0936\u093f\u0932\u093f\u0902" },
            { "usd", "\u0907\u0909.\u090f\u0938 \u0921\u0932\u093e\u0930" },
            { "usn", "\u0905\u092e\u0930\u093f\u0915\u0940 \u0921\u0949\u0932\u0930 (\u0905\u0917\u0932\u0947 \u0926\u093f\u0928 \u0915\u093e)" },
            { "uss", "\u0905\u092e\u0930\u093f\u0915\u0940 \u0921\u0949\u0932\u0930 (\u0907\u0938\u0940 \u0926\u093f\u0928 \u0915\u093e)" },
            { "uyi", "\u090a\u0930\u0941\u0917\u0941\u090f \u0915\u093e \u092a\u0947\u0938\u094b \u0906\u0928 \u090a\u0928\u0940\u0926\u093e\u0926\u094b\u0938 \u0908\u0902\u0926\u0947\u0915\u094d\u0938\u093e\u0926\u093e\u0938" },
            { "uyp", "\u090a\u0930\u0941\u0917\u0941\u090f \u0915\u093e \u092a\u0947\u0938\u094b (1975\u20131993)" },
            { "uyu", "\u0909\u0930\u0941\u0917\u0941\u0935\u0947\u0928\u093f \u092a\u0947\u0938\u2019" },
            { "uzs", "\u0909\u091c\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0928\u093f \u0938\u2019\u092e" },
            { "veb", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e\u0908 \u092c\u094b\u0932\u093f\u0935\u093e\u0930 (1871\u20132008)" },
            { "vef", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e\u0908 \u092c\u094b\u0932\u093f\u0935\u093e\u0930 (2008\u20132018)" },
            { "ves", "\u092d\u0947\u0928\u0947\u091c\u0941\u0935\u0947\u0932\u093e\u0928\u093f \u092c\u0932\u093f\u092d\u093e\u0930" },
            { "vnd", "\u0935\u0940\u092f\u0924\u0928\u093e\u092e\u0940 \u0921\u0949\u0902\u0917" },
            { "vuv", "\u0935\u0928\u0941\u0906\u091f\u0941 \u0935\u091f\u0941" },
            { "wst", "\u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u0938\u092e\u094b\u0906 \u0924\u093e\u0932\u093e" },
            { "xaf", "\u092e\u093f\u0930\u0941 \u0906\u092b\u094d\u0930\u093f\u0915\u093e\u0928\u093f \u0938\u093f.\u090f\u092b.\u090f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "xag", "\u0930\u091c\u0924" },
            { "xau", "\u0938\u094b\u0928\u093e" },
            { "xba", "\u090f\u0915\u094d\u092f\u0941" },
            { "xbb", "\u090f\u092e\u094d\u092f\u0941" },
            { "xbc", "\u092f\u0942\u0930\u094b\u092a\u0940 \u090f\u0915\u093e\u090a\u0902\u091f \u0915\u093e \u092f\u0941\u0928\u0940\u091f (\u090f\u0915\u094d\u0938 \u092c\u0940 \u0938\u0940)" },
            { "xbd", "\u092f\u0942\u0930\u094b\u092a\u0940 \u090f\u0915\u093e\u090a\u0902\u091f \u0915\u093e \u092f\u0941\u0928\u0940\u091f (\u090f\u0915\u094d\u0938 \u092c\u0940 \u0921\u0940)" },
            { "xcd", "\u0938\u093e\u0928\u091c\u093e \u0915\u0947\u0930\u093f\u092c\u093f\u092f\u093e\u0928 \u0921\u0932\u093e\u0930" },
            { "xdr", "\u0938\u094d\u092a\u0947\u0936\u093f\u092f\u0932 \u0921\u094d\u0930\u093e\u0908\u0902\u0917 \u0930\u093e\u0908\u091f\u094d\u0938" },
            { "xeu", "\u092f\u0942\u0930\u094b\u092a\u0940 \u092e\u0941\u0926\u094d\u0930\u093e (\u090f\u0915\u094d\u092f\u0941)" },
            { "xfo", "\u092b\u094d\u0930\u093e\u0928\u0938\u0940\u0938\u0940 \u0938\u0941\u0935\u0930\u094d\u0923 \u092b\u094d\u0930\u093e\u0901" },
            { "xfu", "\u092b\u094d\u0930\u093e\u0928\u0938\u0940\u0938\u0940 \u092f\u0941\u0906\u0908\u0938\u0940 \u092b\u094d\u0930\u093e\u0901" },
            { "xof", "\u0938\u094b\u0928\u093e\u092c \u0906\u092b\u094d\u0930\u093f\u0915\u093e\u0928\u093f \u0938\u093f.\u090f\u092b.\u090f \u092b\u094d\u0930\u093e\u0902\u0915" },
            { "xpd", "\u092a\u0948\u0932\u0947\u0921\u093f\u092f\u092e" },
            { "xpf", "\u092b\u094d\u0930\u093e\u0928\u0938\u0940\u0938\u0940 \u092b\u0947\u0926\u0947\u0930\u0947\u0936\u0928\u0940 \u092b\u094d\u0930\u093e\u0901" },
            { "xpt", "\u092a\u094d\u0932\u0948\u091f\u0940\u0928\u092e" },
            { "xre", "\u0930\u0940\u0928\u0948\u091f \u092b\u0902\u0921\u094d\u0938" },
            { "xts", "\u091f\u0947\u0938\u094d\u091f\u0940\u0902\u0917 \u0915\u0930\u0928\u0938\u0940 \u0915\u094b\u0921" },
            { "xxx", "\u092e\u093f\u0925\u093f\u092f\u0948 \u0930\u093e\u0902" },
            { "ydd", "\u092f\u092e\u0928\u0940 \u0926\u0940\u0928\u093e\u0930" },
            { "yer", "\u092f\u0947\u092e\u0947\u0928\u0928\u093f \u0930\u093f\u092f\u093e\u0932" },
            { "yud", "\u092f\u0941\u0917\u094b\u0938\u094d\u0932\u093e\u0935\u0940 \u0939\u093e\u0930\u094d\u0921 \u0926\u0940\u0928\u093e\u0930" },
            { "yum", "\u092f\u0941\u0917\u094b\u0938\u094d\u0932\u093e\u0935\u0940 \u0928\u094b\u0935\u0940\u092f (\u0928\u092f\u0947) \u0926\u0940\u0928\u093e\u0930" },
            { "yun", "\u092f\u0941\u0917\u094b\u0938\u094d\u0932\u093e\u0935\u0940 \u0915\u0928\u0935\u0930\u094d\u091f\u0940\u092c\u0932 \u0926\u0940\u0928\u093e\u0930" },
            { "zar", "\u0916\u094b\u0932\u093e \u0906\u092b\u094d\u0930\u093f\u0915\u093e\u0928\u093f \u0930\u093e\u0923\u094d\u0921" },
            { "zmk", "\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u092f\u093e\u0908 \u0915\u094d\u0935\u093e\u091a\u093e (1968\u20132012)" },
            { "zmw", "\u091c\u093e\u092e\u094d\u092c\u093f\u092f\u093e\u0928\u093f \u0915\u094d\u0935\u093e\u091a\u093e" },
            { "zrn", "\u091c\u093c\u093e\u0908\u0930\u0940 \u0928\u092f\u0947 \u091c\u093c\u093e\u0908\u0930" },
            { "zrz", "\u091c\u093c\u093e\u0908\u0930\u0940 \u091c\u093c\u093e\u0908\u0930" },
            { "zwd", "\u091c\u093c\u0940\u092e\u094d\u092c\u093e\u092c\u0935\u0947\u0908 \u0921\u0949\u0932\u0930" },
        };
        return data;
    }
}
