/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_nl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AUD", "AU$" },
            { "CAD", "C$" },
            { "FJD", "FJ$" },
            { "PHP", "PHP" },
            { "SBD", "SI$" },
            { "THB", "\u0e3f" },
            { "XPF", "XPF" },
            { "XXX", "XXX" },
            { "adp", "Andorrese peseta" },
            { "aed", "Verenigde Arabische Emiraten-dirham" },
            { "afa", "Afghani (1927\u20132002)" },
            { "afn", "Afghaanse afghani" },
            { "alk", "Albanese lek (1946\u20131965)" },
            { "all", "Albanese lek" },
            { "amd", "Armeense dram" },
            { "ang", "Nederlands-Antilliaanse gulden" },
            { "aoa", "Angolese kwanza" },
            { "aok", "Angolese kwanza (1977\u20131990)" },
            { "aon", "Angolese nieuwe kwanza (1990\u20132000)" },
            { "aor", "Angolese kwanza reajustado (1995\u20131999)" },
            { "ara", "Argentijnse austral" },
            { "arl", "Argentijnse peso ley (1970\u20131983)" },
            { "arm", "Argentijnse peso (1881\u20131970)" },
            { "arp", "Argentijnse peso (1983\u20131985)" },
            { "ars", "Argentijnse peso" },
            { "ats", "Oostenrijkse schilling" },
            { "aud", "Australische dollar" },
            { "awg", "Arubaanse gulden" },
            { "azm", "Azerbeidzjaanse manat (1993\u20132006)" },
            { "azn", "Azerbeidzjaanse manat" },
            { "bad", "Bosnische dinar" },
            { "bam", "Bosnische convertibele mark" },
            { "ban", "Nieuwe Bosnische dinar (1994\u20131997)" },
            { "bbd", "Barbadaanse dollar" },
            { "bdt", "Bengalese taka" },
            { "bec", "Belgische frank (convertibel)" },
            { "bef", "Belgische frank" },
            { "bel", "Belgische frank (financieel)" },
            { "bgl", "Bulgaarse harde lev" },
            { "bgm", "Bulgaarse socialistische lev" },
            { "bgn", "Bulgaarse lev" },
            { "bgo", "Bulgaarse lev (1879\u20131952)" },
            { "bhd", "Bahreinse dinar" },
            { "bif", "Burundese frank" },
            { "bmd", "Bermuda-dollar" },
            { "bnd", "Bruneise dollar" },
            { "bob", "Boliviaanse boliviano" },
            { "bol", "Boliviaanse boliviano (1863\u20131963)" },
            { "bop", "Boliviaanse peso" },
            { "bov", "Boliviaanse mvdol" },
            { "brb", "Braziliaanse cruzeiro novo (1967\u20131986)" },
            { "brc", "Braziliaanse cruzado" },
            { "bre", "Braziliaanse cruzeiro (1990\u20131993)" },
            { "brl", "Braziliaanse real" },
            { "brn", "Braziliaanse nieuwe cruzado (1989\u20131990)" },
            { "brr", "Braziliaanse cruzeiro" },
            { "brz", "Braziliaanse cruzeiro (1942\u20131967)" },
            { "bsd", "Bahamaanse dollar" },
            { "btn", "Bhutaanse ngultrum" },
            { "buk", "Birmese kyat" },
            { "bwp", "Botswaanse pula" },
            { "byb", "Wit-Russische nieuwe roebel (1994\u20131999)" },
            { "byn", "Belarussische roebel" },
            { "byr", "Wit-Russische roebel (2000\u20132016)" },
            { "bzd", "Belizaanse dollar" },
            { "cad", "Canadese dollar" },
            { "cdf", "Congolese frank" },
            { "che", "WIR euro" },
            { "chf", "Zwitserse frank" },
            { "chw", "WIR franc" },
            { "cle", "Chileense escudo" },
            { "clf", "Chileense unidades de fomento" },
            { "clp", "Chileense peso" },
            { "cnh", "Chinese yuan (offshore)" },
            { "cnx", "dollar van de Chinese Volksbank" },
            { "cny", "Chinese yuan" },
            { "cop", "Colombiaanse peso" },
            { "cou", "Unidad de Valor Real" },
            { "crc", "Costa Ricaanse colon" },
            { "csd", "Oude Servische dinar" },
            { "csk", "Tsjechoslowaakse harde koruna" },
            { "cuc", "Cubaanse convertibele peso" },
            { "cup", "Cubaanse peso" },
            { "cve", "Kaapverdische escudo" },
            { "cyp", "Cyprisch pond" },
            { "czk", "Tsjechische kroon" },
            { "ddm", "Oost-Duitse ostmark" },
            { "dem", "Duitse mark" },
            { "djf", "Djiboutiaanse frank" },
            { "dkk", "Deense kroon" },
            { "dop", "Dominicaanse peso" },
            { "dzd", "Algerijnse dinar" },
            { "ecs", "Ecuadoraanse sucre" },
            { "ecv", "Ecuadoraanse unidad de valor constante (UVC)" },
            { "eek", "Estlandse kroon" },
            { "egp", "Egyptisch pond" },
            { "ern", "Eritrese nakfa" },
            { "esa", "Spaanse peseta (account A)" },
            { "esb", "Spaanse peseta (convertibele account)" },
            { "esp", "Spaanse peseta" },
            { "etb", "Ethiopische birr" },
            { "eur", "Euro" },
            { "fim", "Finse markka" },
            { "fjd", "Fiji-dollar" },
            { "fkp", "Falklandeilands pond" },
            { "frf", "Franse franc" },
            { "gbp", "Britse pond" },
            { "gek", "Georgische kupon larit" },
            { "gel", "Georgische lari" },
            { "ghc", "Ghanese cedi (1979\u20132007)" },
            { "ghs", "Ghanese cedi" },
            { "gip", "Gibraltarees pond" },
            { "gmd", "Gambiaanse dalasi" },
            { "gnf", "Guinese frank" },
            { "gns", "Guinese syli" },
            { "gqe", "Equatoriaal-Guinese ekwele guineana" },
            { "grd", "Griekse drachme" },
            { "gtq", "Guatemalteekse quetzal" },
            { "gwe", "Portugees-Guinese escudo" },
            { "gwp", "Guinee-Bissause peso" },
            { "gyd", "Guyaanse dollar" },
            { "hkd", "Hongkongse dollar" },
            { "hnl", "Hondurese lempira" },
            { "hrd", "Kroatische dinar" },
            { "hrk", "Kroatische kuna" },
            { "htg", "Ha\u00eftiaanse gourde" },
            { "huf", "Hongaarse forint" },
            { "idr", "Indonesische roepia" },
            { "iep", "Iers pond" },
            { "ilp", "Isra\u00eblisch pond" },
            { "ilr", "Isra\u00eblische sjekel (1980\u20131985)" },
            { "ils", "Isra\u00eblische nieuwe shekel" },
            { "inr", "Indiase roepie" },
            { "iqd", "Iraakse dinar" },
            { "irr", "Iraanse rial" },
            { "isj", "IJslandse kroon (1918\u20131981)" },
            { "isk", "IJslandse kroon" },
            { "itl", "Italiaanse lire" },
            { "jmd", "Jamaicaanse dollar" },
            { "jod", "Jordaanse dinar" },
            { "jpy", "Japanse yen" },
            { "kes", "Keniaanse shilling" },
            { "kgs", "Kirgizische som" },
            { "khr", "Cambodjaanse riel" },
            { "kmf", "Comorese frank" },
            { "kpw", "Noord-Koreaanse won" },
            { "krh", "Zuid-Koreaanse hwan (1953\u20131962)" },
            { "kro", "Oude Zuid-Koreaanse won (1945\u20131953)" },
            { "krw", "Zuid-Koreaanse won" },
            { "kwd", "Koeweitse dinar" },
            { "kyd", "Kaaimaneilandse dollar" },
            { "kzt", "Kazachse tenge" },
            { "lak", "Laotiaanse kip" },
            { "lbp", "Libanees pond" },
            { "lkr", "Sri Lankaanse roepie" },
            { "lrd", "Liberiaanse dollar" },
            { "lsl", "Lesothaanse loti" },
            { "ltl", "Litouwse litas" },
            { "ltt", "Litouwse talonas" },
            { "luc", "Luxemburgse convertibele franc" },
            { "luf", "Luxemburgse frank" },
            { "lul", "Luxemburgse financi\u00eble franc" },
            { "lvl", "Letse lats" },
            { "lvr", "Letse roebel" },
            { "lyd", "Libische dinar" },
            { "mad", "Marokkaanse dirham" },
            { "maf", "Marokkaanse franc" },
            { "mcf", "Monegaskische frank" },
            { "mdc", "Moldavische cupon" },
            { "mdl", "Moldavische leu" },
            { "mga", "Malagassische ariary" },
            { "mgf", "Malagassische franc" },
            { "mkd", "Macedonische denar" },
            { "mkn", "Macedonische denar (1992\u20131993)" },
            { "mlf", "Malinese franc" },
            { "mmk", "Myanmarese kyat" },
            { "mnt", "Mongoolse tugrik" },
            { "mop", "Macause pataca" },
            { "mro", "Mauritaanse ouguiya (1973\u20132017)" },
            { "mru", "Mauritaanse ouguiya" },
            { "mtl", "Maltese lire" },
            { "mtp", "Maltees pond" },
            { "mur", "Mauritiaanse roepie" },
            { "mvp", "Maldivische roepie" },
            { "mvr", "Maldivische rufiyaa" },
            { "mwk", "Malawische kwacha" },
            { "mxn", "Mexicaanse peso" },
            { "mxp", "Mexicaanse zilveren peso (1861\u20131992)" },
            { "mxv", "Mexicaanse unidad de inversion (UDI)" },
            { "myr", "Maleisische ringgit" },
            { "mze", "Mozambikaanse escudo" },
            { "mzm", "Oude Mozambikaanse metical" },
            { "mzn", "Mozambikaanse metical" },
            { "nad", "Namibische dollar" },
            { "ngn", "Nigeriaanse naira" },
            { "nic", "Nicaraguaanse c\u00f3rdoba (1988\u20131991)" },
            { "nio", "Nicaraguaanse c\u00f3rdoba" },
            { "nlg", "Nederlandse gulden" },
            { "nok", "Noorse kroon" },
            { "npr", "Nepalese roepie" },
            { "nzd", "Nieuw-Zeelandse dollar" },
            { "omr", "Omaanse rial" },
            { "pab", "Panamese balboa" },
            { "pei", "Peruaanse inti" },
            { "pen", "Peruaanse sol" },
            { "pes", "Peruaanse sol (1863\u20131965)" },
            { "pgk", "Papoea-Nieuw-Guinese kina" },
            { "php", "Filipijnse peso" },
            { "pkr", "Pakistaanse roepie" },
            { "pln", "Poolse zloty" },
            { "plz", "Poolse zloty (1950\u20131995)" },
            { "pte", "Portugese escudo" },
            { "pyg", "Paraguayaanse guarani" },
            { "qar", "Qatarese rial" },
            { "rhd", "Rhodesische dollar" },
            { "rol", "Oude Roemeense leu" },
            { "ron", "Roemeense leu" },
            { "rsd", "Servische dinar" },
            { "rub", "Russische roebel" },
            { "rur", "Russische roebel (1991\u20131998)" },
            { "rwf", "Rwandese frank" },
            { "sar", "Saoedi-Arabische riyal" },
            { "sbd", "Salomon-dollar" },
            { "scr", "Seychelse roepie" },
            { "sdd", "Soedanese dinar" },
            { "sdg", "Soedanees pond" },
            { "sdp", "Soedanees pond (1957\u20131998)" },
            { "sek", "Zweedse kroon" },
            { "sgd", "Singaporese dollar" },
            { "shp", "Sint-Heleens pond" },
            { "sit", "Sloveense tolar" },
            { "skk", "Slowaakse koruna" },
            { "sle", "Sierra Leoonse leone" },
            { "sll", "Sierra Leoonse leone (1964\u20132022)" },
            { "sos", "Somalische shilling" },
            { "srd", "Surinaamse dollar" },
            { "srg", "Surinaamse gulden" },
            { "ssp", "Zuid-Soedanees pond" },
            { "std", "Santomese dobra (1977\u20132017)" },
            { "stn", "Santomese dobra" },
            { "sur", "Sovjet-roebel" },
            { "svc", "Salvadoraanse col\u00f3n" },
            { "syp", "Syrisch pond" },
            { "szl", "Swazische lilangeni" },
            { "thb", "Thaise baht" },
            { "tjr", "Tadzjikistaanse roebel" },
            { "tjs", "Tadzjiekse somoni" },
            { "tmm", "Turkmeense manat (1993\u20132009)" },
            { "tmt", "Turkmeense manat" },
            { "tnd", "Tunesische dinar" },
            { "top", "Tongaanse pa\u02bbanga" },
            { "tpe", "Timorese escudo" },
            { "trl", "Turkse lire" },
            { "try", "Turkse lira" },
            { "ttd", "Trinidad en Tobago-dollar" },
            { "twd", "Nieuwe Taiwanese dollar" },
            { "tzs", "Tanzaniaanse shilling" },
            { "uah", "Oekra\u00efense hryvnia" },
            { "uak", "Oekra\u00efense karbovanetz" },
            { "ugs", "Oegandese shilling (1966\u20131987)" },
            { "ugx", "Oegandese shilling" },
            { "usd", "Amerikaanse dollar" },
            { "usn", "Amerikaanse dollar (volgende dag)" },
            { "uss", "Amerikaanse dollar (zelfde dag)" },
            { "uyi", "Uruguayaanse peso en ge\u00efndexeerde eenheden" },
            { "uyp", "Uruguayaanse peso (1975\u20131993)" },
            { "uyu", "Uruguayaanse peso" },
            { "uyw", "Uruguayaanse nominale salarisindexeenheid" },
            { "uzs", "Oezbeekse sum" },
            { "veb", "Venezolaanse bolivar (1871\u20132008)" },
            { "ved", "Bol\u00edvar Soberano" },
            { "vef", "Venezolaanse bolivar (2008\u20132018)" },
            { "ves", "Venezolaanse bolivar" },
            { "vnd", "Vietnamese dong" },
            { "vnn", "Vietnamese dong (1978\u20131985)" },
            { "vuv", "Vanuatuaanse vatu" },
            { "wst", "Samoaanse tala" },
            { "xaf", "CFA-frank" },
            { "xag", "Zilver" },
            { "xau", "Goud" },
            { "xba", "Europese samengestelde eenheid" },
            { "xbb", "Europese monetaire eenheid" },
            { "xbc", "Europese rekeneenheid (XBC)" },
            { "xbd", "Europese rekeneenheid (XBD)" },
            { "xcd", "Oost-Caribische dollar" },
            { "xcg", "Caribische gulden" },
            { "xdr", "Special Drawing Rights" },
            { "xeu", "European Currency Unit" },
            { "xfo", "Franse gouden franc" },
            { "xfu", "Franse UIC-franc" },
            { "xof", "CFA-franc BCEAO" },
            { "xpd", "Palladium" },
            { "xpf", "CFP-frank" },
            { "xpt", "Platina" },
            { "xre", "RINET-fondsen" },
            { "xsu", "Sucre" },
            { "xts", "Valutacode voor testdoeleinden" },
            { "xua", "ADB-rekeneenheid" },
            { "xxx", "onbekende munteenheid" },
            { "ydd", "Jemenitische dinar" },
            { "yer", "Jemenitische rial" },
            { "yud", "Joegoslavische harde dinar" },
            { "yum", "Joegoslavische noviy-dinar" },
            { "yun", "Joegoslavische convertibele dinar" },
            { "yur", "Joegoslavische hervormde dinar (1992\u20131993)" },
            { "zal", "Zuid-Afrikaanse rand (financieel)" },
            { "zar", "Zuid-Afrikaanse rand" },
            { "zmk", "Zambiaanse kwacha (1968\u20132012)" },
            { "zmw", "Zambiaanse kwacha" },
            { "zrn", "Za\u00efrese nieuwe za\u00efre" },
            { "zrz", "Za\u00efrese za\u00efre" },
            { "zwd", "Zimbabwaanse dollar" },
            { "zwl", "Zimbabwaanse dollar (2009)" },
            { "zwr", "Zimbabwaanse dollar (2008)" },
        };
        return data;
    }
}
