/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_qu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabe Simi";
        final String metaValue_hy = "Armenio Simi";
        final String metaValue_bn = "Bangla Simi";
        final String metaValue_ccp = "Chakma Simi";
        final String metaValue_el = "Griego Simi";
        final String metaValue_gu = "Gujarati Simi";
        final String metaValue_he = "Hebreo Simi";
        final String metaValue_ja = "Japones Simi";
        final String metaValue_kn = "Kannada Simi";
        final String metaValue_ko = "Coreano Simi";
        final String metaValue_lo = "Lao Simi";
        final String metaValue_ml = "Malayalam Simi";
        final String metaValue_mn = "Mongol Simi";
        final String metaValue_MM = "Myanmar";
        final String metaValue_nqo = "N\u2019Ko Simi";
        final String metaValue_or = "Odia Simi";
        final String metaValue_si = "Cingales Simi";
        final String metaValue_ta = "Tamil Simi";
        final String metaValue_th = "Tailandes Simi";
        final String metaValue_bo = "Tibetano Simi";
        final String metaValue_vai = "Vai Simi";
        final String metaValue_ii = "Yi Simi";
        final Object[][] data = new Object[][] {
            { "001", "Pacha" },
            { "002", "Africa" },
            { "003", "Norte America" },
            { "005", "Sud America" },
            { "009", "Oceania" },
            { "011", "Africa Occidental" },
            { "013", "America Central" },
            { "014", "Africa Oriental" },
            { "015", "Africa del Norte" },
            { "017", "Africa Media" },
            { "018", "Sud Africa" },
            { "019", "America" },
            { "021", "America del Norte" },
            { "029", "Caribe" },
            { "030", "Asia Oriental" },
            { "034", "Asia del Sur" },
            { "035", "Sureste de Asia" },
            { "039", "Europa del Sur" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Regi\u00f3n Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Central" },
            { "145", "Asia Occidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa del Norte" },
            { "155", "Europa Occidental" },
            { "202", "Africa Sub-Sahariana" },
            { "419", "AmericaLatina" },
            { "AC", "Islas Ascensi\u00f3n" },
            { "AD", "Andorra" },
            { "AE", "Emiratos \u00c1rabes Unidos" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua y Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islas \u00c5land" },
            { "AZ", "Azerbaiy\u00e1n" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "B\u00e9lgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bar\u00e9in" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "San Bartolom\u00e9" },
            { "BM", "Bermudas" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BQ", "Bonaire" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "But\u00e1n" },
            { "BV", "Isla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Belar\u00fas" },
            { "BZ", "Belice" },
            { "CA", "Canad\u00e1" },
            { "CC", "Islas Cocos" },
            { "CD", "Congo (RDC)" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Congo" },
            { "CH", "Suiza" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Islas Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Isla Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curazao" },
            { "CX", "Isla Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "DE", "Alemania" },
            { "DG", "Diego Garc\u00eda" },
            { "DJ", "Yibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Argelia" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "Sahara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Union Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlandia" },
            { "FJ", "Fiyi" },
            { "FK", "Islas Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Islas Feroe" },
            { "FR", "Francia" },
            { "GA", "Gab\u00f3n" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Georgia" },
            { "GF", "Guayana Francesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sur e Islas Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bis\u00e1u" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong RAE China" },
            { "HM", "Islas Heard y McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "IC", "Islas Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Isla de Man" },
            { "IN", "India" },
            { "IO", "Territorio Brit\u00e1nico del Oc\u00e9ano \u00cdndico" },
            { "IQ", "Irak" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Jap\u00f3n" },
            { "KE", "Kenia" },
            { "KG", "Kirguist\u00e1n" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "San Crist\u00f3bal y Nieves" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "KW", "Kuwait" },
            { "KY", "Islas Caim\u00e1n" },
            { "KZ", "Kazajist\u00e1n" },
            { "LA", "Laos" },
            { "LB", "L\u00edbano" },
            { "LC", "Santa Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marruecos" },
            { "MC", "M\u00f3naco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "San Mart\u00edn" },
            { "MG", "Madagascar" },
            { "MH", "Islas Marshall" },
            { "MK", "Macedonia del Norte" },
            { "ML", "Mal\u00ed" },
            { "MM", metaValue_MM },
            { "MN", "Mongolia" },
            { "MO", "Macao RAE China" },
            { "MP", "Islas Marianas del Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e9xico" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nueva Caledonia" },
            { "NE", "N\u00edger" },
            { "NF", "Isla Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00edses Bajos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nueva Zelanda" },
            { "OM", "Om\u00e1n" },
            { "PA", "Panam\u00e1" },
            { "PE", "Per\u00fa" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Pap\u00faa Nueva Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Pakist\u00e1n" },
            { "PL", "Polonia" },
            { "PM", "San Pedro y Miquel\u00f3n" },
            { "PN", "Islas Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestina Kamachikuq" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Ocean\u00eda Perif\u00e9rica" },
            { "RE", "Reuni\u00f3n" },
            { "RO", "Rumania" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saud\u00ed" },
            { "SB", "Islas Salom\u00f3n" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e1n" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Elena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard y Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sud\u00e1n del Sur" },
            { "ST", "Santo Tom\u00e9 y Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Esuatini" },
            { "TA", "Trist\u00e1n de Acu\u00f1a" },
            { "TC", "Islas Turcas y Caicos" },
            { "TD", "Chad" },
            { "TF", "Territorios Australes Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tayikist\u00e1n" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "T\u00fanez" },
            { "TO", "Tonga" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinidad y Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "TZ", "Tanzania" },
            { "UA", "Ucrania" },
            { "UG", "Uganda" },
            { "UM", "Islas menores alejadas de los EE.UU." },
            { "UN", "Naciones Unidas" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekist\u00e1n" },
            { "VA", "Santa Sede (Ciudad del Vaticano)" },
            { "VC", "San Vicente y las Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Islas V\u00edrgenes Brit\u00e1nicas" },
            { "VI", "EE.UU. Islas V\u00edrgenes" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis y Futuna" },
            { "WS", "Samoa" },
            { "XA", "Seudo-Acentos" },
            { "XB", "Seudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud\u00e1frica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Mana yachasqa Suyu" },
            { "ab", "Abjasia" },
            { "af", "Afrikaans Simi" },
            { "ak", "Akan Simi" },
            { "am", "Amarico Simi" },
            { "an", "Aragonesa" },
            { "ar", metaValue_ar },
            { "as", "Asames Simi" },
            { "av", "Avaric" },
            { "ay", "Aymara Simi" },
            { "az", "Azerbaiyano Simi" },
            { "ba", "Baskir Simi" },
            { "be", "Bielorruso Simi" },
            { "bg", "Bulgaro Simi" },
            { "bi", "Bislama" },
            { "bm", "Bambara Simi" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Breton Simi" },
            { "bs", "Bosnio Simi" },
            { "ca", "Catalan Simi" },
            { "ce", "Checheno Simi" },
            { "ch", "Chamorro Simi" },
            { "co", "Corso Simi" },
            { "cs", "Checo Simi" },
            { "cu", "Eslavo Eclesi\u00e1stico Simi" },
            { "cv", "Chuvash Simi" },
            { "cy", "Gales Simi" },
            { "da", "Danes Simi" },
            { "de", "Aleman Simi" },
            { "dv", "Divehi Simi" },
            { "dz", "Butan\u00e9s Simi" },
            { "ee", "Ew\u00e9 Simi" },
            { "el", metaValue_el },
            { "en", "Ingles Simi" },
            { "eo", "Esperanto Simi" },
            { "es", "Espa\u00f1ol Simi" },
            { "et", "Estonio Simi" },
            { "eu", "Euskera Simi" },
            { "fa", "Persa Simi" },
            { "ff", "Fulah Simi" },
            { "fi", "Fines Simi" },
            { "fj", "Fiyiano Simi" },
            { "fo", "Feroes Simi" },
            { "fr", "Frances Simi" },
            { "fy", "Frison Simi" },
            { "ga", "Irlandes Simi" },
            { "gd", "Gaelico Escoces Simi" },
            { "gl", "Gallego Simi" },
            { "gn", "Guaran\u00ed Simi" },
            { "gu", metaValue_gu },
            { "gv", "Man\u00e9s Simi" },
            { "ha", "Hausa Simi" },
            { "he", metaValue_he },
            { "hi", "Hindi Simi" },
            { "hr", "Croata Simi" },
            { "ht", "Haitiano Criollo Simi" },
            { "hu", "Hungaro Simi" },
            { "hy", metaValue_hy },
            { "hz", "Herero Simi" },
            { "ia", "Interlingua Simi" },
            { "id", "Indonesio Simi" },
            { "ig", "Igbo Simi" },
            { "ii", metaValue_ii },
            { "io", "Ido Simi" },
            { "is", "Islandes Simi" },
            { "it", "Italiano Simi" },
            { "iu", "Inuktitut Simi" },
            { "ja", metaValue_ja },
            { "jv", "Javan\u00e9s Simi" },
            { "ka", "Georgiano Simi" },
            { "ki", "Kikuyu Simi" },
            { "kj", "Kuanyama Simi" },
            { "kk", "Kazajo Simi" },
            { "kl", "Groenlandes Simi" },
            { "km", "Khmer Simi" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri Simi" },
            { "ks", "Cachemir Simi" },
            { "ku", "Kurdo Simi" },
            { "kv", "Komi Simi" },
            { "kw", "C\u00f3rnico Simi" },
            { "ky", "Kirghiz Simi" },
            { "la", "Lat\u00edn Simi" },
            { "lb", "Luxemburgues Simi" },
            { "lg", "Luganda Simi" },
            { "li", "Limburgues Simi" },
            { "ln", "Lingala Simi" },
            { "lo", metaValue_lo },
            { "lt", "Lituano Simi" },
            { "lu", "Luba-Katanga Simi" },
            { "lv", "Leton Simi" },
            { "mg", "Malgache Simi" },
            { "mh", "Marshallese Simi" },
            { "mi", "Maori Simi" },
            { "mk", "Macedonio Simi" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi Simi" },
            { "ms", "Malayo Simi" },
            { "mt", "Maltes Simi" },
            { "my", "Birmano Simi" },
            { "na", "Nauru Simi" },
            { "nb", "Noruego Bokm\u00e5l Simi" },
            { "nd", "Ndebele septentrional Simi" },
            { "ne", "Nepali Simi" },
            { "ng", "Ndonga Simi" },
            { "nl", "Neerlandes Simi" },
            { "nn", "Noruego Nynorsk Simi" },
            { "no", "Noruego Simi" },
            { "nr", "Ndebele del Sur Simi" },
            { "nv", "Navajo Simi" },
            { "ny", "Nyanja Simi" },
            { "oc", "Occitano Simi" },
            { "om", "Oromo Simi" },
            { "or", metaValue_or },
            { "os", "Osetio Simi" },
            { "pa", "Punyabi Simi" },
            { "pl", "Polaco Simi" },
            { "ps", "Pashto Simi" },
            { "pt", "Portugues Simi" },
            { "qu", "Runasimi" },
            { "rm", "Romanche Simi" },
            { "rn", "Rundi Simi" },
            { "ro", "Rumano Simi" },
            { "ru", "Ruso Simi" },
            { "rw", "Kinyarwanda Simi" },
            { "sa", "Sanscrito Simi" },
            { "sc", "Sardinian Simi" },
            { "sd", "Sindhi Simi" },
            { "se", "Chincha Sami Simi" },
            { "sg", "Sango Simi" },
            { "si", metaValue_si },
            { "sk", "Eslovaco Simi" },
            { "sl", "Esloveno Simi" },
            { "sm", "Samoano Simi" },
            { "sn", "Shona Simi" },
            { "so", "Somali Simi" },
            { "sq", "Albanes Simi" },
            { "sr", "Serbio Simi" },
            { "ss", "Swati Simi" },
            { "st", "Soto Meridional Simi" },
            { "su", "Sundan\u00e9s Simi" },
            { "sv", "Sueco Simi" },
            { "sw", "Suajili Simi" },
            { "ta", metaValue_ta },
            { "te", "Telugu Simi" },
            { "tg", "Tayiko Simi" },
            { "th", metaValue_th },
            { "ti", "Tigri\u00f1a Simi" },
            { "tk", "Turcomano Simi" },
            { "tn", "Setsuana Simi" },
            { "to", "Tongano Simi" },
            { "tr", "Turco Simi" },
            { "ts", "Tsonga Simi" },
            { "tt", "Tartaro Simi" },
            { "ty", "Tahit\u00ed Simi" },
            { "ug", "Uigur Simi" },
            { "uk", "Ucraniano Simi" },
            { "ur", "Urdu Simi" },
            { "uz", "Uzbeko Simi" },
            { "ve", "Venda Simi" },
            { "vi", "Vietnamita Simi" },
            { "vo", "Volap\u00fck Simi" },
            { "wa", "Valona Simi" },
            { "wo", "Wolof Simi" },
            { "xh", "Isixhosa Simi" },
            { "yi", "Yiddish Simi" },
            { "yo", "Yoruba Simi" },
            { "zh", "Chino Simi" },
            { "zu", "Isizulu Simi" },
            { "ace", "Achinese" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "agq", "Aghem Simi" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Altai Meridional" },
            { "ann", "Obolo Simi" },
            { "anp", "Angika" },
            { "arn", "Mapuche Simi" },
            { "arp", "Arapaho" },
            { "ars", "\u00c1rabe Najdi Simi" },
            { "asa", "Asu Simi" },
            { "ast", "Asturiano Simi" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "ban", "Balines Simi" },
            { "bas", "Basaa Simi" },
            { "bem", "Bemba Simi" },
            { "bez", "Bena Simi" },
            { "bgc", "Haryanvi" },
            { "bho", "Bhojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksik\u00e1 Simi" },
            { "brx", "Bodo Simi" },
            { "bug", "Buginese" },
            { "byn", "Blin" },
            { "cay", "Cayug\u00e1" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano Simi" },
            { "cgg", "Kiga Simi" },
            { "chk", "Chuukese Simi" },
            { "chm", "Mari Simi" },
            { "cho", "Choctaw Simi" },
            { "chp", "Chipewyan Simi" },
            { "chr", "Cheroqui Simi" },
            { "chy", "Cheyenne" },
            { "ckb", "Chawpi Kurdo Simi" },
            { "clc", "Chilcotin Simi" },
            { "crg", "Michif Simi" },
            { "crj", "Cree Este del Sur Simi" },
            { "crk", "Plains Cree Simi" },
            { "crl", "Cree del Noreste Simi" },
            { "crm", "Moose Cree Simi" },
            { "crr", "Algonquian Carolina" },
            { "csw", "Swampy Cree Simi" },
            { "dak", "Dakota Simi" },
            { "dar", "Dargwa Simi" },
            { "dav", "Taita Simi" },
            { "dgr", "Dogrib Simi" },
            { "dje", "Zarma Simi" },
            { "doi", "Dogri Simi" },
            { "dsb", "Bajo Sorbio Simi" },
            { "dua", "Duala Simi" },
            { "dyo", "Jola-Fonyi Simi" },
            { "dzg", "Dazaga Simi" },
            { "ebu", "Embu Simi" },
            { "efi", "Efik Simi" },
            { "eka", "Ekajuk Simi" },
            { "ewo", "Ewondo Simi" },
            { "fil", "Filipino Simi" },
            { "fon", "Fon Simi" },
            { "frc", "Franc\u00e9s Cajun" },
            { "frr", "Fris\u00f3n del Norte Simi" },
            { "fur", "Friulano Simi" },
            { "gaa", "Ga Simi" },
            { "gez", "Geez Simi" },
            { "gil", "Gilbertese Simi" },
            { "gor", "Gorontalo Simi" },
            { "gsw", "Alsaciano Simi" },
            { "guz", "Guz\u00ed Simi" },
            { "gwi", "Gwich\u02bcin Simi" },
            { "hai", "Haida Simi" },
            { "haw", "Hawaiano Simi" },
            { "hax", "Haida Meridional" },
            { "hil", "Hiligaynon Simi" },
            { "hmn", "Hmong Daw Simi" },
            { "hsb", "Alto Sorbio Simi" },
            { "hup", "Hupa Simi" },
            { "hur", "Halkomelem Simi" },
            { "iba", "Iban Simi" },
            { "ibb", "Ibibio Simi" },
            { "ikt", "Inuktitut Simi (Canad\u00e1 occidental)" },
            { "ilo", "Iloko Simi" },
            { "inh", "Ingush Simi" },
            { "jbo", "Lojban Simi" },
            { "jgo", "Ngomba Simi" },
            { "jmc", "Machame Simi" },
            { "kab", "Cabilio Simi" },
            { "kac", "Kachin Simi" },
            { "kaj", "Jju Simi" },
            { "kam", "Kamba Simi" },
            { "kbd", "Kabardiano Simi" },
            { "kcg", "Tyap Simi" },
            { "kde", "Makonde Simi" },
            { "kea", "Caboverdiano Simi" },
            { "kfo", "Koro Simi" },
            { "kgp", "Kaingang Simi" },
            { "kha", "Khasi Simi" },
            { "khq", "Koyra Chiini Simi" },
            { "kkj", "Kako Simi" },
            { "kln", "Kalenjin Simi" },
            { "kmb", "Kimbundu Simi" },
            { "kok", "Konkani Simi" },
            { "kpe", "Kpelle Simi" },
            { "krc", "Karachay-Balkar Simi" },
            { "krl", "Karelian Simi" },
            { "kru", "Kurukh Simi" },
            { "ksb", "Shambala Simi" },
            { "ksf", "Bafia Simi" },
            { "ksh", "K\u00f6lsch Simi" },
            { "kum", "Kumyk Simi" },
            { "kwk", "Kwak\u02bcwala Simi" },
            { "lad", "Ladino Simi" },
            { "lag", "Langi Simi" },
            { "lez", "Lezghian Simi" },
            { "lil", "Lillooet Simi" },
            { "lkt", "Lakota Simi" },
            { "lou", "Luisiana Criollo" },
            { "loz", "Lozi Simi" },
            { "lrc", "Luri septentrional Simi" },
            { "lsm", "Saamia Simi" },
            { "lua", "Luba-Lulua Simi" },
            { "lun", "Lunda Simi" },
            { "luo", "Luo Simi" },
            { "lus", "Mizo Simi" },
            { "luy", "Luyia Simi" },
            { "mad", "Madurese Simi" },
            { "mag", "Magahi Simi" },
            { "mai", "Maithili Simi" },
            { "mak", "Makasar Simi" },
            { "mas", "Masai Simi" },
            { "mdf", "Moksha Simi" },
            { "men", "Mende Simi" },
            { "mer", "Meru Simi" },
            { "mfe", "Mauriciano Simi" },
            { "mgh", "Makhuwa-Meetto Simi" },
            { "mgo", "Meta\u02bc Simi" },
            { "mic", "Mi'kmaq Simi" },
            { "min", "Minangkabau Simi" },
            { "mni", "Manipuri Simi" },
            { "moe", "Innu-aimun Simi" },
            { "moh", "Mohawk Simi" },
            { "mos", "Mossi Simi" },
            { "mua", "Mundang Simi" },
            { "mul", "Idiomas M\u00b4\u00faltiples Simi" },
            { "mus", "Muscogee Simi" },
            { "mwl", "Mirand\u00e9s Simi" },
            { "myv", "Erzya Simi" },
            { "mzn", "Mazandaran\u00ed Simi" },
            { "nap", "Neapolitan Simi" },
            { "naq", "Nama Simi" },
            { "nds", "Bajo Alem\u00e1n Simi" },
            { "new", "Newari Simi" },
            { "nia", "Nias Simi" },
            { "niu", "Niuean Simi" },
            { "nmg", "Kwasio Ngumba Simi" },
            { "nnh", "Ngiemboon Simi" },
            { "nog", "Nogai Simi" },
            { "nqo", metaValue_nqo },
            { "nso", "Sesotho Sa Leboa Simi" },
            { "nus", "Nuer Simi" },
            { "nyn", "Nyankole Simi" },
            { "ojb", "Ojibwa del noroeste Simi" },
            { "ojc", "Ojibwa Central" },
            { "ojs", "Oji-Cree Simi" },
            { "ojw", "Ojibwa Occidental" },
            { "oka", "Okanagan Simi" },
            { "pag", "Pangasinan Simi" },
            { "pam", "Pampanga Simi" },
            { "pap", "Papiamento Simi" },
            { "pau", "Palauan Simi" },
            { "pcm", "Pidgin Nigeriano Simi" },
            { "pis", "Pijin Simi" },
            { "pqm", "Maliseet-Passamaquoddy Simi" },
            { "prg", "Prusiano Simi" },
            { "quc", "K\u02bciche\u02bc Simi" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui Simi" },
            { "rar", "Rarotongan Simi" },
            { "rhg", "Rohingya Simi" },
            { "rof", "Rombo Simi" },
            { "rup", "Arrumano" },
            { "rwk", "Rwa Simi" },
            { "sad", "Sandawe Simi" },
            { "sah", "Sakha Simi" },
            { "saq", "Samburu Simi" },
            { "sat", "Santali Simi" },
            { "sba", "Ngambay Simi" },
            { "sbp", "Sangu Simi" },
            { "scn", "Siciliano Simi" },
            { "sco", "Scots Simi" },
            { "seh", "Sena Simi" },
            { "ses", "Koyraboro Senni Simi" },
            { "shi", "Tashelhit Simi" },
            { "shn", "Shan Simi" },
            { "slh", "Lushootseed Meridional" },
            { "sma", "Qulla Sami Simi" },
            { "smj", "Sami Lule Simi" },
            { "smn", "Sami Inari Simi" },
            { "sms", "Sami Skolt Simi" },
            { "snk", "Soninke Simi" },
            { "srn", "Sranan Tongo Simi" },
            { "str", "Straits Salish Simi" },
            { "suk", "Sukuma Simi" },
            { "swb", "Comorian Simi" },
            { "syr", "Siriaco Simi" },
            { "tce", "Tutchone Meridional" },
            { "tem", "Timne Simi" },
            { "teo", "Teso Simi" },
            { "tet", "Tetum Simi" },
            { "tgx", "Tagish Simi" },
            { "tht", "Tahltan Simi" },
            { "tig", "Tigre Simi" },
            { "tlh", "Klingon Simi" },
            { "tli", "Tlingit Simi" },
            { "tok", "Toki Pona Simi" },
            { "tpi", "Tok Pisin Simi" },
            { "trv", "Taroko Simi" },
            { "ttm", "Tutchone del Norte Simi" },
            { "tum", "Tumbuka Simi" },
            { "tvl", "Tuvalu Simi" },
            { "twq", "Tasawaq Simi" },
            { "tyv", "Tuviniano Simi" },
            { "tzm", "Tamazight Simi" },
            { "udm", "Udmurt Simi" },
            { "umb", "Umbundu Simi" },
            { "und", "Mana Riqsisqa Simi" },
            { "vai", metaValue_vai },
            { "vun", "Vunjo Simi" },
            { "wae", "Walser Simi" },
            { "wal", "Wolaytta Simi" },
            { "war", "Waray Simi" },
            { "wuu", "Wu Chino" },
            { "xal", "Kalmyk Simi" },
            { "xog", "Soga Simi" },
            { "yav", "Yangben Simi" },
            { "ybb", "Yemba Simi" },
            { "yrl", "Nheengatu Simi" },
            { "yue", "Canton\u00e9s Simi" },
            { "zgh", "Bereber Marroqu\u00ed Est\u00e1ndar Simi" },
            { "zun", "Zuni Simi" },
            { "zxx", "Manaraq simi yachana" },
            { "zza", "Zaza Simi" },
            { "Adlm", "Adlam Simi" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq qillqa" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "Bopomofo Simi" },
            { "Brai", "Braile" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Silabeo aborigen Simi (Canadiense unificado)" },
            { "Cher", "Cherokee Simi" },
            { "Cyrl", "Cirilico" },
            { "Deva", "Devanagari" },
            { "Ethi", "Etiope" },
            { "Geor", "Georgiano" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi Simi" },
            { "Hanb", "Han with Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hans", "Simplificado" },
            { "Hant", "Tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hrkt", "Japones silabico sananpakuna" },
            { "Jamo", "Jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "Katakana" },
            { "Khmr", "Khmer" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "Latin Simi" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "Meitei Mayek Simi" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki Simi" },
            { "Orya", metaValue_or },
            { "Rohg", "Hanifi Simi" },
            { "Sinh", metaValue_si },
            { "Sund", "Sundanese Simi" },
            { "Syrc", "Sirio Simi" },
            { "Taml", metaValue_ta },
            { "Telu", "Tegulu Simi" },
            { "Tfng", "Tifinagh Simi" },
            { "Thaa", "Thaana Simi" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", metaValue_ii },
            { "Zmth", "Matimatica Willay" },
            { "Zsye", "Emoji" },
            { "Zsym", "Unanchakuna" },
            { "Zxxx", "Mana qillqasqa" },
            { "Zyyy", "Common Simi" },
            { "Zzzz", "Mana yachasqa Qillqa" },
            { "fa_AF", "Dari Simi" },
            { "nl_BE", "Flamenco Simi" },
            { "sw_CD", "Suajili Simi (Congo (RDC))" },
            { "es_419", "Espa\u00f1ol Simi (Latino Am\u00e9rica)" },
            { "key.ca", "Intiwatana" },
            { "key.cf", "Imayna Qullqi kaynin" },
            { "key.co", "\u00d1iqinchana" },
            { "key.cu", "qullqi" },
            { "key.hc", "Ciclo de Horas (12 vs 24)" },
            { "key.lb", "Siqi paway kaynin" },
            { "key.ms", "Tupuy Kamay" },
            { "key.nu", "Yupaykuna" },
            { "zh_Hans", "Chino Simplificado Simi" },
            { "zh_Hant", "Chino Tradicional Simi" },
            { "type.ca.roc", "Minguo Intiwatana" },
            { "type.hc.h11", "12 hora kaynin (0\u201311)" },
            { "type.hc.h12", "12 hora kaynin (1\u201312)" },
            { "type.hc.h23", "24 hora kaynin (0\u201323)" },
            { "type.hc.h24", "24 hora kaynin (1\u201324)" },
            { "type.nu.arab", "Arabe Sananpakuna" },
            { "type.nu.armn", "Armenio Sananpakuna" },
            { "type.nu.beng", "Bangla Sananpakuna" },
            { "type.nu.cakm", "Chakma Sananpakuna" },
            { "type.nu.deva", "Devanagari Sananpakuna" },
            { "type.nu.ethi", "Etiope Sananpakuna" },
            { "type.nu.geor", "Gregoriano Yupaykuna" },
            { "type.nu.grek", "Griego Yupaykuna" },
            { "type.nu.gujr", "Gujarati Sananpakuna" },
            { "type.nu.guru", "Gurmukhi Sananpakuna" },
            { "type.nu.hans", "Uchuyachusqa Chino Yupaypakuna" },
            { "type.nu.hant", "Kikin Chino Yupaypakuna" },
            { "type.nu.hebr", "Hebreo Yupaykuna" },
            { "type.nu.java", "Javaneses Yupaykuna" },
            { "type.nu.jpan", "Japones Yupaykuna" },
            { "type.nu.khmr", "Khmer Sananpakuna" },
            { "type.nu.knda", "Kannada Sananpakuna" },
            { "type.nu.laoo", "Lao Sananpakuna" },
            { "type.nu.latn", "Occidental Sananpakuna" },
            { "type.nu.mlym", "Malayalam Sananpakuna" },
            { "type.nu.mtei", "Meetei Mayek Yupaykuna" },
            { "type.nu.mymr", "Myanmar Sananpakuna" },
            { "type.nu.olck", "Ol Chiki Yupaykuna" },
            { "type.nu.orya", "Odia Sananpakuna" },
            { "type.nu.taml", "Kikin Tamil Yupaykuna" },
            { "type.nu.telu", "Telegu Sananpakuna" },
            { "type.nu.thai", "Thai Sananpakuna" },
            { "type.nu.tibt", "Tibetano Sananpakuna" },
            { "type.nu.vaii", "Vai Yupaykuna" },
            { "type.ca.dangi", "Dangi Intiwatana" },
            { "type.co.ducet", "\u00d1awpaqchasqa Unicode Nisqa \u00d1iqinchana" },
            { "type.lb.loose", "Siqi paway chinkachiy kaynin" },
            { "type.nu.roman", "Romano Sananpakuna" },
            { "type.ca.coptic", "Copto Intiwatana" },
            { "type.ca.hebrew", "Hebreo Intiwatana" },
            { "type.co.search", "Llapanpaq maskana" },
            { "type.lb.normal", "Siqi paway Normal kaynin" },
            { "type.lb.strict", "Siqi paway Chiqa kaynin" },
            { "type.ms.metric", "Metrico Kamay" },
            { "type.ca.chinese", "Chino Intiwatana" },
            { "type.ca.islamic", "Hijri Intiwatana" },
            { "type.ca.iso8601", "ISO-8601 Intiwatana" },
            { "type.ca.persian", "Persa Intiwatana" },
            { "type.cf.account", "Yupana Qullqi imayna kaynin" },
            { "type.nu.arabext", "Arabe Mirachisqa Sananpakuna" },
            { "type.nu.armnlow", "Armenio Uchuy Sananpakuna" },
            { "type.nu.greklow", "Griego Uchuy Yupaykuna" },
            { "type.nu.hanidec", "Chunkachasqa Chino Yupaykuna" },
            { "type.nu.hansfin", "Uchuyachisqa Qullqi Chino Yupaypakuna" },
            { "type.nu.hantfin", "Kikin Qullqi Chino Yupaypakuna" },
            { "type.nu.jpanfin", "Japones Qullqi Yupaykuna" },
            { "type.nu.tamldec", "Tamil Sananpakuna" },
            { "type.ca.buddhist", "Budista Intiwatana" },
            { "type.ca.ethiopic", "Etiope Intiwatana" },
            { "type.ca.japanese", "Japones Intiwatana" },
            { "type.cf.standard", "Estandar nisqa qullqi imayna kaynin" },
            { "type.co.standard", "Estandar nisqa \u00d1iqinchana" },
            { "type.ms.uksystem", "Metrico Ingles Kamay" },
            { "type.ms.ussystem", "Metrico Americano Kamay" },
            { "type.nu.fullwide", "Llapan kinray Sananpakuna" },
            { "type.nu.romanlow", "Roman Uchuy Yupaykuna" },
            { "type.ca.gregorian", "Gregoriano Intiwatana" },
            { "type.ca.islamic-civil", "Hijri Intiwatana (tabular, epoca civil)" },
            { "type.ca.islamic-umalqura", "Hijri Intiwatana (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Et\u00edope Amete Alem Intiwatana" },
        };
        return data;
    }
}
