/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabiska";
        final String metaValue_hy = "armeniska";
        final String metaValue_ae = "avestiska";
        final String metaValue_ban = "balinesiska";
        final String metaValue_bax = "bamunska";
        final String metaValue_zbl = "blissymboler";
        final String metaValue_bug = "buginesiska";
        final String metaValue_ccp = "chakma";
        final String metaValue_cop = "koptiska";
        final String metaValue_gez = "etiopiska";
        final String metaValue_ka = "georgiska";
        final String metaValue_got = "gotiska";
        final String metaValue_el = "grekiska";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebreiska";
        final String metaValue_ja = "japanska";
        final String metaValue_ko = "koreanska";
        final String metaValue_lo = "laotiska";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongoliska";
        final String metaValue_my = "burmesiska";
        final String metaValue_new = "newariska";
        final String metaValue_nqo = "n-k\u00e5";
        final String metaValue_or = "oriya";
        final String metaValue_osa = "osage";
        final String metaValue_phn = "feniciska";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "singalesiska";
        final String metaValue_sog = "sogdiska";
        final String metaValue_su = "sundanesiska";
        final String metaValue_syr = "syriska";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thail\u00e4ndska";
        final String metaValue_bo = "tibetanska";
        final String metaValue_uga = "ugaritiska";
        final String metaValue_vai = "vaj";
        final String metaValue_peo = "fornpersiska";
        final Object[][] data = new Object[][] {
            { "001", "v\u00e4rlden" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "Sydamerika" },
            { "009", "Oceanien" },
            { "011", "V\u00e4stafrika" },
            { "013", "Centralamerika" },
            { "014", "\u00d6stafrika" },
            { "015", "Nordafrika" },
            { "017", "Centralafrika" },
            { "018", "s\u00f6dra Afrika" },
            { "019", "Nord- och Sydamerika" },
            { "021", "Norra Amerika" },
            { "029", "Karibien" },
            { "030", "\u00d6stasien" },
            { "034", "Sydasien" },
            { "035", "Sydostasien" },
            { "039", "Sydeuropa" },
            { "053", "Australasien" },
            { "054", "Melanesien" },
            { "057", "Mikronesiska \u00f6arna" },
            { "061", "Polynesien" },
            { "142", "Asien" },
            { "143", "Centralasien" },
            { "145", "V\u00e4stasien" },
            { "150", "Europa" },
            { "151", "\u00d6steuropa" },
            { "154", "Nordeuropa" },
            { "155", "V\u00e4steuropa" },
            { "202", "Subsahariska Afrika" },
            { "419", "Latinamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "F\u00f6renade Arabemiraten" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua och Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "\u00d6sterrike" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "AZ", "Azerbajdzjan" },
            { "BA", "Bosnien och Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgien" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S:t Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibiska Nederl\u00e4nderna" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f6n" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokos\u00f6arna" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralafrikanska republiken" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "Elfenbenskusten" },
            { "CK", "Cook\u00f6arna" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f6n" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Jul\u00f6n" },
            { "CY", "Cypern" },
            { "CZ", "Tjeckien" },
            { "DE", "Tyskland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Dominikanska republiken" },
            { "DZ", "Algeriet" },
            { "EA", "Ceuta och Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypten" },
            { "EH", "V\u00e4stsahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Etiopien" },
            { "EU", "Europeiska unionen" },
            { "EZ", "euroomr\u00e5det" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f6arna" },
            { "FM", "Mikronesien" },
            { "FO", "F\u00e4r\u00f6arna" },
            { "FR", "Frankrike" },
            { "GA", "Gabon" },
            { "GB", "Storbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorialguinea" },
            { "GR", "Grekland" },
            { "GS", "Sydgeorgien och Sydsandwich\u00f6arna" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong SAR" },
            { "HM", "Heard\u00f6n och McDonald\u00f6arna" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "HT", "Haiti" },
            { "HU", "Ungern" },
            { "IC", "Kanarie\u00f6arna" },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Brittiska territoriet i Indiska oceanen" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordanien" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorerna" },
            { "KN", "S:t Kitts och Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "Sydkorea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman\u00f6arna" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "S:t Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "LY", "Libyen" },
            { "MA", "Marocko" },
            { "MC", "Monaco" },
            { "MD", "Moldavien" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall\u00f6arna" },
            { "MK", "Nordmakedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongoliet" },
            { "MO", "Macao SAR" },
            { "MP", "Nordmarianerna" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiverna" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mo\u00e7ambique" },
            { "NA", "Namibia" },
            { "NC", "Nya Kaledonien" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f6n" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederl\u00e4nderna" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nya Zeeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franska Polynesien" },
            { "PG", "Papua Nya Guinea" },
            { "PH", "Filippinerna" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "S:t Pierre och Miquelon" },
            { "PN", "Pitcairn\u00f6arna" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinska territorierna" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "yttre \u00f6ar i Oceanien" },
            { "RE", "R\u00e9union" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "RU", "Ryssland" },
            { "RW", "Rwanda" },
            { "SA", "Saudiarabien" },
            { "SB", "Salomon\u00f6arna" },
            { "SC", "Seychellerna" },
            { "SD", "Sudan" },
            { "SE", "Sverige" },
            { "SG", "Singapore" },
            { "SH", "S:t Helena" },
            { "SI", "Slovenien" },
            { "SJ", "Svalbard och Jan Mayen" },
            { "SK", "Slovakien" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sydsudan" },
            { "ST", "S\u00e3o Tom\u00e9 och Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- och Caicos\u00f6arna" },
            { "TD", "Tchad" },
            { "TF", "Franska sydterritorierna" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "TK", "Tokelau\u00f6arna" },
            { "TL", "\u00d6sttimor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisien" },
            { "TO", "Tonga" },
            { "TR", "Turkiet" },
            { "TT", "Trinidad och Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "USA:s yttre \u00f6ar" },
            { "UN", "F\u00f6renta Nationerna" },
            { "US", "USA" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikanstaten" },
            { "VC", "S:t Vincent och Grenadinerna" },
            { "VE", "Venezuela" },
            { "VG", "Brittiska Jungfru\u00f6arna" },
            { "VI", "Amerikanska Jungfru\u00f6arna" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis- och Futuna\u00f6arna" },
            { "WS", "Samoa" },
            { "XA", "fejkade accenter (f\u00f6r test)" },
            { "XB", "fejkad bidi (f\u00f6r test)" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sydafrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ok\u00e4nd region" },
            { "aa", "afar" },
            { "ab", "abchaziska" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhariska" },
            { "an", "aragonesiska" },
            { "ar", metaValue_ar },
            { "as", "assamesiska" },
            { "av", "avariska" },
            { "ay", "aymara" },
            { "az", "azerbajdzjanska" },
            { "ba", "basjkiriska" },
            { "be", "belarusiska" },
            { "bg", "bulgariska" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "br", "bretonska" },
            { "bs", "bosniska" },
            { "ca", "katalanska" },
            { "ce", "tjetjenska" },
            { "ch", "chamorro" },
            { "co", "korsikanska" },
            { "cr", "cree" },
            { "cs", "tjeckiska" },
            { "cu", "kyrkslaviska" },
            { "cv", "tjuvasjiska" },
            { "cy", "walesiska" },
            { "da", "danska" },
            { "de", "tyska" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "engelska" },
            { "eo", "esperanto" },
            { "es", "spanska" },
            { "et", "estniska" },
            { "eu", "baskiska" },
            { "fa", "persiska" },
            { "ff", "fulani" },
            { "fi", "finska" },
            { "fj", "fijianska" },
            { "fo", "f\u00e4r\u00f6iska" },
            { "fr", "franska" },
            { "fy", "v\u00e4stfrisiska" },
            { "ga", "iriska" },
            { "gd", "skotsk g\u00e4liska" },
            { "gl", "galiciska" },
            { "gn", "guaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "kroatiska" },
            { "ht", "haitiska" },
            { "hu", "ungerska" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiska" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "szezuan i" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "isl\u00e4ndska" },
            { "it", "italienska" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "javanesiska" },
            { "ka", metaValue_ka },
            { "kg", "kikongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakiska" },
            { "kl", "gr\u00f6nl\u00e4ndska" },
            { "km", "kambodjanska" },
            { "kn", "kannada" },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiriska" },
            { "ku", "kurdiska" },
            { "kv", "kome" },
            { "kw", "korniska" },
            { "ky", "kirgiziska" },
            { "la", "latin" },
            { "lb", "luxemburgiska" },
            { "lg", "luganda" },
            { "li", "limburgiska" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "litauiska" },
            { "lu", "luba-katanga" },
            { "lv", "lettiska" },
            { "mg", "malagassiska" },
            { "mh", "marshalliska" },
            { "mi", "maori" },
            { "mk", "makedonska" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malajiska" },
            { "mt", "maltesiska" },
            { "my", metaValue_my },
            { "na", "nauruanska" },
            { "nb", "norskt bokm\u00e5l" },
            { "nd", "nordndebele" },
            { "ne", "nepalesiska" },
            { "ng", "ndonga" },
            { "nl", "nederl\u00e4ndska" },
            { "nn", "nynorska" },
            { "no", "norska" },
            { "nr", "sydndebele" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "occitanska" },
            { "oj", "odjibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetiska" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polska" },
            { "ps", "afghanska" },
            { "pt", "portugisiska" },
            { "qu", "quechua" },
            { "rm", "r\u00e4toromanska" },
            { "rn", "rundi" },
            { "ro", "rum\u00e4nska" },
            { "ru", "ryska" },
            { "rw", "kinjarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardinska" },
            { "sd", "sindhi" },
            { "se", "nordsamiska" },
            { "sg", "sango" },
            { "sh", "serbokroatiska" },
            { "si", metaValue_si },
            { "sk", "slovakiska" },
            { "sl", "slovenska" },
            { "sm", "samoanska" },
            { "sn", "shona" },
            { "so", "somaliska" },
            { "sq", "albanska" },
            { "sr", "serbiska" },
            { "ss", "swati" },
            { "st", "sydsotho" },
            { "su", metaValue_su },
            { "sv", "svenska" },
            { "sw", "swahili" },
            { "ta", "tamil" },
            { "te", metaValue_te },
            { "tg", "tadzjikiska" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "tk", "turkmeniska" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganska" },
            { "tr", "turkiska" },
            { "ts", "tsonga" },
            { "tt", "tatariska" },
            { "tw", "twi" },
            { "ty", "tahitiska" },
            { "ug", "uiguriska" },
            { "uk", "ukrainska" },
            { "ur", "urdu" },
            { "uz", "uzbekiska" },
            { "ve", "venda" },
            { "vi", "vietnamesiska" },
            { "vo", "volap\u00fck" },
            { "wa", "vallonska" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddisch" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "kinesiska" },
            { "zu", "zulu" },
            { "ace", "acehnesiska" },
            { "ach", "acholi" },
            { "ada", "adangme" },
            { "ady", "adygeiska" },
            { "aeb", "tunisisk arabiska" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadiska" },
            { "akz", "Alabama-muskogee" },
            { "ale", "aleutiska" },
            { "aln", "gegiska" },
            { "alt", "sydaltaiska" },
            { "ang", "fornengelska" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameiska" },
            { "arn", "mapudungun" },
            { "aro", "araoniska" },
            { "arp", "arapaho" },
            { "arq", "algerisk arabiska" },
            { "ars", "najdiarabiska" },
            { "arw", "arawakiska" },
            { "ary", "marockansk arabiska" },
            { "arz", "egyptisk arabiska" },
            { "asa", "asu" },
            { "ase", "amerikanskt teckenspr\u00e5k" },
            { "ast", "asturiska" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "baluchiska" },
            { "ban", metaValue_ban },
            { "bar", "bayerska" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbc", "batak-toba" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bew", "betawiska" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "bagada" },
            { "bgc", "hariyanvi" },
            { "bgn", "v\u00e4stbaluchiska" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjariska" },
            { "bkm", "bamekon" },
            { "bla", "siksika" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahuiska" },
            { "brx", "bodo" },
            { "bss", "bakossi" },
            { "bua", "burj\u00e4tiska" },
            { "bug", metaValue_bug },
            { "bum", "boulou" },
            { "byn", "blin" },
            { "byv", "bagangte" },
            { "cad", "caddo" },
            { "car", "karibiska" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukesiska" },
            { "chm", "mariska" },
            { "chn", "chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokesiska" },
            { "chy", "cheyenne" },
            { "ckb", "centralkurdiska" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "kapisnon" },
            { "crg", "michif" },
            { "crh", "krimtatariska" },
            { "crj", "sydostcree" },
            { "crk", "sl\u00e4ttcree" },
            { "crl", "nordost-cree" },
            { "crm", "moose cree" },
            { "crr", "Carolina-algonkinska" },
            { "crs", "seychellisk kreol" },
            { "csb", "kasjubiska" },
            { "csw", "tr\u00e4skcree" },
            { "dak", "dakota" },
            { "dar", "darginska" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slavej" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "l\u00e5gsorbiska" },
            { "dtp", "centraldusun" },
            { "dua", "duala" },
            { "dum", "medelnederl\u00e4ndska" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emiliska" },
            { "egy", "fornegyptiska" },
            { "eka", "ekajuk" },
            { "elx", "elamitiska" },
            { "enm", "medelengelska" },
            { "esu", "centralalaskisk jupiska" },
            { "ewo", "ewondo" },
            { "ext", "extremaduriska" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippinska" },
            { "fit", "me\u00e4nkieli" },
            { "fon", "fonspr\u00e5ket" },
            { "frc", "cajun-franska" },
            { "frm", "medelfranska" },
            { "fro", "fornfranska" },
            { "frp", "frankoprovensalska" },
            { "frr", "nordfrisiska" },
            { "frs", "\u00f6stfrisiska" },
            { "fur", "friulianska" },
            { "gaa", "g\u00e3" },
            { "gag", "gagauziska" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "zoroastrisk dari" },
            { "gez", metaValue_gez },
            { "gil", "gilbertiska" },
            { "glk", "gilaki" },
            { "gmh", "medelh\u00f6gtyska" },
            { "goh", "fornh\u00f6gtyska" },
            { "gom", "Goa-konkani" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "forngrekiska" },
            { "gsw", "schweizertyska" },
            { "guc", "wayuu" },
            { "gur", "farefare" },
            { "guz", "gusii" },
            { "gwi", "gwichin" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "hawaiiska" },
            { "hax", "sydhaida" },
            { "hif", "Fiji-hindi" },
            { "hil", "hiligaynon" },
            { "hit", "hettitiska" },
            { "hmn", "hmongspr\u00e5k" },
            { "hsb", "h\u00f6gsorbiska" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "ibanska" },
            { "ibb", "ibibio" },
            { "ikt", "inuktun" },
            { "ilo", "iloko" },
            { "inh", "ingusjiska" },
            { "izh", "ingriska" },
            { "jam", "jamaikansk engelsk kreol" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "kimashami" },
            { "jpr", "judisk persiska" },
            { "jrb", "judisk arabiska" },
            { "jut", "jyll\u00e4ndska" },
            { "kaa", "karakalpakiska" },
            { "kab", "kabyliska" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardinska" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverdiska" },
            { "ken", "kenjang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanesiska" },
            { "khq", "Timbuktu-songhai" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "mkako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permjakiska" },
            { "kok", "konkani" },
            { "kos", "kosreanska" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karelska" },
            { "kru", "kurukh" },
            { "ksb", "kisambaa" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lniska" },
            { "kum", "kumykiska" },
            { "kut", "kutenaj" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghien" },
            { "lfn", "lingua franca nova" },
            { "lij", "liguriska" },
            { "lil", "lillooet" },
            { "liv", "livoniska" },
            { "lkt", "lakota" },
            { "lmo", "lombardiska" },
            { "lol", "mongo" },
            { "lou", "louisiana-kreol" },
            { "loz", "lozi" },
            { "lrc", "nordluri" },
            { "lsm", "saamia" },
            { "ltg", "lettgalliska" },
            { "lua", "luba-lulua" },
            { "lui", "luise\u00f1o" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luhya" },
            { "lzh", "litter\u00e4r kineiska" },
            { "lzz", "laziska" },
            { "mad", "maduresiska" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mande" },
            { "mas", "massajiska" },
            { "mde", "maba" },
            { "mdf", "moksja" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "mauritansk kreol" },
            { "mga", "medeliriska" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "mi\u2019kmaq" },
            { "min", "minangkabau" },
            { "mnc", "manchuriska" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "v\u00e4stmariska" },
            { "mua", "mundang" },
            { "mul", "flera spr\u00e5k" },
            { "mus", "muskogee" },
            { "mwl", "mirandesiska" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erjya" },
            { "mzn", "mazanderani" },
            { "nan", "min nan" },
            { "nap", "napolitanska" },
            { "naq", "nama" },
            { "nds", "l\u00e5gtyska" },
            { "new", metaValue_new },
            { "nia", "nias" },
            { "niu", "niueanska" },
            { "njo", "ao-naga" },
            { "nmg", "kwasio" },
            { "nnh", "bamilek\u00e9-ngiemboon" },
            { "nog", "nogai" },
            { "non", "fornnordiska" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "nordsotho" },
            { "nus", "nuer" },
            { "nwc", "klassisk newariska" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "nordv\u00e4stojibwa" },
            { "ojc", "ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "v\u00e4stojibwe" },
            { "oka", "okanagan" },
            { "osa", metaValue_osa },
            { "ota", "ottomanska" },
            { "pag", "pangasinan" },
            { "pal", "medelpersiska" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "pikardiska" },
            { "pcm", "nigeriansk pidgin" },
            { "pdc", "Pennsylvaniatyska" },
            { "pdt", "mennonitisk l\u00e5gtyska" },
            { "peo", metaValue_peo },
            { "pfl", "Pfalz-tyska" },
            { "phn", metaValue_phn },
            { "pis", "pidginspr\u00e5k" },
            { "pms", "piemontesiska" },
            { "pnt", "pontiska" },
            { "pon", "pohnpeiska" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "fornpreussiska" },
            { "pro", "fornprovensalska" },
            { "quc", "quich\u00e9" },
            { "qug", "Chimborazo-h\u00f6glandskichwa" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonganska" },
            { "rgn", "romagnol" },
            { "rhg", "ru\u00e1ingga" },
            { "rif", "riffianska" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotum\u00e4nska" },
            { "rue", "rusyn" },
            { "rug", "rovianska" },
            { "rup", "arum\u00e4nska" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakutiska" },
            { "sam", "samaritanska" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilianska" },
            { "sco", "skotska" },
            { "sdc", "sassaresisk sardiska" },
            { "sdh", "sydkurdiska" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkup" },
            { "ses", "songhai" },
            { "sga", "forniriska" },
            { "sgs", "samogitiska" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "Tchad-arabiska" },
            { "sid", "sidamo" },
            { "slh", "sydlushootseed" },
            { "sli", "l\u00e5gsilesiska" },
            { "sly", "selayar" },
            { "sma", "sydsamiska" },
            { "smj", "lulesamiska" },
            { "smn", "enaresamiska" },
            { "sms", "skoltsamiska" },
            { "snk", "soninke" },
            { "sog", metaValue_sog },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "stq", "saterfrisiska" },
            { "str", "sundsalishanska" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriska" },
            { "swb", "shimaor\u00e9" },
            { "syc", "klassisk syriska" },
            { "syr", metaValue_syr },
            { "szl", "silesiska" },
            { "tce", "sydtutchone" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tivi" },
            { "tkl", "tokelauiska" },
            { "tkr", "tsakhur" },
            { "tlh", "klingonska" },
            { "tli", "tlingit" },
            { "tly", "talysh" },
            { "tmh", "tamashek" },
            { "tog", "nyasatonganska" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "tsakodiska" },
            { "tsi", "tsimshian" },
            { "ttm", "nordtutchone" },
            { "ttt", "muslimsk tatariska" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluanska" },
            { "twq", "tasawaq" },
            { "tyv", "tuviniska" },
            { "tzm", "centralmarockansk tamazight" },
            { "udm", "udmurtiska" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "obest\u00e4mt spr\u00e5k" },
            { "vai", metaValue_vai },
            { "vec", "venetianska" },
            { "vep", "veps" },
            { "vls", "v\u00e4stflaml\u00e4ndska" },
            { "vmf", "Main-frankiska" },
            { "vot", "votiska" },
            { "vro", "v\u00f5ru" },
            { "vun", "vunjo" },
            { "wae", "walsertyska" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmuckiska" },
            { "xmf", "mingrelianska" },
            { "xog", "lusoga" },
            { "yao", "kiyao" },
            { "yap", "japetiska" },
            { "yav", "yangben" },
            { "ybb", "bamilek\u00e9-jemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonesiska" },
            { "zap", "zapotek" },
            { "zbl", metaValue_zbl },
            { "zea", "zeel\u00e4ndska" },
            { "zen", "zenaga" },
            { "zgh", "marockansk standard-tamazight" },
            { "zun", "zuni" },
            { "zxx", "inget spr\u00e5kligt inneh\u00e5ll" },
            { "zza", "zazaiska" },
            { "Adlm", "adlamiska" },
            { "Afak", "afakiska" },
            { "Aghb", "kaukasiska albanska" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "imperisk arameiska" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", "bassaiska vah" },
            { "Batk", "batak" },
            { "Beng", "bengaliska" },
            { "Bhks", "bhaiksukiska" },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "brami" },
            { "Brai", "punktskrift" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "kanadensiska stavelsetecken" },
            { "Cari", "kariska" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Chrs", "khwarezmiska" },
            { "Cirt", "cirt" },
            { "Copt", metaValue_cop },
            { "Cpmn", "cypro-minoisk skrift" },
            { "Cprt", "cypriotiska" },
            { "Cyrl", "kyrilliska" },
            { "Cyrs", "fornkyrkoslavisk kyrilliska" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogriska" },
            { "Dsrt", "deseret" },
            { "Dupl", "Duploy\u00e9stenografiska" },
            { "Egyd", "demotiska" },
            { "Egyh", "hieratiska" },
            { "Egyp", "egyptiska hieroglyfer" },
            { "Elba", "elbasiska" },
            { "Elym", "elymaiska" },
            { "Ethi", metaValue_gez },
            { "Geok", "kutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitiska" },
            { "Gong", "gunjalgondiska" },
            { "Gonm", "masaram-gondi" },
            { "Goth", metaValue_got },
            { "Gran", "gammaltamilska" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhiska" },
            { "Hanb", "han med bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanun\u00f3\u2019o" },
            { "Hans", "f\u00f6renklad" },
            { "Hant", "traditionell" },
            { "Hatr", "hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "hittitiska hieroglyfer" },
            { "Hmng", "pahaw mong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "katakana/hiragana" },
            { "Hung", "fornungerska" },
            { "Inds", "indus" },
            { "Ital", "fornitaliska" },
            { "Jamo", "jamo" },
            { "Java", "javanska" },
            { "Jpan", metaValue_ja },
            { "Jurc", "jurchenska" },
            { "Kali", "kaya li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshti" },
            { "Khmr", "khmeriska" },
            { "Khoj", "khojkiska" },
            { "Kits", "khitanska" },
            { "Knda", "kanaresiska" },
            { "Kore", metaValue_ko },
            { "Kpel", "kpell\u00e9" },
            { "Kthi", "kaithiska" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "frakturlatin" },
            { "Latg", "gaeliskt latin" },
            { "Latn", "latinska" },
            { "Lepc", "rong" },
            { "Limb", "limbu" },
            { "Lina", "linj\u00e4r A" },
            { "Linb", "linj\u00e4r B" },
            { "Lisu", "Fraser" },
            { "Loma", "loma" },
            { "Lyci", "lykiska" },
            { "Lydi", "lydiska" },
            { "Mahj", "mahajaniska" },
            { "Maka", "makasariska" },
            { "Mand", "manda\u00e9iska" },
            { "Mani", "manikeanska" },
            { "Marc", "marchenska" },
            { "Maya", "mayahieroglyfer" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "kursiv-meroitiska" },
            { "Mero", "meroitiska" },
            { "Mlym", metaValue_ml },
            { "Modi", "modiska" },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mroo", "mru" },
            { "Mtei", "meitei-mayek" },
            { "Mult", "multaniska" },
            { "Mymr", metaValue_my },
            { "Nand", "nandinagari" },
            { "Narb", "fornnordarabiska" },
            { "Nbat", "nabateiska" },
            { "Newa", metaValue_new },
            { "Nkgb", "naxi geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fcshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol-chiki" },
            { "Orkh", "orkon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "osmanja" },
            { "Palm", "palmyreniska" },
            { "Pauc", "Pau Cin Hau-skrift" },
            { "Perm", "fornpermiska" },
            { "Phag", "phags-pa" },
            { "Phli", "tidig pahlavi" },
            { "Phlp", "psaltaren-pahlavi" },
            { "Phlv", "bokpahlavi" },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollardtecken" },
            { "Prti", "tidig parthianska" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifiska" },
            { "Roro", "rongo-rongo" },
            { "Runr", "runor" },
            { "Samr", "samaritiska" },
            { "Sara", "sarati" },
            { "Sarb", "fornsydarabiska" },
            { "Saur", metaValue_saz },
            { "Sgnw", "teckningsskrift" },
            { "Shaw", "shawiska" },
            { "Shrd", "sharada" },
            { "Sidd", "siddhamska" },
            { "Sind", "sindhiska" },
            { "Sinh", metaValue_si },
            { "Sogd", metaValue_sog },
            { "Sogo", "gammalsogdiska" },
            { "Sora", "sora sompeng" },
            { "Soyo", "soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "estrangelosyriska" },
            { "Syrj", "v\u00e4stsyriska" },
            { "Syrn", "\u00f6stsyriska" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takritiska" },
            { "Tale", "tai le" },
            { "Talu", "tai lue" },
            { "Taml", "tamilska" },
            { "Tang", "tangutiska" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinaghiska" },
            { "Tglg", metaValue_tl },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "synligt tal" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancho" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "sumero-akkadisk kilskrift" },
            { "Yezi", "yazidiska" },
            { "Yiii", "yi" },
            { "Zanb", "zanabazar kvadratisk skrift" },
            { "Zinh", "\u00e4rvda" },
            { "Zmth", "matematisk notation" },
            { "Zsye", "emoji" },
            { "Zsym", "symboler" },
            { "Zxxx", "oskrivet spr\u00e5k" },
            { "Zyyy", "gemensamma" },
            { "Zzzz", "ok\u00e4nt skriftsystem" },
            { "de_AT", "\u00f6sterrikisk tyska" },
            { "de_CH", "schweizisk h\u00f6gtyska" },
            { "en_AU", "australisk engelska" },
            { "en_CA", "kanadensisk engelska" },
            { "en_GB", "brittisk engelska" },
            { "en_US", "amerikansk engelska" },
            { "es_ES", "europeisk spanska" },
            { "es_MX", "mexikansk spanska" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadensisk franska" },
            { "fr_CH", "schweizisk franska" },
            { "nl_BE", "flaml\u00e4ndska" },
            { "pt_BR", "brasiliansk portugisiska" },
            { "pt_PT", "europeisk portugisiska" },
            { "ro_MD", "moldaviska" },
            { "sw_CD", "Kongo-swahili" },
            { "%%1901", "traditionell tysk stavning" },
            { "%%1994", "1994 \u00e5rs resisk stavning" },
            { "%%1996", "1996 \u00e5rs reformerad tysk stavning" },
            { "ar_001", "modern standardarabiska" },
            { "es_419", "latinamerikansk spanska" },
            { "key.ca", "kalender" },
            { "key.cf", "valutaformat" },
            { "key.co", "sorteringsordning" },
            { "key.cu", "valuta" },
            { "key.hc", "12- eller 24-timmarsklocka" },
            { "key.lb", "radbrytningstyp" },
            { "key.ms", "enhetssystem" },
            { "key.nu", "siffror" },
            { "key.tz", "Tidszon" },
            { "key.va", "Spr\u00e5kvariant" },
            { "nds_NL", "l\u00e5gsaxiska" },
            { "%%ALUKU", "Aluku-dialekt" },
            { "%%BARLA", "barlavento-dialekt" },
            { "%%BISKE", "Bila-dialekt" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", "kornisk engelska" },
            { "%%JAUER", "jauer-dialekt" },
            { "%%KKCOR", "vanlig stavning" },
            { "%%KSCOR", "standardstavning" },
            { "%%LIPAW", "Lipovaz-dialekt" },
            { "%%NEDIS", "natisonsk dialekt" },
            { "%%NJIVA", "Njiva-dialekt" },
            { "%%NULIK", "nulik-stavning" },
            { "%%OSOJS", "Osojane-dialekt" },
            { "%%POSIX", "Posix" },
            { "%%PUTER", "puter-dialekt" },
            { "%%RIGIK", "klassisk volap\u00fck" },
            { "%%ROZAJ", "resisk dialekt" },
            { "%%RUMGR", "grischun-dialekt" },
            { "%%SAAHO", "saho-dialekt" },
            { "%%SOLBA", "Solbica-dialekt" },
            { "%%SOTAV", "sotavento-dialekt" },
            { "%%UCCOR", "unifierad stavning" },
            { "hi_Latn", "hindi (latinsk)" },
            { "zh_Hans", "f\u00f6renklad kinesiska" },
            { "zh_Hant", "traditionell kinesiska" },
            { "%%AO1990", "stavning enligt 1990 \u00e5rs \u00f6verenskommelse" },
            { "%%ARANES", "aranesiska (occitanska)" },
            { "%%ASANTE", "asante (twi)" },
            { "%%AUVERN", "auvergniska (occitanska)" },
            { "%%CISAUP", "cisalpinska (occitanska)" },
            { "%%CREISS", "croissant-occitanska" },
            { "%%DAJNKO", "Dajnko-alfabetet" },
            { "%%EKAVSK", "ekavisk dialekt" },
            { "%%FONIPA", "internationell fonetisk notation - IPA" },
            { "%%FONUPA", "uralisk fonetisk notation" },
            { "%%GASCON", "Gascogne-occitanska" },
            { "%%GRITAL", "italiensk-inspirerad occitanska" },
            { "%%NDYUKA", "Ndyuka-dialekt" },
            { "%%NICARD", "Nice-occitanska" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%SIMPLE", "l\u00e4tt" },
            { "%%TARASK", "Taraskievika-stavning" },
            { "%%UCRCOR", "reviderad unifierad stavning" },
            { "%%ULSTER", "Ulster-dialekt" },
            { "%%UNIFON", "unifon-skrift" },
            { "%%ABL1943", "1943 \u00e5rs stavning" },
            { "%%AKUAPEM", "akapuem (twi)" },
            { "%%ALALC97", "1997 \u00e5rs ALA-LC" },
            { "%%AREVELA", "\u00f6starmeniska" },
            { "%%AREVMDA", "v\u00e4starmeniska" },
            { "%%BALANKA", "balanka-dialekt" },
            { "%%BAUDDHA", "bauddha-dialekt" },
            { "%%BOHORIC", "Bohori\u010d-alfabetet" },
            { "%%EMODENG", "tidig modern engelska" },
            { "%%FONNAPA", "nordamerikanskt fonetiskt alfabet" },
            { "%%GRCLASS", "klassisk occitanska" },
            { "%%GRMISTR", "Mistral-occitanska" },
            { "%%HEPBURN", "Hepburn" },
            { "%%ITIHASA", "itihasa-dialekt" },
            { "%%LAUKIKA", "laukika-dialekt" },
            { "%%LEMOSIN", "Limousin-occitanska" },
            { "%%METELKO", "Metelko-alfabetet" },
            { "%%MONOTON", "monotonisk stavning" },
            { "%%PAHAWH2", "pahawh hmong andra steget reducerad stavning" },
            { "%%PAHAWH3", "pahawh hmong tredje steget reducerad stavning" },
            { "%%PAHAWH4", "pahawh hmong sista steget reducerad stavning" },
            { "%%POLYTON", "polytonisk stavning" },
            { "%%PROVENC", "provensalska" },
            { "%%REVISED", "reformerad stavning" },
            { "%%SURSILV", "sursilvan-dialekt" },
            { "%%SUTSILV", "sutsilvan-dialekt" },
            { "%%VAIDIKA", "vedisk dialekt" },
            { "%%1606NICT", "1606 \u00e5rs stavning" },
            { "%%1694ACAD", "1694 \u00e5rs stavning" },
            { "%%1959ACAD", "1959 \u00e5rs stavning" },
            { "%%BAKU1926", "1926 \u00e5rs stavning" },
            { "%%BASICENG", "Ogdens basic english" },
            { "%%BISCAYAN", "Biscaya-dialekt" },
            { "%%BORNHOLM", "Bornholm" },
            { "%%COLB1945", "stavning enligt 1945 \u00e5rs konvention mellan Portugal och Brasilien" },
            { "%%FONKIRSH", "Kirshenbaums fonetiska alfabet" },
            { "%%FONXSAMP", "X-SAMPA fonetisk notation" },
            { "%%HOGNORSK", "h\u00f6gnorsk dialekt" },
            { "%%HSISTEMO", "h-system" },
            { "%%IJEKAVSK", "ijekavisk dialekt" },
            { "%%IVANCHOV", "bulgariska i 1899 \u00e5rs stavning" },
            { "%%JYUTPING", "jyutping" },
            { "%%KOCIEWIE", "kociewiska" },
            { "%%LENGADOC", "languedociska" },
            { "%%LUNA1918", "1918 \u00e5rs stavning" },
            { "%%NEWFOUND", "Newfoundland-engelska" },
            { "%%OXENDICT", "Oxford-stavning" },
            { "%%PETR1708", "1708 \u00e5rs stavning" },
            { "%%SCOTLAND", "skotsk engelska" },
            { "%%SPANGLIS", "spangelska" },
            { "%%SURMIRAN", "surmiran-dialekt" },
            { "%%VALENCIA", "valensisk dialekt" },
            { "%%VALLADER", "vallader-dialekt" },
            { "%%VIVARAUP", "vivaroalpinska (occitanska)" },
            { "%%WADEGILE", "Wade-Giles" },
            { "%%XSISTEMO", "x-system" },
            { "type.ca.roc", "kinesiska republikens kalender" },
            { "type.co.eor", "sorteringsordning f\u00f6r flerspr\u00e5kliga europeiska dokument" },
            { "type.hc.h11", "12-timmarsklocka (0\u201311)" },
            { "type.hc.h12", "12-timmarsklocka (1\u201312)" },
            { "type.hc.h23", "24-timmarsklocka (0\u201323)" },
            { "type.hc.h24", "24-timmarsklocka (1\u201324)" },
            { "type.m0.bgn", "enligt USA:s geografiska namnkommitt\u00e9" },
            { "type.nu.ahom", "ahom-siffror" },
            { "type.nu.arab", "indo-arabiska siffror" },
            { "type.nu.armn", "armeniska taltecken" },
            { "type.nu.bali", "balinesiska siffror" },
            { "type.nu.beng", "bengaliska siffror" },
            { "type.nu.brah", "brahmiska siffror" },
            { "type.nu.cakm", "chakma-siffror" },
            { "type.nu.cham", "chamiska siffror" },
            { "type.nu.cyrl", "kyrilliska taltecken" },
            { "type.nu.deva", "devanagariska siffror" },
            { "type.nu.diak", "dives akuru-siffror" },
            { "type.nu.ethi", "etiopiska taltecken" },
            { "type.nu.geor", "georgiska taltecken" },
            { "type.nu.gong", "gunjalagondiska siffror" },
            { "type.nu.gonm", "masaramgondiska siffror" },
            { "type.nu.grek", "grekiska taltecken" },
            { "type.nu.gujr", "gujaratiska siffror" },
            { "type.nu.guru", "gurmukhiska siffror" },
            { "type.nu.hans", "f\u00f6renklat kinesiskt stavade tal" },
            { "type.nu.hant", "traditionellt kinesiskt stavade tal" },
            { "type.nu.hebr", "hebreiska taltecken" },
            { "type.nu.hmng", "pahawh hmong-siffror" },
            { "type.nu.hmnp", "nyiakeng puachue hmong-siffror" },
            { "type.nu.java", "javanesiska siffror" },
            { "type.nu.jpan", "japanskt stavade tal" },
            { "type.nu.kali", "kayah li-siffror" },
            { "type.nu.khmr", "khmeriska siffror" },
            { "type.nu.knda", "kannadiska siffror" },
            { "type.nu.lana", "tai tham hora-siffror" },
            { "type.nu.laoo", "laotiska siffror" },
            { "type.nu.latn", "v\u00e4sterl\u00e4ndska siffror" },
            { "type.nu.lepc", "lepcha-siffror" },
            { "type.nu.limb", "limbu-siffror" },
            { "type.nu.mlym", "malayalamiska siffror" },
            { "type.nu.modi", "modi-siffror" },
            { "type.nu.mong", "mongoliska siffror" },
            { "type.nu.mroo", "mro-siffror" },
            { "type.nu.mtei", "meetei mayek-siffror" },
            { "type.nu.mymr", "burmesiska siffror" },
            { "type.nu.nkoo", "n\u2019ko-siffror" },
            { "type.nu.olck", "ol chiki-siffror" },
            { "type.nu.orya", "oriyiska siffror" },
            { "type.nu.osma", "osmanya-siffror" },
            { "type.nu.rohg", "hanifisiffror" },
            { "type.nu.saur", "saurashtra-siffror" },
            { "type.nu.shrd", "sharada-siffror" },
            { "type.nu.sind", "khudawidiska siffror" },
            { "type.nu.sinh", "sinhala lith-siffror" },
            { "type.nu.sora", "sora sompeng-siffror" },
            { "type.nu.sund", "sundanesiska siffror" },
            { "type.nu.takr", "takri-siffror" },
            { "type.nu.talu", "ny tai l\u00fc-siffror" },
            { "type.nu.taml", "traditionella tamilska taltecken" },
            { "type.nu.telu", "telugiska siffror" },
            { "type.nu.thai", "thail\u00e4ndska siffror" },
            { "type.nu.tibt", "tibetanska siffror" },
            { "type.nu.tirh", "tirhuta-siffror" },
            { "type.nu.vaii", "vai-siffror" },
            { "type.nu.wara", "varang kshiti-siffror" },
            { "type.nu.wcho", "wanchosiffror" },
            { "type.ca.dangi", "koreansk kalender" },
            { "type.co.ducet", "grundl\u00e4ggande Unicode-sorteringsordning" },
            { "type.co.emoji", "emojisorteringsordning" },
            { "type.lb.loose", "fri radbrytning" },
            { "type.nu.roman", "romerska taltecken" },
            { "type.ca.coptic", "koptisk kalender" },
            { "type.ca.hebrew", "hebreisk kalender" },
            { "type.ca.indian", "indisk kalender" },
            { "type.co.compat", "bak\u00e5tkompatibel sorteringsordning" },
            { "type.co.pinyin", "pinyin-sorteringsordning" },
            { "type.co.search", "allm\u00e4n s\u00f6kning" },
            { "type.co.stroke", "strecksorteringsordning" },
            { "type.co.unihan", "radikal-streck-sorteringsordning" },
            { "type.co.zhuyin", "zhuyin-sorteringsordning" },
            { "type.d0.fwidth", "till helbreda" },
            { "type.d0.hwidth", "till halvbreda" },
            { "type.lb.normal", "normal radbrytning" },
            { "type.lb.strict", "strikt radbrytning" },
            { "type.m0.ungegn", "enligt FN:s geografiska namnkommitt\u00e9" },
            { "type.ms.metric", "metersystem" },
            { "type.nu.native", "spr\u00e5kspecifika siffror" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "type.ca.islamic", "islamisk kalender" },
            { "type.ca.iso8601", "ISO 8601-kalender" },
            { "type.ca.persian", "persisk kalender" },
            { "type.cf.account", "redovisningsformat" },
            { "type.co.big5han", "big5-sorteringsordning" },
            { "type.d0.npinyin", "Numerisk" },
            { "type.nu.arabext", "ut\u00f6kade indo-arabiska siffror" },
            { "type.nu.armnlow", "gemena armeniska taltecken" },
            { "type.nu.finance", "finansiella siffror" },
            { "type.nu.greklow", "sm\u00e5 grekiska taltecken" },
            { "type.nu.hanidec", "kinesiska decimaltal" },
            { "type.nu.hansfin", "f\u00f6renklat kinesiskt finansiellt stavade tal" },
            { "type.nu.hantfin", "traditionellt kinesiskt finansiellt stavade tal" },
            { "type.nu.jpanfin", "japanskt finansiellt stavade tal" },
            { "type.nu.mathdbl", "matematiska siffror med dubbelstreck" },
            { "type.nu.tamldec", "tamilska siffror" },
            { "type.ca.buddhist", "buddistisk kalender" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "type.ca.japanese", "japansk kalender" },
            { "type.cf.standard", "normalt format" },
            { "type.co.phonetic", "fonetisk sorteringsordning" },
            { "type.co.searchjl", "s\u00f6ksorteringsordning f\u00f6r att s\u00f6ka p\u00e5 inledande Hangul-konsonant" },
            { "type.co.standard", "normal sorteringsordning" },
            { "type.ms.uksystem", "brittiskt m\u00e5ttsystem" },
            { "type.ms.ussystem", "USA:s m\u00e5ttsystem" },
            { "type.nu.fullwide", "fullbreddssiffror" },
            { "type.nu.lanatham", "tai tham tham-siffror" },
            { "type.nu.mathbold", "matematiska siffror i fetstil" },
            { "type.nu.mathmono", "matematiska siffror med fast teckenbredd" },
            { "type.nu.mathsanb", "matematiska siffror i sans-serif fetstil" },
            { "type.nu.mathsans", "matematiska siffror i sans-serif" },
            { "type.nu.mymrshan", "burmesiska shan-siffror" },
            { "type.nu.mymrtlng", "burmesiska tai laing-siffror" },
            { "type.nu.romanlow", "sm\u00e5 romerska taltecken" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "type.co.gb2312han", "gb2312-sorteringsordning" },
            { "type.co.phonebook", "telefonkatalogssorteringsordning" },
            { "type.co.dictionary", "ordbokssorteringsordning" },
            { "type.co.traditional", "traditionell sorteringsordning" },
            { "type.nu.traditional", "Traditionella siffror" },
            { "type.ca.islamic-civil", "islamisk civil kalender" },
            { "type.ca.islamic-umalqura", "islamisk kalender, Umm al-Qura" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
        };
        return data;
    }
}
