/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sr_Latn_BA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Srednje vrijeme po Grini\u010du",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apija, standardno vrijeme",
               "",
               "Apija, ljetnje vrijeme",
               "",
               "Apija vrijeme",
               "",
            };
        final String[] Cook = new String[] {
               "Kukova Ostrva, standardno vrijeme",
               "",
               "Kukova Ostrva, poluljetnje vrijeme",
               "",
               "Kukova Ostrva vrijeme",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba, standardno vrijeme",
               "CST",
               "Kuba, ljetnje vrijeme",
               "CDT",
               "Kuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei, standardno vrijeme",
               "",
               "Fid\u017ei, ljetnje vrijeme",
               "",
               "Fid\u017ei vrijeme",
               "",
            };
        final String[] Gulf = new String[] {
               "Zalivsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd, standardno vrijeme",
               "",
               "Hovd, ljetnje vrijeme",
               "",
               "Hovd vrijeme",
               "",
            };
        final String[] Iran = new String[] {
               "Iran, standardno vrijeme",
               "",
               "Iran, ljetnje vrijeme",
               "",
               "Iran vrijeme",
               "",
            };
        final String[] Niue = new String[] {
               "Nijue vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk, standardno vrijeme",
               "",
               "Omsk, ljetnje vrijeme",
               "",
               "Omsk vrijeme",
               "",
            };
        final String[] Peru = new String[] {
               "Peru, standardno vrijeme",
               "",
               "Peru, ljetnje vrijeme",
               "",
               "Peru vrijeme",
               "",
            };
        final String[] Truk = new String[] {
               "\u010cuk vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ostrvo Vejk vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010cile, standardno vrijeme",
               "",
               "\u010cile, ljetnje vrijeme",
               "",
               "\u010cile vrijeme",
               "",
            };
        final String[] China = new String[] {
               "Kinesko standardno vrijeme",
               "CST",
               "Kina, ljetnje vrijeme",
               "CDT",
               "Kina vrijeme",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosova (Kiling) ostrva vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Dejvis vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijsko standardno vrijeme",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japansko standardno vrijeme",
               "JST",
               "Japansko ljetnje vrijeme",
               "JDT",
               "Japansko vrijeme",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korejsko standardno vrijeme",
               "KST",
               "Korejsko ljetnje vrijeme",
               "KST",
               "Korejsko vrijeme",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa, standardno vrijeme",
               "SST",
               "Samoa, ljetnje vrijeme",
               "SST",
               "Samoa vrijeme",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u0160ova vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga, standardno vrijeme",
               "",
               "Tonga, ljetnje vrijeme",
               "",
               "Tonga vrijeme",
               "",
            };
        final String[] Alaska = new String[] {
               "Aljaska, standardno vrijeme",
               "AKST",
               "Aljaska, ljetnje vrijeme",
               "AKDT",
               "Aljaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon, standardno vrijeme",
               "",
               "Amazon, ljetnje vrijeme",
               "",
               "Amazon vrijeme",
               "",
            };
        final String[] Azores = new String[] {
               "Azori, standardno vrijeme",
               "",
               "Azori, ljetnje vrijeme",
               "",
               "Azori vrijeme",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunej Darusalum vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Uskr\u0161nja ostrva, standardno vrijeme",
               "",
               "Uskr\u0161nja ostrva, ljetnje vrijeme",
               "",
               "Uskr\u0161nja ostrva vrijeme",
               "",
            };
        final String[] Guyana = new String[] {
               "Gvajana vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Izraelsko standardno vrijeme",
               "IST",
               "Izraelsko ljetnje vrijeme",
               "IDT",
               "Izraelsko vrijeme",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ko\u0161re vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Moson vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva, standardno vrijeme",
               "MSK",
               "Moskva, ljetnje vrijeme",
               "MSK",
               "Moskva vrijeme",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponpej vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tajpej, standardno vrijeme",
               "CST",
               "Tajpej, ljetnje vrijeme",
               "CDT",
               "Tajpej vrijeme",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ostrva Valis i Futuna vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabijsko standardno vrijeme",
               "",
               "Arabijsko ljetnje vrijeme",
               "",
               "Arabijsko vrijeme",
               "",
            };
        final String[] Armenia = new String[] {
               "Jermenija, standardno vrijeme",
               "",
               "Jermenija, ljetnje vrijeme",
               "",
               "Jermenija vrijeme",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivija vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u010catam, standardno vrijeme",
               "",
               "\u010catam, ljetnje vrijeme",
               "",
               "\u010catam vrijeme",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Koordinisano univerzalno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvador vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambije vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzija, standardno vrijeme",
               "",
               "Gruzija, ljetnje vrijeme",
               "",
               "Gruzija vrijeme",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkuck, standardno vrijeme",
               "",
               "Irkuck, ljetnje vrijeme",
               "",
               "Irkuck vrijeme",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan, standardno vrijeme",
               "",
               "Magadan, ljetnje vrijeme",
               "",
               "Magadan vrijeme",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmar vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ostrvo Norfolk, standardno vrijeme",
               "",
               "ostrvo Norfolk, ljetnje vrijeme",
               "",
               "ostrvo Norfolk vrijeme",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronja, standardno vrijeme",
               "",
               "Fernando de Noronja, ljetnje vrijeme",
               "",
               "Fernando de Noronja vrijeme",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunion vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomonska Ostrva vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvaj, standardno vrijeme",
               "",
               "Urugvaj, ljetnje vrijeme",
               "",
               "Urugvaj vrijeme",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu, standardno vrijeme",
               "",
               "Vanuatu, ljetnje vrijeme",
               "",
               "Vanuatu vrijeme",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk, standardno vrijeme",
               "",
               "Jakutsk, ljetnje vrijeme",
               "",
               "Jakutsk vrijeme",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantsko standardno vrijeme",
               "AST",
               "Atlantsko ljetnje vrijeme",
               "AST",
               "Atlantsko vrijeme",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brazilija, standardno vrijeme",
               "",
               "Brazilija, ljetnje vrijeme",
               "",
               "Brazilija vrijeme",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camoro vrijeme",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbija, standardno vrijeme",
               "",
               "Kolumbija, ljetnje vrijeme",
               "",
               "Kolumbija vrijeme",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklandska Ostrva, standardno vrijeme",
               "",
               "Folklandska Ostrva, ljetnje vrijeme",
               "",
               "Folklandska Ostrva vrijeme",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malezija vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivi vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator, standardno vrijeme",
               "",
               "Ulan Bator, ljetnje vrijeeme",
               "",
               "Ulan Bator vrijeme",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan, standardno vrijeme",
               "PKT",
               "Pakistan, ljetnje vrijeme",
               "PKST",
               "Pakistan vrijeme",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvaj, standardno vrijeme",
               "",
               "Paragvaj, ljetnje vrijeme",
               "",
               "Paragvaj vrijeme",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalin, standardno vrijeme",
               "",
               "Sahalin, ljetnje vrijeme",
               "",
               "Sahalin vrijeme",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina, standardno vrijeme",
               "",
               "Argentina, ljetnje vrijeme",
               "",
               "Argentina vrijeme",
               "",
            };
        final String[] Christmas = new String[] {
               "Bo\u017ei\u0107no ostrvo vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong, standardno vrijeme",
               "HKT",
               "Hong Kong, ljetnje vrijeme",
               "HKST",
               "Hong Kong vrijeme",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokina vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Hov, standardno vrijeme",
               "",
               "Lord Hov, ljetnje vrijeme",
               "",
               "Lord Hov vrijeme",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markiz vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijus, standardno vrijeme",
               "",
               "Mauricijus, ljetnje vrijeme",
               "",
               "Mauricijus vrijeme",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur, standardno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venecuela vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd, standardno vrijeme",
               "MSK",
               "Volgograd, ljetnje vrijeme",
               "MSK",
               "Volgograd vrijeme",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbejd\u017ean, standardno vrijeme",
               "",
               "Azerbejd\u017ean, ljetnje vrijeme",
               "",
               "Azerbejd\u017ean vrijeme",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161, standardno vrijeme",
               "",
               "Banglade\u0161, ljetnje vrijeme",
               "",
               "Banglade\u0161 vrijeme",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Zelenortska Ostrva, standardno vrijeme",
               "",
               "Zelenortska Ostrva, ljetnje vrijeme",
               "",
               "Zelenortska Ostrva vrijeme",
               "",
            };
        final String[] East_Timor = new String[] {
               "Isto\u010dni Timor vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sej\u0161eli vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistan vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan, standardno vrijeme",
               "",
               "Uzbekistan, ljetnje vrijeme",
               "",
               "Uzbekistan vrijeme",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Avganistan vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk, standardno vrijeme",
               "",
               "Krasnojarsk, ljetnje vrijeme",
               "",
               "Krasnojarsk vrijeme",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Novi Zeland, standardno vrijeme",
               "NZST",
               "Novi Zeland, ljetnje vrijeme",
               "NZDT",
               "Novi Zeland vrijeme",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk, standardno vrijeme",
               "",
               "Novosibirsk, ljetnje vrijeme",
               "",
               "Novosibirsk vrijeme",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipini, standardno vrijeme",
               "PST",
               "Filipini, ljetnje vrijeme",
               "PDT",
               "Filipini vrijeme",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok, standardno vrijeme",
               "",
               "Vladivostok, ljetnje vrijeme",
               "",
               "Vladivostok vrijeme",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijsko okeansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linijska ostrva vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Njufaundlend, standardno vrijeme",
               "NST",
               "Njufaundlend, ljetnje vrijeme",
               "NDT",
               "Njufaundlend",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan, standardno vrijeme",
               "",
               "Turkmenistan, ljetnje vrijeme",
               "",
               "Turkmenistan vrijeme",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francuska Gvajana vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nova Kaledonija, standardno vrijeme",
               "",
               "Nova Kaledonija, ljetnje vrijeme",
               "",
               "Nova Kaledonija vrijeme",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ju\u017ena D\u017eord\u017eija vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg, standardno vrijeme",
               "",
               "Jekaterinburg, ljetnje vrijeme",
               "",
               "Jekaterinburg vrijeme",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centralno-afri\u010dko vrijeme",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Isto\u010dno-afri\u010dko vrijeme",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Zapadno-afri\u010dko standardno vrijeme",
               "WAT",
               "Zapadno-afri\u010dko ljetnje vrijeme",
               "WAT",
               "Zapadno-afri\u010dko vrijeme",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dimon d\u2019Irvil vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Srednjoevropsko standardno vrijeme",
               "CET",
               "Srednjoevropsko ljetnje vrijeme",
               "CEST",
               "Srednjoevropsko vrijeme",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Isto\u010dnoevropsko standardno vrijeme",
               "EET",
               "Isto\u010dnoevropsko ljetnje vrijeme",
               "EEST",
               "Isto\u010dnoevropsko vrijeme",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Zapadnoevropsko standardno vrijeme",
               "WET",
               "Zapadnoevropsko ljetnje vrijeme",
               "WEST",
               "Zapadnoevropsko vrijeme",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksi\u010dki Pacifik, standardno vrijeme",
               "MST",
               "Meksi\u010dki Pacifik, ljetnje vrijeme",
               "MDT",
               "Meksi\u010dki Pacifik",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017eno-afri\u010dko vrijeme",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Sjevernoameri\u010dko centralno standardno vrijeme",
               "CST",
               "Sjevernoameri\u010dko centralno ljetnje vrijeme",
               "CDT",
               "Sjevernoameri\u010dko centralno vrijeme",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Sjevernoameri\u010dko isto\u010dno standardno vrijeme",
               "EST",
               "Sjevernoameri\u010dko isto\u010dno ljetnje vrijeme",
               "EST",
               "Sjevernoameri\u010dko isto\u010dno vrijeme",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Sjevernoameri\u010dko pacifi\u010dko standardno vrijeme",
               "PST",
               "Sjevernoameri\u010dko pacifi\u010dko letnje vrijeme",
               "PDT",
               "Sjevernoameri\u010dko pacifi\u010dko vrijeme",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Francusko ju\u017eno i antarkti\u010dko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertova ostrva vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsko standardno vrijeme",
               "HST",
               "Havajsko-aleutsko ljetnje vrijeme",
               "HST",
               "Havajsko-aleutsko vrijeme",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks ostrva vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen Pjer i Mikelon, standardno vrijeme",
               "",
               "Sen Pjer i Mikelon, ljetnje vrijeme",
               "",
               "Sen Pjer i Mikelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Sjevernoameri\u010dko planinsko standardno vrijeme",
               "MST",
               "Sjevernoameri\u010dko planinsko ljetnje vrijeme",
               "MST",
               "Sjevernoameri\u010dko planinsko vrijeme",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Mar\u0161alska Ostrva vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nova Gvineja vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Australijsko centralno standardno vrijeme",
               "ACST",
               "Australijsko centralno ljetnje vrijeme",
               "ACDT",
               "Australijsko centralno vrijeme",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australijsko isto\u010dno standardno vrijeme",
               "AEST",
               "Australijsko isto\u010dno ljetnje vrijeme",
               "AEDT",
               "Australijsko isto\u010dno vrijeme",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Australijsko zapadno standardno vrijeme",
               "AWST",
               "Australijsko zapadno ljetnje vrijeme",
               "AWDT",
               "Australijsko zapadno vrijeme",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centralno-indonezijsko vrijeme",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Isto\u010dno-indonezijsko vrijeme",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Zapadno-indonezijsko vrijeme",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zapadno-kazahstansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australijsko centralno zapadno standardno vrijeme",
               "",
               "Australijsko centralno zapadno ljetnje vrijeme",
               "",
               "Australijsko centralno zapadno vrijeme",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Britanija, ljetnje vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Koordinisano univerzalno vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Irska, standardno vrijeme",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Koordinisano univerzalno vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Koordinisano univerzalno vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Britanija, ljetnje vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Koordinisano univerzalno vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Koordinisano univerzalno vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Koordinisano univerzalno vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Irska, standardno vrijeme",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Britanija, ljetnje vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Britanija, ljetnje vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Britanija, ljetnje vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Britanija, ljetnje vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Srednje vrijeme po Grini\u010du",
                    "GMT",
                    "Britanija, ljetnje vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Pacific/Niue", "Nijue" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Regina", "Red\u017eajna" },
            { "timezone.excity.America/Resolute", "Rezolut" },
            { "timezone.excity.America/St_Johns", "Sent D\u017eons" },
            { "timezone.excity.America/St_Thomas", "Sent Tomas" },
            { "timezone.excity.America/Louisville", "Luivil" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.Arctic/Longyearbyen", "Longjir" },
            { "timezone.excity.America/Indianapolis", "Indijanapolis" },
            { "timezone.excity.America/Scoresbysund", "Itokortormit" },
            { "timezone.excity.Antarctica/Macquarie", "Makvori" },
            { "timezone.excity.America/Indiana/Vevay", "Vivi, Indijana" },
            { "timezone.excity.America/Port_of_Spain", "Port ov Spejn" },
            { "timezone.excity.America/St_Barthelemy", "Sen Bartelemi" },
            { "timezone.excity.America/Swift_Current", "Svift Karent" },
            { "timezone.excity.America/Port-au-Prince", "Port-o-Prens" },
            { "timezone.excity.America/Indiana/Vincennes", "Vinsens, Indijana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dimon d\u2019Irvil" },
            { "timezone.excity.America/North_Dakota/Beulah", "Bjula, Sjeverna Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Centar, Sjeverna Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Novi Salem, Sjeverna Dakota" },
        };
        return data;
    }
}
