/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_tr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Ortalama Saati",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre Standart Saati",
               "",
               "Acre Yaz Saati",
               "",
               "Acre Saati",
               "",
            };
        final String[] Apia = new String[] {
               "Apia Standart Saati",
               "",
               "Apia Yaz Saati",
               "",
               "Apia Saati",
               "",
            };
        final String[] Cook = new String[] {
               "Cook Adalar\u0131 Standart Saati",
               "",
               "Cook Adalar\u0131 Yar\u0131 Yaz Saati",
               "",
               "Cook Adalar\u0131 Saati",
               "",
            };
        final String[] Cuba = new String[] {
               "K\u00fcba Standart Saati",
               "CST",
               "K\u00fcba Yaz Saati",
               "CDT",
               "K\u00fcba Saati",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji Standart Saati",
               "",
               "Fiji Yaz Saati",
               "",
               "Fiji Saati",
               "",
            };
        final String[] Gulf = new String[] {
               "K\u00f6rfez Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd Standart Saati",
               "",
               "Hovd Yaz Saati",
               "",
               "Hovd Saati",
               "",
            };
        final String[] Iran = new String[] {
               "\u0130ran Standart Saati",
               "",
               "\u0130ran Yaz Saati",
               "",
               "\u0130ran Saati",
               "",
            };
        final String[] Niue = new String[] {
               "Niue Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk Standart Saati",
               "",
               "Omsk Yaz Saati",
               "",
               "Omsk Saati",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Standart Saati",
               "",
               "Peru Yaz Saati",
               "",
               "Peru Saati",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake Adas\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u015eili Standart Saati",
               "",
               "\u015eili Yaz Saati",
               "",
               "\u015eili Saati",
               "",
            };
        final String[] China = new String[] {
               "\u00c7in Standart Saati",
               "CST",
               "\u00c7in Yaz Saati",
               "CDT",
               "\u00c7in Saati",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Cocos Adalar\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hindistan Standart Saati",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japonya Standart Saati",
               "JST",
               "Japonya Yaz Saati",
               "JDT",
               "Japonya Saati",
               "JT",
            };
        final String[] Korea = new String[] {
               "Kore Standart Saati",
               "KST",
               "Kore Yaz Saati",
               "KST",
               "Kore Saati",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa Standart Saati",
               "SST",
               "Samoa Yaz Saati",
               "SST",
               "Samoa Saati",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Showa Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga Standart Saati",
               "",
               "Tonga Yaz Saati",
               "",
               "Tonga Saati",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukon Saati",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska Standart Saati",
               "AKST",
               "Alaska Yaz Saati",
               "AKDT",
               "Alaska Saati",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon Standart Saati",
               "",
               "Amazon Yaz Saati",
               "",
               "Amazon Saati",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anad\u0131r Standart Saati",
               "",
               "Anad\u0131r Yaz Saati",
               "",
               "Anadyr Saati",
               "",
            };
        final String[] Azores = new String[] {
               "Azorlar Standart Saati",
               "",
               "Azorlar Yaz Saati",
               "",
               "Azorlar Saati",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Dar\u00fc\u2019s-Selam Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Paskalya Adas\u0131 Standart Saati",
               "",
               "Paskalya Adas\u0131 Yaz Saati",
               "",
               "Paskalya Adas\u0131 Saati",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "\u0130srail Standart Saati",
               "IST",
               "\u0130srail Yaz Saati",
               "IDT",
               "\u0130srail Saati",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskova Standart Saati",
               "MSK",
               "Moskova Yaz Saati",
               "MSK",
               "Moskova Saati",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara Standart Saati",
               "",
               "Samara Yaz Saati",
               "",
               "Samara Saati",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei Standart Saati",
               "CST",
               "Taipei Yaz Saati",
               "CDT",
               "Taipei Saati",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis ve Futuna Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabistan Standart Saati",
               "",
               "Arabistan Yaz Saati",
               "",
               "Arabistan Saati",
               "",
            };
        final String[] Armenia = new String[] {
               "Ermenistan Standart Saati",
               "",
               "Ermenistan Yaz Saati",
               "",
               "Ermenistan Saati",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivya Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham Standart Saati",
               "",
               "Chatham Yaz Saati",
               "",
               "Chatham Saati",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "E\u015f G\u00fcd\u00fcml\u00fc Evrensel Zaman",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvador Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "G\u00fcrcistan Standart Saati",
               "",
               "G\u00fcrcistan Yaz Saati",
               "",
               "G\u00fcrcistan Saati",
               "",
            };
        final String[] Irkutsk = new String[] {
               "\u0130rkutsk Standart Saati",
               "",
               "\u0130rkutsk Yaz Saati",
               "",
               "\u0130rkutsk Saati",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan Standart Saati",
               "",
               "Magadan Yaz Saati",
               "",
               "Magadan Saati",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Adas\u0131 Standart Saati",
               "",
               "Norfolk Adas\u0131 Yaz Saati",
               "",
               "Norfolk Adas\u0131 Saati",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Standart Saati",
               "",
               "Fernando de Noronha Yaz Saati",
               "",
               "Fernando de Noronha Saati",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunion Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon Adalar\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguay Standart Saati",
               "",
               "Uruguay Yaz Saati",
               "",
               "Uruguay Saati",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Standart Saati",
               "",
               "Vanuatu Yaz Saati",
               "",
               "Vanuatu Saati",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Standart Saati",
               "",
               "Yakutsk Yaz Saati",
               "",
               "Yakutsk Saati",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik Standart Saati",
               "AST",
               "Atlantik Yaz Saati",
               "AST",
               "Atlantik Saati",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Standart Saati",
               "",
               "Brasilia Yaz Saati",
               "",
               "Brasilia Saati",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro Saati",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolombiya Standart Saati",
               "",
               "Kolombiya Yaz Saati",
               "",
               "Kolombiya Saati",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkland Adalar\u0131 Standart Saati",
               "",
               "Falkland Adalar\u0131 Yaz Saati",
               "",
               "Falkland Adalar\u0131 Saati",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malezya Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivler Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batur Standart Saati",
               "",
               "Ulan Batur Yaz Saati",
               "",
               "Ulan Batur Saati",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standart Saati",
               "PKT",
               "Pakistan Yaz Saati",
               "PKST",
               "Pakistan Saati",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay Standart Saati",
               "",
               "Paraguay Yaz Saati",
               "",
               "Paraguay Saati",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalin Standart Saati",
               "",
               "Sahalin Yaz Saati",
               "",
               "Sahalin Saati",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Arjantin Standart Saati",
               "",
               "Arjantin Yaz Saati",
               "",
               "Arjantin Saati",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmas Adas\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong Standart Saati",
               "HKT",
               "Hong Kong Yaz Saati",
               "HKST",
               "Hong Kong Saati",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hindi\u00e7in Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u00e7atski Standart Saati",
               "",
               "Petropavlovsk-Kam\u00e7atski Yaz Saati",
               "",
               "Petropavlovsk-Kam\u00e7atski Saati",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "K\u0131rg\u0131zistan Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe Standart Saati",
               "",
               "Lord Howe Yaz Saati",
               "",
               "Lord Howe Saati",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markiz Adalar\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius Standart Saati",
               "",
               "Mauritius Yaz Saati",
               "",
               "Mauritius Saati",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur Standart Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd Standart Saati",
               "MSK",
               "Volgograd Yaz Saati",
               "MSK",
               "Volgograd Saati",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaycan Standart Saati",
               "",
               "Azerbaycan Yaz Saati",
               "",
               "Azerbaycan Saati",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u015f Standart Saati",
               "",
               "Banglade\u015f Yaz Saati",
               "",
               "Banglade\u015f Saati",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde Standart Saati",
               "",
               "Cape Verde Yaz Saati",
               "",
               "Cape Verde Saati",
               "",
            };
        final String[] East_Timor = new String[] {
               "Do\u011fu Timor Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sey\u015feller Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tacikistan Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "\u00d6zbekistan Standart Saati",
               "",
               "\u00d6zbekistan Yaz Saati",
               "",
               "\u00d6zbekistan Saati",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Standart Saati",
               "",
               "Krasnoyarsk Yaz Saati",
               "",
               "Krasnoyarsk Saati",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Yeni Zelanda Standart Saati",
               "NZST",
               "Yeni Zelanda Yaz Saati",
               "NZDT",
               "Yeni Zelanda Saati",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standart Saati",
               "",
               "Novosibirsk Yaz Saati",
               "",
               "Novosibirsk Saati",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipinler Standart Saati",
               "PST",
               "Filipinler Yaz Saati",
               "PDT",
               "Filipinler Saati",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Standart Saati",
               "",
               "Vladivostok Yaz Saati",
               "",
               "Vladivostok Saati",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hint Okyanusu Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line Adalar\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Standart Saati",
               "NST",
               "Newfoundland Yaz Saati",
               "NDT",
               "Newfoundland Saati",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u00fcrkmenistan Standart Saati",
               "",
               "T\u00fcrkmenistan Yaz Saati",
               "",
               "T\u00fcrkmenistan Saati",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frans\u0131z Guyanas\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Yeni Kaledonya Standart Saati",
               "",
               "Yeni Kaledonya Yaz Saati",
               "",
               "Yeni Kaledonya Saati",
               "",
            };
        final String[] South_Georgia = new String[] {
               "G\u00fcney Georgia Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg Standart Saati",
               "",
               "Yekaterinburg Yaz Saati",
               "",
               "Yekaterinburg Saati",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Orta Afrika Saati",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Do\u011fu Afrika Saati",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Bat\u0131 Afrika Standart Saati",
               "WAT",
               "Bat\u0131 Afrika Yaz Saati",
               "WAT",
               "Bat\u0131 Afrika Saati",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Orta Avrupa Standart Saati",
               "CET",
               "Orta Avrupa Yaz Saati",
               "CEST",
               "Orta Avrupa Saati",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Do\u011fu Avrupa Standart Saati",
               "EET",
               "Do\u011fu Avrupa Yaz Saati",
               "EEST",
               "Do\u011fu Avrupa Saati",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Bat\u0131 Avrupa Standart Saati",
               "WET",
               "Bat\u0131 Avrupa Yaz Saati",
               "WEST",
               "Bat\u0131 Avrupa Saati",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksika Pasifik K\u0131y\u0131s\u0131 Standart Saati",
               "MST",
               "Meksika Pasifik K\u0131y\u0131s\u0131 Yaz Saati",
               "MDT",
               "Meksika Pasifik K\u0131y\u0131s\u0131 Saati",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "G\u00fcney Afrika Standart Saati",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Kuzey Amerika Merkezi Standart Saati",
               "CST",
               "Kuzey Amerika Merkezi Yaz Saati",
               "CDT",
               "Kuzey Amerika Merkezi Saati",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Kuzey Amerika Do\u011fu Standart Saati",
               "EST",
               "Kuzey Amerika Do\u011fu Yaz Saati",
               "EST",
               "Kuzey Amerika Do\u011fu Saati",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Kuzey Amerika Pasifik Standart Saati",
               "PST",
               "Kuzey Amerika Pasifik Yaz Saati",
               "PDT",
               "Kuzey Amerika Pasifik Saati",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frans\u0131z G\u00fcney ve Antarktika Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Adalar\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleut Standart Saati",
               "HST",
               "Hawaii-Aleut Yaz Saati",
               "HST",
               "Hawaii-Aleut Saati",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Adalar\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint Pierre ve Miquelon Standart Saati",
               "",
               "Saint Pierre ve Miquelon Yaz Saati",
               "",
               "Saint Pierre ve Miquelon Saati",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Kuzey Amerika Da\u011f Standart Saati",
               "MST",
               "Kuzey Amerika Da\u011f Yaz Saati",
               "MST",
               "Kuzey Amerika Da\u011f Saati",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Adalar\u0131 Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Yeni Gine Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Orta Avustralya Standart Saati",
               "ACST",
               "Orta Avustralya Yaz Saati",
               "ACDT",
               "Orta Avustralya Saati",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Do\u011fu Avustralya Standart Saati",
               "AEST",
               "Do\u011fu Avustralya Yaz Saati",
               "AEDT",
               "Do\u011fu Avustralya Saati",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Bat\u0131 Avustralya Standart Saati",
               "AWST",
               "Bat\u0131 Avustralya Yaz Saati",
               "AWDT",
               "Bat\u0131 Avustralya Saati",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Orta Endonezya Saati",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Do\u011fu Endonezya Saati",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Bat\u0131 Endonezya Saati",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Bat\u0131 Kazakistan Saati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0130\u00e7 Bat\u0131 Avustralya Standart Saati",
               "",
               "\u0130\u00e7 Bat\u0131 Avustralya Yaz Saati",
               "",
               "\u0130\u00e7 Bat\u0131 Avustralya Saati",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "E\u015f G\u00fcd\u00fcml\u00fc Evrensel Zaman",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130rlanda Standart Saati",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "E\u015f G\u00fcd\u00fcml\u00fc Evrensel Zaman",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "E\u015f G\u00fcd\u00fcml\u00fc Evrensel Zaman",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "E\u015f G\u00fcd\u00fcml\u00fc Evrensel Zaman",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "E\u015f G\u00fcd\u00fcml\u00fc Evrensel Zaman",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "E\u015f G\u00fcd\u00fcml\u00fc Evrensel Zaman",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130rlanda Standart Saati",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Ortalama Saati",
                    "GMT",
                    "\u0130ngiltere Yaz Saati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bak\u00fc" },
            { "timezone.excity.Asia/Gaza", "Gazze" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktav" },
            { "timezone.excity.Asia/Chita", "\u00c7ita" },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "timezone.excity.Asia/Kabul", "Kabil" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Cuba" },
            { "timezone.excity.Asia/Almaty", "Almat\u0131" },
            { "timezone.excity.Asia/Anadyr", "Anad\u0131r" },
            { "timezone.excity.Asia/Aqtobe", "Akt\u00f6be" },
            { "timezone.excity.Asia/Atyrau", "At\u0131rav" },
            { "timezone.excity.Asia/Beirut", "Beyrut" },
            { "timezone.excity.Asia/Hebron", "El Halil" },
            { "timezone.excity.Asia/Kuwait", "Kuveyt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh Kenti" },
            { "timezone.excity.Asia/Tehran", "Tahran" },
            { "timezone.excity.Asia/Urumqi", "Urum\u00e7i" },
            { "timezone.excity.Etc/Unknown", "Bilinmeyen \u015eehir" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kahire" },
            { "timezone.excity.Africa/Ceuta", "Septe" },
            { "timezone.excity.Africa/Tunis", "Tunus" },
            { "timezone.excity.Asia/Baghdad", "Ba\u011fdat" },
            { "timezone.excity.Asia/Bahrain", "Bahreyn" },
            { "timezone.excity.Asia/Bishkek", "Bi\u015fkek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "\u0130rkutsk" },
            { "timezone.excity.Asia/Jakarta", "Cakarta" },
            { "timezone.excity.Asia/Karachi", "Kara\u00e7i" },
            { "timezone.excity.Asia/Kuching", "Ku\u00e7ing" },
            { "timezone.excity.Asia/Nicosia", "Lefko\u015fa" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.Asia/Yerevan", "Erivan" },
            { "timezone.excity.Europe/Sofia", "Sofya" },
            { "timezone.excity.Asia/Ashgabat", "A\u015fkabat" },
            { "timezone.excity.Asia/Calcutta", "Kalk\u00fcta" },
            { "timezone.excity.Asia/Damascus", "\u015eam" },
            { "timezone.excity.Asia/Dushanbe", "Du\u015fanbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Shanghai", "\u015eanghay" },
            { "timezone.excity.Asia/Tashkent", "Ta\u015fkent" },
            { "timezone.excity.Europe/Athens", "Atina" },
            { "timezone.excity.Europe/Lisbon", "Lizbon" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskova" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Skopje", "\u00dcsk\u00fcp" },
            { "timezone.excity.Europe/Tirane", "Tiran" },
            { "timezone.excity.Europe/Vienna", "Viyana" },
            { "timezone.excity.Europe/Warsaw", "Var\u015fova" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrih" },
            { "timezone.excity.Indian/Comoro", "Komor" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Cezayir" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Africa/Tripoli", "Trablus" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Famagusta", "Gazima\u011fusa" },
            { "timezone.excity.Asia/Jerusalem", "Kud\u00fcs" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u00e7atka" },
            { "timezone.excity.Asia/Qyzylorda", "K\u0131z\u0131lorda" },
            { "timezone.excity.Asia/Samarkand", "Semerkand" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Pacific/Easter", "Paskalya Adas\u0131" },
            { "timezone.excity.Africa/Djibouti", "Cibuti" },
            { "timezone.excity.Africa/El_Aaiun", "Layun" },
            { "timezone.excity.Africa/Khartoum", "Hartum" },
            { "timezone.excity.Africa/Kinshasa", "Kin\u015fasa" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Asia/Choibalsan", "\u00c7oybalsan" },
            { "timezone.excity.Atlantic/Azores", "Azor Adalar\u0131" },
            { "timezone.excity.Atlantic/Canary", "Kanarya Adalar\u0131" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Br\u00fcksel" },
            { "timezone.excity.Europe/Budapest", "Budape\u015fte" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u015finev" },
            { "timezone.excity.Europe/Istanbul", "\u0130stanbul" },
            { "timezone.excity.Europe/Sarajevo", "Saraybosna" },
            { "timezone.excity.Indian/Maldives", "Maldivler" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u015fu" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Batur" },
            { "timezone.excity.Atlantic/Madeira", "Madeira Adalar\u0131" },
            { "timezone.excity.Australia/Sydney", "Sidney" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "B\u00fckre\u015f" },
            { "timezone.excity.Europe/Gibraltar", "Cebelitar\u0131k" },
            { "timezone.excity.Europe/Stockholm", "Stokholm" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Casablanca", "Kazablanka" },
            { "timezone.excity.Africa/Libreville", "Librevil" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhag" },
            { "timezone.excity.Europe/Luxembourg", "L\u00fcksemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "Markiz Adalar\u0131" },
            { "timezone.excity.Africa/Brazzaville", "Brazzavil" },
            { "timezone.excity.America/Costa_Rica", "Kosta Rika" },
            { "timezone.excity.Europe/Isle_of_Man", "Man Adas\u0131" },
            { "timezone.excity.America/Puerto_Rico", "Porto Riko" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar\u00fcsselam" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthelemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "G\u00fcney Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Kuzey Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Merkez, Kuzey Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Kuzey Dakota" },
        };
        return data;
    }
}
