# Komodo XUL language service.
#
# Generated by 'luddite.py' on Fri Oct 20 08:49:16 2006.
#

import logging
from koXMLLanguageBase import koXMLLanguageBase, KoGenericXMLLinter


log = logging.getLogger("koXULLanguage")
#log.setLevel(logging.DEBUG)


def registerLanguage(registry):
    log.debug("Registering language XUL")
    registry.registerLanguage(KoXULLanguage())


class KoXULLanguage(koXMLLanguageBase):
    name = "XUL"
    lexresLangName = "XUL"
    _reg_desc_ = "%s Language" % name
    _reg_contractid_ = "@activestate.com/koLanguage?language=%s;1" % name
    _reg_clsid_ = "{E9B4C1F5-C9F9-4F85-A920-09A9A74B0950}"
    _reg_categories_ = [("komodo-language", name)]
    defaultExtension = '.xul'

    lang_from_udl_family = {'CSL': 'JavaScript', 'M': 'XML'}

    publicIdList = ["-//MOZILLA//DTD XUL V1.0//EN"]
    systemIdList = ["http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"]
    namespaces = ["http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"]

    searchURL = "http://www.google.com/search?q=site%3Ahttp%3A%2F%2Fdeveloper.mozilla.org%2Fen%2Fdocs%2FXUL+%W"

    sample = """<window title="Hello World!"
  xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"
  width="250"
  height="200"> 

  <hbox flex="1" align="center">
    <image src="mozilla-big.gif" />
    <text style="font-weight: bold;" value="Hello World!" />
  </hbox>
</window>
"""

class KoXULCompileLinter(KoGenericXMLLinter):
    _reg_desc_ = "Komodo XUL Compile Linter"
    _reg_clsid_ = "{c097c54e-847b-42aa-81c0-3de0a71bcd08}"
    _reg_contractid_ = "@activestate.com/koLinter?language=XUL;1"
    _reg_categories_ = [
         ("category-komodo-linter", 'XUL'),
         ]
