
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
# This file is generated from /Users/marky/src/komodo/local/mozilla/build/moz1700-ko7.10/mozilla/xpcom/base/nsError.h
#
# Please use pyxpcom/xpcom/tools/nsError_generate.py to re-generate this file.

NS_ERROR_ABORT = 0x80004004
NS_ERROR_BASE = 0xC1F30000
NS_ERROR_FACTORY_NOT_LOADED = 0x800401f8
NS_ERROR_FACTORY_NOT_REGISTERED = 0x80040154
NS_ERROR_FACTORY_REGISTER_AGAIN = 0x80040155
NS_ERROR_FAILURE = 0x80004005
NS_ERROR_ILLEGAL_VALUE = 0x80070057
NS_ERROR_INVALID_POINTER = 0x80004003
NS_ERROR_NOT_AVAILABLE = 0x80040111
NS_ERROR_NOT_IMPLEMENTED = 0x80004001
NS_ERROR_NO_AGGREGATION = 0x80040110
NS_ERROR_OUT_OF_MEMORY = 0x8007000e
NS_ERROR_SEVERITY_ERROR = 1
NS_ERROR_SEVERITY_SUCCESS = 0
NS_ERROR_UNEXPECTED = 0x8000ffff
NS_NOINTERFACE = 0x80004002
NS_OK = 0
NS_ERROR_MODULE_BASE = 2
NS_ERROR_MODULE_BASE_OFFSET = 0x45
NS_ERROR_MODULE_CALENDAR = 5
NS_ERROR_MODULE_CONTENT = 25
NS_ERROR_MODULE_DOM = 14
NS_ERROR_MODULE_DOM_FILE = 32
NS_ERROR_MODULE_DOM_FILEHANDLE = 34
NS_ERROR_MODULE_DOM_INDEXEDDB = 33
NS_ERROR_MODULE_DOM_XPATH = 22
NS_ERROR_MODULE_EDITOR = 17
NS_ERROR_MODULE_FILES = 13
NS_ERROR_MODULE_GENERAL = 51
NS_ERROR_MODULE_GFX = 3
NS_ERROR_MODULE_HTMLPARSER = 9
NS_ERROR_MODULE_IMGLIB = 15
NS_ERROR_MODULE_IPC = 28
NS_ERROR_MODULE_LAYOUT = 8
NS_ERROR_MODULE_LDAP = 20
NS_ERROR_MODULE_MAILNEWS = 16
NS_ERROR_MODULE_NETWORK = 6
NS_ERROR_MODULE_PLUGINS = 7
NS_ERROR_MODULE_PROFILE = 19
NS_ERROR_MODULE_PYXPCOM = 26
NS_ERROR_MODULE_RDF = 10
NS_ERROR_MODULE_REG = 12
NS_ERROR_MODULE_SCHEMA = 31
NS_ERROR_MODULE_SECURITY = 21
NS_ERROR_MODULE_STORAGE = 30
NS_ERROR_MODULE_SVG = 29
NS_ERROR_MODULE_UCONV = 11
NS_ERROR_MODULE_URILOADER = 24
NS_ERROR_MODULE_WIDGET = 4
NS_ERROR_MODULE_XPCOM = 1
NS_ERROR_MODULE_XPCONNECT = 18
NS_ERROR_MODULE_XSLT = 27
NS_BINDING_SUCCEEDED = NS_OK
NS_ERROR_ALREADY_INITIALIZED = NS_ERROR_BASE + 2
NS_ERROR_FACTORY_EXISTS = NS_ERROR_BASE + 0x100
NS_ERROR_FACTORY_NO_SIGNATURE_SUPPORT = NS_ERROR_BASE + 0x101
NS_ERROR_HTMLPARSER_CONTINUE = NS_OK
NS_ERROR_INVALID_ARG = NS_ERROR_ILLEGAL_VALUE
NS_ERROR_NOT_INITIALIZED = NS_ERROR_BASE + 1
NS_ERROR_NO_INTERFACE = NS_NOINTERFACE
NS_ERROR_NULL_POINTER = NS_ERROR_INVALID_POINTER
NS_ERROR_XPATH_INVALID_ARG = NS_ERROR_INVALID_ARG
NS_RDF_ASSERTION_ACCEPTED = NS_OK
NS_STATE_PROPERTY_EXISTS = NS_OK
def NS_LIKELY(x): return bool(x)
def NS_UNLIKELY(x): return bool(x)
def NS_ERROR_GENERATE(sev,module,code): return (((sev) << 31) | ((module + NS_ERROR_MODULE_BASE_OFFSET) << 16) | ((code)))
def NS_ERROR_GENERATE_FAILURE(module,code): return NS_ERROR_GENERATE(NS_ERROR_SEVERITY_ERROR, module, code)
def NS_ERROR_GENERATE_SUCCESS(module,code): return NS_ERROR_GENERATE(NS_ERROR_SEVERITY_SUCCESS, module, code)
def NS_ERROR_GET_CODE(err): return ((err) & 0xffff)
def NS_ERROR_GET_MODULE(err): return ((((err) >> 16) - NS_ERROR_MODULE_BASE_OFFSET) & 0x1fff)
def NS_ERROR_GET_SEVERITY(err): return (((err) >> 31) & 0x1)
def NS_FAILED(_nsresult): return (NS_UNLIKELY((_nsresult) & 0x80000000))
def NS_SUCCEEDED(_nsresult): return (NS_LIKELY( not ((_nsresult) & 0x80000000)))
NS_BASE_STREAM_BAD_CONVERSION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 6)
NS_BASE_STREAM_CLOSED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 2)
NS_BASE_STREAM_ILLEGAL_ARGS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 4)
NS_BASE_STREAM_NO_CONVERTER = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 5)
NS_BASE_STREAM_OSERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 3)
NS_BASE_STREAM_WOULD_BLOCK = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 7)
NS_BINDING_ABORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 2)
NS_BINDING_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 1)
NS_BINDING_REDIRECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 3)
NS_BINDING_RETARGETED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 4)
NS_CONTENT_BLOCKED = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_CONTENT, 8)
NS_CONTENT_BLOCKED_SHOW_ALT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_CONTENT, 9)
NS_EDITOR_ELEMENT_NOT_FOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_EDITOR, 1)
NS_ERROR_ALREADY_CONNECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 11)
NS_ERROR_ALREADY_OPENED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 73)
NS_ERROR_CACHE_DATA_IS_NOT_STREAM = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 63)
NS_ERROR_CACHE_DATA_IS_STREAM = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 62)
NS_ERROR_CACHE_ENTRY_DOOMED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 65)
NS_ERROR_CACHE_IN_USE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 68)
NS_ERROR_CACHE_KEY_NOT_FOUND = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 61)
NS_ERROR_CACHE_READ_ACCESS_DENIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 66)
NS_ERROR_CACHE_WAIT_FOR_VALIDATION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 64)
NS_ERROR_CACHE_WRITE_ACCESS_DENIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 67)
NS_ERROR_CANNOT_CONVERT_DATA = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM, 1)
NS_ERROR_CMS_ENCRYPT_INCOMPLETE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1057)
NS_ERROR_CMS_ENCRYPT_NO_BULK_ALG = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1056)
NS_ERROR_CMS_VERIFY_BAD_DIGEST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1026)
NS_ERROR_CMS_VERIFY_BAD_SIGNATURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1033)
NS_ERROR_CMS_VERIFY_CERT_WITHOUT_ADDRESS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1040)
NS_ERROR_CMS_VERIFY_DIGEST_MISMATCH = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1034)
NS_ERROR_CMS_VERIFY_ERROR_PROCESSING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1032)
NS_ERROR_CMS_VERIFY_ERROR_UNVERIFIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1031)
NS_ERROR_CMS_VERIFY_HEADER_MISMATCH = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1038)
NS_ERROR_CMS_VERIFY_MALFORMED_SIGNATURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1037)
NS_ERROR_CMS_VERIFY_NOCERT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1028)
NS_ERROR_CMS_VERIFY_NOT_SIGNED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1024)
NS_ERROR_CMS_VERIFY_NOT_YET_ATTEMPTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1039)
NS_ERROR_CMS_VERIFY_NO_CONTENT_INFO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1025)
NS_ERROR_CMS_VERIFY_UNKNOWN_ALGO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1035)
NS_ERROR_CMS_VERIFY_UNSUPPORTED_ALGO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1036)
NS_ERROR_CMS_VERIFY_UNTRUSTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 1029)
NS_ERROR_CONNECTION_REFUSED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 13)
NS_ERROR_CONTENT_BLOCKED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_CONTENT, 6)
NS_ERROR_CONTENT_BLOCKED_SHOW_ALT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_CONTENT, 7)
NS_ERROR_CORRUPTED_CONTENT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 29)
NS_ERROR_CSP_FRAME_ANCESTOR_VIOLATION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SECURITY, 99)
NS_ERROR_DNS_LOOKUP_QUEUE_FULL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 33)
NS_ERROR_DOCSHELL_REQUEST_REJECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GENERAL, 1001)
NS_ERROR_DOCUMENT_IS_PRINTMODE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GENERAL, 2001)
NS_ERROR_DOCUMENT_NOT_CACHED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 70)
NS_ERROR_DOM_ABORT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 20)
NS_ERROR_DOM_BAD_DOCUMENT_DOMAIN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1009)
NS_ERROR_DOM_BAD_URI = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1012)
NS_ERROR_DOM_DATA_CLONE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 25)
NS_ERROR_DOM_FILEHANDLE_ABORT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILEHANDLE, 4)
NS_ERROR_DOM_FILEHANDLE_LOCKEDFILE_INACTIVE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILEHANDLE, 3)
NS_ERROR_DOM_FILEHANDLE_NOT_ALLOWED_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILEHANDLE, 2)
NS_ERROR_DOM_FILEHANDLE_READ_ONLY_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILEHANDLE, 5)
NS_ERROR_DOM_FILEHANDLE_UNKNOWN_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILEHANDLE, 1)
NS_ERROR_DOM_FILE_ABORT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILE, 2)
NS_ERROR_DOM_FILE_NOT_FOUND_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILE, 0)
NS_ERROR_DOM_FILE_NOT_READABLE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_FILE, 1)
NS_ERROR_DOM_HIERARCHY_REQUEST_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 3)
NS_ERROR_DOM_INDEXEDDB_ABORT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 8)
NS_ERROR_DOM_INDEXEDDB_CONSTRAINT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 4)
NS_ERROR_DOM_INDEXEDDB_DATA_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 5)
NS_ERROR_DOM_INDEXEDDB_NOT_ALLOWED_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 6)
NS_ERROR_DOM_INDEXEDDB_NOT_FOUND_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 3)
NS_ERROR_DOM_INDEXEDDB_QUOTA_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 11)
NS_ERROR_DOM_INDEXEDDB_READ_ONLY_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 9)
NS_ERROR_DOM_INDEXEDDB_RECOVERABLE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 1001)
NS_ERROR_DOM_INDEXEDDB_TIMEOUT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 10)
NS_ERROR_DOM_INDEXEDDB_TRANSACTION_INACTIVE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 7)
NS_ERROR_DOM_INDEXEDDB_UNKNOWN_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 1)
NS_ERROR_DOM_INDEXEDDB_VERSION_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_INDEXEDDB, 12)
NS_ERROR_DOM_INDEX_SIZE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1)
NS_ERROR_DOM_INUSE_ATTRIBUTE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 10)
NS_ERROR_DOM_INVALID_ACCESS_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 15)
NS_ERROR_DOM_INVALID_CHARACTER_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 5)
NS_ERROR_DOM_INVALID_EXPRESSION_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_XPATH, 51)
NS_ERROR_DOM_INVALID_MODIFICATION_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 13)
NS_ERROR_DOM_INVALID_NODE_TYPE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 24)
NS_ERROR_DOM_INVALID_STATE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 11)
NS_ERROR_DOM_NAMESPACE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 14)
NS_ERROR_DOM_NETWORK_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 19)
NS_ERROR_DOM_NOT_BOOLEAN_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1006)
NS_ERROR_DOM_NOT_FOUND_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 8)
NS_ERROR_DOM_NOT_FUNCTION_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1007)
NS_ERROR_DOM_NOT_NUMBER_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1005)
NS_ERROR_DOM_NOT_OBJECT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1003)
NS_ERROR_DOM_NOT_SUPPORTED_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 9)
NS_ERROR_DOM_NOT_XPC_OBJECT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1004)
NS_ERROR_DOM_NO_MODIFICATION_ALLOWED_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 7)
NS_ERROR_DOM_PROP_ACCESS_DENIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1010)
NS_ERROR_DOM_QUOTA_EXCEEDED_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 22)
NS_ERROR_DOM_QUOTA_REACHED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1014)
NS_ERROR_DOM_RETVAL_UNDEFINED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1013)
NS_ERROR_DOM_SECMAN_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1001)
NS_ERROR_DOM_SECURITY_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 18)
NS_ERROR_DOM_SVG_MATRIX_NOT_INVERTABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SVG, 2)
NS_ERROR_DOM_SVG_WRONG_TYPE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_SVG, 0)
NS_ERROR_DOM_SYNTAX_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 12)
NS_ERROR_DOM_TIMEOUT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 23)
NS_ERROR_DOM_TOO_FEW_PARAMETERS_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1008)
NS_ERROR_DOM_TYPE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM_XPATH, 52)
NS_ERROR_DOM_TYPE_MISMATCH_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 17)
NS_ERROR_DOM_URL_MISMATCH_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 21)
NS_ERROR_DOM_WRONG_DOCUMENT_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 4)
NS_ERROR_DOM_WRONG_TYPE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1002)
NS_ERROR_DOM_XPCONNECT_ACCESS_DENIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 1011)
NS_ERROR_DOWNLOAD_COMPLETE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GENERAL, 1)
NS_ERROR_DOWNLOAD_NOT_PARTIAL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GENERAL, 2)
NS_ERROR_EDITOR_NO_SELECTION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_EDITOR, 1)
NS_ERROR_EDITOR_NO_TEXTNODE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_EDITOR, 2)
NS_ERROR_ENTITY_CHANGED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 32)
NS_ERROR_FILE_ACCESS_DENIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 21)
NS_ERROR_FILE_ALREADY_EXISTS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 8)
NS_ERROR_FILE_COPY_OR_MOVE_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 7)
NS_ERROR_FILE_CORRUPTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 11)
NS_ERROR_FILE_DESTINATION_NOT_DIR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 5)
NS_ERROR_FILE_DIR_NOT_EMPTY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 20)
NS_ERROR_FILE_DISK_FULL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 10)
NS_ERROR_FILE_EXECUTION_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 3)
NS_ERROR_FILE_INVALID_PATH = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 9)
NS_ERROR_FILE_IS_DIRECTORY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 13)
NS_ERROR_FILE_IS_LOCKED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 14)
NS_ERROR_FILE_NAME_TOO_LONG = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 17)
NS_ERROR_FILE_NOT_DIRECTORY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 12)
NS_ERROR_FILE_NOT_FOUND = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 18)
NS_ERROR_FILE_NO_DEVICE_SPACE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 16)
NS_ERROR_FILE_READ_ONLY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 19)
NS_ERROR_FILE_TARGET_DOES_NOT_EXIST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 6)
NS_ERROR_FILE_TOO_BIG = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 15)
NS_ERROR_FILE_UNKNOWN_TYPE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 4)
NS_ERROR_FILE_UNRECOGNIZED_PATH = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 1)
NS_ERROR_FILE_UNRESOLVABLE_SYMLINK = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 2)
NS_ERROR_FIRST_HEADER_FIELD_COMPONENT_EMPTY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 34)
NS_ERROR_FTP_CWD = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 22)
NS_ERROR_FTP_LIST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 28)
NS_ERROR_FTP_LOGIN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 21)
NS_ERROR_FTP_PASV = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 23)
NS_ERROR_FTP_PWD = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 24)
NS_ERROR_GFX_CMAP_MALFORMED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 51)
NS_ERROR_GFX_COULD_NOT_LOAD_PRINT_MODULE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 33)
NS_ERROR_GFX_NO_PRINTDIALOG_IN_TOOLKIT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 28)
NS_ERROR_GFX_NO_PRINTROMPTSERVICE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 29)
NS_ERROR_GFX_PRINTER_ACCESS_DENIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 6)
NS_ERROR_GFX_PRINTER_CMD_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 3)
NS_ERROR_GFX_PRINTER_CMD_NOT_FOUND = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 2)
NS_ERROR_GFX_PRINTER_COLORSPACE_NOT_SUPPORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 22)
NS_ERROR_GFX_PRINTER_COULD_NOT_OPEN_FILE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 12)
NS_ERROR_GFX_PRINTER_DOC_IS_BUSY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 31)
NS_ERROR_GFX_PRINTER_DOC_IS_BUSY_PP = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 25)
NS_ERROR_GFX_PRINTER_DOC_WAS_DESTORYED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 26)
NS_ERROR_GFX_PRINTER_DRIVER_CONFIGURATION_ERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 24)
NS_ERROR_GFX_PRINTER_ENDDOC = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 16)
NS_ERROR_GFX_PRINTER_ENDPAGE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 18)
NS_ERROR_GFX_PRINTER_FILE_IO_ERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 13)
NS_ERROR_GFX_PRINTER_INVALID_ATTRIBUTE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 7)
NS_ERROR_GFX_PRINTER_NAME_NOT_FOUND = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 5)
NS_ERROR_GFX_PRINTER_NO_PRINTER_AVAILABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 4)
NS_ERROR_GFX_PRINTER_NO_XUL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 27)
NS_ERROR_GFX_PRINTER_ORIENTATION_NOT_SUPPORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 21)
NS_ERROR_GFX_PRINTER_OUT_OF_PAPER = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 10)
NS_ERROR_GFX_PRINTER_PAPER_SIZE_NOT_SUPPORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 20)
NS_ERROR_GFX_PRINTER_PLEX_NOT_SUPPORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 30)
NS_ERROR_GFX_PRINTER_PRINTER_IO_ERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 11)
NS_ERROR_GFX_PRINTER_PRINTER_NOT_READY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 9)
NS_ERROR_GFX_PRINTER_PRINTPREVIEW = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 14)
NS_ERROR_GFX_PRINTER_PRINT_WHILE_PREVIEW = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 19)
NS_ERROR_GFX_PRINTER_RESOLUTION_NOT_SUPPORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 34)
NS_ERROR_GFX_PRINTER_STARTDOC = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 15)
NS_ERROR_GFX_PRINTER_STARTPAGE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 17)
NS_ERROR_GFX_PRINTER_TOO_MANY_COPIES = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 23)
NS_ERROR_GFX_PRINTING_NOT_IMPLEMENTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GFX, 32)
NS_ERROR_HOST_IS_IP_ADDRESS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 81)
NS_ERROR_HTMLPARSER_BADATTRIBUTE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1010)
NS_ERROR_HTMLPARSER_BADCONTEXT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1014)
NS_ERROR_HTMLPARSER_BADDTD = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1013)
NS_ERROR_HTMLPARSER_BADFILENAME = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1004)
NS_ERROR_HTMLPARSER_BADTOKENIZER = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1009)
NS_ERROR_HTMLPARSER_BADURL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1005)
NS_ERROR_HTMLPARSER_BLOCK = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1008)
NS_ERROR_HTMLPARSER_CANTPROPAGATE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1002)
NS_ERROR_HTMLPARSER_CONTEXTMISMATCH = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1003)
NS_ERROR_HTMLPARSER_EOF = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1000)
NS_ERROR_HTMLPARSER_FAKE_ENDTAG = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1018)
NS_ERROR_HTMLPARSER_HIERARCHYTOODEEP = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1017)
NS_ERROR_HTMLPARSER_INTERRUPTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1007)
NS_ERROR_HTMLPARSER_INVALIDPARSERCONTEXT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1006)
NS_ERROR_HTMLPARSER_INVALID_COMMENT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1019)
NS_ERROR_HTMLPARSER_MISPLACEDTABLECONTENT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1012)
NS_ERROR_HTMLPARSER_STOPPARSING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1015)
NS_ERROR_HTMLPARSER_UNKNOWN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1001)
NS_ERROR_HTMLPARSER_UNRESOLVEDDTD = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1011)
NS_ERROR_HTMLPARSER_UNTERMINATEDSTRINGLITERAL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_HTMLPARSER, 1016)
NS_ERROR_ILLEGAL_DURING_SHUTDOWN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM, 30)
NS_ERROR_IMAGE_BLOCKED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_CONTENT, 5)
NS_ERROR_IMAGE_SRC_CHANGED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_CONTENT, 4)
NS_ERROR_INSUFFICIENT_DOMAIN_LEVELS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 80)
NS_ERROR_INVALID_CONTENT_ENCODING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 27)
NS_ERROR_IN_PROGRESS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 15)
NS_ERROR_LAUNCHED_CHILD_PROCESS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_PROFILE, 200)
NS_ERROR_LOSS_OF_SIGNIFICANT_DATA = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM, 3)
NS_ERROR_MALFORMED_URI = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 10)
NS_ERROR_MALWARE_URI = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_URILOADER, 30)
NS_ERROR_NET_INTERRUPT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 71)
NS_ERROR_NET_RESET = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 20)
NS_ERROR_NET_TIMEOUT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 14)
NS_ERROR_NOT_CONNECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 12)
NS_ERROR_NOT_IN_TREE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GENERAL, 38)
NS_ERROR_NOT_RESUMABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 25)
NS_ERROR_NOT_SAME_THREAD = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM, 4)
NS_ERROR_NO_CONTENT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 17)
NS_ERROR_OBJECT_IS_IMMUTABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM, 2)
NS_ERROR_OFFLINE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 16)
NS_ERROR_PARSED_DATA_CACHED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_URILOADER, 33)
NS_ERROR_PHISHING_URI = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_URILOADER, 31)
NS_ERROR_PLUGINS_PLUGINSNOTCHANGED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_PLUGINS, 1000)
NS_ERROR_PLUGIN_BLOCKLISTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_PLUGINS, 1002)
NS_ERROR_PLUGIN_CLICKTOPLAY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_PLUGINS, 1004)
NS_ERROR_PLUGIN_DISABLED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_PLUGINS, 1001)
NS_ERROR_PLUGIN_TIME_RANGE_NOT_SUPPORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_PLUGINS, 1003)
NS_ERROR_PORT_ACCESS_NOT_ALLOWED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 19)
NS_ERROR_PROXY_CONNECTION_REFUSED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 72)
NS_ERROR_RANGE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 27)
NS_ERROR_REDIRECT_LOOP = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 31)
NS_ERROR_REMOTE_XUL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 75)
NS_ERROR_SAVE_LINK_AS_TIMEOUT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_URILOADER, 32)
NS_ERROR_SERVICE_IN_USE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCOM, 23)
NS_ERROR_SERVICE_NOT_AVAILABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM, 22)
NS_ERROR_SERVICE_NOT_FOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCOM, 22)
NS_ERROR_SOCKET_CREATE_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 52)
NS_ERROR_STORAGE_BUSY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_STORAGE, 1)
NS_ERROR_STORAGE_CONSTRAINT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_STORAGE, 3)
NS_ERROR_STORAGE_IOERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_STORAGE, 2)
NS_ERROR_TYPE_ERR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_DOM, 26)
NS_ERROR_UCONV_NOCONV = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_UCONV, 1)
NS_ERROR_UDEC_ILLEGALINPUT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_UCONV, 14)
NS_ERROR_UENC_NOMAPPING = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 35)
NS_ERROR_UNKNOWN_HOST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 30)
NS_ERROR_UNKNOWN_PROTOCOL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 18)
NS_ERROR_UNKNOWN_PROXY_HOST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 42)
NS_ERROR_UNKNOWN_SOCKET_TYPE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 51)
NS_ERROR_UNORM_MOREOUTPUT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_GENERAL, 33)
NS_ERROR_UNSAFE_CONTENT_TYPE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 74)
NS_ERROR_WONT_HANDLE_CONTENT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_URILOADER, 1)
NS_ERROR_XBL_BLOCKED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_CONTENT, 15)
NS_ERROR_XPATH_BAD_ARGUMENT_COUNT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 13)
NS_ERROR_XPATH_BAD_BANG = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 24)
NS_ERROR_XPATH_BAD_COLON = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 23)
NS_ERROR_XPATH_BAD_EXTENSION_FUNCTION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 14)
NS_ERROR_XPATH_BINARY_EXPECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 26)
NS_ERROR_XPATH_BRACKET_EXPECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 18)
NS_ERROR_XPATH_ILLEGAL_CHAR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 25)
NS_ERROR_XPATH_INVALID_AXIS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 16)
NS_ERROR_XPATH_INVALID_EXPRESSION_EVALUATED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 28)
NS_ERROR_XPATH_INVALID_VAR_NAME = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 19)
NS_ERROR_XPATH_NO_NODE_TYPE_TEST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 17)
NS_ERROR_XPATH_OPERATOR_EXPECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 21)
NS_ERROR_XPATH_PAREN_EXPECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 15)
NS_ERROR_XPATH_PARSE_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 2)
NS_ERROR_XPATH_UNBALANCED_CURLY_BRACE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 29)
NS_ERROR_XPATH_UNCLOSED_LITERAL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 22)
NS_ERROR_XPATH_UNEXPECTED_END = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 20)
NS_ERROR_XPATH_UNKNOWN_FUNCTION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 5)
NS_ERROR_XPC_BAD_CID = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 23)
NS_ERROR_XPC_BAD_CONVERT_JS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 9)
NS_ERROR_XPC_BAD_CONVERT_JS_NULL_REF = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 11)
NS_ERROR_XPC_BAD_CONVERT_JS_ZERO_ISNOT_NULL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 53)
NS_ERROR_XPC_BAD_CONVERT_NATIVE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 10)
NS_ERROR_XPC_BAD_ID_STRING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 49)
NS_ERROR_XPC_BAD_IID = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 24)
NS_ERROR_XPC_BAD_INITIALIZER_NAME = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 50)
NS_ERROR_XPC_BAD_OP_ON_WN_PROTO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 12)
NS_ERROR_XPC_CALL_TO_SCRIPTABLE_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 47)
NS_ERROR_XPC_CANT_ADD_PROP_TO_WRAPPED_NATIVE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 46)
NS_ERROR_XPC_CANT_CALL_WO_SCRIPTABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 19)
NS_ERROR_XPC_CANT_CONVERT_OBJECT_TO_ARRAY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 35)
NS_ERROR_XPC_CANT_CONVERT_PRIMITIVE_TO_ARRAY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 34)
NS_ERROR_XPC_CANT_CONVERT_WN_TO_FUN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 13)
NS_ERROR_XPC_CANT_CREATE_WN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 25)
NS_ERROR_XPC_CANT_CTOR_WO_SCRIPTABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 20)
NS_ERROR_XPC_CANT_DEFINE_PROP_ON_WN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 14)
NS_ERROR_XPC_CANT_EXPORT_WN_STATIC = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 16)
NS_ERROR_XPC_CANT_GET_ARRAY_INFO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 37)
NS_ERROR_XPC_CANT_GET_INTERFACE_INFO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 5)
NS_ERROR_XPC_CANT_GET_JSOBJECT_OF_DOM_OBJECT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 42)
NS_ERROR_XPC_CANT_GET_METHOD_INFO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 7)
NS_ERROR_XPC_CANT_GET_PARAM_IFACE_INFO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 6)
NS_ERROR_XPC_CANT_MODIFY_PROP_ON_WN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 52)
NS_ERROR_XPC_CANT_SET_OUT_VAL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 3)
NS_ERROR_XPC_CANT_SET_READ_ONLY_ATTRIBUTE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 44)
NS_ERROR_XPC_CANT_SET_READ_ONLY_CONSTANT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 43)
NS_ERROR_XPC_CANT_SET_READ_ONLY_METHOD = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 45)
NS_ERROR_XPC_CANT_WATCH_WN_STATIC = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 15)
NS_ERROR_XPC_CI_RETURNED_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 21)
NS_ERROR_XPC_GS_RETURNED_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 22)
NS_ERROR_XPC_HAS_BEEN_SHUTDOWN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 51)
NS_ERROR_XPC_INTERFACE_NOT_FROM_NSISUPPORTS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 41)
NS_ERROR_XPC_INTERFACE_NOT_SCRIPTABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 40)
NS_ERROR_XPC_JAVASCRIPT_ERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 32)
NS_ERROR_XPC_JAVASCRIPT_ERROR_WITH_DETAILS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 33)
NS_ERROR_XPC_JSOBJECT_HAS_NO_FUNCTION_NAMED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 48)
NS_ERROR_XPC_JS_THREW_EXCEPTION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 26)
NS_ERROR_XPC_JS_THREW_JS_OBJECT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 28)
NS_ERROR_XPC_JS_THREW_NATIVE_OBJECT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 27)
NS_ERROR_XPC_JS_THREW_NULL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 29)
NS_ERROR_XPC_JS_THREW_NUMBER = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 31)
NS_ERROR_XPC_JS_THREW_STRING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 30)
NS_ERROR_XPC_NATIVE_RETURNED_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 4)
NS_ERROR_XPC_NEED_OUT_OBJECT = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 2)
NS_ERROR_XPC_NOT_ENOUGH_ARGS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 1)
NS_ERROR_XPC_NOT_ENOUGH_CHARS_IN_STRING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 38)
NS_ERROR_XPC_NOT_ENOUGH_ELEMENTS_IN_ARRAY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 36)
NS_ERROR_XPC_SCRIPTABLE_CALL_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 17)
NS_ERROR_XPC_SCRIPTABLE_CTOR_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 18)
NS_ERROR_XPC_SECURITY_MANAGER_VETO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 39)
NS_ERROR_XPC_UNEXPECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCONNECT, 8)
NS_ERROR_XSLT_ABORTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 9)
NS_ERROR_XSLT_ALREADY_SET = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 3)
NS_ERROR_XSLT_BAD_NODE_NAME = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 30)
NS_ERROR_XSLT_BAD_RECURSION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 6)
NS_ERROR_XSLT_BAD_VALUE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 7)
NS_ERROR_XSLT_EXECUTION_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 4)
NS_ERROR_XSLT_LOAD_BLOCKED_ERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 27)
NS_ERROR_XSLT_LOAD_RECURSION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 12)
NS_ERROR_XSLT_NETWORK_ERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 10)
NS_ERROR_XSLT_NODESET_EXPECTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 8)
NS_ERROR_XSLT_PARSE_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 1)
NS_ERROR_XSLT_VAR_ALREADY_SET = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 31)
NS_ERROR_XSLT_WRONG_MIME_TYPE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XSLT, 11)
NS_FINDBROADCASTER_AWAIT_OVERLAYS = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_CONTENT, 14)
NS_FINDBROADCASTER_FOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_CONTENT, 13)
NS_FINDBROADCASTER_NOT_FOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_CONTENT, 12)
NS_FOUND_TARGET = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_EDITOR, 3)
NS_HTMLPARSER_VALID_META_CHARSET = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_HTMLPARSER, 3000)
NS_HTMLTOKENS_NOT_AN_ENTITY = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_HTMLPARSER, 2000)
NS_HTML_STYLE_PROPERTY_NOT_THERE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_CONTENT, 2)
NS_IMAGELIB_CHANGING_OWNER = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_IMGLIB, 1)
NS_IMAGELIB_ERROR_FAILURE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_IMGLIB, 5)
NS_IMAGELIB_ERROR_NOT_FINISHED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_IMGLIB, 7)
NS_IMAGELIB_ERROR_NO_DECODER = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_IMGLIB, 6)
NS_IMAGELIB_ERROR_NO_ENCODER = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_IMGLIB, 9)
NS_IMAGELIB_SUCCESS_LOAD_FINISHED = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_IMGLIB, 0)
NS_NET_STATUS_BEGIN_FTP_TRANSACTION = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_NETWORK, 27)
NS_NET_STATUS_CONNECTED_TO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 4)
NS_NET_STATUS_CONNECTING_TO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 7)
NS_NET_STATUS_END_FTP_TRANSACTION = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_NETWORK, 28)
NS_NET_STATUS_READING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 8)
NS_NET_STATUS_RECEIVING_FROM = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 6)
NS_NET_STATUS_RESOLVED_HOST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 11)
NS_NET_STATUS_RESOLVING_HOST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 3)
NS_NET_STATUS_SENDING_TO = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 5)
NS_NET_STATUS_WAITING_FOR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 10)
NS_NET_STATUS_WRITING = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 9)
NS_OK_DEFUNCT_OBJECT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 34)
NS_OK_EMPTY_NAME = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 35)
NS_OK_NAME_FROM_TOOLTIP = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 37)
NS_OK_NO_ARIA_VALUE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 33)
NS_OK_NO_NAME_CLAUSE_HANDLED = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 36)
NS_OK_UDEC_EXACTLENGTH = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 11)
NS_OK_UDEC_MOREINPUT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 12)
NS_OK_UDEC_MOREOUTPUT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 13)
NS_OK_UDEC_NOBOMFOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 14)
NS_OK_UENC_EXACTLENGTH = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 33)
NS_OK_UENC_MOREINPUT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 36)
NS_OK_UENC_MOREOUTPUT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 34)
NS_POSITION_BEFORE_TABLE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_LAYOUT, 3)
NS_PROPTABLE_PROP_NOT_THERE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_CONTENT, 10)
NS_PROPTABLE_PROP_OVERWRITTEN = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_CONTENT, 11)
NS_RDF_ASSERTION_REJECTED = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_RDF, 3)
NS_RDF_CURSOR_EMPTY = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_RDF, 1)
NS_RDF_NO_VALUE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_RDF, 2)
NS_RDF_STOP_VISIT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_RDF, 4)
NS_REFRESHURI_HEADER_FOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_URILOADER, 2)
NS_STATE_PROPERTY_NOT_THERE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_LAYOUT, 5)
NS_SUCCESS_ADOPTED_DATA = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_NETWORK, 90)
NS_SUCCESS_AGGREGATE_RESULT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_FILES, 2)
NS_SUCCESS_ALLOW_SLIM_WRAPPERS = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCONNECT, 3)
NS_SUCCESS_AUTH_FINISHED = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_NETWORK, 40)
NS_SUCCESS_CHROME_ACCESS_ONLY = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCONNECT, 2)
NS_SUCCESS_DONT_FIXUP = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 1)
NS_SUCCESS_FILE_DIRECTORY_EMPTY = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_FILES, 1)
NS_SUCCESS_IME_NO_UPDATES = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_WIDGET, 1)
NS_SUCCESS_INTERRUPTED_TRAVERSE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCOM, 2)
NS_SUCCESS_I_DID_SOMETHING = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCONNECT, 1)
NS_SUCCESS_LOSS_OF_INSIGNIFICANT_DATA = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCOM, 1)
NS_SUCCESS_RESTART_APP = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 1)
NS_SUCCESS_UNORM_NOTFOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_GENERAL, 17)
NS_SUCCESS_USING_FALLBACK_LOCALE = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_UCONV, 2)
NS_TABLELAYOUT_CELL_NOT_FOUND = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_LAYOUT, 0)
NS_XSLT_GET_NEW_HANDLER = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XSLT, 1)
NS_ERROR_ILLEGAL_INPUT = NS_ERROR_UDEC_ILLEGALINPUT
NS_EXACT_LENGTH = NS_OK_UDEC_EXACTLENGTH
NS_PARTIAL_MORE_INPUT = NS_OK_UDEC_MOREINPUT
NS_PARTIAL_MORE_OUTPUT = NS_OK_UDEC_MOREOUTPUT
