/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Arabic *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-14 21:49:25.799709
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_6_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 55, 59, 54, 63, 67, 71, 75, 72, 62, 79, 81, 69, 65, 66, 70, /* 4X */
   58, 89, 68, 49, 60, 78, 80, 76, 90, 88, 86,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 35, 61, 45, 46, 34, 56, 52, 48, 36, 84, 74, 44, 50, 38, 37, /* 6X */
   51, 83, 39, 43, 42, 47, 64, 73, 82, 53, 77,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,ILL,ILL,ILL,SYM,ILL,ILL,ILL,ILL,ILL,ILL,ILL,SYM,SYM,ILL,ILL, /* AX */
  ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,SYM,ILL,ILL,ILL,SYM, /* BX */
  ILL, 32, 40, 17, 41, 25, 31,  0,  8,  9,  7, 26, 19, 18, 24, 11, /* CX */
   29,  6, 27, 12, 22, 21, 28,SYM, 33, 10, 30,ILL,ILL,ILL,ILL,ILL, /* DX */
   57, 13, 15, 14,  1,  3,  5, 16,  4, 23,  2,SYM,SYM,SYM,SYM,SYM, /* EX */
  SYM,SYM,SYM,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1256_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 55, 59, 54, 63, 67, 71, 75, 72, 62, 79, 81, 69, 65, 66, 70, /* 4X */
   58, 89, 68, 49, 60, 78, 80, 76, 90, 88, 86,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 35, 61, 45, 46, 34, 56, 52, 48, 36, 84, 74, 44, 50, 38, 37, /* 6X */
   51, 83, 39, 43, 42, 47, 64, 73, 82, 53, 77,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM, 91,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,102,SYM,103, 97,104, 98, /* 8X */
   87,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 93,SYM,105,SYM,106,SYM,SYM,107, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,108,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  109, 32, 40, 17, 41, 25, 31,  0,  8,  9,  7, 26, 19, 18, 24, 11, /* CX */
   29,  6, 27, 12, 22, 21, 28,SYM, 20, 33, 10, 30, 57, 13, 15, 14, /* DX */
  110,  1, 95,  3,  5, 16,  4,100, 94, 85, 96,111, 23,  2, 99,101, /* EX */
  SYM,SYM,SYM,SYM,112,SYM,SYM,SYM,SYM,113,SYM,114, 92,SYM,SYM,115, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 64;
static const unsigned int Unicode_CharOrder[] =
{
    65, 55,   66, 59,   67, 54,   68, 63,   73, 62,   80, 58,   83, 49,  84, 60,
    97, 35,   98, 61,   99, 45,  100, 46,  101, 34,  102, 56,  103, 52, 104, 48,
   105, 36,  108, 44,  109, 50,  110, 38,  111, 37,  112, 51,  114, 39, 115, 43,
   116, 42,  117, 47,  121, 53, 1569, 32, 1570, 40, 1571, 17, 1572, 41,1573, 25,
  1574, 31, 1575,  0, 1576,  8, 1577,  9, 1578,  7, 1579, 26, 1580, 19,1581, 18,
  1582, 24, 1583, 11, 1584, 29, 1585,  6, 1586, 27, 1587, 12, 1588, 22,1589, 21,
  1590, 28, 1591, 20, 1592, 33, 1593, 10, 1594, 30, 1600, 57, 1601, 13,1602, 15,
  1603, 14, 1604,  1, 1605,  3, 1606,  5, 1607, 16, 1608,  4, 1609, 23,1610,  2,
};


/* Model Table:
 * Total considered sequences: 2046 / 4096
 * - Positive sequences: first 1011 (0.9950032726169761)
 * - Probable sequences: next 415 (1426-1011) (0.004000386891877872)
 * - Neutral sequences: last 2670 (0.0009963404911460527)
 * - Negative sequences: 2050 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 ArabicLangModel[] =
{
  1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,1,3,3,3,3,3,3,
   3,3,0,0,0,0,0,0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   1,3,0,0,0,0,0,0,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,0,3,3,3,3,3,3,
   3,3,0,0,0,0,0,0,0,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,
   0,3,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   3,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,1,2,3,3,3,3,3,
   0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,2,3,3,
   2,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,2,
   0,3,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,
   1,2,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,3,0,0,0,0,0,0,
  2,0,1,2,1,0,1,2,2,0,1,1,1,1,2,1,1,1,1,1,0,0,1,0,1,2,0,1,0,0,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,0,0,3,3,3,3,3,0,0,3,3,3,3,0,0,
   0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,3,3,0,3,3,0,0,2,3,
   3,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,1,1,1,0,1,0,2,
   0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,
   1,3,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,3,2,2,2,3,3,1,3,1,1,
   0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,0,2,1,3,3,3,3,0,0,0,3,3,2,0,0,
   0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,0,3,2,2,3,2,3,0,0,3,2,1,2,3,0,0,0,3,3,3,0,1,
   0,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,
  0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,0,3,3,3,3,3,1,
   0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,0,2,3,3,3,3,3,0,0,3,3,3,3,1,0,
   0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,0,2,1,0,0,0,2,3,0,3,3,3,
   0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,1,3,3,3,3,1,3,0,2,3,1,0,0,1,0,0,2,3,
   2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,3,3,0,3,0,3,3,0,3,3,0,0,0,0,0,3,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,0,1,2,3,0,0,0,0,1,3,3,
   0,2,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,1,3,3,3,0,0,3,0,0,1,3,3,3,1,1,0,1,3,3,3,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,1,3,3,3,3,0,3,3,3,3,3,3,2,0,3,3,3,3,3,0,3,0,3,3,3,3,3,0,
   0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,1,1,1,2,1,3,3,1,0,0,0,0,0,2,0,0,2,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,2,3,3,0,0,0,2,3,0,0,2,0,0,1,3,
   3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,3,3,3,3,0,3,0,0,3,1,3,2,3,0,0,3,3,0,0,0,1,0,3,2,
   0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,3,3,3,3,3,2,0,0,2,3,0,3,0,0,3,0,0,0,2,2,0,0,0,0,0,0,2,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,0,3,3,2,0,0,2,0,0,1,3,1,2,2,0,0,1,3,3,3,0,0,
   0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,2,1,0,0,0,3,2,3,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,2,1,2,1,1,1,3,1,3,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,2,1,3,0,0,0,3,0,0,3,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,3,3,0,0,3,3,3,3,3,2,1,1,3,3,3,2,0,0,2,0,0,0,0,2,0,0,
  0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,2,3,1,3,3,0,0,3,3,3,3,3,3,2,0,3,3,3,3,1,0,2,0,1,0,0,3,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,2,3,3,3,0,0,3,3,3,3,3,2,1,1,3,3,3,1,0,0,2,0,0,0,0,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,2,2,3,3,3,0,0,3,3,3,3,3,3,2,0,3,3,3,2,1,0,3,0,0,0,0,3,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,3,1,0,0,3,3,3,3,3,2,1,0,1,0,3,1,0,0,2,0,0,0,0,2,0,0,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,3,3,0,0,3,3,3,3,3,3,1,0,2,1,3,3,0,0,2,0,0,0,1,2,0,0,
  0,3,3,3,2,3,3,3,3,3,0,3,3,2,2,1,2,0,1,1,0,1,3,1,3,0,3,2,0,3,1,1,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,1,0,0,3,3,0,3,3,3,0,0,1,1,0,2,2,2,0,3,0,0,2,0,0,
   0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,1,3,0,0,3,3,2,2,0,3,3,0,2,2,0,3,1,0,1,0,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,0,1,0,0,3,3,2,3,2,2,3,0,3,3,0,2,0,0,2,0,0,0,0,1,0,0,
  0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,0,1,0,0,3,2,3,1,3,3,1,0,2,2,2,3,0,0,2,0,0,0,0,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,1,2,0,0,3,2,3,2,0,2,3,0,2,0,0,3,1,0,0,0,0,2,0,0,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,1,2,0,0,1,2,2,0,2,2,1,1,1,1,2,2,0,1,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,2,3,3,0,0,3,3,3,3,3,0,0,0,3,2,2,1,0,0,1,0,0,0,0,3,0,0,
  0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,2,2,0,0,2,0,1,0,0,2,0,0,1,1,0,2,0,0,1,0,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,3,2,3,0,0,0,0,3,0,0,3,0,2,3,1,2,2,0,2,2,2,0,0,1,3,3,0,1,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,1,0,0,0,0,2,0,0,0,2,1,0,2,3,0,2,0,0,1,0,1,0,0,3,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,3,0,3,0,0,2,2,3,0,1,2,3,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,2,3,2,2,3,0,0,2,2,2,0,1,2,3,0,1,0,1,2,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,2,0,1,1,2,0,0,1,2,2,3,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,3,2,3,0,2,0,0,0,0,2,0,1,2,3,2,0,0,0,1,2,2,0,0,1,0,1,0,1,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,1,2,0,2,3,0,0,1,2,2,2,2,2,0,2,2,1,2,1,2,1,2,0,1,1,1,2,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,2,3,3,0,2,0,0,2,1,1,0,0,0,0,1,1,0,1,1,0,0,2,0,0,0,0,1,0,0,
  2,1,2,1,1,1,1,2,1,2,1,2,0,0,1,1,2,1,0,0,1,1,0,0,0,0,0,1,0,0,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,3,2,3,0,3,0,0,0,1,2,0,0,2,2,2,0,0,0,1,2,1,0,0,1,0,0,0,1,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,2,2,3,0,3,0,0,0,0,2,0,0,2,1,0,0,0,0,2,2,2,0,0,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,2,2,2,0,3,0,0,0,0,0,1,0,2,3,2,0,0,0,1,0,2,0,0,0,0,1,0,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,2,3,1,3,0,0,1,2,3,0,2,2,2,0,0,1,0,2,0,0,0,0,0,0,0,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,1,0,1,3,2,0,0,1,2,1,1,0,1,0,3,2,0,0,0,2,1,0,0,0,2,2,1,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,2,0,1,0,0,0,2,0,0,0,2,0,1,0,0,0,0,1,0,0,0,1,2,1,2,1,2,
};


const SequenceModel Iso_8859_6ArabicModel =
{
  Iso_8859_6_CharToOrderMap,
  ArabicLangModel,
  64,
  (float)0.999003659508854,
  PR_FALSE,
  "ISO-8859-6",
  "ar"
};

const SequenceModel Windows_1256ArabicModel =
{
  Windows_1256_CharToOrderMap,
  ArabicLangModel,
  64,
  (float)0.999003659508854,
  PR_FALSE,
  "WINDOWS-1256",
  "ar"
};

const LanguageModel ArabicModel =
{
  "ar",
  Unicode_CharOrder,
  64,
  ArabicLangModel,
  64,
  4,
  (float)0.40059675552120994,
  29,
  (float)0.033261237094477154,
};
