/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Croatian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-14 21:57:58.988239
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_2_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 4X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 6X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 54,SYM, 53,SYM, 55, 56,SYM,SYM, 22, 40, 57, 58,SYM, 25, 41, /* AX */
  SYM, 59,SYM, 53,SYM, 60, 61,SYM,SYM, 22, 40, 62, 63,SYM, 25, 41, /* BX */
   64, 39, 37, 65, 36, 66, 24, 44, 20, 31, 67, 68, 69, 70, 71, 72, /* CX */
   26, 73, 74, 38, 75, 51, 32,SYM, 76, 50, 42, 77, 33, 78, 79, 45, /* DX */
   80, 39, 37, 81, 36, 82, 24, 44, 20, 31, 83, 84, 85, 86, 87, 88, /* EX */
   26, 89, 90, 38, 91, 51, 32,SYM, 92, 50, 42, 93, 33, 94, 95,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_13_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 4X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 6X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 34,SYM, 96,SYM,SYM,SYM,SYM, 49, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 34,SYM, 97,SYM,SYM,SYM,SYM, 49, /* BX */
   98, 99,100, 24, 36,101,102, 46, 20, 31,103,104,105,106, 47,107, /* CX */
   22,108,109, 38, 43,110, 32,SYM,111, 53,112, 48, 33, 41, 25, 45, /* DX */
  113,114,115, 24, 36,116,117, 46, 20, 31,118,119,120,121, 47,122, /* EX */
   22,123,124, 38, 43,125, 32,SYM,126, 53,127, 48, 33, 41, 25,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_16_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 4X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 6X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,128,129, 53,SYM,SYM, 22,SYM, 22,SYM, 52,SYM,130,SYM,131, 41, /* AX */
  SYM,SYM, 20, 53, 25,SYM,SYM,SYM, 25, 20, 52,SYM,132,133,134, 41, /* BX */
  135, 39, 37,136, 36, 24, 49, 44, 35, 31,137,138,139,140,141,142, /* CX */
   26,143,144, 38,145, 51, 32,146,147,148, 42,149, 33,150,151, 45, /* DX */
  152, 39, 37,153, 36, 24, 49, 44, 35, 31,154,155,156,157,158,159, /* EX */
   26,160,161, 38,162, 51, 32,163,164,165, 42,166, 33,167,168,169, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1250_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 4X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 6X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,ILL,SYM,SYM,SYM,SYM,ILL,SYM, 22,SYM,170,171, 25,172, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 22,SYM,173,174, 25,175, /* 9X */
  SYM,SYM,SYM, 53,SYM,176,SYM,SYM,SYM,SYM, 40,SYM,SYM,SYM,SYM, 41, /* AX */
  SYM,SYM,SYM, 53,SYM,SYM,SYM,SYM,SYM,177, 40,SYM,178,SYM,179, 41, /* BX */
  180, 39, 37,181, 36,182, 24, 44, 20, 31,183,184,185,186,187,188, /* CX */
   26,189,190, 38,191, 51, 32,SYM,192, 50, 42,193, 33,194,195, 45, /* DX */
  196, 39, 37,197, 36,198, 24, 44, 20, 31,199,200,201,202,203,204, /* EX */
   26,205,206, 38,207, 51, 32,SYM,208, 50, 42,209, 33,210,211,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm852_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 4X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 6X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,CTR, /* 7X */
   44, 33, 31, 37, 36, 50, 24, 44, 53,212, 51, 51,213,214, 36, 24, /* 8X */
   31,215,216,217, 32,218,219,220,221, 32, 33,222,223, 53,SYM, 20, /* 9X */
   39,224, 38, 42,225,226, 25, 25,227,228,SYM,229, 20, 40,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 39, 37,230, 40,SYM,SYM,SYM,SYM, 41, 41,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM,231,232,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
   26, 26,233,234,235,236,237,238,239,SYM,SYM,SYM,SYM,240, 50,SYM, /* DX */
   38, 45,241,242,243,244, 22, 22,245, 42,246,247,248,249,249,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,249,249,249,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Mac_Centraleurope_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 4X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 19, 14,  2, 23, 17, 21,  1,  6, 10, 11, 12,  4,  3, /* 6X */
   15, 30,  5,  8,  7,  9, 13, 28, 29, 27, 16,SYM,SYM,SYM,SYM,CTR, /* 7X */
   36,249,249, 31,249, 32, 33, 39,249, 20, 36, 20, 24, 24, 31,249, /* 8X */
  249,249,249,249, 46, 46,249, 38,249,249, 32,249, 42,249,249, 33, /* 9X */
  SYM,SYM,249,SYM,SYM,SYM,SYM, 45,SYM,SYM,SYM,249,SYM,SYM,249,249, /* AX */
  249, 47,SYM,SYM, 47,249,SYM,SYM, 53,249,249,249,249,249,249,249, /* BX */
  249,249,SYM,SYM,249,249,SYM,SYM,SYM,SYM,SYM,249, 51,249, 51, 43, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 43,249,249,249,SYM,SYM,249,249, /* DX */
  249, 22,SYM,SYM, 22,249,249, 39,249,249,249, 25, 25, 48, 38,249, /* EX */
   48, 50, 42, 50,249,249,249,249,249,249,249, 41, 53, 41,249,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 62;
static const unsigned int Unicode_CharOrder[] =
{
   65,  0,  66, 18,  67, 19,  68, 14,  69,  2,  70, 23,  71, 17, 72, 21,
   73,  1,  74,  6,  75, 10,  76, 11,  77, 12,  78,  4,  79,  3, 80, 15,
   81, 30,  82,  5,  83,  8,  84,  7,  85,  9,  86, 13,  87, 28, 88, 29,
   89, 27,  90, 16,  97,  0,  98, 18,  99, 19, 100, 14, 101,  2,102, 23,
  103, 17, 104, 21, 105,  1, 106,  6, 107, 10, 108, 11, 109, 12,110,  4,
  111,  3, 112, 15, 113, 30, 114,  5, 115,  8, 116,  7, 117,  9,118, 13,
  119, 28, 120, 29, 121, 27, 122, 16, 262, 24, 263, 24, 268, 20,269, 20,
  272, 26, 273, 26, 352, 22, 353, 22, 381, 25, 382, 25,
};


/* Model Table:
 * Total considered sequences: 814 / 961
 * - Positive sequences: first 402 (0.9950352500193897)
 * - Probable sequences: next 120 (522-402) (0.003975137961536701)
 * - Neutral sequences: last 439 (0.0009896120190735491)
 * - Negative sequences: 147 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 CroatianLangModel[] =
{
  2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,1,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,2,1,
  3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,0,
  3,3,3,3,2,2,3,3,3,3,3,2,2,3,3,3,3,3,2,3,3,2,1,3,0,2,1,1,0,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,2,2,0,1,
  3,3,3,3,3,2,2,2,3,3,3,2,3,3,3,3,2,1,3,2,3,1,2,1,1,1,0,0,0,1,0,
  3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,2,1,2,0,3,0,2,0,0,0,3,1,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,1,1,2,3,1,3,0,3,0,0,0,1,1,0,2,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,1,0,1,0,
  3,3,3,3,3,3,2,3,3,3,0,3,3,3,1,1,1,3,0,3,1,2,3,1,1,0,0,1,2,0,0,
  3,3,3,3,3,1,3,3,3,3,3,3,3,2,2,2,2,2,2,2,0,1,0,3,0,1,0,2,1,1,0,
  3,3,3,3,3,3,3,1,3,3,2,3,3,1,2,3,0,2,3,2,2,2,0,2,1,0,0,1,2,0,0,
  3,3,3,3,3,3,3,1,2,3,2,3,1,1,2,0,0,1,1,3,2,1,2,1,0,0,1,1,0,0,0,
  3,3,3,3,3,3,3,2,3,3,1,3,3,3,1,1,2,3,3,1,0,2,1,1,0,3,0,1,2,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,2,1,0,1,3,2,3,2,1,3,0,0,1,1,1,0,
  3,3,3,3,3,3,2,0,1,3,1,3,3,3,3,0,1,3,3,0,0,1,0,0,0,1,0,0,1,0,0,
  3,3,3,3,3,3,0,1,2,3,1,3,2,1,3,1,1,2,1,1,0,3,0,1,0,0,0,1,1,1,0,
  3,3,3,3,3,3,3,1,1,3,0,3,0,1,2,1,3,0,2,1,0,0,0,1,0,0,0,1,1,1,0,
  3,3,3,3,2,3,2,2,2,3,3,3,2,1,3,1,1,1,1,2,0,3,0,1,0,0,0,1,0,1,1,
  3,3,3,2,3,0,3,0,0,3,3,3,1,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,0,3,2,3,1,3,2,3,1,1,2,1,2,2,0,0,1,2,0,0,1,2,1,1,0,
  3,3,3,2,3,1,1,3,0,3,3,3,1,2,0,2,0,0,0,1,2,0,0,0,3,0,0,0,0,0,0,
  3,3,3,3,2,3,1,3,2,3,1,3,1,1,1,1,0,2,1,1,0,1,0,2,0,0,0,0,1,1,0,
  3,3,3,3,3,0,1,1,0,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,1,2,0,0,3,0,2,1,0,2,0,0,0,3,1,0,0,0,0,0,0,1,0,0,0,0,
  3,3,3,1,0,0,0,0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,2,2,1,1,2,1,3,1,1,3,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,
  2,3,2,2,1,1,1,3,1,1,1,1,1,1,1,1,0,0,1,0,0,2,0,1,0,0,0,1,2,0,0,
  1,2,1,0,0,1,0,1,0,1,0,0,1,1,0,1,0,1,0,0,0,1,0,1,0,0,0,1,1,1,0,
  0,1,0,0,0,2,0,1,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
};


const SequenceModel Iso_8859_2CroatianModel =
{
  Iso_8859_2_CharToOrderMap,
  CroatianLangModel,
  31,
  (float)0.9990103879809265,
  PR_TRUE,
  "ISO-8859-2",
  "hr"
};

const SequenceModel Iso_8859_13CroatianModel =
{
  Iso_8859_13_CharToOrderMap,
  CroatianLangModel,
  31,
  (float)0.9990103879809265,
  PR_TRUE,
  "ISO-8859-13",
  "hr"
};

const SequenceModel Iso_8859_16CroatianModel =
{
  Iso_8859_16_CharToOrderMap,
  CroatianLangModel,
  31,
  (float)0.9990103879809265,
  PR_TRUE,
  "ISO-8859-16",
  "hr"
};

const SequenceModel Windows_1250CroatianModel =
{
  Windows_1250_CharToOrderMap,
  CroatianLangModel,
  31,
  (float)0.9990103879809265,
  PR_TRUE,
  "WINDOWS-1250",
  "hr"
};

const SequenceModel Ibm852CroatianModel =
{
  Ibm852_CharToOrderMap,
  CroatianLangModel,
  31,
  (float)0.9990103879809265,
  PR_TRUE,
  "IBM852",
  "hr"
};

const SequenceModel Mac_CentraleuropeCroatianModel =
{
  Mac_Centraleurope_CharToOrderMap,
  CroatianLangModel,
  31,
  (float)0.9990103879809265,
  PR_TRUE,
  "MAC-CENTRALEUROPE",
  "hr"
};

const LanguageModel CroatianModel =
{
  "hr",
  Unicode_CharOrder,
  62,
  CroatianLangModel,
  31,
  5,
  (float)0.4525866540568839,
  20,
  (float)0.0303664155164663,
};
