/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Danish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-14 21:51:50.797798
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 4X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 6X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM, 47,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 55, 48,SYM,SYM, 56,SYM,SYM,SYM, 57, 58, 59,SYM, /* BX */
   42, 33, 60, 41, 32, 20, 22, 37, 34, 28, 53, 38, 61, 36, 62, 63, /* CX */
   40, 39, 64, 35, 65, 66, 29,SYM, 19, 67, 43, 68, 31, 69, 70, 46, /* DX */
   42, 33, 71, 41, 32, 20, 22, 37, 34, 28, 53, 38, 72, 36, 73, 74, /* EX */
   40, 39, 75, 35, 76, 77, 29,SYM, 19, 78, 43, 79, 31, 80, 81, 82, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 4X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 6X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 48,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   42, 33, 83, 41, 32, 20, 22, 37, 34, 28, 53, 38, 84, 36, 85, 86, /* CX */
   40, 39, 87, 35, 88, 89, 29,SYM, 19, 90, 43, 91, 31, 92, 93, 46, /* DX */
   42, 33, 94, 41, 32, 20, 22, 37, 34, 28, 53, 38, 95, 36, 96, 97, /* EX */
   40, 39, 98, 35, 99,100, 29,SYM, 19,101, 43,102, 31,103,104,105, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 4X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 6X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,106,SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM,107,ILL,108,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM,109,ILL,110,111, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 48,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   42, 33,112, 41, 32, 20, 22, 37, 34, 28, 53, 38,113, 36,114,115, /* CX */
   40, 39,116, 35,117,118, 29,SYM, 19,119, 43,120, 31,121,122, 46, /* DX */
   42, 33,123, 41, 32, 20, 22, 37, 34, 28, 53, 38,124, 36,125,126, /* EX */
   40, 39,127, 35,128,129, 29,SYM, 19,130, 43,131, 31,132,133,134, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm865_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 4X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 16, 23,  7,  0, 13, 10, 17,  6, 24, 12,  9, 11,  2,  8, /* 6X */
   18, 30,  1,  4,  3, 15, 14, 25, 26, 21, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
   37, 31, 28,135, 32, 42, 20, 37, 53, 38, 34,136,137,138, 32, 20, /* 8X */
   28, 22, 22,139, 29,140,141,142,143, 29, 31, 19,SYM, 19,SYM,SYM, /* 9X */
   33, 36, 35, 43, 39, 39,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* DX */
   44, 46,144, 54, 51, 51, 48, 52, 50,145,146, 49,147, 50, 45,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 62;
static const unsigned int Unicode_CharOrder[] =
{
   65,  5,  66, 16,  67, 23,  68,  7,  69,  0,  70, 13,  71, 10, 72, 17,
   73,  6,  74, 24,  75, 12,  76,  9,  77, 11,  78,  2,  79,  8, 80, 18,
   81, 30,  82,  1,  83,  4,  84,  3,  85, 15,  86, 14,  87, 25, 88, 26,
   89, 21,  90, 27,  97,  5,  98, 16,  99, 23, 100,  7, 101,  0,102, 13,
  103, 10, 104, 17, 105,  6, 106, 24, 107, 12, 108,  9, 109, 11,110,  2,
  111,  8, 112, 18, 113, 30, 114,  1, 115,  4, 116,  3, 117, 15,118, 14,
  119, 25, 120, 26, 121, 21, 122, 27, 197, 20, 198, 22, 201, 28,214, 29,
  216, 19, 229, 20, 230, 22, 233, 28, 246, 29, 248, 19,
};


/* Model Table:
 * Total considered sequences: 925 / 961
 * - Positive sequences: first 485 (0.9950259492446578)
 * - Probable sequences: next 131 (616-485) (0.003975741174389147)
 * - Neutral sequences: last 345 (0.0009983095809530385)
 * - Negative sequences: 36 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 DanishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,1,3,3,3,3,2,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,1,2,2,1,1,
  3,3,3,3,3,3,3,2,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,3,2,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,0,1,2,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,0,0,3,1,3,3,3,2,3,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,1,3,2,2,3,2,0,1,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,2,1,1,2,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,0,3,3,3,3,2,0,0,1,
  3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,1,0,1,1,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,2,3,3,3,3,1,3,1,0,0,1,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,1,1,1,0,1,1,0,
  3,3,3,3,3,3,3,1,3,3,2,3,3,2,3,3,2,3,2,3,3,3,3,1,3,1,0,1,1,2,0,
  3,3,2,3,3,3,3,2,3,3,3,2,2,3,2,3,2,3,2,3,3,3,3,2,3,1,2,0,2,1,0,
  3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,3,2,2,2,2,3,2,3,1,3,0,0,0,1,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,2,3,1,0,1,1,3,1,1,2,1,0,0,0,
  3,3,3,3,3,3,3,2,3,3,1,2,1,1,1,3,3,1,1,3,3,3,3,2,3,1,0,1,0,1,1,
  3,3,3,3,3,3,3,1,3,3,2,2,2,1,3,3,1,1,1,3,3,3,3,1,3,2,1,1,1,1,0,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,3,3,3,2,3,2,3,1,0,1,0,1,1,0,0,
  3,3,3,3,3,0,2,3,1,3,3,3,3,2,3,1,3,1,1,0,0,2,0,0,3,0,0,0,0,0,0,
  3,3,3,3,3,0,0,3,1,3,2,1,3,2,3,0,3,1,1,1,0,0,0,1,1,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,2,3,2,3,2,0,0,0,2,1,2,0,1,0,1,0,
  2,3,3,3,3,1,3,3,2,3,3,3,3,3,3,2,3,1,2,0,0,0,0,2,0,0,0,0,0,0,0,
  3,3,1,3,2,3,3,2,3,3,1,2,3,1,1,3,1,3,1,1,0,3,3,3,0,0,0,1,1,0,1,
  3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,2,1,0,3,1,3,3,1,1,0,0,0,0,2,0,
  3,2,2,1,2,3,3,1,3,2,0,0,1,0,0,1,1,2,0,1,0,1,1,0,0,2,0,1,0,1,0,
  3,0,1,1,1,2,3,0,1,1,1,1,0,1,1,0,0,1,3,1,0,1,0,1,0,1,1,0,0,0,0,
  3,1,1,1,1,2,3,1,3,1,1,2,1,0,0,2,1,1,1,1,0,1,0,1,0,1,0,2,1,0,1,
  2,2,2,2,1,1,0,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,
  0,2,1,2,1,0,0,1,0,2,1,1,1,1,1,0,1,1,1,0,0,1,0,1,0,1,0,0,0,1,0,
  1,0,0,0,0,2,1,0,1,0,0,0,0,0,1,3,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
};


const SequenceModel Iso_8859_15DanishModel =
{
  Iso_8859_15_CharToOrderMap,
  DanishLangModel,
  31,
  (float)0.999001690419047,
  PR_TRUE,
  "ISO-8859-15",
  "da"
};

const SequenceModel Iso_8859_1DanishModel =
{
  Iso_8859_1_CharToOrderMap,
  DanishLangModel,
  31,
  (float)0.999001690419047,
  PR_TRUE,
  "ISO-8859-1",
  "da"
};

const SequenceModel Windows_1252DanishModel =
{
  Windows_1252_CharToOrderMap,
  DanishLangModel,
  31,
  (float)0.999001690419047,
  PR_TRUE,
  "WINDOWS-1252",
  "da"
};

const SequenceModel Ibm865DanishModel =
{
  Ibm865_CharToOrderMap,
  DanishLangModel,
  31,
  (float)0.999001690419047,
  PR_TRUE,
  "IBM865",
  "da"
};

const LanguageModel DanishModel =
{
  "da",
  Unicode_CharOrder,
  62,
  DanishLangModel,
  31,
  5,
  (float)0.44984602512589994,
  19,
  (float)0.037218017605308955,
};
