/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Hebrew *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 15:27:25.018997
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_8_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 46, 47, 45, 54, 59, 66, 63, 69, 48, 67, 72, 56, 53, 62, 68, /* 4X */
   57, 80, 58, 52, 55, 64, 65, 70, 74, 73, 77,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 28, 44, 37, 38, 26, 51, 41, 39, 29, 75, 49, 35, 40, 30, 33, /* 6X */
   42, 76, 31, 34, 32, 36, 50, 61, 71, 43, 60,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,CTR,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 94,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,CTR, /* BX */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* CX */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,SYM, /* DX */
    8,  6, 20, 12,  2,  1, 23, 16, 19,  0, 24, 18,  4, 11,  7, 22, /* EX */
   10, 17, 13, 25, 15, 27, 21, 14,  3,  9,  5,CTR,CTR,SYM,SYM,CTR, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1255_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 46, 47, 45, 54, 59, 66, 63, 69, 48, 67, 72, 56, 53, 62, 68, /* 4X */
   57, 80, 58, 52, 55, 64, 65, 70, 74, 73, 77,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 28, 44, 37, 38, 26, 51, 41, 39, 29, 75, 49, 35, 40, 30, 33, /* 6X */
   42, 76, 31, 34, 32, 36, 50, 61, 71, 43, 60,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,CTR,SYM, 95,SYM,SYM,SYM,SYM, 96,SYM,CTR,SYM,CTR,CTR,CTR,CTR, /* 8X */
  CTR,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,CTR,SYM,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM, 97,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 98,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
  SYM,SYM,SYM,SYM, 99,100, 88,SYM,SYM,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* DX */
    8,  6, 20, 12,  2,  1, 23, 16, 19,  0, 24, 18,  4, 11,  7, 22, /* EX */
   10, 17, 13, 25, 15, 27, 21, 14,  3,  9,  5,CTR,CTR,SYM,SYM,CTR, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm862_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 46, 47, 45, 54, 59, 66, 63, 69, 48, 67, 72, 56, 53, 62, 68, /* 4X */
   57, 80, 58, 52, 55, 64, 65, 70, 74, 73, 77,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 28, 44, 37, 38, 26, 51, 41, 39, 29, 75, 49, 35, 40, 30, 33, /* 6X */
   42, 76, 31, 34, 32, 36, 50, 61, 71, 43, 60,SYM,SYM,SYM,SYM,CTR, /* 7X */
    8,  6, 20, 12,  2,  1, 23, 16, 19,  0, 24, 18,  4, 11,  7, 22, /* 8X */
   10, 17, 13, 25, 15, 27, 21, 14,  3,  9,  5,SYM,SYM,SYM,SYM,101, /* 9X */
   81, 86, 78, 89, 82,102,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* DX */
   83, 79,103, 90, 92, 84,104, 85,105, 91,106, 93,SYM,107, 87,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 64;
static const unsigned int Unicode_CharOrder[] =
{
    65, 46,   66, 47,   67, 45,   68, 54,   69, 59,   71, 63,   73, 48,  76, 56,
    77, 53,   78, 62,   80, 57,   82, 58,   83, 52,   84, 55,   97, 28,  98, 44,
    99, 37,  100, 38,  101, 26,  102, 51,  103, 41,  104, 39,  105, 29, 107, 49,
   108, 35,  109, 40,  110, 30,  111, 33,  112, 42,  114, 31,  115, 34, 116, 32,
   117, 36,  118, 50,  119, 61,  121, 43,  122, 60, 1488,  8, 1489,  6,1490, 20,
  1491, 12, 1492,  2, 1493,  1, 1494, 23, 1495, 16, 1496, 19, 1497,  0,1498, 24,
  1499, 18, 1500,  4, 1501, 11, 1502,  7, 1503, 22, 1504, 10, 1505, 17,1506, 13,
  1507, 25, 1508, 15, 1509, 27, 1510, 21, 1511, 14, 1512,  3, 1513,  9,1514,  5,
};


/* Model Table:
 * Total considered sequences: 1640 / 4096
 * - Positive sequences: first 688 (0.9950129360753337)
 * - Probable sequences: next 328 (1016-688) (0.0039909002477918065)
 * - Neutral sequences: last 3080 (0.0009961636768744953)
 * - Negative sequences: 2456 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 HebrewLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,1,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,2,1,1,1,1,1,1,0,1,0,1,1,0,1,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,1,3,3,0,3,3,3,3,3,3,3,2,1,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,3,3,2,1,3,0,2,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,1,3,3,3,3,3,3,3,0,2,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,2,3,1,3,3,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,1,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,3,0,3,3,1,3,3,0,3,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,0,0,3,3,3,2,0,0,2,0,2,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,1,0,1,0,2,1,1,0,1,0,0,1,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,2,2,2,3,1,3,3,3,2,1,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,3,3,3,
   3,2,3,3,3,3,3,2,3,2,2,2,3,0,0,0,0,2,2,2,0,2,0,0,0,0,0,0,2,3,1,0,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,3,3,3,
   3,1,3,3,3,3,3,2,3,3,2,3,3,0,0,0,0,2,3,2,1,0,0,0,0,0,1,0,2,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,2,3,3,
   3,3,3,3,3,3,3,1,3,3,2,1,3,0,0,1,0,2,3,2,0,0,0,0,0,0,0,0,2,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,3,2,
   3,3,3,2,3,3,3,2,1,3,0,2,2,0,0,0,0,3,1,2,0,0,0,0,0,0,0,0,2,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,2,2,
   3,3,3,2,3,2,3,1,2,3,2,3,2,0,1,0,0,3,2,2,0,0,1,0,0,0,0,0,2,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,3,0,3,3,1,3,
   2,3,3,2,3,1,1,3,1,1,0,3,1,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,2,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,3,3,
   3,3,3,3,3,3,2,2,3,2,3,1,2,1,0,1,0,3,2,3,0,1,0,1,0,0,0,0,2,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,1,2,
   3,3,3,2,2,3,1,3,1,1,3,2,1,0,0,0,0,2,1,1,0,0,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,2,1,
   3,3,2,3,3,2,2,1,2,1,1,2,1,0,0,0,0,2,1,2,0,0,1,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,3,3,
   3,1,3,3,1,3,3,1,3,2,2,1,2,0,0,0,0,2,1,2,0,0,0,1,0,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,0,2,
   3,3,1,2,3,2,0,3,1,0,0,2,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,1,2,
   1,2,2,1,2,1,1,0,1,1,0,2,1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,2,2,
   2,3,2,2,3,0,1,1,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,2,0,
   1,2,1,1,2,1,1,0,2,0,2,1,2,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,2,1,2,
   1,2,2,2,2,0,0,2,1,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,2,0,2,
   2,3,1,3,2,0,0,2,0,0,2,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,1,2,1,
   2,1,3,3,1,2,1,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,2,1,3,
   1,2,2,3,2,0,1,0,0,0,0,1,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,2,0,2,
   0,3,0,1,2,0,0,2,0,0,0,0,0,2,1,1,2,0,1,0,1,0,2,1,1,1,1,0,1,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,2,2,
   2,0,2,2,2,1,1,1,2,1,1,0,2,1,1,1,1,0,2,1,2,1,1,2,1,1,2,0,0,1,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,1,3,
   0,3,0,1,2,0,1,0,0,0,0,1,0,2,1,1,1,0,0,0,1,1,1,1,0,1,1,1,0,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,
   1,1,2,1,1,2,0,0,1,1,0,0,0,1,2,1,2,0,0,0,2,2,1,1,1,2,1,1,1,0,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,2,1,2,
   2,2,3,1,1,1,0,1,0,1,0,2,1,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,1,0,0,
  0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,3,1,2,
   0,2,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,2,
   2,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,0,
   2,2,0,1,2,3,0,2,1,0,2,1,0,1,1,1,1,1,0,2,1,0,1,2,0,1,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,2,0,1,
   0,2,0,0,2,1,0,0,0,0,0,1,0,0,2,1,1,0,0,0,0,1,1,0,1,1,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,2,
   0,2,0,0,2,0,0,0,1,0,0,1,0,1,1,0,1,0,0,0,1,1,1,0,0,1,1,1,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,2,
   0,2,1,0,2,0,0,3,0,0,0,1,0,1,1,1,2,0,1,0,2,1,0,0,0,1,0,1,1,1,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,2,0,0,
   0,2,0,0,1,0,0,0,0,0,0,1,0,2,1,0,3,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,3,
   0,2,2,2,2,0,0,1,0,0,0,0,0,1,2,1,1,0,0,1,1,0,1,0,1,1,1,1,0,0,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,1,0,0,
   0,2,0,0,2,0,0,1,0,0,0,0,0,1,2,1,2,0,0,0,0,0,1,1,0,1,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,
   0,0,2,1,2,1,2,0,1,1,1,0,1,2,1,0,1,0,2,1,2,1,1,1,0,1,1,1,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,3,0,0,
   1,1,0,1,1,0,0,1,1,0,1,0,1,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,1,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,3,1,1,
   0,2,2,0,1,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,1,0,0,
   0,2,0,0,1,0,0,0,0,0,0,0,0,1,2,1,1,0,0,0,0,0,2,1,1,1,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,0,3,
   0,2,0,1,1,0,0,1,0,0,0,1,0,0,0,1,1,0,0,0,1,1,1,0,0,0,0,1,1,0,2,0,
};


const SequenceModel Iso_8859_8HebrewModel =
{
  Iso_8859_8_CharToOrderMap,
  HebrewLangModel,
  64,
  (float)0.9990038363231255,
  PR_FALSE,
  "ISO-8859-8",
  "he"
};

const SequenceModel Windows_1255HebrewModel =
{
  Windows_1255_CharToOrderMap,
  HebrewLangModel,
  64,
  (float)0.9990038363231255,
  PR_FALSE,
  "WINDOWS-1255",
  "he"
};

const SequenceModel Ibm862HebrewModel =
{
  Ibm862_CharToOrderMap,
  HebrewLangModel,
  64,
  (float)0.9990038363231255,
  PR_FALSE,
  "IBM862",
  "he"
};

const LanguageModel HebrewModel =
{
  "he",
  Unicode_CharOrder,
  64,
  HebrewLangModel,
  64,
  5,
  (float)0.4412277399275502,
  22,
  (float)0.031037939709794155,
};
