/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Hindi *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-14 20:23:15.737999
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const int Unicode_Char_size = 83;
static const unsigned int Unicode_CharOrder[] =
{
  2305, 45, 2306,  8, 2307, 70, 2309, 26, 2310, 41, 2311, 37, 2312, 44,2313, 36,
  2314, 60, 2315, 71, 2317, 72, 2318, 77, 2319, 33, 2320, 65, 2321, 58,2323, 52,
  2324, 40, 2325,  2, 2326, 38, 2327, 20, 2328, 51, 2329, 74, 2330, 32,2331, 49,
  2332, 19, 2333, 61, 2334, 69, 2335, 27, 2336, 54, 2337, 30, 2338, 55,2339, 39,
  2340,  9, 2341, 29, 2342, 18, 2343, 35, 2344,  7, 2346, 15, 2347, 43,2348, 22,
  2349, 28, 2350, 11, 2351, 13, 2352,  1, 2353, 82, 2354, 14, 2355, 79,2357, 16,
  2358, 24, 2359, 34, 2360,  6, 2361, 12, 2364, 42, 2365, 75, 2366,  0,2367,  5,
  2368, 10, 2369, 23, 2370, 31, 2371, 47, 2372, 80, 2373, 73, 2374, 78,2375,  4,
  2376, 21, 2377, 48, 2379, 17, 2380, 46, 2381,  3, 2400, 81, 2404, 25,2405, 76,
  2406, 50, 2407, 53, 2408, 56, 2409, 66, 2410, 68, 2411, 57, 2412, 62,2413, 64,
  2414, 63, 2415, 59, 2416, 67,
};


/* Model Table:
 * Total considered sequences: 2239 / 6889
 * - Positive sequences: first 1379 (0.9950003274894658)
 * - Probable sequences: next 426 (1805-1379) (0.004003168850449601)
 * - Neutral sequences: last 5084 (0.0009965036600846355)
 * - Negative sequences: 4650 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 HindiLangModel[] =
{
  2,3,3,1,2,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,3,3,2,3,3,3,3,0,3,3,3,3,3,3,3,3,0,
   0,1,3,3,3,1,0,0,2,1,3,3,0,3,3,0,0,0,0,3,2,0,0,0,3,0,1,0,1,2,0,0,1,2,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,3,3,3,3,3,2,3,3,0,0,3,3,0,
   1,0,3,2,1,3,3,3,2,1,3,0,0,3,0,0,0,0,0,0,1,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,3,1,3,3,3,3,3,3,1,2,0,1,0,0,3,0,
   0,3,2,3,0,3,3,3,2,0,0,1,0,3,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,
  0,3,3,0,0,0,3,3,0,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,3,1,0,3,3,3,3,0,3,0,3,3,0,0,3,3,0,
   0,0,3,0,0,0,1,0,3,0,3,1,0,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,
  2,3,3,0,2,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,3,3,2,3,1,3,3,0,3,1,3,2,1,2,3,3,0,
   1,0,3,1,1,0,0,0,0,2,2,2,0,3,2,0,0,0,0,2,1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,3,3,1,0,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,3,3,2,3,3,3,3,0,3,3,3,3,1,2,3,3,0,
   1,2,3,0,0,0,0,0,3,1,2,3,0,3,0,0,0,0,0,0,1,0,0,0,1,0,3,0,0,2,0,0,0,2,0,1,0,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,2,2,0,3,3,0,3,3,3,3,0,0,0,1,3,0,0,
   2,1,3,2,3,3,3,3,0,1,2,2,0,1,0,0,0,0,0,2,0,0,0,0,0,0,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,2,3,3,3,3,3,2,0,2,1,0,0,
   1,0,3,3,0,3,3,3,0,1,1,0,0,0,0,0,0,0,0,3,1,0,0,0,0,0,3,0,0,3,0,0,1,0,0,0,0,0,0,0,0,0,
  0,3,3,1,0,0,3,3,1,3,0,2,3,3,3,3,3,0,3,3,3,0,3,0,3,3,1,3,3,3,3,0,3,1,1,3,0,0,3,2,0,
   0,0,2,1,0,0,0,0,1,1,3,0,0,3,2,1,0,0,0,0,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,0,3,3,3,2,3,3,2,0,0,0,0,2,0,0,
   1,0,2,0,0,3,3,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,3,3,0,3,2,3,3,3,3,0,3,3,3,0,3,0,3,3,2,3,2,2,3,0,3,3,3,3,0,1,3,3,0,
   3,1,3,2,0,0,0,0,3,2,3,2,0,3,3,2,0,0,0,0,0,0,0,0,0,0,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,0,3,2,2,3,3,3,2,0,3,1,1,2,3,0,
   1,0,3,3,1,3,3,3,3,1,1,0,0,3,1,0,0,0,0,3,3,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,3,3,3,3,2,3,2,3,1,1,0,3,2,3,3,3,3,0,0,1,1,1,2,3,0,
   0,0,2,1,2,3,2,3,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,3,3,3,3,0,3,3,2,3,3,2,0,0,3,1,0,0,3,0,
   0,1,1,0,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,3,3,0,3,3,3,1,0,1,1,0,3,0,1,
   0,0,3,2,0,3,0,3,0,0,3,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,3,3,1,1,3,3,3,3,3,3,3,3,2,0,0,2,3,0,
   0,0,1,0,1,3,3,3,2,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,0,3,3,1,3,2,3,0,0,3,0,2,0,3,0,
   0,0,1,2,3,0,3,3,1,0,2,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,3,3,0,1,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,3,3,2,3,3,3,3,0,3,3,3,3,2,3,3,3,0,
   3,1,3,3,2,0,0,0,1,0,2,1,1,1,3,0,0,0,0,1,2,0,0,0,0,0,2,0,0,0,0,0,0,1,2,0,0,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,0,0,2,0,1,3,1,0,1,1,0,0,2,2,0,
   0,0,2,2,0,3,3,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,2,1,0,3,3,0,2,3,0,0,0,3,0,0,0,0,0,
   0,3,2,2,0,3,1,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,2,2,0,3,3,2,3,3,0,3,0,3,0,0,0,3,0,
   1,3,2,3,0,3,3,2,0,0,0,0,0,3,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  1,3,3,0,0,0,3,3,3,3,0,3,2,3,3,3,3,0,3,3,3,0,3,0,3,3,0,3,2,3,3,0,3,1,2,3,0,0,0,3,0,
   1,0,2,0,1,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,1,1,3,3,3,3,3,2,3,2,1,0,3,0,0,3,3,3,0,0,2,0,1,2,0,0,
   1,0,1,3,2,3,3,3,1,0,2,0,0,0,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  0,3,3,1,0,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,2,3,2,3,3,3,2,3,0,3,3,3,3,1,3,3,3,0,
   3,0,3,3,3,0,0,0,3,0,0,3,0,2,1,0,0,0,0,0,3,0,0,0,2,0,2,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,3,3,3,0,2,1,0,2,0,1,3,2,0,0,0,0,0,1,0,0,
   0,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,3,0,0,0,2,0,0,0,0,0,0,0,0,
  0,2,3,0,0,0,3,2,0,2,0,3,3,3,0,3,3,0,2,3,2,0,3,0,2,2,3,1,2,0,2,0,2,2,0,1,2,3,2,0,2,
   1,0,2,1,0,0,0,0,1,0,0,1,2,0,0,2,0,0,0,1,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,3,0,0,3,3,3,3,0,3,0,2,3,0,0,3,2,0,
   0,0,3,0,1,0,0,0,2,0,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,3,3,2,0,3,2,3,3,2,2,2,3,3,3,1,2,0,0,0,0,2,3,1,1,0,0,0,1,0,1,0,
   2,0,2,0,0,2,0,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,2,3,1,0,3,3,2,3,3,3,2,3,3,0,3,1,1,0,3,1,0,2,3,0,0,0,0,0,0,1,2,0,
   0,0,0,0,2,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,1,2,3,3,0,2,3,2,3,3,1,0,2,1,1,3,3,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
   0,1,0,0,0,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,2,0,3,3,2,2,3,2,3,3,0,0,1,1,3,3,2,1,1,2,0,0,0,3,3,0,0,0,0,1,0,1,0,
   0,3,2,0,0,2,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,2,2,2,3,2,1,3,0,3,3,3,2,0,1,3,1,0,
   2,0,3,1,3,0,0,0,3,1,0,2,0,3,2,0,0,0,0,0,2,0,0,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,1,1,1,3,1,3,1,1,0,3,2,0,3,3,1,2,0,0,0,1,0,0,0,
   2,0,0,0,1,3,0,1,0,0,1,1,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,3,2,0,3,1,3,3,2,3,0,1,3,3,0,3,0,3,3,1,3,0,2,3,0,3,2,0,0,0,1,0,2,0,
   2,0,3,1,3,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,1,1,1,3,3,3,0,3,0,2,1,3,3,3,2,2,0,2,2,1,0,2,1,0,1,0,2,1,2,3,0,0,0,3,0,
   0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,2,3,3,3,1,1,1,2,3,3,1,0,2,0,0,3,2,2,0,0,0,0,2,3,2,0,0,1,0,0,0,0,0,
   0,0,0,1,1,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,2,0,0,0,3,3,3,3,0,3,0,0,3,3,1,0,3,3,3,0,2,0,1,0,1,3,3,3,3,0,3,0,3,3,0,2,1,2,0,
   1,0,1,0,1,0,0,0,2,0,1,0,0,3,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,3,3,0,3,1,3,3,3,3,0,1,3,3,0,3,0,2,1,0,3,0,1,3,0,3,3,0,2,0,0,0,3,0,
   1,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,3,2,0,1,3,3,2,3,3,2,2,2,3,3,0,1,0,2,2,0,3,3,1,0,0,0,0,0,0,3,0,
   0,3,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,1,3,3,2,0,3,0,3,3,3,2,2,2,0,1,3,2,2,0,0,2,1,1,0,0,0,0,2,0,0,0,0,0,
   0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,0,0,0,0,3,0,0,0,0,0,0,0,1,3,0,0,3,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  0,3,3,0,0,0,3,3,3,3,0,3,3,3,3,3,3,0,3,3,3,0,3,0,3,3,0,2,2,0,2,0,3,3,2,3,3,3,3,2,0,
   0,0,1,3,3,0,0,0,0,0,1,1,0,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,0,3,3,3,1,2,3,2,3,3,2,1,2,3,3,3,0,1,0,0,0,0,1,2,0,0,0,0,0,0,1,0,0,
   0,1,2,1,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,0,3,3,3,3,3,2,3,3,0,1,0,3,1,1,3,0,1,1,3,0,3,0,0,0,2,0,0,1,3,0,3,0,0,0,0,0,2,0,
   1,3,0,1,1,2,0,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,0,0,0,3,2,3,0,0,2,0,2,2,2,2,0,1,2,2,0,1,0,2,3,1,3,0,0,2,0,0,3,0,0,0,0,0,0,0,
   2,0,1,1,0,0,0,0,0,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,0,0,0,3,2,0,2,0,2,1,1,1,1,3,0,3,2,3,0,2,0,1,3,0,3,0,0,2,0,3,1,0,3,1,1,3,0,0,
   0,0,0,1,1,0,0,0,2,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,3,3,0,3,3,0,3,2,2,0,3,3,3,0,3,0,3,1,0,3,2,3,3,0,2,0,2,2,0,0,2,0,0,
   0,0,2,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,3,0,0,0,2,1,3,3,0,2,3,0,0,3,0,0,3,3,2,0,0,0,3,0,0,0,3,3,0,0,0,0,3,0,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,0,0,0,3,0,3,3,3,2,0,0,3,2,0,3,0,1,0,0,3,0,0,3,0,2,0,0,0,0,2,0,2,0,
   0,0,3,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,0,3,3,0,2,2,3,3,1,3,0,3,2,2,3,1,0,0,0,1,3,0,0,0,1,0,0,2,3,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,1,0,0,0,0,0,0,0,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,0,0,0,0,0,0,0,2,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,2,0,0,0,0,0,0,0,
   1,0,0,0,0,0,0,0,0,3,0,0,3,0,0,3,3,0,3,0,0,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,2,3,3,3,0,3,3,1,3,2,1,0,2,1,2,3,2,0,1,0,1,3,1,1,0,3,0,0,2,3,0,0,0,0,0,0,0,1,0,
   0,1,0,1,0,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,2,3,0,0,2,2,0,3,3,2,0,1,1,1,0,1,0,2,0,1,3,0,0,2,0,0,0,0,0,0,1,1,0,0,
   2,0,0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,3,3,0,3,0,0,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,1,3,3,3,3,0,3,3,3,3,1,2,1,1,0,2,3,0,0,1,0,3,2,2,1,0,0,3,0,0,3,0,0,0,0,0,0,0,1,0,
   0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,1,3,2,0,1,3,2,2,1,0,0,2,0,1,3,0,0,0,1,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
   0,3,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,3,3,0,2,0,0,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,2,3,0,2,0,0,3,2,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,0,0,0,3,3,1,0,0,0,0,1,2,2,1,0,0,0,0,0,0,0,0,0,0,3,0,1,1,0,0,0,0,0,0,0,0,0,0,
   0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,3,3,0,3,0,0,3,3,3,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,0,0,0,0,2,3,3,0,0,0,0,0,0,3,0,0,2,0,0,0,1,0,0,1,0,2,0,0,0,0,1,0,0,2,0,0,2,0,0,
   0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,2,0,3,2,0,3,1,2,3,0,0,0,3,1,1,2,0,1,1,0,1,3,0,0,0,2,0,0,2,3,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,3,1,0,3,3,0,3,0,0,3,3,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,2,3,0,3,0,0,2,3,3,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,2,0,0,3,3,0,3,0,0,2,3,3,0,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,0,0,3,1,3,3,0,2,0,1,2,0,2,0,0,0,0,0,2,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,2,0,0,3,2,0,2,0,0,3,2,2,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,1,0,0,0,1,0,0,0,0,3,0,0,1,2,1,0,0,0,1,0,3,0,0,0,2,0,0,0,2,0,0,2,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,2,3,0,3,0,0,2,3,3,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,2,1,0,0,0,0,2,1,0,0,0,0,0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  0,0,1,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,2,0,3,0,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,3,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,1,0,0,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,3,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const LanguageModel HindiModel =
{
  "hi",
  Unicode_CharOrder,
  83,
  HindiLangModel,
  83,
  7,
  (float)0.4172238383435763,
  41,
  (float)0.033113346067542536,
};
