/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Italian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:04:23.458332
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 57,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* CX */
   59, 44, 24, 33, 43, 65, 34,SYM, 49, 25, 48, 53, 36, 66, 67, 62, /* DX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* EX */
   59, 44, 24, 33, 43, 68, 34,SYM, 49, 25, 48, 53, 36, 69, 70, 71, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_3_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 50,SYM,SYM,SYM,ILL, 72,SYM,SYM, 73, 64, 55, 74,SYM,ILL, 75, /* AX */
  SYM, 50,SYM,SYM,SYM,SYM, 76,SYM,SYM, 58, 64, 55, 77,SYM,ILL, 78, /* BX */
   21, 39, 45,ILL, 47, 61, 79, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* CX */
  ILL, 44, 24, 33, 43, 60, 34,SYM, 63, 25, 48, 53, 36, 80, 81, 62, /* DX */
   21, 39, 45,ILL, 47, 61, 82, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* EX */
  ILL, 44, 24, 33, 43, 60, 34,SYM, 63, 25, 48, 53, 36, 83, 84,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 57,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* CX */
   55, 44, 24, 33, 43, 85, 34,SYM, 49, 25, 48, 53, 36, 86, 64, 62, /* DX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* EX */
   55, 44, 24, 33, 43, 87, 34,SYM, 49, 25, 48, 53, 36, 58, 64, 88, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 42,SYM, 42,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 54, 57,SYM,SYM, 54,SYM,SYM,SYM, 51, 51, 89,SYM, /* BX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* CX */
   59, 44, 24, 33, 43, 90, 34,SYM, 49, 25, 48, 53, 36, 91, 92, 62, /* DX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* EX */
   59, 44, 24, 33, 43, 93, 34,SYM, 49, 25, 48, 53, 36, 94, 95, 96, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 30, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 23, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 97,SYM,SYM,SYM,SYM,SYM,SYM, 42,SYM, 51,ILL, 54,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 42,SYM, 51,ILL, 54, 98, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 57,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* CX */
   59, 44, 24, 33, 43, 99, 34,SYM, 49, 25, 48, 53, 36,100,101, 62, /* DX */
   21, 39, 45, 40, 47, 52, 37, 35, 22, 29, 41, 32, 31, 38, 46, 56, /* EX */
   59, 44, 24, 33, 43,102, 34,SYM, 49, 25, 48, 53, 36,103,104,105, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 68;
static const unsigned int Unicode_CharOrder[] =
{
   65,  2,  66, 17,  67,  9,  68, 10,  69,  1,  70, 16,  71, 14, 72, 19,
   73,  0,  74, 30,  75, 26,  76,  5,  77, 13,  78,  4,  79,  3, 80, 12,
   81, 20,  82,  7,  83,  8,  84,  6,  85, 11,  86, 15,  87, 28, 88, 23,
   89, 27,  90, 18,  97,  2,  98, 17,  99,  9, 100, 10, 101,  1,102, 16,
  103, 14, 104, 19, 105,  0, 106, 30, 107, 26, 108,  5, 109, 13,110,  4,
  111,  3, 112, 12, 113, 20, 114,  7, 115,  8, 116,  6, 117, 11,118, 15,
  119, 28, 120, 23, 121, 27, 122, 18, 192, 21, 200, 22, 201, 29,203, 32,
  204, 31, 210, 24, 211, 33, 217, 25, 224, 21, 232, 22, 233, 29,235, 32,
  236, 31, 242, 24, 243, 33, 249, 25,
};


/* Model Table:
 * Total considered sequences: 1088 / 1156
 * - Positive sequences: first 301 (0.99504151171882)
 * - Probable sequences: next 203 (504-301) (0.00396113186513658)
 * - Neutral sequences: last 652 (0.0009973564160433712)
 * - Negative sequences: 68 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 ItalianLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,2,3,3,3,3,2,1,1,2,0,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,0,0,3,2,0,2,3,3,0,2,0,0,1,
  3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,2,0,0,3,3,2,0,2,0,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,2,0,0,2,2,3,1,2,1,1,1,
  3,3,3,3,3,2,3,3,3,3,3,3,1,2,3,3,3,2,3,2,3,1,2,1,3,1,2,2,2,2,2,2,0,1,
  3,3,3,3,2,3,3,1,3,3,3,3,3,3,3,3,3,3,2,2,1,2,1,1,2,1,2,3,1,2,1,2,0,1,
  3,3,3,3,3,3,3,3,3,2,1,3,2,2,2,2,1,2,2,3,0,3,2,1,3,2,1,3,2,2,1,2,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,1,3,1,3,3,2,2,1,2,1,1,
  3,3,3,3,2,3,3,2,3,3,3,3,3,3,2,3,3,3,1,3,3,1,1,0,2,2,2,2,2,2,1,3,1,1,
  3,3,3,3,3,3,3,3,2,3,1,3,1,2,1,1,1,1,0,3,3,2,0,1,3,1,3,3,1,2,1,2,1,1,
  3,3,3,3,1,2,2,3,2,2,3,3,1,2,2,1,2,1,2,2,0,2,1,0,2,1,1,2,2,2,1,2,2,1,
  3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,1,1,1,1,2,3,0,2,2,1,1,2,2,0,0,
  3,3,3,3,1,3,2,3,2,2,2,3,3,1,1,1,0,1,1,3,0,1,1,1,2,1,1,1,0,2,1,1,1,0,
  3,3,3,3,2,2,2,1,2,2,1,3,3,3,1,1,1,3,1,1,1,1,1,1,2,1,1,2,1,2,1,1,1,1,
  3,3,3,3,3,3,2,3,2,2,1,3,1,2,3,1,1,2,1,3,1,1,1,1,2,1,1,2,2,2,1,1,0,1,
  3,3,3,3,1,1,1,3,1,1,1,3,0,1,1,3,1,1,0,1,0,1,1,0,2,1,0,1,0,2,0,1,1,0,
  3,3,3,3,1,3,2,3,1,1,1,3,1,1,2,1,3,1,0,0,0,1,2,0,1,1,0,1,0,1,1,1,1,0,
  3,3,3,3,3,3,2,3,2,2,2,3,1,1,1,0,1,3,1,1,0,1,1,0,1,2,1,2,0,2,1,2,1,1,
  3,3,3,3,1,1,1,1,1,0,1,3,1,1,1,1,1,0,3,1,0,1,0,0,2,0,1,1,1,1,1,1,1,0,
  3,3,3,3,2,2,2,3,2,1,2,3,1,2,1,1,1,1,1,0,0,1,1,0,1,0,1,2,1,3,0,1,1,0,
  2,0,2,0,0,1,0,0,1,0,0,3,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,
  2,0,0,1,1,1,1,1,1,1,1,2,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,1,0,1,1,1,2,2,1,1,0,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,
  3,2,2,2,0,1,2,1,1,2,0,1,2,1,1,3,1,1,0,1,0,0,0,3,0,0,0,1,1,0,0,0,0,0,
  1,0,0,0,2,1,1,1,1,1,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  1,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,2,1,2,2,1,1,2,1,3,1,1,1,1,0,2,0,1,0,1,0,0,2,2,1,1,1,0,0,0,
  1,2,3,2,2,2,2,2,3,2,2,1,2,2,1,1,1,2,1,1,0,0,0,1,0,1,1,2,1,0,1,0,0,0,
  3,3,3,2,1,2,2,1,2,1,1,1,1,1,0,0,1,0,1,2,0,0,0,0,0,0,1,1,2,0,1,0,0,0,
  1,2,2,1,2,2,2,2,2,1,2,1,1,2,2,1,1,1,1,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,
  2,3,3,3,1,1,1,1,1,1,1,2,1,1,1,0,0,1,0,0,0,2,0,0,1,0,1,1,1,1,1,0,1,0,
  0,1,1,1,1,1,1,0,1,1,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,1,2,1,1,1,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,2,0,0,1,1,1,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_1ItalianModel =
{
  Iso_8859_1_CharToOrderMap,
  ItalianLangModel,
  34,
  (float)0.9990026435839566,
  PR_TRUE,
  "ISO-8859-1",
  "it"
};

const SequenceModel Iso_8859_3ItalianModel =
{
  Iso_8859_3_CharToOrderMap,
  ItalianLangModel,
  34,
  (float)0.9990026435839566,
  PR_TRUE,
  "ISO-8859-3",
  "it"
};

const SequenceModel Iso_8859_9ItalianModel =
{
  Iso_8859_9_CharToOrderMap,
  ItalianLangModel,
  34,
  (float)0.9990026435839566,
  PR_TRUE,
  "ISO-8859-9",
  "it"
};

const SequenceModel Iso_8859_15ItalianModel =
{
  Iso_8859_15_CharToOrderMap,
  ItalianLangModel,
  34,
  (float)0.9990026435839566,
  PR_TRUE,
  "ISO-8859-15",
  "it"
};

const SequenceModel Windows_1252ItalianModel =
{
  Windows_1252_CharToOrderMap,
  ItalianLangModel,
  34,
  (float)0.9990026435839566,
  PR_TRUE,
  "WINDOWS-1252",
  "it"
};

const LanguageModel ItalianModel =
{
  "it",
  Unicode_CharOrder,
  68,
  ItalianLangModel,
  34,
  4,
  (float)0.42999498479538617,
  16,
  (float)0.03980172126113431,
};
