/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Romanian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:04:31.828422
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_2_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 4X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 6X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 60,SYM, 43,SYM, 68, 56,SYM,SYM, 41, 69, 70, 66,SYM, 51, 71, /* AX */
  SYM, 60,SYM, 43,SYM, 72, 56,SYM,SYM, 41, 73, 74, 66,SYM, 51, 75, /* BX */
   76, 32, 24, 14, 44, 77, 40, 36, 46, 30, 61, 39, 65, 34, 21, 78, /* CX */
   64, 52, 79, 33, 49, 45, 35,SYM, 58, 80, 42, 62, 37, 57, 81, 55, /* DX */
   82, 32, 24, 14, 44, 83, 40, 36, 46, 30, 61, 39, 65, 34, 21, 84, /* EX */
   64, 52, 85, 33, 49, 45, 35,SYM, 58, 86, 42, 62, 37, 57, 87,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_16_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 4X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 6X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 60, 60, 43,SYM,SYM, 41,SYM, 41,SYM, 19,SYM, 66,SYM, 66, 88, /* AX */
  SYM,SYM, 46, 43, 51,SYM,SYM,SYM, 51, 46, 19,SYM, 67, 67, 63, 89, /* BX */
   48, 32, 24, 14, 44, 40, 50, 36, 38, 30, 53, 39, 59, 34, 21, 47, /* CX */
   64, 52, 54, 33, 49, 45, 35, 56, 62, 90, 42, 91, 37, 61, 20, 55, /* DX */
   48, 32, 24, 14, 44, 40, 50, 36, 38, 30, 53, 39, 59, 34, 21, 47, /* EX */
   64, 52, 54, 33, 49, 45, 35, 56, 62, 92, 42, 93, 37, 61, 20, 63, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1250_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 4X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 6X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,ILL,SYM,SYM,SYM,SYM,ILL,SYM, 41,SYM, 56, 94, 51, 66, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 41,SYM, 56, 95, 51, 66, /* 9X */
  SYM,SYM,SYM, 43,SYM, 60,SYM,SYM,SYM,SYM, 96,SYM,SYM,SYM,SYM, 97, /* AX */
  SYM,SYM,SYM, 43,SYM,SYM,SYM,SYM,SYM, 60, 98,SYM, 99,SYM,100,101, /* BX */
  102, 32, 24, 14, 44,103, 40, 36, 46, 30, 61, 39, 65, 34, 21,104, /* CX */
   64, 52,105, 33, 49, 45, 35,SYM, 58,106, 42, 62, 37, 57,107, 55, /* DX */
  108, 32, 24, 14, 44,109, 40, 36, 46, 30, 61, 39, 65, 34, 21,110, /* EX */
   64, 52,111, 33, 49, 45, 35,SYM, 58,112, 42, 62, 37, 57,113,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm852_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 4X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 15,  9, 11,  1, 17, 16, 23,  0, 26, 25,  6, 12,  4,  8, /* 6X */
   13, 31,  3, 10,  5,  7, 18, 29, 27, 28, 22,SYM,SYM,SYM,SYM,CTR, /* 7X */
   36, 37, 30, 24, 44,114, 40, 36, 43, 39, 45, 45, 21, 66, 44, 40, /* 8X */
   30,115,116, 49, 35,117,118, 56, 56, 35, 37,119,120, 43,SYM, 46, /* 9X */
   32, 34, 33, 42, 60, 60, 51, 51, 61, 61,SYM, 66, 46,121,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 32, 24, 65,122,SYM,SYM,SYM,SYM,123,124,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM, 14, 14,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
   64, 64,125, 39,126,127, 34, 21, 65,SYM,SYM,SYM,SYM,128,129,SYM, /* DX */
   33, 55, 49, 52, 52,130, 41, 41,131, 42,132, 62, 57, 57,133,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 62, 58, 58,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 64;
static const unsigned int Unicode_CharOrder[] =
{
   65,  2,  66, 15,  67,  9,  68, 11,  69,  1,  70, 17,  71, 16, 72, 23,
   73,  0,  74, 26,  75, 25,  76,  6,  77, 12,  78,  4,  79,  8, 80, 13,
   81, 31,  82,  3,  83, 10,  84,  5,  85,  7,  86, 18,  87, 29, 88, 27,
   89, 28,  90, 22,  97,  2,  98, 15,  99,  9, 100, 11, 101,  1,102, 17,
  103, 16, 104, 23, 105,  0, 106, 26, 107, 25, 108,  6, 109, 12,110,  4,
  111,  8, 112, 13, 113, 31, 114,  3, 115, 10, 116,  5, 117,  7,118, 18,
  119, 29, 120, 27, 121, 28, 122, 22, 194, 24, 201, 30, 206, 21,226, 24,
  233, 30, 238, 21, 258, 14, 259, 14, 536, 19, 537, 19, 538, 20,539, 20,
};


/* Model Table:
 * Total considered sequences: 1295 / 1024
 * - Positive sequences: first 487 (0.9950167482401342)
 * - Probable sequences: next 267 (754-487) (0.003984360305270163)
 * - Neutral sequences: last 270 (0.0009988914545956407)
 * - Negative sequences: -271 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 RomanianLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,0,3,3,1,3,3,3,3,3,1,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,2,3,3,2,3,3,3,3,3,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,1,3,3,1,3,3,3,3,3,1,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,1,3,3,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,1,3,3,3,3,3,2,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,1,0,2,3,3,3,2,1,1,3,3,3,0,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,1,2,3,3,3,2,1,3,2,2,0,
  3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,3,3,3,3,2,2,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,1,3,3,0,3,3,3,3,3,1,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,1,3,2,2,1,3,2,3,1,2,3,3,3,1,1,2,1,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,0,3,2,3,3,3,3,1,0,3,3,2,2,
  3,3,3,3,3,2,3,3,3,2,3,3,3,1,3,3,3,2,3,0,0,2,2,3,2,1,3,0,3,3,2,1,
  3,3,3,2,3,2,2,3,3,3,3,2,3,3,3,3,2,3,2,1,2,2,2,2,3,2,1,1,3,2,2,0,
  3,3,3,3,2,3,3,3,3,2,3,2,2,3,3,1,0,1,1,0,3,1,1,3,3,2,2,0,2,1,2,1,
  3,1,0,3,3,3,3,3,1,3,3,3,3,3,1,3,3,0,2,3,3,0,3,0,0,1,2,0,0,0,0,0,
  3,3,3,3,3,2,3,3,3,3,3,2,2,2,3,3,2,1,2,0,3,2,1,2,2,1,2,0,3,2,2,0,
  3,3,3,3,3,3,3,3,3,1,3,2,3,2,3,3,3,1,3,0,0,1,1,3,3,2,2,1,3,2,2,1,
  3,3,3,3,1,3,3,3,3,2,2,0,2,0,3,1,2,3,1,1,0,0,0,1,3,1,1,1,2,1,2,0,
  3,3,3,3,2,1,3,3,3,1,2,2,1,1,3,1,1,1,1,0,0,1,0,2,3,2,1,0,2,1,1,0,
  3,3,3,1,3,3,2,3,3,3,0,0,1,1,2,1,0,0,1,0,0,0,0,0,1,2,0,0,0,0,1,0,
  3,3,3,0,0,0,0,3,2,1,0,0,0,0,3,0,0,0,1,0,0,1,0,0,2,2,0,0,0,0,1,0,
  3,0,0,2,3,1,3,0,0,1,0,1,3,1,0,1,1,0,1,3,1,0,1,1,0,1,0,0,0,0,0,0,
  3,3,3,2,2,2,2,3,3,1,2,3,2,1,3,3,2,0,3,0,0,1,2,2,3,2,1,0,2,1,1,1,
  3,3,3,3,3,3,3,3,3,2,2,2,3,1,3,2,1,1,1,0,0,1,0,1,2,2,1,0,3,2,2,2,
  3,0,0,3,3,3,3,3,0,1,1,0,3,0,0,0,1,0,0,3,2,0,1,1,0,0,1,0,1,1,0,0,
  3,3,3,3,2,2,3,3,3,1,3,1,3,2,2,2,1,1,2,1,1,1,1,3,1,2,1,1,3,2,2,0,
  3,3,3,2,1,2,3,3,3,1,0,2,2,1,2,2,1,0,1,0,0,0,1,1,1,1,1,0,1,0,1,0,
  3,3,3,0,1,3,1,3,3,3,1,0,1,3,2,1,1,2,3,0,0,0,0,2,1,1,0,3,2,1,0,0,
  2,3,3,3,3,2,3,3,3,2,3,3,3,2,0,3,2,1,2,0,1,0,1,1,1,2,1,1,2,2,1,1,
  3,3,3,2,2,2,2,2,3,2,3,2,1,1,0,1,0,1,0,0,0,0,1,3,1,2,0,0,2,2,1,0,
  2,2,2,2,2,2,2,1,2,1,2,2,2,2,0,2,2,1,2,0,0,0,1,0,0,2,1,1,0,0,0,0,
  2,1,2,0,0,0,1,3,2,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,
};


const SequenceModel Iso_8859_2RomanianModel =
{
  Iso_8859_2_CharToOrderMap,
  RomanianLangModel,
  32,
  (float)0.9990011085454044,
  PR_TRUE,
  "ISO-8859-2",
  "ro"
};

const SequenceModel Iso_8859_16RomanianModel =
{
  Iso_8859_16_CharToOrderMap,
  RomanianLangModel,
  32,
  (float)0.9990011085454044,
  PR_TRUE,
  "ISO-8859-16",
  "ro"
};

const SequenceModel Windows_1250RomanianModel =
{
  Windows_1250_CharToOrderMap,
  RomanianLangModel,
  32,
  (float)0.9990011085454044,
  PR_TRUE,
  "WINDOWS-1250",
  "ro"
};

const SequenceModel Ibm852RomanianModel =
{
  Ibm852_CharToOrderMap,
  RomanianLangModel,
  32,
  (float)0.9990011085454044,
  PR_TRUE,
  "IBM852",
  "ro"
};

const LanguageModel RomanianModel =
{
  "ro",
  Unicode_CharOrder,
  64,
  RomanianLangModel,
  32,
  4,
  (float)0.4039034087176214,
  21,
  (float)0.03235169186956807,
};
