/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Spanish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:20:04.575395
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 14,  9,  8,  0, 18, 15, 20,  5, 24, 30,  7, 12,  3,  2, /* 4X */
   13, 22,  6,  4, 10, 11, 16, 31, 27, 17, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 14,  9,  8,  0, 18, 15, 20,  5, 24, 30,  7, 12,  3,  2, /* 6X */
   13, 22,  6,  4, 10, 11, 16, 31, 27, 17, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 39,SYM, 39,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 50, 60,SYM,SYM, 50,SYM,SYM,SYM, 55, 55, 61,SYM, /* BX */
   36, 23, 35, 41, 40, 46, 33, 38, 37, 26, 49, 48, 53, 21, 42, 47, /* CX */
   51, 28, 44, 19, 57, 54, 34,SYM, 59, 52, 29, 56, 32, 45, 58, 43, /* DX */
   36, 23, 35, 41, 40, 46, 33, 38, 37, 26, 49, 48, 53, 21, 42, 47, /* EX */
   51, 28, 44, 19, 57, 54, 34,SYM, 59, 52, 29, 56, 32, 45, 58, 62, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 14,  9,  8,  0, 18, 15, 20,  5, 24, 30,  7, 12,  3,  2, /* 4X */
   13, 22,  6,  4, 10, 11, 16, 31, 27, 17, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 14,  9,  8,  0, 18, 15, 20,  5, 24, 30,  7, 12,  3,  2, /* 6X */
   13, 22,  6,  4, 10, 11, 16, 31, 27, 17, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 63,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   36, 23, 35, 41, 40, 46, 33, 38, 37, 26, 49, 48, 53, 21, 42, 47, /* CX */
   51, 28, 44, 19, 57, 54, 34,SYM, 59, 52, 29, 56, 32, 45, 58, 43, /* DX */
   36, 23, 35, 41, 40, 46, 33, 38, 37, 26, 49, 48, 53, 21, 42, 47, /* EX */
   51, 28, 44, 19, 57, 54, 34,SYM, 59, 52, 29, 56, 32, 45, 58, 64, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 14,  9,  8,  0, 18, 15, 20,  5, 24, 30,  7, 12,  3,  2, /* 4X */
   13, 22,  6,  4, 10, 11, 16, 31, 27, 17, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 14,  9,  8,  0, 18, 15, 20,  5, 24, 30,  7, 12,  3,  2, /* 6X */
   13, 22,  6,  4, 10, 11, 16, 31, 27, 17, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 65,SYM,SYM,SYM,SYM,SYM,SYM, 39,SYM, 55,ILL, 50,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 39,SYM, 55,ILL, 50, 66, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 67,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   36, 23, 35, 41, 40, 46, 33, 38, 37, 26, 49, 48, 53, 21, 42, 47, /* CX */
   51, 28, 44, 19, 57, 54, 34,SYM, 59, 52, 29, 56, 32, 45, 58, 43, /* DX */
   36, 23, 35, 41, 40, 46, 33, 38, 37, 26, 49, 48, 53, 21, 42, 47, /* EX */
   51, 28, 44, 19, 57, 54, 34,SYM, 59, 52, 29, 56, 32, 45, 58, 68, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 66;
static const unsigned int Unicode_CharOrder[] =
{
   65,  1,  66, 14,  67,  9,  68,  8,  69,  0,  70, 18,  71, 15, 72, 20,
   73,  5,  74, 24,  75, 30,  76,  7,  77, 12,  78,  3,  79,  2, 80, 13,
   81, 22,  82,  6,  83,  4,  84, 10,  85, 11,  86, 16,  87, 31, 88, 27,
   89, 17,  90, 25,  97,  1,  98, 14,  99,  9, 100,  8, 101,  0,102, 18,
  103, 15, 104, 20, 105,  5, 106, 24, 107, 30, 108,  7, 109, 12,110,  3,
  111,  2, 112, 13, 113, 22, 114,  6, 115,  4, 116, 10, 117, 11,118, 16,
  119, 31, 120, 27, 121, 17, 122, 25, 193, 23, 201, 26, 205, 21,209, 28,
  211, 19, 218, 29, 220, 32, 225, 23, 233, 26, 237, 21, 241, 28,243, 19,
  250, 29, 252, 32,
};


/* Model Table:
 * Total considered sequences: 1139 / 1089
 * - Positive sequences: first 446 (0.9950161077973593)
 * - Probable sequences: next 174 (620-446) (0.0039865210967695575)
 * - Neutral sequences: last 469 (0.0009973711058711698)
 * - Negative sequences: -50 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 SpanishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,1,2,2,0,
  3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,1,3,3,2,2,3,3,3,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,3,1,3,3,2,3,2,0,3,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,3,3,2,3,3,2,3,3,3,3,3,3,1,0,3,2,1,1,
  3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,1,2,3,0,0,2,3,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,1,3,3,3,3,3,3,3,1,3,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,1,0,2,3,1,1,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,3,2,2,3,2,0,2,2,1,1,
  3,3,3,2,2,3,3,2,1,1,2,3,3,1,1,2,2,2,2,3,2,3,2,3,2,1,3,1,1,2,1,2,1,
  3,3,3,3,2,3,3,3,2,3,3,3,2,1,1,1,2,2,1,3,3,3,1,3,1,1,3,1,0,2,3,1,1,
  3,3,3,2,3,3,3,3,1,3,3,3,2,2,3,1,2,3,1,3,3,3,1,3,1,2,3,1,0,3,1,2,1,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,2,3,3,2,3,3,3,2,3,0,2,1,0,
  3,3,3,3,2,3,1,1,1,2,1,3,3,3,3,1,1,2,1,3,1,3,1,3,1,1,3,0,0,3,1,1,1,
  3,3,3,2,3,3,3,3,2,3,3,3,1,3,1,1,1,1,1,3,3,3,1,3,0,1,3,0,0,3,1,0,1,
  3,3,3,3,3,3,3,3,2,2,3,3,1,1,2,1,2,2,2,3,1,3,0,3,3,1,3,0,0,2,1,1,1,
  3,3,3,3,2,3,3,3,2,1,2,3,3,1,1,2,1,2,1,3,3,3,0,2,1,1,3,0,0,3,1,1,3,
  3,3,3,1,1,3,2,2,2,1,1,3,1,0,1,1,1,1,1,3,1,3,0,2,0,0,3,1,0,0,0,0,0,
  3,3,3,2,2,2,2,3,1,2,2,3,2,1,2,1,1,1,0,3,1,0,0,1,1,1,1,1,0,1,1,1,0,
  3,3,3,1,2,3,3,3,1,2,2,3,1,1,1,1,1,1,2,2,1,3,0,2,1,1,2,0,0,2,1,1,1,
  1,0,0,3,3,1,3,3,3,2,3,0,3,3,2,3,3,0,2,0,0,0,1,0,1,1,0,2,1,0,1,0,0,
  3,3,3,2,2,3,3,2,1,1,2,3,2,1,2,1,1,2,1,2,1,2,0,2,0,1,2,1,0,2,2,1,1,
  2,3,3,3,3,0,3,3,3,3,3,1,3,2,2,3,2,0,3,1,1,0,2,0,1,2,0,1,1,0,1,0,0,
  0,1,0,0,1,1,1,1,1,0,1,3,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,
  1,1,0,3,3,2,3,3,2,3,3,2,3,3,3,3,2,1,3,0,1,0,2,0,2,2,0,3,1,0,1,0,0,
  3,3,3,1,1,3,1,0,1,0,1,3,1,1,1,0,1,1,1,3,1,1,0,1,1,0,3,1,0,2,1,0,1,
  3,3,3,2,1,3,1,1,1,3,2,3,2,1,1,2,1,1,1,3,1,0,3,3,0,2,1,0,0,2,1,1,0,
  1,3,1,3,3,2,3,3,2,3,3,1,2,3,2,3,2,1,2,0,0,0,1,0,2,1,0,3,0,0,1,0,0,
  2,3,2,0,1,3,1,2,1,3,3,2,1,3,1,0,3,1,1,1,2,1,1,2,1,0,1,3,0,0,0,1,0,
  3,3,3,0,0,2,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,2,0,1,0,0,1,0,0,0,0,0,0,
  1,3,1,3,3,0,2,3,1,3,2,0,3,2,3,0,0,0,1,0,1,0,0,0,1,1,0,0,1,0,0,0,0,
  3,3,3,2,2,3,2,2,1,2,1,2,3,1,1,1,1,2,1,1,2,1,0,1,1,0,1,0,0,1,2,1,0,
  3,3,2,1,1,3,1,1,1,0,1,1,1,1,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,
  3,0,0,1,1,2,1,1,0,1,1,0,0,0,1,0,1,0,0,0,1,2,0,0,0,1,1,0,0,0,1,0,0,
};


const SequenceModel Iso_8859_15SpanishModel =
{
  Iso_8859_15_CharToOrderMap,
  SpanishLangModel,
  33,
  (float)0.9990026288941288,
  PR_TRUE,
  "ISO-8859-15",
  "es"
};

const SequenceModel Iso_8859_1SpanishModel =
{
  Iso_8859_1_CharToOrderMap,
  SpanishLangModel,
  33,
  (float)0.9990026288941288,
  PR_TRUE,
  "ISO-8859-1",
  "es"
};

const SequenceModel Windows_1252SpanishModel =
{
  Windows_1252_CharToOrderMap,
  SpanishLangModel,
  33,
  (float)0.9990026288941288,
  PR_TRUE,
  "WINDOWS-1252",
  "es"
};

const LanguageModel SpanishModel =
{
  "es",
  Unicode_CharOrder,
  66,
  SpanishLangModel,
  33,
  4,
  (float)0.4006610130808832,
  20,
  (float)0.03251280941750342,
};
