/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Swedish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:20:31.413578
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 66,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   67, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43, 68, 32, 45, 69, /* CX */
   42, 44, 70, 33, 38, 59, 22,SYM, 39, 71, 40, 72, 34, 56, 50, 54, /* DX */
   73, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43, 74, 32, 45, 75, /* EX */
   42, 44, 76, 33, 38, 59, 22,SYM, 39, 77, 40, 78, 34, 56, 50, 79, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_4_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 80, 81, 82,SYM, 83, 65,SYM,SYM, 53, 48, 84, 85,SYM, 86,SYM, /* AX */
  SYM, 87,SYM, 88,SYM, 89, 65,SYM,SYM, 53, 48, 90, 91, 58, 92, 58, /* BX */
   46, 30, 49, 31, 18, 21, 35, 93, 57, 28, 63, 43, 94, 32, 45, 51, /* CX */
   95, 64, 37, 96, 38, 59, 22,SYM, 39, 97, 40, 98, 34, 99, 55, 54, /* DX */
   46, 30, 49, 31, 18, 21, 35,100, 57, 28, 63, 43,101, 32, 45, 51, /* EX */
  102, 64, 37,103, 38, 59, 22,SYM, 39,104, 40,105, 34,106, 55,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,107,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  108, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43,109, 32, 45,110, /* CX */
   61, 44,111, 33, 38, 59, 22,SYM, 39,112, 40,113, 34,114, 60, 54, /* DX */
  115, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43,116, 32, 45,117, /* EX */
   61, 44,118, 33, 38, 59, 22,SYM, 39,119, 40,120, 34,121, 60,122, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 53,SYM, 53,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,123,124,SYM,SYM,125,SYM,SYM,SYM, 62, 62,126,SYM, /* BX */
  127, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43,128, 32, 45,129, /* CX */
   42, 44,130, 33, 38, 59, 22,SYM, 39,131, 40,132, 34, 56, 50, 54, /* DX */
  133, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43,134, 32, 45,135, /* EX */
   42, 44,136, 33, 38, 59, 22,SYM, 39,137, 40,138, 34, 56, 50,139, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 19,  9,  0, 15, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   16, 29,  2,  5,  4, 14, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 52,SYM,SYM,SYM,SYM,SYM,SYM, 53,SYM, 62,ILL,140,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 53,SYM, 62,ILL,141,142, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,143,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  144, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43,145, 32, 45,146, /* CX */
   42, 44,147, 33, 38, 59, 22,SYM, 39,148, 40,149, 34, 56, 50, 54, /* DX */
  150, 30, 49, 31, 18, 21, 35, 36, 41, 28, 47, 43,151, 32, 45,152, /* EX */
   42, 44,153, 33, 38, 59, 22,SYM, 39,154, 40,155, 34, 56, 50,156, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 60;
static const unsigned int Unicode_CharOrder[] =
{
   65,  1,  66, 20,  67, 19,  68,  9,  69,  0,  70, 15,  71, 12, 72, 17,
   73,  6,  74, 23,  75, 11,  76,  7,  77, 10,  78,  3,  79,  8, 80, 16,
   81, 29,  82,  2,  83,  5,  84,  4,  85, 14,  86, 13,  87, 26, 88, 25,
   89, 24,  90, 27,  97,  1,  98, 20,  99, 19, 100,  9, 101,  0,102, 15,
  103, 12, 104, 17, 105,  6, 106, 23, 107, 11, 108,  7, 109, 10,110,  3,
  111,  8, 112, 16, 113, 29, 114,  2, 115,  5, 116,  4, 117, 14,118, 13,
  119, 26, 120, 25, 121, 24, 122, 27, 196, 18, 197, 21, 201, 28,214, 22,
  228, 18, 229, 21, 233, 28, 246, 22,
};


/* Model Table:
 * Total considered sequences: 1083 / 900
 * - Positive sequences: first 502 (0.9950552774288863)
 * - Probable sequences: next 173 (675-502) (0.003945597397539302)
 * - Neutral sequences: last 225 (0.0009991251735743667)
 * - Negative sequences: -183 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 SwedishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,2,2,3,3,3,3,3,0,2,
  3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,1,1,3,3,3,3,3,1,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,1,2,3,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,2,1,3,2,3,1,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,1,2,3,3,3,3,2,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,3,3,3,3,1,2,2,2,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,1,1,0,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,0,2,3,3,2,3,1,1,0,1,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,1,3,3,3,3,3,0,1,1,2,1,
  3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,2,2,3,1,2,3,2,2,1,0,0,0,1,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,2,0,3,3,1,2,2,2,3,1,2,1,1,
  3,3,3,2,3,2,3,3,3,1,1,1,2,1,3,3,1,0,3,1,1,3,3,3,3,0,1,0,1,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,3,3,2,2,3,1,2,2,0,1,1,2,0,
  3,3,3,3,3,2,3,3,3,1,2,1,1,1,3,1,1,1,3,1,2,3,3,3,3,0,2,1,2,1,
  1,1,3,3,3,3,1,3,0,3,3,3,3,3,1,3,3,1,0,3,3,0,0,0,0,3,0,0,0,0,
  3,3,3,2,3,2,3,3,3,2,2,3,1,1,3,1,1,3,0,3,1,0,0,1,3,1,0,2,2,2,
  3,3,3,3,3,3,3,3,3,2,2,2,1,2,3,2,2,2,3,2,3,3,3,3,3,0,1,1,1,1,
  3,1,3,3,3,3,2,3,1,3,2,3,3,3,0,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,
  2,3,3,3,3,3,2,3,1,3,3,3,3,3,0,2,3,1,2,2,2,1,1,3,0,0,1,1,0,0,
  3,3,1,3,2,3,2,3,3,3,1,2,2,2,3,2,1,1,3,0,2,0,3,0,1,1,0,1,1,0,
  2,3,3,3,3,3,1,3,3,3,3,3,3,2,2,3,3,2,1,3,2,1,1,1,1,2,1,1,0,0,
  3,3,1,2,3,1,3,3,3,1,1,2,1,1,2,2,3,2,0,2,1,0,0,2,1,0,0,0,0,0,
  3,3,2,2,2,2,3,1,3,1,1,2,0,0,1,1,0,2,1,1,1,0,0,1,1,1,2,1,0,0,
  3,3,1,1,2,1,3,1,3,0,1,2,1,0,2,0,1,2,1,1,1,0,0,1,2,0,1,2,1,0,
  3,1,2,3,2,3,1,2,1,1,2,0,2,1,1,2,2,0,0,2,1,0,0,1,0,1,0,1,0,0,
  0,1,0,0,0,0,1,1,1,1,0,0,1,1,3,0,0,0,0,1,1,0,0,0,1,0,1,0,0,0,
};


const SequenceModel Iso_8859_1SwedishModel =
{
  Iso_8859_1_CharToOrderMap,
  SwedishLangModel,
  30,
  (float)0.9990008748264256,
  PR_TRUE,
  "ISO-8859-1",
  "sv"
};

const SequenceModel Iso_8859_4SwedishModel =
{
  Iso_8859_4_CharToOrderMap,
  SwedishLangModel,
  30,
  (float)0.9990008748264256,
  PR_TRUE,
  "ISO-8859-4",
  "sv"
};

const SequenceModel Iso_8859_9SwedishModel =
{
  Iso_8859_9_CharToOrderMap,
  SwedishLangModel,
  30,
  (float)0.9990008748264256,
  PR_TRUE,
  "ISO-8859-9",
  "sv"
};

const SequenceModel Iso_8859_15SwedishModel =
{
  Iso_8859_15_CharToOrderMap,
  SwedishLangModel,
  30,
  (float)0.9990008748264256,
  PR_TRUE,
  "ISO-8859-15",
  "sv"
};

const SequenceModel Windows_1252SwedishModel =
{
  Windows_1252_CharToOrderMap,
  SwedishLangModel,
  30,
  (float)0.9990008748264256,
  PR_TRUE,
  "WINDOWS-1252",
  "sv"
};

const LanguageModel SwedishModel =
{
  "sv",
  Unicode_CharOrder,
  60,
  SwedishLangModel,
  30,
  5,
  (float)0.4423731214253967,
  21,
  (float)0.03064427111061184,
};
