/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Thai *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:23:34.345129
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_11_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, /* 4X */
   84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 95, 96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109, /* 6X */
  110,111,112,113,114,115,116,117,118,119,120,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,  3, 29, 67, 22,121, 63,  6, 26, 55, 28, 40, 65, 46, 58, 57, /* AX */
   48, 59, 56, 47, 20, 18, 45, 16, 42,  1, 24, 19, 49, 51, 30, 50, /* BX */
   44,  9, 11,  2, 52, 12,122, 15, 34, 43, 17, 25, 61,  4, 53, 64, /* CX */
   21,SYM,  0, 39,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,ILL,ILL,ILL,SYM, /* DX */
    5, 23, 35, 27, 36,123, 54,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,124, /* EX */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,125,126,ILL,ILL,ILL,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Tis_620_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141, /* 4X */
  142,143,144,145,146,147,148,149,150,151,152,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167, /* 6X */
  168,169,170,171,172,173,174,175,176,177,178,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  ILL,  3, 29, 67, 22,179, 63,  6, 26, 55, 28, 40, 65, 46, 58, 57, /* AX */
   48, 59, 56, 47, 20, 18, 45, 16, 42,  1, 24, 19, 49, 51, 30, 50, /* BX */
   44,  9, 11,  2, 52, 12,180, 15, 34, 43, 17, 25, 61,  4, 53, 64, /* CX */
   21,SYM,  0, 39,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,ILL,ILL,ILL,SYM, /* DX */
    5, 23, 35, 27, 36,181, 54,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,182, /* EX */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,183,184,ILL,ILL,ILL,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 69;
static const unsigned int Unicode_CharOrder[] =
{
  3585,  3, 3586, 29, 3587, 67, 3588, 22, 3590, 63, 3591,  6, 3592, 26,3593, 55,
  3594, 28, 3595, 40, 3596, 65, 3597, 46, 3598, 58, 3599, 57, 3600, 48,3601, 59,
  3602, 56, 3603, 47, 3604, 20, 3605, 18, 3606, 45, 3607, 16, 3608, 42,3609,  1,
  3610, 24, 3611, 19, 3612, 49, 3613, 51, 3614, 30, 3615, 50, 3616, 44,3617,  9,
  3618, 11, 3619,  2, 3620, 52, 3621, 12, 3623, 15, 3624, 34, 3625, 43,3626, 17,
  3627, 25, 3628, 61, 3629,  4, 3630, 53, 3631, 64, 3632, 21, 3633,  8,3634,  0,
  3635, 39, 3636, 14, 3637, 10, 3638, 41, 3639, 33, 3640, 32, 3641, 38,3642, 66,
  3648,  5, 3649, 23, 3650, 35, 3651, 27, 3652, 36, 3654, 54, 3655, 37,3656,  7,
  3657, 13, 3658, 60, 3659, 62, 3660, 31, 3661, 68,
};


/* Model Table:
 * Total considered sequences: 2458 / 4761
 * - Positive sequences: first 1634 (0.9950175671509007)
 * - Probable sequences: next 347 (1981-1634) (0.003986731842203994)
 * - Neutral sequences: last 2780 (0.0009957010068952776)
 * - Negative sequences: 2303 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 ThaiLangModel[] =
{
  0,3,3,3,3,3,3,0,0,3,0,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,
   3,3,3,0,0,0,3,0,3,3,3,3,3,3,1,3,3,3,1,3,1,2,0,2,0,1,0,2,0,2,1,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   3,3,3,3,3,3,3,3,3,0,3,3,3,0,3,3,3,3,3,3,3,2,0,1,0,0,0,0,0,1,1,1,1,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,0,2,0,2,1,0,0,0,1,0,0,3,1,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,2,2,0,3,3,0,3,0,2,2,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,
   3,3,3,3,3,3,3,1,3,0,3,3,3,0,1,3,3,3,1,3,0,1,0,0,0,0,1,0,1,1,0,0,0,0,0,
  0,3,3,3,3,0,3,0,0,3,0,3,3,0,0,3,3,3,3,3,3,0,3,0,3,3,3,0,3,3,3,0,0,0,
   3,0,0,0,0,0,3,0,3,2,3,3,0,1,0,3,3,2,0,3,0,3,1,1,0,0,0,0,0,0,0,2,0,0,0,
  3,3,3,3,3,3,3,3,2,3,2,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,3,
   3,3,3,0,1,2,3,0,3,2,3,3,3,0,2,3,3,3,2,3,3,2,0,0,0,0,0,0,0,1,0,1,0,0,0,
  3,3,3,3,3,3,3,0,0,3,0,3,3,0,0,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,0,0,0,
   3,3,3,0,0,3,3,0,2,0,3,3,2,0,1,3,2,3,1,2,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,
  0,3,2,3,0,0,3,3,0,3,0,3,3,3,0,3,3,3,3,3,3,0,3,0,3,0,3,1,3,1,3,0,0,0,
   3,0,0,0,0,0,2,0,3,1,0,0,3,3,3,0,3,1,0,0,0,0,3,0,1,0,2,0,3,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,
   3,3,3,3,3,0,3,1,2,3,3,3,2,3,1,3,3,3,2,2,1,3,0,0,0,1,0,0,0,2,1,0,0,0,0,
  0,3,3,3,3,3,3,3,0,3,0,3,3,3,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,0,0,
   3,3,3,0,0,0,3,0,2,1,3,3,2,0,3,3,3,3,2,2,0,1,0,0,0,1,1,3,2,1,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   3,3,3,3,3,2,3,3,3,0,3,3,3,2,2,3,2,3,1,2,2,2,0,0,0,0,0,0,0,1,1,1,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   2,3,3,3,3,3,3,3,1,0,3,2,2,0,1,3,3,2,0,2,0,1,0,1,2,0,1,0,0,0,2,0,0,0,0,
  3,3,3,3,3,3,3,0,0,3,0,3,3,0,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,0,0,
   2,3,3,0,0,3,3,0,3,0,3,3,2,0,1,3,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,3,3,3,0,3,0,3,3,3,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,0,0,
   3,3,3,0,0,0,3,0,3,3,3,3,3,2,2,2,3,2,0,2,0,0,1,0,1,0,2,2,3,1,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
   2,3,3,3,2,0,3,0,1,0,3,3,3,3,0,2,2,3,1,3,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,
  3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,2,3,2,3,3,3,3,3,
   3,3,2,3,3,3,3,3,3,3,1,0,0,0,0,2,1,1,3,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   1,3,3,1,3,3,3,3,3,0,3,3,0,0,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,2,
   3,3,3,3,3,3,3,3,2,0,3,3,1,0,0,2,2,1,1,1,0,0,0,0,0,0,2,0,2,0,1,0,1,0,0,
  3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,3,3,3,3,3,3,3,3,
   2,3,3,3,2,0,3,2,0,0,3,3,2,1,1,1,0,0,0,1,0,1,0,3,0,0,1,0,1,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   2,3,3,3,3,3,2,3,1,0,3,3,1,0,1,3,2,2,1,1,1,2,0,0,0,0,0,0,0,1,0,0,0,0,0,
  0,3,3,3,3,3,3,0,0,3,0,3,3,0,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,0,0,
   3,3,3,0,0,0,3,0,3,1,3,3,3,1,1,3,3,3,2,3,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,
   1,3,3,1,3,3,3,1,2,0,2,1,0,3,0,1,1,2,2,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,
  0,3,3,3,3,1,3,0,0,3,0,3,3,0,0,3,3,3,3,3,3,0,3,1,3,3,3,0,3,3,3,0,0,0,
   0,0,0,0,0,0,3,0,1,0,0,3,0,1,0,3,3,0,0,3,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,
   3,3,3,3,3,2,3,1,3,0,3,3,3,0,1,3,2,3,1,3,1,2,0,2,1,0,1,0,1,1,0,0,0,0,0,
  3,3,3,3,3,0,2,3,3,3,1,3,3,3,3,3,0,1,3,3,2,3,1,0,1,1,0,0,0,0,3,3,3,1,
   1,0,0,3,3,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   1,3,3,3,3,3,3,3,0,0,1,2,1,1,0,1,2,1,0,1,0,3,0,0,0,0,2,0,2,0,2,0,0,0,0,
  0,3,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,3,3,0,3,0,2,0,3,3,3,0,3,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,3,2,3,2,3,3,2,3,3,3,
   1,3,2,3,3,3,1,0,2,0,1,0,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,
  3,3,2,2,3,2,2,3,3,3,3,3,1,3,1,3,3,2,3,2,1,0,2,3,3,1,2,2,0,3,1,2,3,2,
   1,1,1,3,1,1,0,3,1,0,3,1,0,3,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,3,3,3,3,3,3,3,3,3,3,3,
   3,3,3,2,3,1,1,3,2,0,3,2,3,3,0,2,2,2,3,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
  0,3,3,3,3,3,0,0,0,3,0,3,3,0,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,0,0,
   3,3,3,0,0,0,3,0,2,0,3,3,2,0,0,2,3,2,1,3,0,2,0,0,0,0,0,0,0,1,2,0,0,0,0,
  0,3,3,3,3,3,3,3,0,3,0,3,3,3,0,3,3,3,3,3,3,0,3,3,3,2,3,3,3,3,3,3,1,0,
   2,3,3,0,0,0,2,0,3,3,3,2,3,3,0,2,1,0,0,1,0,0,3,1,2,1,2,2,2,1,0,0,0,0,0,
  0,3,1,0,3,0,1,3,0,2,0,1,0,3,0,0,0,0,0,0,2,0,0,0,3,0,0,0,3,0,1,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,1,0,3,3,2,3,3,0,3,3,3,3,3,3,2,0,3,3,3,3,3,3,3,3,3,3,2,0,
   1,3,3,0,3,0,2,3,1,3,2,2,3,0,0,3,2,3,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,0,2,0,0,3,0,3,3,0,0,3,3,2,3,3,3,0,3,0,3,3,3,0,3,3,3,0,0,0,
   1,0,0,0,0,0,3,0,2,0,3,1,0,1,0,1,2,0,0,3,0,1,0,0,0,0,0,0,0,2,0,1,0,0,0,
  0,3,3,3,3,0,0,0,0,3,0,1,3,0,0,3,3,2,3,3,3,0,3,0,3,3,1,0,2,3,2,0,0,0,
   0,0,0,0,0,0,3,0,1,0,0,2,1,0,0,1,3,1,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,1,3,3,3,3,0,0,3,0,3,2,0,0,3,2,3,3,2,3,0,3,1,3,1,3,1,1,1,2,0,0,0,
   0,1,3,0,0,0,1,0,0,0,0,3,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,3,3,3,0,3,0,1,3,3,0,2,3,3,3,3,3,0,2,3,3,3,3,3,3,3,2,0,0,0,
   2,3,3,0,0,0,3,0,1,0,0,1,3,1,0,1,1,2,0,2,0,1,0,1,0,0,3,0,2,0,0,0,0,0,0,
  0,3,3,3,3,3,3,0,0,3,0,2,3,0,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,0,0,
   2,3,3,0,0,0,2,0,2,0,2,2,1,0,0,2,2,3,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
  3,3,2,2,3,3,3,3,3,3,3,2,3,3,3,2,1,2,3,2,2,3,3,2,2,0,1,1,0,1,1,3,3,3,
   0,3,2,3,3,1,2,3,3,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,2,0,3,1,1,3,3,0,2,0,0,1,3,0,0,0,1,0,1,3,0,0,0,1,1,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,0,3,3,3,3,0,0,3,2,3,2,1,2,1,1,1,2,1,1,1,2,1,2,1,3,3,0,
   3,1,2,0,0,1,0,0,0,0,3,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,0,0,3,3,3,3,0,0,2,1,3,3,3,2,2,3,2,3,0,2,2,3,1,2,1,3,1,0,
   1,2,3,0,0,0,1,0,0,0,3,1,0,3,3,1,0,1,0,1,1,0,0,2,3,0,0,0,0,0,0,0,0,0,0,
  3,0,2,1,2,0,0,0,3,1,2,1,0,0,3,0,3,2,0,0,0,1,3,1,0,0,0,0,1,0,3,2,1,0,
   0,0,0,0,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,2,3,3,2,2,3,0,2,3,3,2,2,3,1,2,2,2,3,3,
   0,1,3,0,3,0,1,3,0,0,1,2,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,3,3,1,3,3,3,3,1,3,2,3,1,3,3,2,1,2,0,2,3,2,3,3,3,3,3,3,1,1,0,
   1,2,2,0,0,0,2,0,1,0,1,1,3,0,0,1,0,0,0,1,1,2,0,0,0,0,0,0,0,1,1,0,0,0,0,
  3,3,3,3,3,3,1,0,3,2,3,2,3,0,3,3,3,3,3,2,2,3,3,3,2,3,2,2,3,3,2,3,1,0,
   2,1,1,0,2,0,1,0,2,0,3,1,0,1,1,2,0,2,0,0,0,0,0,2,0,3,0,0,0,0,0,0,1,0,0,
  3,3,2,3,3,3,0,0,0,3,2,2,2,0,1,3,3,3,3,3,2,0,2,3,3,3,3,3,2,2,2,2,0,0,
   2,2,3,0,0,0,3,0,3,0,2,1,1,0,0,1,1,2,0,2,0,1,0,0,0,0,0,0,0,1,3,1,0,0,0,
  2,3,0,1,1,0,2,3,3,1,1,3,3,3,3,1,0,3,0,0,3,0,0,0,0,0,1,0,3,0,0,0,1,3,
   0,0,0,1,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,3,3,1,2,3,1,3,2,3,3,3,1,3,2,3,1,1,0,2,2,2,1,1,2,2,2,1,2,3,3,
   0,2,2,2,3,0,2,0,0,0,1,0,1,0,0,0,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,3,3,0,0,0,1,3,3,0,2,0,0,2,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,2,1,
   0,0,0,0,2,0,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,2,0,3,0,3,0,1,0,0,1,0,0,0,0,0,0,0,0,
   3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,3,2,3,3,3,2,1,2,1,1,1,1,0,1,1,0,1,0,0,0,0,2,3,1,
   0,2,0,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,
  0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,2,0,1,0,0,0,1,2,0,0,0,1,0,1,0,0,0,0,
   0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,1,1,2,1,0,1,0,3,0,3,1,3,2,2,2,0,0,0,0,0,1,0,0,3,0,0,0,0,0,3,0,2,1,
   0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,0,0,0,0,0,1,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,1,2,1,2,0,0,0,1,1,1,1,0,3,2,1,0,2,1,0,0,1,1,1,1,0,3,1,2,0,0,0,0,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,1,3,1,2,2,0,0,0,0,3,0,0,0,0,0,1,1,0,0,1,0,0,1,2,3,0,1,0,1,0,0,0,0,
   0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,0,1,0,0,0,0,0,0,1,0,3,0,2,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,3,0,0,
   0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,3,3,0,0,0,0,1,0,1,0,0,0,2,0,2,2,1,1,2,1,0,1,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,1,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,
   0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,1,0,1,2,1,2,0,0,0,0,2,0,0,0,3,1,1,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,0,0,1,0,3,1,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,
   0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,0,1,1,0,0,1,0,2,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,
   0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,2,0,0,0,0,0,2,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_11ThaiModel =
{
  Iso_8859_11_CharToOrderMap,
  ThaiLangModel,
  69,
  (float)0.9990042989931047,
  PR_FALSE,
  "ISO-8859-11",
  "th"
};

const SequenceModel Tis_620ThaiModel =
{
  Tis_620_CharToOrderMap,
  ThaiLangModel,
  69,
  (float)0.9990042989931047,
  PR_FALSE,
  "TIS-620",
  "th"
};

const LanguageModel ThaiModel =
{
  "th",
  Unicode_CharOrder,
  69,
  ThaiLangModel,
  69,
  9,
  (float)0.4296733852091798,
  43,
  (float)0.031143367969453536,
};
