// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoBitParticle.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef _EOBITPARTICLE_H
#define _EOBITPARTICLE_H


#include <eoVectorParticle.h>


/** eoBitParticle: Implementation of a bit-coded particle.
 *  Positions and best positions are 0 or 1 but the velocity is a vector of double.
*/
template < class FitT> class eoBitParticle: public eoVectorParticle<FitT,bool,double>

{
public:

    eoBitParticle(unsigned size = 0, bool positions = 0,double velocities = 0.0,bool bestPositions = 0): eoVectorParticle<FitT, bool,double> (size, positions,velocities,bestPositions) {}

    virtual std::string className() const
    {
        return "eoBitParticle";
    }
};

#endif /*_EOBITPARTICLE_H*/
