// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoTopology.h
// (c) OPAC 2007
/*


    Contact: paradiseo-help@lists.gforge.inria.fr, http://paradiseo.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EOTOPOLOGY_H_
#define EOTOPOLOGY_H_

//-----------------------------------------------------------------------------
#include <eoNeighborhood.h>
//-----------------------------------------------------------------------------


/**
 * Define the interface for a swarm optimization topology.
 */
template < class POT > class eoTopology:public eoPop < POT >
{
public:

    /**
     * Build the neighborhoods contained in the topology.
     */
    virtual void setup(const eoPop<POT> &)=0;

    /**
     * Update the neighborhood of the given particle and its indice in the population
     */
    virtual void updateNeighborhood(POT & ,unsigned)=0;


    /**
      * Update the neighborhood of the given particle thanks to a whole population (used for distributed or synchronous PSO)
      */
    virtual void updateNeighborhood(eoPop < POT > &_pop)
    {
        for (unsigned i = 0; i < _pop.size (); i++)
        {
            updateNeighborhood(_pop[i],i);
        }
    }

    /**
     * Build the neighborhoods contained in the topology.
     */
    virtual POT & best (unsigned ) = 0;

    /**
     * Build the neighborhoods contained in the topology.
     * @param _pop - The population ton share between the neighborhood(s)
     */
    virtual void printOn(){}
};


#endif /*EOTOPOLOGY_H_ */








