"use strict";var Buffer=require("buffer").Buffer,Transform=require("stream").Transform,binding=require("./binding"),util=require("util"),assert=require("assert").ok,kMaxLength=require("buffer").kMaxLength,kRangeErrorMessage="Cannot create final Buffer. It would be larger than 0x"+kMaxLength.toString(16)+" bytes";binding.Z_MIN_WINDOWBITS=8,binding.Z_MAX_WINDOWBITS=15,binding.Z_DEFAULT_WINDOWBITS=15,binding.Z_MIN_CHUNK=64,binding.Z_MAX_CHUNK=1/0,binding.Z_DEFAULT_CHUNK=16384,binding.Z_MIN_MEMLEVEL=1,binding.Z_MAX_MEMLEVEL=9,binding.Z_DEFAULT_MEMLEVEL=8,binding.Z_MIN_LEVEL=-1,binding.Z_MAX_LEVEL=9,binding.Z_DEFAULT_LEVEL=binding.Z_DEFAULT_COMPRESSION;for(var bkeys=Object.keys(binding),bk=0;bk<bkeys.length;bk++){var e=bkeys[bk];e.match(/^Z/)&&Object.defineProperty(exports,e,{enumerable:!0,value:binding[e],writable:!1})}for(var codes={Z_OK:binding.Z_OK,Z_STREAM_END:binding.Z_STREAM_END,Z_NEED_DICT:binding.Z_NEED_DICT,Z_ERRNO:binding.Z_ERRNO,Z_STREAM_ERROR:binding.Z_STREAM_ERROR,Z_DATA_ERROR:binding.Z_DATA_ERROR,Z_MEM_ERROR:binding.Z_MEM_ERROR,Z_BUF_ERROR:binding.Z_BUF_ERROR,Z_VERSION_ERROR:binding.Z_VERSION_ERROR},ckeys=Object.keys(codes),ck=0;ck<ckeys.length;ck++){var n=ckeys[ck];codes[codes[n]]=n}function zlibBuffer(e,n,i){var t=[],r=0;function s(){for(var n;null!==(n=e.read());)t.push(n),r+=n.length;e.once("readable",s)}function f(){var n,s=null;r>=kMaxLength?s=RangeError(kRangeErrorMessage):n=Buffer.concat(t,r),t=[],e.close(),i(s,n)}e.on("error",function(n){e.removeListener("end",f),e.removeListener("readable",s),i(n)}),e.on("end",f),e.end(n),s()}function zlibBufferSync(e,n){if("string"==typeof n&&(n=Buffer.from(n)),!Buffer.isBuffer(n))throw TypeError("Not a string or buffer");var i=e._finishFlushFlag;return e._processChunk(n,i)}function Deflate(e){if(!(this instanceof Deflate))return new Deflate(e);Zlib.call(this,e,binding.DEFLATE)}function Inflate(e){if(!(this instanceof Inflate))return new Inflate(e);Zlib.call(this,e,binding.INFLATE)}function Gzip(e){if(!(this instanceof Gzip))return new Gzip(e);Zlib.call(this,e,binding.GZIP)}function Gunzip(e){if(!(this instanceof Gunzip))return new Gunzip(e);Zlib.call(this,e,binding.GUNZIP)}function DeflateRaw(e){if(!(this instanceof DeflateRaw))return new DeflateRaw(e);Zlib.call(this,e,binding.DEFLATERAW)}function InflateRaw(e){if(!(this instanceof InflateRaw))return new InflateRaw(e);Zlib.call(this,e,binding.INFLATERAW)}function Unzip(e){if(!(this instanceof Unzip))return new Unzip(e);Zlib.call(this,e,binding.UNZIP)}function isValidFlushFlag(e){return e===binding.Z_NO_FLUSH||e===binding.Z_PARTIAL_FLUSH||e===binding.Z_SYNC_FLUSH||e===binding.Z_FULL_FLUSH||e===binding.Z_FINISH||e===binding.Z_BLOCK}function Zlib(e,n){var i=this;if(this._opts=e=e||{},this._chunkSize=e.chunkSize||exports.Z_DEFAULT_CHUNK,Transform.call(this,e),e.flush&&!isValidFlushFlag(e.flush))throw Error("Invalid flush flag: "+e.flush);if(e.finishFlush&&!isValidFlushFlag(e.finishFlush))throw Error("Invalid flush flag: "+e.finishFlush);if(this._flushFlag=e.flush||binding.Z_NO_FLUSH,this._finishFlushFlag=void 0!==e.finishFlush?e.finishFlush:binding.Z_FINISH,e.chunkSize&&(e.chunkSize<exports.Z_MIN_CHUNK||e.chunkSize>exports.Z_MAX_CHUNK))throw Error("Invalid chunk size: "+e.chunkSize);if(e.windowBits&&(e.windowBits<exports.Z_MIN_WINDOWBITS||e.windowBits>exports.Z_MAX_WINDOWBITS))throw Error("Invalid windowBits: "+e.windowBits);if(e.level&&(e.level<exports.Z_MIN_LEVEL||e.level>exports.Z_MAX_LEVEL))throw Error("Invalid compression level: "+e.level);if(e.memLevel&&(e.memLevel<exports.Z_MIN_MEMLEVEL||e.memLevel>exports.Z_MAX_MEMLEVEL))throw Error("Invalid memLevel: "+e.memLevel);if(e.strategy&&e.strategy!=exports.Z_FILTERED&&e.strategy!=exports.Z_HUFFMAN_ONLY&&e.strategy!=exports.Z_RLE&&e.strategy!=exports.Z_FIXED&&e.strategy!=exports.Z_DEFAULT_STRATEGY)throw Error("Invalid strategy: "+e.strategy);if(e.dictionary&&!Buffer.isBuffer(e.dictionary))throw Error("Invalid dictionary: it should be a Buffer instance");this._handle=new binding.Zlib(n);var t=this;this._hadError=!1,this._handle.onerror=function(e,n){_close(t),t._hadError=!0;var i=Error(e);i.errno=n,i.code=exports.codes[n],t.emit("error",i)};var r=exports.Z_DEFAULT_COMPRESSION;"number"==typeof e.level&&(r=e.level);var s=exports.Z_DEFAULT_STRATEGY;"number"==typeof e.strategy&&(s=e.strategy),this._handle.init(e.windowBits||exports.Z_DEFAULT_WINDOWBITS,r,e.memLevel||exports.Z_DEFAULT_MEMLEVEL,s,e.dictionary),this._buffer=Buffer.allocUnsafe(this._chunkSize),this._offset=0,this._level=r,this._strategy=s,this.once("end",this.close),Object.defineProperty(this,"_closed",{get:function(){return!i._handle},configurable:!0,enumerable:!0})}function _close(e,n){n&&process.nextTick(n),e._handle&&(e._handle.close(),e._handle=null)}function emitCloseNT(e){e.emit("close")}Object.defineProperty(exports,"codes",{enumerable:!0,value:Object.freeze(codes),writable:!1}),exports.Deflate=Deflate,exports.Inflate=Inflate,exports.Gzip=Gzip,exports.Gunzip=Gunzip,exports.DeflateRaw=DeflateRaw,exports.InflateRaw=InflateRaw,exports.Unzip=Unzip,exports.createDeflate=function(e){return new Deflate(e)},exports.createInflate=function(e){return new Inflate(e)},exports.createDeflateRaw=function(e){return new DeflateRaw(e)},exports.createInflateRaw=function(e){return new InflateRaw(e)},exports.createGzip=function(e){return new Gzip(e)},exports.createGunzip=function(e){return new Gunzip(e)},exports.createUnzip=function(e){return new Unzip(e)},exports.deflate=function(e,n,i){return"function"==typeof n&&(i=n,n={}),zlibBuffer(new Deflate(n),e,i)},exports.deflateSync=function(e,n){return zlibBufferSync(new Deflate(n),e)},exports.gzip=function(e,n,i){return"function"==typeof n&&(i=n,n={}),zlibBuffer(new Gzip(n),e,i)},exports.gzipSync=function(e,n){return zlibBufferSync(new Gzip(n),e)},exports.deflateRaw=function(e,n,i){return"function"==typeof n&&(i=n,n={}),zlibBuffer(new DeflateRaw(n),e,i)},exports.deflateRawSync=function(e,n){return zlibBufferSync(new DeflateRaw(n),e)},exports.unzip=function(e,n,i){return"function"==typeof n&&(i=n,n={}),zlibBuffer(new Unzip(n),e,i)},exports.unzipSync=function(e,n){return zlibBufferSync(new Unzip(n),e)},exports.inflate=function(e,n,i){return"function"==typeof n&&(i=n,n={}),zlibBuffer(new Inflate(n),e,i)},exports.inflateSync=function(e,n){return zlibBufferSync(new Inflate(n),e)},exports.gunzip=function(e,n,i){return"function"==typeof n&&(i=n,n={}),zlibBuffer(new Gunzip(n),e,i)},exports.gunzipSync=function(e,n){return zlibBufferSync(new Gunzip(n),e)},exports.inflateRaw=function(e,n,i){return"function"==typeof n&&(i=n,n={}),zlibBuffer(new InflateRaw(n),e,i)},exports.inflateRawSync=function(e,n){return zlibBufferSync(new InflateRaw(n),e)},util.inherits(Zlib,Transform),Zlib.prototype.params=function(e,n,i){if(e<exports.Z_MIN_LEVEL||e>exports.Z_MAX_LEVEL)throw RangeError("Invalid compression level: "+e);if(n!=exports.Z_FILTERED&&n!=exports.Z_HUFFMAN_ONLY&&n!=exports.Z_RLE&&n!=exports.Z_FIXED&&n!=exports.Z_DEFAULT_STRATEGY)throw TypeError("Invalid strategy: "+n);if(this._level!==e||this._strategy!==n){var t=this;this.flush(binding.Z_SYNC_FLUSH,function(){assert(t._handle,"zlib binding closed"),t._handle.params(e,n),!t._hadError&&(t._level=e,t._strategy=n,i&&i())})}else process.nextTick(i)},Zlib.prototype.reset=function(){return assert(this._handle,"zlib binding closed"),this._handle.reset()},Zlib.prototype._flush=function(e){this._transform(Buffer.alloc(0),"",e)},Zlib.prototype.flush=function(e,n){var i=this,t=this._writableState;"function"!=typeof e&&(void 0!==e||n)||(n=e,e=binding.Z_FULL_FLUSH),t.ended?n&&process.nextTick(n):t.ending?n&&this.once("end",n):t.needDrain?n&&this.once("drain",function(){return i.flush(e,n)}):(this._flushFlag=e,this.write(Buffer.alloc(0),"",n))},Zlib.prototype.close=function(e){_close(this,e),process.nextTick(emitCloseNT,this)},Zlib.prototype._transform=function(e,n,i){var t,r=this._writableState,s=(r.ending||r.ended)&&(!e||r.length===e.length);return null===e||Buffer.isBuffer(e)?this._handle?void(s?t=this._finishFlushFlag:(t=this._flushFlag,e.length>=r.length&&(this._flushFlag=this._opts.flush||binding.Z_NO_FLUSH)),this._processChunk(e,t,i)):i(Error("zlib binding closed")):i(Error("invalid input"))},Zlib.prototype._processChunk=function(e,n,i){var t=e&&e.length,r=this._chunkSize-this._offset,s=0,f=this,o="function"==typeof i;if(!o){var l,a=[],u=0;this.on("error",function(e){l=e}),assert(this._handle,"zlib binding closed");do var _=this._handle.writeSync(n,e,s,t,this._buffer,this._offset,r);while(!this._hadError&&d(_[0],_[1]));if(this._hadError)throw l;if(u>=kMaxLength)throw _close(this),RangeError(kRangeErrorMessage);var h=Buffer.concat(a,u);return _close(this),h}assert(this._handle,"zlib binding closed");var c=this._handle.write(n,e,s,t,this._buffer,this._offset,r);function d(l,_){if(this&&(this.buffer=null,this.callback=null),!f._hadError){var h=r-_;if(assert(h>=0,"have should not go down"),h>0){var c=f._buffer.slice(f._offset,f._offset+h);f._offset+=h,o?f.push(c):(a.push(c),u+=c.length)}if((0===_||f._offset>=f._chunkSize)&&(r=f._chunkSize,f._offset=0,f._buffer=Buffer.allocUnsafe(f._chunkSize)),0===_){if(s+=t-l,t=l,!o)return!0;var p=f._handle.write(n,e,s,t,f._buffer,f._offset,f._chunkSize);return p.callback=d,void(p.buffer=e)}if(!o)return!1;i()}}c.buffer=e,c.callback=d},util.inherits(Deflate,Zlib),util.inherits(Inflate,Zlib),util.inherits(Gzip,Zlib),util.inherits(Gunzip,Zlib),util.inherits(DeflateRaw,Zlib),util.inherits(InflateRaw,Zlib),util.inherits(Unzip,Zlib);