$CONSOLE:ONLY

OPTION _EXPLICIT

DIM buffer AS STRING: buffer = LoadTestData
PRINT "Size ="; LEN(buffer)


DIM h AS LONG: h = _SNDOPEN(buffer, "memory")
PRINT "Handle ="; h
PRINT USING "Length = ####.####"; _SNDLEN(h)

SYSTEM

' Modified RhoSigma MakeDATA loader
FUNCTION LoadTestData$
    '--- option _explicit requirements ---
    DIM numL&, numB&, rawdata$, stroffs&, i&, dat&
    '--- write DATAs ---
    RESTORE Test
    READ numL&, numB&
    rawdata$ = SPACE$((numL& * 4) + numB&)
    stroffs& = 1
    FOR i& = 1 TO numL&
        READ dat&
        MID$(rawdata$, stroffs&, 4) = MKL$(dat&)
        stroffs& = stroffs& + 4
    NEXT i&
    IF numB& > 0 THEN
        FOR i& = 1 TO numB&
            READ dat&
            MID$(rawdata$, stroffs&, 1) = CHR$(dat&)
            stroffs& = stroffs& + 1
        NEXT i&
    END IF

    '--- set result ---
    LoadTestData$ = _INFLATE$(rawdata$)
    EXIT FUNCTION

    '--- DATAs representing the contents of file test.mp3
    '---------------------------------------------------------------------
    Test:
    DATA 10104,29
    DATA &H9C2C9C78,&HFFD53C77,&H15AFC717,&HEF7B5D59,&H5590854D,&H196C9BD9,&H0BB25995,&HECAD7199
    DATA &H9BD957BD,&H45C42B28,&H23DEF656,&HB9B23D91,&HB9FEFBDC,&H1FF7BFBE,&HF0F171F7,&HCF8F5E78
    DATA &H7AF39F79,&HF379F79D,&H985605B9,&H0810215B,&H0BF5E1A6,&HB20E7C04,&H66B3F799,&HDF130486
    DATA &HFC4A27BA,&HD0910A01,&H80BAAB5A,&H30E004A5,&H229F65FC,&H3B6887BC,&HC9C7F15C,&H8702CC3A
    DATA &H897F7281,&H9E1FA131,&HF8FE58BC,&H66FB6C03,&HFFF9E74B,&H1127C6A3,&HEE73D4A4,&HE336F8B3
    DATA &HC521FF00,&H13BEBF84,&HDE1932B9,&H82DD5595,&HF9DC98E6,&H218C53ED,&H1DB10D4B,&H674E24EA
    DATA &HED3EB2A5,&H2D283694,&HCAC9CDB6,&H341B0873,&H69482E51,&H75BD60BA,&HFB9C337B,&H60EEE144
    DATA &HE5CB13F5,&H66BFF207,&H7A083F9E,&H0F714B44,&HD3DFC25C,&H49B773D9,&HA61D07C8,&H8149ED9C
    DATA &H67B227A3,&H163555D6,&HAE5D23F2,&H3CFAB4B3,&H2361F824,&H8E68F904,&H3ADCDF1B,&H95463C0B
    DATA &H2600BE13,&H7A6751AD,&HCDA50FEC,&H59246869,&H62E77EEB,&H947F5059,&H64197D63,&H12CE3A15
    DATA &H80700502,&H717E575E,&HB8747239,&H5A5BF430,&H3E3E00DE,&H43760A3F,&H871F6B0F,&HDFBE3DBA
    DATA &H8D7E7171,&H03A11391,&H9E5AD35B,&H39AF56F8,&H264E45FE,&H39A2CDC6,&HB1D0E42C,&H0243EB3B
    DATA &H39795090,&H52BF7BF5,&H5A6A0DFF,&H2D8AD2F9,&HC89DF7DF,&H7DF80AEE,&HA7E2C9E5,&HB121762F
    DATA &H8CE4F6C8,&H77D26A80,&HEA53DC80,&H32D04F2A,&HA72655B8,&H80C49905,&HB373BF7D,&H59B258D9
    DATA &H2F8670B4,&HEB85C63D,&H950FAAB9,&HA97497DF,&HCA23A2D7,&H8DF72DA0,&H3814CFBC,&HA0F87345
    DATA &H73B6305E,&H61BAA0B1,&H8021E8A1,&H1E82291C,&H390408D7,&H4CBD6239,&HD601361C,&H700638F4
    DATA &H4B7DCC90,&H4D1BE76B,&H4EA170AD,&H97E540F5,&H7D475B13,&H112424C6,&H2F3DD528,&H38175042
    DATA &HF0E4EF46,&H89F09D14,&H3FDD53BE,&H592ACB0E,&HD935C3EA,&HFD27C243,&H3EB146CC,&H57E007C7
    DATA &HC4F239A0,&HCD0A80CB,&HC20863E1,&H96D8F82B,&HDE98EE73,&HFDF3936C,&HE7FD57D7,&HA674C34C
    DATA &H2CA63BEF,&H4A03DDA6,&HDE2ABB98,&H5D97255A,&H3DDC4CC6,&HAE783BB1,&H4C2A03DD,&H61C5AB0F
    DATA &H4366CC27,&HC39C2D6D,&H9A18D4FE,&HE3780D93,&H188C19FE,&HD69321FC,&H51F5F6B4,&H2F7F9CDE
    DATA &HF85DAB1D,&HA84B1CD1,&H481EADE0,&H84DBC75F,&HA8525664,&HDA990755,&H362004F3,&HF5F55BA6
    DATA &H8A531799,&HAAA3F866,&H2DA5A364,&H52ABFAFC,&HD478889A,&H90A3003E,&HE11D55A2,&H167960F9
    DATA &H463C4B55,&H88BEE096,&H8553A7B7,&HF7BBEB6D,&HBF761D9F,&HEC65CAE9,&HDD4BACCE,&HE0F3BDD7
    DATA &H8D6DBE78,&HE9992C97,&HC73463C5,&HE0FBF487,&H69630C77,&HADD47EC8,&H88CE24E0,&HD7643DB9
    DATA &HD47FCEC7,&HE2C1E05E,&H5A6DF621,&H288E688F,&HB3B1B19C,&HCD0E25D7,&H5250B443,&HD5DC24C2
    DATA &HC3863FAE,&H52BA4E64,&HB06EDB0B,&HD5C85915,&HFC5658F7,&H4B14A661,&HCA66196C,&H0338F8EB
    DATA &H63A43CFF,&HD5E9CD09,&H6D5CBFE4,&HD143922A,&HC096289C,&HA9A6F33F,&H23709062,&HF72784D3
    DATA &HDF2308E4,&HF03F1E7B,&H60486A19,&H8E013178,&HEF1FD446,&H93835659,&H5FEBA2ED,&H44EC6007
    DATA &HCE70A9A4,&HAB66A2BD,&H42B1CBDB,&H737AA35C,&H2105EC7A,&HF47AFC77,&HAD5510AD,&H720C1565
    DATA &H3F478963,&HE899257B,&HAF7A21D9,&H12EFA4AC,&H3BC9DDA4,&H282C7346,&H2EF9029A,&H6D30C5DA
    DATA &H25640954,&H8444D4A7,&H2A9B27B8,&HBA805DA7,&HA0D5E9B8,&HEC02B6CF,&HA1EE58E4,&H89160002
    DATA &H60FB49B2,&H67A456BE,&H7F2C9FEC,&H2315B943,&HCEE7FCCE,&H8BA6BB72,&HBF0B4142,&HDD0EA514
    DATA &HF2F335AE,&HAFBB84A4,&HBE5587A6,&H63F4EC06,&HFCBD1F43,&HA8C91CC3,&HBCE687A2,&H9185A526
    DATA &HD7CB8B9D,&H49DBC37D,&HA5FF1914,&HFF4BFE5B,&H92CA2D49,&H0904F44E,&HE2DD83A5,&H00185DDA
    DATA &H2012BAC0,&H686D71B5,&H30451DE1,&HF5EAAA80,&H2F9690E8,&H651AD52E,&H67AD55F9,&H5F23B2F8
    DATA &H21E8A7EC,&H515C8324,&HC7E6A447,&HDDC2389B,&H97AF5B24,&H544B95D1,&H7DF07465,&HC73460F6
    DATA &H60D59483,&HA3ABF21E,&HA548CC06,&H9C4DCC0E,&H8148BA5A,&H700E78FD,&HA405C660,&HB1B316D3
    DATA &H74A8E079,&HB234827E,&HC44A4944,&HBF27F19F,&H5F270D24,&H509C89A4,&H18C9065C,&H863634B6
    DATA &H79940130,&H351AE9B8,&HEBE15C82,&HE224B812,&H263D8180,&H1225C21E,&HEE60D47E,&HE04B39A0
    DATA &H4E139A16,&H87E88392,&H0CD4768C,&HCDEFD44F,&H9F43CB47,&H90AA395A,&HF363CB07,&HF4D48B2E
    DATA &H55DF13D4,&HFCEA3133,&HD8D629A1,&H86D98410,&HCFD37F7F,&H53DE5ADF,&H2A09A951,&H2C7C9FC4
    DATA &HE281ECFA,&H6696A8D3,&HAA78B341,&HACE20D3F,&H7EAC4F15,&H85F07EFA,&H3A14F23D,&H0F8153D1
    DATA &H3516A7F5,&HA0533060,&H9D499F39,&H3285C0BB,&H55FB6637,&HF0C0C7A6,&H0B9221D2,&H1F8D4316
    DATA &HFE732ED8,&HAB049445,&H5239665D,&H88DF26EA,&HB651B075,&H4430F3FF,&H28B4D348,&H327A1610
    DATA &H841261A8,&HC7C39013,&H442728E1,&H1A71383D,&H1E1894D6,&H194DFC05,&H5357C897,&H03C5913B
    DATA &H0D4D3649,&HAE3A2471,&H254E6819,&HAADAD1E3,&H84168C69,&HCF0579EF,&HAD79B48B,&HE6781E37
    DATA &HF205F445,&H72C44D42,&H780A2111,&HD0D69801,&H31B80AC7,&H61584C8C,&H6D62ADD0,&H7E37DA0A
    DATA &HFAAE7839,&HA4B171F4,&HD8DC4B0E,&H821D939F,&H1EAD5F5F,&H3C2A1505,&H761CD16D,&H3B778842
    DATA &HDF154A51,&H66B41559,&H2471A706,&H682BA652,&H65F5344E,&H2745D708,&H4F46A637,&HA7A3E50A
    DATA &H8C8EB297,&HFED11D01,&H63ADA3AA,&HD6BCB958,&H49AC5B49,&H4B8271B9,&HA58AACDC,&H38FAFF98
    DATA &HDB68A544,&HFE88861E,&H7B61D028,&H0012D1C3,&H4075484E,&H5BA3B3C9,&H2FE6E7FC,&H823FDD5F
    DATA &HF58FF981,&HD5D42760,&HD72B496C,&HCEACD914,&HB46B329D,&H847CE683,&HA1F2E036,&H939DE5A8
    DATA &H702607DC,&HBF48869E,&H4896F885,&H904A3FF3,&H8BF28A9E,&H32E26B8A,&H7E3116E5,&H8FB3056F
    DATA &HDD6739D4,&H1C8423DD,&H49061FAE,&H7D6508A1,&HB310E7CD,&H4A5901C5,&HF6BB3600,&H957E0D2E
    DATA &HA333C568,&HA16B1C9F,&H4CB8A3FB,&HFC7BCFDD,&H6D289BD4,&H2FD82BB7,&HF9CD1732,&HA703AA44
    DATA &H35074943,&HFEF07986,&H13F2C492,&H5711089D,&H583B8679,&HAD93F4A0,&H3B177210,&H1FE0499E
    DATA &H57488C75,&H77590C7D,&H3DD85916,&H74E0C4A0,&H23970A91,&H8D62F787,&H8139F40F,&H183E4B73
    DATA &H8E8C1550,&HDA16096E,&H06A8D947,&H2053E7EE,&H21C8B6B3,&H566EA812,&H0974953B,&HE7346299
    DATA &HEFA9390B,&H4772B9FA,&HF3C1384D,&H4326DB35,&HF1C91B65,&HE507BD28,&H2439759B,&H5773A88A
    DATA &HA729D339,&HE401AC24,&H95C8F9CF,&H1818608D,&HC9CBBDE9,&HF5CC68E3,&HC5D22D25,&H86B61C74
    DATA &HED50CAA9,&H2FFE3B94,&HFB2DA33F,&H1E19A127,&H2A8E761E,&H308D261F,&HCCB1F38E,&H25065BCF
    DATA &HA80D32EF,&HE4EF9CD1,&H10ADBDB2,&HB3EF8ECF,&HA3CFFC12,&HE6363026,&HCE1E5955,&H3D8BA79E
    DATA &H99934AE2,&H561D5E34,&HAD1D17BB,&H22F54569,&HE1CCEB21,&H9B72E924,&HB8427C1C,&H53854C37
    DATA &HC8BAFEAC,&HFE42A7B0,&H2C46ABF8,&HB86E5FB5,&H36626C02,&H6CBB5F93,&HCC35A7AA,&H6168D0FC
    DATA &H66090BC7,&H9DBFD1D8,&HE6825C6E,&HFAE593B4,&H35C75D8E,&HCA76C2E4,&HA3526881,&H62247A2E
    DATA &H16E432C4,&H565A4D31,&HEBD8A502,&H450117D7,&H186AE2AC,&HD14D4409,&HBEE2FB3A,&H23AB36EF
    DATA &H6BB3A64C,&HB8A4943B,&H4247E125,&HABF775E8,&H532089AE,&HC19ACDFF,&HCE1DC352,&HC90C5B7C
    DATA &H257312C4,&HF8B030D7,&HE68D80A6,&HADF00A0C,&H9AA5534D,&H6ED53E41,&H3445E6AB,&H37C3E1C4
    DATA &H90B2AF54,&H0900A2F2,&H0E6A428D,&H02087F76,&H4A4034A0,&H4E150103,&HF7A6552F,&H7EF3B0A1
    DATA &HEBBD86B2,&HDD9D9E34,&HABC78F91,&HE2141E13,&HE9B5AD97,&H2F48E733,&H7E4B8D49,&H2284EFE0
    DATA &H4EFA7267,&H97A3B405,&H21502C36,&HCE6892B4,&HC457E81B,&H1400C606,&H73CF2E72,&HEF52C942
    DATA &H7B768006,&H1275C18F,&HA8C3BCBB,&H588492F7,&H6B316C0A,&H56C2172E,&H27417E73,&HF5B466BB
    DATA &HF2799995,&HEF8D4B5D,&H2FAB8436,&H5510D314,&H70F87DAB,&H81A99BA9,&HE9427508,&H6EDA2067
    DATA &H4D233123,&H3F596677,&HC10BFAAA,&HCB30B7C0,&HCD714AEB,&H6D6523F1,&H51E5ED59,&HAF97FEFD
    DATA &HA896C25A,&HC5F93912,&H67CD999A,&H2C7DCB77,&H64EB56E9,&H7D3BFE1F,&HD0C96666,&HF8C60AD5
    DATA &HA93D644F,&H5B2AF3B9,&HDF846A7F,&H7ED2F024,&H586E77BE,&HE7ACB9B4,&H84774974,&H6B7C7F55
    DATA &HEBA15C36,&H51BD0001,&H8A10F000,&H49B7B6DD,&H12AAD260,&HBEB3E7DB,&HA4F1A3C9,&H2858DDA3
    DATA &HCAC6A0DB,&HB305499D,&HED3639D1,&H35ECE2C5,&HF0265D2D,&HBBA331C9,&H87FC32A2,&HA1BE537B
    DATA &HEF17F694,&HBB310D89,&HB070AAAB,&HCB1A66F5,&H5E3AA960,&H5C02BD33,&HC2F35B85,&HEEFBA7C0
    DATA &H68381500,&HB1303E9B,&H587BAA8B,&H1A6962FA,&H545A861B,&H66539661,&H872FEC0F,&HA43939A3
    DATA &H28473AE9,&H3CBAF91B,&H5864CFF6,&H3277A6AA,&H3DD97015,&H8927C4BF,&HC861FAE4,&H9F88BF66
    DATA &HCBCE8066,&H566CB2A8,&HB9FEB131,&HCEDBF82F,&HA0255272,&HB05457CA,&HC5DA6C8C,&HAFB2E5E5
    DATA &H4C01C124,&H996FED8E,&H51C852FB,&HFBDD615D,&H8A8F2A22,&H274351F7,&HE56A6326,&H834A8370
    DATA &H342385C9,&H7A592BE7,&H14D03AD7,&HAA350CC3,&H2F3FE7E3,&HBBF3BA4C,&HBB9FAACB,&HFADD9DF2
    DATA &HF1BCFC1A,&HC44785B2,&H7AA25DC1,&H89E57FC1,&H652DA589,&HF7AE32CD,&HA6A47B81,&H7BB6D1F2
    DATA &HB7D219E1,&H37F6EE66,&HCF99BC7A,&H0967D4C2,&H1E1EEF02,&H9A9F7C9D,&H8072EE9F,&H4C4C2247
    DATA &HE317D9D1,&H2289DF8E,&HC0FCD39A,&H2295AD72,&HA7F203DD,&H83FD0C75,&HA42F71CB,&HC326DBE3
    DATA &H66018D30,&H84B2EFEC,&H0692CBD3,&HDFFE3651,&H28377FCA,&H4571FA27,&H94EBE4D1,&HDB6016C1
    DATA &H97AC04E0,&H7847192D,&H04F71367,&HCA78BB2E,&HC02DFFEE,&HDF5C0B38,&H96C3B79E,&HD8E43A91
    DATA &H23C70AC5,&H9DEFE6F8,&H8532E4D9,&HDF253CE6,&H6603BCA8,&H657998A1,&H6F86BE7B,&H2A179EC8
    DATA &H55BEAF30,&H5F84B065,&H2F481599,&HA521690F,&HFAF8EEA2,&H7F302FC1,&H87CAA00E,&H00F8C98E
    DATA &H9F8094B3,&H002E61FF,&H00939939,&HA5C8E6E8,&H2153F8BB,&H9A91D682,&HFB48964A,&H1ABD6C3E
    DATA &H14ED1513,&HF3AD666E,&HCEA2E0D7,&HCD026C26,&HF09127D1,&HAE2EA7FA,&HE795535A,&H91F4BF55
    DATA &H51EC12EE,&H60D49C57,&H08D903D3,&H91A623A9,&H381CB901,&H30576E18,&HAF274000,&H1DDC6A84
    DATA &H9773D995,&H2AE21EFD,&H89BC9E15,&HA26D37ED,&HCDCFA1A3,&H78221CAC,&HEBD8BAC2,&HDC5C52E2
    DATA &H85D8451C,&H84ADCBE1,&H101383CA,&H7FA9D6C3,&H39A37FC2,&H7D3A2476,&HE1D25077,&H0570B28D
    DATA &HEB79A5FC,&H3C823C12,&H70C97029,&H77B5800B,&H4A43346D,&H2F307004,&HA4F97C18,&H5F84AA4E
    DATA &HC1DC75A7,&H49AA42D8,&H0E0D3D3A,&H53448A22,&HECBCF8BC,&H97F53811,&H9FC697B7,&H48494AA1
    DATA &H54D69018,&H5B4ED7C8,&H9E3CEB8C,&HA3B1B030,&HCD65FEFD,&HFB7FD5F1,&HF2EBBE27,&H551ADE3A
    DATA &HB81D68BA,&HDABB61C4,&H7D72332B,&H05EF8547,&H990F2F89,&H2158AD99,&HB532B718,&HC4ACADA9
    DATA &HC685B64F,&H9416F6BD,&HD78937DB,&HD05C61AA,&H355E5E17,&H7FCE2F62,&HB6BFAD31,&H862E1B83
    DATA &H4B6C0BA4,&H868800FC,&H1A851586,&H7D833694,&H921D8096,&H7BC84667,&H89CD0424,&HBAEE3525
    DATA &H98DC6A04,&HDCB5F77C,&HBA56B20F,&HB3B45617,&HE33D7F74,&HE916B024,&HA91E9706,&H768B05C7
    DATA &HFA92E3FA,&HE903DFE3,&H8A672A00,&HEF965AC2,&H45DC293B,&HE1C2249C,&H5FF1AF40,&H666A49B2
    DATA &H1C0D8D8A,&HB0158308,&H043BEDDC,&H81162EF7,&H192C7EF9,&H5B189FC5,&HF8A94FD3,&H7FB37122
    DATA &H46D70204,&H203D5345,&H9F395E3F,&HDD75152D,&HB7F68F98,&HAD0D21E1,&H20C23761,&H17970D47
    DATA &HF591F83A,&H441CDD75,&HBD98AA66,&H7B439AA1,&H03BE36F3,&H258827C9,&HC3F19A73,&H5F14BFBE
    DATA &H6FEB6CAE,&H23EC1562,&HC0098201,&H0815612F,&HE55C0C38,&HD863829B,&H239A3AD2,&HCDEDB641
    DATA &H58A1A606,&H470E00A0,&H2D4C17B2,&H965B2B10,&H320EC739,&HE306860F,&HEE41A717,&H85DE4186
    DATA &H27A84AD4,&HC9643AC1,&H151E8271,&H0822D42F,&H50D578A4,&HA08CF1B6,&H0690EB8C,&HAB782DAE
    DATA &H6E2980D7,&HB03B200E,&HEA012B02,&HCDC442D4,&H909C0A4C,&H3E0E1D65,&H1A6B805A,&H240A39A2
    DATA &H101BEDBC,&H66EFDE9B,&H0A1731F8,&HD7B2E5BC,&H833BACB5,&H1EE754D1,&H9C37C3AA,&H5FD2EBF4
    DATA &HE45B14F9,&H17564078,&H9401FD5E,&H89E085CF,&H24403F3E,&H6D47275E,&H63836892,&HCDF0AF81
    DATA &H38259667,&H4C5E2819,&H48AF3C30,&HFE7124FB,&H90A156A1,&HC4434ED2,&H84DB4AC6,&H8D448100
    DATA &H246F8DFA,&H3B223F69,&H946DE9B7,&H506E6EEE,&H01DE2582,&H44B7D88D,&H87A63411,&H6DE759D8
    DATA &H3E1EBC4F,&HD89CFEBE,&HAC001338,&H346F98CB,&H9CFF9B93,&HF62723AD,&H0654CBF9,&H2B6F68A0
    DATA &H24A63A6B,&HFD7F86ED,&H9BE22E7C,&HDAAEE671,&H2E9787F6,&HC077DAFC,&H0F763219,&H4C7EDD84
    DATA &HE68DD43D,&HBAF49138,&H7A7240F5,&HC801786B,&H0532EEA6,&H112A4888,&HA721AD09,&HDCD5715D
    DATA &H13A70576,&HF86A830A,&H658624C6,&H044E0D0F,&H0ACC8756,&HB2B54DE2,&H89E9191D,&HEC5371D8
    DATA &HE5C6BDF3,&H6B9DA41A,&HC8D42C98,&H3E8C4255,&H4C473E94,&HD76BD261,&H98606146,&HAA27D6FE
    DATA &H8C9654CD,&HFD1BB8C2,&H70124016,&HB834097A,&H07F48B31,&HF70A1E6A,&H3F73C705,&H5FA20B25
    DATA &HE0D89858,&HDAFBE277,&HF1B85368,&HF1D9A268,&H173726BD,&H17F38ED0,&H6A912A78,&HDE9027F0
    DATA &HBAEE8F02,&HDBD58954,&H9CA8540E,&H7885C37F,&HA3C575FD,&H207E8BEE,&H68B03C23,&H500134AA
    DATA &HE2E085D1,&H1E171643,&H19D59406,&HE8E149CD,&H4AA1EC5B,&H4480C54B,&HFEDECAB1,&HBCF7276C
    DATA &H560EE98D,&HD0131374,&H807D0077,&HC1CA6C1F,&HD8004F4C,&H57BEDB82,&HDAC80270,&HA9CCAEF2
    DATA &HF707A2F2,&H935F07FA,&H3CF6E338,&H63C1937A,&H8E47FB14,&H877A1395,&H4F0B7320,&HEA0DD689
    DATA &H0544C8CE,&H7BBC1A6D,&HEC912657,&H39374513,&H594C639A,&H7E0A2216,&H8DBE6372,&HD25AA7E9
    DATA &H3435CEA1,&H2DD757EE,&HE026620F,&H9479F0C0,&H040A6995,&HA6DCF1C0,&HF07215D4,&HD5F77676
    DATA &H0E37225D,&H45D566FD,&HE7622266,&H3AA9E13B,&H2411D8C1,&H9C0D0372,&HCFDA9404,&HE470E613
    DATA &H15C568BF,&HE537DED0,&H7B17F666,&HA65B1390,&H5DFD5BA4,&H8C0E26F7,&H8FD24A49,&H89418621
    DATA &HA8CD3CD4,&H8592AD1F,&HC2C74CDA,&H9A1A241C,&HC7152CEB,&H44F0228C,&HFB492F3A,&H87C40018
    DATA &HB755C1F7,&H41C69258,&H98806309,&HE9B27EF2,&H661FD6C8,&HCA9271EE,&H888A1912,&H877FC224
    DATA &HCB6D9A4F,&H7C4B5D4B,&H934FA3E7,&H555CFDDA,&H0BFA79BF,&H63D15281,&HC73425C2,&H9BD79491
    DATA &H5D1DC50E,&H4DF71797,&HD41B42FD,&HEA31FD5F,&H4D1933DD,&H81C7579D,&H307BCDD9,&H1905F37A
    DATA &H0511955F,&H745AC425,&H90D55462,&HA499697E,&H249B0A9F,&H54B8521D,&HDD5AA736,&H1A739514
    DATA &H163203A6,&HB210AFE0,&H851102BF,&HD06F2261,&HBA500C1F,&H4A85A9E1,&HEA9D3E2F,&H5FF2FCBF
    DATA &H5801CB7E,&H75F224E7,&HF38D1CFD,&H0D48BB4A,&H6DAE2E73,&H426027CB,&H6A9D61F7,&HA0EE5265
    DATA &H2437061F,&H4C7E8245,&H8C5BEEF9,&H57F8BD58,&H418721CC,&H524965BA,&H2022F0C3,&HD571939D
    DATA &H03987BBF,&H5EE2791F,&H028F5FA2,&H6DAE42B7,&H034F7198,&H5E20BC83,&HF8AB8685,&HBFCE942A
    DATA &HBF26FB67,&H5F7A4991,&H85675473,&H037FCC45,&H5914AE45,&HA872593F,&H8F4BE90F,&H9926AAEE
    DATA &HDFF55C6A,&H1174016C,&H474AACF7,&HBCF37F1B,&H6E9379EA,&H7A3FE1C2,&H73E2B3C0,&H84958297
    DATA &HF84F9F34,&HE255F25F,&HED75E3CF,&HB6756AFB,&HC73F540E,&H34761556,&HF839D9EE,&H63468C26
    DATA &H64BC1076,&HB930D3EB,&HA4643FF1,&HCA4743ED,&H0572C850,&HDBF369DF,&HE23C83D6,&HDF1E4197
    DATA &H2BDDBDAC,&HD58C9AB2,&H5C4688FB,&H08B5BF35,&H6815FBD2,&HF8A473DE,&HEAA1A961,&HF4C93F5A
    DATA &HA574E261,&H3C793320,&HE5F69061,&H5CFE7C57,&HEF74A20F,&HB6088402,&HDD2DD35B,&H9B2FD38A
    DATA &H37835FB5,&HC3E95C91,&H88567FA1,&H9CD0D2D3,&HB5BE8172,&H9D6B8E29,&H9CBD7698,&HAA3CC42B
    DATA &H846FD447,&HC1E2A165,&H33EE45F9,&H832B56C8,&H5F1781DA,&H979DE99E,&H27F5B59D,&H65A71728
    DATA &HCF00B130,&H060E6291,&HE03588AF,&H3A1CB0B2,&HD0CE5644,&H04AC75DC,&HFCCE5481,&H26620EFC
    DATA &HD6B3B82E,&HF907E1BE,&H5B989294,&H8E6824B5,&H6A0B091C,&H0A086303,&H3187E479,&HCB433E2B
    DATA &H3655BAF1,&H23E62D2D,&H8A8A2C0F,&H743CFF99,&HEA36E171,&HA2D82B11,&H2A6F8126,&HCFEB2421
    DATA &H1AA99CC9,&H5F2A0032,&H758AA014,&H12FBDEF0,&HF5A00262,&H74E6D511,&H79064315,&H86EB446A
    DATA &H6752E62C,&H26C4A1FD,&HAD9872EF,&H0B0662D5,&H8C7341AD,&HCC70E1A0,&HDF1D3447,&H81FE9FE3
    DATA &HB2B86DE2,&HCB1A76FF,&HEB1B27C5,&H305485F8,&H1A569739,&H8007DAB9,&H98EA4C39,&HD571BBE0
    DATA &HC7C2539D,&HB0CA97DB,&H2AA36930,&HFA5B749E,&HA48C7CC4,&HE6BEFEE0,&H4F14E4C9,&HE1F151FD
    DATA &H8DCF893F,&H4CB62A2A,&H4AF710EE,&H5D927690,&H43FDBD26,&H8F35BC63,&H8E83BCE6,&H68A1F25C
    DATA &H4C78EB54,&HA2149210,&HB605BEDD,&H8748E335,&H804D2B73,&H7212E9DA,&H5D33ED23,&H544DD09C
    DATA &H21786ACE,&H402EE59B,&HA0EBE053,&H136548CF,&HD25A7A37,&H89EE346B,&HFFBBA7AB,&H10DFF8B7
    DATA &HB3B9C276,&HA77A67EF,&H96F87929,&HF488D9D1,&HEC949950,&H7467E575,&H114A0802,&HBC942734
    DATA &HDCF71BB1,&H3F7BE823,&H377F5F33,&H6DBED3A5,&H5425E3E3,&H6F42163B,&H3484CB68,&H4D28BAFC
    DATA &H032741D2,&H11B9FAD8,&H467D7A9F,&HB05FB64E,&HB1EE898F,&H3ECAF0CB,&H7B056138,&H439763D6
    DATA &H8A2D82D9,&H502A0FCA,&HF8EB351A,&H499FDB16,&H72907B5E,&HB63CDA19,&H36A37A49,&H37A79477
    DATA &HDD5FFCAB,&H3BA33AF6,&H1C6F0B17,&H858F3715,&HEB345650,&HAC4315B3,&H2E48BD6C,&HB05897DC
    DATA &HC81762F3,&H1105C3CD,&HEE09EE74,&HBF3AC77D,&H7E6FB93F,&H29FE2A7D,&H359C3495,&H9F578791
    DATA &HCFFA5745,&H390F8592,&H87862538,&H4DBF8C87,&HE5B17E65,&HB7F58530,&H7FD52AAB,&HB86F4ACA
    DATA &H7A84E8ED,&H3FECA8BC,&HC97E6BDD,&H54102E77,&HBA37E647,&HA5A9658A,&H7F2DE090,&HB56FEACF
    DATA &HD5BC73FD,&HADB39D8C,&H8C47B164,&HC81F999C,&H2E88F35C,&H85780123,&HCF7A1FD9,&H82F601A4
    DATA &H503CC2E8,&HB6C81814,&H0E5ABF58,&HB9EC597A,&H2E623F18,&H9E5F54C0,&HF64E5C7D,&H8B4682F8
    DATA &H09506219,&H1C71C592,&HA27FFB64,&H6F28DF39,&H539DD25F,&H8E8DD477,&H415ABC99,&H4E315A4E
    DATA &H6FF31DCC,&HECE9BE41,&H799556CD,&H659F1179,&HF4691EBD,&H54489FF4,&HEAC4174D,&H51A9D31F
    DATA &H5BACA0A2,&H3036082A,&HECB16167,&H02F6F9D6,&HCDCCA162,&HC02CFE33,&H88F95A6F,&H1549E1C1
    DATA &H80092204,&HE7DB6C64,&HEA0C8DB5,&H7E6ACF47,&H3539A2FA,&HABED3664,&HC4F92F10,&HA604B672
    DATA &HE560CD9C,&H4D90FED4,&HED26F945,&H81DC4E66,&H6AB6C955,&H942BC9F8,&H97759015,&HF0A5A27D
    DATA &H65F4D6CF,&H98C73E27,&HB64991E9,&H719F436C,&HEE072FE9,&HD9B88FE5,&HC92682D4,&H3366F1C3
    DATA &H6391F054,&H6056CB88,&H16060246,&H1B5E1B3E,&H93EF8CD9,&H3476422E,&HCFFC8DA7,&H23738233
    DATA &H8B32BAD5,&H3D895B76,&H768E31AB,&HDA12E25F,&H7EFECC80,&HF92E8B2A,&HFC9E7B2F,&H3E104FF3
    DATA &HB5485238,&H606889FA,&H5D24F40E,&HCB829EC6,&HBDE4503B,&H714CB32A,&H03F92D8E,&H8F2BFDAD
    DATA &HB704580F,&H203142F1,&H593F70B2,&H9EEA6C0C,&H8FBF380D,&H53108930,&H15A1576C,&H1943D39A
    DATA &HDE7EBB9E,&HBC2351D6,&H2B967C31,&H90F364CA,&H71A72908,&HE65DB2BA,&H9D3067D9,&HE8401DB7
    DATA &HA07218A6,&H7353E4CA,&H481F9788,&HC967F959,&H2FB5F2F5,&H605AA1A3,&H4D4A299C,&H37613AD4
    DATA &HECAE48F6,&H5B8A7B2B,&H7C5C5811,&HFA2B80C6,&HA828957D,&HC2445355,&H41253A42,&H41922C46
    DATA &HD96FA6F4,&HF50EFE43,&H0C58C303,&HC0795F42,&H36FA1300,&H5A630EFF,&HD0FD619D,&H5023A792
    DATA &HA41A135A,&H44577B8F,&H885461E2,&HD0B6008E,&HA6D3265F,&H82E6996B,&H1791B66B,&H0A000956
    DATA &H77CF67EF,&H28DA7482,&HA0F9334E,&H68D84759,&HD6C63A41,&H9F922564,&H676490BC,&HADA49FE4
    DATA &H96F29E62,&H9A39B59B,&H6E777233,&HD52A986D,&HC1E32210,&H626BF426,&H5789593A,&HD5C67A30
    DATA &HF8306EBA,&H1B9448B5,&H6EB8D492,&H2BC811B2,&HB68DA85A,&HE8BC0FF4,&HF498785D,&H7AAF555E
    DATA &H36D078A1,&HE8A4C963,&HB51F0961,&HB69C8A11,&HF4225784,&HAF6B3B0D,&H214E92F6,&HAD5DB369
    DATA &H0AF68300,&H176BEBB7,&HF661764F,&H1BFE9BB3,&H1F28B6D5,&HE2C6E1E8,&HC9861C28,&HC2CBE9AD
    DATA &HF4BC254A,&H7F412B48,&H9D2C83E6,&H649B4EB8,&H5BCDA97C,&H29DF555A,&HED9AEB76,&HA511082B
    DATA &H481CB8CC,&H005E4857,&H729D11A1,&HFF5D6706,&H6059ABF3,&H13A57695,&H1251B7ED,&HD2ACB064
    DATA &HE9EDA0F8,&HEBC4D754,&HAEC3EF7F,&H27614D28,&H8E6876CB,&H1F58490B,&H3E5C4A1B,&H35350259
    DATA &H34C60294,&H06DB3DFE,&HBC121F06,&HA63D2EE8,&H8D1BE034,&HF75F04BC,&HFF4CFA51,&H22FD8FF6
    DATA &H15F5C234,&HCED21153,&HB6BA9102,&HFBB4DFB7,&H2CF93CB0,&H8ED7F8FE,&H3FE3D788,&H8888CF9E
    DATA &HFF5DE716,&H70F09818,&H3360A6C8,&H8825BD32,&HD4F01F33,&HBC97AC5A,&H9085F3E9,&H434C1B85
    DATA &HF46B7AFA,&H94FB501A,&H0E3FFBAC,&HA0656E23,&H27618C84,&H180A0C10,&HDA589D22,&HEC8CC7EF
    DATA &HE489EBA1,&H35E1913D,&H9F2566EB,&HE603D361,&H23B8B894,&HEB6053EE,&H015B962B,&HC36C484E
    DATA &H7478EC84,&H19726B51,&H86D2C0C0,&H86179C88,&HD7EB48CA,&H39E722E9,&H0B502DCA,&H48127340
    DATA &H903D5195,&H8AB7AEB1,&H7F26A336,&H825808CC,&HBA054803,&HF2B75E2E,&HD1281451,&HAE2A3D11
    DATA &HD253EB7B,&HE8FDE44F,&HEB32E623,&H193AE573,&H113F1969,&H2347B885,&HBF6B5D75,&HB1E9A969
    DATA &H5AB3619F,&H7EA5CE27,&H84EAE0EF,&HF4E66370,&HABF204B5,&H1B146587,&HA40690E1,&HBD0FAC6F
    DATA &H40342950,&H72C9F273,&H942F2FDB,&H7F3931B8,&HD20BF7F9,&H0AF7B3B7,&H6D8F190A,&HAC57D589
    DATA &H9B1569B6,&HFE1360EA,&H1A742B10,&H5A6956DF,&HE0DDEF58,&H58249474,&HCE796E95,&H10458F28
    DATA &HAD4D9044,&H38B81D6E,&H9B393B5E,&HBF2F1C26,&HF154D220,&HB950DC64,&H45908DEB,&H47C898A2
    DATA &HEA55EE56,&H0C4E7257,&H4E680DEC,&H5AD8C095,&H366A5107,&HD2BC8B04,&H83BA5C09,&HB6E8F32B
    DATA &H8CCB945F,&H7ED664D4,&H3C107E71,&H737931A6,&H9A3C87AD,&H7A6F2000,&H00520EE0,&HC7600529
    DATA &H5FBB9253,&HB9B69B10,&HAEAEFD1B,&HE4098335,&H3566F2CA,&HA124AAD1,&H053AEFAC,&H0DE6BE9F
    DATA &H92EB36A1,&HE7EF14E1,&H478C9376,&H2CC89473,&H1B41249D,&H973B5637,&H0CDB9BF8,&H2B35B3D9
    DATA &H5948D698,&H29B68B29,&H5B573BA2,&H156029D5,&H030572CE,&H9C0120A7,&HDB08BADD,&HD2FB0F78
    DATA &H2EB4B23B,&H33FC41AD,&H22DF2227,&H025E8B1C,&H19C30FDF,&H3D48AC93,&H903A6D5D,&HD53F5865
    DATA &H399C516E,&H630E3729,&HC49307B1,&H1DCA5875,&H9923D1CD,&H6A287201,&H46EF3AF9,&H2F60EEEB
    DATA &H107AD2E6,&HC2C480C0,&HB0B4D0F8,&H1A77CA8F,&H27021EC7,&H65420F6C,&HD45B8C5E,&H2484AA23
    DATA &H06A71761,&HE074C66E,&H473A6E88,&H098E561D,&H2C35D950,&H19A537F7,&H5F4AFA4F,&H3D5CF9FF
    DATA &HE4A93AF0,&H4A71C653,&H7D70CD2A,&H7C23FDF6,&H3950BF89,&HC49AC734,&HCA1527E2,&HC4B1A830
    DATA &HEAEF88F5,&H53805AFC,&H58EE5625,&HD0E79EC0,&HE90EA057,&HFB918E1F,&H7B6AACC5,&H540839E9
    DATA &H7656D6BB,&HB3493A43,&H9C65EB86,&H78A92DE8,&H707BDC0A,&HA93FBFCD,&H9F629BCB,&HC10CC9AD
    DATA &H8788FDFF,&H61E5EBBC,&HDFE388C1,&H90F7297B,&H6292C1AF,&H501086C1,&H3E734713,&HC18C2290
    DATA &H5D7CA0B9,&H800647CB,&H12EFB0DC,&H8904DD4D,&HA248F59D,&H7741D9A7,&H2DEDF695,&H0E21EEB1
    DATA &H6EFDA439,&H55A816F3,&H7ED0D716,&H23B11B72,&HC27C1DD2,&H6788416B,&H52D8E325,&HC3FB2AF0
    DATA &HCD13D58F,&HBA2A705E,&H70D73CB7,&H152BE4FB,&H489DEC0F,&HF1D4B73D,&H9636E5DB,&H34152F3E
    DATA &HFE2C8227,&H5DA42B69,&H5BC526BE,&H47AD99EA,&H05B679E4,&H98242635,&H003F3714,&H2B6B5B67
    DATA &H22F72481,&H80332A92,&H7FD697B7,&H67823DE8,&H68F245B6,&H6F22A3B0,&HEB91F2E0,&H78977258
    DATA &H673AC737,&HE4FA61E6,&H01FA7BC8,&H95597FAF,&HBC8CFB77,&H243406DA,&H1C99DF92,&H8F24CA7C
    DATA &HA9FFBACF,&H97C6EA99,&H76F5B490,&H2141A91C,&HFB12D59A,&H1C1A949D,&HE1CE1612,&HC248AEEC
    DATA &H7F41559E,&H53D7D9F3,&H2A34EDD8,&H7F938D3C,&H66376A2E,&HD6DD19A7,&HB4DAAAB1,&HE2E2C48D
    DATA &H7E3D5B97,&H7D7858D4,&H7F642D90,&H0EE8FDF3,&HB5EAFBDB,&H6B4EB1F4,&H4CF8E2F9,&H6D77C361
    DATA &H94AD162C,&H791B4F9A,&HCD10B2D0,&HB9F81329,&H76142E36,&HE51313AD,&HFCAD761E,&HFEE792BB
    DATA &H617E274F,&HB5B9E0C8,&H9E0D27CF,&HDA56CF41,&H2E5E6A04,&H4D3FF340,&H6D093191,&HC622A2EE
    DATA &H1B0490C9,&H459BD677,&H53F878BD,&H0EA471B0,&HC652A996,&H5AEF168D,&H3D1A4BFF,&H1C6C5328
    DATA &H1D37A2EA,&HBB5ADE7B,&H1C2CABE5,&H13A37CCF,&H514F69A1,&HC8503D42,&H399E43B4,&H6CEBF438
    DATA &HCAFD11FE,&H9D685FFA,&H1C2C70F9,&H3AB79DF4,&H026D9F49,&HA124269D,&HF9044035,&H79C711D7
    DATA &H49810AC4,&HC960383B,&H3A48FD4A,&H545F4606,&H9D5DF253,&H91873398,&H702C6B1B,&H75562443
    DATA &HD8D7B523,&H2C127637,&H8ED97876,&H6EF0ACD4,&H502648FA,&H143E3ED6,&HF9236A89,&H8D73EE99
    DATA &H8A2A4D38,&HC759B4B7,&H5EBF5B72,&HC30B9EB9,&HA2009372,&HAE30FE41,&H909C1F19,&H69212E12
    DATA &HB9CB6B5A,&HC76F3290,&H0E80A9A6,&H8CC4B984,&HAF9A48DC,&HA4F1FA7B,&H4B743619,&HF4F93A45
    DATA &H42CD61B7,&HA8196BF8,&HC298799A,&HF1459EE1,&HDD64F62B,&H3DE73430,&H1614B199,&H8EBB164A
    DATA &H46607D62,&H0782359B,&H394702AE,&H76ADD773,&HD737873E,&H5A738648,&HAE7FEC68,&HD4352F9C
    DATA &H3C47DD84,&H2F0DE7DA,&HF6778028,&HAAD3E4F1,&H4BD9D934,&HEDE8C035,&HD3C11C3E,&H2C5553A7
    DATA &H6B4F5A73,&HBE483D48,&H9CEB29EE,&H87D69316,&HC1BE7061,&H23C56C0C,&HBBE9BB23,&H3F70D004
    DATA &H22EF3CBD,&HB3EF4BE5,&HFCB163F2,&H2BA8A34A,&H91775720,&HAE9AF42B,&H045C1A38,&H3354BA5F
    DATA &H62FBE19D,&H7E2F2738,&H5B55157C,&HFFADF72E,&H3F0B6A38,&H33EFD489,&H5B284E47,&H1B24A26E
    DATA &H954CE107,&H0A6ABBCC,&HD6F3477B,&HF2360964,&HE2011E98,&H05F257E0,&H233FE32B,&H2B6EB898
    DATA &H39D4DF9F,&H0D68C872,&H5ED15464,&H4E302BDA,&H0AA63479,&H0CCE4CAA,&HEC540811,&HA5FF7F0C
    DATA &HCD3D4257,&H756D46C1,&H47E27176,&H6DA4DE2E,&HFDE5534D,&HAE472138,&H09BC237C,&H0573241E
    DATA &HA11E3651,&H66B26B81,&HE4B5A739,&H5DDBD4F0,&H06BFBAFB,&H9C5A0CAC,&H27B50D97,&HA8CFEF54
    DATA &H8FDDB37C,&H68A561AA,&H6A65204E,&H27E430E3,&H86F1FDA1,&HEEB10C2C,&H85C43153,&H767AB572
    DATA &HB86E417A,&H7B7694F5,&H00985B53,&H0707427E,&H5CDC61A3,&HC42ACEAC,&H80F51B96,&H56E37133
    DATA &H4E287648,&HF155EEFF,&H9A70D5CA,&H88E8B689,&HE4C8D209,&H9C1B4730,&HAE059B70,&H056A9B91
    DATA &HF9B2B7C0,&H1F772861,&HE79B8B7C,&H90824813,&H93690DF8,&H2182F1AF,&H9A1E2464,&HA5828915
    DATA &HC8B87A37,&H2F5355CF,&HCA6035D2,&HBD3178CC,&HE78D6AE3,&H0941ABC1,&HAE8CA5CB,&HDF70EE07
    DATA &H442E2442,&HD42A09A4,&H41E41B7D,&H8598B45F,&HC250C1F2,&HB3D4E1A3,&H52B55DE2,&HA84B8425
    DATA &H2CE6A7C8,&H2852046C,&H540E5261,&H9A12B101,&HC2BA4C93,&HE9B10AB8,&H9905FE98,&H5C163073
    DATA &HE3FBF650,&H12827112,&H4C3DEA8C,&HC70CDBAE,&H108F2C32,&H6CFD9CBA,&H1F002072,&H31205C76
    DATA &H48C25941,&HFBB1C164,&H98F91183,&H4AD0ECBC,&HE8149764,&H090B8AE3,&HC10185AD,&HD270E8E8
    DATA &HA2A8043B,&H10EADBF0,&H962E2FF0,&HEF92D62E,&HCD11D4F2,&H35ED2029,&HF5194025,&H07F139D6
    DATA &H47D775E3,&HFECA2F0F,&H01E1927D,&H7A16583F,&HBACC7658,&H7F227E34,&H23F5FB91,&H19B7E8D8
    DATA &H246933A7,&H926A4297,&H22442D7D,&H93422FE9,&HBB97B384,&HDFEBE0E1,&H9599810C,&HF0D8380E
    DATA &H50C4895C,&H0D0BC127,&H28094E11,&H39FD7F34,&H53C8929A,&HED742828,&HDAABDD3F,&HECF28975
    DATA &H7E34E46D,&H4B563BFC,&H244718E0,&H5933F6F9,&HDBAFFC55,&HC652AB10,&H86379F0A,&H794F6DD8
    DATA &HE5A7E670,&HD49C1DA2,&H260EC95D,&H734667DF,&H273428E9,&H209FBA9D,&HF9BC443A,&HD5E947BE
    DATA &HFEF88AD6,&HFD31FD80,&H4DF3382E,&HF2BBB279,&H24AD2A3C,&H2D6E23CA,&H24A0C878,&HDD3FF8D7
    DATA &HEB58C92B,&HA10626A0,&H9BDCCD10,&H5A9D9FEE,&HFBED83E0,&H762B072E,&HCD5AC935,&HCDD3CEA7
    DATA &HD995D751,&H2309D8F9,&H8143E126,&H22A7A5C5,&HF8C478EB,&H1F097C27,&HC81E18E7,&H3EC61876
    DATA &HD758CFAE,&H99F03AEB,&H442D39BB,&H44B9625E,&HB8CB9A3C,&H7692EF79,&H133B3D9E,&HE9CD1B7A
    DATA &H6C5BCC13,&HC0F74AA5,&H16662E10,&H7C4AEE53,&HA9DF4C4A,&HFD8BF914,&H1E343627,&H3B5AC293
    DATA &H7CA23A58,&H748DE4F9,&H6C6B59B6,&H436364AB,&H2455478D,&H7799C09D,&HAB3916D1,&H447E04B2
    DATA &H3BC1B3BE,&H6EB064B0,&H60E073B9,&H2AFCBDA3,&HCEE1FBCE,&H5839469B,&HF24B265E,&H231DA2BC
    DATA &H020B418E,&HFCA531CD,&HE606426E,&H6CC99820,&H9E520E72,&HB309E956,&H31A35297,&HA21BA2B6
    DATA &H520B9225,&H41E0FD5B,&HC749401C,&HB31EAEA4,&H25F6E181,&HB7AAC5A7,&HDBDDD9CA,&H43B8E1BA
    DATA &H977F2DA8,&H13CC93A1,&HEF850A48,&H8E3C37C3,&H5E9F256D,&H076A0CD4,&H9BAD3B3E,&H18D0F1C6
    DATA &H14907B59,&H59114AA9,&HF3B9C37B,&H9CED92EB,&H226EA83B,&H5DD6C602,&H20358164,&H5EE976F7
    DATA &H26FD5933,&HAE13C04A,&H89224B45,&HBEE8DE94,&H96543152,&HB45AF604,&H06DE118F,&H7A2411BE
    DATA &HBDD34F36,&HD06313DF,&H7DCB895B,&H6134CC4F,&HA7C021C1,&H3D1D60E2,&HCA9BFAEA,&HD34E5ADC
    DATA &H27FCF6B5,&HFEBB8FC1,&HDE1DCF85,&H7345DD34,&H8DC548BC,&HF13F21C7,&HA4752563,&HFEBF6FB8
    DATA &HEA71EEEA,&HF5DB98AB,&HDC6F6A53,&HC10B150E,&H047B0470,&H1FFCF3CB,&H4B4827DB,&H1E9F2B12
    DATA &HF5EBE8CF,&H9DF46ABD,&H63357ADA,&H44AA8A6B,&HDD0AA135,&H6D9459C0,&H3F5E9518,&H428D87C2
    DATA &HB1A81B7B,&HD33BB2A4,&H23822610,&HF149E9F1,&HE6879064,&H0D989244,&HFDA275A2,&H3636AD9E
    DATA &H8F930436,&H5E583CB3,&H5F26B2DA,&HAB75F220,&H42B0B24E,&H6D309731,&H1AA9327E,&H67F5E545
    DATA &HEA305D79,&HDF22461A,&H1B21DBF3,&HF8BD8273,&HEFCB90B7,&H2AD0BCB9,&HBB38D2AE,&H675FE37B
    DATA &H3ED309D5,&HF7AFDF84,&HC29E7A5A,&HAE9C99DF,&H73AF5EB6,&HF1D1D82B,&H47DA7F3F,&HB8342E09
    DATA &H1E2F56B1,&H709AE7AA,&H53A6E715,&H37332B34,&H51C83ED5,&H7FB5B62F,&H6ECC3323,&H276052D8
    DATA &H18E22233,&HDBD3E074,&HE1FCE799,&H978C8A92,&H254C53D8,&HA958DA6C,&HBB95BA0D,&H1EA74058
    DATA &HFAFCCED6,&H6C960BAF,&HABCCADAE,&H4FBBE723,&HC8D6B53A,&HF67F9808,&HEC74A50C,&H44E8DD99
    DATA &H71B5CBC1,&H4C50B4D1,&H7A77BBE3,&HE060C7B6,&HB81BE0BE,&HE3583F0E,&H6558B60C,&H87B35B5D
    DATA &H4B599840,&HB9D2B245,&HD78A13FE,&H39B070AF,&H9A0529B6,&H92FD9E5B,&H2F66EAD3,&H27A5A7BC
    DATA &HA241CB9F,&H0EE0F29B,&H3101290E,&HEDC8762E,&H1D041257,&HAE149403,&H86E9DEAF,&HD4DD7526
    DATA &H77360A53,&H9D6B8BA1,&HFF46C518,&HDA257A5C,&H3A1BB082,&HA62FD792,&HC49BF5AC,&HC4910878
    DATA &H852F60FB,&HAE39A977,&H17ABD5E6,&HFDD475B0,&HD7A708FD,&H07DBC06E,&HE646060F,&H3A943E84
    DATA &H65A75E15,&H0FF26137,&H9E3B6DF2,&H509F1ECF,&H2E0ABE1B,&HB99E0BE5,&H691F88C5,&HEF5EB2FA
    DATA &H1D2F430F,&H2242A39A,&HA1EBED7E,&H6D387541,&H95B8E25B,&H86A35FA2,&H0778CDBF,&H1ACB1ABA
    DATA &H26B8D152,&HB2E527D9,&H5B7C9908,&H7BF5967A,&HDD43F549,&HE4001491,&HC8CF16C7,&H2F1106D9
    DATA &H7822562E,&H61C189A9,&H08986C11,&H97723217,&HE4BFA0DD,&H6DD85697,&HF0CB814C,&HDE0C1582
    DATA &H6EAB7FB6,&H771ACCD2,&H29A9F66F,&H37E0C474,&H56355DA4,&H76B9E944,&H9FD06286,&H8225BB8E
    DATA &HABFB273D,&HA8EFC1AE,&HC6F46A7E,&H4E557CA3,&HEEEF2684,&H0C1A2457,&H47A84DFD,&HF407D3D8
    DATA &HBBC8C458,&H4747F9E2,&H49284373,&H9CCDD5E5,&HA0647103,&H4114E6C3,&H5B4CC2BB,&H08ED57B9
    DATA &H4855C7AB,&HC0CB0C73,&HEDD8FCB7,&H378722EB,&H62244F73,&HBE90C3A3,&HCAC97B41,&H159F8973
    DATA &HA5451BDA,&HF7BBCFFD,&H759FDD5D,&H061A4981,&HE408AA18,&HB0660443,&H33CE857F,&H0B666FBA
    DATA &HED6B88E1,&H4FA535CC,&HEE4FAD98,&HAC3EDB3C,&H47BABC14,&H9A9489B5,&H727EBB5B,&H447047FB
    DATA &H2CCED2CB,&HFA80132C,&H371CA876,&H69C45024,&HBCCDF7EB,&HBFE92458,&HD8C80ED1,&H0420BDB0
    DATA &HBB0C13D2,&H86973CF2,&HFA34812A,&HAC7E17C7,&H1818A1D2,&H3911511A,&H0F3364B6,&HB1BD3F1C
    DATA &H2E724852,&HB1E4FAC5,&HE4CAB4E9,&H0DE469B8,&HBBBE18FA,&H67F231EE,&H7BDD34D4,&HE7F8163F
    DATA &H52B787AC,&H646CA2B3,&HB6166867,&HA4FCA862,&HFF335BE2,&H739EBF87,&H0CD87D37,&HA9C75572
    DATA &H0628437D,&H2D895FEA,&HF0E3CBED,&HA6996F04,&H27262F9A,&H2E720993,&H5959E2DF,&H27475C0E
    DATA &H70B9DE85,&HF97D95B2,&HA19C9AD4,&H1DCF11AA,&HDA166570,&HC42B5E51,&HB27A6D1D,&HE1FA5099
    DATA &HD3D823BC,&H549C862A,&H88D3C3AF,&HDA9EE480,&H2ADFE8E1,&H0113D32E,&H71DD3BA6,&H346F55D9
    DATA &H80967C6F,&H60B8DAEE,&HFC24198C,&HB5597A35,&H185B8DD0,&HFFFE1A91,&HCA152FAB,&HA4B98CF1
    DATA &HCE44905A,&H9119E77E,&HEC9164DB,&H342E9414,&H29AEA3BA,&H13C3C1D3,&HBF5F6C9F,&H322B1D4C
    DATA &HF64DE693,&H2EC997A8,&H780F9B90,&HA422A831,&H893B7554,&HEBF222C1,&H2C8B24FB,&H1BDE1A47
    DATA &HB498FA7F,&HB9A0F88A,&HA5F9020B,&H0B444142,&H66733BA9,&H33D4851E,&H62D3D43B,&H62FCB4C2
    DATA &H165388CB,&H88EF604A,&H4920E0F3,&H2913A2B7,&H1B1BE0F7,&H9D31C86C,&H08A00C9E,&HD7F24CE4
    DATA &HA4DAE760,&HD4720395,&H758EBFD4,&H40CA0136,&H30F4C167,&H3D11DBE7,&HFD6BBCB6,&H3F523DD8
    DATA &HD1027600,&H9DEB8D1C,&H91A28675,&HDF81846F,&HEFCFDFB7,&H56EEBA56,&H3D791AA7,&HD215EA0D
    DATA &HED022988,&HD6A53E0A,&H8025A87D,&H060270C8,&HB9928BB4,&H4F202A41,&HDD19A40A,&H9621E777
    DATA &HCD348D80,&H3DA695CC,&H40BE425D,&H2A440A28,&HC25EDC8F,&HF6DC33F3,&H32A112FD,&H91EF9BFC
    DATA &HEC36B8B2,&H8746F734,&H31949298,&HEF799402,&H96DF406C,&H145CC168,&H9757E6A5,&H3F0B264F
    DATA &H5C809D63,&H8FF92398,&HE260797F,&H20EC2E67,&H955BF28D,&H30148885,&HC8F55C18,&H23EA2E02
    DATA &HECB2B1FD,&HCAD9BC32,&H647D08FB,&H070684E7,&H32572C9E,&H88441C79,&H7117AC7F,&H6EB3FA2E
    DATA &HF52403BE,&H38048F9D,&HFE9BFD80,&H6525A901,&HFE478A13,&H989FBC7B,&HFB347CFB,&H857401D2
    DATA &HBEAD3615,&H2429FC6F,&HAF0514B7,&H2EE6EE68,&H50FFAD43,&H9661F63E,&H2D8C3016,&H36A4C626
    DATA &HF0E48A4F,&H751BC4C3,&H946084C0,&H7546D39A,&H1BEF0EFE,&HA5174FC6,&H2233C80B,&HD7F4A593
    DATA &HD05566E4,&H44C01D2C,&H2A247C14,&H99B99914,&H9D220AE3,&H51392AED,&HC97486E6,&HF35C563F
    DATA &H70FC974D,&H715AC2B1,&HFD5B1EF5,&H49EF6E9B,&H728550F2,&H656C67E2,&H72D98792,&H6D886C34
    DATA &H090B0C90,&HA30489EF,&H3B13D438,&H1722785B,&HCFC92881,&H98068F8C,&H27D8B01F,&H4114AC4D
    DATA &H1161E53B,&HB2D0EB5E,&H7D8667F4,&H3042FBE7,&HFBCE0B0D,&H4134FB37,&H9C714080,&HC203CD29
    DATA &HF0D218CA,&HD16BF74D,&H407216CC,&H4E7B78C6,&HF2766CC0,&H635FC864,&H59006E89,&HAEC9727B
    DATA &H42271142,&H9523EB0C,&HC325EA18,&HB0524BF0,&H2127D12D,&H2D5AB0C3,&H2C8CFDCA,&H999F2143
    DATA &H711A8ADA,&HD5DB8E2E,&H88697D5E,&H2F8D4D33,&HBFB9B2A3,&H84B3C220,&HE684FAC8,&H39CD23DC
    DATA &H05F8BBA3,&H237EC4C5,&H3F77C00F,&HF2882BA7,&H207FFBDB,&HE3276FD3,&HCE0DC6BE,&HF7039591
    DATA &H9C0136A5,&H64969682,&HB60AE241,&H1CDCEFC5,&H4F6CACDF,&H39CA1BC4,&H2A40ED06,&H7CBCAEBC
    DATA &HF9095F31,&HFD472067,&HF2000565,&H537C006C,&H1E767ED7,&H84F09F6B,&H147F69F4,&H89BD5D38
    DATA &H30E13BEB,&H6AA873B6,&HFDE4185D,&HD57C10DF,&H8D8F07E1,&H1C3F12AD,&H38CD7B06,&HBEF52A59
    DATA &HE2BBF76B,&HA8F30A51,&HD31AB4E9,&HA94AB627,&H5C7C1E55,&HB9B4F653,&H360384F4,&H8310408C
    DATA &H74B99311,&HD7F70053,&H32B34584,&HCA5E3F8C,&HE81B3796,&H957FD61F,&H5F9867C7,&H07CC256C
    DATA &H73AE7E59,&H692727D3,&H37E75D40,&H1B6F9AF9,&HCFEDFDA9,&HE65962AB,&H9F157344,&H4EE32EFC
    DATA &H7526A8A0,&H92E460E5,&H70378C68,&H71FD2CC7,&H77B8B12C,&H0CE5D5F4,&HE96BFC56,&H08608CDC
    DATA &H0D98BB56,&HF0013081,&HD3965CA0,&HC4A23F51,&H7F8D74F3,&H8EDEC370,&H41B3E27F,&H13A389ED
    DATA &HDB5AA3DF,&HA59DA2CB,&H0398BE9B,&HBF3A3649,&H2EA7DA0D,&H86FA951D,&H313EA2EE,&H816725E5
    DATA &H600FF2DF,&HF62FFE60,&HD8AD326D,&HF7251415,&H24A8A47D,&HE0866438,&HEADC51F2,&H82D38D64
    DATA &H8544CFF9,&H48332DB7,&H27E616E2,&H351A6A0F,&H850A11DB,&HE67FD530,&H5299A4B7,&H34B7DC15
    DATA &HF698527D,&HC2B255F3,&HC70D6617,&H3F8E68BF,&HDCC1BA69,&HD2142185,&HE86D4922,&HA760C05F
    DATA &HF8375061,&HE5C341B7,&HE334FAE3,&HFB0F3592,&HF210F974,&HFCB713B5,&H36E18582,&HDE2AA88B
    DATA &H8A65F8CF,&HDD385FEF,&H7898D50B,&H890745F5,&H4AE552FC,&H2593C2B8,&H78191868,&HF67143E2
    DATA &H50F60AF2,&H8D43EC40,&HFF6F427B,&HB1C440AF,&HB9CDDD1A,&HB2FDDC66,&H54D371B5,&H3561C843
    DATA &HAFA868C9,&HEE47AFFD,&HA95FD839,&HFB8FDC77,&H77F8012A,&H21E550DA,&H5D7444CA,&H94C50EDE
    DATA &HF14F2187,&HB0ABB104,&H2834BFE3,&HB8D692F2,&H14F0D9AD,&HD1B592DC,&H7B27DE70,&H24582425
    DATA &HD7625675,&HB0E7A734,&H0F59BA35,&H075801EA,&H46D9EC60,&H89D1B816,&HE8746482,&H4C6E44F9
    DATA &HC6CE5CEF,&H3D3A4BE4,&H9CC338DD,&H424F0171,&H09720173,&HCFBABBDE,&HCDDFB0BF,&H2D2B4CC6
    DATA &HB2601249,&HA639AFDD,&H61AF78AD,&H34E45673,&HAB4979FE,&HB4597603,&H85B4E4A5,&H03B877D2
    DATA &H69BBA64E,&HE6A36D3E,&H9CF085B6,&HAD294F19,&H7F31F42B,&H937F3BEB,&H44AE6BD5,&HE9A0A473
    DATA &H913A37DE,&H1A43B2ED,&H5C34C6FE,&HA5A45B08,&HD4D5193C,&H9C94EDE6,&H1CB12B33,&H3625DE19
    DATA &H8777125D,&H7DED8A48,&H4BFF1F67,&HD167FAB3,&H4062CF13,&HFAD49A7B,&HE9A606F6,&H078E6A21
    DATA &H2FC8D606,&H7ACCBB01,&HA1D023D2,&H7F8D210A,&H80509B00,&H361DB9B8,&HE7F84AA9,&H3CFF9CDC
    DATA &H8D47F123,&H6A3BDA43,&H3FD30E46,&H53E03CC7,&H727DC7BC,&H0262CBEB,&H92DFE538,&H1A98E583
    DATA &HA003ECB7,&HB9030BCF,&H5E6176DC,&H5222B2DA,&H21013D08,&H1CB74953,&H83F109A0,&H3EC0A540
    DATA &H784E0C9B,&H43EABD21,&H35DDB771,&HFC3FA8A7,&HA2864EC9,&HBD5D0F13,&HC96496AE,&HB7783D50
    DATA &HEC84E66F,&H77E15449,&H8DF2E250,&H4D669CBF,&H4667ADCF,&H9E9A3EB6,&H8AABE7EE,&H03F92402
    DATA &H1205C1EA,&H8FD1D3A6,&H9B30A96D,&H1E4A387D,&H1CE99FE2,&HE7E07D4E,&H2F14AB59,&H8DE8CBAF
    DATA &H967C4C49,&H52E64ADD,&H53F1CE4C,&H2AAC9B9B,&H07AEE35F,&H6366134D,&HC558F442,&HED81E903
    DATA &H37FB6C8C,&HFF29F94E,&HD7739BC5,&H142685CA,&H3D2AC152,&H9F0B09F2,&H586986C7,&H99569238
    DATA &HFF30B374,&H98FB28D3,&H516AA080,&H6158F089,&HFEB6FC46,&HDA1C37A7,&H2DC5415F,&H0F7B8D95
    DATA &HEE04BDA4,&HB4776105,&HD9BA1471,&H6410BC5B,&H9C28F037,&HA96945DD,&H1EA6519B,&HD33B5073
    DATA &HC9344DDE,&HFDB8B0D5,&H6F4C84B7,&H891E66F8,&H67716D57,&H8B06C622,&HF08AC19B,&HD4000B65
    DATA &H5DCB69CE,&HAFF8C60F,&H2F5744E3,&H0AEFC70A,&H80D9B583,&H1A7C9F75,&H597B028E,&H17602617
    DATA &H831DCDF0,&HE16BCDA2,&H9A890CF1,&H7E0D8A34,&HFFAD3AF1,&H795D9AA8,&H4F5F5D87,&H8BFA31C8
    DATA &H58965744,&H77DDB8C9,&HD2E7BD0F,&HCEF27A50,&H66489D1B,&H13A374E9,&HC5E061DF,&HC47C4F66
    DATA &H1D25ACFF,&H31A3AB17,&H45218DC1,&HCE21E315,&HEEB316B4,&HFDB0B9EC,&H0F290432,&H9A07E53B
    DATA &H4A5752AB,&H00D6730D,&H7F1024D5,&H49A4F5E9,&HD5E4FC7B,&H8F5BF31B,&H1CCD344B,&HCA7E9538
    DATA &H726929FB,&H703E3C38,&H7E9675D8,&HCF724987,&H02259B94,&H1922D1CD,&HA8A1B185,&H95B2EA83
    DATA &H1FDCCF43,&HFDB18A37,&H9517AB65,&H8D861A57,&H5EE4A3F3,&H222AF566,&HEB4A977A,&HA84F5F13
    DATA &H00F7C001,&HB53EE180,&H7ED42E13,&HED6C8963,&H4ED8CA02,&H8D4F4B1D,&HAFEA06D5,&H179A53EA
    DATA &HC6B96991,&H2CD23292,&H3FC53421,&HFB6BE996,&H6C13FFCD,&HF91C27F9,&HA2345CDF,&H16250C9B
    DATA &H8C86A8D4,&HCFE5EA5E,&HD12EBAB9,&HF9004E24,&H60E6DC82,&H8B203B1F,&H7E121E84,&H83E833FE
    DATA &H04B7887E,&H0E029364,&H1E198992,&HC35C263E,&H1FD7BFC2,&H3D29F195,&HC76A8658,&H43AFB560
    DATA &H5F28A0D3,&H284CEB2B,&HD79CAAED,&H3E6F8374,&H33015E57,&HF9E06773,&HE5875C20,&HE340FFC6
    DATA &HEB5C119F,&HACEC3A83,&H910463E3,&H2A8CF245,&HB4D2359B,&H69603082,&HB10BCBAB,&H5760B063
    DATA &H142A7C61,&H29078C59,&H2C66B795,&H742667B0,&H2CFFA695,&H5E97DAE0,&H9C53539C,&HFE52FA9C
    DATA &H4BFD8AF4,&HD8AF3322,&HE4F57410,&H8FC1BA6E,&HBC979DB6,&H94F78390,&H385F117D,&HCC2028E7
    DATA &H40713794,&H797CED51,&H198DC0A1,&H3B6A58F4,&HFCF2FD55,&HE2D11DC2,&H0A7B60C5,&H3A97C273
    DATA &HFA8A30CE,&H80C7D620,&H15814127,&H0755CBE3,&HD8487EF6,&HABBC6E99,&HB0C43EF8,&H80265AAA
    DATA &HB3A932CA,&HBA68BE2B,&HB4777968,&H31EDF3E4,&HA32CD247,&HBDFAF14D,&H91CA4C10,&HA6DA6DDD
    DATA &H6E27C5A1,&H7C9BA863,&HB2682C90,&HEA904E56,&H766DD901,&H89CA6292,&H1931DA0C,&HF8BA387A
    DATA &H0033022E,&H4B4E32DB,&H195E0CEA,&HF7A4E373,&H6C6E5657,&HD0A3CAC9,&H04FF066E,&H0B687CE9
    DATA &H47FEFA4A,&H70A254DC,&HA1179AB3,&HDA98472D,&H7A5A9B3C,&H3E62B794,&H7DAA7E10,&HC0E49C7F
    DATA &H88EB6B6D,&HE980BC5F,&H4F873376,&H74C7C86A,&HD9820BF1,&HEF5E3CF0,&H3ADBABD6,&HDFC2455A
    DATA &H576E28A2,&H5B55D8D8,&HDFD345C6,&H6D94EA0B,&H8C82269B,&HB72DB9BD,&H4BC2F825,&H14CA78C5
    DATA &H2596DBFC,&H3A73261B,&H3B1384A1,&H5006B421,&H51A7C889,&HCE75DF28,&H1C804D62,&H0B670189
    DATA &HD9BEB2EA,&H5A95F641,&H98158FE6,&H4BCE6E84,&HBD65411E,&H411E2036,&H8A935035,&H2A8FE523
    DATA &HFC341C5C,&HA57E38E6,&HDB951204,&HCAFA0322,&HA68AC391,&H2B4BC262,&HEA6FBE85,&HD37C47C1
    DATA &H7C13AE23,&HE69F9437,&H9FF5EF9A,&H80019829,&HB6B64F56,&H93A9EFE1,&H507773B4,&H178D0DAD
    DATA &H063DADBD,&H3F153C81,&HF04BCB59,&H6E181A2A,&H173378F9,&H78B50060,&HA648FA79,&HFCA4A6A3
    DATA &H7143E0D0,&H1930F36D,&H2FD92F2C,&H024E3E09,&H6281390C,&H0C00EECF,&H02D5689C,&HCF401ED0
    DATA &HD451A6E9,&H4F6CCD2C,&H6FC6D17D,&H1C6369F2,&H4D44C6B7,&HAB6199FB,&H4BC81EC3,&H963C4177
    DATA &HF70FD8C5,&H7701D261,&H0F2C0760,&H92EA4E81,&HF4911C05,&H44E386E3,&H86706B2A,&HD3A8E992
    DATA &HCB817482,&H4CC81A75,&H67E8CDB3,&H1D5F1737,&H1FD5B570,&H14D2A3E0,&HCAA6C11C,&H050CC154
    DATA &H38735D48,&HE7D6B7F2,&H360C6D44,&H390C0082,&H0E7417C1,&HC05E007D,&H9CB603E4,&H9897E046
    DATA &H4B836C00,&H64C93A05,&H53DB1200,&H57AF6A00,&HF1CD2597,&H7E4DE11D,&H3DEDC923,&H67D1E743
    DATA &H2EF234C8,&HC6088C16,&H4B0100E6,&H1B4A6055,&H484D38C2,&H7F155588,&H5FF77478,&H5B419999
    DATA &HEE34B067,&H527F2B89,&HD8D3B063,&HA4FDC88F,&HB6E2E3DC,&HF0C2CE2D,&H0B9B01DA,&H92CF07D8
    DATA &H1B4369F4,&H08FE6326,&H9EEF3D1E,&HA0F8718A,&HB49DE999,&H8F06DFFB,&H9CD0A35A,&H2EC6D224
    DATA &H98A05400,&H9005B63F,&H2B31A97C,&HECDF15E5,&HF0E4C0E8,&HC1DA1BE6,&H3BB7B3D8,&HD595D1D9
    DATA &HDBE9DB49,&HE6EFFAEB,&H3DF26EBF,&H3DACF9A1,&H699D4FB8,&H3D5CE08F,&H4E9D849F,&H9BE66D7E
    DATA &H3B8E077F,&HF5B836EF,&H5E6E0D57,&HE86E7CC5,&HD7B76108,&HE09CF295,&H48AF7B87,&H9CDC2449
    DATA &H0A081463,&HA5530E2D,&H0EA06079,&H3FA334AE,&HB5BCB5A9,&H723BEB7E,&HE326C913,&HC33776BC
    DATA &HDEEB518C,&H10B102C1,&HBCD6FCC2,&HF9FB4130,&HFAECD7CE,&H05A61C14,&H4B858C5E,&HDAA624C7
    DATA &H95ADB160,&H54E9A90E,&H17FF09D2,&HB1056740,&H47DB075F,&HA02B2CB1,&HDFFB1F22,&H04E69431
    DATA &HDA8491CD,&H46315620,&H3F8E10A0,&H01C13477,&HAD386F33,&H02A8E99B,&HD761A5A1,&H8D3FD946
    DATA &H5D2D5300,&H22253498,&HEDE34C14,&H32A70502,&H6B7C100A,&H53D04716,&HDDF2A003,&H3722014C
    DATA &H27E96592,&H65A44013,&H11A45301,&H288D8001,&H7BC54DBE,&H53E2A7ED,&H72578668,&H4672AAD7
    DATA &H815EE6F9,&H9BC5741E,&H9A0D050F,&HC5298FCD,&HCE5C10E8,&HCABC5F4A,&H90C0AD81,&H88206EBD
    DATA &H1F174972,&H2F43EA54,&H1252E060,&H0E1AFE06,&H06DC6DBA,&H4011B1F9,&HD5776677,&H4484C6AF
    DATA &H999B827B,&H1BB9B194,&H67A8CFD1,&HAA903962,&H6D653C36,&HD59CB07C,&HF574EEDD,&H490E7D87
    DATA &HC3D283C8,&H844F99BF,&H9DEDBBC6,&H2CD474DA,&H68EDCB8D,&H001B443B,&H296E9AD8,&HF8E2E300
    DATA &H4E0D4C46,&H605F0C60,&H5990EF89,&HA7A5890F,&H43446B1C,&HFCCDC424,&H14CF92C8,&HDB94B910
    DATA &HE323FF06,&HC836DE1F,&H049ABE3C,&H36180125,&H089B174E,&HAC9823E6,&H21ABCE8A,&HC0526FE3
    DATA &H3AE779C9,&HF4DC67C9,&HBF49020F,&HBAE3A2F5,&HE6CC6391,&HD5322215,&H99B46AEE,&HAC56FB69
    DATA &H96241E34,&H43131039,&H64B84F7A,&H7CB25E41,&H53943337,&HC7F16310,&HCAC8ECF7,&HBFD66BDF
    DATA &H8A421E6A,&H6717A399,&H73CB3FA4,&H5D8FC486,&HFB720CA9,&HE947B142,&H4EE2EABF,&H2F235AE9
    DATA &H3FAAA814,&H03F09A34,&HCE7C7A8B,&HD240BF1B,&H9402BBE8,&H849D30C5,&H35D4DE86,&H4F603222
    DATA &HF93D8C32,&H4D2E38F6,&H3547056E,&H58A709D4,&H37B23E22,&HD47F3B56,&H94C87AD0,&H6DD8F17E
    DATA &H549D30DC,&H8683AFB2,&HA30DCAB9,&HF0AB9FED,&H142A9602,&HDB572AC7,&HD7BAA4B3,&HD3E3B76A
    DATA &H04B9329D,&H321F498D,&H5E5A4793,&H7EB2D344,&HB1799BC8,&HB5BB7E22,&H9D6BF719,&H012C4508
    DATA &HD9698AB0,&HFA169D33,&H55C00E0F,&HE4D54ADA,&H74DD61A0,&H367F4CBB,&HA3CBF636,&H9677A398
    DATA &H365CB2EC,&HB5F747B4,&HD89434B8,&H9CDF748D,&H9D732E91,&HC6E96C36,&HCD7B122D,&H5C54BB8D
    DATA &HF96EED16,&H7566E8B0,&H8E69BF31,&H8B9E3315,&H7509C691,&H7340F148,&HE5CEC9E4,&H040CC0A8
    DATA &H18CBD533,&H2EC622D3,&H230B12A0,&HCE8F1B9E,&H53B7B4CD,&H352EE043,&HCBEA9E12,&HEE2E352A
    DATA &H0773DA2E,&H83F50771,&HEDF5007C,&H485DAF3A,&H7E45940F,&H27053768,&H8A0096EF,&H9A6B9579
    DATA &H34135E95,&H9D2E0DC5,&HB06680FA,&HDA11E3EA,&H77DF85AA,&H3230FC9A,&HD1CD0B30,&HE174B124
    DATA &HCEAB8943,&HE627B081,&H484C324E,&HDC88AD20,&H4495E809,&HE1C7C331,&HB6F44E27,&H903072D1
    DATA &H043F3819,&H65B99490,&HC977993E,&H8A369043,&H9B1FD836,&H30A11F35,&HADD82211,&H09781C10
    DATA &H2216A3C6,&HC1F99053,&HCBC787E7,&HCD24B993,&H39E37F76,&H76363D13,&HC7312413,&H05639A05
    DATA &H3B26EF8D,&H0C6D56D7,&H823A91C1,&H08C5CA54,&H02E3BF72,&H0019F220,&H8D5F8A69,&H23C34636
    DATA &H9F90C1BE,&H299B6042,&HF60038C8,&H30437FB8,&H22C19134,&HEE3D1F69,&H836E8AD3,&HD846306F
    DATA &H2A3C2046,&H210E8D80,&H19477F16,&HEBE4517E,&H253F0C4D,&H0A80B7A7,&H8167462F,&HFFBC7D2D
    DATA &HBC4D01CE,&H7A6DCE8E,&HBFAFA967,&HD1C21365,&H140A643C,&H08E1345D,&H1814543B,&HA611FFDE
    DATA &H65602105,&HC969D5BC,&HD62A5D32,&H71B571F4,&H94B9D9FB,&HA5EFF1CE,&H01315DE5,&H965C48DA
    DATA &HDFDBDA65,&HA6CCE749,&HE2628B1F,&HD8FD4C3F,&H4EC929A0,&HFB2099C4,&HE98DFA3C,&H3DFDEC24
    DATA &H5EC6A69C,&H348A2734,&H42FF6DCF,&H326B0C43,&H114925A2,&HDD5B6D4F,&H95232E99,&HD75C82BA
    DATA &H7A2D7775,&HF79B035B,&H726BB695,&HDBA27EB8,&H6577FCA9,&HD4C2E7F6,&HAD18E8EF,&H10A51E72
    DATA &HCFB42CFC,&HE9615FF5,&H37C36010,&HB4AEFD78,&H57CC7704,&H25D5B020,&H349950A3,&H570A3D32
    DATA &H6A2D29BC,&HE67BE0F5,&H7D1B9573,&HDF7EE9FD,&HD4D36FDA,&HF23F9037,&H49D2AFD2,&H6BD9FEFF
    DATA &H795D8116,&HE205F627,&HBAEDBA3D,&H23B06604,&HEF560AD4,&H84C3FDF8,&H04F084B4,&H21857D3A
    DATA &H14F8EA6F,&HC79A0210,&H2A180948,&H3A211A69,&H9CEFE1F6,&HDC3EE22A,&HE1A0EBF8,&HD863B784
    DATA &H6ADA9083,&H88F5F4ED,&H7F50B0C0,&HC1B99BEE,&H30816447,&H31768BD1,&HDF5A3BAC,&H5DC5720F
    DATA &HDAE51254,&HF655A105,&H51894465,&H1332E9AC,&HC84F6CDC,&HED1596ED,&H46BF4372,&H40238079
    DATA &H11023A05,&H64F7148F,&H3B2BEF73,&HD2B1F95D,&HD53D7EA2,&HFE8EF4BA,&H6BF14EFC,&H7C872A77
    DATA &H694E5704,&H3BDD8160,&H7973925C,&H3C1913D5,&H37BBD4EF,&H4EE54E75,&H7E75EE1B,&H16AE7793
    DATA &HC8689A92,&H7FA2031A,&HA58F4D64,&H10524305,&H155743B1,&H14275D57,&HD80074F7,&H83E4E808
    DATA &H2C4806A1,&HFE0B3371,&H8EC35B48,&H6F19FBBD,&H961DEE99,&HAB679088,&H7A90D44F,&HC3403B49
    DATA &H7347F555,&H6E44FFBA,&HF354F163,&HED786C1B,&H362BFE1E,&HBB21AF1A,&H48AF0BF1,&HCE77E075
    DATA &H1B1B5479,&H591761BA,&H81875457,&H1D7DF642,&HE2A80049,&HB888B860,&H2B5917ED,&HA5E0B495
    DATA &H8A6D42A0,&HCCADF9CD,&HA85E950E,&H76CC8B1F,&HF8866F7E,&H2BACEA7E,&H53494C2C,&H8E338690
    DATA &H1DF091E5,&H0B4F07F0,&H15D41BE4,&H6E0DD53F,&H781CB525,&HB8539EB7,&HB5B1D1DB,&H4FD37034
    DATA &H26ED9D24,&H8DD7CEB8,&HA7525194,&HA5A37EA8,&H3513378D,&H00AE3522,&H8F7E3EA4,&H65289D84
    DATA &H39A46DEE,&HAAB8E8B9,&HCE55B5AA,&H6198BA9D,&H4425E1F4,&H14235B3F,&HDB7A9C6C,&H3AC9F5A2
    DATA &HEE49DDB9,&H2D706E3D,&HE65C9AA1,&HC0D6F387,&H230204CC,&HCD2B1376,&H99AD967B,&H93CAD214
    DATA &H688D2A3E,&H637247CE,&H9A181FDF,&HC2A19062,&HA5DFE8C0,&HC21DA938,&H4C9B6C83,&H5CDCDA63
    DATA &H952BFE56,&HDB0A5B2A,&HA98B5FAF,&H89A7DD32,&H28FE4A0C,&HB398D0FC,&HE2DAC0A7,&H7D31FBE2
    DATA &H83F45A68,&H6A87FE34,&H259C8DA7,&HD4ECFAF5,&H31641E3D,&HA99CC974,&H84DAB7C6,&H6A170818
    DATA &HBABD14BF,&HE3CD4367,&HE68F6326,&H5BEBDF44,&H8EB8A0EB,&H1A6159B7,&HA264BF4C,&HA5316240
    DATA &HDC736938,&H5BB654A0,&H25AB6F2C,&H92C0E66C,&HF83F0276,&H755AB63B,&HA46063EF,&H7A9F90F9
    DATA &H7611C42C,&HB6D92858,&H2733B8F8,&H144F93CE,&HC3D9185C,&HB85E2B13,&H4EF821E7,&HE045604D
    DATA &H695F834C,&H6F69C5F1,&HCB2C99CD,&HC6F04C25,&H9B7B9307,&H28018172,&H86D9A7D6,&HDD72ADE4
    DATA &H44CA0E5C,&HD0AAA9D8,&HB7F5A8BA,&HF13630C4,&H7E8CC7D2,&H29B8793D,&HF439E38A,&H07ABD838
    DATA &HCF742D51,&H07EFE761,&H4F4C387C,&H91344E98,&HABD14C10,&HE8BB4418,&H6667393F,&H02EBD5A1
    DATA &HDAF5F18B,&H19EC9B66,&H21D5E0CB,&H4C21B1F8,&HFD370BC2,&HAC3B8951,&HC3103BBE,&H77819AA0
    DATA &HDB914F6F,&H1648E001,&H1FEDF633,&H585AB86D,&H3E71415A,&HE1900759,&H4461BD00,&HC3609427
    DATA &H9E8A5C13,&H16F0A1B8,&HCD1C7073,&HB90BF801,&H1D0CFB76,&HC0302373,&H0047EFE3,&H9E32754B
    DATA &H047B1359,&HD40DE216,&HD204598A,&HB89F9DC6,&H3D1CA24D,&H0C17CE6E,&H45BABC49,&H984E75D1
    DATA &H7EB5586C,&HB5A60829,&HF3010A84,&H7F5917F5,&H26DA5FDB,&H40C379ED,&H6BD3D12F,&H2FD46AB7
    DATA &HC85BE83E,&H87C39006,&H258B472A,&H34D6A9E0,&H6732B900,&H5EDB39BD,&HD6693CD0,&HED32B32E
    DATA &HE0D86AA1,&HD8024C95,&HDA09C07A,&H4EE11053,&HAB29CCE3,&HF5FF6187,&HD9BB785D,&H1B4F8250
    DATA &H031200E9,&H4A06024F,&H5ADE7AD3,&H5B73E32F,&H85A23A81,&HA41B2008,&H8BA67554,&HBB5A8480
    DATA &H35FF6865,&H604BB3FF,&H9AD38526,&H42CAB496,&H305E4C2C,&H27AC3A10,&HBB233C5A,&HBC918D5A
    DATA &H6EA791AA,&HB524C439,&H828FC365,&HA5FAC24A,&HEC272690,&H717C9FB7,&HFCEFFA2C,&H0B8CFE34
    DATA &H28D41F85,&HFD2B0304,&HC3D29780,&H436E5638,&H94F8AF3B,&HF8EA34EE,&H2BDBDDE0,&HF333BE54
    DATA &H77CBF11A,&H75D8291C,&H328115FD,&H5ECA0E8E,&H6EA8D2BE,&HAF956242,&HEBC56606,&H34B6B9A1
    DATA &H4F73E4C6,&H9F9F844A,&HBA888E96,&H1987FAB2,&HE8DA8EED,&H1E95D234,&H827F7CFE,&H6F73713F
    DATA &H197C8537,&H1CF71881,&H044229AC,&H6F580F6A,&HB7BD5BEE,&H6F51C817,&HD4640A30,&H7A870C19
    DATA &HFC2C96C4,&H4F0FD435,&H4BA9A3E3,&HA0C61AA8,&H624C6968,&H677624E6,&HFF5B7AA2,&HADB347E1
    DATA &H097C64E7,&H1E11A101,&H8E6A686E,&H62C37C09,&H39908D2E,&HD1FBE90C,&H5E05E12B,&H6A50DEFE
    DATA &HE9F34CBB,&H67E379CD,&HD5DF2D9A,&H9AEC76D2,&HDE361096,&HEB64C346,&H36ABFD4D,&HDBC4F0BC
    DATA &H54D1B4B6,&HA5765C02,&H085688DB,&HC1351C05,&HC23ADF6C,&H7C21F4E0,&H99FF6D53,&H3CAF3DE9
    DATA &H0D961764,&HA44A4537,&H8FA5D9FB,&HB7D210AD,&HD7794AF8,&H591C3826,&H6D20132B,&HD96FCF59
    DATA &HC430F72F,&HABFAE7FC,&HFB9BC5B9,&HA4E47125,&HA5CEA93F,&HEAE51BE5,&H768DA6D3,&H4387E5DD
    DATA &H881020B7,&H98D853EA,&H6DD36042,&H1D2B1A4D,&HCCC9A677,&HC522B2D5,&H0DFB92B9,&H3035BBD2
    DATA &H21380AF9,&H9E509251,&H4F91E9D0,&H118BA7D3,&H2FCE5426,&HCAF46427,&H0A57DF19,&H5897A029
    DATA &H8E6D4D94,&H6A513DBD,&H2E465F44,&H345E7049,&H27F7D37A,&H3BA6ED1D,&HC46D5127,&H6DEF87D0
    DATA &HB5F74B0B,&HCF174EA2,&H7FA89F93,&H4966D33D,&H8F4C0FA2,&H9913A4D3,&HA5911703,&HBCEC8229
    DATA &H7072DF4F,&HEEA139F0,&H63058726,&H92AA1127,&H71B47FA9,&HADE2D9E7,&HF80A2F0B,&HA4A613B6
    DATA &HF1007B47,&H5E9CA6FF,&HFE74B59A,&HC5F75465,&HD988FD75,&H8BE9BF22,&HD1359295,&HB5C741DD
    DATA &H2F8CE5C9,&H02153F6A,&H11CF81A1,&H0F2DBD29,&H7C9F3693,&H956D6BA3,&HA5C0B8D0,&HC13F18BB
    DATA &HF90AF8C0,&H2F2E40B8,&HEA70CF8F,&H75CBF801,&HD8E05E35,&H60BD3EEC,&H5FB7DAA4,&HE16616CA
    DATA &HDD256B83,&H61754191,&H821186A7,&H71A729B0,&H8D3C4121,&H86669661,&H39A261E2,&HB0EFD475
    DATA &HFA05CEA8,&H997D205D,&HEAB66DCA,&HFC5532CE,&HB5F79489,&HEECCF879,&H8807A963,&HC2579EFD
    DATA &H6D33261D,&HC3233113,&H97F5BC14,&HDB366325,&HE04E0EE3,&HA79113E5,&H59614746,&H96254362
    DATA &H25D38CBC,&HAFEE4229,&HEF4467D7,&H5D42787D,&HCC1114F1,&H4357C1DD,&HBB5B2B4C,&H5CBD6357
    DATA &HA9CD1EF6,&H8147F324,&HA6280D0B,&H2730B0BD,&HA3F13E7D,&HBC79C964,&H4742A8D3,&H047F5BFF
    DATA &H62D879B5,&H57B5DDF4,&H1BF0BC93,&HE75D42FC,&H311EFD71,&H7BFE1DDD,&H9D88EAC7,&HE4A180C8
    DATA &H97EB42D0,&HEA8E5E39,&H7B8FF6C3,&HC6724303,&HEC97D409,&H7D0BDC64,&HA4797ED7,&HB1B82B41
    DATA &H22115AF3,&H9CDC1FF2,&HE010FC2F,&H4A671B5B,&H78CC8433,&H32C7992B,&HC33827E7,&H6CC43B0E
    DATA &HE9EB783F,&H4E6E4A55,&H02456B5A,&HE5232311,&HE63B770E,&HFD8D1108,&H859125BA,&H25BC34C5
    DATA &HDDFE4F78,&H92B75E00,&H4F645DCE,&H3D3E402F,&HEA58FDF6,&H3AE05A2A,&H5A8F591B,&HE3D471F2
    DATA &H7029E049,&H83AB707F,&H6FC46E47,&H529FC6F0,&H8172E810,&H3516281E,&H555DC157,&H7C578C9F
    DATA &H9F5D4C5D,&HBBA62677,&H721EABBA,&H8BB23644,&HCC2B3E2E,&H62954CCC,&H02986E72,&HCF3B317B
    DATA &HC6B2F6E6,&H4EC771BB,&HD0BB8AFF,&H05FE827F,&H86BEB225,&HE0FF9309,&H5C3EA587,&HAD39502F
    DATA &H0D50862D,&HCC2B09FA,&H383C1C2F,&H835FEE0C,&HCFEE6FAB,&H4235273D,&H05B486FC,&HB5D278D5
    DATA &H92329286,&HB211A730,&HA40EF8CF,&H8ED9BCD2,&H73598F9F,&H45B52D42,&H8DA981CE,&H58EC044E
    DATA &HEA760CB2,&H046855A8,&H1EAE971C,&HA73CF486,&HFAEDBEA1,&H520F8F13,&H94D14BDA,&HA14F8CF8
    DATA &H5A97B533,&H89509F1C,&H9C60AA18,&H78E0B2F5,&HDABCE70F,&HA6E0CDA3,&HBD403B6E,&H7E438E9E
    DATA &HD418D7C9,&HC37488F7,&H3DDA360C,&H24C4EEEE,&HDE9882DF,&H4260C9E5,&H9E995B25,&H406DFAE4
    DATA &H8B20E1F0,&HA1FF919B,&H2287BC97,&H2A14C2D5,&H14D99FE9,&H34146BD4,&H8628FB86,&HFE2F2B34
    DATA &H5D0ADA75,&H40191E2A,&HFCFA387E,&HC468BDBB,&H07140228,&HC276C1F0,&H61BA55A6,&HC9304E68
    DATA &HA40F7A66,&HD4113C3D,&HCAD06446,&H59B8CDC2,&H987C8764,&HF8D22048,&H1DE114B4,&H317818AC
    DATA &H9F9C0CAF,&HB39468C9,&H8E7C2C7C,&H6E176AF2,&H7589FAA5,&H2D875F40,&H1A4E1D40,&HD2859A5A
    DATA &H5F19A365,&HB2D02ADB,&H5E3EFD81,&H4BCD5B4C,&H5DAA7F8E,&H3E62095B,&H3587B755,&HB735F4F5
    DATA &H485FDCDF,&H5F6D5323,&H86E350BA,&HE1156538,&HEA65D3EE,&H41EF33BD,&HB276549C,&H5E3FC1CA
    DATA &H772F7C3D,&H9C1E5CA9,&H73E03DD4,&H7904EB2F,&H3971DE16,&H7F3C5C87,&HED66902A,&H3F178255
    DATA &HB11724BC,&HD8F0DA2C,&H9E540F4C,&HFDB07FEC,&HDFA4E73C,&HDD566B56,&H59E0635A,&H307AE8AF
    DATA &HA8149347,&H1DF558B9,&HB81429CD,&H0F44EB44,&HE4964F08,&HD82BAA7B,&H6429BDCD,&HAB9E9540
    DATA &HBFCDC6BB,&HEDD9306F,&HAA7BEB1C,&HA39AC185,&HC49581C0,&H08FCB2F0,&H3C34E676,&H266B026E
    DATA &H04ABE072,&H215C08A0,&H8BD8C0A5,&H1205DDBA,&H5AD652BB,&H27152B3A,&H794CC137,&H0A250572
    DATA &HB12B4AEA,&HFB9BC49C,&HFBC98F59,&H9DF7D09C,&HCC43C2B1,&H935FF439,&H5192AFD0,&H1B762608
    DATA &HB6250828,&HF9F5E957,&HDC069361,&H9109D537,&HA95CDD16,&H2ABA2AA9,&H574D1FFA,&HFB84D61D
    DATA &H4888477D,&H1BA4A308,&H5A4043A4,&H53A4443A,&HA5690424,&H7746104B,&H5D21DD2A,&H07C284A2
    DATA &H74A8B486,&H46904E48,&HDB061A40,&HFBF985FB,&HE33C0FF1,&H6D9F7679,&HE7BDEEEF,&HCBCE73DE
    DATA &HB6D5BB52,&H3ABE9C5B,&H9CFC1702,&HCA33260D,&H91C09362,&H56FD7CFD,&H27D8A049,&H6C8EE136
    DATA &H53298D49,&H93DBDD0D,&H85F79327,&H08647E7F,&HECC5721B,&H42C99465,&HC4F3D7E1,&H892292B6
    DATA &HDEFC6B19,&HBD1BFA70,&HBA45F877,&H910CBEDE,&HB4B2DB64,&H9653B6EE,&HE1FD5B9B,&H5EE50C58
    DATA &H02F3B9CE,&H25516F56,&H4BDAD06C,&H940AFDF7,&H64695C01,&HFCF8F069,&HC9F2E75E,&H4CDFC579
    DATA &H3A9EB96F,&HBA1D484F,&HEA7257E8,&H3BE95FFB,&H95CA6EF8,&H1884836A,&H7421A0DE,&H6404C9F3
    DATA &H8AD93950,&HA08BE6A5,&H064EC7CE,&HA10AE4F2,&H3980B22C,&H9B9EC5BC,&H9101E194,&H64E6BE3F
    DATA &HDF129C30,&HEABC7E7B,&HB0AE6A50,&H703055C8,&HA9815C4F,&HB58A7870,&HB2E0B396,&HF4E55732
    DATA &HE58213AC,&H11EFB60A,&H640FA6DD,&H1AAD1BB5,&HFD2BE414,&H77108EBC,&H18ED516C,&H8EBEE0BB
    DATA &HB85640E3,&H0FBD7035,&H30652C56,&HD4162742,&H10AEAAC2,&HC08FA6BC,&HF4303DD1,&H2E016AA5
    DATA &H9BF260BA,&HFD5BF683,&HE069C6D8,&H2C9457C8,&HA1855272,&HD7484924,&H7E9B3568,&H0D4BFA38
    DATA &H6919BE31,&H6E3B3C78,&H9B733312,&H88C30AFC,&HC95742B0,&H55B79BB7,&H4C406F52,&HE9B2DE3C
    DATA &HC0DC9250,&H2EC8B8F0,&H23F9C118,&H68856C52,&H8620BE56,&H5BD5464C,&HC8B333A5,&H82AF0AEC
    DATA &HB06B07E7,&HD6A99AF9,&H3F621CC7,&HC47CDC13,&H5E8B1D11,&H5F8548ED,&H36E6E98F,&H7FACA503
    DATA &HF5E3F197,&H2EEADF13,&H64387F4C,&H69CA8138,&HFD46D5F6,&H56C59219,&HFC86EA28,&H94CF54D5
    DATA &H7FED501E,&H325DD880,&HA361CCC2,&H46D66CF8,&H129BF3AE,&HA7F0F50F,&H77994738,&H773B1B15
    DATA &HB07DEE19,&H9DDE7BB6,&HAD73CFAB,&H399A6BD5,&HCEF916BC,&H36E1FA64,&H143C8F7D,&H41113652
    DATA &H68900BA7,&H96AB3BB4,&HD5C020F2,&H81EAE4FF,&H894029E5,&H500B211F,&H8E4EC4AF,&HA7F9F8EC
    DATA &H6D9A6BB6,&H1F018FEF,&H47F7CC35,&H8C3C8C88,&H8F5F5AF7,&H69E433DA,&H54F7C14B,&HAAC88A8D
    DATA &HA757A1C0,&H4DEFBE66,&H134CC54A,&HB884F2AC,&HD1AAFE51,&HF70D8D6B,&H9C197472,&H4806AE30
    DATA &H9EF10DC1,&H8AA0E1D7,&H8C39553E,&HE56C12C5,&H3B61ECC1,&H608F444A,&HB59E7A63,&H63F0BB5A
    DATA &H14C662FE,&H6C8BE483,&H3C8E6D2F,&H8456DD4C,&H5DD09592,&H34E81CF3,&H1E4C9DE4,&H9A8C2C0E
    DATA &H07FAF4D0,&H9A0B2FC5,&H9BAE4D9A,&HB44933C7,&H978FC280,&H5037809D,&H65A7956E,&H7606C790
    DATA &H9AD7BA49,&H9806FDF1,&H594E06FF,&HCD6F195A,&HB504A1C8,&H6061246C,&H47462F57,&H2EAAA8C5
    DATA &H6FF8DA4D,&H927B87A1,&H175ECBAF,&H7B5FFCFF,&HFA489F4C,&HF738F19B,&H244FF2A1,&HE7DB5B2B
    DATA &H20513075,&H6A36081D,&H2D288451,&H66FFD6CF,&H321AF7D3,&HDCE93A15,&H9999922D,&H2A56DC79
    DATA &H1FACC71E,&H29E2B8B3,&H8E252BED,&H03DA3C26,&H213D19EA,&H58E77910,&HAAAA8FD5,&H63EA59C5
    DATA &H28BF9591,&H9FE24D8A,&HF4695030,&H76C7AB5B,&H3ED30DAB,&H4F37FF63,&H7246FCAC,&H1E93D426
    DATA &HBE2FA312,&H8D8EC892,&HAAAEC645,&HAAAAC29E,&H8870E3A0,&H0B4263A5,&H159851C5,&H63A5B9D6
    DATA &H0DF27380,&HE76EA147,&H6471A100,&HCAB3C696,&HC11D2F48,&HE3490B48,&H51D1497D,&HB90854E7
    DATA &H44B603C1,&H99C4BDE5,&H9C331404,&H6B506977,&HF4BF60DF,&H5E3785B0,&H28F260B1,&HEC70BA8C
    DATA &H2F9F35FB,&H693B8859,&H6E5CFB5B,&H37D174BA,&H540B2DE5,&H54D8EABB,&H335F017B,&HC588F241
    DATA &H80E27B5E,&H5FBE393C,&HA1586D32,&H46007A99,&HFF282A84,&HB03B927A,&HD41EB23E,&H467EE499
    DATA &H74A7EE1B,&H1C8F0F83,&H4586BEF2,&H1EFBCFE3,&H4CAE6B5B,&H3D7D9D66,&H0487EA42,&HBD18890D
    DATA &H59252FB3,&H8999CE3F,&HDEAD1B72,&H321AE7F7,&HC8FAC6EE,&H8302A349,&H2C004B49,&HAA3BB3C6
    DATA &H1A5FDB0F,&H882F87E7,&H3A4E780C,&H2F6B4BF4,&H559298D0,&H6A2B6529,&H591AA955,&H3E90166B
    DATA &H26C1390F,&H37442F9C,&HB27073B1,&H2A50C07B,&H8D69C138,&H935B668E,&HB7CAF85E,&HB60DB061
    DATA &H0C11BA23,&HDA902F9F,&HC6F7EF13,&HA34FE52B,&HC3AC0B60,&H8E048180,&H2E546DF5,&HC1517A17
    DATA &HFD76A6EA,&H0FAD2ECF,&H1F4E3D26,&HE6B5A6C1,&H3421E7F8,&H8718F262,&H9DA2E981,&H99EE7B19
    DATA &H2E39AF18,&H5E662FD1,&HC6CEFF9A,&H845C09F7,&H80721AA1,&H78CE1B92,&H95CC9FC7,&H1AB10A55
    DATA &HE973F747,&HB00FFED9,&H9A370FFA,&H706209D1,&H5777E063,&HB2303D5D,&H0C096E44,&H123C3644
    DATA &H60DA76A1,&HCA5FADF2,&H44B50028,&H3E7ED17C,&H938E1363,&H997EE121,&H2D55015B,&HA7858E2A
    DATA &H4E42C644,&H4470B63D,&HA7F6C891,&HC39389F1,&H4CF0606A,&H0276FB7B,&H4A5B61D8,&H8506263A
    DATA &HB2B97B8E,&H31B78C3C,&H59144F9F,&H0C89ED1B,&HC4A7E0CD,&H36FC761A,&H204B58E4,&H83A1D833
    DATA &H6AE0BD02,&H8902C535,&H871DC5F3,&H359E07D1,&H0C94C77A,&H91F0A746,&HB312458C,&H804BC90A
    DATA &H4C0DE124,&H3CD18185,&H0EC7BEB7,&HADAF40BE,&HA92F0E04,&H1AE8DACC,&HA183CB14,&HE94D2B7B
    DATA &HAB61E595,&H2F234256,&HFDC7EFD2,&H9E9B2BE3,&H853BCDAC,&H1091DA37,&H0F3A2B3F,&HF80F44D8
    DATA &H46CD46BB,&HA646B39D,&HD57A59BA,&HF65535E7,&HB494E4F4,&HC1C812D5,&H553FA30B,&H8D2D928D
    DATA &HBD0D8091,&HAFD0DA68,&HCFB4227F,&HFA00B571,&H385239B0,&H032016B6,&H00FB431A,&HC3AE5C18
    DATA &HC22137C6,&H21789257,&H4B8397F4,&H37B304D4,&HF8F721AB,&HDA6C4FC7,&H6DCCEEB5,&H3D41D822
    DATA &H8B2F0BB6,&H3FDA2821,&HDF1C16C9,&H7AA75BF0,&HFFA1B99B,&H9BA48D99,&H5590B7F9,&HED395E8F
    DATA &H724B0AA9,&HC7A681A2,&HFFFAE88F,&H98F6A6C6,&H25C82395,&HCD3F6842,&H9ED5A5FB,&HBD59C952
    DATA &H09EFF9F3,&HE76F6A82,&HF1B94CB7,&H438BC9B0,&H9ECC12B9,&H1B7933F6,&HABC3E7E3,&H77BD3DBA
    DATA &HB29BBD39,&HC29ECC34,&H8ECD22E8,&HE781C6A7,&H31111E85,&H9B5F5F5F,&H97861FEB,&H30D2BF97
    DATA &H469092FD,&HAC806492,&HFD59DAD5,&HD2793F39,&H7B19682C,&HD1D6BD39,&HC1FB771A,&H9871D3FE
    DATA &H8E2AC971,&H7B5EDDE7,&HAE1A50CC,&HFEB888BE,&H2BE2F87D,&H0AF7D706,&HBF7ECFEB,&HFFCA27E6
    DATA &HA2424C81,&HDE4E52CD,&HB88B09F1,&H1B9B19C0,&HDF6C86B3,&H9E589144,&H75C17856,&HBCC4075D
    DATA &HA58F5C7D,&HE10D7FC9,&H883BF401,&H48C26913,&H9084382C,&H54A2D83E,&H2841E67F,&H33F5B01F
    DATA &H24D03623,&H8890A978,&HC1190F18,&H9C2548C5,&H657FF600,&H6373582A,&HD027AAFA,&HB5CAE425
    DATA &HFF8B6F4E,&HC15B446C,&H3E068F55,&H07A1D699,&H46566805,&HD7FDAB01,&H80C0FC5D,&HBCEC11F8
    DATA &H4D454F40,&H5EA5200E,&H200B46E8,&H3DE6E6D0,&HCC0719CA,&H0AA6A68D,&HEC662E28,&H41FF683C
    DATA &H1F9CFBC7,&HEE75F238,&HA02D677E,&H7417BC1F,&H9CACAF9E,&HF3E14335,&HC3FD9477,&H374C66A7
    DATA &H7E35B8CF,&HABA368E2,&H173D3F74,&H5BFB027F,&H946BD008,&H055D1583,&HBDF65500,&H3ED11F06
    DATA &H4C38C656,&HC110757C,&H27306B5B,&H6F26937F,&H39BD3EBB,&HC137CCF3,&H2B09F489,&H65225821
    DATA &HE90D6995,&H11123860,&H9F0F5247,&HEB02BAA8,&H6FA63482,&HC8EA63B0,&H20B1F82C,&H94243FC6
    DATA &HCDFF49EC,&H43925C6B,&HF4F578DF,&HA385AC3E,&H4EB3963A,&HB4C53F26,&H669DA7E5,&H07DE231F
    DATA &HC2ADBCBF,&HF330479C,&H48214D90,&H298B633D,&H54162CC5,&H524060BD,&H403E2474,&HAE2F3762
    DATA &HBD9F2B93,&H1D850F1F,&HF619F233,&H38FC75A6,&H1344FAAD,&H04FB56F1,&HCCA55D0A,&HF4C00322
    DATA &H4B1D3FC5,&HB41237D5,&H3D6B46A9,&HAC16402B,&H8AFF6730,&HC6A2E457,&HA06966EA,&HB9287F1E
    DATA &HA4102D1F,&H3493828F,&HCE7E155A,&H7E09C3D9,&H1481E2D3,&H805195C6,&H2C5BCF0B,&H915364BB
    DATA &HB553B4EF,&H9B780FC6,&HFFA5696D,&H9B53E821,&H2750E97A,&HFA79705E,&HEDA42B27,&HA8006B9B
    DATA &HDCA1D675,&H4A17ECC2,&HB768E828,&H1C2E63C1,&H3A3BD142,&HB0AEF1DE,&HFEE9D375,&H89717109
    DATA &HE3371586,&HED60746A,&HB60A3B7E,&H2A34EB17,&HA770287A,&H70A629C4,&HC38F8D5F,&H94E34CDB
    DATA &H7298FB74,&HD6BEBB97,&HF3BFADE5,&HBCBB8778,&HFA9A7764,&H7B6CF962,&H9E0BDFA4,&H9975BBA9
    DATA &HCC08AF9C,&HCABE8A04,&HAF036AC0,&H6D0AD4E3,&H66C9AE2F,&H633961FA,&H1C5DA38E,&HA99F2B0F
    DATA &HDF2D4618,&HF6B89A5E,&H08D6CDE9,&H6E2B4C84,&HC2594F54,&HFF423A1F,&HB88576E2,&H93D8E784
    DATA &HE077972C,&HD23FCFDF,&HCE654AE2,&H468ABE76,&H4326F3F3,&HCFC9EAE2,&HFCAD07F1,&H11443429
    DATA &H1EC37ACA,&HAA7C180B,&HCAEE494C,&HC5271A8B,&HDC2A8071,&H55B5C520,&HE3FA112A,&HD14DF3A7
    DATA &H9FB9B3B1,&H5286114E,&H306EB13C,&H7A40AC28,&H35838B6C,&HD3340192,&H6B760007,&HCBD841C1
    DATA &H32C69441,&H07F4236C,&H53DECC4A,&H78B1534A,&H6C8E032D,&HCDE1C533,&HD2BE4039,&H38DA51A0
    DATA &H17796CD0,&H677FB96C,&HD34BC315,&HA3BC3D20,&H6E52E684,&HBC13847D,&H0A73E9F4,&H108884AF
    DATA &H5EEFCE13,&H42764698,&H53E23F36,&HB80C94C2,&H516EEE0B,&H7D02BBD1,&H645B2749,&HF8F0D81A
    DATA &HEEFE8720,&H69AD4554,&H3A5C774D,&H98886CCA,&HAFACAF57,&HDDA0A639,&H6497A794,&HA66519C5
    DATA &HB1DF6B1E,&H44ABAFE5,&H79CE2ABB,&H50FC612A,&HE83F419E,&H0E4A0CAD,&H1E38DA36,&HC3351627
    DATA &HE82E0D06,&HDE9FC077,&HBFF50FD7,&H89EFD730,&H5D50C0E4,&HACDF4E31,&H0CC1A25E,&H9EFE9403
    DATA &H0DC736F8,&HD7D92148,&H96055204,&H47429D05,&HDD32232C,&H012A44F2,&H8D6AE733,&HE2A9305A
    DATA &H7233043A,&H77AEA1D6,&H28A43E9D,&H23E47E00,&HF93077A6,&HB14C9BCD,&HF7719C0B,&H4282F6B4
    DATA &H743936EB,&H1199D748,&H930002CF,&HC6D45B33,&H74885E2D,&H8BF51579,&H324EFF24,&HB63459CD
    DATA &H5F4343E9,&HE5FCC6AD,&H9FA1BEA9,&HBE3709A9,&HDC1B4F2A,&H94F4DDA7,&H5C0E3DF5,&H33FD37AB
    DATA &HCAF6172D,&HA7E8CE7E,&H17594211,&H3DBE0A61,&H47B9A3DD,&HE59AF7CF,&H4B785D5F,&H48540A75
    DATA &HA7CB69B1,&HF6E8D178,&HCED6A84A,&H50E9B1C5,&H9C9BF9D1,&H7B0E2033,&H4D3A8014,&H57C17174
    DATA &H9D85C3A2,&H09EB8FA2,&H7E23777F,&H9537A1EC,&H09699A6A,&HB933457C,&H79959FC7,&H07E6BFE0
    DATA &H034DFFAE,&H6ED83A6D,&H7ABB124B,&HD9F56A7E,&H0B09A14A,&H1E452CAE,&H37461A9F,&HB1702195
    DATA &H924E1FF6,&HAD5DC41F,&H4B58A768,&H601D6F1B,&H68E07276,&H87B51462,&HD6CC2941,&HD4ECEC7D
    DATA &HA3CA0203,&HE43E67F7,&H408F1B24,&H6170F53E,&HE23AA03D,&H90E9D12E,&H2B906687,&H5F5B3569
    DATA &H52B61C54,&H403A14AB,&H4CCD2A9F,&H8A3D50D0,&H37859648,&H343E7AF0,&HFE30C243,&HA3C9F748
    DATA &H18C04833,&H3EC98435,&H5EFDFCCC,&H7A4C0AE5,&H5E7C9F62,&H498BF425,&H9664E56A,&H0AC42A4C
    DATA &H269E0057,&H50932212,&H60DCD6AA,&H97C137A9,&H90B6D13B,&H325135B6,&H9B8FCE3A,&H70026AFE
    DATA &HAA359FD4,&H1BD6DF13,&HD9F96EDD,&HD4F11794,&H775D3588,&HB134B973,&H83D0C059,&H4087474B
    DATA &H9227D314,&HCE48210B,&H1C5D94FC,&HAC390C47,&H69C237E5,&H14210AA9,&H4EE2E09E,&HE6C98FA1
    DATA &HFF5DC38E,&HEE918ED9,&HC6B55AB1,&H8BD73312,&HBA2559DC,&H39FAA3C1,&H38130974,&HC2E96E3C
    DATA &H99CCB82A,&H2A2E4D43,&HE393F684,&H518F6962,&HFA04644E,&HEF3A4D63,&H58204277,&HB97B0557
    DATA &HAA1C3FF2,&H829F0C29,&HE2E8D674,&HB9B624CC,&HEABD7064,&H7F63E726,&H468B2FF1,&HE6C2C734
    DATA &H7BA33D4C,&HAF8FA82C,&H02EFFC35,&H30221FED,&H25E9A7E4,&H7AC2A912,&H50397874,&HBFC5663E
    DATA &H19C4E8F1,&H6F8388CB,&H1099F26F,&H656D06E4,&HF93318A5,&H20D74D60,&H9F20DF47,&HB98FD198
    DATA &H614F8FBD,&H2F5297D8,&H7B30964F,&HB2E87B5A,&H2FDA38D1,&HFF08F1B6,&H39C300EE,&HB3967E40
    DATA &H330365C3,&H1D772BC4,&H2187E184,&H8A46203B,&H385D8CB2,&H252BE5C5,&HA3271BA7,&H2F9FDFEF
    DATA &HCC212046,&H707AE9FA,&H524AD11B,&HD8C7C8E2,&HD6AF6A87,&H9B6DEF9D,&HB4EE7C6E,&HCFE77FC3
    DATA &HD83596F6,&H52322D49,&H5E7C6DEB,&HC454BB96,&H793E3FF0,&H35F75195,&H2FCDE6AF,&H7661C56B
    DATA &HCABB053D,&H54749FD4,&HAB16103A,&HE57825D9,&H0AB97E54,&H4C9E099F,&H59BEFD00,&H40D108A2
    DATA &HA59D8775,&H448227DF,&H14C17205,&H6ABB328D,&H815556ED,&HC982FFA6,&HE48D7E6E,&HFA1843B9
    DATA &H726DD4CD,&H252CBF9B,&HCFE5BFE7,&HBF0F9525,&HBE7D669E,&HD9E18AC3,&HACD80AC5,&H15665055
    DATA &HEF70B242,&H79E61312,&H53BEA0D3,&H6523EBD5,&HD3BF8546,&H331B3228,&H3E9BCAE3,&H2548BFA7
    DATA &H0B3FBB08,&H7E801200,&H62153A99,&H5FA5AE8E,&H0AEE50F2,&H752CBE05,&HAE322A52,&HB149BB74
    DATA &H4D4B97D2,&H2782BE07,&H7839468E,&H255FC556,&H4C0C04F4,&H48B005A2,&HFE1A7DC8,&HEB3A1CF1
    DATA &HA8FBCE49,&HB1D807B1,&HEFCF82B8,&H467D0020,&H6EED05D3,&H39929B7F,&H89D3BA7D,&H8FB1C02C
    DATA &HDB9DAB8C,&HAD69D2C0,&H98FFBAAC,&HE2B51BBE,&HF3E0E3FC,&H86DFA56F,&H4864B2F3,&H078643F5
    DATA &H77623BCB,&H2D8B6086,&H5077A3AE,&H454E76B2,&H40EFE072,&HDB1F4002,&H1290CDDB,&HFDCEE72D
    DATA &H03233BDB,&HC284CF08,&H9428E31B,&H212CDFA4,&H1BEE1F00,&H58D82D3D,&H7862951F,&HAD4B67A9
    DATA &H96FE4879,&HE83C067D,&HDD0AB78F,&HD875BD47,&H207283EF,&H0A96B682,&HD26821C4,&H2DA368A4
    DATA &H30BC2700,&H41A92C50,&H508941D9,&HF7319679,&H1B91ACC6,&HE4EB443D,&HF2292B7A,&HBE7846AB
    DATA &H3AE42E19,&HD4341E8E,&HD12D0997,&HD0CC6CD3,&HEDA7FBFB,&H078FD9EE,&HD14BCACC,&HEC242C3E
    DATA &H93376CE4,&HCAF4F528,&H998AAF0D,&H49BF83F7,&HABF16D30,&HE4B7CE37,&HB14C3BEA,&H87723677
    DATA &HE270A503,&HDBFDEF2F,&H908B3DEE,&H67EF235B,&HEFE2AF71,&H5F7784B8,&HABEEB70E,&H389527BF
    DATA &HA47857B8,&HC9D3E3A2,&H6F398CA1,&H3ED7A3A4,&H348DE173,&H769D8FBA,&H7616F95C,&H01D24427
    DATA &H87B61ADA,&H6E97404E,&H02A46EAD,&H7BE4CB80,&HD276A90E,&HC795DBDD,&H4A78F79E,&H492AA9E1
    DATA &H9CDC8904,&H37592ED3,&HCACC99F4,&H796E31B0,&HCA7A7B69,&H24D02D5D,&HAB3758FD,&H29BF9C29
    DATA &HE07A0A14,&H83AEE597,&H6E63E289,&HC88271D7,&HAF3A4FB8,&H2BD8ECFD,&H4A273C38,&H57F9C15D
    DATA &HB21CB818,&H28663A33,&H10E08730,&HE1E29351,&HEE416160,&HDCADE8AB,&HA8801522,&H6EF24B87
    DATA &HED4D9925,&HE655FA85,&H5BCB55CC,&HDE3E4CE3,&H4BF5ACD6,&H57F0500D,&HFCE6B663,&H4F8EE510
    DATA &HACF96294,&H67BED10F,&H4A5257D1,&H699747B0,&H99271D78,&H80FF89EC,&H242929B9,&HB565C373
    DATA &HD868612B,&H829021A3,&HDEFBDDA1,&HE7677CDA,&HA54079BE,&H7D61B7C5,&HAEFBD2AB,&HDC6F87DE
    DATA &H8D1AB9D8,&H8E349F4D,&HF254D327,&H7CC85A8B,&H31CEB6F4,&H32CBB468,&HDE6109EE,&HF249B92F
    DATA &HE49E34BB,&HE2BBB94E,&H60A19AE5,&H21DDA759,&HFB6DF7BF,&H19AA5085,&H58417E8C,&H32DE6D64
    DATA &HE7D20AC9,&H13E4FCBD,&HCF656BFD,&H5AF50C32,&H76E758DB,&H3FCD8F61,&HC7EE3103,&HE13ED9EC
    DATA &HB6B8D13E,&H4995372F,&H25BFBF3B,&HA55EEE3A,&H70CA251D,&HE690E57E,&HA2ABA650,&HD2AE8C36
    DATA &HC09DBC4B,&HF7C3059F,&H2FDA56B2,&H412E2128,&HF09FE671,&H320518C3,&H88E3AF18,&H98705343
    DATA &HB1497BCE,&HD40DD819,&H15974897,&H8B5AFBD9,&H218A6A26,&HBE018090,&H4BE307A7,&HBFAF3D52
    DATA &H69BB921D,&HB1D48AFD,&H8DED1323,&H35E4252B,&H01C9DC09,&HFC00C411,&H4740DD70,&HBD73E8BC
    DATA &H20E386CA,&H31EF88C7,&H20B148D5,&H9FD0A338,&H4182A619,&H38372361,&H123917E0,&H47C01F18
    DATA &HD3BEC8A4,&H4FF0BF5D,&H1AC43F1E,&H22AA8F25,&H9B9DF46C,&H29BE8E2A,&HF1186F6C,&H76252FDF
    DATA &HD741F16D,&H6B720BA2,&H7692898A,&H8FDD5032,&HA30BD001,&H9F777AF9,&H047F582B,&HC19FF36E
    DATA &HE40ACF1A,&HBA105506,&HD4D8218A,&H01D241B1,&H3C9CFDE5,&HC4894241,&H8FEFB1F2,&HA6B01633
    DATA &H1D7AEB8F,&H56349AC7,&H24CCFC9F,&HA602F9BC,&H6B217DA6,&H072C8038,&H70139D97,&H9B7B65B0
    DATA &H62AAAACB,&H67359750,&HB1BA950A,&H58E4C0A4,&H089487B9,&H4175B2C7,&H5BE1D3A5,&H52995CDC
    DATA &H76507B15,&H6FA130CE,&H4474CB2C,&H1F0B7179,&H79A5CCE6,&H11A67E8C,&HDB0041A8,&HBB634F60
    DATA &HCA800F7B,&H4C649A3E,&H807E837E,&H08933CDF,&H5580456F,&HFF0FE7FA,&H4A1ADE5B,&H9BA42A15
    DATA &HFE96F55A,&H1D4531F1,&H8442CF82,&H258D838B,&HF3AD5C1F,&H673BBF34,&H9F5B9795,&HADD0B177
    DATA &HF1195EE8,&HE636CD2F,&H2F08C92F,&H7EC0F656,&H28AF54C2,&H9627031B,&H5C8EE9C6,&HB02F5CAE
    DATA &HBE3E614C,&H79AF3C6D,&H81C2ED22,&H92269FD9,&H5E1D04F1,&H08BE27FB,&H2BC5DED8,&H549D46B6
    DATA &H1F3B1153,&H4E4502A3,&HAB9B9413,&HC58C2F6B,&H5CF3F8FA,&H53C0D2E0,&H73AE73F8,&HA6AE0AA4
    DATA &H32DCC0B6,&H4D37EA6F,&HCE1FFEC9,&HF115112B,&H93A6A37C,&H893217FB,&H880D0304,&H833A24D9
    DATA &H637EF614,&H0F9E7CD9,&H633E88FB,&H83A79561,&H8538EBE8,&H2BCB6142,&HD144F3D7,&HFFCEBD37
    DATA &HBA37FFED,&HB33F3BC0,&HAF5D7E2F,&H329ECBDB,&HFF5ED1CC,&H23795485,&H129A9F83,&HFD358D8A
    DATA &H2DD907A1,&H0186896D,&H814039C4,&HF6B45F53,&H1CBF5071,&HCC5B7500,&H9CBD0F96,&H66DBA66B
    DATA &H85FA090C,&HF63538EF,&HC4530991,&H2747C746,&H9289E662,&HE2513914,&HB6170BE0,&H29830A8D
    DATA &H4948CD03,&HDE3B2B3C,&HAE8915FB,&H0A6E78E8,&HE8A24775,&HACCD5FFD,&H1EE0EE64,&H80CE9EB3
    DATA &HDDDD28BD,&H09F8ED3F,&H5B111FD5,&H60915DDA,&HD4017117,&H7EEF8F2C,&HA860035B,&H2CA00D54
    DATA &HD24EB9BC,&HEFA599ED,&HEE878E47,&H43D6C45D,&H9A1B7A1F,&H0A25F461,&HBCD71AA4,&H4866D89A
    DATA &H4DFF2DD3,&H1C21C205,&HE31F5D72,&H49B1210B,&HB366F98D,&H93E92DEA,&H8B4FE0DB,&HDA88DCFD
    DATA &H2D3C0D31,&HC5FF5327,&H48374029,&H12827403,&H9FD9F375,&HC2F706DD,&H0BC77237,&H8B3F6A45
    DATA &H393674BB,&HE90D5AAA,&H0CECD225,&H4ABD1E43,&H2ADA0C69,&H76D02E4B,&H9E72E8C5,&H08C31690
    DATA &H9B95B8CF,&H11FB6071,&H05A7F3B0,&HA648734A,&HDAAF7981,&H3146B876,&H162B8C1C,&H74379B3E
    DATA &HDB2A2329,&HA41B6969,&H715A07BE,&H4D9B18B0,&H1ECC6EFC,&H2937329C,&H4F427CD4,&HA5147E15
    DATA &H7CB7B114,&H2DB8723B,&H545F4F6C,&H4FA9F2F5,&H77BD1979,&HC373CE14,&HDE7AAE27,&HFD980AD2
    DATA &HC79907A9,&H9C55CE21,&HB9505956,&HC9B70A6E,&H4252D8EB,&H8CCC9C2F,&H4CAA81CA,&H628E8057
    DATA &H1577EAAC,&H7B88D96A,&HF472D9F0,&H2A421BD8,&HAD144224,&HBDFA3D68,&HC625D1C1,&H7BC8DCEA
    DATA &H6FBB9A96,&HF482E354,&H2A7CF7BF,&HDDF45278,&H70A93FEA,&HB33606F0,&H25FA3272,&HAA7BA98E
    DATA &H78312B16,&HD63C8C21,&H899613FF,&H325FA404,&H3C888C48,&HE6B06E39,&H970B3B24,&HE6AE3D86
    DATA &HA3988E9D,&H11E3F8B6,&HCD737F03,&H66B7D898,&H3F0E8B85,&H62CA72CA,&H1BD9B939,&H143BC71F
    DATA &H37955714,&H7A599709,&HECFE7F71,&H9741FF97,&HA7AD863D,&HD243E432,&H8FB56C31,&H11786BE3
    DATA &HB60450B3,&H94AA6E6E,&H9C75CE8B,&H6B6FBE24,&H074CF013,&H7DC8C708,&HF531E546,&HAD8F149A
    DATA &H1EE3AB6F,&HB4704DAE,&HC4A17CEC,&H4D6C73E0,&H6D90DE00,&H1B1535FC,&HEEC42E0E,&H42721B44
    DATA &HBF29B8AC,&H04371BBC,&HEAEA79A0,&HA7355DA8,&H69DB9F29,&H0997AE60,&H60CED3EB,&H033FA834
    DATA &HE1B529FC,&H9AFC6D6D,&H93B9EEF7,&H3EBFDA54,&HD319ADF1,&HCE2920F9,&H956ECA06,&H74839787
    DATA &H0D165DE0,&H5E8EA50D,&H95970A7A,&H77165357,&H7786CA70,&H98AE7CA8,&H1C947945,&H4BFAC8A8
    DATA &H0A74B96F,&H4907B5E4,&H1CF73280,&H10A8107A,&H0C8AFF69,&HBBB72524,&H1123D5C2,&H5D00C364
    DATA &HCE3BC527,&H7F0DA84B,&H56CB3080,&H8466FF1B,&H92282FD1,&H406FFB66,&H831B954C,&HF1940D23
    DATA &H43084373,&H70C49792,&H943E4935,&H097A5BE1,&H1B357125,&HFD80E849,&HF22123B8,&HA14E9A8B
    DATA &HE1555818,&H11371229,&HFCBC3231,&HB8185BDF,&HA35BCF3A,&H1014165F,&HC1B7783E,&H8F5CF1B6
    DATA &H5BB57BFC,&HCC20E78F,&H47E21E54,&H3FC2C792,&HB76A3AFA,&HFAE1FFA4,&HF35B4627,&H4D8D1A8E
    DATA &HFEF65F7E,&HD3AD3116,&HB97C4597,&H8DEC8D80,&HE6402CDE,&H5FD244CE,&HAA8DB5E1,&HEB97742B
    DATA &H5DB15648,&H3177C8A9,&H7F727B48,&HAAD2F1D7,&HA9D3FDF9,&H89E65A19,&H997B428A,&H0EC73917
    DATA &H049594B5,&H594D2FBB,&H1B610FED,&H9C7E13BE,&H353D4BB0,&H640FD974,&HE07E662E,&H39F03D0A
    DATA &H356A4B45,&HB9F2BB1F,&HCB838AC8,&HB0305B2F,&H0500F2BF,&H74ED8285,&H690F69D1,&H3DB142D1
    DATA &HC1085A60,&H4AE76087,&H0A9247DA,&HFF4DCB55,&H14D0AC94,&H50EA71DA,&HC62DD18D,&H107A9535
    DATA &H84B8AFC5,&H61310857,&HD2EAE90E,&HF9AC17D2,&H1CF2413B,&HB3E83FFB,&HC34C5B90,&H5C18B1A9
    DATA &HBC1E2D0F,&HD812C1C2,&HC1244A35,&H91A6C18E,&H6AD1C40A,&H41D931F1,&HCDA3755E,&H14A9D892
    DATA &HF529E4CF,&H48A9CC5F,&HBBD3139D,&HC4D58648,&H97669594,&HBC27B3A1,&HE02B6E2F,&H04E1AEB2
    DATA &HBA93F3E7,&H1F6AA92F,&H9CD43267,&H33BC5A9F,&HD29FBD34,&H1EFB795D,&HDDAB0C75,&HE6BA4D73
    DATA &H578A062A,&HE0AC3E18,&H955AB5B7,&HD84864EC,&H482057BD,&HF24FA549,&HAC5FDFF9,&H3AF85DB6
    DATA &H054F9C3C,&HBCF21818,&H33FABEAF,&HBEFCE0D3,&H6C5243D5,&HFCA2B7B7,&H118D88C1,&H4F60D82D
    DATA &H84F09D2C,&H162CB97E,&HC4BECE79,&HD5F7A297,&H566EB334,&H42CAD4D1,&HBE667646,&H49FF53A9
    DATA &H42C5EC0F,&H26FD6865,&HE3FF1FA4,&H66D5FFFB,&H9685D6BA,&H1754165F,&HCD3CEE31,&H82A5016F
    DATA &HD65ADFA9,&HC7475D65,&H7ACB3DCE,&HDDD4B183,&HC2204CF8,&H87387826,&HC40BFAA1,&HA620E879
    DATA &H20C6C73B,&H90085D0E,&H97E28431,&HB043C07F,&H15D5D5B2,&HD009661F,&HE5615DA1,&HF131C900
    DATA &H5491C1F4,&H6C4DD53A,&HAC12A9AF,&H59D87C7F,&H495DD3FF,&HAE26468D,&HF1E09443,&HC82EE741
    DATA &H5F630109,&H1F08C582,&HB7F63A7C,&HBEFE68F7,&HD4697370,&HE418C755,&HB6C3441C,&HA7115878
    DATA &H40BD97BE,&H34296A87,&H5C05A3C3,&H50019BF6,&H3D33D0CD,&H828E0C31,&HE1CF7D93,&H31C7A7CA
    DATA &H752F9DF2,&H661FF785,&H2F5DF642,&HE3AF33C7,&HFAF543E8,&H94CFD179,&H0456BD5B,&H7588A9A2
    DATA &H4D15475E,&HAE6E0DED,&H6C815362,&H7850CBCB,&H7CBA1961,&HB9E0B437,&H43CE382B,&HD8B3D400
    DATA &H1E83E4AE,&H5DDFD71E,&HEEE9BE05,&HA286AD80,&HFF7A0CD1,&H32E204AC,&H6E9A828D,&H4358C447
    DATA &HE6C88EEB,&H2624BD2E,&HC1447517,&HC403FB11,&HEB4F6606,&H58B45500,&H69EC9236,&H561CFD74
    DATA &HD6D10E8A,&HF45A5DD5,&H36053CB6,&H65B03071,&H71B5089D,&H3B07AE16,&H4B60946A,&H82286026
    DATA &HDA793551,&H7A615699,&HF1D21980,&H942EAEE6,&H7FC973F7,&H18C0BAAE,&H81B175DC,&H584EC31D
    DATA &H26E13D06,&HF379873C,&HD5A74297,&H03A41283,&H1BDDC0D2,&H589F5FE7,&H5F7637DC,&H9ED3F072
    DATA &H12D876DC,&HBB9F9B40,&HBD32E675,&H7E4A620A,&HD9D724A8,&HB153CCF6,&H875FD2AC,&H6F01A421
    DATA &H064B9170,&H9113A64B,&HC7C07103,&HAAE88625,&H6616B0CF,&H05F1599E,&H303561FF,&HBC86C358
    DATA &H1AEE8BD0,&H64ADBDB7,&HBAFDCB08,&H42D9F5C8,&H665A6BED,&H9BFF8A4D,&HDD4C323E,&H7892FD26
    DATA &HB1489401,&HF9CF5623,&H60EDA177,&HA1E662C8,&H737219C9,&H82C92F50,&H497E3566,&H6DC9ADA2
    DATA &HD92BBC36,&H5DB17C9D,&H9DF1D1DB,&HD8AA693E,&H4ACBDCD4,&H491F8E45,&HEF5FCA34,&H66BDB789
    DATA &HC31DF1E4,&H4FD5CE2D,&H77D1F732,&H3629CAFD,&HCAA2EB3A,&H80DC5362,&HB04443DF,&H336CE180
    DATA &H6FF19677,&H65B1CDAF,&H76C043A9,&HF5B52707,&H3787EBAB,&H9F3829D6,&H260DB8B2,&HF7631B13
    DATA &HEBF93F19,&H6004D19B,&H3DC3A7D2,&H49EFAE44,&H50479650,&H05510060,&HB91630AD,&H2FE7E82E
    DATA &HE061FBF7,&H03CC4B80,&HC4A03E06,&HFC5A59F1,&HF8475F23,&H0BD19FC3,&HD8B39E40,&H51075191
    DATA &H71E3FDB3,&H5CFE8321,&H6FDD13CF,&H6E0779E0,&H388D16CF,&H4D7C8ADD,&HEA241E70,&H9008ACBB
    DATA &H1FB0D578,&H444D70A8,&H80ED4297,&H5157D3C0,&H9688E02D,&HAACB8007,&H16050867,&H17B700B2
    DATA &H61035FC3,&HB04CA677,&HF7319E1D,&H847CE43E,&H29116F73,&H4C8F25AD,&H7A9BE5B9,&H8A55D6AB
    DATA &H1A2935DF,&H0E7E5733,&H93B410FD,&HD0DF957A,&H2D13626F,&H20C01437,&HFDC92801,&HC7DB2F4C
    DATA &HD57F9570,&HFF780187,&H666D66A5,&HDCEE6D59,&H733D79CD,&H9A6E5607,&H440EC10C,&H0BA93286
    DATA &H20E71959,&H0CE8860B,&HE3D77D54,&HED3EE6E6,&H7683B16D,&H168360F9,&H62AC10D4,&HCACD1FA3
    DATA &H55807AF0,&HF31B5A53,&H9741F9BE,&HB20C267D,&HA8CF1B06,&H41500A2B,&H63DED0C5,&HF875E8AE
    DATA &H2C696CF4,&H71930558,&HB8A36E60,&H6AD10210,&H83231157,&HB2A2C03C,&H33024D84,&HB396D8FF
    DATA &H4E09D391,&H161BD062,&HB433C88F,&HAEDB735C,&H2F85BF5F,&H2F63437C,&H32AAF7B3,&HC0200AB0
    DATA &HA3D3B729,&HF2E28963,&H38EB80D3,&H3E736471,&H83296773,&HC923E93F,&H685365B8,&HA7CAD5EA
    DATA &H782149C8,&H04C4F844,&H47429058,&H6C8B32FE,&H0F4E5E87,&HD759D97C,&H4B128180,&HB9A97D2A
    DATA &HFC50A881,&H5D5A74D2,&HAA1EBCDD,&H31597B99,&HFC8E5E9F,&HC190EC5E,&H1498C8AB,&HBF9702A3
    DATA &H9242CE2D,&HD3A8606A,&HB013FDC9,&HE5A1737B,&H59364E3A,&HF9FAD757,&H2A6C2E63,&H85785A81
    DATA &HB8EE4C5F,&H23FA0778,&H53E8DABC,&H1EFA209F,&HC1FD9078,&HA0740DFD,&HACD34422,&H50968227
    DATA &HB60EB7D4,&H14FB5F06,&H5D603543,&HB2907F24,&HA53EDCF2,&H6074449B,&HC5DBEDAD,&HBB1989D2
    DATA &HEEC6886B,&H2F909987,&HFE65F7F9,&H7BCDDE56,&H91259EFB,&H63E30528,&HB6182556,&HF55C07F6
    DATA &H6D07D789,&HDF7EDBDF,&HA86633F5,&HE821D7E3,&H0B17FD90,&HD1CAAADE,&H5009B495,&H72D33C81
    DATA &H85AE0DF0,&H2872E107,&H5C0B7330,&H9400265E,&H7A1307AF,&H19EC0B71,&HA2C6A356,&H74343975
    DATA &H066D062A,&HE258DA4D,&HC325A3F5,&H357E4295,&H7E4DF040,&HBDE66326,&H5171146A,&HC07BD782
    DATA &H24E57086,&H9B925C42,&HC1516936,&HDF5B0F7B,&H693DDFC9,&H32C9D5B1,&HB4A64F82,&H7B2FDEB0
    DATA &H270933BE,&H5D5F8283,&HDA9AE8F5,&HEE9800A3,&H57ABD57F,&H47A888B9,&HE164F56E,&HB4DB1083
    DATA &HD19F4EBA,&H2D81BE79,&HAFF0BC41,&H72BE03B2,&H4FDE9FDB,&HC21ECE25,&H1884E9D0,&H54992C3E
    DATA &H8299DD3F,&HC092EB72,&H755C2E98,&H89EAC7F0,&H27F84FEA,&H6DD453A2,&H943DE656,&HDEC3A5EB
    DATA &HA15DD93E,&H9683368F,&H7DEB98E0,&H74383553,&H10EFF489,&H3BD82CA5,&H9C152DC9,&H250276E4
    DATA &H7FA93A6C,&H45164984,&H3A22E70B,&HDF54984C,&H5D3E48DA,&H3B39A97E,&H4624695D,&H0FEB711D
    DATA &H8CFE4E66,&HCEFF4CCC,&H2E635419,&H21FDAB44,&H7EF8CEFA,&HE81ED551,&HE26B04A1,&HC460151B
    DATA &HBFE4D2A7,&H65020458,&H3906FBC2,&H7B3DDA5F,&H11A06E53,&H6D7DC0BB,&H3727CC13,&H0D1CA542
    DATA &H87BF8489,&H74109B7A,&H52E01921,&HA26B25E4,&H455BE3D3,&HE232F408,&H7758F058,&HC5D7B2F8
    DATA &HBFCD41E6,&H5D01E07C,&HF8877F42,&H32EE36E3,&HA130032B,&H26B1FEBA,&HEE5D7E54,&HE147E790
    DATA &HEEB51F68,&H01F15292,&H2D43246B,&H2BF8B394,&H37070429,&H0531595A,&H52B1E0E2,&H5852C1A4
    DATA &HE7A73088,&H1F10F9A7,&H69FBF5C1,&HD8C65B45,&H28953167,&HE8FA7513,&H0126491F,&H3BF2FD4C
    DATA &H1C9A74C2,&H250D352E,&H44FC31EF,&HBDBEEC72,&H8C8B1D6B,&H596E0B90,&HB373FDEE,&HE80F43C5
    DATA &H41888EFA,&H02FB3BC6,&H85B711FF,&H830BB0BE,&H314D72B6,&H4169C9FE,&H55AE724E,&H3CDA1F19
    DATA &H0D2F81DD,&HFD723B8D,&HB44A2A3F,&H46654B4C,&H60057E46,&HE91BA19D,&HD6EC3724,&H54DFE4B4
    DATA &HACBF46DD,&HE93DAE59,&H15BA3C56,&H47F18315,&H5CF4154A,&H2659009B,&H77D14D10,&HBFA44F5F
    DATA &H32BC1993,&H152F8B7F,&HF7B9C5AF,&H25EAFBDB,&H6DFFCAFF,&HD32BD7F5,&H3D8012D1,&HA9157973
    DATA &H0D2641D7,&H1A746E90,&H34A4230F,&HEDE7AB01,&H8A0037D4,&H9F580053,&HEAFD639D,&H3172D41C
    DATA &HF72E0E01,&H919EC1EA,&H0407EB0A,&HCBEE5A0A,&H9F8FF1CA,&H76C36848,&H871483FE,&HF3F3E0F6
    DATA &H62969AA9,&H558D5ABD,&H3C7BAAB5,&H8943331C,&H1B0F0486,&H17DEF425,&H823D2C77,&H6EE13B28
    DATA &H84292678,&H02FBB0AA,&HEFC107A6,&HFF828723,&H5A75A3F6,&H97105556,&H9180EC0F,&HAC2AA8F6
    DATA &HB08BBF33,&HD0D00108,&HAF5AA4AB,&H63EDC6CA,&HC772CE05,&HD2BDFE31,&HE21479D7,&H0718D838
    DATA &H00171A3B,&HC143C72F,&HCAC46758,&HD77FA447,&H320EBEF3,&HFB90DF86,&HFE070C80,&HC37500AB
    DATA &H8DCCCD0C,&H44D4BB96,&H619C2187,&H55EE27E0,&H425B9BDF,&HC24278DD,&HBBE82E06,&HF85EFE49
    DATA &H2A20B647,&HDDBF6606,&H62E43622,&H5D189589,&HC1628833,&HFD0D57D2,&HEAD963A7,&H68D34117
    DATA &HF6ABEAB4,&HED70DB7D,&H18F3A326,&HE81A30F2,&H7B7F2649,&HEEEBB7C0,&HA535A599,&H675808A3
    DATA &H56B6594B,&HD0406E16,&H42EDFE7B,&HFECD1D64,&H8C09579A,&HA938148C,&HCF853687,&H9A7D9D02
    DATA &H51619E61,&H8C1FDDFD,&H15A0EF3A,&H6CAD7115,&H0116F539,&HCE938B37,&H62FE1707,&H95543FF6
    DATA &H81E84C17,&H0C8D66F0,&H03F8E886,&HA9C71A8D,&H81EFB472,&H08AA9345,&H31308FAD,&H6B4B08EA
    DATA &H7AB6DCA1,&H65F894AE,&H94DB10BD,&H71D1F30B,&H20EAC151,&H8181BA9E,&H8E2DD6FE,&HC950650E
    DATA &HE49429B4,&HA67B4E16,&H9C54D0F4,&HC8B15ECF,&H3BFC4BE4,&HF7F61B5B,&H7BB18FA2,&H15B23D70
    DATA &H97CD7B31,&HF7439FE4,&H9234BA0D,&HDD2EA11D,&H120E0F75,&H1DC6D9C1,&H44C0EAB9,&H60489400
    DATA &H5900AEA7,&H6E8B9071,&H3EB587B8,&H425178C2,&HA5BBC5B9,&HE2A99976,&HE2AF01D4,&H90E58E33
    DATA &H7CAF3CD9,&H0EF25E31,&H5F13A8A9,&H63466020,&HDEC3FA9E,&HB276155E,&H56AD3B70,&H5769F6D7
    DATA &HA7FF855B,&HE3AEF77B,&H447322BC,&H6FFC406F,&H53E67E37,&H93BC9D34,&H8A0DB9A7,&HC4343EBD
    DATA &H09FE53EB,&H3E9F178D,&HA32A5BE1,&H4CE6689F,&H8393DEDA,&HFB8DB59B,&H5F7B3BDD,&H1EEEF158
    DATA &H52517C81,&H47FE02C4,&HF55C7361,&HC51387FE,&H5932C9DF,&H1AED2562,&HBBDD0926,&HD8FA605A
    DATA &HF6A20AA7,&HCBE85969,&H8015CB96,&H52C4FFD9,&H9EEEC139,&HBCB78751,&H32FD6AFF,&HD631F1F4
    DATA &HE51FFEF8,&H86E1B905,&H55746F65,&H23960D2E,&H60F1A41C,&H754A2D3F,&HAFF89858,&H87DB8D4D
    DATA &H7B3944DB,&H774CDC70,&HA6485231,&HECD182A6,&H44F4CEB7,&H57016CBB,&HA5F4D07F,&H3D335FBA
    DATA &HB2709295,&H9ACCB53A,&HDF649362,&HA3747B6D,&HA7C60537,&H921A0E3E,&H4D6207FE,&HFEAC9A90
    DATA &H6CC86718,&H433E0886,&H76955BCC,&HF3B6BE03,&HBBDD864E,&HBB4A4FF8,&H638254A2,&HD5728503
    DATA &HBF8855DB,&H548FAE15,&H2D4FD88E,&H5DA90721,&H367B8709,&H9A240904,&HBDB90D03,&H20D95BF2
    DATA &H4E4B47A0,&H9837EEBD,&HC83BDA10,&H6C076B07,&H417B302E,&HE63A92F4,&H3BC2915E,&H67E47422
    DATA &H0F6D1A92,&H18DE1D5B,&H1F555159,&HC24685D6,&H2F5F1937,&H7B1815BC,&H4DA2999F,&H1E3C9FB6
    DATA &H5D406569,&H6BE9595C,&H3954F266,&HBE653CCA,&HEB55B79A,&HBF92BF58,&HDD18ECC2,&H468FDC71
    DATA &H9FD6D3F0,&H514735D4,&H8F81220A,&H65CFBA1A,&HD5F7966B,&H992C904B,&H57F6EBD4,&HF27F8301
    DATA &H0C9D5E29,&H1B70C640,&HA2BA0DDB,&HD9EF6360,&HC0FADFD9,&HCBD3EC2E,&H3BB9E364,&H8D66AB22
    DATA &H96CCEFA7,&HD19CBDA6,&H33B9F3CE,&H970A1EE9,&H382AF42B,&H4705F637,&H9A6928D6,&H5F3ACE15
    DATA &H582700F4,&H9E430171,&H28CD5AB5,&H9D6480AD,&HE375E5E5,&H01E928E4,&H91DB3B65,&H60A12370
    DATA &H2D3E0C37,&H764228A7,&H34F5BE42,&H1DEA8DBE,&H204087A0,&H01BB144B,&H92262D50,&H3E7A6CA4
    DATA &H40A20E89,&H9FFE6381,&H43DEC5B4,&H81F94EBA,&H199B3D65,&HF9362AE5,&H6B41B3AC,&HAC6BF7FC
    DATA &H97CB8CDC,&HFE1B15BA,&HB1FE7FEB,&HB45BCFCF,&HDDC3B140,&HA8FF364C,&H6908D96F,&H3BF5DC1B
    DATA &H6D6032FE,&HE306C866,&HA34F507F,&HED784514,&H3D92DDB3,&H6FC3FE13,&HF7DA01F1,&HA934EBA9
    DATA &H9CEE5273,&H98577590,&HF4B63898,&H428CCDA6,&H5BA353E9,&H8A97CDF5,&H2E7E1B25,&H0FF5C425
    DATA &H852D9DF9,&H54CA8D1D,&H6984FB0D,&HBE8A7DA5,&H7EC5A478,&HB0D1F00A,&H36D4B3AB,&H59FBF473
    DATA &HC86DB3FD,&HA16324E3,&HE274DAB8,&HAB27C62B,&H796DB054,&H6EAAEB1E,&H5EFB0F8B,&HBF9DEBD7
    DATA &HA393B974,&H15982E94,&H750CF6DF,&H72A85CDA,&H0567D3A9,&HEF2E118A,&HEF838CB2,&HB7CE3CC2
    DATA &H1E196CB6,&HC516AA6E,&HE876AE4B,&H1A046DE0,&H706D6EBB,&H39B98E10,&H266B0258,&H8A3CE8B7
    DATA &HFE7FA71F,&H4A43037C,&H13F80B83,&H318FE3AB,&HA28147AF,&HBCEE8D8D,&H2B5B149F,&H262C19D6
    DATA &H84F0F50C,&H18FB387B,&H690BE0DA,&HB50595E2,&HAADD09A6,&HF0983EA7,&H28EC8D32,&HCDBA6919
    DATA &H1FAA9E74,&HBBE59115,&HB49FBEB5,&H1D76DB00,&HA18690A4,&H1A04D68D,&H5F5AE185,&HCA600268
    DATA &H90E1FEBE,&H4A4B9AA8,&HCB128525,&HBD994AD2,&H92D7C11F,&H147EEBF5,&H774DA1AA,&H0CD3D5C6
    DATA &H81329900,&H932D94C1,&HA6E9ACA9,&H03CE9D1A,&HD90E625D,&H9A9126EA,&H5AA53B17,&HE0E7DC4D
    DATA &HB1C9FCD4,&H69BA36EA,&H1EAE5C79,&H0B6012B1,&H8B6863A4,&H1577AA7E,&HC0FE9E27,&H9D7215CB
    DATA &H1044329C,&H419C2043,&H1B816CC8,&HF02EBE8F,&H84B71DCC,&H5775C6B5,&H163FF460,&H87461A64
    DATA &H8D833167,&H59ED81C6,&H41C51DB4,&H891E6B7A,&H64351388,&H2FD81CDA,&H7D41A520,&H96BDE903
    DATA &H0A8CD8E8,&H5E00691F,&H69AE89FF,&H245144B0,&HD7510FB1,&H3FCBB45D,&HEF47BBCA,&H545F49BD
    DATA &HCBC01B4F,&HFDAAA2F3,&H0CE13DBF,&H1690B25B,&H526A47FF,&H946712E4,&H4C474DA9,&HFC7FC8C8
    DATA &H9C263A1D,&H59F09333,&H0F0BF4A4,&H3C3AA433,&HDE56174B,&H9DC3637E,&H4E35D976,&HD3FC837A
    DATA &HB05E4E53,&H84E2DB02,&HF2917110,&HE33E9050,&HFDEAE967,&H259E4378,&HF5F4A295,&H43C27A2F
    DATA &H37526835,&HF58C9C33,&H76CE20F2,&HDA978357,&HAAD2DFBA,&H77B96D38,&H945F7F72,&H63ACCEAB
    DATA &H57331653,&HAABE810E,&H0996EFFA,&H23336417,&H90E774C5,&HF906D2EE,&H679FC26C,&H6C6E2625
    DATA &H35CA64E6,&HF41699D7,&HC7BAFF37,&HB9696DB3,&H6A2E0DAD,&HD14416DA,&HF1DC1F72,&HF390329F
    DATA &H523DC6F0,&H738A7297,&HEB2E9D96,&H7211AFA8,&HF912704A,&HACE93E82,&H636838F8,&H10AC2466
    DATA &H6D68CD80,&H4B5F4F54,&HE76F0FF5,&H4F31FDAC,&H316F3ABA,&H36D28654,&H2631B3A9,&H189339EF
    DATA &H0E385CBE,&H631D4F55,&H39018236,&HDD98EBFA,&H0FDABFA0,&HB4CEC6BB,&H407AB7E4,&H5A2AB708
    DATA &H1AD77EEC,&H2BF80F8C,&H9DD439DC,&H39E1558D,&H3E2099C8,&H13B039C9,&HF0AD80CB,&H148DD4F8
    DATA &HA989C0DF,&H827DC4A2,&H23DF3BD1,&H04175BF3,&HE2D8A4DD,&H1EB5022A,&H109E9EEF,&H70727EC6
    DATA &H65AD3132,&HBBAD21BD,&HE34EFF6F,&H8B0D288D,&H46714F31,&HE50548D1,&HA69E8A2E,&H11A01CD1
    DATA &H0FED0815,&H32B469B0,&HD816540C,&HD0C01ABA,&H9DA2E009,&HCB2623DD,&HD3E2B61F,&H3F689858
    DATA &H703355AD,&H0703869C,&H9D28EF85,&H9128E3AE,&HEB5DD21C,&H15575AF4,&HA56FE608,&HE62E7958
    DATA &H1D09F469,&H8BC7C0AA,&H6F6EB74E,&H0F9A9617,&HA7D2B1F0,&H6D33845A,&H9D5DA515,&H84FA54C9
    DATA &HA22A382D,&H67EE5658,&H684CFDD1,&H44A29B04,&HC28E92F5,&H1FFF41AC,&H56793E56,&H250ED4C7
    DATA &H5E1A33AA,&HE3D70454,&H860CB6D1,&H6777AF5B,&H582FF730,&H619A8790,&H5683AFFC,&H524581EC
    DATA &H7BADE10B,&H8C1E2F7F,&HEC288E22,&HBE8915CF,&H729534ED,&HA8DFE67F,&H14046A05,&H6E1BC7F5
    DATA &HE91F66C5,&HE766516B,&H035947F1,&H930DAD1D,&HCF7CBA72,&H7C3EC7A5,&H7B9670DF,&H0DA6F277
    DATA &H794BF342,&HD7C055D5,&H4EFB2D9E,&H1B21B56A,&H7C48BF52,&HE837E30C,&H7B4DDE4C,&H5AD89FED
    DATA &HB6053E5D,&HC5F3CF2A,&H30C3FB41,&H71353597,&H3787BD14,&HBAE09C18,&H6BEF84A5,&HF256A3EF
    DATA &H54D848C3,&H822BAAB7,&HDF382F6C,&H0F533F05,&HDC164642,&H1A40AD6B,&HF538C8AE,&HA5515B5A
    DATA &H4F66BB0A,&H2F477DF6,&HFA3C6489,&HDD87BBA9,&H07C4EC59,&H412E27A5,&H8EF99802,&HD89F55EF
    DATA &H0A49A9BF,&H6507D189,&HDEB711DA,&HC5E7E18A,&H463947B4,&H8BABE7D8,&H123DB38A,&H9CF27458
    DATA &HF03E724C,&H93771227,&H9643EA7E,&H1E0261BB,&H9B975CA3,&H7012195C,&HE11F5295,&HFD9EA3BA
    DATA &H5B7E5FF7,&H0566C561,&H6AABF192,&H01EFA398,&H7EAD3998,&H474076F8,&HF3464449,&H078BFA6E
    DATA &H1F2F7E18,&H414CDAE1,&HD1E409A4,&H269B24DD,&H431BFD72,&H1E7FC9C5,&HAEFDE0E4,&H0F3978BD
    DATA &H1313EABB,&H6E38A42D,&H0046B4DC,&H7C9159B0,&H3691404B,&H8FA6920B,&HCB5F0A13,&H9A9F7AC5
    DATA &HD2E43AD8,&H0C59B511,&HEB17F25A,&H5B602E4F,&HD6EFD3BE,&H6C066AAF,&H213C1CA8,&H823BD78D
    DATA &HCF853EA9,&H9A27E3FE,&HF74C10D9,&HD4016293,&H1A8BD4A8,&H28D3CB78,&H9A54EE03,&H4D7BBC5A
    DATA &HB736B85C,&H745FF01A,&H45362D82,&HF6215E98,&H6E257B73,&H210EF32A,&H6D2D297D,&HA6E41FA0
    DATA &H055AEF2D,&H591ED35B,&H39CF8185,&H4A7E77DC,&HB58A26C3,&H4D45A32E,&H4798DDBF,&HC1EA7C54
    DATA &H1CBFA01F,&H448855EB,&H9B5F9BFD,&HB9A2085E,&H2EAD9B95,&H00B0DE16,&H8E5542F5,&H73618D11
    DATA &H13DD51DA,&HB51EC4ED,&H98E0897B,&H7608B2F2,&HBE01633B,&H2DC28149,&HE9A10700,&H77C53951
    DATA &H7755CD81,&H34383748,&HDBD70001,&H652F0AD6,&H1A024BE3,&H428B6112,&H2DFAB6C4,&HF7B62E31
    DATA &H1202DEA1,&HA278D2A2,&HFFA4A201,&HDFC589E6,&H1A8ED1C8,&H6E3C87AD,&HFA9DEB12,&H69C922AF
    DATA &HD33B8BE4,&H20480BDB,&H96333A77,&H63743A6F,&HA657BDB9,&HC6B4EDC7,&H5AF4EFBA,&H388DD448
    DATA &H5197A195,&H9F3E813C,&H5407436F,&H5AF5F31F,&H5779BF1E,&HF7323B71,&H9CB398FC,&H9DF9CA83
    DATA &HE3838129,&HDB5A776B,&H672A0F50,&HE5DBA71E,&H5C71D7E9,&H136908EE,&H791687A2,&H761C163C
    DATA &HCCF1C59C,&H7987421E,&HFE91CAC6,&H0A628FD2,&H30DD5F29,&H5E52A734,&H30F56049,&HC71B30FC
    DATA &HCB2B4538,&H5ADEB727,&H9FBF151A,&H76FD3F07,&H22FA01CB,&H7473679D,&HB55FC277,&HA0A4DD71
    DATA &H3303FD96,&H2B7B8F04,&H2E139BFD,&HF933F925,&HFAFD5BF7,&H4C71F4C8,&HF282F89F,&H960F58E7
    DATA &H61C410A9,&HD4FF8B02,&HA18DAAD4,&HE49F3E3D,&H85CCAC61,&HF42EBBA2,&HFE73AA6E,&H64CFC82B
    DATA &H8DD3FBC7,&HBFF73FA7,&H18D8572C,&H1E9A7B34,&HC7AAEEAA,&H27520FB8,&H3FA62458,&H742EBD7D
    DATA &HE018B362,&H31DF8363,&H359D4918,&HAA2CFB13,&H9039D532,&HBEE57CE4,&H88B3DD50,&H98E137FC
    DATA &HBD2ACD7C,&H299C6F36,&H538BDD81,&HB3E15BF2,&H2C46D0AE,&HB3E711A7,&H9DCC72B8,&HC4A52515
    DATA &H83F1F1D6,&HD097BFD0,&HC61B58CE,&HEAEDCAB7,&H5FE65115,&HA68D1BDC,&H9D7A2C75,&H84F542A7
    DATA &H3A3ED233,&H7B69B93C,&H701F58FB,&H9F31079E,&HAB3A197F,&HA99E319E,&HF3CD9DC0,&H0A3B549D
    DATA &HE8C101BE,&HD4481569,&H0D617E7D,&H2D144353,&HD9B12307,&H920057E5,&H00B33EDC,&HA8F24A2D
    DATA &HB9564B16,&HAA3C10C3,&H018AEFDF,&HE158C183,&HAC8820CF,&H9EB47101,&H8F44FC2C,&H0F962B81
    DATA &HE2860F2B,&H8DCDAA91,&H9D4E03B8,&HACA2C398,&HC4ACE7A2,&HAD3A9D59,&H67741B0A,&HF0758FEE
    DATA &HA5172D12,&H70619A8A,&H84B405A3,&H550D0D89,&H4E5DFD9E,&H2E724DB7,&HEAEF9D0F,&HCA523B95
    DATA &H9A8EFD7B,&H799C0189,&HBC0ADA35,&H08EA5289,&HB0794D81,&H19013392,&HC03C8255,&H5F2780CE
    DATA &H3DC34CE2,&HA11105C9,&H83DC3504,&H21AC6DCD,&HCBA9F34B,&H8FC1BD88,&H3724B5AF,&HE0229178
    DATA &H2AC23AA1,&HA91811F8,&H87FDEFB1,&H76FB754F,&H5307B865,&HC0E95FA5,&HC21FA82E,&HB6D92B2F
    DATA &H0A6BF038,&H015607C0,&H6D987EA2,&H3CC51C24,&HB8F64735,&HC0120063,&H32739028,&HF1D02715
    DATA &HCC5BEC58,&HFD7865A7,&H654B8DEA,&HBD20B5E3,&HF0923858,&HE74B9223,&H3BBA5C14,&HB97B73D1
    DATA &H1F888B33,&H8255D429,&H30E6E292,&HDF0C090D,&H75DB3A05,&H1B17CD71,&H5B440380,&H321C9E16
    DATA &H8214348A,&H12A4D695,&H58FC48E3,&HDCFC72CE,&H0805EBEA,&H2FABD60D,&HA432D30D,&H2BA885C1
    DATA &HB61AC929,&H69D83D3B,&H406DA7F0,&HCDAB305B,&HD93F35B2,&HB73DC75A,&H684C86C1,&H9F3907D8
    DATA &H37BBB519,&HFDD73071,&HEB7A7B10,&H62C478BF,&HB9BFF76B,&HDEDF684B,&H9115BDF5,&H09F981AD
    DATA &HEB2209DF,&H3DA27410,&H9C53AEB2,&H92C3E765,&H9C2F1454,&H9F2694C4,&H3DDC9184,&HDA11CB3F
    DATA &H0E724FFF,&HED36ED54,&H1656BC8B,&H9618759D,&HD6582B51,&H720697D4,&H4160B5EE,&HF9D825E6
    DATA &H8B26BDF5,&H719AC748,&H14E2B1C3,&HFFA2A4CB,&H575838FF,&HC605AA71,&HB34A6AD7,&HFD6020FC
    DATA &H8C63D402,&H8DE5581B,&H061E9394,&H729199CF,&H8A176219,&H39E8969A,&HAEEB656A,&H85A5AD1A
    DATA &HC5B7517C,&HED5DEACF,&HCA0E1012,&HF9D17FD4,&H21203EAE,&HBB787292,&H9BE40BE8,&H9C4FF2AC
    DATA &H95FBAFD9,&H5ED7AAE7,&HDA36A1DC,&HC4014535,&H9A9E7427,&H0AFB98E2,&H8DA82834,&H042CC0E9
    DATA &H2E2F5EBB,&H9F251549,&H295286F6,&HE785D45D,&H906D56D2,&H3D5A758E,&H990936F9,&H3E4F6683
    DATA &H158A49F8,&HCBAEC122,&H17A09F1C,&HA33FE854,&H1D55F370,&H4ACB4933,&H4EA27258,&HB9E4A154
    DATA &H09C89675,&H01A556F0,&H383B5026,&H4F9E8D3A,&H74CFEBA7,&HC4F87AFB,&H9F0C3DF8,&H61D480C2
    DATA &H8DD2056C,&HC9D2C2FB,&H8999B9FB,&H04E116F6,&HEC2573AF,&H0958CE50,&HBCD4D00A,&H13CCCF7A
    DATA &H21B72EC0,&HA93A491C,&H0D38377B,&H9BE26A86,&H439B608A,&H69D6860E,&H491044D7,&HA63DFDDD
    DATA &HE4C0FE4C,&H5166DF88,&H2EBFB673,&HA1DDDBBA,&H94F143ED,&H0C4D97B1,&H7EE72B71,&HDCFAE59B
    DATA &H87E27E3F,&H313EABEE,&HEED675BC,&H6CE12A4F,&H0B64FB5D,&HA75FC22A,&H962CE170,&HC8116E98
    DATA &HADAC8EC3,&H92D18446,&HD0B3BF29,&HDEC94111,&HA4AAD971,&HE3FB7C61,&HC303F7B4,&HF4058E20
    DATA &H986EF2B7,&H13A53B05,&H4561673A,&HB7DDB7FA,&H728A96EA,&HAE347AD8,&H34827F9D,&HEDF2E712
    DATA &H6DF2CBAE,&H6455F4C7,&HAFDF464B,&HCCF242F0,&H8FA5FEFB,&HBDFE5E2D,&H201F6572,&H0F3C6014
    DATA &HB4204054,&H83280548,&H7DF1627C,&HCE9D7602,&HBE4AB488,&H7B152CD6,&H96973C86,&HD4973027
    DATA &H14CE8D80,&H9C70EE2E,&H4818CF38,&H529BABF7,&H070D26F9,&H20EFB9CF,&H9A5D5E87,&HFC496F5B
    DATA &H0F19F852,&HC7AFC104,&H03FC308F,&H4EB1DFE8,&H17F7DCC8,&H216C10B8,&H1C764A2E,&HD67B886C
    DATA &H371D675D,&H3B3D50C2,&HA20994A1,&H4A66708A,&HBF68F995,&HD144CF21,&H2E7237C3,&H726C552F
    DATA &H453C6D7A,&HC38FA64E,&HD47DE244,&H777CBCA1,&H55174C75,&H92F46CEB,&H8C720B4E,&H937CFA69
    DATA &HFC83EC66,&HEAA894E4,&H2FB66DAB,&H73302D03,&H9D3212FF,&H5D73EDA1,&HE818EC52,&H8F87DB7C
    DATA &H9F08B11A,&H630D6766,&HA3398004,&H77B1BA94,&H5C898966,&HC4E72E0D,&H4B5E82FA,&H9E9E66EF
    DATA &H4BB2FC2D,&HB29C5354,&H722A1710,&HB7CCD93C,&HA935738B,&H16F49E42,&HB978FC0E,&HF1EE62F5
    DATA &HC2D9BA96,&HF19DF4D2,&H45F7E7D2,&HE8A0681A,&H662199EB,&H3428DCEF,&HEE47F6BE,&H9B6C4FAA
    DATA &H727E9BA7,&HFCCFAE7D,&H1969C49A,&HF583D983,&HD8EA60F4,&H6C6C84F8,&H0B52138C,&H15E752E3
    DATA &H0D4ED11D,&H9FE2A0EF,&H11E4DB94,&H1B107FA9,&H0803EFF0,&HCD1EBF20,&H25E7A375,&H33E166CC
    DATA &HD4DC485E,&H03594F37,&H070AEF1C,&HBB4F9BC7,&H76785306,&HBBFE5FB8,&HD911E0AF,&HE0BB9C97
    DATA &H5384970A,&H89F4917C,&H317DC7F0,&HF021DF64,&HDDFCB937,&HEC723627,&HE61111F2,&HFB0793BF
    DATA &HD257E097,&HA6734DE5,&HD68AB035,&H87348979,&H6CA81AB4,&H27370D43,&HCF5A0334,&HD1D74DAD
    DATA &H35968AB3,&H1D62B733,&H74C91B36,&H4D5502E0,&H7FE3F5AD,&H1E65AB0F,&H78597F70,&H660BA987
    DATA &H364FEEA4,&H93C2AF20,&HDFB3C605,&HAE833F9A,&HC7A178FB,&H398782EC,&H5CDF5D47,&H28AA9975
    DATA &H8FA847EA,&HDF5F5F5A,&H15F0F145,&HD86C152E,&H83BB2EC2,&HE9BC3F0A,&H1E4567F1,&H530E1B33
    DATA &H23EEA43F,&H8A565CD2,&H4D66614B,&H4D6D6626,&H3326E5D3,&H50F8A879,&HFD463289,&HD9C5BA2F
    DATA &HF18E09BA,&H3E82F505,&HD9D7E7FB,&HD70BF23D,&H68965556,&HE0A93C05,&HD242D088,&H6B9E899C
    DATA &HC09D9F57,&H2C102610,&H3EC7B041,&HCBDB1ACF,&H30646C9B,&H3133CF4D,&H3E9D9EB1,&H6CB4468C
    DATA &HA91FAD31,&H0AD05A82,&H04EC2C03,&HA009E7C6,&HEB555110,&H467B06AA,&HD41051F0,&H321B46C4
    DATA &H7B79BD2F,&H8C86271D,&HF2006EAB,&H23C5EC6D,&HC54321AF,&H9456086E,&H1DE15897,&H2C795A59
    DATA &HFC325A3C,&H9E2B6A3E,&H0CED27E3,&H2C096B47,&HE6C3A101,&HE802FEA7,&HF6E8CB3E,&H02EC939A
    DATA &HB7EFC7D1,&H58DCE2C0,&H47BF0B9E,&H95DBCE5F,&H0FDD31CD,&HB9BF19FF,&H7B649315,&HDB7A5139
    DATA &H15FC50CB,&HE277BCDF,&HF74625FE,&H4E3E439E,&HE0B1D18B,&H50F419BF,&HDEFC3EAE,&HFD91E1DE
    DATA &HE379897A,&H293607EE,&HBF8FF143,&H4F0E3AF3,&H27A0C61C,&H5E5CD23A,&H03A41914,&H5F51AAB3
    DATA &HBC8DE3E5,&HE619030A,&H8FEDB976,&H4685F18F,&H333A48BC,&HB586BE73,&H33AA2E53,&HFEE07EE0
    DATA &HFBABA63C,&H234C78BC,&H2E652EFE,&H0E46DAB2,&H38112FB3,&HCF309B5C,&H70008134,&H1D005DE9
    DATA &H5CEAFAF0,&HDF14757B,&H0D618677,&H3C3AD169,&HB050AABC,&HBAE50E11,&H4B7ABD13,&HB05CBB00
    DATA &H0C7FD5E5,&HCD06DED3,&HC582DD28,&H2DDE7BF0,&H164DDB46,&H6766AAEF,&H93EC6AF9,&H2FCD906B
    DATA &H16C850F5,&H1E5E5E67,&H9322C35F,&H62EA36DE,&HEBFD7556,&H36942A38,&HC5D03A30,&H504B9385
    DATA &HC85DDD34,&HCAAC1D13,&H4BA899C8,&H7DDC11BA,&H8C1D093B,&HCC8E411B,&H8F575740,&H9ED99402
    DATA &H6B741D06,&H3270267E,&H849EFC76,&H9943D03E,&H36E47F09,&H4361B47D,&HA3C9CBAB,&H91EC4E61
    DATA &H36BF1C16,&H23E2FA51,&H86A55F75,&H7797B72B,&HB44ECA13,&H3FD9F0B6,&H08A52C3E,&H6919CE09
    DATA &HC4C51B78,&H64B01C8F,&HF6A7A5E1,&H87A3C3E2,&HC13C81AC,&H08FDD20E,&HC9734BEF,&HE7789991
    DATA &HA5D86755,&H38C1D3E6,&H665950DD,&H4E6E6419,&H972C0650,&H491C1ED4,&HE2C21A5A,&H382A80E5
    DATA &HB28DDB15,&H2506D45E,&HA5265EE2,&HD5647D00,&H862066F9,&HA2183445,&H861BEB7E,&HA335089F
    DATA &H2A9B475D,&HB58C5AB7,&HB0E2E2DC,&H39796770,&H7AE09EC5,&HC1BDCA66,&HC2BF6FBF,&H9BE0B6DD
    DATA &H0E2065B1,&H52987A16,&HE0C43D90,&HE399382B,&H07E3CA7E,&HD9507D10,&H6ED80F83,&HA7643073
    DATA &HF72843C7,&H3BF04544,&H5539E6C3,&HFA84DBEE,&H10F94EBF,&H4883D673,&H2A576A17,&HEBF8C939
    DATA &HBD50B638,&H0568C327,&H43D7668D,&HD5E7C47A,&H59301CFE,&H987F4C6F,&HB20A77EB,&H4301EB05
    DATA &H3AF73D9B,&H9E8073DD,&H407BAB19,&HE37B5F6D,&H35304909,&H28732A73,&HE0F0C1F5,&HF4556413
    DATA &H2BC59EF4,&H9BC3A477,&HFEB4F9F9,&H526FB41B,&H6FE88CCD,&H79A0DF7B,&HE35D56C0,&HFAC386C4
    DATA &H72AEE7BE,&H227E3FC4,&H5038D741,&HDDBEC094,&HF11E02E3,&HA8ECEBDC,&H5E4F1CA6,&HFB5C67BD
    DATA &H6DAB78DA,&HA8559332,&H7967FB85,&H9DF6EB80,&HD4B8718B,&H1FABE23C,&H65AD3BA9,&HCA09E092
    DATA &HB6E65D62,&H6168AF17,&H5C74ED0C,&HB8F4F5A5,&H24B385E5,&H2E0D59DA,&HD0FBFBF5,&H9EC6BA7A
    DATA &H54D44257,&H2C0D5EDD,&HE3AF931E,&HBFD3F505,&HC2BD664F,&HFFED83CE,&H1430D2E7,&H4FEC70DD
    DATA &H61D5E2E3,&HBAAC3CFF,&H8279F4BD,&HC75FF4FD,&H5D7FB49B,&H73AEF66B,&H50CCDCDF,&H1A2EF0B4
    DATA &H30DE45F6,&H2B2FDE52,&H0ADEEDF2,&H010B812E,&H02669284,&H621EB7B2,&H36858F77,&H1D4A823A
    DATA &H1E476A62,&HAE4C15B8,&H7FA38B28,&H27998D69,&H55B85372,&HA867A7A1,&HA77E6621,&HDFA99E22
    DATA &HBA69439A,&H3CB62243,&HFEDC14E7,&H173CA656,&HA826C28D,&HCE1DCAFC,&H31D62A00,&H3C8F852D
    DATA &H3CFC1359,&H93620B9D,&HEFE0F1A0,&HB485E97D,&HA9F432CA,&H3A632EA3,&HA8E057B3,&HE1B93465
    DATA &H6CAF9AE8,&H676C2EA0,&H23801DB7,&HEC007B1F,&HB49B7830,&H5AF7760A,&H6079F537,&H3A9C2972
    DATA &H2502C8C9,&H76D08D5A,&H60833E49,&H8E59686B,&H3EF631F5,&HF57FD12E,&HE67C6AB9,&HE5F6BB24
    DATA &H257D41FB,&H12512058,&H33D02DFA,&H9B334D6A,&H004961CC,&HABEC2AA8,&HDC4A2BA7,&H64E77C5A
    DATA &HEC854E08,&H662A502F,&H2D52FDBF,&HF486B527,&HFC1034FF,&HF47B79E3,&H2DF6B9DF,&H9DFC6E2A
    DATA &H8362390A,&HC695DD59,&H785AF98B,&HCEC91EF0,&HCF61136E,&HAB2A9F69,&H583479AB,&H6FEC715E
    DATA &H6FEA6148,&HC03B7AE8,&H36416B55,&H763DA903,&HE0BE5C55,&H673F8EC0,&HA3E41AC3,&HD5C4D816
    DATA &HC476FD0B,&HF375028C,&H48BBACA8,&HA2A8F5F5,&H6C58149E,&HEA63877B,&HEB340DB6,&H3FDAE064
    DATA &H5EA4B3F1,&H4EFDF195,&H1F97BD23,&H95954AEA,&H7687ADBE,&H0BB79714,&H205C3C8C,&HAF852E09
    DATA &HAA5C06A6,&HB6EDA33E,&HEA71D65C,&H851B85B9,&H79287AF5,&H8D956A0C,&HF220AB83,&HE38D2048
    DATA &H5F265BBB,&H4146AD60,&HAF7CF3D6,&H7F794630,&H9168F615,&HAE48F652,&H063BA2E9,&H7C2B7B98
    DATA &HFFE9CCA1,&H87513D61,&H379DD904,&HB11EA923,&H1FD3510C,&HFE73224B,&HF4391C34,&H5DAF3731
    DATA &H640535CC,&H60969AF4,&H1A9DFECD,&H0394693E,&H5C9C7F03,&HA42C7939,&HD581E7EF,&H0847FF7D
    DATA &H2B7D2530,&H988DBF38,&H95AAEBE0,&H425FADEA,&H4B19E89E,&H53B06DA6,&HF7A87DBF,&HB9F7E13A
    DATA &H75E6C8B0,&HEEEE049C,&H64EEFFB5,&H6672409B,&H42E44EAC,&H75C402EE,&HB9B44DA1,&H2819C8FA
    DATA &HE01F7934,&H13C85CAF,&H511AFFA0,&H8258D276,&HADCAE961,&H6353C593,&HA3ADA1FD,&HD669CBF2
    DATA &H84D8D4DA,&HCC2CDAE9,&H4B288FC5,&H8FE9B218,&H251B6CD1,&H53915D87,&HFB739AAF,&H6968E9A8
    DATA &H8186B9B9,&HDF39BFE1,&HFCF04C21,&H4249BF2A,&H52B84C87,&H47F10A68,&HD5846DE4,&H0598F86B
    DATA &H29B9EBD8,&HC41DBC05,&HE8C00BB8,&HB08EEFC2,&H0B3652FF,&H5654FF35,&H5379354F,&H9DF3BF76
    DATA &HAF41AE0B,&HFDB2C799,&H9E146866,&HF6E90EA0,&H2C6BA82C,&H868F2B47,&H2E4D2B25,&HF2CD9816
    DATA &H9B6DF0E5,&HFFC30695,&HA1D47FE9,&H903FEC50,&HFB37552E,&HBF9367EC,&H5BCC10BF,&H55FC4BB2
    DATA &H479DBB5C,&HC1F4DD0E,&H9F3273A5,&H1C6B56E0,&H966B1026,&H8746AAEF,&HD42F4926,&HBB46D76C
    DATA &H00318C8B,&HD2B9C45D,&HE1C55AB3,&H00114A4B,&H249BE40E,&H49F3E33C,&HDEBE4AC7,&H98E17779
    DATA &H7CDCD25E,&HF78BC034,&H37E12B87,&H761EE629,&HF44CD20B,&HD47EABAF,&H9EBBF7ED,&HD4953219
    DATA &HBE5D26A3,&H432A498E,&H5A8D0BFD,&H808C01E0,&H1ACF91FE,&HE5165C0C,&H3E88C9A0,&H091A821A
    DATA &HD12E3DC8,&H36A316D1,&H21B6F6D4,&H3B536823,&H97256F76,&HA710B7A0,&H3193ABED,&H6F6E8E87
    DATA &H81D3AEB9,&H70089A57,&H2A805DCC,&H8034FA28,&H21F1DFF1,&HD7E7FF3D,&H6F08FE09,&H02A1B402
    DATA &H1AF3D1BB,&HE4640CAE,&H0682AC0D,&H47968818,&HAA700EE5,&HE5363FB0,&H9C15AFCC,&H38F90C2C
    DATA &H1C8F762E,&H460955B1,&H91E0C7E0,&H0378BD5C,&H59182F9D,&H9203A03F,&H51A48AC3,&H49435210
    DATA &HE4BA7244,&H11B7A402,&H109BABF2,&H0F76C67E,&H204997B3,&HDF1A0BD3,&HD8D3D2FD,&H75CAFE0F
    DATA &HF95B4512,&H53842B61,&HFF44161B,&HDF3B6A36,&H1165DFF0,&HF853BC96,&HEBEEDF29,&HCE9888D3
    DATA &H0515EF78,&H4E217D00,&HAA8AB3B6,&H6F926AFC,&HB6B91F6B,&HF086F0CE,&HC92CA352,&HC10253FE
    DATA &H252FB7F7,&H5B795729,&HDEFDEFA7,&H3AEB7C0E,&HAB24F595,&HC309AF1E,&HDB27CF5B,&H7ED8837A
    DATA &H51D58A4C,&H83586E8B,&H4F05AB99,&HEF5619B3,&HDC0EBEC4,&H087B020B,&H431930AA,&H756F024F
    DATA &HF64EE2D4,&HF6809DF4,&HE1AE13D5,&H6BFBCF68,&HE73F86BC,&HFEF9BC9E,&H99F7ED2A,&H657133F6
    DATA &H42737DBF,&HA3287527,&H6D72E862,&H43FE944C,&H3ADCC68D,&HA65BCBE8,&H7BCEF8CD,&H2BBE31BF
    DATA &HCB61C2B5,&H7E99C22B,&H8B9B3490,&H45248C75,&HE74FC776,&H2EA4E623,&HF2B28DD7,&HCE14A6C9
    DATA &HB86304BD,&H94E84F05,&H761B2CC8,&H9B55CDEA,&H4A7C4BEA,&HF77C2100,&H041CB6CF,&HDCBB57EF
    DATA &H9C67D093,&HC14D3C02,&H32234A2E,&H08F29F7F,&H37B154AD,&H483F358C,&H9E0AC349,&HFA6E5171
    DATA &HF212E3C7,&HF8DD0114,&H74C6EFD8,&HDCAC5C11,&H76F8904A,&H4658B732,&HBD1FF792,&HE368FED9
    DATA &HA0EF0BC2,&H91D0926B,&HD58AE776,&H83417930,&HE28757FB,&H001C50C8,&HBFE3052F,&HCEC77225
    DATA &H08451447,&HBD941683,&H2969373B,&H02AD7B65,&H9A412365,&HF979374E,&H190FA2CD,&HA80F67FC
    DATA &HAF53B30D,&H5D253CE3,&H534266EE,&H8392B787,&HC8E0DBB4,&H93E2AFF2,&H916B42D3,&H26198D49
    DATA &H46EC4E80,&HAB2F8B80,&H7DE25F82,&HD6BC2D9D,&H93DB3C13,&H541A0658,&H28CE46B4,&HA8D376EB
    DATA &H5E85A289,&H5DB8138F,&HC5885A10,&HA4A03139,&HE0F11048,&HD717F46F,&HA9741A0B,&H75972C24
    DATA &H12DA655E,&HA988E419,&H29509E73,&HF9D79BDF,&H5108507A,&H4464F83E,&HD45B9DCB,&H62F35EE7
    DATA &H1594136E,&H38AFB3E4,&H7CDD4469,&HD20AF27D,&H3685A544,&HE3713E82,&HADD6A5A5,&H5734DC89
    DATA &H95DF0579,&H6740623E,&HAB843C7A,&H99B920A9,&HDBEFF02E,&H0A457373,&H003AA402,&H3712AFDB
    DATA &H16D16E7F,&H6AC52C3C,&H89C4C6B6,&H013DA721,&HAD1A3467,&HC55FB515,&H0B3AE366,&HA4F8F821
    DATA &H42B0B7B8,&HE71A8B82,&HC4FC7E0D,&H1A40FA27,&HC8512998,&HD7E19126,&HCDCE8D97,&H4988F690
    DATA &H7AA36263,&HAD2C77B6,&HEECB152F,&H06BFC6BC,&H8F78D46B,&H7C3CAA6A,&HF844B882,&HB0BC277C
    DATA &H95F29A6E,&H9FD96BDD,&H6913FD01,&HDEE62448,&HD9D20C8A,&H4573C3A0,&HE385EC2E,&H3D04BD82
    DATA &H9738BDB1,&H9D441699,&H1EF19B78,&HF53B090C,&HB7CF986B,&HCF9C6723,&H8DB29AEF,&HB3D0817A
    DATA &H963F8A87,&H5009F1A9,&HD53FAC5E,&H21129914,&H41D435B4,&H6D18F4A8,&H17D76475,&H3B9DEA5A
    DATA &H0B6C0633,&HF9EF7BDE,&H1FE43FB9,&HECCDB5D7,&H9C75CD06,&HA9E9013A,&H7E99969F,&HA1AE0F58
    DATA &H8B42EA0A,&H87C086FE,&H558378FF,&HF18162A4,&H7B116B7B,&HD9F85EAA,&H94626BD0,&H801CADC1
    DATA &H42D97FC4,&H75839A8F,&H9EC11013,&H3F0BE1D2,&H5A490898,&H7A2393BE,&HFCB1B934,&H827785E6
    DATA &HB09142FA,&HB044565B,&H15820426,&HEF2B15D6,&HBEE2F8D0,&H4FF50C27,&H863D11F7,&H8D7DE9D1
    DATA &HC3716E85,&H49F1A37F,&HCA20A640,&HFE4B6E74,&H07EFE5C7,&H42D7D211,&H571BFD2C,&H86255D58
    DATA &H05EA5A5E,&H70F80705,&H0B5D13AC,&HC73B0E88,&H595EF477,&H4F826898,&HEAE64603,&H7BCA58F2
    DATA &HA4A5BDDF,&H919E192D,&HA56E2D3E,&H5ECB2791,&H5343C28C,&H7FAB5680,&H83D6AAFC,&HF089138B
    DATA &H289BFC4F,&HE0997415,&H1D4BFAB9,&HB17513A8,&H8AA64019,&H0A2D81C9,&H5FD577DE,&H8E9DCA3E
    DATA &HEEF110FB,&HEF9ED31E,&H7A7FC960,&H80BEE7A4,&HEE158CCF,&HB13F03E0,&HA4F9AEB7,&HC1B223EC
    DATA &HA1F9366D,&H640392F2,&H72CB3317,&H2DA64900,&HF8A0129D,&H27B1BDE7,&H3AFC86BC,&HE2B26BCE
    DATA &H82B46DBE,&H99D827F2,&H1FE24FC1,&H4508B63C,&H8E57E9AC,&HE919CA8C,&HE6EFE2FE,&H9656369C
    DATA &H4C413FB9,&HAFD1B27A,&H6153B35A,&H4C358FEC,&H9C147744,&H828BE62D,&H50F78AAA,&H68903835
    DATA &HDBC94D44,&HF058F579,&H272DB6BD,&H46A012CB,&H5418014A,&HB926AD8A,&HC8C7751F,&H7301B17F
    DATA &HD43C58EF,&HAD14F43D,&H7E66F5A0,&H42858C0F,&HA1912520,&HF1F60A8A,&H25E39FF2,&HE533EC9D
    DATA &H0F9514C3,&H9AB885CB,&H8E3D493A,&HED531DD3,&HAD7F1492,&H3D58E0E8,&H44F5D88A,&H13D28726
    DATA &H63FDD5DF,&H70788096,&H00EFF1FC,&H229976FB,&H854B4381,&HDB818835,&HCFC6A107,&H9B6D9D8E
    DATA &H5D2F734F,&H45357E31,&H7D41FE64,&H905CEA72,&H3A17B3B3,&HF35E374E,&H3E55B99B,&H6F47047D
    DATA &HF1BFEFE7,&HBD24A1B9,&H308D5B31,&H3C5CEE37,&H9B8CBF44,&H2E9E7FF6,&H7E80F01D,&H75E53D47
    DATA &HB24C9D53,&H34FCAE77,&HB29EBCE8,&H545A6D0C,&H86818F3F,&HC62C1672,&H0610249F,&H6F38777C
    DATA &H929B4874,&HFFFB3B3B,&H6107CEF9,&HE35EB5DE,&H98083F6C,&H417C254B,&H8AD87F14,&H5EEB6D49
    DATA &HB3428751,&HF815D53F,&H6CA87199,&HFD3972F0,&HD93538D9,&HCC21AD5D,&H6F646ECC,&H2BACF0A9
    DATA &H7AC6B64E,&H26A5E03E,&H55CB6F71,&HAE24F7AC,&H2EE6FBE2,&HBCDD76FB,&HFCFBA87B,&HE1D7F041
    DATA &H46AE5DE5,&HBB892A7A,&H98191353,&H29D48CFB,&HAF0894DC,&H672289F9,&HC7298AFC,&HD9B75B1B
    DATA &HACE98239,&H20551F61,&H96067D89,&H1633FA68,&HC5583626,&H380825CD,&H1EB94480,&HE24CB549
    DATA &HD98A3080,&H57030B38,&H0AEB7170,&H5691B7A1,&HA2FFCF4C,&H6EEF2E02,&HA52FC35B,&H50E372C3
    DATA &H2392DFDA,&H17C27DF1,&H210B44AA,&H73316B6F,&HE2A85D58,&H825F6621,&HB25779E4,&H7A1B3ACC
    DATA &HBD4B0CE9,&H46D10873,&HC692744D,&H5FB0A280,&H358AC83E,&H2F0B5EB4,&H0006C8C1,&H3036BA9B
    DATA &HFD16CAB0,&H8E0D3FD1,&H8322A48E,&HC761F7A1,&HCE9DC191,&HB6E48714,&H1936D812,&H158E0C17
    DATA &H14F6131E,&HBCB0E794,&H9BAC2841,&HE18E551F,&H9193D887,&H2A2C9D75,&H04E27C68,&H2E812507
    DATA &HAF382F88,&H994709FB,&H0962B050,&H257A2E00,&H2CEDAD6C,&H64F3ADD1,&H4935C7B9,&H7CB084C4
    DATA &H2F9FCE8F,&H82C1AC4B,&HF0CC8055,&H9B49890F,&H746DBFB3,&H423F5FB7,&HBD9DD269,&H96BA5B01
    DATA &H1551ED68,&HAACDBCD8,&H6D6303CD,&HC590D670,&H182A5004,&H4DF4005E,&HC903E2D7,&H46374F9E
    DATA &H7CB5DBD5,&HC225E082,&HC8849A06,&H561E074B,&H820D4D59,&H763C0328,&H6C6C5237,&H94686C05
    DATA &H510CBFA0,&H97C1ED7D,&HC89AC731,&H366279D3,&HA1EFEB4A,&H82560ECB,&HBFB81BC1,&H516C43B0
    DATA &HD5EFD12A,&H5542B33B,&H1BD48B6F,&H450B226C,&HCFDC21FB,&H15C5905E,&HDBABFC06,&H026EDF5D
    DATA &H89EC2E35,&H4B29CF99,&HA22B028D,&H27B02E09,&H49CF4E0B,&HDC638952,&H69E20465,&H152DB887
    DATA &H1E5A82D8,&H660FC993,&H7E620241,&HA2D365AD,&H8F6CC4D8,&H1DD83646,&H42E26D35,&H2538B886
    DATA &H9F7271F0,&H621B5144,&H3B9B8E77,&HEB8B87DC,&HDA17CBAE,&H396C4CE5,&HF1048414,&HFEE66344
    DATA &H6B614279,&H0E597BED,&H67FA2590,&H59B78A9D,&H12B25824,&HF2C874BA,&H7D01309E,&H3C898CDA
    DATA &H5B9925F8,&HF1B53875,&H90F3792D,&H3FCD6AF7,&H2A5A153B,&HE5BC306E,&H7AA54C38,&H10BB12F1
    DATA &H9A13BD4F,&HF748FA52,&HCFB2C764,&H2DA50729,&HEAED86B9,&H20937FEC,&H5C447EE8,&HB0DCD3CD
    DATA &H5185A531,&HEBFC7FF7,&HD74CDA9F,&HC1C986BE,&HD3E71D19,&H26F05233,&HEDD2D9FF,&H9D76D5FF
    DATA &HDD054D51,&H01693436,&HD29BD092,&H454D2E94,&HD200928A,&H415483A5,&H03101010,&H4254520A
    DATA &H05528A53,&H5D2029A4,&H546020BA,&H45095482,&H25288094,&H51441074,&H2799243A,&HDEBF7DF1
    DATA &H7BD6B7AF,&H77BCFEF7,&H66BBAF65,&H99F66732,&HE929F67D,&HF310BF48,&H44755104,&HB3E45DBB
    DATA &HDF6C8E49,&HA3A5618C,&H16F43DED,&H3920B825,&H8F5E8206,&HD54040C6,&H9FB873F9,&H5A9D7BB5
    DATA &H44DF4C43,&H580145C7,&H2B700812,&HDCF0FB03,&H3B1CE392,&HEC985A21,&HF36B934B,&HF2FFE66D
    DATA &H7FC39FE4,&H1A124240,&H18523E59,&H7B4E344E,&H094D5981,&H5C6121AD,&H17592C67,&H1FB5A969
    DATA &HF14F2B4B,&HF810C5E2,&HE170AB89,&HD70BC8EE,&HE831F48A,&H200C692D,&HF3EC2C1B,&H9862C141
    DATA &H9DC19D8D,&H8A25D73D,&H81745C63,&H488305EA,&H9AE342F3,&HD2B4EA91,&H8495DA6F,&HEE4193F5
    DATA &H0DB8D471,&HDDE3E9CF,&H76C23355,&H83D93E0F,&HF066AEAD,&H91FA93E4,&HF35D41B7,&HC2900346
    DATA &H68F02834,&H3D274060,&H1F6B5262,&HCFD1657F,&H4E0E9668,&H18D2910E,&H05FE4A0D,&HC31B5972
    DATA &HB8325FFD,&H98BF3D44,&H697E223B,&H7E319922,&HD3FE9FD6,&H4B99EFE2,&HE8F29626,&HF80C65AF
    DATA &H2F254C06,&H3F8F2FB5,&H03FC3B42,&H634279E4,&HE85023EC,&HB59064A2,&H993602E0,&H60D14BD2
    DATA &HC9579B95,&HFF9E38CF,&H7F4ED6D2,&HA0264B80,&H4083671C,&HE47B1AE4,&H62E59604,&HEC6E6CE6
    DATA &HB88B2F7B,&H793046F6,&HD58DBD58,&H0124F798,&H5DA8278A,&HE6265F52,&H02D3BF56,&H36B50F1B
    DATA &H96246252,&H4644E9CE,&H08D7F552,&H4CADFE3C,&HF225BE21,&H4AA407E9,&HE204133B,&HDC41011E
    DATA &H7837BA7A,&H42830B0B,&HCC62C0FF,&H96F3E869,&HEBF6A052,&HE4086510,&HDAB40751,&H2DF7F21F
    DATA &HD2C36B26,&H8687A439,&HCD569AC7,&H8FA1FCE5,&H1BD71756,&H7549AB0B,&HACC17021,&H4C68CF8B
    DATA &HC5A29045,&H47E901D9,&HCE606805,&H7CA93887,&H7FC627E2,&HEA68C259,&H7C37CB1F,&H3F1E1537
    DATA &H6034CE0E,&H4E2651CC,&HA77211F8,&HC6F156A5,&HE110442D,&HAD7177F4,&H213E9FB5,&H7AD1BD2B
    DATA &HCBAF33EE,&H626C867E,&HCF9B4A0E,&H39198BEB,&HDB847F68,&HF176F13E,&H2EB9B5AB,&HCCC1D0F3
    DATA &HFB1D133D,&HA6692FE2,&H143F8AFC,&HF5AFCC34,&H0F697551,&HC9068AC5,&H3491926F,&H37E362A9
    DATA &HFA319631,&H786632A2,&HFAA6E0E1,&H0203425B,&HF098367D,&H304EF0E8,&HF648857D,&H9B261FDB
    DATA &HB8ADB32D,&H6BEA82A9,&H1A98B63D,&H9E75751F,&H3D72B346,&H6577C9BE,&HB71775DE,&H5DD41F3B
    DATA &HCED939A4,&HD41A783D,&HEAA90482,&HCD6CAF88,&H47C12852,&H50BAD4B6,&HD13FCE47,&H4C3E872A
    DATA &HD9C195ED,&H8569E5EF,&HA757F4A6,&H4138B7F3,&HD27CFBF9,&HF4922F0B,&HD9B9AEF8,&H007183C4
    DATA &HBFAAF850,&HBDC5A3FC,&H8E996C41,&H57DA4C7C,&HC6D438CE,&H83D4B6F6,&HF4DBC62D,&HDFD65511
    DATA &H46372C64,&H1D66F499,&H29D14524,&HA92D05EB,&HBE4257D1,&H4EFD4037,&H69EB525A,&H3E88113D
    DATA &H68EBBFBA,&HCC89704B,&H56090C49,&H56602E06,&HFB2536CC,&HC9C6B446,&HB553CC5C,&H8BD8E8EF
    DATA &HEA76B538,&HB5CE7A5C,&H41046AAE,&HFDD6F0C8,&H1349E84C,&H699898E7,&H40878715,&HC0639AB6
    DATA &HA24BF176,&H866E9919,&HC5D6FF71,&H491FE93F,&H79010B3D,&HC3B018DD,&H9F238161,&HA7FFE833
    DATA &H10A66587,&H1B3A5720,&HF0CC2C7F,&HA40F9227,&HEF26F375,&H93555571,&H31CB3DAF,&HA2DBC6B2
    DATA &HCC2053A6,&H8B88363E,&H7FD6AAF9,&H65D2A444,&H48EC0755,&H95726163,&HE7980CCE,&HCC692474
    DATA &H75B70226,&H8BC3DC33,&H5A8D97F2,&HD83E693E,&H05ABE7D3,&H3F2C43C0,&HC8FCDAD0,&H8DD37227
    DATA &H2ECEAA0E,&H4C1E3109,&HF46D2BB7,&HA568E18D,&H7E218CF9,&H3E5D14F7,&H8682240D,&HC6C7C61E
    DATA &H302C811C,&H5EBBC612,&H9CAF4A39,&H48131AE7,&H0EA456CB,&H4AEE709B,&H702C9DE9,&HE88E9893
    DATA &H4AA8AFD5,&H88CECDCD,&HDE97E370,&HB283CBE3,&H28E12D9C,&H9DB0F4AD,&H3D2C1418,&HF09B2BEE
    DATA &H449D28DE,&HE6A36090,&H26729F2D,&H19EF0F74,&H238F20C2,&H2A778A93,&H10F69EAD,&H1A391C2E
    DATA &H3FA48919,&H9E789902,&HBBE130DE,&HD4598A10,&HB5F263FB,&H1722BAE8,&HFAC5B042,&HB682A373
    DATA &H46BBCDB6,&H5CBBBEAD,&HDA47DF5F,&HAFB5E555,&H406529A5,&H4E7D3BEF,&H2F93953C,&H3D1C7DE1
    DATA &HE8BFB7E0,&H09F2EF23,&H11D05A25,&H1BF54DC7,&H9F7050AC,&H0659009D,&H27AC3D54,&HE51BDA0C
    DATA &H9ADC0D4C,&HB4EACCA9,&HF422268A,&H973F8337,&HF7F3A11E,&HD51A1566,&H325D1F00,&H37861FFB
    DATA &H9F027A6E,&H6C011C54,&H3B87F880,&HC18F82A2,&HE2188777,&HA5A17DFE,&HD8676B57,&H25D83C1D
    DATA &HA5269F43,&HDB2171CA,&H354FDCE0,&H710E0A0B,&H07D910F4,&H452F0092,&H8DF2DF4B,&H44C2790E
    DATA &H5C5F523C,&HCA5642D9,&H6AC0F332,&H002DCE23,&HDB8DCD63,&HC3A6427F,&H347127EC,&H2C6217EF
    DATA &HF811C169,&H955CB52B,&HFD364066,&H766289BB,&H2D75E565,&H673B02E0,&H886BFA91,&H51E5AD20
    DATA &H4F58ACA7,&HF881565D,&HC291F82A,&HB2BEBBC5,&H81FDD4CA,&HC7195C2D,&HD9DE197E,&H6FC1DF12
    DATA &H64CD500E,&HAB32D2D4,&HD81B96D6,&H67D8D265,&H1F2FADC5,&HC9E47AF9,&HEE405ACB,&H9D822388
    DATA &H63CB2A80,&HF00C5978,&HA0FAD665,&HB9B26D5A,&HE356006A,&H2045862D,&H2C482FA7,&H9F58A486
    DATA &HC3E03ABF,&H93F73F7F,&HB1017E43,&H428C7213,&H5BF5A34B,&HFDFDBFF4,&H49687A57,&H2196F8D2
    DATA &HF093921D,&H22F9FC7E,&H95080046,&H5974E800,&H59701E30,&H13ECA25C,&H7946ADAC,&H5A2A8259
    DATA &H79BC167F,&HFBEDE6F3,&H9CBE6E00,&H3B5978AA,&H65CE40BD,&H50D2A8E1,&H74B036D4,&H82055649
    DATA &HF39598AC,&H920D4D98,&H9D31FB25,&H872A8B47,&H9BBFCF82,&HFCD473F9,&HD6210628,&H32514BC3
    DATA &H0D71AAC2,&H930F085A,&HD6E99F36,&HA4CA81F7,&HA9297094,&H239FB78F,&H20FB27AB,&HE3B1E9AF
    DATA &H33AB48D1,&HBE2C4CF3,&H65A1B90E,&H4BDF7B1F,&H3BE73D04,&HFD0C3ED5,&HD74E19FA,&H699F6A8E
    DATA &H60FDC6BB,&HBABA15F2,&H7B5735E2,&H029A8686,&H10ACC150,&H510D7047,&H5443B9A5,&H4E54F27F
    DATA &HC53B4001,&H37E2D83F,&H00C3CA0E,&H994F12D8,&H8315312D,&H2A175FA1,&HFDC8AF27,&H3CAD546C
    DATA &H21FF66DB,&H2A4229B1,&HC378EA5A,&H446923CC,&H5C6C4498,&HDB43ED4A,&HCF166758,&HD4E82558
    DATA &HC50B8D60,&H0EEB24CA,&HBA560B0B,&H790983FF,&HBAFC1DA4,&H961659A0,&HA7FE746B,&H2F9669F6
    DATA &HBE7C9C54,&H650460A8,&H05F1A128,&H254546F6,&HA4C0640B,&H91C3C6E2,&H5F75579F,&HD6643BD9
    DATA &HE5BEDE94,&H32A83371,&HF52A7034,&HCA8B5DF8,&HBE2813F1,&HBD8E52C5,&HE6EA9C97,&H2BB5E561
    DATA &H9C8D77B5,&HF7A67AB6,&H7C2B3D8F,&H993F7E26,&H91B442D3,&HD5EBAE4B,&H91EAA8DD,&H04B0A8EE
    DATA &H1ACC7DF5,&H3A8B5AC5,&H1DFC593E,&H36948CE2,&HB5C1F1A3,&H491BF9AC,&H19A0D268,&H9BA8C408
    DATA &H771540E1,&HF1339492,&H886655C2,&H9BE3CC48,&H644CF218,&H630777A2,&HC668D053,&HBAD7C7CF
    DATA &HB6C7C80F,&H19BF4038,&H05A1B305,&HBBCA72E6,&HC91C9536,&HC73613F4,&H55F34340,&H2FB2E51E
    DATA &H50F284E4,&H8F041103,&H8FB51FBC,&HBE0423CD,&HBDE65974,&H9BFE8B6E,&H5708ACC2,&H014C177B
    DATA &H66A60D8D,&H389738F5,&H19979BDD,&HD7943139,&HBF3C39CB,&H4EEB8E22,&H2AECBA2C,&HB1333AF6
    DATA &HFC153EED,&H97D4F608,&H0F1DA75E,&H55801C9E,&H6B68C3BE,&HE6C8CC4C,&HF67E4A9B,&HC73BDF10
    DATA &H78FD601A,&H3EFF5608,&HE1DB424D,&HE0B3182E,&H2F9EA4E9,&H8A096E20,&HB012F853,&HFBFDE53A
    DATA &H905DF4AB,&HC247C2B6,&H75D3274C,&H370C20DA,&HF8C60070,&HA9662D2C,&HC056FB90,&H04D5C0B1
    DATA &H25B7BEF5,&H976E20B8,&H10375C51,&H8D734018,&HF61A5D3C,&H8F03F740,&H5E679929,&HD46CAFFD
    DATA &H2A7D1635,&H7DF8D407,&H6A7BEA70,&H778B2A8E,&H25F27CCE,&H8B7D524E,&H7A1CF8AA,&HBAA57778
    DATA &HFC5E5FB1,&H892DD152,&H737EBE30,&H9369DEE5,&H560367ED,&H057BD34F,&H3BF70C3B,&H56D0F42D
    DATA &H215CF7ED,&H4C4A0231,&H5E7562F4,&H980930A6,&H87848085,&H628A4F00,&HB71B2B18,&H2D3F0CF9
    DATA &H6CEBC12C,&HDBE0B967,&H68634E16,&HC978BB87,&H90B942E2,&H6729FCB6,&H01CCA17D,&H44A5DEAA
    DATA &H7583A720,&HD69158CF,&H69C941B1,&HD037B745,&H729DA065,&HA2F09E8F,&H31826019,&H928C0BFA
    DATA &H66379E69,&H6CEE55EF,&H7E1468FD,&HD7E0FA57,&HEADF65F0,&H1C052B1C,&H4AE250F0,&HBC78B8BB
    DATA &H4690FDF3,&HA92B231F,&HF6A0FF89,&H7A73868E,&HF6FE6A80,&H75D177C5,&H69D6ABEB,&H8D1BAF57
    DATA &H1E2A479A,&H54C864E2,&HE56BF6CE,&H883C41D8,&HDB0B87EB,&H43ADD9D0,&H17592266,&H63F89306
    DATA &H2E3D2C8F,&H2FEB6E66,&HC82F4DEC,&HF46A6C3E,&HE93F9B1C,&HB2E7B8D3,&H3839F030,&H15290A25
    DATA &HD0161B48,&H1650AFEF,&H3956D5BE,&H677644F5,&H11F6C9FC,&HFDD2CFF1,&H9E1BC567,&H592CAAAE
    DATA &H8B5D0D93,&HA965F8BA,&H968825E7,&H6334CBDB,&H0D2A4830,&H0C9A471D,&H9B160643,&H2D53AA21
    DATA &HD0C37D54,&H59EA4A03,&HBD1D3FD2,&H06BD10A1,&HCFE4665E,&HE580E34B,&H351B1D1B,&HEE6FD077
    DATA &H1FF02607,&H189E2683,&HFA859039,&H19135D92,&H7953979B,&H43BF7CF8,&HF009C9EE,&H04A25567
    DATA &HA56F620B,&H0466F92E,&HEB506CC9,&HDA606C58,&H52BBE295,&H4AB858BA,&H8AD2EB40,&H58EBC0F8
    DATA &H400BCB20,&H202FEDC1,&H76E19537,&H00B5F92E,&HE86774A0,&H940FB9E6,&HC3751DF5,&H85C9C03F
    DATA &H4E533009,&H819B70D1,&HE294D14C,&H4F573FD9,&H4C0FC896,&HA005BF7A,&HF3F85288,&H4C45225B
    DATA &H2D686C06,&H3F10484B,&H2A5E0E85,&HD54ECB38,&HD8FEC087,&HD36CFEAE,&H8F8DBC6D,&HC7A3C3E3
    DATA &HAE823F06,&H251B01B1,&H4A45A57D,&H0F6D056C,&H69CF1325,&HB8C5D164,&H6FBA890F,&HD65CC9CB
    DATA &H6E17EFD4,&HE3249CE8,&HC0F5B86C,&H77F7D279,&HD2CBCDAE,&HA282BABC,&H1103F922,&HCAC979D5
    DATA &H191C3CD0,&H360298A3,&HE59251B7,&H98DE92ED,&H7D54B39D,&H67C403D5,&H0B5DC647,&H180A937C
    DATA &HA15C25A9,&HEB48FF41,&HAEDDC464,&H89313143,&H78DDAEC2,&H494F89A1,&HFAB675FB,&H566C4BCC
    DATA &H246E43F7,&HB4D8AC76,&H28FD087C,&H130459E4,&H02E546CA,&HAD89C7C2,&HC7804EA2,&HAB78A204
    DATA &H6D405A5A,&HE487F521,&H42F2F686,&H055970AE,&HAFF9A7D7,&H85572C9D,&H01E750CF,&H8DB2CC42
    DATA &H120A5EC6,&HB92EF0C6,&H3E6C52A1,&H55399687,&H286C9B45,&HEB0CBA7C,&H78D352A1,&HEE8C5CD9
    DATA &H5CDDEB51,&H496E80FE,&H426A8163,&H63454D91,&H02F8D60E,&H988C9EA7,&HDD49DCDA,&H45FB850E
    DATA &H0B6527B1,&H75B1FD26,&HDFA689CD,&H65D1AA15,&H8B9843D5,&HB32AA67A,&H3975584F,&HA9ABD7CC
    DATA &HDF255BBA,&HAC8616A9,&HC8061A02,&HED114659,&HA70E4D28,&HFDED10A6,&H08850C03,&H1B7E7D76
    DATA &HB9B4A727,&HDB9824D1,&H81685A55,&H6B5DCA07,&HD4F2FC27,&HD4651E59,&HFDB8AF82,&HA4EFB8D4
    DATA &HD9306C0A,&H0899F888,&HE8C3C8CA,&HD31760D5,&H0AB2B5D5,&HE31DF2DB,&HF93837D1,&H9EDC3C1A
    DATA &HFBEA9E69,&H8C35C9A5,&HBBFBDD56,&H91FA0B7F,&HFC53EDE4,&H9BCEBAFA,&HD72BACC8,&H13F56C62
    DATA &HB6CF4444,&HB9E92369,&HCA46BC6F,&HCB39CFD0,&HF9AD7D4C,&HFF7D6971,&HBC8765EA,&H39AACB7B
    DATA &HDAC1A6C4,&H9018D027,&HB94F3392,&H67ED81DE,&HC062BC84,&HA022A6E6,&H278A05EC,&H0A35455F
    DATA &HD43E460E,&H8D41B1AC,&H75C9FD53,&HC756FCE0,&HB4B7CEFE,&H7D2ED742,&HB5F16C68,&H7D0DC266
    DATA &HDF662319,&H6AF66D40,&H04ECA6B6,&H8BCDB879,&H89E8ACF8,&HFF237461,&HDAEA484A,&H73E35A91
    DATA &H14FAD30A,&HFC50D7B6,&H595E199B,&HD2370382,&HD1B598FB,&HAE03319C,&H25E0BB57,&HEFC73139
    DATA &H01A9AF61,&H23DD5A1B,&HFA3E7BDF,&HB755359E,&HABE70F61,&HB0748099,&H91F9675C,&H84E3F5B6
    DATA &H157B29E8,&HB6DB8676,&HA891D5E7,&HFD2501A0,&H36AB8E55,&HAD56A18B,&H5A10356F,&HB2FED86E
    DATA &H32CBBA65,&HEA7D652A,&H4C580D29,&HFA38BDF1,&HBA6852BC,&H544A2722,&HCD06F0B9,&H9637BE43
    DATA &H2C330C57,&H1F1EA214,&HE934334D,&H696B263F,&H56DEEDB4,&H4247F542,&HFAD2EBC3,&H1350A321
    DATA &H1CC5FB2D,&H2B269BDF,&H5CECA50B,&HD73D369A,&H12152EBC,&HD4DCF6ED,&HDC5C158E,&HD844420D
    DATA &HFE721702,&H93B50609,&H31D1BEDF,&HEDBD0846,&H1B1E179A,&HE164E7A6,&H64327778,&H5BDF526F
    DATA &H50D84966,&H457D3038,&HADF8333B,&H3BE78D65,&H4255BC15,&HA33482EE,&HD51AFCA4,&HF39A2ECF
    DATA &H641B60EC,&H387D7614,&HB574745B,&H3BD49E45,&HD39AF939,&H9F589958,&H10220444,&H143E1173
    DATA &HF403158D,&HFDE467E4,&H692E5305,&HC2E2892F,&H5888C61C,&HC29C861D,&H3FB086EA,&H2610D0B1
    DATA &H1B3AFB93,&H4766F80D,&HC1E5FB7D,&HCC0D971C,&H2ACCE5FE,&H077A24B2,&HAB81E837,&HBBD9330C
    DATA &H88DB8D4C,&HC61278D7,&HE3568A58,&H6FF9D3B5,&HFF4E4777,&H196B20DA,&HA8ABA45A,&H2CF82568
    DATA &H4D9828BA,&HF4F67F15,&H4F772F96,&H541FF39A,&H2E9DC576,&HAF9E9AE7,&H77942B1F,&H3B387FB1
    DATA &H87A3992F,&H866097CB,&H77E670F3,&H5751DA61,&H527A468A,&H755EAAB7,&HD7615CCF,&H7B1523BA
    DATA &HDDEFD439,&H9E351892,&H2C362A16,&H5DB38412,&H22339A21,&H7343DBBF,&H321B0ED4,&H489C6767
    DATA &HAC7EEF64,&HE6EA8B7B,&HD3AE4670,&H176EF154,&H584F0DBD,&HE5195213,&HA2969CAE,&H7630F8E2
    DATA &H03E5D92E,&H349E6D71,&H9F54E203,&HA824FEE6,&HAD137D11,&H19D08070,&HCDBD51C4,&H11A91349
    DATA &H12B5F154,&HBF0ED05C,&HC6A38875,&HB8245CA5,&HF68A41F7,&H7DAEC9F4,&HADECB1AE,&HE2495E2C
    DATA &HFC33C137,&HD6E68646,&H05820B75,&HFDD356B8,&HB655C50C,&H0248A144,&H5BE2C5B3,&H1A027A5E
    DATA &HD62A5368,&H0794AA71,&H184A2B0A,&HDD7EEAE0,&H5815AEEA,&H096405A1,&H2BBD20D1,&H66C03C17
    DATA &H2AD15111,&H0CD59015,&HA8AD8B5C,&H581D6F3A,&HA1E4A087,&H06F6A6AE,&H55C50F6E,&H93B9F090
    DATA &HF5B57AD3,&H16726FA4,&H96D645CF,&H0BDB3BB9,&HD8D765EC,&H7BE7EABC,&H281B62F7,&H1F88A32F
    DATA &H12C11CD5,&H918BFEC2,&HED446CEA,&H772B1874,&HBE266FF0,&HC1A388B3,&HAD04A2FB,&H87485FD1
    DATA &H1617BF72,&HF8095E2A,&H37BB5DE7,&HB38D4D11,&H859E5479,&HDC65CE90,&HC2660D45,&H25999872
    DATA &H6B33A8B0,&H61DD7BE4,&H31780321,&H8D7C7DA8,&H051DCF29,&HBB35C154,&HEBC1FDA1,&H666F5B28
    DATA &H564F2756,&H53897A45,&H035BAA6C,&H9F637870,&H98AE39F1,&H1F4FB91C,&HC38D5B09,&H8F6610E7
    DATA &H06BCD3BD,&HBF351DAE,&HAE64D475,&H5239BCFD,&H8E37A992,&H4F5A9139,&HB67BC7EB,&HF4377583
    DATA &H4A9D0DD1,&H11483BCE,&HCD9D3D91,&H4D1FB3B5,&HDF4E0E0E,&H728D3B48,&HF0DEFEFB,&H51F8C1E3
    DATA &HCD4D4F4F,&HEF42ABA5,&HDE7A27A5,&HD09F11B4,&H39ED7B97,&H0FF0CA50,&H937CB35B,&H26B314CE
    DATA &H80C65784,&HF31D12A8,&H0C540821,&H613462FE,&HA4CB82B8,&HFDA6569B,&HDCD45BB6,&H77553694
    DATA &HB06D7DCB,&H1141C691,&HE1CB34A2,&H9CE0F63A,&HBDBA4841,&HCA373111,&HFA38597F,&HE78A3D2D
    DATA &H2B547EA0,&H4844FDE9,&H90AAD24D,&H4409F4D3,&HFB35656F,&H4D682DF5,&H05D98C92,&HE06B4C19
    DATA &H73DFC7B9,&H178A87C7,&HE7BF0796,&H20D19E58,&HB6486A9C,&H7E8479D7,&H269D8137,&HDDC92E90
    DATA &HA41BE83D,&HCBF8B1D6,&HB824CE3C,&H0C41DB64,&HC9E2AB2B,&HFD6B234D,&H648B7545,&HB83E3B9F
    DATA &H63483705,&HF45278A4,&HA973F595,&HD05D6206,&H64E7BC44,&H57DC1DDE,&HCA3EC1CE,&H44D54161
    DATA &HE349BA71,&H7D0CB217,&H7884FE1B,&H77328698,&H7F27B187,&HD7C67176,&HEFAB598F,&H6C77061A
    DATA &H99A1E79A,&HADBEBF9E,&H0881E752,&HF4F6CAFC,&H1F96DC61,&H4E48862D,&H66F24F82,&H73937280
    DATA &HE0F12878,&HEC6C6456,&H879E76A7,&H29652E49,&H8173463C,&H8AB4D581,&H0A6363A7,&H8E8CE862
    DATA &H3AE64912,&H7AC8834C,&H9DDBF05E,&H843C3E54,&HFA041259,&H38A93366,&HF3C3540A,&H66031EF6
    DATA &H3B819E05,&H104C1DC8,&HFEA18AFD,&H1C734E7F,&HD4432CF0,&H5D2B5F3A,&H60247ABA,&H1C1B0C1C
    DATA &HB4746817,&H0A0D1387,&H4DD05C8C,&HE1083507,&HE19DE68C,&HE3B95C31,&H306D9C1D,&HDC395EA5
    DATA &H2C19AD3C,&H07185ACB,&HC86DC53D,&H77C3038E,&H805FC1B0,&H88419A9C,&HE0A0515C,&H88AC2D6C
    DATA &HE6D90032,&HC18B4F6B,&H4A71B047,&HCBFFB96E,&H720AAFC7,&HB08CD450,&H8381EC23,&H80E5237C
    DATA &H2FE61162,&HBC2122BF,&H24560798,&H6245D6CC,&H423E9FC1,&H5511C2DF,&HB2D8354A,&H149029F5
    DATA &H0D0335AA,&H1E672D5F,&H46766F05,&H5B8D35B7,&H887D4E88,&H0974F750,&H53755D7A,&HBEA4DF10
    DATA &HE1772387,&HE704C3C4,&H8E2860A0,&H4B522598,&H582F1EFD,&HC523075A,&HA3BB13A2,&H3CB343F8
    DATA &H42E8AA1B,&H1CC65129,&H3C098454,&H0BAB0668,&H18215921,&HCB62B0D0,&H0A1B4A77,&HB4A243A3
    DATA &H2A3CEFEB,&H522E16E4,&HF9EDFBA3,&H6A6455C0,&H74E89758,&H8BA9D645,&HA044DB46,&H4F5E8690
    DATA &H6B410DA2,&H325E8AE2,&H5A3B5E29,&H7EDF242E,&H01D6ED5D,&H06133FB5,&HEBF021B6,&H33989F30
    DATA &H1FCF45E2,&H3E4E7EA5,&HDBCB12D6,&HF723B2AD,&H9FAEA8EB,&H4F345B9F,&HD9DB9813,&HEAD0BDF9
    DATA &HBEF72C51,&H7D96DCE4,&HCEF06FAD,&H09A3D8AD,&H9F6E47FA,&HD0FEFDF0,&HB0FD76B6,&H56EEDDA7
    DATA &HE7EEC532,&HEEE7C5EF,&H06DB35FE,&HA75E7366,&HBFAD17C0,&HADA9B2BC,&H93FF5A97,&HF99748A9
    DATA &H7D7F30FE,&H87DDB7EA,&H15B9CAA0,&HCFF3B0A1,&HF4275958,&H6D4FAAF6,&H261F90FD,&HCB0173FE
    DATA &H47B7AF54,&HA0912FAC,&H4DFCEA12,&H5D9148DD,&HD3726BBA,&HAEDA8F42,&H8D3E47CF,&H9BF11291
    DATA &H31A543EE,&HFE2A2524,&HCE2AFC44,&HC12611C4,&H2EFE993C,&HF0962AB2,&H79BB9B03,&HE5C4A388
    DATA &H2648C4BA,&H5EB968C0,&HF8985065,&HF13949C2,&HB04CD38A,&H4E426C0B,&H72892BE6,&H75BCCE77
    DATA &H767219EE,&H77F571DF,&HCFDE4F62,&HFC5FA290,&HA7B0514B,&H1205C1F2,&H63937192,&H5F79B65F
    DATA &H81D099BD,&H2A2F6701,&H266FAA89,&H07066C83,&H728B4140,&H112962A1,&H738AAEE3,&H7EB53C14
    DATA &HCDC39D4E,&H6E177645,&H98F6D4D4,&HC477F292,&H246431A2,&H3776C16C,&H57E9B3D7,&H8542919E
    DATA &H181F9C5C,&H77C0D142,&HA489199C,&H6C8BF005,&H66DCB605,&H801F5AB9,&HE089114F,&H259DAE4F
    DATA &H202F4B0B,&H15765E7D,&HBF7DC0E9,&H18BCDAE7,&HEC37BA41,&H605CF986,&H71F62FCF,&H616082D5
    DATA &HBDA7AD4F,&H51ECB704,&H60C768A0,&H99E65FE9,&HA2D68CBF,&H2926DF3C,&HB8C29D4F,&H114B7E63
    DATA &H820BEF65,&H5B853C8A,&H011D4FCD,&HF10A0314,&H0BCDD2DF,&H81C17A8C,&HB571C858,&H636566AD
    DATA &H0F68D550,&H439421A7,&H912D186E,&H14DC726D,&HE63FF18E,&HB00B81C7,&H9C312512,&H188096FE
    DATA &H84D8EF71,&HFDBE3FEB,&HE28383A7,&HA17D89DD,&H6711320A,&H0CF72C24,&HB950C9B6,&HC4FEDC38
    DATA &HA7733CAB,&HEDF0174C,&HD3DBA783,&H0EC5E10B,&H39806F4D,&H621E8FB2,&H37034B48,&H22B8E547
    DATA &H26E9B835,&H8268526C,&H0EEA3B21,&HB192A522,&H7C21F6FE,&HED9ED369,&H27A6C525,&HD0AE05CA
    DATA &H8F4F082E,&HB25C7207,&H7DB7C7F8,&H918157BA,&HE292ED14,&H3AE7E523,&HB6ECBA29,&HB9D1B2DF
    DATA &H0AE3638F,&HB7CBA303,&H3F9D570C,&H025D618E,&HD40C24B2,&HB53ECF44,&H45F4B176,&H8F668723
    DATA &H333D146F,&H823BBA4B,&HDE2BE65D,&H8E20FD6C,&H146489AC,&H50286259,&H16CEAF7E,&HEADC5087
    DATA &H76AAB331,&H3099A8BE,&H3828DA6C,&H9D23ED45,&HD8B07F22,&H00569C15,&HA74A1B99,&HEA18485D
    DATA &HD277107C,&H248EC791,&HAD612DA9,&H81E3AF10,&HBF1F5F01,&H2484A403,&H5E1CCD65,&HA693B6C8
    DATA &H6883F657,&HF089483A,&H23DBE147,&HE9858F50,&HE73CDD79,&H46D862DF,&H2B74E118,&HD900071A
    DATA &HD5B0EE22,&HFF03301E,&H2F7DA8B9,&HAAAB1055,&HC18CBF47,&H78296A68,&H578C9A9D,&H4B818D09
    DATA &H6055532F,&H86894219,&HD56E03C7,&H16A58EE7,&HE50945C0,&HFA1ABC34,&H8B5B1102,&H98E233C9
    DATA &HF3CA68FD,&HF73CA8A9,&H339D34B7,&HA13D471F,&H7B3CE2EA,&H7B7F6F34,&H15F20D44,&HE320D432
    DATA &H8E47081D,&H7C15C964,&HE7F57892,&H396AEFFD,&H36B38FAA,&H92557FDC,&HE3746522,&H5CA36767
    DATA &HE8B644A6,&HC4D167D4,&HC9412895,&HE6D52995,&H670D9A7A,&H2D69CA2D,&H55DC970B,&HD52B49F0
    DATA &HEBD6FC11,&HCDD3D9D6,&H7B6A7DC0,&H17714036,&H08C4FECE,&H027C2EEB,&H74BD992A,&H15D3314B
    DATA &H2BD2485F,&H45D9A4E3,&H4E6D4F7B,&H5FB47A37,&H9D233585,&HF9BFDA46,&H4E265DA6,&H4AC5D251
    DATA &H353877FA,&HA4BBCCAF,&H4C8697A9,&HA177819B,&H638DC483,&H00508A5B,&H8E49066E,&H2FC50179
    DATA &H942598B2,&H97D6415D,&H6CACBB7D,&HE2A7E962,&H9C123AF0,&H3D019285,&H5286129D,&H6FED8CEC
    DATA &H016C27BC,&HD524C6C8,&H56E155BE,&HC6403D6C,&H86958062,&H7FDBD2A7,&HF5375BBA,&H4B1B8831
    DATA &H58364AA3,&HEADAD8BC,&H72685BC6,&H86466DD6,&HEEA0B6A6,&H52287A21,&HA0B25625,&H2E797E4D
    DATA &HB867C57D,&H83ED223F,&H734CA680,&HD959DDFD,&H3A279C3F,&H7EF42B3A,&H5A9D0EEE,&HDE12E1F5
    DATA &HC19E211D,&H37BFBA90,&HCA026808,&HD96579A3,&H6DC447BD,&H7E97F44F,&HAA40CDDF,&H760A2F9E
    DATA &H976E91D3,&H10C9A62F,&H7F67A080,&HB799F1C7,&H88AD0444,&H845E9408,&HDD6BF296,&HEBF55A7A
    DATA &HAC34B6E0,&H15B54CA5,&H78B04F07,&HAF45D563,&HFF2DF092,&H727B116E,&HE5DCA94F,&HDBAF91CA
    DATA &H3C331776,&HB1EEC394,&HEB7D1973,&HD324FB97,&HC41CFAA1,&HA67BB40D,&HA48D4EAD,&H5FD96AFD
    DATA &H3F97FA68,&HDB7813E8,&HE216726B,&HEEE5677D,&H3D74C4FA,&H63A559FA,&HC3379653,&HA970D6AA
    DATA &H6EC90B8F,&H8A5F1CE6,&H85F1E345,&HBAD9F5D4,&HB027E3EF,&H0E75DEA3,&H16F726C2,&H541CA319
    DATA &H0DF10B68,&H6646132D,&HA7AFE78A,&H67080DBD,&HE9F12A15,&H5AF9920A,&H58B01C1C,&H64A81193
    DATA &H0AEDF0BF,&HD519E9DC,&H5285F687,&HB9D8E2C7,&H83C8572C,&H310EEA39,&H4282F75B,&H47A7B19A
    DATA &HFED522F9,&HC8D734CB,&H7C553C3C,&H97005BC1,&H82273CC2,&H542F8F12,&HBA639D39,&H769899B8
    DATA &H6703B4E6,&HF9E84D7A,&HB8D0A7E2,&H76E602C8,&HC76D3266,&H630BCDF5,&H4376C221,&HF79F8445
    DATA &H3EB34D89,&HB5495F27,&HDEEB5378,&HD1CA23CF,&H10C37BBC,&HF464A75A,&HD2478B9F,&HFE086743
    DATA &H7F4B7284,&H3952B29A,&H78467C8F,&H15F151AC,&H8BC0B8F9,&H5B69BBB0,&H279EDED2,&H4AC88716
    DATA &HB9270676,&H46981C72,&H127DB652,&H24DE579C,&HC579891F,&H9AF22BA8,&H7F18E3C0,&H38159D63
    DATA &H09001D6B,&H20993B3D,&H2D0E1EDC,&HED4B5617,&HA5CA6057,&H1906DA58,&H11DEBB1E,&H81020D72
    DATA &HAA1E7A1C,&HAC5A6AED,&HC4F77FDE,&HF4D83B7E,&H4F36BDF5,&H7506B913,&HB70D9356,&HD4D45F06
    DATA &HC96EF726,&HDBD02481,&HBD02F3E7,&HC62063FC,&HCF62CC34,&HE5169E81,&H66CE5F96,&H394BCF57
    DATA &HCA082DD0,&HAF287541,&H2F4BEA94,&H3DA6F1F7,&H3FB54D19,&H6783B1C4,&H84A17F77,&H6F5BA51A
    DATA &H2E88F665,&H1C3AA1AB,&H900284B8,&HBF1B43BF,&HFE9224F4,&HC6E0C860,&H0E83FA28,&H52EB2F66
    DATA &H25C1B344,&H23862830,&HA9DB8CE7,&HAD36E1A8,&HF8104CC8,&HF64AA6F9,&HA7697417,&H33B60D9A
    DATA &HE5363B9E,&HF1151378,&H9BA9C4FC,&H3353DEEB,&H9291AAED,&H9D714F4A,&H28D1D6FF,&H6F487287
    DATA &H40366367,&H97C076C1,&H5B6AF3A1,&H0440B9BE,&HEC47EA0D,&HFA932785,&HB906FFE3,&H07861D2B
    DATA &H50F4A746,&HA9698890,&H20182F17,&HFA5DE44F,&H6687CE16,&HB3C7B767,&H5A94871C,&H4F1CB0FE
    DATA &HD7772867,&HECB6688E,&HD1704BF7,&H58F1304B,&H42E452AB,&HEB8683E7,&HFF2BF4FD,&HDD39E4F4
    DATA &H0976BB1D,&H72EE2F2D,&H0680B8AD,&H004F5B1A,&H9033B422,&H247C6C97,&HF7875E5A,&H60BF3C90
    DATA &HB7441FE3,&H69B064B2,&H21FFC86A,&HD7FE418A,&HF0FF9517,&H77735B62,&HFCB41F15,&HFF22C7CF
    DATA &H57,&H37,&HF5,&H5C,&H13,&H02,&HA1,&HB5,&HFB,&HBF,&HFD,&HD9,&HFF,&H71,&H1F,&HE2
    DATA &H2C,&HFF,&H07,&HE7,&HFF,&H0F,&H06,&HF2,&H5F,&HB1,&H97,&H4B,&H80
END FUNCTION
