CHDIR ".\programs\samples\thebob\leapfrog"

'*****************************************************************************
'
'---------------------------- L F G F X . B A S ------------------------------
'
'-------- A utility which creates graphical components for LEAPFROG.BAS ------
'
'*****************************************************************************

DEFINT A-Z

DECLARE SUB GetFROG (x, y, FileNAME$)
DECLARE SUB PrintSTRING (x, y, Prnt$, Font)
DECLARE SUB Rings (Pad, Colr)
DIM SHARED Box(1 TO 16400)
DIM SHARED FontBOX(10000)
DIM Elements(3600)
DIM BasicsBOX(3000)

SCREEN 12
GOSUB SetPALETTE

'Create images from DATA
MaxWIDTH = 300
MaxDEPTH = 395
x = 0: y = 0
RESTORE PixDATA
DO
    READ DataSTRING$
    FOR n = 1 TO LEN(DataSTRING$)
        Char$ = MID$(DataSTRING$, n, 1)
        IF Char$ = CHR$(225) THEN Char$ = CHR$(160)
        SELECT CASE Char$
            CASE "!"
                n = n + 1
                a$ = MID$(DataSTRING$, n, 1)
                Count = ASC(a$) + 68
            CASE "#"
                n = n + 1
                B$ = MID$(DataSTRING$, n)
                FOR i = 1 TO LEN(B$)
                    t$ = MID$(B$, i, 1)
                    IF t$ = "#" THEN EXIT FOR
                    c$ = c$ + t$
                NEXT i
                Count = VAL("&H" + c$)
                n = n + LEN(c$)
                c$ = ""
            CASE ELSE
                Count = ASC(Char$) - 60
        END SELECT
        n = n + 1
        Colr = VAL("&H" + MID$(DataSTRING$, n, 1))
        FOR Reps = 1 TO Count
            PSET (x, y), Colr
            x = x + 1
            IF x > MaxWIDTH THEN x = 0: y = y + 1
        NEXT Reps
    NEXT n
LOOP UNTIL y > MaxDEPTH 'DATA drawing loop ends here --------------------
'Draw mirror image of frog leaping frames
FOR x = 0 TO 270
    FOR y = 0 TO 204
        PSET (540 - x, y), POINT(x, y)
    NEXT y
NEXT x
'GET/Save leap animation files
RESTORE LeapDATA
GetFROG 0, 0, "leapdr.bsv"
GetFROG 270, 0, "leapdl.bsv"
GetFROG 0, 68, "leapur.bsv"
GetFROG 270, 68, "leapul.bsv"
GetFROG 0, 136, "leapr.bsv"
GetFROG 270, 136, "leapl.bsv"
'Get additonal frog/lilypad images
x = 70: y = 206
GET (x, y)-(x + 48, y + 37), BasicsBOX(651)
PUT (x, y), BasicsBOX(651)
GET (x + 49, y)-(x + 49 + 48, y + 37), BasicsBOX(1251)
PUT (x + 49, y), BasicsBOX(1251)
GET (x + 49 + 49, y)-(x + 49 + 49 + 48, y + 37), BasicsBOX(51)
PUT (x + 98, y), BasicsBOX(51)
'Hold menu/lilypad elements for use later
GET (0, 206)-(65, 267), Elements()
FOR x = 0 TO 65
    FOR y = 206 TO 267
        IF POINT(x, y) = 0 THEN PSET (x, y), 15 ELSE PSET (x, y), 0
    NEXT y
NEXT x
GET (0, 206)-(65, 267), Elements(1200)
PUT (0, 206), Elements(1200)
GET (69, 246)-(146, 258), Elements(2400)
PUT (69, 246), Elements(2400)

GOSUB GetFONT
'Create/BSAVE Error blurbs
PrintSTRING 20, 230, "There is no frog", 0
PrintSTRING 20, 243, "on that lilypad!", 0
PrintSTRING 20, 260, "You can't get", 0
PrintSTRING 20, 273, "there from here!", 0
PrintSTRING 20, 290, "You'll land right", 0
PrintSTRING 20, 303, "on a wee froggie!", 0
PrintSTRING 20, 320, "There's no froggie", 0
PrintSTRING 20, 333, "to leap over!", 0
Index = 1
FOR y = 230 TO 320 STEP 30
    GET (20, y)-(120, y + 24), Box(Index)
    PUT (20, y), Box(Index)
    Index = Index + 660
NEXT y
DEF SEG = VARSEG(Box(1))
BSAVE "leaperrs.bsv", VARPTR(Box(1)), 5280
DEF SEG
'Begin lilypad drawing
PSET (308, 90), 4
DRAW "M+199,+330 L398 M+199,-330 BD20 P4,4"
FOR Reps = 1 TO 500
    x = FIX(RND * 400) + 80
    y = FIX(RND * 380) + 90
    Radius = FIX(RND * 12) + 10
    IF POINT(x, y) = 4 THEN CIRCLE (x, y), Radius, 8
    x = FIX(RND * 400) + 80
    y = FIX(RND * 380) + 90
    IF POINT(x, y) = 4 THEN CIRCLE (x, y), 4, 5: PAINT STEP(0, 0), 5
NEXT Reps
FOR x = 70 TO 520
    FOR y = 80 TO 480
        IF POINT(x, y) = 4 THEN PSET (x, y), 0
    NEXT y
NEXT x
PUT (286, 63), Elements(1200), AND
PUT (286, 63), Elements()
PUT (334, 143), Elements(1200), AND
PUT (334, 143), Elements()
PUT (238, 143), Elements(1200), AND
PUT (238, 143), Elements()
FOR x = 94 TO 500 STEP 96
    PUT (x, 383), Elements(1200), AND
    PUT (x, 383), Elements()
NEXT x
FOR x = 142 TO 500 STEP 96
    PUT (x, 303), Elements(1200), AND
    PUT (x, 303), Elements()
NEXT x
FOR x = 190 TO 400 STEP 96
    PUT (x, 223), Elements(1200), AND
    PUT (x, 223), Elements()
NEXT x
DEF SEG = VARSEG(Box(1))
GET (191, 63)-(447, 301), Box()
PUT (191, 63), Box()
BSAVE "leappnd1.bsv", VARPTR(Box(1)), 32800
GET (95, 302)-(543, 444), Box()
PUT (95, 302), Box()
BSAVE "leappnd2.bsv", VARPTR(Box(1)), 32800
DEF SEG
'Create/BSAVE menu bar and item highlighting
LINE (0, 0)-(639, 25), 8, BF
PUT (12, 5), Elements(2400), PSET
PrintSTRING 130, 7, "NewGAME", 0
PrintSTRING 221, 7, "SOUND", 0
GET (220, 8)-(258, 16), BasicsBOX(2301) 'Green SOUND
FOR x = 221 TO 300
    FOR y = 7 TO 20
        IF POINT(x, y) <> 8 THEN PSET (x, y), 9
    NEXT y
NEXT x
GET (220, 8)-(258, 16), BasicsBOX(2101) 'Lavender SOUND
PrintSTRING 600, 7, "EXIT", 0
GET (12, 6)-(624, 17), Box()
DEF SEG = VARSEG(Box(1))
BSAVE "leaphead.bsv", VARPTR(Box(1)), 4000
DEF SEG
FOR x = 130 TO 639
    IF x = 261 THEN x = 600
    FOR y = 8 TO 16
        IF POINT(x, y) <> 8 THEN PSET (x, y), 15
    NEXT y
NEXT x
GET (130, 8)-(184, 16), BasicsBOX(1851) 'White NewGAME
GET (220, 8)-(258, 16), BasicsBOX(2201) 'White SOUND
GET (600, 8)-(626, 16), BasicsBOX(2001) 'White EXIT
LINE (0, 0)-(639, 25), 0, BF
DEF SEG = VARSEG(BasicsBOX(1))
BSAVE "leapbscs.bsv", VARPTR(BasicsBOX(1)), 6000
DEF SEG
'Create/BSAVE instructionas
PrintSTRING 24, 45, "LEAPFROG is based on a popular", 1
PrintSTRING 24, 57, "wooden pegboard puzzle.", 1
PrintSTRING 37, 75, "The object of the game is to", 1
PrintSTRING 37, 87, "eliminate all the frogs but one.", 1
PrintSTRING 37, 105, "Frogs are eliminated by leaping", 1
PrintSTRING 37, 117, "them.", 1
PrintSTRING 37, 135, "To leap a frog, first click the", 1
PrintSTRING 37, 147, "jumper frog, then click the", 1
PrintSTRING 37, 159, "destination lilypad.", 1
LINE (25, 78)-(28, 81), 10, BF
LINE (25, 108)-(28, 111), 10, BF
LINE (25, 138)-(28, 141), 10, BF
PrintSTRING 460, 55, "To deselect a jumper just click it.", 1
PrintSTRING 460, 73, "To reset, click NewGAME.", 1
PrintSTRING 460, 91, "Click EXIT at any time to quit.", 1
PrintSTRING 460, 109, "To switch sound on or off just", 1
PrintSTRING 460, 121, "click SOUND on the menu bar.", 1
PrintSTRING 446, 150, "Copyright (C) 2007 by Bob Seguin", 1
LINE (447, 58)-(450, 61), 10, BF
LINE (447, 76)-(450, 79), 10, BF
LINE (447, 94)-(450, 97), 10, BF
LINE (447, 112)-(450, 115), 10, BF
GET (24, 45)-(188, 170), Box()
PUT (24, 45), Box()
DEF SEG = VARSEG(Box(1))
BSAVE "leapins1.bsv", VARPTR(Box(1)), 11100
GET (445, 45)-(615, 170), Box()
PUT (445, 45), Box()
BSAVE "leapins2.bsv", VARPTR(Box(1)), 11100
DEF SEG
'Finish up
OUT &H3C8, 11: OUT &H3C9, 40: OUT &H3C9, 30: OUT &H3C9, 63
LINE (5, 5)-(634, 474), 5, B
LINE (8, 8)-(631, 471), 5, B
LINE (200, 180)-(439, 290), 5, B
LINE (197, 177)-(442, 293), 5, B
PrintSTRING 241, 212, "The graphics files for LEAPFROG", 1
PrintSTRING 243, 226, "have been successfully created.", 1
PrintSTRING 246, 250, "You can now run the program.", 1

a$ = INPUT$(1)
END

GetFONT:
'Stores two fonts in single array (see PrintSTRING sub program).
Index = 2
FOR y = 272 TO 386 STEP 14
    FOR x = 0 TO 300 STEP 14
        GET (x, y)-(x + 11, y + 11), Box(Index)
        PUT (x, y), Box(Index)
        Index = Index + 50
        IF Index = 188 * 50 + 2 THEN EXIT FOR
    NEXT x
NEXT y
FontBOX(0) = 50
FontBOX(1) = 4
FOR Index = 2 TO 187 * 50 + 2 STEP 50
    LINE (0, 200)-(20, 220), 0, BF
    PUT (0, 200), Box(Index)
    x1 = -1: x2 = -1
    FOR x = 0 TO 20
        FOR y = 200 TO 220
            IF POINT(x, y) <> 0 AND x1 = -1 THEN x1 = x
        NEXT y
    NEXT x
    FOR x = 20 TO 0 STEP -1
        FOR y = 200 TO 220
            IF POINT(x, y) <> 0 AND x2 = -1 THEN x2 = x
        NEXT y
    NEXT x
    GET (x1, 200)-(x2 + 1, 211), FontBOX(Index)
NEXT Index
LINE (0, 200)-(20, 220), 0, BF
RETURN

SetPALETTE:
DATA 0,0,21, 60,55,55, 0,38,14, 0,0,0, 63,0,0, 0,24,0, 0,34,10, 32,40,55
DATA 21,21,21, 53,0,63, 31,55,4, 18,28,40, 63,58,58, 8,30,0, 63,63,21, 63,63,63
RESTORE SetPALETTE
OUT &H3C8, 0
FOR n = 1 TO 48
    READ Intensity: OUT &H3C9, Intensity
NEXT n
RETURN

LeapDATA:
DATA -45,-37,1,-42,-35,3301,-6,0,6601,18,32,6601,30,57,6601,42,84,3301,47
DATA 106,1,-45,-37,6601,-50,-35,3301,-86,0,1,-110,32,1,-120,57,1,-125,84
DATA 3301,-132,106,6601,-36,-34,1,-28,-52,3301,-30,-78,6601,-12,-120,6601
DATA 12,-156,6601,42,-182,3301,50,-190,1,-50,-34,6601,-62,-50,3301,-60,-78
DATA 1,-75,-122,1,-98,-156,1,-127,-182,3301,-136,-186,6601,-45,-37,1,-32
DATA -42,3301,-12,-54,6601,25,-56,6601,56,-54,6601,88,-44,3301,120,-40,1
DATA -45,-37,6601 ,-68,-46, 3301,-94,-56,1,-124,-58,1,-156,-55,1,-188,-44
DATA 3301,-220,-40,6601

PixDATA:
DATA "!0>3?0>3>0>3#120#0=3>A=2>3=0>2=3=0=A=3#121#0=3?A=2=3>A>3=A=3#122#0=3?A"
DATA "=2>A=2>A=3#123#0=3CA=3#10C#0>3S0BA=3#10D#0=3=A=3R0=3@A=3#10C#0=3=2=3>A"
DATA ">3P0=3@A=3#10C#0=3=A>3?A>3N0=3AA?3#109#0=3?A=3@A?3L0=2CA?3#104#0@3FA>3"
DATA "K0?3BA>3#102#0=3LA=3M0=3CA=3#102#0>3HA=2=3O0=3CA#104#0>3>2>3>2>A=2=3Q0"
DATA "=3BA=D=3#109#0=2?A=3R0=2AA=2=D=3#109#0=2?A=3Q0=3BA>D=3#109#0=3?A=3P0=3"
DATA "CA>D=3#109#0=3@A=3L0?3=2CA=2=D=3#109#0=3AA=2=3G0>3=2HA=D=3!@0?3>0?30=3"
DATA "CA>2B3?2LA>3!>0=3?A>2?A=30=3`A=3!<0=3=A>2=3?A=3=2=A=30=3BA=2?D=2UA=3"
DATA "0=3=A=2>F=7=3=A=3=7=F=2=30=3@ACDKA?DCA=30=3>2@F=3=A=3?F=30>3>ACD=2"
DATA "IAADCA=30>3=A=2>F=7>3=A>3=7=F=2!<0>3>A=2>D>2JABD@A=2=D=A=30=2B3>A=3>F"
DATA "?3=A=2>3=F=7=3!=0>3=2NABD?A=2?D=A=30>3?D=2BA=2>F=7=3=2>A>3=C=7=3!@0>3"
DATA "HA>D?A@D@AAD=A=30?3=2>A>D=2CA=7>C=3BA>30?3=2=0?3e0=3GA>DGA=2?D=2=A=3"
DATA "0>3>D=2JA=8=2DA=30D3D0=3>A=2>3=2>A=3e0=3JA=2@DAA=2=D=2?A=30=3@DVA=3"
DATA "{0@3@D=A?D@3?0=3=A=2=3C2f0=3HACDFA=30=3@DHA?3IA=3w0?3=ABD?ABD?3=2=3=7"
DATA ">F=7=3=2?F=3e0=3=2FA=2DDEA=30=3NA=3KA=3t0>3IABD=2=A>2=7@F>3@F=3e0=3=C"
DATA "EA=2DD>A=2@D?A=30=3>D=A>DJA=3=7JA=3s0=3?A?D@A@D>A@D=2>A>2?F=7A3>F=3e0"
DATA "=3>CDA=2CD>ACD>A=30=3>D=2=A>DKA>3HA?3q0=3?AAD>ABDEA=2>F=7?3=A=2=3=7=F"
DATA "=3f0=3=CEA=2BD>ACD>A=30=3?DPA=7G3=7>F=3g0A3@0=3=D?A=2?D=2>ABDEA=3>F=7"
DATA ">3=2>A=2=3=C=3f0=3>CFA?D@ACD?A=30=3>2NAMF=3g0=3>A=2>D>3=0=3IA=2?DGA=7"
DATA ">C=3=2AA>3g0=3>CLA=2BD=A>D=30@3>0=3OAMF=3g0=8@A=2?D=3ZA=2=3DA=3g0=3?C"
DATA "LA>2>D>A=2>D=30>3@D?3NAMF=3h0=3AA=2>D=3eA=3g0=3>CGA>2>D=2BA@D=30=3>A"
DATA "=2?D>A>3FA>3@AMF=3i0=3RA=3XA=3f0=3?CEA=2AD=2BA=2=D=2=30=3FA=3DA=3AA=3"
DATA "LF=3j0=3RA=3IA>3JA=3f0>3>CDACDFA?30=3@A>3=A=3>A>3AA=3AA=3LF=3l0=3@A>3"
DATA "KA=3BA=3AA=3MA=3f0>3>CCA=2AD=2FA=3?A>30=3@A?3DA=3AA=3LF=3n0=3@A?3JA=3"
DATA "@A=3AF@3=2JA=3g0>3?CBA=2?D=2HA=3@A>30=3@A>3?AAF=3@A=3KF=C>3o0=3@A>3?A"
DATA "GF=3@A=3EF?3EA=2>3j0>3>CQA=2>3=2@A=30>3?A>3=A>C@F=3@A=3IF>C=3=2=3p0=3"
DATA "=8?A>3=A=CHF=3?A=3HF=8C3=8>F=3l0=3=CPA=3@A=3@A=30>3>A>3@C?F=3?A=3DFBC"
DATA "=3>2=A=3q0=3=8>A>3?CFF=3@A=3PF=8=3l0=3LA?3>A=3?A>3=A=3?A=30A3>A=2=8BC"
DATA "=3?A=3GC>1=3?2>A=3n0?3>2>A=3=1ACDF=3?A=3MF=7=8=3=2A3g0=3LA=3=2>A=2@A=3"
DATA ">F>3?A=30>3DA=2=3=1AC=3?A=3CC?1@3=2@AA3g0>3EA=3=1CCAF=3?A=3HF?C=7=3=D"
DATA ">2AA>3d0=3LA=2AA=3>A=3?F=7>3?A=30=3?A>3AA>2=3A1=3@A=3B1>3>2?A=3FAe0=3"
DATA "?A=3=2CA=3>1FC=3@A>3EC=7?3=8=3>2CA>3c0=3KA=3@A?3>A=3@F>3?A=30?3BAB3@1"
DATA "=3@A?3>1=3?2?A?3BA=3>A=3e0?3BA=2@3=7?1DC=3@A>3@1=7>3>8@0=3=2BA=3?A=3b0"
DATA "=3BA>3GA=7>F=3>A=2>3=F=C>3?A=30=3?A=3>A=2=3A0A3DA@3=2>A=3?A=3=A?3>A=3"
DATA ">A=3d0>3?A=2?A=3B0=3=8F1=3@AA3E0=3@A=3?A>3=A=3b0=3AA>3=0>1DA=3@F=3>A=2"
DATA "=3=C=7=3=0=3>A=30=3>A>3>A>3B0=3=A=3IA?3>A>3?A=3>0>A=3=0>3d0=3>A>3>A=2"
DATA "=3E0>3=7A1=7>3AAA3F0=3>A?3=A=3e0=3AA=3?0>1CA=7>F=7>3?A=2=3=A=3=0=3>A=3"
DATA "0>3?A=3D0=3=A=3@A=2?A=2B3=0=3?A>3@0=3=A=3h0>3?A=3J0A3>0=3FA=3F0=3=A>0"
DATA ">3=A=3d0=3AA=3?0=3>1CA=C=F>3=2AA>3=0=3>A>30?3E0@3>A>3?A=3D0?3C0=3k0?3"
DATA "R0=3BA=2?3H0>3>0=3=A=3e0=3@A=3@0=3>1=2@A=3>C=3=2CA?3@A=30>3=A=0>3?A=3"
DATA "0>3=A>2>A>2O0>3f0=3@A=3@0=3=1=2=3@A=2=3EA=3CA=30>3?0>3>A=30=3=A?3>A"
DATA "=3=2z0=3@A=3A0=3>1=3KA=3=A=2>A=2>A=30@30=3=A=3=0>3?A=3z0=3@A=3B0=3=1"
DATA "=3JA=3=A=2>A=2=3=A=3!{0?3>0?3>A=3z0=3@A=3=2A0=3=1=3IA=3=A=3>A?3!0@3{0"
DATA "=3AA=2>3?0=3=1=3GA>3=A=3>A=3#10D#0=3DA=3?0=3GA=3=0@3#10C#0>3@A=2=3=2?A"
DATA "=3@0=3DA=3#111#0=3=2>A=3>A=3=0@3B0?3@A=3#112#0=3>A>3>A>3I0@3#113#0=3>A"
DATA "=3=0=3>A=3#125#0>3?0=3=A=3#12B#0=3#70A#0>3@0>3=2#123#0=3=2=A=3=0=3?A=2"
DATA "#123#0=3>A=2=3=A=2?3#123#0=3AA=3@0=3#122#0=3=2?A=2?3=2=A=3A0?D#11A#0=3"
DATA "=2DA=3?0>D@A=D0E30A30=3CA=3?0=3CA=30=3@A=2=3?A=30=3@A=2=30>3>A>2"
DATA "A0=3=DEA=3D0=3>20=3>A@3=A?3=A=30=3@A=2>30=3=2>A=2>0?D=3=DGA=3D0=3=A"
DATA "=30=3>A=7>F>3=7>F>3=A0=3@A=3>F=30=3=2>A=2>0=3AA=3FA=3?0>3?0=3=A>30"
DATA "=3=A=3?F>3=C>F=7=3=A0=3@A=2>F>30=3=2?A=2=0=3DA>3=2CA=3>0=3=A=3>0=3>A"
DATA "=3=0>30=3>A=3=C?F>3?F=7=A0=3AA=2?F=30=2=3@A=3=0=DDA=2>F=3=2AA=3?0=3"
DATA "=A?3>A=2=3=A=30=2>A=3?C=F=C=A=3=7=3>A=30=3BA=3>C=A=30=3@A=2=3=0=DEA"
DATA "=3>F>3@A=3?0=3>A=3=2>A=2=3=A=30=3@A=2=7>3DA=30=3AA=3>A>2>A>30=3BA=D"
DATA "GA=2?C=3?A=3@0=3AA=2=3=A=30=3MA=30=3AA=3EA?30=3=2@A=DHA=2>3=2?A=3@0"
DATA "=3DA=30=2NA=30=3CA>3FA=30=3=2>A=2=DNA=F=3@0=3CA>30=3PA=30=3FAD3?A"
DATA "=30=3=2=A=3=2@A?DGA=F=3@0=3?A@30=3>A=3=2LA=30=3OA@30=3>2AA?DGA=F=3"
DATA "@0=3>A>30=3>A>3=2AA>2?3@2=A=2=3~0>3SA=30=3=DQA=F=3?0>3=A>30=3@A=2?A"
DATA "=2=3=2EA=2>A=3|0=3UA=30=3=DSAB3>A=30=3BA>3=2KA=3{0=3GAIF=C=30=3@D=2"
DATA "AA=2>DHA=2?DAA=30=3=2GAIF=3z0>3FAKF=C=30=3BD=2?AADGA=2?D=A>D>A=30=3"
DATA "EAMF=3y0=3=DEAMF=C=3~0=3DD>A=2ADCA>D?A?2=A>D=A=3=20>3=2DANF=3x0>3>D=A"
DATA "=3BAMF=C=3~0=3ED>A=2ADCA=2=D=2EA=20>3EAPF=3w0=3AA=3?A=3NF=C>3~0=3=ACD"
DATA "=2?A=2?D?A?DFA?3=20=3GAOF=3w0=3BA=3?A=3NF=C=3~0=3>A=2BDGA>2EA>3=20=3"
DATA "FAQF=3v0=3CA=3?A>3LF=C=30=3?A=2?D=2AA=2>D>2FA?30=3@A>2@3QF=3v0=3DA=3"
DATA "=2@A=2>3HF=C>30=3HA=2BD=2EA=F=30=3BA>3SF?3s0=3FA>3=2AA=2>3EF>30=3HA"
DATA "=2DDEA=F=30=3BA>3PF=3=2>A>3q0=3=2EA>C>3=2BA=2>3AF=C=30=3AA=2>D=2?A=2"
DATA "DDDA>F=30=3BA=3=F=CMF=3=2@A>3n0=3>DDA?C?F=3=2CA>3>F=C=30=3@A=2AD=2>A"
DATA "DDDA>F=30=3AA=3=CLF=C>3BA>3l0=3>DCAAC?F>3?A=2>3=A=3>F=C=30=3@ACD>A=2"
DATA "BD=2CA>F=30D3@A=3>CJF>C=3=0=3=A=3AA=3j0=3>D=2AADC?F=3@A=3=F>3=F=C=30"
DATA "=3AACD@A=2>D=2EA=F=C=30>3@D=2>A=3=A=3=A=3=A=3@CEF@C=3=0=3=A=0=3=A>3=A"
DATA "=3j0=3>D=2?A=1FC>F=3=A>3>A=2?F=C=30=3=A?2=A=2AD=2LA=F=C=30>3=2AD=2>A"
DATA "=3=A=3=A>3=A=3LC=3=0=3=A=0=3=A>3=A=3j0=3=D=2?A>1GC=F=3=A?3=A=3>F=C=30"
DATA "=3=A@2>A=2>D=2LA?C=30=3?A=2?D=2?A=3=A=3=A=3=C>3LC=3=D=3=A>3=A=3=0=3j0"
DATA "=3>2?A?1HC=3=A=3>F>3=F>C=30>3>A@2BA=2@D=2FA>C=30GA=3=A=3=A=3OC=3?D>A"
DATA "=3m0=3@AA1GC=2=3=2CC@3>Dy0?3@A>2BA=2BD=2DA?C=30=3AA?3>A>3=C=3PC=3=D=2"
DATA "@Am0=3?AB1HC=2DC=3>2?A?Dt0>3>D=2HADDCA>1=C=30=3CA?3=1QC=3=2AA=3m0=3?A"
DATA "C1OC=1=3=2CA=3q0>3?D=2IA=2BD=2BA?1=C=30>3=2BA=3>1NC>1=3=2?A=3o0=3?AD1"
DATA "MC=1@3CA=3o0=3=A?2LA=2?D=2CA@1=30?3=2?A=3@1IC@1=3=2>A>3n0=3AAF1JC>1=3"
DATA "?0=3=A=3=A>3>Ao0=3[A@1>30>3?A?3>A=3A1CCD1=2>A=3n0>3>D@AJ1EC>1=3@0=3>A"
DATA "=3=A=3=0=An0=2[A@1>30=3>A?3AA=3O1=3=A>3@Aj0=3@DAAT1=3A0=3=A=3=A=3=0=A"
DATA "n0=3CAF3HA@1>30=3=A>3?A>3=2?A>3L1=3=2?AB3h0=3@DBAR1=C=3A0=3=A=3=A=3=0"
DATA "=3n0=3@A?3F0>3FA@30=3?A>3@A>3>0>3H1>3>2EA=3f0=3=2?D=2DAP1=3B0=3=A=3=A"
DATA "=3p0=3?A=3K0?3DA=30?3@A>3B0>3D1>3>0?3AA?3g0=3=A?2GAM1>3C0=3=0=3q0=3?A"
DATA "=3N0=3CA=30=3?A?3F0D3C0@3>A=3h0=3BA=2B3=2@AH1>2=3|0=3?A=3O0=3AA=2=D=3"
DATA "0?3\0>3j0=3AA=3C0@3=2CA=2?3>2>D=3o0C3@0=3?A=3P0=3@A=2=D=3!h0=3@A=3H0C3"
DATA "C2=A>D=3k0>3CA=3?0=3>A=3R0=3?A=2=D=3!h0=3@A=2N0?3@2@A=D=3i0=3>A>2@3>A=3"
DATA ">0=3>A=3S0=3>A=2=D=3!i0=3@A=3P0A3AA=3h0=2>3B0=3?A>3=A=3T0=3?A=D=3!j0=3"
DATA "?A=3T0>3=2@A=3m0=2>3CA=3T0=3@A=3!k0=3>A=2R0>3=2BA=2l0=3FA=3S0=3=2?A=2=3"
DATA "!l0=3>A=3M0?3=2AA=2?3l0=3?A>3>2?A=3S0=3=2?A=2=3!i0@3=2>A=2I0?3=2AA=2?3"
DATA "p0=3=A>3=0=2@A=3S0=3=2?A=2=3!e0@3=2DA=3G0=3BA>2=3t0=2=3?0=3=A?3S0=3=2?A"
DATA "=3!d0>3=2IA=3H0>3?A=2A3w0=2>3T0=3=2?A=3!d0=3@A=3=2DA>3K0>3CA=2?3s0=2=3"
DATA "T0=3=2@A=3!e0?3=2@A=2?A>3O0=3?A=2>3@A=3r0=3U0=3BA=2=3!d0=3?A?3>A>3R0>3"
DATA "@A=2?30=3DA=3!d0?3=2>A>3V0?3>A=30=3AA>2>A=3!e0=3=A>3[0>30=3=A=2>3>A"
DATA ">3=2=A=3#121#0=3=A=3>0=3>A=3=0=3=A=3#120#0=3=A=3?0=3=A=3>0=2=3#11F#0=3"
DATA "=2=3@0=3=2#124#0=3=2A0=3=2#CA5#0@3#124#0A3@A=3#122#0=3@A=3>A?3!0@30=3"
DATA "?A>3=7=A=3>F=3!0A3@A=30?A=7?F?3>F!0=3@A=3>A?30=3>A=7?FA3=C=3!}0=3?A"
DATA "=D=3=A>3>F=30>3>A=7>F@3>A@30?3>0?30?A=7?F=7>3>F0>3?A=7=C=F?3CA?30"
DATA ">3?A>3?A=30=3>A=3?FA3=C=30?3@A=7?C=7HA=30>3=2=A@3@A=30>3>A=7>F@3=A"
DATA "B30=3=D=2BA?7IA=30=3=2=D=2=A=3>F=3>A>F=30>3?A=7=C=F=7>3CA@30>3=D=2"
DATA "OA@30=3@2=3@F=3=A>F=30>3@A=D?C=3HA=3}0>3>D=2KAA3@F=3v0B3C0=3@2=A=3?F"
DATA ">3=A?30?3>DBA=3=7=3IA=3|0=3?D=2?A>2EA>3DF=3u0>3>D>A>DC3=A@2>A>C?3=A?3"
DATA "0?3?DOA@3|0=3?D=2?A=2>A=2=3AA>3FF=3s0>3?D@ABDEA=3=C?3>AA30>3@D?A>3FA"
DATA "B3?F=3z0=3=A?2DAB3GF=3s0=3@DBA@DGA?3CA@30>3=A>2=D=2?A?3CA?3=ACF=3z0=3"
DATA "CA=3?AOF=3r0=3BA?DZA>30>3DA>3=A>3@A?3FF=3y0=3=A=DBA=3=APF=3o0?3=D?3?A"
DATA "AD[A=30=3=A>3FAB3GF=3z0=3=A=DBA=3QF=3D0A3`0>3=A@D>A=3?A?DGA=2=3JA=2A3"
DATA "0=3>A=3AA=3?AOF=3y0=D?A=3BA=3PF=3B0>3BA=3]0=D?A?DOA@2=3FA=2?3=A>F=A0"
DATA "=3=D=A=3@A=3>AQF=3y0=3=D=A?C=3BA=3NF=3=2B3@AA3\0=3ZA>2E3=2=A@F0=3=D=A"
DATA "=3?A>3SF=3x0=3?A@C=3BA>3JF>C=3?2GA=3\0=3cACF0>D=A=3>A>3TF=3x0=3>ABC=3"
DATA "CA>3FF?C=3?2IA=3Y0=3?DGA=3QAGF=30=3=D=2=A=3>A=3TF=3x0=3?A=1BC?3CAD3@C"
DATA "=3>2>AA3>A?3>A=3X0ADFA=3GA?2AAIF=30?3@0=3>2=A>3>A=3RF>C=3v0>3=D?A=1EC"
DATA ">3HA>3>CB3A0=3>A=3=0?3V0CDEA=3GAA2>AHF>C=30=3=A>D=3?0=3=2?A=3>A=3=COF"
DATA "?C=3v0=3>D=2?A=1GC@3FA>3H0=3>AX0DDDA>3FA=3=A@2=3=AGF?C=30=3?A=3=D=3>0"
DATA "=3@A=3>A=3?CKF@C=1=3u0=3>D>2>A?1JCA3@A=3>A=3G0=3>AV0=3KA>3HA=3>A?2=3FF"
DATA "?C>30=3>2>A=3=D=3=0=3@A=3>A=3BCCFDC=1=3u0=3?D=2?A@1NC=3@A=3>A=3G0>3T0"
DATA "=3JA@3=2=3AFBA=3?A>2=3FF>C=30=3>D=2>A=3=A>3@A=3>A=3PC=1=3=A=3s0=3>D>2"
DATA "@AA1MC=3@A>3=A`0>3DAB3B2=3FF>C=3@A=3FF=C=30=3?D=2=A=3?A=3?A=3>A=3OC>1"
DATA "=3=A=3r0=3EAC1KC=3>A=3?A=3^0=3DA?3?AD2?3=CEF=C=3@A=3BF@C?30=3>D=2>A=3"
DATA "?A=3>A=3>A=3=1DCA3?C?1=3>A=3r0=3EAE1GC?1=3>A=3=A=3]0>3AA@3EA>2?3?0=3?C"
DATA "CF=C=3AACC=2=3?2B30=3>2?A=3>A=3=A=3@A=3=1BC=3AAB3?Ar0=3BAB3F1BC@1>3=A"
DATA ">3[0@3AA>3GA@3C0=3GC=3BA?3E2@AA30=3=2@A=3>A=3AA=3?1@C=3=A>3FA=3r0=3@A"
DATA ">3B0=3N1=3=0>3Z0?3CA>3EA@3H0>3FC=3CA?3@2HA?3}0>3@A=3=A=3=A=2=A=2=A=3D1"
DATA "=3GA=3s0=3?A=3E0?3I1>3]0=3EA=3BAA3N0>3EC=3EAF3EA=3~0>3?A>3=A=2=A=2>A=3"
DATA "C1=3?AC3t0=3?A=3K0?3BA>3]0>3@A=3?A>3@A?3U0>3DC>3EA>3B0=3>A@3=A=3=A=30"
DATA "=3?A=3=A=2=A=3>A=3B1=3?A=3>2?3v0=3?AN0=3AA=3^0=3?A=3=A=3>A>3AA=3[0H3CA"
DATA ">3B0=3>A>3=0=3=A>3y0B3AA=3=2=A>3=A=3B1=3>A=3=2=A>3x0=3>A=3M0=3BA=3^0=3"
DATA ">A=3=A=3>A>3?A=3>A=3g0A3@A=3B0=3>A>3>A>3w0>3GA?3=0@3A1=3=A=3=2>A=3@A>3"
DATA "s0?AM0=3BA=3`0=3=0B3?A=3>A=3l0>3=A=3>A=3B0=3>A@3w0=3?A>3BA>3D0E3=A=3>A"
DATA ">3?A=3q0?A=3L0=3>A=2?3i0=3>A=3>A=3n0=3=A>3=A=3C0=3>A=3z0?3BA=3P0>3@A?3"
DATA "i0E3>A=3L0=3>A=2n0A3o0=3=A=3=0>3D0>3{0=3?A=3?A=3Q0=3?A=3?A=3g0>3FA=2M0"
DATA "=3@A>2>30=3=A=30=3>A>3>A>3S0>3>A>3>A=3e0=3?A>3BA=3O0=3?A=3?A=30=30"
DATA ">3?A=3W0=3?A>3g0?3BA=3Q0=3@A?3!r0?3Y0?3i0=3?A=3?A=3R0=3>A=3?A=3#105#0=3"
DATA ">A>3>A>3T0=3>A>3>A=3#105#0>3?A=3W0=3?A>3#108#0?3Y0?3#112C#0GD]0G2=6=D@6"
DATA "A2C6[2=6=2=D@6>2@3=6@3A2=DU2=6=D@6A2C6P20ADE2?D[0G2=6=2=D@6>2@3=6@3A2"
DATA "=DV2C6=3?A?3?A=3Z2=6=2=D@6@2=6=DA6A2=DJ20?DC2=6C2?DY0H2C6=3?A=2=3=2?A"
DATA "=3]2@6=3AA=6?3>A=3>2=DW2C6@2B6P20>DG2=6D2?DW0J2@6=3>A=2>3=6>3=2>A=3>2"
DATA "=DX2A6=3>A>3=2=3=2>A=3=A=3\2B6=2>6=DB6?2=DK20>DH2=DG2CDQ0I2A6=3=A=3?F"
DATA "=3?F=3=A=3\2=6=2=D=3>A=3?A=3@A=3=A=3A2@6Q2M6O20>DK2=6L2?DO0J2=6=2=D=3"
DATA "=A=2>F=3=F=3=F=3>F=2=A=3A2G6K2?6=3=A=D@A=3@A=D=A=3>2J6K2=6=2=DI6=DB2G6"
DATA "=20=DN2=6M2@DL0J2?6=3=A=2=F=3=7?3=7=3=F=2=A=3>2K6J2?6=3=A=D?A?3?A=D=A"
DATA "=3M6J2?6=2A6=DC6?2K60=D?2>6I2=D>6O2>DK0J2?6=3=A=3=FC3=F=3=A=3E6=D>6O2"
DATA ">6=3?A?3?A?3?A=3B6=D=2=D>6O2W6=D>6A20>D@2=D>6I2>6I2=DB2?DI0J2>6=3>A=3"
DATA "=C?3=A?3=C=3>A=3B6=DS2>6=3>A=3>2BA=2=3>A=3?6=D>6T2@6=2E6=DF6=DE20>DC2"
DATA ">6H2?6G2=DE2>DH0J2>6=3>A=3>C=3?A=3>C=3>A=3?6=D>6?2@6M2=6=3>A=2GA=2>A=3"
DATA "=6=D@2=6=2@6M2A6=2L6=D>6?2@6?20=DF2?6F2@6Q2=DH0?6=D?6C2=6=3@A>2AA>2@A"
DATA "=3=6=D@2=6D2?6=D?6=2?6>2>6=3MA=3>6=2=6=2=6E2?6=D?6C2B6=D?6=D>6=DC6=D@2"
DATA "=6D20>DF2B6C2A6C2=DH2>DG0>6?2>6=D?6>2>6=3MA=3>6=2=6=2=6E2>6?2>6=D>2=6"
DATA "=D>6=3DA?2DA=3?6G2>6?2>6=D?6>2C6=2K6=2=6=2=6E20>DH2=6=D@6A2C6P2>DF0?2"
DATA "@6?2=6=D>6=3OA=3?6@2=6E2@6=2>6>2=6=3DA=2>3>2DA=3=6A2=6E2@6?2=6=DE6=2=D"
DATA "E6=D=6=2?6@2=6B20=DI2=6=2=D@6@2=6=DA6A2=DJ2?DE0B2@6>2=6=3QA=3=6N2B6=3"
DATA "EA@3=DEA=3N2@6>2H6=DD6>2>6H20>DJ2C6@2B6Q2>DE0C2A6=3?A=3?A?2>3?2@A=3?A"
DATA "=3O2A6=3DA=1A3=1DA=3O2A6=2=6=2=DB6=2D6=D?6J20>DM2B6=2>6=DB6?2=DM2=DE0"
DATA "?2=6@2@6=3>A=3=A>3=2DA=2=3?A=3>A=3K2=6A2>6=3DA>1A3>1DA=3J2=6@2A6>2E6=D"
DATA "B6=2>6K20=DM2M6Q2=DE0E2>6=3>A>3=2IA=2@3>A=3Q2=3DA=F>C=1?3=1>C=FDA=3O2"
DATA "@6=2=6>2B6=2A6=2=6=2>6K20>DN2=6=2=DI6=DB2G6@2=DD0F2=3?A=3@AGF@A=3?A=3"
DATA "O2=3AAAF=7=1AC=1=7AFAA=3=6N2C6=2B6=2@6=2@6K20=DO2?6=2A6=DC6?2K6>2?DC0"
DATA "E2=3BAMFBA=3=6M2=3?A=1CF=3A1=3BF=C=1?A=3=6P2B6=2A6=2=D=2=6=2H6D20=DO2"
DATA "W6=D>6D2>DC0E2=3@AQF@A=3=6=D>6I2?D=A=C=1=CDF?7CF>C=1=C=A@D>6N2B6>2H6=D"
DATA "?6=D?6=D>6A20=DO2@6=2E6=DF6=DI2=DC0D2?D=ACCGFCC=A?DA6G2?D=A=C>1>CKF>C"
DATA ">1=C=A?DA6L2C6=2>6=2=D=2P6?20=DO2A6=2L6=D>6?2@6C2>DB0D2?D=AUC=A?D?6=D"
DATA "@6D2=3?A=C?1@CEF@C?1=C?A=3?6=D@6D2I6=2=6=2A6=DJ6=D@60=D?2=D@6=D?6C2B6"
DATA "=D?6=D>6=DC6=D@2=6I2=DB0C2=6=3?AUC?A=3C6=DC2=6=3?A=C?1@CEF@C?1=C?A=3C6"
DATA "=DC2M6=DS6=D0=DA2?6?2>6=D?6>2C6=2K6=2=6=2=6J2>DA0B2?6=3>A=1SC>1=A=3B2"
DATA "?6B2?6=3>A>C@1HCA1>C>A=3B2?6B2E6=DB6=2?6=DC6H2?60=D>2>6A2@6?2=6=DE6=2"
DATA "=DE6=D=6=2?6@2=6G2>DA0@2?D?3>A>1QC>1>A?3?D?2=6@2?D?3>A>CC1BCC1?C>A?3?D"
DATA "?2=6A2B6=DB2=6=D>6=2=6=DC6L2=60>D?6E2@6>2H6=DD6>2>6N2=DA0>2CD=3>A@1MC"
DATA "?1?A=3CD@2CD=3?A>CN1?C?A=3CDB2=6=D>6G2?6=2D6N20=D=6=2=6G2A6=2=6=2=DB6"
DATA "=2D6=D?6P2=DA0?3=A?D?A=3>DB1GCA1=A>D=3?A?D=AB3=A?D?A=3>D=A?CK1?C=A>D=3"
DATA "?A?D=A?3?2?6I2?6=2=DA6P20=D>6D2=6@2A6>2E6=DB6=2>6Q2=DA0=3FA=3=D=AP1>A"
DATA "=D=3FA>3FA=3=D>A@CG1@C>A=D=3FA=3>2=6=DL2E6P20=D=6K2@6=2=6>2B6=2A6=2=6"
DATA "=2>6Q2B0?3EA>3=AO1>A=3EAB3EA>3?AACA1AC=3?A=3EA?3=2=6N2=6=2=6=D@6Q20=D"
DATA "=6L2C6=2B6=2@6=2@6Q2=DA0=2=DA3AA=3=A=3>AL1?A=3AAA3?2=DA3AA=3=A=3>A=3IC"
DATA "=3@A=3AAA3?2=DN2=6>2@6R20=D=6N2B6=2A6=2=D=2=6=2H6J2=DA0C2A3=A?3>A=3H1"
DATA ">A?3=AA3J2A3=A?3>A=3GC=3>A?3=AA3U2=D>6>2=D>6>2B6=D>6H20=DP2B6>2H6=D?6"
DATA "=D?6=D>6G2=DA0A2>3EA=3>AG3>A=3EA>3F2>3EA=3>AG3>A=3EA>3L2=D>6=DJ6=DD6=2"
DATA "=DE20=DP2C6=2>6=2=D=2P6F2=D@0@2=3?A>3CA=3>A>3A6=3?A=3CA>3?A=3D2=3?A>3"
DATA "CA=3>A>3A6=3?A=3CA>3?A=3K2>6D2=DA6>2>6B2>6F20=D=6J2I6=2=6=2A6=DJ6=D@6"
DATA "C2=D@0A2?3BA@3@A=3=D>6=3@A@3BA?3F2?3BA@3@A=3=D>6=3@A@3BA?3K2>6G2=D?6=2"
DATA ">6=2E6E20=D=6I2M6=DS6=D>6A2=D@0A2=3?A=3?A=3>2=3BA?3BA=3>2=3?A=3?A=3F2"
DATA "=3?A=3?A=3>2=3BA?3BA=3>2=3?A=3?A=3J2>6I2>6=DA6A2?6E20=D=6H2E6=DB6=2?6"
DATA "=DC6H2?6=2=D=6@2=D@0@2=3>A>3>A>3>2=3>A>3@A=3@A>3>A=3>2>3>A>3>A=3?2=6@2"
DATA "=3>A>3>A>3>2=3>A>3@A=3@A>3>A=3>2>3>A>3>A=3?2=6C2=D>6K2A6D2>6=2=DB2=60"
DATA "=DH2B6=DB2=6=D>6=2=6=DC6L2@6@2=D@0A2>3?A=3@2?3=2=3=A>3=A=3=A>3=A=3=2?3"
DATA "@2=3?A>3@2=6A2>3?A=3@2?3=2=3=A>3=A=3=A>3=A=3=2?3@2=3?A>3@2=6D2>6J2=D?6"
DATA "G2=6D2=60>DF2=6=D>6G2?6=2D6O2?6?2=D@0C2?3E2>3>2=3=2=3>6>3E2?3A2>6C2?3"
DATA "E2>3>2=3=2=3>6>3E2?3A2>6D2=6L2?6G2=6C2>60=DE2?6I2?6=2=DA6R2=6=D?2=D!0"
DATA "=DD2=6=DL2E6S2=6?2=D!0=DC2=6N2=6=2=6=D@6U2=D>2@08!X0>DB2=DN2=6>2@6X2"
DATA "=D@0=8>4B8C4C8>4?8A4?8D4>8@4F8A4C8?4?8!Y0=DS2=D>6>2=D>6>2B6=D>6K2=6>2=D"
DATA "@0=8>4B8C4C8>4?8B4>8E4=8B4B8D4A8B4=8!Y0=D@2=DG2=D>6=DJ6=DD6=2=DH2=6=2=D"
DATA "A0=8>4B8>4G8?4?8>4>8?4=8>4D8>4>8?4@8?4@8?4?8?4>8>4=8!Y0=DL2>6D2=DA6>2>6"
DATA "B2>6H2>6=2=DA0=8>4B8>4F8>4=8>4>8>4?8>4=8>4D8>4?8?4?8>4B8>4>8?4B8!Z0=DJ2"
DATA ">6G2=D?6=2>6=2E6G2>6=2=DA0=8>4B8>4F8>4=8>4>8>4>8?4=8>4D8>4@8>4>8?4B8>4"
DATA ">8>4C8!Z0=D?2=DE2>6I2>6=DA6A2?6E2@6=DB0=8>4B8C4@8>4>8>4>8B4>8D4>8>4@8>4"
DATA ">8>4C8>4=8>4=8C4!Z0>DF2=D>6K2A6D2>6=2=DB2A6=DB0=8>4B8C4?8C4>8A4?8D4>8>4"
DATA "?8>4?8>4C8>4=8>4=8C4![0=DG2>6J2=D?6G2=6D2A6C0=8>4B8>4D8C4>8>4B8>4D8B4@8"
DATA ">4B8?4=8>4B8>4!\0=D>6D2=6L2?6G2=6C2A6=DC0=8>4B8>4C8>4@8?4=8>4B8>4D8B4@8"
DATA ">4B8>4>8>4A8>4=8!\0=D?6S2=D>6L2=D?2@6=DD0=8>4B8>4C8>4A8>4=8>4B8>4D8>4>8"
DATA "?4@8>4@8?4>8>4@8?4=8!]0=D?6R2>6Q2?6>DD0=8C4=8C4=8>4B8>4=8>4B8>4D8>4@8?4"
DATA ">8D4@8C4>8!]0=D@6?2=DM2=D=6Q2>6=2F0=8C4>8B4=8>4B8>4=8>4B8>4D8>4A8>4@8@4"
DATA "C8@4@8!^0=D@6P2=6=DN2=D>2>6=D!0=DA6O2>6Q2>6!0>D?6=DO2=6=DL2=D=2>6=D!0"
DATA ">D?6O2=DL2@6=D#100#0>D>6=DJ2>6=D=6>D=2=6E2C6=D#101#0@D=6I2?6ADK6>D#104#0"
DATA "AD?6B2@6>D@0>DH6=D#109#0ADE6?DB0GD#10E#0HD#6EF#0>EH0>E=0>EF0>E=0>EF0>E"
DATA "G0?EG0>EG0>EI0>EG0>E0>EF0@EG0>EG0@EF0@EH0>EE0BEE0@E>0>EH0>E=0>EF0>E=0"
DATA ">EE0@EE0>E=0>E=0>EB0@EF0>EH0>EI0>EG0@E0>EE0>E>0>ED0@EF0>E>0>ED0>E>0>E"
DATA "F0?EE0>EH0>E>0>E=0>EH0>E=0>EE0CEC0BEE0?E=0>EC0@EF0>EH0>EI0>EH0>E0>EE0"
DATA ">E>0>EF0>EJ0>EH0>EF0?EE0>EH0>EA0>EW0>E=0>ED0@EJ0>EE0>EU0>EI0>EG0@EH0>E"
DATA "r0>EF0>E>0>EF0>EJ0>EH0>EE0@EE0AEE0>EA0>EW0>E=0>EE0?EI0>EF0>EU0>EI0>EW0"
DATA ">Er0>EF0>E>0>EF0>EI0>EG0?EF0@EE0>E>0>ED0AE>0>EW0>E=0>EF0?EG0>EF0BER0>E"
DATA "I0>EU0BER0?EV0>EG0>E>0>EF0>EH0>EJ0>ED0>E=0>EI0>ED0>E>0>E=0>EV0CEE0@EE0"
DATA ">E=0?EC0>E=0>ES0>EI0>EW0>Eq0>EG0>E>0>EF0>EG0>EK0>ED0BEH0>ED0>E>0>EZ0>E"
DATA "=0>ED0BED0>E=0>E=0>EB0>E=0>ES0>EI0>EW0>Ep0>EH0>E>0>EF0>EF0>EH0>E>0>EG0"
DATA ">EE0>E>0>ED0>E>0>E=0>EW0>E=0>EE0@EI0?ED0AER0>EI0>Ed0>EU0>EH0>EI0@EG0>E"
DATA "F0BEE0@EH0>EF0@EF0@Ej0>Ep0>EI0>Ec0>E!0>EG0>E#396#0AE!c0BEE0@EF0@E0@E"
DATA "F0?E?0?EC0>EE0AEF0AED0AEE0BED0BEE0AED0>E?0>EC0>EK0>EE0>E>0>ED0>EE0>ED0"
DATA ">E>0>ED0>E>0>E0>E>0>EE0>EA0>EC0>EE0>E>0>ED0>E?0>EC0>E>0>ED0>EH0>EH0>E"
DATA "?0>EC0>E?0>EC0>EK0>EE0>E=0>EE0>ED0>EE0>E>0>ED0>E>0>Ec0>ES0>EL0>ED0>E>0"
DATA "@E=0>EA0@ED0>E>0>ED0>EH0>E?0>EC0>EH0>EH0>EH0>E?0>EC0>EK0>EE0@EF0>ED0>E"
DATA "E0>E>0>ED0>E>0>ED0>EI0>EI0>EU0>EK0>ED0>E=0>E=0>E=0>EA0@ED0>E>0>ED0>EH0"
DATA ">E?0>EC0>EH0>EH0>EH0>E?0>EC0>EK0>EE0?EG0>EC0>EG0@EF0AEa0>EG0BEF0>EI0>E"
DATA "E0>E=0>E=0>E=0>E@0>E>0>EC0AEE0>EH0>E?0>EC0AEE0AEE0>E=0@EC0CEC0>EK0>EE0"
DATA "?EG0>EC0>EF0>E>0>EH0>E`0>EY0>EG0>EF0>E>0CE@0>E>0>EC0>E>0>ED0>EH0>E?0>E"
DATA "C0>EH0>EH0>E?0>EC0>E?0>EC0>EK0>EE0@EF0>EB0>EG0>E>0>EH0>Ea0>EG0BEF0>EH0"
DATA ">EG0>EH0BEC0>E>0>ED0>EH0>E?0>EC0>EH0>EH0>E?0>EC0>E?0>EC0>EH0>E=0>EE0>E"
DATA "=0>EE0>EB0>EG0>E>0>ED0>E>0>Eb0>EU0>EV0?EF0>E@0>EB0>E>0>ED0>E?0>EC0>E>0"
DATA ">ED0>EH0>EH0>E>0?EC0>E?0>EC0>EH0>E=0>EE0>E>0>ED0>EB0>EH0@EF0@EE0>EI0>E"
DATA "J0>ES0>EJ0>EJ0@EB0>E@0>EB0AEF0AED0AEE0BED0>EI0BEC0>E?0>EC0>EI0?EF0>E?0"
DATA ">EC0BEu0>E#56A#0>Ew0>E@0>EB0>E?0>ED0AED0BEE0AED0BEE0@EE0BED0>E?0>EC0>E"
DATA "@0>EB0>ED0>E>0>E@0>EB0>E@0>EB0DEB0?EG0>EH0?EH0@ES0>EV0>EA0>E@0>EB0?E>0"
DATA ">EC0>E?0>EC0>E?0>EC0>E?0>EC0>E?0>EC0>E>0>EF0>EF0>E?0>EC0>E@0>EB0>ED0>E"
DATA ">0>E@0>EB0>E@0>EH0>EB0>EH0>EI0>EG0>E>0>ES0>EU0>EA0?E>0?EB0?E>0>EC0>E?0"
DATA ">EC0>E?0>EC0>E?0>EC0>E?0>EC0>EJ0>EF0>E?0>ED0>E>0>ED0>E>0>E>0>E@0>E>0>E"
DATA "D0>E>0>EH0>EC0>EH0>EI0>E0>EA0?E>0?EB0@E=0>EC0>E?0>EC0>E?0>EC0>E?0>EC0"
DATA ">E?0>EC0>EJ0>EF0>E?0>ED0>E>0>ED0>E>0>E>0>EA0@EF0@EH0>ED0>EI0>EH0>Er0@E"
DATA "E0AE>0DEB0@E=0>EC0>E?0>EC0BED0>E?0>EC0BEE0@EG0>EF0>E?0>ED0>E>0>ED0>E>0"
DATA ">E>0>EB0>EH0>EH0>EE0>EI0>EH0>Eu0>ED0>E>0>E=0DEB0>E=0@EC0>E?0>EC0>EH0>E"
DATA "?0>EC0>E?0>EG0>EF0>EF0>E?0>EE0@EF0DEB0@EG0>EG0>EF0>EJ0>EG0>Er0AED0>E>0"
DATA ">E=0>E=0>E=0>EB0>E>0?EC0>E?0>EC0>EH0>E=0@EC0>E?0>EG0>EF0>EF0>E?0>EE0@E"
DATA "F0DEA0>E>0>EF0>EF0>EG0>EJ0>EG0>Eq0>E>0>ED0>E>0>E=0>E=0>E=0>EB0>E>0?EC0"
DATA ">E?0>EC0>EH0>E>0?EC0>E?0>EC0>E>0>EF0>EF0>E?0>EF0>EH0>E>0>EA0>E@0>EE0>E"
DATA "E0>EH0>EK0>EF0>Eq0>E>0>ED0>E>0>E=0>E@0>EB0>E?0>ED0AED0>EI0AED0>E?0>ED0"
DATA "@EG0>EG0AEG0>EH0>E>0>EA0>E@0>EE0>EE0DEB0>EK0>EF0>Er0AED0AE{0>E!A0>EW0>E"
DATA "#10E#0?EU0?EU0CE#3C3#0>ES0>EU0>EH0>EH0>EH0>EH0>E!{0>ER0>EV0>Ed0>EH0>E0"
DATA ">E0>ER0>EV0>Ed0>EH0>E0>Ez0@EF0AEE0@EE0?EH0AED0AEE0>EH0>EH0>E=0>EE0>E"
DATA "H0CEC0AEF0@EE0AEF0AED0?EH0?EF0?EG0>E>0>ED0>E>0>ED0>E=0>E=0>EB0>E=0>E>0"
DATA ">E>0>ED0>E>0>ED0>E>0>ED0>EH0>E>0>ED0?E=0>ED0>EH0>EH0@EF0>EH0>E=0>E=0>E"
DATA "B0?E=0>ED0>E>0>ED0>E>0>ED0>E>0>ED0>EH0>E=0>EE0>EH0>E>0>ED0>E>0>ED0>E=0"
DATA ">E=0>EB0>E=0>E>0>EH0>E>0>ED0BED0>EH0>E>0>ED0>E>0>ED0>EH0>EH0?EG0>EH0>E"
DATA "=0>E=0>EB0>E>0>ED0>E>0>ED0>E>0>ED0>E>0>ED0>EI0>EG0>EH0>E>0>EE0@EE0DEC0"
DATA "?E?0>EH0>E>0>ED0>EH0>EH0>E>0>ED0>E>0>ED0>EH0>EH0@EF0>EH0>E=0>E=0>EB0>E"
DATA ">0>ED0>E>0>ED0>E>0>ED0>E>0>ED0>EJ0>EF0>EH0>E>0>EE0@EE0DEC0?E?0>E>0>ED0"
DATA ">E>0>ED0>E>0>ED0>EH0>E>0>ED0>E>0>ED0>EH0>EH0>E=0>EE0>EH0>E=0>E=0>EB0>E"
DATA ">0>ED0>E>0>ED0>E>0>ED0>E>0>ED0>EH0>E=0>EE0>EH0>E=0?EF0>EG0>E>0>EC0>E=0"
DATA ">E?0@EF0AEE0@EE0>EI0AED0>E>0>ED0>EH0>EH0>E>0>ED0>EH0>E=0>E=0>EB0>E>0>E"
DATA "E0@EE0AEF0AED0>EI0?EG0>EH0AEF0>EG0>E>0>EC0>E=0>Ez0>E`0>E0>EL0>E!W0AEa0"
DATA ">E0>EL0>E#2DB#0>ET0>E#110#0>EG0>EI0>EU0=BI0=B>0=BG0=B>0=BG0=BH0>BH0=B"
DATA "H0=BJ0=BH0=B0=BG0?B\0>EG0>EI0>EH0?E=0=E=BC0=BI0=B>0=BG0=B>0=BF0?BF0=B"
DATA ">0=B>0=BC0=B=0=BG0=BI0=BJ0=BH0=B=0=B0=BF0=B?0=B[0>EG0>EI0>EG0>E=0?ED0"
DATA "=BI0=B>0=BF0BBD0=B=0=B=0=BF0>B>0=BD0=B=0=BG0=BI0=BJ0=BI0=B0=BF0=B?0=B"
DATA "?0>E=0>ED0AEF0>EG0>EI0>EU0=BX0=B>0=BE0=B=0=BK0=BF0=BV0=BJ0=BH0=B=0=BI0"
DATA "=Bs0=BG0=B?0=B?0>E=0>EG0>EE0>EH0>EJ0>ET0=BX0=B>0=BF0>BJ0=BG0=BV0=BJ0=B"
DATA "X0=Bs0=BG0=B?0=B?0>E=0>EF0>EG0>EG0>EI0>EU0=BX0=B>0=BG0>BH0=BG0=B=0=B=0"
DATA "=BS0=BJ0=BV0ABS0>BW0=BH0=B?0=B?0>E=0>EE0>EH0>EG0>EI0>EU0=BW0BBF0=B=0=B"
DATA "F0=B>0>BD0=B>0=BT0=BJ0=BX0=Br0=BH0=B?0=B@0?EE0>EI0>EG0>EI0>Er0=B>0=BE0"
DATA "=B=0=B=0=BE0=B>0=B>0=BC0=B>0=BT0=BJ0=BX0=Bq0=BI0=B?0=B@0>EF0AEF0>EG0>E"
DATA "I0>EU0=BX0=B>0=BF0?BJ0>BE0>B=0=BS0=BJ0=Be0=BV0=BI0=BJ0?BA0>EV0>EF0>EH0"
DATA ">E0=Bq0=BJ0=Bd0=Bz0?E!p0=BH0=B#3F1#0=BH0?BG0?BI0=BF0ABF0?BF0ABF0?BG0?B"
DATA "0?BI0@BF0=BF0@BG0@BE0@BF0ABE0AB>0?BG0=B?0=BE0=B?0=BG0>BF0=BI0=B?0=BI0"
DATA "=BE0=B?0=BE0=B?0=B0=B?0=BF0>B@0>BD0=BF0=B?0=BE0=B@0=BD0=B?0=BE0=BI0=B"
DATA "D0=BK0=BI0=BG0>BF0=BI0=BL0=BF0=B?0=BE0=B?0=Bd0=BT0=BM0=BF0=BB0=BC0=B=0"
DATA "=BE0=B?0=BE0=BI0=B@0=BD0=BI0=BD0=BK0=BI0=BF0=B=0=BF0@BF0=BL0=BF0=B?0=B"
DATA "E0=B?0=BE0=BJ0=BJ0=BV0=BL0=BE0=B?0?B>0=BB0=B=0=BE0=B?0=BE0=BI0=B@0=BD0"
DATA "=BI0=BD0=BJ0=BH0>BG0=B=0=BF0=B?0=BE0@BH0=BH0?BG0@Bb0=BH0ABG0=BJ0=BF0=B"
DATA ">0=B>0=B>0=BA0=B?0=BD0@BF0=BI0=B@0=BD0@BF0@BA0=BI0=BK0=BE0=B>0=BJ0=BE0"
DATA "=B?0=BG0=BG0=B?0=BI0=Ba0=BZ0=BH0=BG0=B>0=B>0=B>0=BA0=B?0=BD0=B?0=BE0=B"
DATA "I0=B@0=BD0=BI0=BD0=BH0=BL0=BE0ABI0=BE0=B?0=BF0=BH0=B?0=BI0=Bb0=BH0ABG0"
DATA "=BI0=BG0=B?0>B=0?BA0ABD0=B?0=BE0=BI0=B@0=BD0=BI0=BD0=BG0=BI0=B?0=BH0=B"
DATA "F0=B?0=BE0=B?0=BF0=BH0=B?0=BE0=B?0=Bc0=BV0=BW0=BH0=BA0=BC0=B?0=BE0=B@0"
DATA "=BD0=B?0=BE0=BI0=BD0=BG0ABF0?BI0=BG0?BG0?BG0=BI0?BG0?BF0=BJ0=BK0=BT0=B"
DATA "K0=BH0>BG0=BA0=BC0@BG0@BE0@BF0ABE0=B!N0=B0AB#508#0@BE0=B@0=BD0=BL0=BF0"
DATA "=B?0=BE0=BI0=BA0=BC0=B@0=BE0@BE0ABF0@BE0ABF0?BF0ABE0=B@0=BD0=BA0=BC0=B"
DATA "E0=B?0=BA0=BC0=BA0=BC0CBC0>BH0=BB0=B@0=BD0=B@0=BD0=BL0=BF0=B>0=BF0=BI0"
DATA "=BA0=BC0>B?0=BD0=B@0=BD0=B@0=BD0=B@0=BD0=B@0=BD0=B?0=BG0=BG0=B@0=BD0=B"
DATA "A0=BC0=BE0=B?0=BA0=BC0=BA0=BI0=BC0=BI0=BB0=BI0=B@0=BD0=BL0=BF0=B=0=BG0"
DATA "=BI0>B?0>BC0>B?0=BD0=B@0=BD0=B@0=BD0=B@0=BD0=B@0=BD0=BK0=BG0=B@0=BE0=B"
DATA "?0=BE0=B?0=B?0=BA0=B?0=BE0=B?0=BI0=BD0=BI0=BB0=BI0=B@0=BD0=BL0=BF0>BH0"
DATA "=BI0>B?0>BC0=B=0=B>0=BD0=B@0=BD0=B@0=BD0=B@0=BD0=B@0=BD0=BK0=BG0=B@0=B"
DATA "E0=B?0=BE0=B?0=B?0=BB0=B=0=BG0=B=0=BI0=BE0=BJ0=BA0=B>0?BD0BBD0=BL0=BF0"
DATA ">BH0=BI0=B=0=B=0=B=0=BC0=B=0=B>0=BD0=B@0=BD0ABE0=B@0=BD0ABF0?BH0=BG0=B"
DATA "@0=BE0=B?0=BE0=B?0=B?0=BC0=BI0=BI0=BF0=BJ0=BA0=B@0=BD0=B@0=BD0=BL0=BF0"
DATA "=B=0=BG0=BI0=B=0=B=0=B=0=BC0=B>0=B=0=BD0=B@0=BD0=BI0=B@0=BD0=B@0=BH0=B"
DATA "G0=BG0=B@0=BF0=B=0=BG0=B=0=B=0=B=0=BC0=B=0=BH0=BH0=BG0=BK0=B@0=B@0=BD0"
DATA "=B@0=BD0=BI0=B>0=BF0=B>0=BF0=BI0=B>0=B>0=BC0=B?0>BD0=B@0=BD0=BI0=B>0=B"
DATA "=0=BD0=B@0=BH0=BG0=BG0=B@0=BF0=B=0=BG0=B=0=B=0=B=0=BB0=B?0=BG0=BG0=BH0"
DATA "=BK0=B@0=B?0>BD0=B@0=BD0=BI0=B>0=BF0=B?0=BE0=BI0=B>0=B>0=BC0=B?0>BD0=B"
DATA "@0=BD0=BI0=B?0>BD0=B@0=BD0=B?0=BG0=BG0=B@0=BG0=BI0=B?0=BB0=BA0=BF0=BF0"
DATA "=BI0=BL0=B@0?B=0=BD0=B@0=BD0=BJ0>BG0=B@0=BD0ABE0=BA0=BC0=B@0=BE0@BE0=B"
DATA "J0@BE0=B@0=BE0?BH0=BH0@BH0=BI0=B?0=BB0=BA0=BF0=BF0CBC0=BL0=B!P0=B!B0=B"
DATA "#12C#0>B#27D#0=B#11C#0>BI0=B=0=BT0=BW0=B[0=BT0=BV0=BI0=BI0=BI0=BI0=B0"
DATA "=BH0=B?0=BT0=BV0=B[0=BS0=BW0=Be0=BI0=B0=B0=B[0=BS0=BW0=Be0=BI0=B0=B"
DATA "s0?BF0@BG0?BG0@BF0?BF0>BI0@BE0=B=0>BF0=BI0=BI0=B>0=BF0=BI0?B=0>BD0=B=0"
DATA ">BG0?BF0@BG0@BE0>BB0=Bv0=BE0=B?0=BE0=B?0=BE0=B?0=BE0=B?0=BE0=BI0=B?0=B"
DATA "E0>B>0=BE0=BI0=BI0=B=0=BG0=BI0=B>0=B>0=BC0>B>0=BE0=B?0=BE0=B?0=BE0=B?0"
DATA "=BE0=BC0=Bs0@BE0=B?0=BE0=BI0=B?0=BE0ABE0=BI0=B?0=BE0=B?0=BE0=BI0=BI0>B"
DATA "H0=BI0=B>0=B>0=BC0=B?0=BE0=B?0=BE0=B?0=BE0=B?0=BE0=BC0=Br0=B?0=BE0=B?0"
DATA "=BE0=BI0=B?0=BE0=BI0=BI0=B?0=BE0=B?0=BE0=BI0=BI0=B=0=BG0=BI0=B>0=B>0=B"
DATA "C0=B?0=BE0=B?0=BE0=B?0=BE0=B?0=BE0=BC0=Br0=B?0=BE0=B?0=BE0=B?0=BE0=B?0"
DATA "=BE0=B?0=BE0=BI0=B?0=BE0=B?0=BE0=BI0=BI0=B>0=BF0=BI0=B>0=B>0=BC0=B?0=B"
DATA "E0=B?0=BE0=B?0=BE0=B?0=BE0=BC0=Bs0@BE0@BG0?BG0@BF0?BF0=BJ0@BE0=B?0=BE0"
DATA "=BI0=BI0=B?0=BE0=BI0=B>0=B>0=BC0=B?0=BF0?BF0@BG0@BE0=BC0=B!J0=Ba0=B0=B"
DATA "M0=BL0>BV0BB0@Bb0=B0=BM0=B#2DC#0=BU0=B#111#0=BH0=BJ0=B!i0=B0=BH0=BJ0"
DATA "=BI0>B>0=B!W0=B0=BH0=BJ0=BH0=B>0>B!K0>BG0>BH0=B?0=BE0=B?0=BE0=B>0=B>0"
DATA "=BC0=B>0=BG0=B>0=BE0@BG0=BH0=BJ0=B![0=B>0=BF0=BI0=B?0=BE0=B?0=BE0=B>0=B"
DATA ">0=BC0=B>0=BG0=B>0=BH0=BF0=BI0=BK0=B![0=BH0=BI0=B?0=BF0=B=0=BF0=B=0=B=0"
DATA "=B=0=BD0>BH0=B>0=BG0=BH0=BH0=BJ0=B!]0=BG0=BI0=B?0=BF0=B=0=BF0=B=0=B=0=B"
DATA "=0=BD0>BH0=B>0=BF0=BI0=BH0=BJ0=B![0=B>0=BF0=BI0=B>0>BG0=BH0=B?0=BD0=B>0"
DATA "=BH0>BF0=BJ0=BH0=BJ0=B!\0>BH0=BI0>B=0=BG0=BH0=B?0=BD0=B>0=BH0=BG0@BG0=B"
DATA "H0=BJ0=B!0=BW0=BG0=BI0=B!0>B!0"

SUB GetFROG (x, y, FileNAME$)

Index = 1
FOR xx = x TO x + 180 STEP 90
    GET (xx, y)-(xx + 89, y + 67), Box(Index)
    Index = Index + 3300
NEXT xx
FOR xx = x TO x + 269
    FOR yy = y TO y + 67
        IF POINT(xx, yy) = 0 THEN PSET (xx, yy), 15 ELSE PSET (xx, yy), 0
    NEXT yy
NEXT xx
Index = 1651
FOR xx = x TO x + 180 STEP 90
    GET (xx, y)-(xx + 89, y + 67), Box(Index)
    PUT (xx, y), Box(Index)
    Index = Index + 3300
NEXT xx
FOR n = 9901 TO 9921
    READ LeapVALUE: Box(n) = LeapVALUE
NEXT n

ByteCOUNT = 20000
DEF SEG = VARSEG(Box(1))
BSAVE FileNAME$, VARPTR(Box(1)), ByteCOUNT
DEF SEG

END SUB

SUB PrintSTRING (x, y, Prnt$, Font)

'Bold face font begins at index 2, regular face at index 4702
Hop = Font * 4700
FOR n = 1 TO LEN(Prnt$)
    Char$ = MID$(Prnt$, n, 1)
    IF Char$ = " " THEN
        x = x + FontBOX(1)
    ELSE
        Index = (ASC(Char$) - 33) * 50 + 2 + Hop
        PUT (x, y), FontBOX(Index)
        x = x + FontBOX(Index)
    END IF
NEXT n

END SUB

SUB Rings (Pad, Colr)

SELECT CASE Pad
    CASE 1: y = 95: x = 318
    CASE 2: y = 175: x = 270
    CASE 3: y = 175: x = 366
    CASE 4: y = 255: x = 222
    CASE 5: y = 255: x = 318
    CASE 6: y = 255: x = 414
    CASE 7: y = 335: x = 174
    CASE 8: y = 335: x = 270
    CASE 9: y = 335: x = 366
    CASE 10: y = 335: x = 462
    CASE 11: y = 415: x = 126
    CASE 12: y = 415: x = 222
    CASE 13: y = 415: x = 318
    CASE 14: y = 415: x = 414
    CASE 15: y = 415: x = 510
END SELECT

CIRCLE (x, y), 44, Colr
CIRCLE (x, y), 39, Colr

END SUB
