/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.BLabel;
import com.apollographql.apollo.api.BPossibleTypes;
import com.apollographql.apollo.api.BTerm;
import com.apollographql.apollo.api.BVariable;
import com.apollographql.apollo.api.BooleanExpression;
import com.apollographql.apollo.api.DeferredFragmentIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

public final class BooleanExpressions {
    public static final BooleanExpression<BPossibleTypes> possibleTypes(String ... typenames) {
        Intrinsics.checkNotNullParameter(typenames, "typenames");
        return new BooleanExpression.Element<BPossibleTypes>(new BPossibleTypes(ArraysKt.toSet(typenames)));
    }

    public static final <T> boolean evaluate(BooleanExpression<? extends T> $this$evaluate, Function1<? super T, Boolean> block) {
        boolean bl;
        block18: {
            Intrinsics.checkNotNullParameter($this$evaluate, "<this>");
            Intrinsics.checkNotNullParameter(block, "block");
            BooleanExpression<? extends T> booleanExpression = $this$evaluate;
            if (Intrinsics.areEqual(booleanExpression, BooleanExpression.True.INSTANCE)) {
                bl = true;
            } else if (Intrinsics.areEqual(booleanExpression, BooleanExpression.False.INSTANCE)) {
                bl = false;
            } else if (booleanExpression instanceof BooleanExpression.Not) {
                bl = !BooleanExpressions.evaluate(((BooleanExpression.Not)$this$evaluate).getOperand(), block);
            } else if (booleanExpression instanceof BooleanExpression.Or) {
                Iterable $this$any$iv = ((BooleanExpression.Or)$this$evaluate).getOperands();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl2 = false;
                        if (!BooleanExpressions.evaluate(it, block)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            } else if (booleanExpression instanceof BooleanExpression.And) {
                Iterable $this$all$iv = ((BooleanExpression.And)$this$evaluate).getOperands();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl3 = false;
                        if (BooleanExpressions.evaluate(it, block)) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            } else if (booleanExpression instanceof BooleanExpression.Element) {
                bl = block.invoke(((BooleanExpression.Element)$this$evaluate).getValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean evaluate(BooleanExpression<? extends BTerm> $this$evaluate, Set<String> variables, String typename, Set<DeferredFragmentIdentifier> deferredFragmentIdentifiers, List<? extends Object> path) {
        Intrinsics.checkNotNullParameter($this$evaluate, "<this>");
        List<? extends Object> list = path;
        List croppedPath = list != null ? CollectionsKt.drop((Iterable)list, 1) : null;
        return BooleanExpressions.evaluate($this$evaluate, arg_0 -> BooleanExpressions.evaluate$lambda$2(variables, deferredFragmentIdentifiers, croppedPath, typename, arg_0));
    }

    private static final boolean hasDeferredFragment(Set<DeferredFragmentIdentifier> deferredFragmentIdentifiers, List<? extends Object> path, String label) {
        if (deferredFragmentIdentifiers == null) {
            return true;
        }
        return deferredFragmentIdentifiers.contains(new DeferredFragmentIdentifier(path, label));
    }

    private static final boolean evaluate$lambda$2(Set $variables, Set $deferredFragmentIdentifiers, List $croppedPath, String $typename, BTerm it) {
        boolean bl;
        Intrinsics.checkNotNullParameter(it, "it");
        BTerm bTerm = it;
        if (bTerm instanceof BVariable) {
            Set set = $variables;
            bl = !(set != null ? set.contains(((BVariable)it).getName()) : false);
        } else if (bTerm instanceof BLabel) {
            List list = $croppedPath;
            Intrinsics.checkNotNull(list);
            bl = BooleanExpressions.hasDeferredFragment($deferredFragmentIdentifiers, list, ((BLabel)it).getLabel());
        } else if (bTerm instanceof BPossibleTypes) {
            bl = CollectionsKt.contains((Iterable)((BPossibleTypes)it).getPossibleTypes(), $typename);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

