/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.Upload;
import com.apollographql.apollo.api.http.CountingSink;
import com.apollographql.apollo.api.http.HttpBody;
import com.apollographql.apollo.api.json.-JsonWriters;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.JsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;

public final class UploadsHttpBody
implements HttpBody {
    private final Map<String, Upload> uploads;
    private final ByteString operationByteString;
    private final String boundary;
    private final String contentType;
    private final Lazy contentLength$delegate;

    public UploadsHttpBody(Map<String, ? extends Upload> uploads, ByteString operationByteString) {
        Intrinsics.checkNotNullParameter(uploads, "uploads");
        Intrinsics.checkNotNullParameter(operationByteString, "operationByteString");
        this.uploads = uploads;
        this.operationByteString = operationByteString;
        boolean $i$f$uuid4 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        String string = uUID.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.boundary = string;
        this.contentType = "multipart/form-data; boundary=" + this.boundary;
        this.contentLength$delegate = LazyKt.lazy(() -> UploadsHttpBody.contentLength_delegate$lambda$1(this));
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getContentLength() {
        Lazy lazy = this.contentLength$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter(bufferedSink, "bufferedSink");
        this.writeBoundaries(bufferedSink, true);
    }

    /*
     * WARNING - void declaration
     */
    private final ByteString buildUploadMap(Map<String, ? extends Upload> uploads) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        String indent$iv = null;
        boolean $i$f$buildJsonByteString = false;
        Buffer buffer$iv = new Buffer();
        JsonWriter $this$buildUploadMap_u24lambda_u243 = new BufferedSinkJsonWriter(buffer$iv, indent$iv);
        boolean bl = false;
        Iterable iterable = uploads.entrySet();
        JsonWriter jsonWriter = $this$buildUploadMap_u24lambda_u243;
        boolean $i$f$mapIndexed = false;
        void var10_10 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void entry;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to(String.valueOf((int)index), CollectionsKt.listOf(entry.getKey())));
        }
        -JsonWriters.writeAny(jsonWriter, MapsKt.toMap((List)destination$iv$iv));
        return buffer$iv.readByteString();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeBoundaries(BufferedSink $this$writeBoundaries, boolean writeUploadContents) {
        $this$writeBoundaries.writeUtf8("--" + this.boundary + "\r\n");
        $this$writeBoundaries.writeUtf8("Content-Disposition: form-data; name=\"operations\"\r\n");
        $this$writeBoundaries.writeUtf8("Content-Type: application/json\r\n");
        $this$writeBoundaries.writeUtf8("Content-Length: " + this.operationByteString.size() + "\r\n");
        $this$writeBoundaries.writeUtf8("\r\n");
        $this$writeBoundaries.write(this.operationByteString);
        ByteString uploadsMap = this.buildUploadMap(this.uploads);
        $this$writeBoundaries.writeUtf8("\r\n--" + this.boundary + "\r\n");
        $this$writeBoundaries.writeUtf8("Content-Disposition: form-data; name=\"map\"\r\n");
        $this$writeBoundaries.writeUtf8("Content-Type: application/json\r\n");
        $this$writeBoundaries.writeUtf8("Content-Length: " + uploadsMap.size() + "\r\n");
        $this$writeBoundaries.writeUtf8("\r\n");
        $this$writeBoundaries.write(uploadsMap);
        Iterable $this$forEachIndexed$iv = this.uploads.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void upload;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Upload upload2 = (Upload)item$iv;
            int index = n;
            boolean bl = false;
            $this$writeBoundaries.writeUtf8("\r\n--" + this.boundary + "\r\n");
            $this$writeBoundaries.writeUtf8("Content-Disposition: form-data; name=\"" + index + '\"');
            if (upload.getFileName() != null) {
                $this$writeBoundaries.writeUtf8("; filename=\"" + upload.getFileName() + '\"');
            }
            $this$writeBoundaries.writeUtf8("\r\n");
            $this$writeBoundaries.writeUtf8("Content-Type: " + upload.getContentType() + "\r\n");
            long contentLength = upload.getContentLength();
            if (contentLength != -1L) {
                $this$writeBoundaries.writeUtf8("Content-Length: " + contentLength + "\r\n");
            }
            $this$writeBoundaries.writeUtf8("\r\n");
            if (!writeUploadContents) continue;
            upload.writeTo($this$writeBoundaries);
        }
        $this$writeBoundaries.writeUtf8("\r\n--" + this.boundary + "--\r\n");
    }

    /*
     * WARNING - void declaration
     */
    private static final long contentLength_delegate$lambda$1(UploadsHttpBody this$0) {
        long l;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        CountingSink countingSink = new CountingSink(Okio.blackhole());
        BufferedSink bufferedCountingSink = Okio.buffer(countingSink);
        this$0.writeBoundaries(bufferedCountingSink, false);
        bufferedCountingSink.flush();
        Iterable iterable = this$0.uploads.values();
        long l2 = countingSink.getBytesWritten();
        long l3 = 0L;
        for (Object t : iterable) {
            void it;
            Upload upload = (Upload)t;
            l = l3;
            boolean bl = false;
            long l4 = it.getContentLength();
            l3 = l + l4;
        }
        l = l3;
        long result2 = l2 + l;
        return result2;
    }
}

