/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.json;

import com.apollographql.apollo.api.json.JsonNumber;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.internal.JsonScope;
import com.apollographql.apollo.exception.JsonDataException;
import com.apollographql.apollo.exception.JsonEncodingException;
import java.io.EOFException;
import java.util.Arrays;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public final class BufferedSourceJsonReader
implements JsonReader {
    public static final Companion Companion = new Companion(null);
    private final BufferedSource source;
    private final Buffer buffer;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack;
    private int stackSize;
    private String[] pathNames;
    private int[] pathIndices;
    private int[] indexStack;
    private int indexStackSize;
    private static final ByteString SINGLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("'\\");
    private static final ByteString DOUBLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("\"\\");
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.Companion.encodeUtf8("{}[]:, \n\t\r/\\;#=");

    public BufferedSourceJsonReader(BufferedSource source2) {
        int[] nArray;
        Intrinsics.checkNotNullParameter(source2, "source");
        this.source = source2;
        this.buffer = this.source.getBuffer();
        int[] nArray2 = nArray = new int[64];
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        $this$stack_u24lambda_u240[0] = 6;
        bufferedSourceJsonReader.stack = nArray;
        this.stackSize = 1;
        this.pathNames = new String[64];
        this.pathIndices = new int[64];
        int[] $this$stack_u24lambda_u240 = nArray = new int[64];
        bufferedSourceJsonReader = this;
        boolean bl2 = false;
        $this$indexStack_u24lambda_u241[0] = false;
        bufferedSourceJsonReader.indexStack = nArray;
        this.indexStackSize = 1;
    }

    @Override
    public JsonReader beginArray() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$beginArray_u24lambda_u243 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$beginArray_u24lambda_u243.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$beginArray_u24lambda_u243.doPeek();
        if (p != 3) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$beginArray_u24lambda_u243.peek()) + " at path " + $this$beginArray_u24lambda_u243.getPathAsString());
        }
        $this$beginArray_u24lambda_u243.push(1);
        $this$beginArray_u24lambda_u243.pathIndices[$this$beginArray_u24lambda_u243.stackSize - 1] = 0;
        $this$beginArray_u24lambda_u243.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    public JsonReader endArray() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$endArray_u24lambda_u245 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$endArray_u24lambda_u245.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$endArray_u24lambda_u245.doPeek();
        if (p != 4) {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$endArray_u24lambda_u245.peek()) + " at path " + $this$endArray_u24lambda_u245.getPathAsString());
        }
        int n4 = $this$endArray_u24lambda_u245.stackSize;
        $this$endArray_u24lambda_u245.stackSize = n4 + -1;
        int[] nArray = $this$endArray_u24lambda_u245.pathIndices;
        int n5 = $this$endArray_u24lambda_u245.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        $this$endArray_u24lambda_u245.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    public JsonReader beginObject() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$beginObject_u24lambda_u247 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$beginObject_u24lambda_u247.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$beginObject_u24lambda_u247.doPeek();
        if (p != 1) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$beginObject_u24lambda_u247.peek()) + " at path " + $this$beginObject_u24lambda_u247.getPathAsString());
        }
        $this$beginObject_u24lambda_u247.push(3);
        $this$beginObject_u24lambda_u247.peeked = 0;
        int n4 = $this$beginObject_u24lambda_u247.indexStackSize;
        $this$beginObject_u24lambda_u247.indexStackSize = n4 + 1;
        $this$beginObject_u24lambda_u247.indexStack[$this$beginObject_u24lambda_u247.indexStackSize - 1] = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    public JsonReader endObject() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$endObject_u24lambda_u249 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$endObject_u24lambda_u249.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$endObject_u24lambda_u249.doPeek();
        if (p != 2) {
            throw new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)$this$endObject_u24lambda_u249.peek()) + " at path " + $this$endObject_u24lambda_u249.getPathAsString());
        }
        int n4 = $this$endObject_u24lambda_u249.stackSize;
        $this$endObject_u24lambda_u249.stackSize = n4 + -1;
        $this$endObject_u24lambda_u249.pathNames[$this$endObject_u24lambda_u249.stackSize] = null;
        int[] nArray = $this$endObject_u24lambda_u249.pathIndices;
        int n5 = $this$endObject_u24lambda_u249.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        $this$endObject_u24lambda_u249.peeked = 0;
        int n7 = $this$endObject_u24lambda_u249.indexStackSize;
        $this$endObject_u24lambda_u249.indexStackSize = n7 + -1;
        return bufferedSourceJsonReader;
    }

    @Override
    public boolean hasNext() {
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        return p != 2 && p != 4;
    }

    @Override
    public JsonReader.Token peek() {
        JsonReader.Token token;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 1: {
                token = JsonReader.Token.BEGIN_OBJECT;
                break;
            }
            case 2: {
                token = JsonReader.Token.END_OBJECT;
                break;
            }
            case 3: {
                token = JsonReader.Token.BEGIN_ARRAY;
                break;
            }
            case 4: {
                token = JsonReader.Token.END_ARRAY;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                token = JsonReader.Token.NAME;
                break;
            }
            case 5: 
            case 6: {
                token = JsonReader.Token.BOOLEAN;
                break;
            }
            case 7: {
                token = JsonReader.Token.NULL;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                token = JsonReader.Token.STRING;
                break;
            }
            case 15: {
                token = JsonReader.Token.LONG;
                break;
            }
            case 16: {
                token = JsonReader.Token.NUMBER;
                break;
            }
            case 17: {
                token = JsonReader.Token.END_DOCUMENT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int doPeek() {
        int n;
        int c;
        int peekStack = this.stack[this.stackSize - 1];
        switch (peekStack) {
            case 1: {
                this.stack[this.stackSize - 1] = 2;
                break;
            }
            case 2: {
                c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                n = c;
                if (n == 93) {
                    int n2;
                    int it = n2 = 4;
                    boolean bl = false;
                    this.peeked = it;
                    return n2;
                }
                if (n == 44) break;
                this.throwSyntaxError("Unterminated array");
                throw new KotlinNothingValueException();
            }
            case 3: 
            case 5: {
                int n3;
                char c2;
                int c3;
                this.stack[this.stackSize - 1] = 4;
                if (peekStack == 5) {
                    c3 = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    c2 = (char)c3;
                    if (c2 == '}') {
                        int n4;
                        int it = n4 = 2;
                        boolean bl = false;
                        this.peeked = it;
                        return n4;
                    }
                    if (c2 != ',') {
                        this.throwSyntaxError("Unterminated object");
                        throw new KotlinNothingValueException();
                    }
                }
                if ((c2 = (char)(c3 = this.nextNonWhitespace(true))) == '\"') {
                    int n5;
                    this.buffer.readByte();
                    int it = n5 = 13;
                    boolean bl = false;
                    this.peeked = it;
                    n3 = n5;
                    return n3;
                }
                if (c2 != '}') {
                    this.throwSyntaxError("Unexpected character: " + (char)c3);
                    throw new KotlinNothingValueException();
                }
                if (peekStack != 5) {
                    int n6;
                    this.buffer.readByte();
                    int it = n6 = 2;
                    boolean bl = false;
                    this.peeked = it;
                    n3 = n6;
                    return n3;
                }
                this.throwSyntaxError("Expected name");
                throw new KotlinNothingValueException();
            }
            case 4: {
                this.stack[this.stackSize - 1] = 5;
                c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                if ((char)c == ':') break;
                this.throwSyntaxError("Expected ':'");
                throw new KotlinNothingValueException();
            }
            case 6: {
                this.stack[this.stackSize - 1] = 7;
                break;
            }
            case 7: {
                int c4 = this.nextNonWhitespace(false);
                if (c4 == -1) {
                    int n7;
                    int it = n7 = 17;
                    boolean bl = false;
                    this.peeked = it;
                    return n7;
                }
                this.throwSyntaxError("Malformed JSON");
                throw new KotlinNothingValueException();
            }
            default: {
                if (peekStack != 8) break;
                boolean bl = false;
                String string = "JsonReader is closed";
                throw new IllegalStateException(string.toString());
            }
        }
        int c5 = this.nextNonWhitespace(true);
        c = (char)c5;
        if (c == 93) {
            if (peekStack == 1) {
                this.buffer.readByte();
                int it = n = 4;
                boolean bl = false;
                this.peeked = it;
                return n;
            }
            this.throwSyntaxError("Unexpected value");
            throw new KotlinNothingValueException();
        }
        if (c == 59 || c == 44 || c == 39) {
            this.throwSyntaxError("Unexpected value");
            throw new KotlinNothingValueException();
        }
        if (c == 34) {
            this.buffer.readByte();
            int it = n = 9;
            boolean bl = false;
            this.peeked = it;
            return n;
        }
        if (c == 91) {
            this.buffer.readByte();
            int it = n = 3;
            boolean bl = false;
            this.peeked = it;
            return n;
        }
        if (c == 123) {
            this.buffer.readByte();
            int it = n = 1;
            boolean bl = false;
            this.peeked = it;
            return n;
        }
        int result2 = this.peekKeyword();
        if (result2 != 0) {
            return result2;
        }
        result2 = this.peekNumber();
        if (result2 != 0) {
            return result2;
        }
        if (!this.isLiteral((char)this.buffer.getByte(0L))) {
            this.throwSyntaxError("Expected value");
            throw new KotlinNothingValueException();
        }
        this.throwSyntaxError("Malformed JSON");
        throw new KotlinNothingValueException();
    }

    private final int peekKeyword() {
        int n;
        String keyword = null;
        String keywordUpper = null;
        int peeking = 0;
        byte by = this.buffer.getByte(0L);
        if (by == 116 || by == 84) {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (by == 102 || by == 70) {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (by == 110 || by == 78) {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i = 1; i < length; ++i) {
            if (!this.source.request((long)i + 1L)) {
                return 0;
            }
            byte c = this.buffer.getByte(i);
            if (c == (byte)keyword.charAt(i) || c == (byte)keywordUpper.charAt(i)) continue;
            return 0;
        }
        if (this.source.request((long)length + 1L) && this.isLiteral((char)this.buffer.getByte(length))) {
            return 0;
        }
        this.buffer.skip(length);
        int it = n = peeking;
        boolean bl = false;
        this.peeked = it;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int peekNumber() {
        int n;
        int it;
        int n2;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        while (this.source.request((long)i + 1L)) {
            block22: {
                char c;
                byte c2;
                block24: {
                    block23: {
                        block21: {
                            c2 = this.buffer.getByte(i);
                            c = (char)c2;
                            if (c != '-') break block21;
                            switch (last) {
                                case 0: {
                                    negative = true;
                                    last = 1;
                                    break block22;
                                }
                                case 5: {
                                    last = 6;
                                    break block22;
                                }
                                default: {
                                    return 0;
                                }
                            }
                        }
                        if (c != '+') break block23;
                        if (last != 5) return 0;
                        last = 6;
                        break block22;
                    }
                    if (c != 'e' && c != 'E') break block24;
                    switch (last) {
                        case 2: 
                        case 4: {
                            last = 5;
                            break block22;
                        }
                        default: {
                            return 0;
                        }
                    }
                }
                if (c == '.') {
                    if (last != 2) return 0;
                    last = 3;
                } else {
                    if (c2 < 48 || c2 > 57) {
                        if (this.isLiteral((char)c2)) return 0;
                        break;
                    }
                    switch (last) {
                        case 0: 
                        case 1: {
                            value = -((long)(c2 - 48));
                            last = 2;
                            break;
                        }
                        case 2: {
                            if (value == 0L) {
                                return 0;
                            }
                            long newValue = value * (long)10 - (long)(c2 - 48);
                            fitsInLong = fitsInLong & value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                            value = newValue;
                            break;
                        }
                        case 3: {
                            last = 4;
                            break;
                        }
                        case 5: 
                        case 6: {
                            last = 7;
                        }
                    }
                }
            }
            ++i;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.buffer.skip(i);
            it = n2 = 15;
            boolean bl = false;
            this.peeked = it;
            n = n2;
            return n;
        } else {
            if (last != 2 && last != 4) {
                if (last != 7) return 0;
            }
            this.peekedNumberLength = i;
            it = n2 = 16;
            boolean bl = false;
            this.peeked = it;
            n = n2;
        }
        return n;
    }

    private final boolean isLiteral(char c) {
        char c2 = c;
        if (c2 == '/' || c2 == '\\' || c2 == ';' || c2 == '#' || c2 == '=') {
            this.throwSyntaxError("Unexpected character: " + c);
            throw new KotlinNothingValueException();
        }
        return c2 != '{' && c2 != '}' && c2 != '[' && c2 != ']' && c2 != ':' && c2 != ',' && c2 != ' ' && c2 != '\t' && c2 != '\r' && c2 != '\n';
    }

    @Override
    public String nextName() {
        String string;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 14: {
                string = this.nextUnquotedValue();
                break;
            }
            case 13: {
                string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 12: {
                string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            default: {
                throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        String result2 = string;
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result2;
        return result2;
    }

    @Override
    public String nextString() {
        Object object;
        Object object2 = this.peeked;
        int it = ((Number)object2).intValue();
        boolean bl = false;
        Object object3 = !(it == 0) ? object2 : null;
        switch (object3 != null ? ((Integer)object3).intValue() : this.doPeek()) {
            case 10: {
                object = this.nextUnquotedValue();
                break;
            }
            case 9: {
                object = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 8: {
                object = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            case 11: {
                String string = this.peekedString;
                if (string != null) {
                    Object it2 = object2 = string;
                    boolean bl2 = false;
                    this.peekedString = null;
                    object = object2;
                    break;
                }
                object = null;
                break;
            }
            case 15: {
                object = String.valueOf(this.peekedLong);
                break;
            }
            case 16: {
                object = this.buffer.readUtf8(this.peekedNumberLength);
                break;
            }
            default: {
                throw new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        String result2 = object;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return result2;
    }

    @Override
    public boolean nextBoolean() {
        boolean bl;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 5: {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                int n3 = this.stackSize - 1;
                int n4 = nArray[n3];
                nArray[n3] = n4 + 1;
                bl = true;
                break;
            }
            case 6: {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                int n5 = this.stackSize - 1;
                int n4 = nArray[n5];
                nArray[n5] = n4 + 1;
                bl = false;
                break;
            }
            default: {
                throw new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        return bl;
    }

    @Override
    public Void nextNull() {
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        if ((n2 != null ? n2.intValue() : this.doPeek()) != 7) {
            throw new JsonDataException("Expected null but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n3 = this.stackSize - 1;
        int n4 = nArray[n3];
        nArray[n3] = n4 + 1;
        return null;
    }

    @Override
    public double nextDouble() {
        double d;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        if (p == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            int n3 = this.stackSize - 1;
            int n4 = nArray[n3];
            nArray[n3] = n4 + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9) {
            this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (p == 8) {
            this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (p == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (p != 11) {
            throw new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull(string);
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double result2 = d;
        if (Double.isNaN(result2) || Double.isInfinite(result2)) {
            throw new JsonEncodingException("JSON forbids NaN and infinities: " + result2 + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n5 = this.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        return result2;
    }

    @Override
    public long nextLong() {
        double it22;
        Integer n = this.peeked;
        int it22 = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it22 == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        if (p == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            int n3 = this.stackSize - 1;
            it22 = nArray[n3];
            nArray[n3] = it22 + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                Intrinsics.checkNotNull(string);
                long result2 = Long.parseLong(string);
                this.peeked = 0;
                int[] it22 = this.pathIndices;
                int n4 = this.stackSize - 1;
                int n5 = it22[n4];
                it22[n4] = n5 + 1;
                return result2;
            }
            catch (NumberFormatException result2) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected a long but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull(string);
            it22 = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double asDouble = it22;
        long result3 = (long)asDouble;
        if (!((double)result3 == asDouble)) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n6 = this.stackSize - 1;
        int n7 = nArray[n6];
        nArray[n6] = n7 + 1;
        return result3;
    }

    @Override
    public JsonNumber nextNumber() {
        String string = this.nextString();
        Intrinsics.checkNotNull(string);
        return new JsonNumber(string);
    }

    private final String nextQuotedValue(ByteString runTerminator) {
        String string;
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                this.throwSyntaxError("Unterminated string");
                throw new KotlinNothingValueException();
            }
            if (this.buffer.getByte(index) != 92) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result2 = this.buffer.readUtf8(index);
            this.buffer.readByte();
            string = result2;
        } else {
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            String string2 = builder.toString();
            Intrinsics.checkNotNull(string2);
            string = string2;
        }
        return string;
    }

    private final String nextUnquotedValue() {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private final void skipQuotedValue(ByteString runTerminator) {
        long index;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                this.throwSyntaxError("Unterminated string");
                throw new KotlinNothingValueException();
            }
            if (this.buffer.getByte(index) != 92) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    private final void skipUnquotedValue() {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(i != -1L ? i : this.buffer.size());
    }

    @Override
    public int nextInt() {
        double it2;
        Object object;
        Object object2 = this.peeked;
        int it2 = ((Number)object2).intValue();
        boolean bl = false;
        Object object3 = !(it2 == 0) ? object2 : null;
        int p = object3 != null ? ((Integer)object3).intValue() : this.doPeek();
        if (p == 15) {
            int result2 = (int)this.peekedLong;
            if (this.peekedLong != (long)result2) {
                throw new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            object2 = this.pathIndices;
            it2 = this.stackSize - 1;
            object = object2[it2];
            object2[it2] = object + true;
            return result2;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                Intrinsics.checkNotNull(string);
                int result3 = Integer.parseInt(string);
                this.peeked = 0;
                object2 = this.pathIndices;
                it2 = this.stackSize - 1;
                object = object2[it2];
                object2[it2] = object + true;
                return result3;
            }
            catch (NumberFormatException result3) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull(string);
            it2 = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double asDouble = it2;
        int result4 = (int)asDouble;
        if (!((double)result4 == asDouble)) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return result4;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() {
        int n;
        int count = 0;
        do {
            Integer n2 = this.peeked;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = !(it == 0) ? n2 : null;
            switch (n3 != null ? n3.intValue() : this.doPeek()) {
                case 3: {
                    this.push(1);
                    ++count;
                    break;
                }
                case 1: {
                    this.push(3);
                    ++count;
                    break;
                }
                case 4: {
                    n = this.stackSize;
                    this.stackSize = n + -1;
                    --count;
                    break;
                }
                case 2: {
                    n = this.stackSize;
                    this.stackSize = n + -1;
                    --count;
                    break;
                }
                case 10: 
                case 14: {
                    this.skipUnquotedValue();
                    break;
                }
                case 9: 
                case 13: {
                    this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                    break;
                }
                case 8: 
                case 12: {
                    this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
                    break;
                }
                case 16: {
                    this.buffer.skip(this.peekedNumberLength);
                }
            }
            this.peeked = 0;
        } while (count != 0);
        int[] nArray = this.pathIndices;
        n = this.stackSize - 1;
        int n4 = nArray[n];
        nArray[n] = n4 + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    @Override
    public int selectName(List<String> names) {
        Intrinsics.checkNotNullParameter(names, "names");
        if (names.isEmpty()) {
            return -1;
        }
        while (this.hasNext()) {
            block7: {
                int n;
                String name = this.nextName();
                int expectedIndex = this.indexStack[this.indexStackSize - 1];
                if (Intrinsics.areEqual(names.get(expectedIndex), name)) {
                    int n2;
                    int it = n2 = expectedIndex;
                    boolean bl = false;
                    this.indexStack[this.indexStackSize - 1] = expectedIndex + 1;
                    if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                        this.indexStack[this.indexStackSize - 1] = 0;
                    }
                    return n2;
                }
                int index = 0;
                index = expectedIndex;
                do {
                    if ((index = (n = index) + 1) == names.size()) {
                        index = 0;
                    }
                    if (index == expectedIndex) break block7;
                } while (!Intrinsics.areEqual(names.get(index), name));
                int it = n = index;
                boolean bl = false;
                this.indexStack[this.indexStackSize - 1] = index + 1;
                if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                    this.indexStack[this.indexStackSize - 1] = 0;
                }
                return n;
            }
            this.skipValue();
        }
        return -1;
    }

    private final void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = Arrays.copyOf(this.stack, this.stack.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            this.stack = nArray;
            String[] stringArray = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
            Intrinsics.checkNotNullExpressionValue(stringArray, "copyOf(...)");
            this.pathNames = stringArray;
            int[] nArray2 = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray2, "copyOf(...)");
            this.pathIndices = nArray2;
            int[] nArray3 = Arrays.copyOf(this.indexStack, this.indexStack.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray3, "copyOf(...)");
            this.indexStack = nArray3;
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
        this.stack[n] = newTop;
    }

    private final int nextNonWhitespace(boolean throwOnEof) {
        int p = 0;
        block7: while (this.source.request((long)p + 1L)) {
            byte c = this.buffer.getByte(p++);
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block7;
                }
            }
            this.buffer.skip((long)p - 1L);
            switch (c) {
                case 47: {
                    if (!this.source.request(2L)) {
                        return c;
                    }
                    this.throwSyntaxError("Malformed JSON");
                    throw new KotlinNothingValueException();
                }
                case 35: {
                    this.throwSyntaxError("Malformed JSON");
                    throw new KotlinNothingValueException();
                }
            }
            return c;
        }
        if (throwOnEof) {
            throw new EOFException("End of input");
        }
        return -1;
    }

    @Override
    public List<Object> getPath() {
        return JsonScope.INSTANCE.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    private final String getPathAsString() {
        return CollectionsKt.joinToString$default(this.getPath(), ".", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final char readEscapeCharacter() {
        int n;
        if (!this.source.request(1L)) {
            this.throwSyntaxError("Unterminated escape sequence");
            throw new KotlinNothingValueException();
        }
        char escaped = (char)this.buffer.readByte();
        if (escaped == 'u') {
            void var2_2;
            int i;
            if (!this.source.request(4L)) {
                throw new EOFException("Unterminated escape sequence at path " + this.getPath());
            }
            int result2 = 0;
            int end = i + 4;
            for (i = 0; i < end; ++i) {
                int n2;
                byte c = this.buffer.getByte(i);
                result2 = (char)(result2 << 4);
                if (c >= 48 && c <= 57) {
                    n2 = c - 48;
                } else if (c >= 97 && c <= 102) {
                    n2 = c - 97 + 10;
                } else if (c >= 65 && c <= 70) {
                    n2 = c - 65 + 10;
                } else {
                    this.throwSyntaxError("\\u" + this.buffer.readUtf8(4L));
                    throw new KotlinNothingValueException();
                }
                result2 = (char)(result2 + n2);
            }
            this.buffer.skip(4L);
            n = var2_2;
        } else if (escaped == 't') {
            n = 9;
        } else if (escaped == 'b') {
            n = 8;
        } else if (escaped == 'n') {
            n = 10;
        } else if (escaped == 'r') {
            n = 13;
        } else if (escaped == 'f') {
            n = 12;
        } else if (escaped == '\n' || escaped == '\'' || escaped == '\"' || escaped == '\\' || escaped == '/') {
            n = escaped;
        } else {
            this.throwSyntaxError("Invalid escape sequence: \\" + escaped);
            throw new KotlinNothingValueException();
        }
        return (char)n;
    }

    @Override
    public void rewind() {
        throw new IllegalStateException("BufferedSourceJsonReader cannot rewind.".toString());
    }

    private final Void throwSyntaxError(String message) {
        throw new JsonEncodingException(message + " at path " + this.getPath());
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

