/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;

public final class DefaultInterceptorChain
implements ApolloInterceptorChain {
    private final List<ApolloInterceptor> interceptors;
    private final int index;

    public DefaultInterceptorChain(List<? extends ApolloInterceptor> interceptors, int index) {
        Intrinsics.checkNotNullParameter(interceptors, "interceptors");
        this.interceptors = interceptors;
        this.index = index;
    }

    @Override
    public <D extends Operation.Data> Flow<ApolloResponse<D>> proceed(ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        if (!(this.index < this.interceptors.size())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.interceptors.get(this.index).intercept(request, new DefaultInterceptorChain(this.interceptors, this.index + 1));
    }
}

