/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.network.NetworkTransport;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;

public final class NetworkInterceptor
implements ApolloInterceptor {
    private final NetworkTransport networkTransport;
    private final NetworkTransport subscriptionNetworkTransport;

    public NetworkInterceptor(NetworkTransport networkTransport, NetworkTransport subscriptionNetworkTransport) {
        Intrinsics.checkNotNullParameter(networkTransport, "networkTransport");
        Intrinsics.checkNotNullParameter(subscriptionNetworkTransport, "subscriptionNetworkTransport");
        this.networkTransport = networkTransport;
        this.subscriptionNetworkTransport = subscriptionNetworkTransport;
    }

    @Override
    public <D extends Operation.Data> Flow<ApolloResponse<D>> intercept(ApolloRequest<D> request, ApolloInterceptorChain chain) {
        Flow<ApolloResponse<D>> flow2;
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(chain, "chain");
        Operation<D> operation = request.getOperation();
        if (operation instanceof Query) {
            flow2 = this.networkTransport.execute(request);
        } else if (operation instanceof Mutation) {
            flow2 = this.networkTransport.execute(request);
        } else if (operation instanceof Subscription) {
            flow2 = this.subscriptionNetworkTransport.execute(request);
        } else {
            throw new IllegalStateException("".toString());
        }
        return flow2;
    }
}

