/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.http;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Operations;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.apollo.api.http.HttpResponse;
import com.apollographql.apollo.api.internal.ResponseParserKt;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.RouterError;
import com.apollographql.apollo.internal.DeferredJsonMerger;
import com.apollographql.apollo.internal.MultipartKt;
import com.apollographql.apollo.mpp.UtilsKt;
import com.apollographql.apollo.network.NetworkTransport;
import com.apollographql.apollo.network.http.DefaultHttpEngine;
import com.apollographql.apollo.network.http.DefaultHttpInterceptorChain;
import com.apollographql.apollo.network.http.HttpEngine;
import com.apollographql.apollo.network.http.HttpInfo;
import com.apollographql.apollo.network.http.HttpInterceptor;
import com.apollographql.apollo.network.http.HttpInterceptorChain;
import com.apollographql.apollo.network.http.HttpNetworkTransport$execute$1$invokeSuspend$;
import com.apollographql.apollo.network.http.HttpNetworkTransport$multipleResponses$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import okio.BufferedSource;

public final class HttpNetworkTransport
implements NetworkTransport {
    private static final Companion Companion = new Companion(null);
    private final HttpRequestComposer httpRequestComposer;
    private final HttpEngine engine;
    private final List<HttpInterceptor> interceptors;
    private final boolean exposeErrorBody;
    private final EngineInterceptor engineInterceptor;

    private HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine engine, List<? extends HttpInterceptor> interceptors, boolean exposeErrorBody) {
        this.httpRequestComposer = httpRequestComposer;
        this.engine = engine;
        this.interceptors = interceptors;
        this.exposeErrorBody = exposeErrorBody;
        this.engineInterceptor = new EngineInterceptor();
    }

    public final List<HttpInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public <D extends Operation.Data> Flow<ApolloResponse<D>> execute(ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Object e = request.getExecutionContext().get(CustomScalarAdapters.Key);
        Intrinsics.checkNotNull(e);
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)e;
        HttpRequest httpRequest = this.httpRequestComposer.compose(request);
        return this.execute(request, httpRequest, customScalarAdapters);
    }

    public final <D extends Operation.Data> Flow<ApolloResponse<D>> execute(ApolloRequest<D> request, HttpRequest httpRequest, CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(httpRequest, "httpRequest");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        return FlowKt.flow(new Function2<FlowCollector<? super ApolloResponse<D>>, Continuation<? super Unit>, Object>(this, httpRequest, request, customScalarAdapters, null){
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HttpNetworkTransport this$0;
            final /* synthetic */ HttpRequest $httpRequest;
            final /* synthetic */ ApolloRequest<D> $request;
            final /* synthetic */ CustomScalarAdapters $customScalarAdapters;
            {
                this.this$0 = $receiver;
                this.$httpRequest = $httpRequest;
                this.$request = $request;
                this.$customScalarAdapters = $customScalarAdapters;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        millisStart = UtilsKt.currentTimeMillis();
                        apolloException = null;
                        this.L$0 = $this$flow;
                        this.J$0 = millisStart;
                        this.label = 1;
                        v0 = new DefaultHttpInterceptorChain(CollectionsKt.plus((Collection)this.this$0.getInterceptors(), HttpNetworkTransport.access$getEngineInterceptor$p(this.this$0)), 0).proceed(this.$httpRequest, this);
                        ** if (v0 != var14_2) goto lbl16
lbl15:
                        // 1 sources

                        return var14_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        millisStart = this.J$0;
                        apolloException = null;
                        $this$flow = (FlowCollector)this.L$0;
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var7_6 = (HttpResponse)v0;
                        }
                        catch (ApolloException e) {
                            apolloException = e;
                            var7_6 = null;
                        }
                        httpResponse = var7_6;
                        if (httpResponse == null) {
                            v1 = this.$request.getOperation();
                            v2 = apolloException;
                            Intrinsics.checkNotNull(v2);
                            v3 = FlowKt.flowOf(HttpNetworkTransport.access$errorResponse(this.this$0, v1, v2));
                        } else {
                            var7_7 = httpResponse.getStatusCode();
                            v3 = (200 <= var7_7 ? var7_7 < 300 : false) == false ? HttpNetworkTransport.access$errorResponse(this.this$0, this.$request.getOperation(), httpResponse) : (MultipartKt.isMultipart(httpResponse) != false ? HttpNetworkTransport.access$multipleResponses(this.this$0, this.$request.getOperation(), this.$customScalarAdapters, httpResponse) : HttpNetworkTransport.access$singleResponse(this.this$0, this.$request.getOperation(), this.$customScalarAdapters, httpResponse));
                        }
                        $this$map$iv = v3;
                        var8_9 = this.this$0;
                        var9_11 = this.$request;
                        $i$f$map = false;
                        $this$unsafeTransform$iv$iv = $this$map$iv;
                        $i$f$unsafeTransform = false;
                        $i$f$unsafeFlow = false;
                        this.L$0 = null;
                        this.label = 2;
                        v4 = FlowKt.emitAll(var2_3, (Flow)new Flow<ApolloResponse<D>>($this$unsafeTransform$iv$iv, var8_9, var9_11, httpResponse, millisStart){
                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                            final /* synthetic */ HttpNetworkTransport this$0;
                            final /* synthetic */ ApolloRequest $request$inlined;
                            final /* synthetic */ HttpResponse $httpResponse$inlined;
                            final /* synthetic */ long $millisStart$inlined;
                            {
                                this.$this_unsafeTransform$inlined = flow2;
                                this.this$0 = httpNetworkTransport;
                                this.$request$inlined = apolloRequest;
                                this.$httpResponse$inlined = httpResponse;
                                this.$millisStart$inlined = l;
                            }

                            public Object collect(FlowCollector collector, Continuation $completion) {
                                Continuation continuation = $completion;
                                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                boolean bl = false;
                                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0, this.$request$inlined, this.$httpResponse$inlined, this.$millisStart$inlined){
                                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                                    final /* synthetic */ HttpNetworkTransport this$0;
                                    final /* synthetic */ ApolloRequest $request$inlined;
                                    final /* synthetic */ HttpResponse $httpResponse$inlined;
                                    final /* synthetic */ long $millisStart$inlined;
                                    {
                                        this.$this_unsafeFlow = $receiver;
                                        this.this$0 = httpNetworkTransport;
                                        this.$request$inlined = apolloRequest;
                                        this.$httpResponse$inlined = httpResponse;
                                        this.$millisStart$inlined = l;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object emit(Object var1_1, Continuation $completion) {
                                        if (!($completion instanceof execute$1$invokeSuspend$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                        var3_3 = $completion;
                                        if ((var3_3.label & -2147483648) != 0) {
                                            var3_3.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, $completion){
                                                /* synthetic */ Object result;
                                                int label;
                                                final /* synthetic */ execute$1$invokeSuspend$$inlined$map$1$2 this$0;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.emit((Object)null, (Continuation)this);
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure($result);
                                                var6_6 = value;
                                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                var9_10 = $this$map_u24lambda_u245;
                                                (Continuation)$continuation;
                                                it = (ApolloResponse)value;
                                                $i$a$-map-HttpNetworkTransport$execute$1$1 = false;
                                                $continuation.label = 1;
                                                v0 = var9_10.emit(HttpNetworkTransport.access$withHttpInfo(this.this$0, it, this.$request$inlined.getRequestUuid(), this.$httpResponse$inlined, this.$millisStart$inlined), $continuation);
                                                if (v0 == var5_5) {
                                                    return var5_5;
                                                }
                                                ** GOTO lbl29
                                            }
                                            case 1: {
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                ResultKt.throwOnFailure($result);
                                                v0 = $result;
lbl29:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation<? super Unit>)this);
                        if (v4 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl57
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl57:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<FlowCollector<? super ApolloResponse<D>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(FlowCollector<? super ApolloResponse<D>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final <D extends Operation.Data> ApolloResponse<D> errorResponse(Operation<D> operation, Throwable throwable) {
        ApolloException apolloException = throwable instanceof ApolloException ? (ApolloException)throwable : (ApolloException)new ApolloNetworkException("Error while reading JSON response", (Object)throwable);
        boolean $i$f$uuid4 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        UUID uUID2 = uUID;
        return new ApolloResponse.Builder<D>(operation, uUID2).exception(apolloException).isLast(true).build();
    }

    private final <D extends Operation.Data> Flow<ApolloResponse<D>> errorResponse(Operation<D> operation, HttpResponse httpResponse) {
        BufferedSource bufferedSource;
        if (this.exposeErrorBody) {
            bufferedSource = httpResponse.getBody();
        } else {
            BufferedSource bufferedSource2 = httpResponse.getBody();
            if (bufferedSource2 != null) {
                bufferedSource2.close();
            }
            bufferedSource = null;
        }
        BufferedSource maybeBody = bufferedSource;
        ApolloHttpException apolloException = new ApolloHttpException(httpResponse.getStatusCode(), httpResponse.getHeaders(), maybeBody, "Http request failed with status code `" + httpResponse.getStatusCode() + '`', null, 16, null);
        return FlowKt.flowOf(this.errorResponse(operation, apolloException));
    }

    private final <D extends Operation.Data> Flow<ApolloResponse<D>> singleResponse(Operation<D> operation, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        BufferedSource bufferedSource = httpResponse.getBody();
        Intrinsics.checkNotNull(bufferedSource);
        ApolloResponse response = Operations.toApolloResponse$default(-JsonReaders.jsonReader(bufferedSource), operation, null, customScalarAdapters, null, 2, null);
        return FlowKt.flowOf(response.newBuilder().isLast(true).build());
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends Operation.Data> Flow<ApolloResponse<D>> multipleResponses(Operation<D> operation, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        void $this$mapNotNull$iv;
        Ref.ObjectRef jsonMerger = new Ref.ObjectRef();
        Flow<BufferedSource> flow2 = MultipartKt.multipartBodyFlow(httpResponse);
        boolean $i$f$mapNotNull = false;
        void $this$unsafeTransform$iv$iv = $this$mapNotNull$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return FlowKt.catch(new Flow<ApolloResponse<D>>((Flow)$this$unsafeTransform$iv$iv, operation, customScalarAdapters, this, jsonMerger){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ Operation $operation$inlined;
            final /* synthetic */ CustomScalarAdapters $customScalarAdapters$inlined;
            final /* synthetic */ HttpNetworkTransport this$0;
            final /* synthetic */ Ref.ObjectRef $jsonMerger$inlined;
            {
                this.$this_unsafeTransform$inlined = flow2;
                this.$operation$inlined = operation;
                this.$customScalarAdapters$inlined = customScalarAdapters;
                this.this$0 = httpNetworkTransport;
                this.$jsonMerger$inlined = objectRef;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$operation$inlined, this.$customScalarAdapters$inlined, this.this$0, this.$jsonMerger$inlined){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ Operation $operation$inlined;
                    final /* synthetic */ CustomScalarAdapters $customScalarAdapters$inlined;
                    final /* synthetic */ HttpNetworkTransport this$0;
                    final /* synthetic */ Ref.ObjectRef $jsonMerger$inlined;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.$operation$inlined = operation;
                        this.$customScalarAdapters$inlined = customScalarAdapters;
                        this.this$0 = httpNetworkTransport;
                        this.$jsonMerger$inlined = objectRef;
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final Object emit(Object var1_1, Continuation $completion) {
                        if (!($completion instanceof multipleResponses$$inlined$mapNotNull$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                final /* synthetic */ multipleResponses$$inlined$mapNotNull$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit((Object)null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                var6_6 = value;
                                $this$mapNotNull_u24lambda_u246 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                (Continuation)$continuation;
                                part = (BufferedSource)value;
                                $i$a$-mapNotNull-HttpNetworkTransport$multipleResponses$1 = false;
                                if (this.$operation$inlined instanceof Subscription) {
                                    reader = -JsonReaders.jsonReader(part);
                                    payloadResponse = null;
                                    errors = null;
                                    reader.beginObject();
                                    while (reader.hasNext()) {
                                        var14_18 = reader.nextName();
                                        if (Intrinsics.areEqual(var14_18, "payload")) {
                                            if (reader.peek() == JsonReader.Token.NULL) {
                                                reader.skipValue();
                                                continue;
                                            }
                                            payloadResponse = Operations.parseResponse$default(reader, this.$operation$inlined, null, this.$customScalarAdapters$inlined, null, 2, null);
                                            continue;
                                        }
                                        if (Intrinsics.areEqual(var14_18, "errors")) {
                                            if (reader.peek() == JsonReader.Token.NULL) {
                                                reader.skipValue();
                                                continue;
                                            }
                                            errors = ResponseParserKt.readErrors(reader);
                                            continue;
                                        }
                                        reader.skipValue();
                                    }
                                    reader.endObject();
                                    if (errors != null) {
                                        v0 /* !! */  = HttpNetworkTransport.access$errorResponse(this.this$0, this.$operation$inlined, new RouterError(errors));
                                    } else {
                                        v0 /* !! */  = payloadResponse;
                                        if (v0 /* !! */  == null) {
                                            v0 /* !! */  = null;
                                        }
                                    }
                                } else {
                                    if (this.$jsonMerger$inlined.element == null) {
                                        this.$jsonMerger$inlined.element = new DeferredJsonMerger();
                                    }
                                    v1 = this.$jsonMerger$inlined.element;
                                    Intrinsics.checkNotNull(v1);
                                    merged = ((DeferredJsonMerger)v1).merge(part);
                                    v2 = this.$jsonMerger$inlined.element;
                                    Intrinsics.checkNotNull(v2);
                                    deferredFragmentIds = ((DeferredJsonMerger)v2).getMergedFragmentIds();
                                    v3 = this.$jsonMerger$inlined.element;
                                    Intrinsics.checkNotNull(v3);
                                    isLast = ((DeferredJsonMerger)v3).getHasNext() == false;
                                    v4 = this.$jsonMerger$inlined.element;
                                    Intrinsics.checkNotNull(v4);
                                    v0 /* !! */  = ((DeferredJsonMerger)v4).isEmptyPayload() ? null : Operations.toApolloResponse$default(-JsonReaders.jsonReader(merged), this.$operation$inlined, null, this.$customScalarAdapters$inlined, deferredFragmentIds, 2, null).newBuilder().isLast(isLast != false).build();
                                }
                                if ((var15_19 = v0 /* !! */ ) != null) {
                                    transformed = var15_19;
                                    $continuation.label = 1;
                                    v5 = $this$mapNotNull_u24lambda_u246.emit(transformed, $continuation);
                                    if (v5 == var5_5) {
                                        return var5_5;
                                    }
                                }
                                ** GOTO lbl76
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                ResultKt.throwOnFailure($result);
                                v5 = $result;
lbl76:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }, new Function3<FlowCollector<? super ApolloResponse<D>>, Throwable, Continuation<? super Unit>, Object>(operation, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ Operation<D> $operation;
            {
                this.$operation = $operation;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure(object);
                        FlowCollector $this$catch = (FlowCollector)this.L$0;
                        Throwable throwable = (Throwable)this.L$1;
                        if (!(throwable instanceof ApolloException)) return Unit.INSTANCE;
                        boolean $i$f$uuid4 = false;
                        UUID uUID = UUID.randomUUID();
                        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
                        this.L$0 = null;
                        this.label = 1;
                        Object object3 = var2_3.emit(new ApolloResponse.Builder<D>(this.$operation, uUID).exception((ApolloException)throwable).build(), this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(FlowCollector<? super ApolloResponse<D>> p1, Throwable p2, Continuation<? super Unit> p3) {
                Function3<FlowCollector<? super ApolloResponse<D>>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final <D extends Operation.Data> ApolloResponse<D> withHttpInfo(ApolloResponse<D> $this$withHttpInfo, UUID requestUuid, HttpResponse httpResponse, long millisStart) {
        ApolloResponse.Builder<D> builder;
        ApolloResponse.Builder<D> $this$withHttpInfo_u24lambda_u241 = builder = $this$withHttpInfo.newBuilder().requestUuid(requestUuid);
        boolean bl = false;
        if (httpResponse != null) {
            $this$withHttpInfo_u24lambda_u241.addExecutionContext(new HttpInfo(millisStart, UtilsKt.currentTimeMillis(), httpResponse.getStatusCode(), httpResponse.getHeaders()));
        }
        return builder.build();
    }

    @Override
    public void dispose() {
        Iterable $this$forEach$iv = this.interceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpInterceptor it = (HttpInterceptor)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.engine.close();
    }

    public static final /* synthetic */ EngineInterceptor access$getEngineInterceptor$p(HttpNetworkTransport $this) {
        return $this.engineInterceptor;
    }

    public static final /* synthetic */ ApolloResponse access$errorResponse(HttpNetworkTransport $this, Operation operation, Throwable throwable) {
        return $this.errorResponse(operation, throwable);
    }

    public static final /* synthetic */ Flow access$errorResponse(HttpNetworkTransport $this, Operation operation, HttpResponse httpResponse) {
        return $this.errorResponse(operation, httpResponse);
    }

    public static final /* synthetic */ Flow access$multipleResponses(HttpNetworkTransport $this, Operation operation, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        return $this.multipleResponses(operation, customScalarAdapters, httpResponse);
    }

    public static final /* synthetic */ Flow access$singleResponse(HttpNetworkTransport $this, Operation operation, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        return $this.singleResponse(operation, customScalarAdapters, httpResponse);
    }

    public static final /* synthetic */ ApolloResponse access$withHttpInfo(HttpNetworkTransport $this, ApolloResponse $receiver, UUID requestUuid, HttpResponse httpResponse, long millisStart) {
        return $this.withHttpInfo($receiver, requestUuid, httpResponse, millisStart);
    }

    public /* synthetic */ HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine engine, List interceptors, boolean exposeErrorBody, DefaultConstructorMarker $constructor_marker) {
        this(httpRequestComposer, engine, interceptors, exposeErrorBody);
    }

    public static final class Builder {
        private HttpRequestComposer httpRequestComposer;
        private String serverUrl;
        private HttpEngine engine;
        private final List<HttpInterceptor> interceptors = new ArrayList();
        private boolean exposeErrorBody;
        private final List<HttpHeader> headers = new ArrayList();

        public final Builder serverUrl(String serverUrl2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(serverUrl2, "serverUrl");
            Builder $this$serverUrl_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$serverUrl_u24lambda_u241.serverUrl = serverUrl2;
            return builder;
        }

        public final Builder exposeErrorBody(boolean exposeErrorBody) {
            Builder builder;
            Builder $this$exposeErrorBody_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$exposeErrorBody_u24lambda_u242.exposeErrorBody = exposeErrorBody;
            return builder;
        }

        public final Builder httpEngine(HttpEngine httpEngine) {
            Builder builder;
            Intrinsics.checkNotNullParameter(httpEngine, "httpEngine");
            Builder $this$httpEngine_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$httpEngine_u24lambda_u246.engine = httpEngine;
            return builder;
        }

        public final Builder interceptors(List<? extends HttpInterceptor> interceptors) {
            Builder builder;
            Intrinsics.checkNotNullParameter(interceptors, "interceptors");
            Builder $this$interceptors_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$interceptors_u24lambda_u247.interceptors.clear();
            $this$interceptors_u24lambda_u247.interceptors.addAll((Collection<HttpInterceptor>)interceptors);
            return builder;
        }

        public final HttpNetworkTransport build() {
            HttpEngine httpEngine;
            if (!(this.httpRequestComposer == null || this.serverUrl == null)) {
                boolean bl = false;
                String string = "It is an error to set both 'httpRequestComposer' and 'serverUrl'";
                throw new IllegalStateException(string.toString());
            }
            HttpRequestComposer httpRequestComposer = this.httpRequestComposer;
            if (httpRequestComposer == null) {
                DefaultHttpRequestComposer defaultHttpRequestComposer;
                String string = this.serverUrl;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    defaultHttpRequestComposer = new DefaultHttpRequestComposer(it);
                } else {
                    defaultHttpRequestComposer = null;
                }
                if (defaultHttpRequestComposer != null) {
                    httpRequestComposer = defaultHttpRequestComposer;
                } else {
                    throw new IllegalStateException("No HttpRequestComposer found. Use 'httpRequestComposer' or 'serverUrl'".toString());
                }
            }
            HttpRequestComposer composer = httpRequestComposer;
            if (!((Collection)this.headers).isEmpty()) {
                this.interceptors.add(new TransportHeadersInterceptor(this.headers));
            }
            if ((httpEngine = this.engine) == null) {
                httpEngine = DefaultHttpEngine.DefaultHttpEngine$default(0L, 1, null);
            }
            return new HttpNetworkTransport(composer, httpEngine, this.interceptors, this.exposeErrorBody, null);
        }
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class EngineInterceptor
    implements HttpInterceptor {
        @Override
        public Object intercept(HttpRequest request, HttpInterceptorChain chain, Continuation<? super HttpResponse> $completion) {
            return HttpNetworkTransport.this.engine.execute(request, $completion);
        }
    }

    private static final class TransportHeadersInterceptor
    implements HttpInterceptor {
        private final List<HttpHeader> headers;

        public TransportHeadersInterceptor(List<HttpHeader> headers) {
            Intrinsics.checkNotNullParameter(headers, "headers");
            this.headers = headers;
        }

        @Override
        public Object intercept(HttpRequest request, HttpInterceptorChain chain, Continuation<? super HttpResponse> $completion) {
            return chain.proceed(HttpRequest.newBuilder$default(request, null, null, 3, null).addHeaders(this.headers).build(), $completion);
        }
    }
}

