/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.ArraysKt___ArraysJvmKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IndexingIterable;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;

class ArraysKt___ArraysKt
extends ArraysKt___ArraysJvmKt {
    public static final <T> boolean contains(T[] $this$contains, T element) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        return ArraysKt.indexOf($this$contains, element) >= 0;
    }

    public static final boolean contains(byte[] $this$contains, byte element) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        return ArraysKt.indexOf($this$contains, element) >= 0;
    }

    public static final boolean contains(short[] $this$contains, short element) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        return ArraysKt.indexOf($this$contains, element) >= 0;
    }

    public static final boolean contains(int[] $this$contains, int element) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        return ArraysKt.indexOf($this$contains, element) >= 0;
    }

    public static final boolean contains(long[] $this$contains, long element) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        return ArraysKt.indexOf($this$contains, element) >= 0;
    }

    public static final boolean contains(char[] $this$contains, char element) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        return ArraysKt.indexOf($this$contains, element) >= 0;
    }

    public static final <T> T getOrNull(T[] $this$getOrNull, int index) {
        Intrinsics.checkNotNullParameter($this$getOrNull, "<this>");
        return (0 <= index ? index < $this$getOrNull.length : false) ? (T)$this$getOrNull[index] : null;
    }

    public static final <T> int indexOf(T[] $this$indexOf, T element) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        if (element == null) {
            int n = $this$indexOf.length;
            for (int index = 0; index < n; ++index) {
                if ($this$indexOf[index] != null) continue;
                return index;
            }
        } else {
            int n = $this$indexOf.length;
            for (int index = 0; index < n; ++index) {
                if (!Intrinsics.areEqual(element, $this$indexOf[index])) continue;
                return index;
            }
        }
        return -1;
    }

    public static final int indexOf(byte[] $this$indexOf, byte element) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        int n = $this$indexOf.length;
        for (int index = 0; index < n; ++index) {
            if (element != $this$indexOf[index]) continue;
            return index;
        }
        return -1;
    }

    public static final int indexOf(short[] $this$indexOf, short element) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        int n = $this$indexOf.length;
        for (int index = 0; index < n; ++index) {
            if (element != $this$indexOf[index]) continue;
            return index;
        }
        return -1;
    }

    public static final int indexOf(int[] $this$indexOf, int element) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        int n = $this$indexOf.length;
        for (int index = 0; index < n; ++index) {
            if (element != $this$indexOf[index]) continue;
            return index;
        }
        return -1;
    }

    public static final int indexOf(long[] $this$indexOf, long element) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        int n = $this$indexOf.length;
        for (int index = 0; index < n; ++index) {
            if (element != $this$indexOf[index]) continue;
            return index;
        }
        return -1;
    }

    public static final int indexOf(char[] $this$indexOf, char element) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        int n = $this$indexOf.length;
        for (int index = 0; index < n; ++index) {
            if (element != $this$indexOf[index]) continue;
            return index;
        }
        return -1;
    }

    public static final char single(char[] $this$single) {
        Intrinsics.checkNotNullParameter($this$single, "<this>");
        switch ($this$single.length) {
            case 0: {
                throw new NoSuchElementException("Array is empty.");
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Array has more than one element.");
            }
        }
        return $this$single[0];
    }

    public static final <T> T singleOrNull(T[] $this$singleOrNull) {
        Intrinsics.checkNotNullParameter($this$singleOrNull, "<this>");
        return $this$singleOrNull.length == 1 ? (T)$this$singleOrNull[0] : null;
    }

    public static final <T> List<T> filterNotNull(T[] $this$filterNotNull) {
        Intrinsics.checkNotNullParameter($this$filterNotNull, "<this>");
        return (List)ArraysKt.filterNotNullTo($this$filterNotNull, (Collection)new ArrayList());
    }

    public static final <C extends Collection<? super T>, T> C filterNotNullTo(T[] $this$filterNotNullTo, C destination) {
        Intrinsics.checkNotNullParameter($this$filterNotNullTo, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        for (T element : $this$filterNotNullTo) {
            if (element == null) continue;
            destination.add(element);
        }
        return destination;
    }

    public static final <T> int getLastIndex(T[] $this$lastIndex) {
        Intrinsics.checkNotNullParameter($this$lastIndex, "<this>");
        return $this$lastIndex.length - 1;
    }

    public static final int getLastIndex(long[] $this$lastIndex) {
        Intrinsics.checkNotNullParameter($this$lastIndex, "<this>");
        return $this$lastIndex.length - 1;
    }

    public static final <T, C extends Collection<? super T>> C toCollection(T[] $this$toCollection, C destination) {
        Intrinsics.checkNotNullParameter($this$toCollection, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        for (T item : $this$toCollection) {
            destination.add(item);
        }
        return destination;
    }

    public static final <T> List<T> toList(T[] $this$toList) {
        List list;
        Intrinsics.checkNotNullParameter($this$toList, "<this>");
        switch ($this$toList.length) {
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = CollectionsKt.listOf($this$toList[0]);
                break;
            }
            default: {
                list = ArraysKt.toMutableList($this$toList);
            }
        }
        return list;
    }

    public static final <T> List<T> toMutableList(T[] $this$toMutableList) {
        Intrinsics.checkNotNullParameter($this$toMutableList, "<this>");
        return new ArrayList<T>(CollectionsKt.asCollection($this$toMutableList));
    }

    public static final <T> Set<T> toSet(T[] $this$toSet) {
        Set set;
        Intrinsics.checkNotNullParameter($this$toSet, "<this>");
        switch ($this$toSet.length) {
            case 0: {
                set = SetsKt.emptySet();
                break;
            }
            case 1: {
                set = SetsKt.setOf($this$toSet[0]);
                break;
            }
            default: {
                set = (Set)ArraysKt.toCollection($this$toSet, (Collection)new LinkedHashSet(MapsKt.mapCapacity($this$toSet.length)));
            }
        }
        return set;
    }

    public static final <T> Iterable<IndexedValue<T>> withIndex(T[] $this$withIndex) {
        Intrinsics.checkNotNullParameter($this$withIndex, "<this>");
        return new IndexingIterable(new Function0<Iterator<? extends T>>($this$withIndex){
            final /* synthetic */ T[] $this_withIndex;
            {
                this.$this_withIndex = $receiver;
                super(0);
            }

            public final Iterator<T> invoke() {
                return ArrayIteratorKt.iterator(this.$this_withIndex);
            }
        });
    }
}

