/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import kotlin.KotlinNothingValueException;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.HexFormat;

public final class HexExtensionsKt {
    private static final int[] BYTE_TO_LOWER_CASE_HEX_DIGITS;
    private static final int[] BYTE_TO_UPPER_CASE_HEX_DIGITS;
    private static final int[] HEX_DIGITS_TO_DECIMAL;
    private static final long[] HEX_DIGITS_TO_LONG_DECIMAL;

    public static final int[] getBYTE_TO_LOWER_CASE_HEX_DIGITS() {
        return BYTE_TO_LOWER_CASE_HEX_DIGITS;
    }

    public static final long hexToLong(String $this$hexToLong, int startIndex, int endIndex, HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToLong, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToLongImpl($this$hexToLong, startIndex, endIndex, format, 16);
    }

    public static /* synthetic */ long hexToLong$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, n, n2, hexFormat);
    }

    private static final long hexToLongImpl(String $this$hexToLongImpl, int startIndex, int endIndex, HexFormat format, int typeHexLength) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToLongImpl.length());
        HexFormat.NumberHexFormat numberFormat = format.getNumber();
        if (numberFormat.isDigitsOnly$kotlin_stdlib()) {
            HexExtensionsKt.checkNumberOfDigits($this$hexToLongImpl, startIndex, endIndex, typeHexLength);
            return HexExtensionsKt.parseLong($this$hexToLongImpl, startIndex, endIndex);
        }
        String prefix = numberFormat.getPrefix();
        String suffix = numberFormat.getSuffix();
        HexExtensionsKt.checkPrefixSuffixNumberOfDigits($this$hexToLongImpl, startIndex, endIndex, prefix, suffix, numberFormat.getIgnoreCase$kotlin_stdlib(), typeHexLength);
        return HexExtensionsKt.parseLong($this$hexToLongImpl, startIndex + prefix.length(), endIndex - suffix.length());
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkPrefixSuffixNumberOfDigits(String $this$checkPrefixSuffixNumberOfDigits, int startIndex, int endIndex, String prefix, String suffix, boolean ignoreCase, int typeHexLength) {
        int n;
        if (endIndex - startIndex - prefix.length() <= suffix.length()) {
            HexExtensionsKt.throwInvalidPrefixSuffix($this$checkPrefixSuffixNumberOfDigits, startIndex, endIndex, prefix, suffix);
        }
        String string = $this$checkPrefixSuffixNumberOfDigits;
        String partName$iv = "prefix";
        boolean $i$f$checkContainsAt = false;
        if (((CharSequence)prefix).length() == 0) {
            n = startIndex;
        } else {
            int n2 = ((CharSequence)prefix).length();
            for (int i$iv = 0; i$iv < n2; ++i$iv) {
                void $this$checkContainsAt$iv;
                if (CharsKt.equals(prefix.charAt(i$iv), $this$checkContainsAt$iv.charAt(startIndex + i$iv), ignoreCase)) continue;
                HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, startIndex, endIndex, prefix, partName$iv);
            }
            n = startIndex + prefix.length();
        }
        int digitsStartIndex = n;
        int digitsEndIndex = endIndex - suffix.length();
        partName$iv = $this$checkPrefixSuffixNumberOfDigits;
        String partName$iv2 = "suffix";
        boolean $i$f$checkContainsAt2 = false;
        if (!(((CharSequence)suffix).length() == 0)) {
            int n3 = ((CharSequence)suffix).length();
            for (int i$iv = 0; i$iv < n3; ++i$iv) {
                void $this$checkContainsAt$iv;
                if (CharsKt.equals(suffix.charAt(i$iv), $this$checkContainsAt$iv.charAt(digitsEndIndex + i$iv), ignoreCase)) continue;
                HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, digitsEndIndex, endIndex, suffix, partName$iv2);
            }
            int cfr_ignored_0 = digitsEndIndex + suffix.length();
        }
        HexExtensionsKt.checkNumberOfDigits($this$checkPrefixSuffixNumberOfDigits, digitsStartIndex, digitsEndIndex, typeHexLength);
    }

    private static final void checkNumberOfDigits(String $this$checkNumberOfDigits, int startIndex, int endIndex, int typeHexLength) {
        int digits = endIndex - startIndex;
        if (digits < 1) {
            HexExtensionsKt.throwInvalidNumberOfDigits($this$checkNumberOfDigits, startIndex, endIndex, "at least", 1);
        } else if (digits > typeHexLength) {
            HexExtensionsKt.checkZeroDigits($this$checkNumberOfDigits, startIndex, startIndex + digits - typeHexLength);
        }
    }

    private static final void checkZeroDigits(String $this$checkZeroDigits, int startIndex, int endIndex) {
        for (int index = startIndex; index < endIndex; ++index) {
            if ($this$checkZeroDigits.charAt(index) == '0') continue;
            throw new NumberFormatException("Expected the hexadecimal digit '0' at index " + index + ", but was '" + $this$checkZeroDigits.charAt(index) + "'.\nThe result won't fit the type being parsed.");
        }
    }

    private static final long parseLong(String $this$parseLong, int startIndex, int endIndex) {
        long result2 = 0L;
        for (int i = startIndex; i < endIndex; ++i) {
            String $this$longDecimalFromHexDigitAt$iv = $this$parseLong;
            boolean $i$f$longDecimalFromHexDigitAt = false;
            char code$iv = $this$longDecimalFromHexDigitAt$iv.charAt(i);
            if (code$iv >>> 8 != 0 || HEX_DIGITS_TO_LONG_DECIMAL[code$iv] < 0L) {
                HexExtensionsKt.throwInvalidDigitAt($this$longDecimalFromHexDigitAt$iv, i);
                throw new KotlinNothingValueException();
            }
            result2 = result2 << 4 | HEX_DIGITS_TO_LONG_DECIMAL[code$iv];
        }
        return result2;
    }

    private static final void throwInvalidNumberOfDigits(String $this$throwInvalidNumberOfDigits, int startIndex, int endIndex, String specifier, int expected) {
        String string = $this$throwInvalidNumberOfDigits;
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String substring = string2;
        throw new NumberFormatException("Expected " + specifier + ' ' + expected + " hexadecimal digits at index " + startIndex + ", but was \"" + substring + "\" of length " + (endIndex - startIndex));
    }

    private static final void throwNotContainedAt(String $this$throwNotContainedAt, int index, int endIndex, String part, String partName) {
        String string = $this$throwNotContainedAt;
        int n = RangesKt.coerceAtMost(index + part.length(), endIndex);
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.substring(index, n);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String substring = string2;
        throw new NumberFormatException("Expected " + partName + " \"" + part + "\" at index " + index + ", but was " + substring);
    }

    private static final void throwInvalidPrefixSuffix(String $this$throwInvalidPrefixSuffix, int startIndex, int endIndex, String prefix, String suffix) {
        String string = $this$throwInvalidPrefixSuffix;
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String substring = string2;
        throw new NumberFormatException("Expected a hexadecimal number with prefix \"" + prefix + "\" and suffix \"" + suffix + "\", but was " + substring);
    }

    private static final Void throwInvalidDigitAt(String $this$throwInvalidDigitAt, int index) {
        throw new NumberFormatException("Expected a hexadecimal digit at index " + index + ", but was " + $this$throwInvalidDigitAt.charAt(index));
    }

    static {
        Object[] objectArray;
        char c;
        int index;
        char item$iv;
        int n;
        int[] nArray;
        int n2;
        int n3 = 0;
        int[] nArray2 = new int[256];
        while (n3 < 256) {
            n2 = n3++;
            nArray2[n2] = "0123456789abcdef".charAt(n2 >> 4) << 8 | "0123456789abcdef".charAt(n2 & 0xF);
        }
        BYTE_TO_LOWER_CASE_HEX_DIGITS = nArray2;
        n3 = 0;
        nArray2 = new int[256];
        while (n3 < 256) {
            n2 = n3++;
            nArray2[n2] = "0123456789ABCDEF".charAt(n2 >> 4) << 8 | "0123456789ABCDEF".charAt(n2 & 0xF);
        }
        BYTE_TO_UPPER_CASE_HEX_DIGITS = nArray2;
        n3 = 0;
        nArray2 = new int[256];
        while (n3 < 256) {
            n2 = n3++;
            nArray2[n2] = -1;
        }
        Object[] $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242 = nArray = nArray2;
        int n4 = 0;
        CharSequence $this$forEachIndexed$iv = "0123456789abcdef";
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n5 = index$iv++;
            char c2 = item$iv;
            index = n5;
            boolean bl = false;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[c] = index;
        }
        $this$forEachIndexed$iv = "0123456789ABCDEF";
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n6 = index$iv++;
            c = item$iv;
            index = n6;
            boolean bl = false;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[c] = index;
        }
        HEX_DIGITS_TO_DECIMAL = nArray;
        int n7 = 0;
        $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242 = new long[256];
        while (n7 < 256) {
            n4 = n7++;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[n4] = (int)-1L;
        }
        Object[] $this$HEX_DIGITS_TO_LONG_DECIMAL_u24lambda_u245 = objectArray = $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242;
        boolean bl = false;
        $this$forEachIndexed$iv = "0123456789abcdef";
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n8 = index$iv++;
            c = item$iv;
            index = n8;
            boolean bl2 = false;
            $this$HEX_DIGITS_TO_LONG_DECIMAL_u24lambda_u245[c] = (int)((long)index);
        }
        $this$forEachIndexed$iv = "0123456789ABCDEF";
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n9 = index$iv++;
            c = item$iv;
            index = n9;
            boolean bl3 = false;
            $this$HEX_DIGITS_TO_LONG_DECIMAL_u24lambda_u245[c] = (int)((long)index);
        }
        HEX_DIGITS_TO_LONG_DECIMAL = objectArray;
    }
}

