/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.DelimitedRangesSequence;
import kotlin.text.StringsKt;
import kotlin.text.StringsKt__StringsJVMKt;

class StringsKt__StringsKt
extends StringsKt__StringsJVMKt {
    public static final String trim(String $this$trim, char ... chars) {
        Intrinsics.checkNotNullParameter($this$trim, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        String $this$trim$iv = $this$trim;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean match$iv$iv = ArraysKt.contains(chars, it);
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    public static final CharSequence trim(CharSequence $this$trim) {
        Intrinsics.checkNotNullParameter($this$trim, "<this>");
        CharSequence $this$trim$iv = $this$trim;
        boolean $i$f$trim = false;
        int startIndex$iv = 0;
        int endIndex$iv = $this$trim$iv.length() - 1;
        boolean startFound$iv = false;
        while (startIndex$iv <= endIndex$iv) {
            int index$iv = !startFound$iv ? startIndex$iv : endIndex$iv;
            char p0 = $this$trim$iv.charAt(index$iv);
            boolean bl = false;
            boolean match$iv = CharsKt.isWhitespace(p0);
            if (!startFound$iv) {
                if (!match$iv) {
                    startFound$iv = true;
                    continue;
                }
                ++startIndex$iv;
                continue;
            }
            if (!match$iv) break;
            --endIndex$iv;
        }
        return $this$trim$iv.subSequence(startIndex$iv, endIndex$iv + 1);
    }

    public static final CharSequence padStart(CharSequence $this$padStart, int length, char padChar) {
        Intrinsics.checkNotNullParameter($this$padStart, "<this>");
        if (length < 0) {
            throw new IllegalArgumentException("Desired length " + length + " is less than zero.");
        }
        if (length <= $this$padStart.length()) {
            return $this$padStart.subSequence(0, $this$padStart.length());
        }
        StringBuilder sb = new StringBuilder(length);
        int i = 1;
        int n = length - $this$padStart.length();
        if (i <= n) {
            while (true) {
                sb.append(padChar);
                if (i == n) break;
                ++i;
            }
        }
        sb.append($this$padStart);
        return sb;
    }

    public static final String padStart(String $this$padStart, int length, char padChar) {
        Intrinsics.checkNotNullParameter($this$padStart, "<this>");
        return ((Object)StringsKt.padStart((CharSequence)$this$padStart, length, padChar)).toString();
    }

    public static final boolean isBlank(CharSequence $this$isBlank) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$isBlank, "<this>");
            CharSequence $this$all$iv = $this$isBlank;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (CharsKt.isWhitespace(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public static final int getLastIndex(CharSequence $this$lastIndex) {
        Intrinsics.checkNotNullParameter($this$lastIndex, "<this>");
        return $this$lastIndex.length() - 1;
    }

    public static final String substring(CharSequence $this$substring, IntRange range) {
        Intrinsics.checkNotNullParameter($this$substring, "<this>");
        Intrinsics.checkNotNullParameter(range, "range");
        return ((Object)$this$substring.subSequence(range.getStart(), range.getEndInclusive() + 1)).toString();
    }

    public static final String substringBefore(String $this$substringBefore, char delimiter, String missingDelimiterValue) {
        String string;
        Intrinsics.checkNotNullParameter($this$substringBefore, "<this>");
        Intrinsics.checkNotNullParameter(missingDelimiterValue, "missingDelimiterValue");
        int index = StringsKt.indexOf$default((CharSequence)$this$substringBefore, delimiter, 0, false, 6, null);
        if (index == -1) {
            string = missingDelimiterValue;
        } else {
            String string2 = $this$substringBefore;
            int n = 0;
            String string3 = string2.substring(n, index);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String substringBefore$default(String string, char c, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return StringsKt.substringBefore(string, c, string2);
    }

    public static final String substringBefore(String $this$substringBefore, String delimiter, String missingDelimiterValue) {
        String string;
        Intrinsics.checkNotNullParameter($this$substringBefore, "<this>");
        Intrinsics.checkNotNullParameter(delimiter, "delimiter");
        Intrinsics.checkNotNullParameter(missingDelimiterValue, "missingDelimiterValue");
        int index = StringsKt.indexOf$default((CharSequence)$this$substringBefore, delimiter, 0, false, 6, null);
        if (index == -1) {
            string = missingDelimiterValue;
        } else {
            String string2 = $this$substringBefore;
            int n = 0;
            String string3 = string2.substring(n, index);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String substringBefore$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string;
        }
        return StringsKt.substringBefore(string, string2, string3);
    }

    public static final String substringAfter(String $this$substringAfter, char delimiter, String missingDelimiterValue) {
        String string;
        Intrinsics.checkNotNullParameter($this$substringAfter, "<this>");
        Intrinsics.checkNotNullParameter(missingDelimiterValue, "missingDelimiterValue");
        int index = StringsKt.indexOf$default((CharSequence)$this$substringAfter, delimiter, 0, false, 6, null);
        if (index == -1) {
            string = missingDelimiterValue;
        } else {
            String string2 = $this$substringAfter;
            int n = index + 1;
            int n2 = $this$substringAfter.length();
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String substringAfter$default(String string, char c, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return StringsKt.substringAfter(string, c, string2);
    }

    public static final String substringAfter(String $this$substringAfter, String delimiter, String missingDelimiterValue) {
        String string;
        Intrinsics.checkNotNullParameter($this$substringAfter, "<this>");
        Intrinsics.checkNotNullParameter(delimiter, "delimiter");
        Intrinsics.checkNotNullParameter(missingDelimiterValue, "missingDelimiterValue");
        int index = StringsKt.indexOf$default((CharSequence)$this$substringAfter, delimiter, 0, false, 6, null);
        if (index == -1) {
            string = missingDelimiterValue;
        } else {
            String string2 = $this$substringAfter;
            int n = index + delimiter.length();
            int n2 = $this$substringAfter.length();
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String substringAfter$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string;
        }
        return StringsKt.substringAfter(string, string2, string3);
    }

    public static final String substringAfterLast(String $this$substringAfterLast, char delimiter, String missingDelimiterValue) {
        String string;
        Intrinsics.checkNotNullParameter($this$substringAfterLast, "<this>");
        Intrinsics.checkNotNullParameter(missingDelimiterValue, "missingDelimiterValue");
        int index = StringsKt.lastIndexOf$default((CharSequence)$this$substringAfterLast, delimiter, 0, false, 6, null);
        if (index == -1) {
            string = missingDelimiterValue;
        } else {
            String string2 = $this$substringAfterLast;
            int n = index + 1;
            int n2 = $this$substringAfterLast.length();
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String substringAfterLast$default(String string, char c, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return StringsKt.substringAfterLast(string, c, string2);
    }

    public static final String removePrefix(String $this$removePrefix, CharSequence prefix) {
        Intrinsics.checkNotNullParameter($this$removePrefix, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (StringsKt.startsWith$default((CharSequence)$this$removePrefix, prefix, false, 2, null)) {
            String string = $this$removePrefix;
            int n = prefix.length();
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return string2;
        }
        return $this$removePrefix;
    }

    public static final String removeSuffix(String $this$removeSuffix, CharSequence suffix) {
        Intrinsics.checkNotNullParameter($this$removeSuffix, "<this>");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        if (StringsKt.endsWith$default((CharSequence)$this$removeSuffix, suffix, false, 2, null)) {
            String string = $this$removeSuffix;
            int n = 0;
            int n2 = $this$removeSuffix.length() - suffix.length();
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return string2;
        }
        return $this$removeSuffix;
    }

    public static final String removeSurrounding(String $this$removeSurrounding, CharSequence prefix, CharSequence suffix) {
        Intrinsics.checkNotNullParameter($this$removeSurrounding, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        if ($this$removeSurrounding.length() >= prefix.length() + suffix.length() && StringsKt.startsWith$default((CharSequence)$this$removeSurrounding, prefix, false, 2, null) && StringsKt.endsWith$default((CharSequence)$this$removeSurrounding, suffix, false, 2, null)) {
            String string = $this$removeSurrounding;
            int n = prefix.length();
            int n2 = $this$removeSurrounding.length() - suffix.length();
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return string2;
        }
        return $this$removeSurrounding;
    }

    public static final String removeSurrounding(String $this$removeSurrounding, CharSequence delimiter) {
        Intrinsics.checkNotNullParameter($this$removeSurrounding, "<this>");
        Intrinsics.checkNotNullParameter(delimiter, "delimiter");
        return StringsKt.removeSurrounding($this$removeSurrounding, delimiter, delimiter);
    }

    public static final boolean regionMatchesImpl(CharSequence $this$regionMatchesImpl, int thisOffset, CharSequence other, int otherOffset, int length, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$regionMatchesImpl, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        if (otherOffset < 0 || thisOffset < 0 || thisOffset > $this$regionMatchesImpl.length() - length || otherOffset > other.length() - length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (CharsKt.equals($this$regionMatchesImpl.charAt(thisOffset + index), other.charAt(otherOffset + index), ignoreCase)) continue;
            return false;
        }
        return true;
    }

    public static final boolean startsWith(CharSequence $this$startsWith, char c, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$startsWith, "<this>");
        return $this$startsWith.length() > 0 && CharsKt.equals($this$startsWith.charAt(0), c, ignoreCase);
    }

    public static /* synthetic */ boolean startsWith$default(CharSequence charSequence, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(charSequence, c, bl);
    }

    public static final boolean startsWith(CharSequence $this$startsWith, CharSequence prefix, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$startsWith, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (!ignoreCase && $this$startsWith instanceof String && prefix instanceof String) {
            return StringsKt.startsWith$default((String)$this$startsWith, (String)prefix, false, 2, null);
        }
        return StringsKt.regionMatchesImpl($this$startsWith, 0, prefix, 0, prefix.length(), ignoreCase);
    }

    public static /* synthetic */ boolean startsWith$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(charSequence, charSequence2, bl);
    }

    public static final boolean endsWith(CharSequence $this$endsWith, CharSequence suffix, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$endsWith, "<this>");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        if (!ignoreCase && $this$endsWith instanceof String && suffix instanceof String) {
            return StringsKt.endsWith$default((String)$this$endsWith, (String)suffix, false, 2, null);
        }
        return StringsKt.regionMatchesImpl($this$endsWith, $this$endsWith.length() - suffix.length(), suffix, 0, suffix.length(), ignoreCase);
    }

    public static /* synthetic */ boolean endsWith$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.endsWith(charSequence, charSequence2, bl);
    }

    public static final int indexOfAny(CharSequence $this$indexOfAny, char[] chars, int startIndex, boolean ignoreCase) {
        int n;
        Intrinsics.checkNotNullParameter($this$indexOfAny, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        if (!ignoreCase && chars.length == 1 && $this$indexOfAny instanceof String) {
            char c = ArraysKt.single(chars);
            return ((String)$this$indexOfAny).indexOf(c, startIndex);
        }
        int index = RangesKt.coerceAtLeast(startIndex, 0);
        if (index <= (n = StringsKt.getLastIndex($this$indexOfAny))) {
            while (true) {
                boolean bl;
                block5: {
                    char charAtIndex = $this$indexOfAny.charAt(index);
                    char[] $this$any$iv = chars;
                    boolean $i$f$any = false;
                    int n2 = $this$any$iv.length;
                    for (int i = 0; i < n2; ++i) {
                        char element$iv;
                        char it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!CharsKt.equals(it, charAtIndex, ignoreCase)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                if (bl) {
                    return index;
                }
                if (index == n) break;
                ++index;
            }
        }
        return -1;
    }

    public static final int lastIndexOfAny(CharSequence $this$lastIndexOfAny, char[] chars, int startIndex, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$lastIndexOfAny, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        if (!ignoreCase && chars.length == 1 && $this$lastIndexOfAny instanceof String) {
            char c = ArraysKt.single(chars);
            return ((String)$this$lastIndexOfAny).lastIndexOf(c, startIndex);
        }
        for (int index = RangesKt.coerceAtMost(startIndex, StringsKt.getLastIndex($this$lastIndexOfAny)); -1 < index; --index) {
            boolean bl;
            block3: {
                char charAtIndex = $this$lastIndexOfAny.charAt(index);
                char[] $this$any$iv = chars;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!CharsKt.equals(it, charAtIndex, ignoreCase)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) continue;
            return index;
        }
        return -1;
    }

    private static final int indexOf$StringsKt__StringsKt(CharSequence $this$indexOf, CharSequence other, int startIndex, int endIndex, boolean ignoreCase, boolean last) {
        IntProgression indices;
        IntProgression intProgression = indices = !last ? (IntProgression)new IntRange(RangesKt.coerceAtLeast(startIndex, 0), RangesKt.coerceAtMost(endIndex, $this$indexOf.length())) : RangesKt.downTo(RangesKt.coerceAtMost(startIndex, StringsKt.getLastIndex($this$indexOf)), RangesKt.coerceAtLeast(endIndex, 0));
        if ($this$indexOf instanceof String && other instanceof String) {
            int index = indices.getFirst();
            int n = indices.getLast();
            int n2 = indices.getStep();
            if (n2 > 0 && index <= n || n2 < 0 && n <= index) {
                while (true) {
                    if (StringsKt.regionMatches((String)other, 0, (String)$this$indexOf, index, other.length(), ignoreCase)) {
                        return index;
                    }
                    if (index != n) {
                        index += n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int index = indices.getFirst();
            int n = indices.getLast();
            int n3 = indices.getStep();
            if (n3 > 0 && index <= n || n3 < 0 && n <= index) {
                while (true) {
                    if (StringsKt.regionMatchesImpl(other, 0, $this$indexOf, index, other.length(), ignoreCase)) {
                        return index;
                    }
                    if (index == n) break;
                    index += n3;
                }
            }
        }
        return -1;
    }

    static /* synthetic */ int indexOf$StringsKt__StringsKt$default(CharSequence charSequence, CharSequence charSequence2, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            bl2 = false;
        }
        return StringsKt__StringsKt.indexOf$StringsKt__StringsKt(charSequence, charSequence2, n, n2, bl, bl2);
    }

    private static final Pair<Integer, String> findAnyOf$StringsKt__StringsKt(CharSequence $this$findAnyOf, Collection<String> strings, int startIndex, boolean ignoreCase, boolean last) {
        IntProgression indices;
        if (!ignoreCase && strings.size() == 1) {
            String string = (String)CollectionsKt.single((Iterable)strings);
            int index = !last ? StringsKt.indexOf$default($this$findAnyOf, string, startIndex, false, 4, null) : StringsKt.lastIndexOf$default($this$findAnyOf, string, startIndex, false, 4, null);
            return index < 0 ? null : TuplesKt.to(index, string);
        }
        IntProgression intProgression = indices = !last ? (IntProgression)new IntRange(RangesKt.coerceAtLeast(startIndex, 0), $this$findAnyOf.length()) : RangesKt.downTo(RangesKt.coerceAtMost(startIndex, StringsKt.getLastIndex($this$findAnyOf)), 0);
        if ($this$findAnyOf instanceof String) {
            int index = indices.getFirst();
            int n = indices.getLast();
            int n2 = indices.getStep();
            if (n2 > 0 && index <= n || n2 < 0 && n <= index) {
                while (true) {
                    Object v1;
                    block12: {
                        Iterable $this$firstOrNull$iv = strings;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            if (!StringsKt.regionMatches(it, 0, (String)$this$findAnyOf, index, it.length(), ignoreCase)) continue;
                            v1 = element$iv;
                            break block12;
                        }
                        v1 = null;
                    }
                    String matchingString = v1;
                    if (matchingString != null) {
                        return TuplesKt.to(index, matchingString);
                    }
                    if (index != n) {
                        index += n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int index = indices.getFirst();
            int n = indices.getLast();
            int n3 = indices.getStep();
            if (n3 > 0 && index <= n || n3 < 0 && n <= index) {
                while (true) {
                    Object v2;
                    block14: {
                        Iterable $this$firstOrNull$iv = strings;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            if (!StringsKt.regionMatchesImpl(it, 0, $this$findAnyOf, index, it.length(), ignoreCase)) continue;
                            v2 = element$iv;
                            break block14;
                        }
                        v2 = null;
                    }
                    String matchingString = v2;
                    if (matchingString != null) {
                        return TuplesKt.to(index, matchingString);
                    }
                    if (index == n) break;
                    index += n3;
                }
            }
        }
        return null;
    }

    public static final int indexOf(CharSequence $this$indexOf, char c, int startIndex, boolean ignoreCase) {
        int n;
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        if (ignoreCase || !($this$indexOf instanceof String)) {
            char[] cArray = new char[]{c};
            n = StringsKt.indexOfAny($this$indexOf, cArray, startIndex, ignoreCase);
        } else {
            n = ((String)$this$indexOf).indexOf(c, startIndex);
        }
        return n;
    }

    public static /* synthetic */ int indexOf$default(CharSequence charSequence, char c, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.indexOf(charSequence, c, n, bl);
    }

    public static final int indexOf(CharSequence $this$indexOf, String string, int startIndex, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        Intrinsics.checkNotNullParameter(string, "string");
        return ignoreCase || !($this$indexOf instanceof String) ? StringsKt__StringsKt.indexOf$StringsKt__StringsKt$default($this$indexOf, string, startIndex, $this$indexOf.length(), ignoreCase, false, 16, null) : ((String)$this$indexOf).indexOf(string, startIndex);
    }

    public static /* synthetic */ int indexOf$default(CharSequence charSequence, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.indexOf(charSequence, string, n, bl);
    }

    public static final int lastIndexOf(CharSequence $this$lastIndexOf, char c, int startIndex, boolean ignoreCase) {
        int n;
        Intrinsics.checkNotNullParameter($this$lastIndexOf, "<this>");
        if (ignoreCase || !($this$lastIndexOf instanceof String)) {
            char[] cArray = new char[]{c};
            n = StringsKt.lastIndexOfAny($this$lastIndexOf, cArray, startIndex, ignoreCase);
        } else {
            n = ((String)$this$lastIndexOf).lastIndexOf(c, startIndex);
        }
        return n;
    }

    public static /* synthetic */ int lastIndexOf$default(CharSequence charSequence, char c, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = StringsKt.getLastIndex(charSequence);
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.lastIndexOf(charSequence, c, n, bl);
    }

    public static final int lastIndexOf(CharSequence $this$lastIndexOf, String string, int startIndex, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$lastIndexOf, "<this>");
        Intrinsics.checkNotNullParameter(string, "string");
        return ignoreCase || !($this$lastIndexOf instanceof String) ? StringsKt__StringsKt.indexOf$StringsKt__StringsKt($this$lastIndexOf, string, startIndex, 0, ignoreCase, true) : ((String)$this$lastIndexOf).lastIndexOf(string, startIndex);
    }

    public static /* synthetic */ int lastIndexOf$default(CharSequence charSequence, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = StringsKt.getLastIndex(charSequence);
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.lastIndexOf(charSequence, string, n, bl);
    }

    public static final boolean contains(CharSequence $this$contains, CharSequence other, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return other instanceof String ? StringsKt.indexOf$default($this$contains, (String)other, 0, ignoreCase, 2, null) >= 0 : StringsKt__StringsKt.indexOf$StringsKt__StringsKt$default($this$contains, other, 0, $this$contains.length(), ignoreCase, false, 16, null) >= 0;
    }

    public static /* synthetic */ boolean contains$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.contains(charSequence, charSequence2, bl);
    }

    public static final boolean contains(CharSequence $this$contains, char c, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        return StringsKt.indexOf$default($this$contains, c, 0, ignoreCase, 2, null) >= 0;
    }

    public static /* synthetic */ boolean contains$default(CharSequence charSequence, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.contains(charSequence, c, bl);
    }

    private static final Sequence<IntRange> rangesDelimitedBy$StringsKt__StringsKt(CharSequence $this$rangesDelimitedBy, char[] delimiters, int startIndex, boolean ignoreCase, int limit) {
        StringsKt.requireNonNegativeLimit(limit);
        return new DelimitedRangesSequence($this$rangesDelimitedBy, startIndex, limit, (Function2<? super CharSequence, ? super Integer, Pair<Integer, Integer>>)new Function2<CharSequence, Integer, Pair<? extends Integer, ? extends Integer>>(delimiters, ignoreCase){
            final /* synthetic */ char[] $delimiters;
            final /* synthetic */ boolean $ignoreCase;
            {
                this.$delimiters = $delimiters;
                this.$ignoreCase = $ignoreCase;
                super(2);
            }

            public final Pair<Integer, Integer> invoke(CharSequence $this$$receiver, int currentIndex) {
                int n;
                Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                int it = n = StringsKt.indexOfAny($this$$receiver, this.$delimiters, currentIndex, this.$ignoreCase);
                boolean bl = false;
                return it < 0 ? null : TuplesKt.to(it, 1);
            }
        });
    }

    static /* synthetic */ Sequence rangesDelimitedBy$StringsKt__StringsKt$default(CharSequence charSequence, char[] cArray, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt(charSequence, cArray, n, bl, n2);
    }

    private static final Sequence<IntRange> rangesDelimitedBy$StringsKt__StringsKt(CharSequence $this$rangesDelimitedBy, String[] delimiters, int startIndex, boolean ignoreCase, int limit) {
        StringsKt.requireNonNegativeLimit(limit);
        List<String> delimitersList = ArraysKt.asList(delimiters);
        return new DelimitedRangesSequence($this$rangesDelimitedBy, startIndex, limit, (Function2<? super CharSequence, ? super Integer, Pair<Integer, Integer>>)new Function2<CharSequence, Integer, Pair<? extends Integer, ? extends Integer>>(delimitersList, ignoreCase){
            final /* synthetic */ List<String> $delimitersList;
            final /* synthetic */ boolean $ignoreCase;
            {
                this.$delimitersList = $delimitersList;
                this.$ignoreCase = $ignoreCase;
                super(2);
            }

            public final Pair<Integer, Integer> invoke(CharSequence $this$$receiver, int currentIndex) {
                Pair<A, Integer> pair;
                Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                Pair pair2 = StringsKt__StringsKt.access$findAnyOf($this$$receiver, this.$delimitersList, currentIndex, this.$ignoreCase, false);
                if (pair2 != null) {
                    Pair pair3;
                    Pair it = pair3 = pair2;
                    boolean bl = false;
                    pair = TuplesKt.to(it.getFirst(), ((String)it.getSecond()).length());
                } else {
                    pair = null;
                }
                return pair;
            }
        });
    }

    static /* synthetic */ Sequence rangesDelimitedBy$StringsKt__StringsKt$default(CharSequence charSequence, String[] stringArray, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt(charSequence, stringArray, n, bl, n2);
    }

    public static final void requireNonNegativeLimit(int limit) {
        boolean bl;
        boolean bl2 = bl = limit >= 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Limit must be non-negative, but was " + limit;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final Sequence<String> splitToSequence(CharSequence $this$splitToSequence, String[] delimiters, boolean ignoreCase, int limit) {
        Intrinsics.checkNotNullParameter($this$splitToSequence, "<this>");
        Intrinsics.checkNotNullParameter(delimiters, "delimiters");
        return SequencesKt.map(StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt$default($this$splitToSequence, delimiters, 0, ignoreCase, limit, 2, null), (Function1)new Function1<IntRange, String>($this$splitToSequence){
            final /* synthetic */ CharSequence $this_splitToSequence;
            {
                this.$this_splitToSequence = $receiver;
                super(1);
            }

            public final String invoke(IntRange it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return StringsKt.substring(this.$this_splitToSequence, it);
            }
        });
    }

    public static /* synthetic */ Sequence splitToSequence$default(CharSequence charSequence, String[] stringArray, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return StringsKt.splitToSequence(charSequence, stringArray, bl, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<String> split(CharSequence $this$split, char[] delimiters, boolean ignoreCase, int limit) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$split, "<this>");
        Intrinsics.checkNotNullParameter(delimiters, "delimiters");
        if (delimiters.length == 1) {
            return StringsKt__StringsKt.split$StringsKt__StringsKt($this$split, String.valueOf(delimiters[0]), ignoreCase, limit);
        }
        Iterable $this$map$iv = SequencesKt.asIterable(StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt$default($this$split, delimiters, 0, ignoreCase, limit, 2, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntRange intRange = (IntRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substring($this$split, (IntRange)it));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List split$default(CharSequence charSequence, char[] cArray, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return StringsKt.split(charSequence, cArray, bl, n);
    }

    private static final List<String> split$StringsKt__StringsKt(CharSequence $this$split, String delimiter, boolean ignoreCase, int limit) {
        StringsKt.requireNonNegativeLimit(limit);
        int currentOffset = 0;
        int nextIndex = StringsKt.indexOf($this$split, delimiter, currentOffset, ignoreCase);
        if (nextIndex == -1 || limit == 1) {
            return CollectionsKt.listOf(((Object)$this$split).toString());
        }
        boolean isLimited = limit > 0;
        ArrayList<String> result2 = new ArrayList<String>(isLimited ? RangesKt.coerceAtMost(limit, 10) : 10);
        do {
            result2.add(((Object)$this$split.subSequence(currentOffset, nextIndex)).toString());
            currentOffset = nextIndex + delimiter.length();
        } while ((!isLimited || result2.size() != limit - 1) && (nextIndex = StringsKt.indexOf($this$split, delimiter, currentOffset, ignoreCase)) != -1);
        result2.add(((Object)$this$split.subSequence(currentOffset, $this$split.length())).toString());
        return result2;
    }

    public static final Sequence<String> lineSequence(CharSequence $this$lineSequence) {
        Intrinsics.checkNotNullParameter($this$lineSequence, "<this>");
        String[] stringArray = new String[]{"\r\n", "\n", "\r"};
        return StringsKt.splitToSequence$default($this$lineSequence, stringArray, false, 0, 6, null);
    }

    public static final List<String> lines(CharSequence $this$lines) {
        Intrinsics.checkNotNullParameter($this$lines, "<this>");
        return SequencesKt.toList(StringsKt.lineSequence($this$lines));
    }

    public static final Boolean toBooleanStrictOrNull(String $this$toBooleanStrictOrNull) {
        Intrinsics.checkNotNullParameter($this$toBooleanStrictOrNull, "<this>");
        String string = $this$toBooleanStrictOrNull;
        return Intrinsics.areEqual(string, "true") ? Boolean.valueOf(true) : (Intrinsics.areEqual(string, "false") ? Boolean.valueOf(false) : null);
    }

    public static final /* synthetic */ Pair access$findAnyOf(CharSequence $receiver, Collection strings, int startIndex, boolean ignoreCase, boolean last) {
        return StringsKt__StringsKt.findAnyOf$StringsKt__StringsKt($receiver, strings, startIndex, ignoreCase, last);
    }
}

