/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.AbstractTimeSource;
import kotlinx.coroutines.AbstractTimeSourceKt;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.EventLoop;
import kotlinx.coroutines.EventLoopImplBase;
import kotlinx.coroutines.ThreadLocalEventLoop;

public final class DefaultExecutor
extends EventLoopImplBase
implements Runnable {
    public static final DefaultExecutor INSTANCE;
    private static final long KEEP_ALIVE_NANOS;
    private static volatile Thread _thread;
    private static volatile int debugStatus;

    private DefaultExecutor() {
    }

    @Override
    protected Thread getThread() {
        Thread thread = _thread;
        if (thread == null) {
            thread = this.createThreadSync();
        }
        return thread;
    }

    private final boolean isShutDown() {
        return debugStatus == 4;
    }

    private final boolean isShutdownRequested() {
        int debugStatus = DefaultExecutor.debugStatus;
        return debugStatus == 2 || debugStatus == 3;
    }

    @Override
    public void enqueue(Runnable task) {
        if (this.isShutDown()) {
            this.shutdownError();
        }
        super.enqueue(task);
    }

    @Override
    protected void reschedule(long now, EventLoopImplBase.DelayedTask delayedTask) {
        this.shutdownError();
    }

    private final void shutdownError() {
        throw new RejectedExecutionException("DefaultExecutor was shut down. This error indicates that Dispatchers.shutdown() was invoked prior to completion of exiting coroutines, leaving coroutines in incomplete state. Please refer to Dispatchers.shutdown documentation for more details");
    }

    @Override
    public void shutdown() {
        debugStatus = 4;
        super.shutdown();
    }

    @Override
    public DisposableHandle invokeOnTimeout(long timeMillis, Runnable block, CoroutineContext context) {
        return this.scheduleInvokeOnTimeout(timeMillis, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadLocalEventLoop.INSTANCE.setEventLoop$kotlinx_coroutines_core(this);
        AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
        if (abstractTimeSource != null) {
            abstractTimeSource.registerTimeLoopThread();
        }
        try {
            long shutdownNanos = Long.MAX_VALUE;
            if (!this.notifyStartup()) {
                return;
            }
            while (true) {
                Unit unit;
                Thread.interrupted();
                long parkNanos = this.processNextEvent();
                if (parkNanos == Long.MAX_VALUE) {
                    long tillShutdown;
                    long now;
                    AbstractTimeSource abstractTimeSource2 = AbstractTimeSourceKt.access$getTimeSource$p();
                    long l = now = abstractTimeSource2 != null ? abstractTimeSource2.nanoTime() : System.nanoTime();
                    if (shutdownNanos == Long.MAX_VALUE) {
                        shutdownNanos = now + KEEP_ALIVE_NANOS;
                    }
                    if ((tillShutdown = shutdownNanos - now) <= 0L) {
                        return;
                    }
                    parkNanos = RangesKt.coerceAtMost(parkNanos, tillShutdown);
                } else {
                    shutdownNanos = Long.MAX_VALUE;
                }
                if (parkNanos <= 0L) continue;
                if (this.isShutdownRequested()) {
                    return;
                }
                AbstractTimeSource abstractTimeSource3 = AbstractTimeSourceKt.access$getTimeSource$p();
                if (abstractTimeSource3 != null) {
                    abstractTimeSource3.parkNanos(this, parkNanos);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) continue;
                LockSupport.parkNanos(this, parkNanos);
            }
        }
        finally {
            _thread = null;
            this.acknowledgeShutdownIfNeeded();
            AbstractTimeSource abstractTimeSource4 = AbstractTimeSourceKt.access$getTimeSource$p();
            if (abstractTimeSource4 != null) {
                abstractTimeSource4.unregisterTimeLoopThread();
            }
            if (!this.isEmpty()) {
                this.getThread();
            }
        }
    }

    private final synchronized Thread createThreadSync() {
        Thread thread = _thread;
        if (thread == null) {
            Thread thread2;
            Thread $this$createThreadSync_u24lambda_u240 = thread2 = new Thread((Runnable)this, "kotlinx.coroutines.DefaultExecutor");
            boolean bl = false;
            _thread = $this$createThreadSync_u24lambda_u240;
            $this$createThreadSync_u24lambda_u240.setContextClassLoader(this.getClass().getClassLoader());
            $this$createThreadSync_u24lambda_u240.setDaemon(true);
            $this$createThreadSync_u24lambda_u240.start();
            thread = thread2;
        }
        return thread;
    }

    private final synchronized boolean notifyStartup() {
        if (this.isShutdownRequested()) {
            return false;
        }
        debugStatus = 1;
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type java.lang.Object");
        ((Object)this).notifyAll();
        return true;
    }

    private final synchronized void acknowledgeShutdownIfNeeded() {
        if (!this.isShutdownRequested()) {
            return;
        }
        debugStatus = 3;
        this.resetAll();
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type java.lang.Object");
        ((Object)this).notifyAll();
    }

    static {
        Long l;
        TimeUnit timeUnit;
        INSTANCE = new DefaultExecutor();
        EventLoop.incrementUseCount$default(INSTANCE, false, 1, null);
        TimeUnit timeUnit2 = TimeUnit.MILLISECONDS;
        try {
            timeUnit = timeUnit2;
            l = Long.getLong("kotlinx.coroutines.DefaultExecutor.keepAlive", 1000L);
        }
        catch (SecurityException e) {
            timeUnit = timeUnit2;
            l = 1000L;
        }
        KEEP_ALIVE_NANOS = timeUnit.toNanos(l);
    }
}

