/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TasksKt;

public final class WorkQueue {
    private final AtomicReferenceArray<Task> buffer = new AtomicReferenceArray(128);
    private volatile /* synthetic */ Object lastScheduledTask$volatile;
    private volatile /* synthetic */ int producerIndex$volatile;
    private volatile /* synthetic */ int consumerIndex$volatile;
    private volatile /* synthetic */ int blockingTasksInBuffer$volatile;
    private static final /* synthetic */ AtomicReferenceFieldUpdater lastScheduledTask$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater producerIndex$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater consumerIndex$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater blockingTasksInBuffer$volatile$FU;

    private final int getBufferSize() {
        return WorkQueue.producerIndex$volatile$FU.get(this) - WorkQueue.consumerIndex$volatile$FU.get(this);
    }

    public final int getSize$kotlinx_coroutines_core() {
        return WorkQueue.lastScheduledTask$volatile$FU.get(this) != null ? this.getBufferSize() + 1 : this.getBufferSize();
    }

    public final Task poll() {
        Task task = WorkQueue.lastScheduledTask$volatile$FU.getAndSet(this, null);
        if (task == null) {
            task = this.pollBuffer();
        }
        return task;
    }

    public final Task add(Task task, boolean fair) {
        if (fair) {
            return this.addLast(task);
        }
        Task task2 = WorkQueue.lastScheduledTask$volatile$FU.getAndSet(this, task);
        if (task2 == null) {
            return null;
        }
        Task previous = task2;
        return this.addLast(previous);
    }

    private final Task addLast(Task task) {
        if (this.getBufferSize() == 127) {
            return task;
        }
        Task $this$isBlocking$iv = task;
        boolean $i$f$isBlocking = false;
        if ($this$isBlocking$iv.taskContext.getTaskMode() == 1) {
            WorkQueue.blockingTasksInBuffer$volatile$FU.incrementAndGet(this);
        }
        int nextIndex = WorkQueue.producerIndex$volatile$FU.get(this) & 0x7F;
        while (this.buffer.get(nextIndex) != null) {
            Thread.yield();
        }
        this.buffer.lazySet(nextIndex, task);
        WorkQueue.producerIndex$volatile$FU.incrementAndGet(this);
        return null;
    }

    public final long trySteal(int stealingMode, Ref.ObjectRef<Task> stolenTaskRef) {
        Task task;
        Task task2 = task = stealingMode == 3 ? this.pollBuffer() : this.stealWithExclusiveMode(stealingMode);
        if (task != null) {
            stolenTaskRef.element = task;
            return -1L;
        }
        return this.tryStealLastScheduled(stealingMode, stolenTaskRef);
    }

    private final Task stealWithExclusiveMode(int stealingMode) {
        boolean onlyBlocking;
        int start = WorkQueue.consumerIndex$volatile$FU.get(this);
        int end = WorkQueue.producerIndex$volatile$FU.get(this);
        boolean bl = onlyBlocking = stealingMode == 1;
        while (start != end) {
            if (onlyBlocking && WorkQueue.blockingTasksInBuffer$volatile$FU.get(this) == 0) {
                return null;
            }
            Task task = this.tryExtractFromTheMiddle(start++, onlyBlocking);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    public final Task pollBlocking() {
        return this.pollWithExclusiveMode(true);
    }

    private final Task pollWithExclusiveMode(boolean onlyBlocking) {
        while ((Task)WorkQueue.lastScheduledTask$volatile$FU.get(this) != null) {
            Task lastScheduled;
            Task $this$isBlocking$iv = lastScheduled;
            boolean $i$f$isBlocking = false;
            if ($this$isBlocking$iv.taskContext.getTaskMode() == 1 != onlyBlocking) break;
            if (!WorkQueue.lastScheduledTask$volatile$FU.compareAndSet(this, lastScheduled, null)) continue;
            return lastScheduled;
        }
        int start = WorkQueue.consumerIndex$volatile$FU.get(this);
        int end = WorkQueue.producerIndex$volatile$FU.get(this);
        while (start != end) {
            Task task;
            if (onlyBlocking && WorkQueue.blockingTasksInBuffer$volatile$FU.get(this) == 0) {
                return null;
            }
            if ((task = this.tryExtractFromTheMiddle(--end, onlyBlocking)) == null) continue;
            return task;
        }
        return null;
    }

    private final Task tryExtractFromTheMiddle(int index, boolean onlyBlocking) {
        int arrayIndex = index & 0x7F;
        Task value = this.buffer.get(arrayIndex);
        if (value != null) {
            Task $this$isBlocking$iv = value;
            boolean $i$f$isBlocking = false;
            if ($this$isBlocking$iv.taskContext.getTaskMode() == 1 == onlyBlocking && this.buffer.compareAndSet(arrayIndex, value, null)) {
                if (onlyBlocking) {
                    WorkQueue.blockingTasksInBuffer$volatile$FU.decrementAndGet(this);
                }
                return value;
            }
        }
        return null;
    }

    public final void offloadAllWorkTo(GlobalQueue globalQueue) {
        Task task = WorkQueue.lastScheduledTask$volatile$FU.getAndSet(this, null);
        if (task != null) {
            Task it = task;
            boolean bl = false;
            globalQueue.addLast(it);
        }
        while (this.pollTo(globalQueue)) {
        }
    }

    private final long tryStealLastScheduled(int stealingMode, Ref.ObjectRef<Task> stolenTaskRef) {
        Task lastScheduled;
        do {
            if ((Task)WorkQueue.lastScheduledTask$volatile$FU.get(this) == null) {
                return -2L;
            }
            Task $this$maskForStealingMode$iv = lastScheduled;
            boolean $i$f$getMaskForStealingMode = false;
            Task $this$isBlocking$iv$iv = $this$maskForStealingMode$iv;
            boolean $i$f$isBlocking = false;
            if ((($this$isBlocking$iv$iv.taskContext.getTaskMode() == 1 ? 1 : 2) & stealingMode) == 0) {
                return -2L;
            }
            long time = TasksKt.schedulerTimeSource.nanoTime();
            long staleness = time - lastScheduled.submissionTime;
            if (staleness >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS) continue;
            return TasksKt.WORK_STEALING_TIME_RESOLUTION_NS - staleness;
        } while (!WorkQueue.lastScheduledTask$volatile$FU.compareAndSet(this, lastScheduled, null));
        stolenTaskRef.element = lastScheduled;
        return -1L;
    }

    private final boolean pollTo(GlobalQueue queue) {
        Task task = this.pollBuffer();
        if (task == null) {
            return false;
        }
        Task task2 = task;
        queue.addLast(task2);
        return true;
    }

    private final Task pollBuffer() {
        Task task;
        while (true) {
            int tailLocal;
            if ((tailLocal = WorkQueue.consumerIndex$volatile$FU.get(this)) - WorkQueue.producerIndex$volatile$FU.get(this) == 0) {
                return null;
            }
            int index = tailLocal & 0x7F;
            if (!WorkQueue.consumerIndex$volatile$FU.compareAndSet(this, tailLocal, tailLocal + 1)) continue;
            task = this.buffer.getAndSet(index, null);
            if (task != null) break;
        }
        Task value = task;
        this.decrementIfBlocking(value);
        return value;
    }

    private final void decrementIfBlocking(Task $this$decrementIfBlocking) {
        if ($this$decrementIfBlocking != null) {
            Task $this$isBlocking$iv = $this$decrementIfBlocking;
            boolean $i$f$isBlocking = false;
            if ($this$isBlocking$iv.taskContext.getTaskMode() == 1) {
                int value = WorkQueue.blockingTasksInBuffer$volatile$FU.decrementAndGet(this);
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl = false;
                    if (!(value >= 0)) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    static {
        lastScheduledTask$volatile$FU = AtomicReferenceFieldUpdater.newUpdater(WorkQueue.class, Object.class, "lastScheduledTask$volatile");
        producerIndex$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "producerIndex$volatile");
        consumerIndex$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "consumerIndex$volatile");
        blockingTasksInBuffer$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "blockingTasksInBuffer$volatile");
    }
}

