/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;

public final class ElementMarker {
    private static final Companion Companion = new Companion(null);
    private final SerialDescriptor descriptor;
    private final Function2<SerialDescriptor, Integer, Boolean> readIfAbsent;
    private long lowerMarks;
    private final long[] highMarksArray;
    private static final long[] EMPTY_HIGH_MARKS = new long[0];

    public ElementMarker(SerialDescriptor descriptor, Function2<? super SerialDescriptor, ? super Integer, Boolean> readIfAbsent) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(readIfAbsent, "readIfAbsent");
        this.descriptor = descriptor;
        this.readIfAbsent = readIfAbsent;
        int elementsCount = this.descriptor.getElementsCount();
        if (elementsCount <= 64) {
            this.lowerMarks = elementsCount == 64 ? 0L : -1L << elementsCount;
            this.highMarksArray = EMPTY_HIGH_MARKS;
        } else {
            this.lowerMarks = 0L;
            this.highMarksArray = this.prepareHighMarksArray(elementsCount);
        }
    }

    public final void mark(int index) {
        if (index < 64) {
            this.lowerMarks |= 1L << index;
        } else {
            this.markHigh(index);
        }
    }

    public final int nextUnmarkedIndex() {
        int elementsCount = this.descriptor.getElementsCount();
        while (this.lowerMarks != -1L) {
            int index = Long.numberOfTrailingZeros(this.lowerMarks ^ 0xFFFFFFFFFFFFFFFFL);
            this.lowerMarks |= 1L << index;
            if (!this.readIfAbsent.invoke(this.descriptor, index).booleanValue()) continue;
            return index;
        }
        if (elementsCount > 64) {
            return this.nextUnmarkedHighIndex();
        }
        return -1;
    }

    private final long[] prepareHighMarksArray(int elementsCount) {
        int slotsCount = elementsCount - 1 >>> 6;
        int elementsInLastSlot = elementsCount & 0x3F;
        long[] highMarks = new long[slotsCount];
        if (elementsInLastSlot != 0) {
            highMarks[ArraysKt.getLastIndex((long[])highMarks)] = -1L << elementsCount;
        }
        return highMarks;
    }

    private final void markHigh(int index) {
        int slot = (index >>> 6) - 1;
        int offsetInSlot = index & 0x3F;
        this.highMarksArray[slot] = this.highMarksArray[slot] | 1L << offsetInSlot;
    }

    private final int nextUnmarkedHighIndex() {
        int n = this.highMarksArray.length;
        for (int slot = 0; slot < n; ++slot) {
            long slotMarks;
            int indexInSlot;
            int slotOffset = (slot + 1) * 64;
            for (slotMarks = this.highMarksArray[slot]; slotMarks != -1L; slotMarks |= 1L << indexInSlot) {
                indexInSlot = Long.numberOfTrailingZeros(slotMarks ^ 0xFFFFFFFFFFFFFFFFL);
                int index = slotOffset + indexInSlot;
                if (!this.readIfAbsent.invoke(this.descriptor, index).booleanValue()) continue;
                this.highMarksArray[slot] = slotMarks;
                return index;
            }
            this.highMarksArray[slot] = slotMarks;
        }
        return -1;
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

