/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.internal.PolymorphismValidator;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;

final class JsonImpl
extends Json {
    public JsonImpl(JsonConfiguration configuration, SerializersModule module) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(module, "module");
        super(configuration, module, null);
        this.validateConfiguration();
    }

    private final void validateConfiguration() {
        if (Intrinsics.areEqual(this.getSerializersModule(), SerializersModuleBuildersKt.EmptySerializersModule())) {
            return;
        }
        PolymorphismValidator collector = new PolymorphismValidator(this.getConfiguration().getUseArrayPolymorphism(), this.getConfiguration().getClassDiscriminator());
        this.getSerializersModule().dumpTo(collector);
    }
}

