/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

public final class CharMappings {
    public static final CharMappings INSTANCE = new CharMappings();
    public static final char[] ESCAPE_2_CHAR = new char[117];
    public static final byte[] CHAR_TO_TOKEN = new byte[126];

    private CharMappings() {
    }

    private final void initEscape() {
        for (int i = 0; i < 32; ++i) {
            this.initC2ESC(i, 'u');
        }
        this.initC2ESC(8, 'b');
        this.initC2ESC(9, 't');
        this.initC2ESC(10, 'n');
        this.initC2ESC(12, 'f');
        this.initC2ESC(13, 'r');
        this.initC2ESC('/', '/');
        this.initC2ESC('\"', '\"');
        this.initC2ESC('\\', '\\');
    }

    private final void initCharToToken() {
        for (int i = 0; i < 33; ++i) {
            this.initC2TC(i, (byte)127);
        }
        this.initC2TC(9, (byte)3);
        this.initC2TC(10, (byte)3);
        this.initC2TC(13, (byte)3);
        this.initC2TC(32, (byte)3);
        this.initC2TC(',', (byte)4);
        this.initC2TC(':', (byte)5);
        this.initC2TC('{', (byte)6);
        this.initC2TC('}', (byte)7);
        this.initC2TC('[', (byte)8);
        this.initC2TC(']', (byte)9);
        this.initC2TC('\"', (byte)1);
        this.initC2TC('\\', (byte)2);
    }

    private final void initC2ESC(int c, char esc) {
        if (esc != 'u') {
            CharMappings.ESCAPE_2_CHAR[esc] = (char)c;
        }
    }

    private final void initC2ESC(char c, char esc) {
        this.initC2ESC((int)c, esc);
    }

    private final void initC2TC(int c, byte cl) {
        CharMappings.CHAR_TO_TOKEN[c] = cl;
    }

    private final void initC2TC(char c, byte cl) {
        this.initC2TC((int)c, cl);
    }

    static {
        INSTANCE.initEscape();
        INSTANCE.initCharToToken();
    }
}

