/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.InternalJsonWriter;

public final class ComposerWithPrettyPrint
extends Composer {
    private final Json json;
    private int level;

    public ComposerWithPrettyPrint(InternalJsonWriter writer, Json json) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(json, "json");
        super(writer);
        this.json = json;
    }

    @Override
    public void indent() {
        this.setWritingFirst(true);
        int n = this.level;
        this.level = n + 1;
    }

    @Override
    public void unIndent() {
        int n = this.level;
        this.level = n + -1;
    }

    @Override
    public void nextItem() {
        this.setWritingFirst(false);
        this.print("\n");
        int n = this.level;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this.print(this.json.getConfiguration().getPrettyPrintIndent());
        }
    }

    @Override
    public void nextItemIfNotFirst() {
        if (this.getWritingFirst()) {
            this.setWritingFirst(false);
        } else {
            this.nextItem();
        }
    }

    @Override
    public void space() {
        this.print(' ');
    }
}

