/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import kotlinx.serialization.json.internal.ComposersKt;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    private final Composer composer;
    private final Json json;
    private final WriteMode mode;
    private final JsonEncoder[] modeReuseCache;
    private final SerializersModule serializersModule;
    private final JsonConfiguration configuration;
    private boolean forceQuoting;
    private String polymorphicDiscriminator;
    private String polymorphicSerialName;

    public StreamingJsonEncoder(Composer composer, Json json, WriteMode mode, JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter(composer, "composer");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        this.composer = composer;
        this.json = json;
        this.mode = mode;
        this.modeReuseCache = modeReuseCache;
        this.serializersModule = this.getJson().getSerializersModule();
        this.configuration = this.getJson().getConfiguration();
        int i = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this)) {
            this.modeReuseCache[i] = this;
        }
    }

    @Override
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonEncoder(InternalJsonWriter output, Json json, WriteMode mode, JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(modeReuseCache, "modeReuseCache");
        this(ComposersKt.Composer(output, json), json, mode, modeReuseCache);
    }

    @Override
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> void encodeSerializableValue(SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        JsonEncoder $this$encodePolymorphically$iv = this;
        boolean $i$f$encodePolymorphically = false;
        if ($this$encodePolymorphically$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer.serialize($this$encodePolymorphically$iv, value);
        } else {
            SerializationStrategy<T> actualSerializer$iv;
            SerializationStrategy<T> serializationStrategy;
            String baseClassDiscriminator$iv;
            boolean bl;
            boolean isPolymorphicSerializer$iv = serializer instanceof AbstractPolymorphicSerializer;
            if (isPolymorphicSerializer$iv) {
                bl = $this$encodePolymorphically$iv.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
            } else {
                switch (PolymorphicKt.WhenMappings.$EnumSwitchMapping$0[$this$encodePolymorphically$iv.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                    case 1: 
                    case 2: {
                        bl = false;
                        break;
                    }
                    case 3: {
                        SerialKind it$iv = serializer.getDescriptor().getKind();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual(it$iv, StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual(it$iv, StructureKind.OBJECT.INSTANCE)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean needDiscriminator$iv = bl;
            String string = baseClassDiscriminator$iv = needDiscriminator$iv ? PolymorphicKt.classDiscriminator(serializer.getDescriptor(), $this$encodePolymorphically$iv.getJson()) : null;
            if (isPolymorphicSerializer$iv) {
                AbstractPolymorphicSerializer casted$iv = (AbstractPolymorphicSerializer)serializer;
                if (value == null) {
                    boolean $i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$1$iv22 = false;
                    String $i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$1$iv22 = "Value for serializer " + ((AbstractPolymorphicSerializer)serializer).getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$1$iv22.toString());
                }
                SerializationStrategy<T> actual$iv = PolymorphicSerializerKt.findPolymorphicSerializer(casted$iv, $this$encodePolymorphically$iv, value);
                if (baseClassDiscriminator$iv != null) {
                    PolymorphicKt.access$validateIfSealed(serializer, actual$iv, baseClassDiscriminator$iv);
                }
                PolymorphicKt.checkKind(actual$iv.getDescriptor().getKind());
                Intrinsics.checkNotNull(actual$iv, "null cannot be cast to non-null type kotlinx.serialization.SerializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.encodePolymorphically>");
                serializationStrategy = actual$iv;
            } else {
                serializationStrategy = actualSerializer$iv = serializer;
            }
            if (baseClassDiscriminator$iv != null) {
                void serialName;
                String string2 = actualSerializer$iv.getDescriptor().getSerialName();
                String discriminatorName = baseClassDiscriminator$iv;
                boolean bl3 = false;
                this.polymorphicDiscriminator = discriminatorName;
                this.polymorphicSerialName = serialName;
            }
            actualSerializer$iv.serialize($this$encodePolymorphically$iv, value);
        }
    }

    private final void encodeTypeInfo(String discriminator, String serialName) {
        this.composer.nextItem();
        this.encodeString(discriminator);
        this.composer.print(':');
        this.composer.space();
        this.encodeString(serialName);
    }

    @Override
    public CompositeEncoder beginStructure(SerialDescriptor descriptor) {
        String discriminator;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.getJson(), descriptor);
        if (newMode.begin != '\u0000') {
            this.composer.print(newMode.begin);
            this.composer.indent();
        }
        if ((discriminator = this.polymorphicDiscriminator) != null) {
            String string = this.polymorphicSerialName;
            if (string == null) {
                string = descriptor.getSerialName();
            }
            this.encodeTypeInfo(discriminator, string);
            this.polymorphicDiscriminator = null;
            this.polymorphicSerialName = null;
        }
        if (this.mode == newMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        return this.modeReuseCache != null && (object = object[newMode.ordinal()]) != null ? (CompositeEncoder)object : (CompositeEncoder)new StreamingJsonEncoder(this.composer, this.getJson(), newMode, this.modeReuseCache);
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItemIfNotFirst();
            this.composer.print(this.mode.end);
        }
    }

    @Override
    public boolean encodeElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl;
                    if (index % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (index == 0) {
                    this.forceQuoting = true;
                }
                if (index != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(JsonNamesMapKt.getJsonElementName(descriptor, this.getJson(), index));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Encoder encodeInline(SerialDescriptor descriptor) {
        Encoder encoder;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (StreamingJsonEncoderKt.isUnsignedNumber(descriptor)) {
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            boolean $i$f$composerAs = false;
            if (this_$iv.composer instanceof ComposerForUnsignedNumbers) {
                composer = this_$iv.composer;
            } else {
                void p1;
                boolean bl = this_$iv.forceQuoting;
                InternalJsonWriter p0 = this_$iv.composer.writer;
                boolean $i$f$encodeInline$stub_for_inlining = false;
                boolean bl2 = false;
                composer = new ComposerForUnsignedNumbers(p0, (boolean)p1);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer2 = composer;
            encoder = new StreamingJsonEncoder(composer2, json, writeMode, jsonEncoderArray);
        } else if (StreamingJsonEncoderKt.isUnquotedLiteral(descriptor)) {
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            boolean $i$f$composerAs = false;
            if (this_$iv.composer instanceof ComposerForUnquotedLiterals) {
                composer = this_$iv.composer;
            } else {
                boolean p1 = this_$iv.forceQuoting;
                InternalJsonWriter p0 = this_$iv.composer.writer;
                boolean $i$f$encodeInline$stub_for_inlining$1 = false;
                boolean bl = false;
                composer = new ComposerForUnquotedLiterals(p0, p1);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer3 = composer;
            encoder = new StreamingJsonEncoder(composer3, json, writeMode, jsonEncoderArray);
        } else if (this.polymorphicDiscriminator != null) {
            StreamingJsonEncoder streamingJsonEncoder;
            StreamingJsonEncoder $this$encodeInline_u24lambda_u242 = streamingJsonEncoder = this;
            boolean bl = false;
            $this$encodeInline_u24lambda_u242.polymorphicSerialName = descriptor.getSerialName();
            encoder = streamingJsonEncoder;
        } else {
            encoder = super.encodeInline(descriptor);
        }
        return encoder;
    }

    @Override
    public void encodeNull() {
        this.composer.print("null");
    }

    @Override
    public void encodeBoolean(boolean value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeByte(byte value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeShort(short value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeInt(int value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeLong(long value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeFloat(float value) {
        float f;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Float.isInfinite(f = value) && !Float.isNaN(f))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf(value), this.composer.writer.toString());
        }
    }

    @Override
    public void encodeDouble(double value) {
        double d;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Double.isInfinite(d = value) && !Double.isNaN(d))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(value, this.composer.writer.toString());
        }
    }

    @Override
    public void encodeChar(char value) {
        this.encodeString(String.valueOf(value));
    }

    @Override
    public void encodeString(String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.composer.printQuoted(value);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

