/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

public final class Handshake {
    public static final Companion Companion = new Companion(null);
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List<Certificate> localCertificates;
    private final Lazy peerCertificates$delegate;

    public Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<? extends Certificate> localCertificates, Function0<? extends List<? extends Certificate>> peerCertificatesFn) {
        Intrinsics.checkNotNullParameter((Object)tlsVersion, "tlsVersion");
        Intrinsics.checkNotNullParameter(cipherSuite, "cipherSuite");
        Intrinsics.checkNotNullParameter(localCertificates, "localCertificates");
        Intrinsics.checkNotNullParameter(peerCertificatesFn, "peerCertificatesFn");
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.localCertificates = localCertificates;
        this.peerCertificates$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Certificate>>(peerCertificatesFn){
            final /* synthetic */ Function0<List<Certificate>> $peerCertificatesFn;
            {
                this.$peerCertificatesFn = $peerCertificatesFn;
                super(0);
            }

            public final List<Certificate> invoke() {
                List<Certificate> list;
                try {
                    list = this.$peerCertificatesFn.invoke();
                }
                catch (SSLPeerUnverifiedException spue) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        });
    }

    public final TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    public final CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    public final List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    public final List<Certificate> peerCertificates() {
        Lazy lazy = this.peerCertificates$delegate;
        return (List)lazy.getValue();
    }

    public boolean equals(Object other) {
        return other instanceof Handshake && ((Handshake)other).tlsVersion == this.tlsVersion && Intrinsics.areEqual(((Handshake)other).cipherSuite, this.cipherSuite) && Intrinsics.areEqual(((Handshake)other).peerCertificates(), this.peerCertificates()) && Intrinsics.areEqual(((Handshake)other).localCertificates, this.localCertificates);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.tlsVersion.hashCode();
        result2 = 31 * result2 + this.cipherSuite.hashCode();
        result2 = 31 * result2 + ((Object)this.peerCertificates()).hashCode();
        result2 = 31 * result2 + ((Object)this.localCertificates).hashCode();
        return result2;
    }

    public String toString() {
        Certificate it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.peerCertificates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Certificate certificate = (Certificate)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.getName(it));
        }
        String peerCertificatesString = ((List)destination$iv$iv).toString();
        $this$map$iv = this.localCertificates;
        object = new StringBuilder().append("Handshake{tlsVersion=").append((Object)this.tlsVersion).append(" cipherSuite=").append(this.cipherSuite).append(" peerCertificates=").append(peerCertificatesString).append(" localCertificates=");
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getName(it));
        }
        return ((StringBuilder)object).append((List)destination$iv$iv).append('}').toString();
    }

    private final String getName(Certificate $this$name) {
        String string;
        if ($this$name instanceof X509Certificate) {
            string = ((Object)((X509Certificate)$this$name).getSubjectDN()).toString();
        } else {
            String string2 = $this$name.getType();
            Intrinsics.checkNotNullExpressionValue(string2, "type");
            string = string2;
        }
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public final Handshake get(SSLSession $this$handshake) throws IOException {
            List<Object> list;
            Intrinsics.checkNotNullParameter($this$handshake, "<this>");
            String string = $this$handshake.getCipherSuite();
            if (string == null) {
                boolean $i$a$-checkNotNull-Handshake$Companion$handshake$cipherSuiteString$22 = false;
                String $i$a$-checkNotNull-Handshake$Companion$handshake$cipherSuiteString$22 = "cipherSuite == null";
                throw new IllegalStateException($i$a$-checkNotNull-Handshake$Companion$handshake$cipherSuiteString$22.toString());
            }
            String cipherSuiteString = string;
            String $i$a$-checkNotNull-Handshake$Companion$handshake$cipherSuiteString$22 = cipherSuiteString;
            if (Intrinsics.areEqual($i$a$-checkNotNull-Handshake$Companion$handshake$cipherSuiteString$22, "TLS_NULL_WITH_NULL_NULL") ? true : Intrinsics.areEqual($i$a$-checkNotNull-Handshake$Companion$handshake$cipherSuiteString$22, "SSL_NULL_WITH_NULL_NULL")) {
                throw new IOException(Intrinsics.stringPlus("cipherSuite == ", cipherSuiteString));
            }
            CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
            String string2 = $this$handshake.getProtocol();
            if (string2 == null) {
                boolean $i$a$-checkNotNull-Handshake$Companion$handshake$tlsVersionString$22 = false;
                String $i$a$-checkNotNull-Handshake$Companion$handshake$tlsVersionString$22 = "tlsVersion == null";
                throw new IllegalStateException($i$a$-checkNotNull-Handshake$Companion$handshake$tlsVersionString$22.toString());
            }
            String tlsVersionString = string2;
            if (Intrinsics.areEqual("NONE", tlsVersionString)) {
                throw new IOException("tlsVersion == NONE");
            }
            TlsVersion tlsVersion = TlsVersion.Companion.forJavaName(tlsVersionString);
            try {
                list = this.toImmutableList($this$handshake.getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException _) {
                list = CollectionsKt.emptyList();
            }
            List peerCertificatesCopy = list;
            return new Handshake(tlsVersion, cipherSuite, this.toImmutableList($this$handshake.getLocalCertificates()), (Function0<? extends List<? extends Certificate>>)new Function0<List<? extends Certificate>>(peerCertificatesCopy){
                final /* synthetic */ List<Certificate> $peerCertificatesCopy;
                {
                    this.$peerCertificatesCopy = $peerCertificatesCopy;
                    super(0);
                }

                public final List<Certificate> invoke() {
                    return this.$peerCertificatesCopy;
                }
            });
        }

        private final List<Certificate> toImmutableList(Certificate[] $this$toImmutableList) {
            return $this$toImmutableList != null ? Util.immutableListOf(Arrays.copyOf($this$toImmutableList, $this$toImmutableList.length)) : CollectionsKt.emptyList();
        }

        public final Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<? extends Certificate> peerCertificates2, List<? extends Certificate> localCertificates) {
            Intrinsics.checkNotNullParameter((Object)tlsVersion, "tlsVersion");
            Intrinsics.checkNotNullParameter(cipherSuite, "cipherSuite");
            Intrinsics.checkNotNullParameter(peerCertificates2, "peerCertificates");
            Intrinsics.checkNotNullParameter(localCertificates, "localCertificates");
            List<? extends Certificate> peerCertificatesCopy = Util.toImmutableList(peerCertificates2);
            return new Handshake(tlsVersion, cipherSuite, Util.toImmutableList(localCertificates), (Function0<? extends List<? extends Certificate>>)new Function0<List<? extends Certificate>>(peerCertificatesCopy){
                final /* synthetic */ List<Certificate> $peerCertificatesCopy;
                {
                    this.$peerCertificatesCopy = $peerCertificatesCopy;
                    super(0);
                }

                public final List<Certificate> invoke() {
                    return this.$peerCertificatesCopy;
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

