/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.Header;
import okhttp3.internal.io.FileSystem;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Source;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Headers EMPTY_HEADERS = Headers.Companion.of(new String[0]);
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.Companion.create$default(ResponseBody.Companion, EMPTY_BYTE_ARRAY, null, 1, null);
    public static final RequestBody EMPTY_REQUEST = RequestBody.Companion.create$default(RequestBody.Companion, EMPTY_BYTE_ARRAY, null, 0, 0, 7, null);
    private static final Options UNICODE_BOMS;
    public static final TimeZone UTC;
    private static final Regex VERIFY_AS_IP_ADDRESS;
    public static final boolean assertionsEnabled;
    public static final String okHttpName;

    public static final void checkOffsetAndCount(long arrayLength, long offset, long count) {
        if ((offset | count) < 0L || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static final ThreadFactory threadFactory(String name, boolean daemon) {
        Intrinsics.checkNotNullParameter(name, "name");
        return arg_0 -> Util.threadFactory$lambda-1(name, daemon, arg_0);
    }

    public static final String[] intersect(String[] $this$intersect, String[] other, Comparator<? super String> comparator) {
        Intrinsics.checkNotNullParameter($this$intersect, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        List result2 = new ArrayList();
        int n = 0;
        int n2 = $this$intersect.length;
        block0: while (n < n2) {
            String a = $this$intersect[n];
            ++n;
            for (String b : other) {
                if (comparator.compare(a, b) != 0) continue;
                result2.add(a);
                continue block0;
            }
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return stringArray;
    }

    public static final boolean hasIntersection(String[] $this$hasIntersection, String[] other, Comparator<? super String> comparator) {
        Intrinsics.checkNotNullParameter($this$hasIntersection, "<this>");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        if ($this$hasIntersection.length == 0 || other == null || other.length == 0) {
            return false;
        }
        int n = 0;
        int n2 = $this$hasIntersection.length;
        while (n < n2) {
            String a = $this$hasIntersection[n];
            ++n;
            Iterator<String> iterator2 = ArrayIteratorKt.iterator(other);
            while (iterator2.hasNext()) {
                String b = iterator2.next();
                if (comparator.compare(a, b) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static final String toHostHeader(HttpUrl $this$toHostHeader, boolean includeDefaultPort) {
        Intrinsics.checkNotNullParameter($this$toHostHeader, "<this>");
        String host = StringsKt.contains$default((CharSequence)$this$toHostHeader.host(), ":", false, 2, null) ? '[' + $this$toHostHeader.host() + ']' : $this$toHostHeader.host();
        return includeDefaultPort || $this$toHostHeader.port() != HttpUrl.Companion.defaultPort($this$toHostHeader.scheme()) ? host + ':' + $this$toHostHeader.port() : host;
    }

    public static /* synthetic */ String toHostHeader$default(HttpUrl httpUrl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return Util.toHostHeader(httpUrl, bl);
    }

    public static final int indexOf(String[] $this$indexOf, String value, Comparator<String> comparator) {
        int n;
        block1: {
            Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(comparator, "comparator");
            String[] $this$indexOfFirst$iv = $this$indexOf;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                String it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(comparator.compare(it, value) == 0)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    public static final String[] concat(String[] $this$concat, String value) {
        Intrinsics.checkNotNullParameter($this$concat, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        String[] stringArray = Arrays.copyOf($this$concat, $this$concat.length + 1);
        Intrinsics.checkNotNullExpressionValue(stringArray, "copyOf(this, newSize)");
        String[] result2 = stringArray;
        result2[ArraysKt.getLastIndex(result2)] = value;
        return result2;
    }

    public static final int indexOfFirstNonAsciiWhitespace(String $this$indexOfFirstNonAsciiWhitespace, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter($this$indexOfFirstNonAsciiWhitespace, "<this>");
        int n = startIndex;
        while (n < endIndex) {
            int i;
            char c;
            if (((((c = $this$indexOfFirstNonAsciiWhitespace.charAt(i = n++)) == '\t' ? true : c == '\n') ? true : c == '\f') ? true : c == '\r') ? true : c == ' ') continue;
            return i;
        }
        return endIndex;
    }

    public static /* synthetic */ int indexOfFirstNonAsciiWhitespace$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Util.indexOfFirstNonAsciiWhitespace(string, n, n2);
    }

    public static final int indexOfLastNonAsciiWhitespace(String $this$indexOfLastNonAsciiWhitespace, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter($this$indexOfLastNonAsciiWhitespace, "<this>");
        int n = endIndex - 1;
        if (startIndex <= n) {
            int i;
            do {
                char c;
                if (((((c = $this$indexOfLastNonAsciiWhitespace.charAt(i = n--)) == '\t' ? true : c == '\n') ? true : c == '\f') ? true : c == '\r') ? true : c == ' ') continue;
                return i + 1;
            } while (i != startIndex);
        }
        return startIndex;
    }

    public static /* synthetic */ int indexOfLastNonAsciiWhitespace$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Util.indexOfLastNonAsciiWhitespace(string, n, n2);
    }

    public static final String trimSubstring(String $this$trimSubstring, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter($this$trimSubstring, "<this>");
        int start = Util.indexOfFirstNonAsciiWhitespace($this$trimSubstring, startIndex, endIndex);
        int end = Util.indexOfLastNonAsciiWhitespace($this$trimSubstring, start, endIndex);
        String string = $this$trimSubstring.substring(start, end);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public static /* synthetic */ String trimSubstring$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Util.trimSubstring(string, n, n2);
    }

    public static final int delimiterOffset(String $this$delimiterOffset, String delimiters, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter($this$delimiterOffset, "<this>");
        Intrinsics.checkNotNullParameter(delimiters, "delimiters");
        int n = startIndex;
        while (n < endIndex) {
            int i;
            if (!StringsKt.contains$default((CharSequence)delimiters, $this$delimiterOffset.charAt(i = n++), false, 2, null)) continue;
            return i;
        }
        return endIndex;
    }

    public static final int delimiterOffset(String $this$delimiterOffset, char delimiter, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter($this$delimiterOffset, "<this>");
        int n = startIndex;
        while (n < endIndex) {
            int i;
            if ($this$delimiterOffset.charAt(i = n++) != delimiter) continue;
            return i;
        }
        return endIndex;
    }

    public static /* synthetic */ int delimiterOffset$default(String string, char c, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return Util.delimiterOffset(string, c, n, n2);
    }

    public static final int indexOfControlOrNonAscii(String $this$indexOfControlOrNonAscii) {
        Intrinsics.checkNotNullParameter($this$indexOfControlOrNonAscii, "<this>");
        int n = 0;
        int n2 = $this$indexOfControlOrNonAscii.length();
        while (n < n2) {
            int i;
            char c;
            if (Intrinsics.compare(c = $this$indexOfControlOrNonAscii.charAt(i = n++), 31) > 0 && Intrinsics.compare(c, 127) < 0) continue;
            return i;
        }
        return -1;
    }

    public static final boolean canParseAsIpAddress(String $this$canParseAsIpAddress) {
        Intrinsics.checkNotNullParameter($this$canParseAsIpAddress, "<this>");
        return VERIFY_AS_IP_ADDRESS.matches($this$canParseAsIpAddress);
    }

    public static final boolean isSensitiveHeader(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return StringsKt.equals(name, "Authorization", true) || StringsKt.equals(name, "Cookie", true) || StringsKt.equals(name, "Proxy-Authorization", true) || StringsKt.equals(name, "Set-Cookie", true);
    }

    public static final String format(String format, Object ... args) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(args, "args");
        Locale locale = Locale.US;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(locale, format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(locale, format, *args)");
        return string;
    }

    public static final int checkDuration(String name, long duration, TimeUnit unit) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (!(duration >= 0L)) {
            boolean $i$a$-check-Util$checkDuration$32 = false;
            String $i$a$-check-Util$checkDuration$32 = Intrinsics.stringPlus(name, " < 0");
            throw new IllegalStateException($i$a$-check-Util$checkDuration$32.toString());
        }
        if (!(unit != null)) {
            boolean bl = false;
            String string = "unit == null";
            throw new IllegalStateException(string.toString());
        }
        long millis = unit.toMillis(duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-Util$checkDuration$52 = false;
            String $i$a$-require-Util$checkDuration$52 = Intrinsics.stringPlus(name, " too large.");
            throw new IllegalArgumentException($i$a$-require-Util$checkDuration$52.toString());
        }
        if (!(millis != 0L || duration <= 0L)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus(name, " too small.");
            throw new IllegalArgumentException(string.toString());
        }
        return (int)millis;
    }

    public static final int parseHexDigit(char $this$parseHexDigit) {
        int n;
        block1: {
            char c;
            block0: {
                c = $this$parseHexDigit;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = $this$parseHexDigit - 48;
                break block1;
            }
            n = ('a' <= c ? c < 'g' : false) ? $this$parseHexDigit - 97 + 10 : (('A' <= c ? c < 'G' : false) ? $this$parseHexDigit - 65 + 10 : -1);
        }
        return n;
    }

    public static final Headers toHeaders(List<Header> $this$toHeaders) {
        Intrinsics.checkNotNullParameter($this$toHeaders, "<this>");
        Headers.Builder builder = new Headers.Builder();
        for (Header header : $this$toHeaders) {
            ByteString name = header.component1();
            ByteString value = header.component2();
            builder.addLenient$okhttp(name.utf8(), value.utf8());
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static final List<Header> toHeaderList(Headers $this$toHeaderList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHeaderList, "<this>");
        Iterable $this$map$iv = RangesKt.until(0, $this$toHeaderList.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Header($this$toHeaderList.name((int)it), $this$toHeaderList.value((int)it)));
        }
        return (List)destination$iv$iv;
    }

    public static final boolean canReuseConnectionFor(HttpUrl $this$canReuseConnectionFor, HttpUrl other) {
        Intrinsics.checkNotNullParameter($this$canReuseConnectionFor, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual($this$canReuseConnectionFor.host(), other.host()) && $this$canReuseConnectionFor.port() == other.port() && Intrinsics.areEqual($this$canReuseConnectionFor.scheme(), other.scheme());
    }

    public static final EventListener.Factory asFactory(EventListener $this$asFactory) {
        Intrinsics.checkNotNullParameter($this$asFactory, "<this>");
        return arg_0 -> Util.asFactory$lambda-8($this$asFactory, arg_0);
    }

    public static final int and(byte $this$and, int mask) {
        return $this$and & mask;
    }

    public static final int and(short $this$and, int mask) {
        return $this$and & mask;
    }

    public static final long and(int $this$and, long mask) {
        return (long)$this$and & mask;
    }

    public static final void writeMedium(BufferedSink $this$writeMedium, int medium) throws IOException {
        Intrinsics.checkNotNullParameter($this$writeMedium, "<this>");
        $this$writeMedium.writeByte(medium >>> 16 & 0xFF);
        $this$writeMedium.writeByte(medium >>> 8 & 0xFF);
        $this$writeMedium.writeByte(medium & 0xFF);
    }

    public static final int readMedium(BufferedSource $this$readMedium) throws IOException {
        Intrinsics.checkNotNullParameter($this$readMedium, "<this>");
        return Util.and($this$readMedium.readByte(), 255) << 16 | Util.and($this$readMedium.readByte(), 255) << 8 | Util.and($this$readMedium.readByte(), 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean skipAll(Source $this$skipAll, int duration, TimeUnit timeUnit) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$skipAll, "<this>");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        long nowNs = System.nanoTime();
        long originalDurationNs = $this$skipAll.timeout().hasDeadline() ? $this$skipAll.timeout().deadlineNanoTime() - nowNs : Long.MAX_VALUE;
        long l = timeUnit.toNanos(duration);
        $this$skipAll.timeout().deadlineNanoTime(nowNs + Math.min(originalDurationNs, l));
        try {
            Buffer skipBuffer = new Buffer();
            while ($this$skipAll.read(skipBuffer, 8192L) != -1L) {
                skipBuffer.clear();
            }
            bl = true;
        }
        catch (InterruptedIOException _) {
            bl = false;
        }
        finally {
            if (originalDurationNs == Long.MAX_VALUE) {
                $this$skipAll.timeout().clearDeadline();
            } else {
                $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
            }
        }
        return bl;
    }

    public static final boolean discard(Source $this$discard, int timeout2, TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$discard, "<this>");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        try {
            bl = Util.skipAll($this$discard, timeout2, timeUnit);
        }
        catch (IOException _) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isHealthy(Socket $this$isHealthy, BufferedSource source2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isHealthy, "<this>");
        Intrinsics.checkNotNullParameter(source2, "source");
        try {
            boolean bl2;
            int readTimeout = $this$isHealthy.getSoTimeout();
            try {
                $this$isHealthy.setSoTimeout(1);
                bl2 = !source2.exhausted();
            }
            finally {
                $this$isHealthy.setSoTimeout(readTimeout);
            }
            bl = bl2;
        }
        catch (SocketTimeoutException _) {
            bl = true;
        }
        catch (IOException _) {
            bl = false;
        }
        return bl;
    }

    public static final int skipAll(Buffer $this$skipAll, byte b) {
        Intrinsics.checkNotNullParameter($this$skipAll, "<this>");
        int count = 0;
        while (!$this$skipAll.exhausted() && $this$skipAll.getByte(0L) == b) {
            int n = count;
            count = n + 1;
            $this$skipAll.readByte();
        }
        return count;
    }

    public static final int indexOfNonWhitespace(String $this$indexOfNonWhitespace, int startIndex) {
        Intrinsics.checkNotNullParameter($this$indexOfNonWhitespace, "<this>");
        int n = startIndex;
        int n2 = $this$indexOfNonWhitespace.length();
        while (n < n2) {
            int i;
            char c;
            if ((c = $this$indexOfNonWhitespace.charAt(i = n++)) == ' ' || c == '\t') continue;
            return i;
        }
        return $this$indexOfNonWhitespace.length();
    }

    public static final long headersContentLength(Response $this$headersContentLength) {
        long l;
        Intrinsics.checkNotNullParameter($this$headersContentLength, "<this>");
        String string = $this$headersContentLength.headers().get("Content-Length");
        return string == null ? -1L : (l = Util.toLongOrDefault(string, -1L));
    }

    public static final long toLongOrDefault(String $this$toLongOrDefault, long defaultValue) {
        long l;
        Intrinsics.checkNotNullParameter($this$toLongOrDefault, "<this>");
        try {
            l = Long.parseLong($this$toLongOrDefault);
        }
        catch (NumberFormatException _) {
            l = defaultValue;
        }
        return l;
    }

    public static final int toNonNegativeInt(String $this$toNonNegativeInt, int defaultValue) {
        try {
            String string = $this$toNonNegativeInt;
            Long l = string == null ? null : Long.valueOf(Long.parseLong(string));
            if (l == null) {
                return defaultValue;
            }
            long value = l;
            return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (value < 0L ? 0 : (int)value);
        }
        catch (NumberFormatException _) {
            return defaultValue;
        }
    }

    public static final <T> List<T> toImmutableList(List<? extends T> $this$toImmutableList) {
        Intrinsics.checkNotNullParameter($this$toImmutableList, "<this>");
        List list = Collections.unmodifiableList(CollectionsKt.toMutableList((Collection)$this$toImmutableList));
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(toMutableList())");
        return list;
    }

    @SafeVarargs
    public static final <T> List<T> immutableListOf(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Object[] objectArray = (Object[])elements.clone();
        List<Object> list = Collections.unmodifiableList(CollectionsKt.listOf(Arrays.copyOf(objectArray, objectArray.length)));
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(listOf(*elements.clone()))");
        return list;
    }

    public static final <K, V> Map<K, V> toImmutableMap(Map<K, ? extends V> $this$toImmutableMap) {
        Map map2;
        Intrinsics.checkNotNullParameter($this$toImmutableMap, "<this>");
        if ($this$toImmutableMap.isEmpty()) {
            map2 = MapsKt.emptyMap();
        } else {
            Map map3 = Collections.unmodifiableMap((Map)new LinkedHashMap<K, V>($this$toImmutableMap));
            Intrinsics.checkNotNullExpressionValue(map3, "{\n    Collections.unmodi\u2026(LinkedHashMap(this))\n  }");
            map2 = map3;
        }
        return map2;
    }

    public static final void closeQuietly(Closeable $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (RuntimeException rethrown) {
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeQuietly(Socket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (RuntimeException rethrown) {
            if (Intrinsics.areEqual(rethrown.getMessage(), "bio == null")) {
                return;
            }
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    public static final boolean isCivilized(FileSystem $this$isCivilized, File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final String toHexString(long $this$toHexString) {
        String string = Long.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(this)");
        return string;
    }

    public static final String toHexString(int $this$toHexString) {
        String string = Integer.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(this)");
        return string;
    }

    public static final <E> void addIfAbsent(List<E> $this$addIfAbsent, E element) {
        Intrinsics.checkNotNullParameter($this$addIfAbsent, "<this>");
        if (!$this$addIfAbsent.contains(element)) {
            $this$addIfAbsent.add(element);
        }
    }

    public static final Throwable withSuppressed(Exception $this$withSuppressed, List<? extends Exception> suppressed) {
        Exception exception;
        Intrinsics.checkNotNullParameter($this$withSuppressed, "<this>");
        Intrinsics.checkNotNullParameter(suppressed, "suppressed");
        Exception $this$withSuppressed_u24lambda_u2d10 = exception = $this$withSuppressed;
        boolean bl = false;
        if (suppressed.size() > 1) {
            System.out.println(suppressed);
        }
        for (Exception exception2 : suppressed) {
            ExceptionsKt.addSuppressed($this$withSuppressed_u24lambda_u2d10, exception2);
        }
        return exception;
    }

    private static final Thread threadFactory$lambda-1(String $name, boolean $daemon, Runnable runnable2) {
        Thread thread;
        Intrinsics.checkNotNullParameter($name, "$name");
        Thread $this$threadFactory_u24lambda_u2d1_u24lambda_u2d0 = thread = new Thread(runnable2, $name);
        boolean bl = false;
        $this$threadFactory_u24lambda_u2d1_u24lambda_u2d0.setDaemon($daemon);
        return thread;
    }

    private static final EventListener asFactory$lambda-8(EventListener $this_asFactory, Call it) {
        Intrinsics.checkNotNullParameter($this_asFactory, "$this_asFactory");
        Intrinsics.checkNotNullParameter(it, "it");
        return $this_asFactory;
    }

    static {
        Object object = new ByteString[]{ByteString.Companion.decodeHex("efbbbf"), ByteString.Companion.decodeHex("feff"), ByteString.Companion.decodeHex("fffe"), ByteString.Companion.decodeHex("0000ffff"), ByteString.Companion.decodeHex("ffff0000")};
        UNICODE_BOMS = Options.Companion.of((ByteString)object);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNull(timeZone);
        UTC = timeZone;
        VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
        assertionsEnabled = OkHttpClient.class.desiredAssertionStatus();
        object = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(object, "OkHttpClient::class.java.name");
        okHttpName = StringsKt.removeSuffix(StringsKt.removePrefix((String)object, "okhttp3."), "Client");
    }
}

